/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2023-03-15 11:58:12 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text COLLATE utf8mb4_unicode_520_ci,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_submissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hash_id` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `main_meta_id` bigint(20) unsigned NOT NULL COMMENT 'Id of main field. to represent the main meta field',
  `post_id` bigint(20) unsigned NOT NULL,
  `referer` varchar(500) COLLATE utf8mb4_unicode_ci NOT NULL,
  `referer_title` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `element_id` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `form_name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `campaign_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip` varchar(46) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `actions_count` int(11) DEFAULT '0',
  `actions_succeeded_count` int(11) DEFAULT '0',
  `status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  `meta` text COLLATE utf8mb4_unicode_ci,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash_id_unique_index` (`hash_id`),
  KEY `main_meta_id_index` (`main_meta_id`),
  KEY `hash_id_index` (`hash_id`),
  KEY `type_index` (`type`),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `campaign_id_index` (`campaign_id`),
  KEY `user_id_index` (`user_id`),
  KEY `user_ip_index` (`user_ip`),
  KEY `status_index` (`status`),
  KEY `is_read_index` (`is_read`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `referer_index` (`referer`(191)),
  KEY `referer_title_index` (`referer_title`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_e_submissions_actions_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL,
  `action_name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action_label` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `log` text COLLATE utf8mb4_unicode_ci,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `action_name_index` (`action_name`),
  KEY `status_index` (`status`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_e_submissions_values` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `key` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `key_index` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_kelaket_lists` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `list_desc` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `films` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_private` tinyint(1) DEFAULT '0',
  `created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_kelaket_reqs` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` int(2) NOT NULL DEFAULT '1',
  `type` int(2) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `msg` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_kelaket_tickets` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `subject` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` int(2) NOT NULL DEFAULT '1',
  `department` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `created_at` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_kelaket_tickets_msg` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `ticket_id` bigint(20) NOT NULL,
  `msg` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `created_at` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `reply_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mclean_refs` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `mediaId` bigint(20) DEFAULT NULL,
  `mediaUrl` tinytext COLLATE utf8mb4_unicode_520_ci,
  `originType` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=83 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mclean_scan` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `type` tinyint(1) NOT NULL,
  `postId` bigint(20) DEFAULT NULL,
  `path` tinytext COLLATE utf8mb4_unicode_520_ci,
  `size` int(9) DEFAULT NULL,
  `ignored` tinyint(1) NOT NULL DEFAULT '0',
  `deleted` tinyint(1) NOT NULL DEFAULT '0',
  `issue` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IgnoredIndex` (`ignored`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_my_analysis` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `views` smallint(5) NOT NULL,
  `clicks` smallint(5) NOT NULL,
  `blog_id` smallint(5) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=28757 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_otptokens` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `mobile` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` int(6) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `is_expire` tinyint(1) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=115011 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=3513 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_rcp_customers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `date_registered` datetime NOT NULL,
  `email_verification` enum('verified','pending','none') COLLATE utf8mb4_unicode_ci DEFAULT 'none',
  `last_login` datetime DEFAULT NULL,
  `has_trialed` smallint(5) unsigned DEFAULT NULL,
  `ips` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `notes` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `uuid` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_rcp_discounts` (
  `id` bigint(9) NOT NULL AUTO_INCREMENT,
  `name` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `unit` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `use_count` mediumint(9) NOT NULL DEFAULT '0',
  `max_uses` mediumint(9) NOT NULL DEFAULT '0',
  `status` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` datetime DEFAULT NULL,
  `membership_level_ids` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `one_time` smallint(6) NOT NULL DEFAULT '0',
  `date_created` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  `uuid` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_rcp_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `object_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `object_id` bigint(20) unsigned DEFAULT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_error` tinyint(1) NOT NULL DEFAULT '0',
  `date_created` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  `uuid` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `object_id_object_type` (`object_id`,`object_type`),
  KEY `user_id` (`user_id`),
  KEY `type` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_rcp_membership_counts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `level_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `active_count` bigint(20) unsigned NOT NULL DEFAULT '0',
  `pending_count` bigint(20) unsigned NOT NULL DEFAULT '0',
  `cancelled_count` bigint(20) unsigned NOT NULL DEFAULT '0',
  `expired_count` bigint(20) unsigned NOT NULL DEFAULT '0',
  `date_created` datetime NOT NULL,
  `uuid` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB AUTO_INCREMENT=956 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_rcp_membershipmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rcp_membership_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `rcp_membership_id` (`rcp_membership_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_rcp_memberships` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `object_id` bigint(9) NOT NULL DEFAULT '0',
  `object_type` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `currency` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'USD',
  `initial_amount` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `recurring_amount` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_date` datetime NOT NULL,
  `activated_date` datetime DEFAULT NULL,
  `trial_end_date` datetime DEFAULT NULL,
  `renewed_date` datetime DEFAULT NULL,
  `cancellation_date` datetime DEFAULT NULL,
  `expiration_date` datetime DEFAULT NULL,
  `payment_plan_completed_date` datetime DEFAULT NULL,
  `auto_renew` smallint(5) unsigned NOT NULL DEFAULT '0',
  `times_billed` smallint(5) unsigned NOT NULL DEFAULT '0',
  `maximum_renewals` smallint(5) unsigned NOT NULL DEFAULT '0',
  `status` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `gateway_customer_id` tinytext COLLATE utf8mb4_unicode_ci,
  `gateway_subscription_id` tinytext COLLATE utf8mb4_unicode_ci,
  `gateway` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `signup_method` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `subscription_key` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `notes` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `upgraded_from` bigint(20) unsigned DEFAULT NULL,
  `date_modified` datetime NOT NULL,
  `disabled` smallint(5) unsigned DEFAULT NULL,
  `uuid` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `object_id` (`object_id`),
  KEY `status` (`status`),
  KEY `disabled` (`disabled`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_rcp_payment_meta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `rcp_payment_id` bigint(20) NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `rcp_payment_id` (`rcp_payment_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_rcp_payments` (
  `id` bigint(9) unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint(20) unsigned NOT NULL,
  `membership_id` bigint(20) unsigned NOT NULL,
  `subscription` varchar(200) NOT NULL,
  `object_id` bigint(9) unsigned NOT NULL,
  `object_type` varchar(20) NOT NULL DEFAULT 'subscription',
  `date` datetime NOT NULL,
  `amount` mediumtext NOT NULL,
  `subtotal` mediumtext NOT NULL,
  `credits` mediumtext NOT NULL,
  `fees` mediumtext NOT NULL,
  `discount_amount` mediumtext NOT NULL,
  `discount_code` tinytext NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `payment_type` tinytext NOT NULL,
  `transaction_type` varchar(12) NOT NULL,
  `subscription_key` varchar(32) NOT NULL,
  `transaction_id` varchar(64) NOT NULL,
  `status` varchar(12) NOT NULL,
  `gateway` tinytext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `subscription` (`subscription`),
  KEY `customer_id` (`customer_id`),
  KEY `membership_id` (`membership_id`),
  KEY `user_id` (`user_id`),
  KEY `transaction_type` (`transaction_type`),
  KEY `subscription_key` (`subscription_key`),
  KEY `transaction_id` (`transaction_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_rcp_queue` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `callback` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `total_count` bigint(20) unsigned NOT NULL DEFAULT '0',
  `current_count` bigint(20) unsigned NOT NULL DEFAULT '0',
  `step` bigint(20) unsigned NOT NULL DEFAULT '0',
  `status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'incomplete',
  `data` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_created` datetime NOT NULL,
  `date_completed` datetime DEFAULT NULL,
  `uuid` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name_queue` (`name`,`queue`),
  KEY `queue` (`queue`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_rcp_subscription_level_meta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `level_id` bigint(20) NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `level_id` (`level_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_relevanssi` (
  `doc` bigint(20) NOT NULL DEFAULT '0',
  `term` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '0',
  `term_reverse` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '0',
  `content` mediumint(9) NOT NULL DEFAULT '0',
  `title` mediumint(9) NOT NULL DEFAULT '0',
  `comment` mediumint(9) NOT NULL DEFAULT '0',
  `tag` mediumint(9) NOT NULL DEFAULT '0',
  `link` mediumint(9) NOT NULL DEFAULT '0',
  `author` mediumint(9) NOT NULL DEFAULT '0',
  `category` mediumint(9) NOT NULL DEFAULT '0',
  `excerpt` mediumint(9) NOT NULL DEFAULT '0',
  `taxonomy` mediumint(9) NOT NULL DEFAULT '0',
  `customfield` mediumint(9) NOT NULL DEFAULT '0',
  `mysqlcolumn` mediumint(9) NOT NULL DEFAULT '0',
  `taxonomy_detail` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `customfield_detail` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `mysqlcolumn_detail` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(210) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `item` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`doc`,`term`,`item`),
  KEY `terms` (`term`(20)),
  KEY `relevanssi_term_reverse_idx` (`term_reverse`(10)),
  KEY `typeitem` (`type`(190),`item`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_relevanssi_log` (
  `id` bigint(9) NOT NULL AUTO_INCREMENT,
  `query` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hits` mediumint(9) NOT NULL DEFAULT '0',
  `time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `user_id` bigint(20) NOT NULL DEFAULT '0',
  `ip` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `query` (`query`(190))
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_relevanssi_stopwords` (
  `stopword` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  PRIMARY KEY (`stopword`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_restrict_content_pro` (
  `id` bigint(9) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `duration` smallint(5) unsigned NOT NULL DEFAULT '0',
  `duration_unit` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `trial_duration` smallint(6) unsigned NOT NULL DEFAULT '0',
  `trial_duration_unit` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `price` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `fee` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `maximum_renewals` smallint(5) unsigned NOT NULL DEFAULT '0',
  `after_final_payment` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `level` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `role` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `list_order` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `date_created` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  `uuid` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `name` (`name`(191)),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_stats` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=2255 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3705 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2255 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_tm_taskmeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `task_id` bigint(20) NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `task_id` (`task_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_tm_tasks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `type` varchar(300) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `class_identifier` varchar(300) COLLATE utf8mb4_unicode_520_ci DEFAULT '0',
  `attempts` int(11) DEFAULT '0',
  `description` varchar(300) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `time_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `last_locked_at` bigint(20) DEFAULT '0',
  `status` varchar(300) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=856 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_commentmeta */
INSERT INTO `wp_commentmeta` VALUES("1", "1", "spoiler", "0");
INSERT INTO `wp_commentmeta` VALUES("2", "1", "_spoiler", "field_61d33c2e0f968");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("1", "3079", "یونیک تم", "test@gmail.com", "", "::1", "2023-03-06 14:55:07", "2023-03-06 11:25:07", "تست", "0", "1", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/110.0.0.0 Safari/537.36", "comment", "0", "1");
INSERT INTO `wp_comments` VALUES("2", "825", "یونیک تم", "test@gmail.com", "", "::1", "2023-03-13 16:32:12", "2023-03-13 13:02:12", "jsj", "0", "1", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "comment", "0", "1");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("17", "20220508_daa9d984d8a7daa9d8aad981db8cd9", "3566468850690bed6781_20230315115623", "21", "2023-03-15 11:58:12", "imahmoodzz", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-03-15 11:56:23\";s:7:\"Version\";s:7:\"1.5.2.1\";s:9:\"VersionWP\";s:5:\"6.1.1\";s:9:\"VersionDB\";s:6:\"5.7.34\";s:10:\"VersionPHP\";s:6:\"7.4.21\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";i:17;s:4:\"Name\";s:39:\"20220508_daa9d984d8a7daa9d8aad981db8cd9\";s:4:\"Hash\";s:35:\"3566468850690bed6781_20230315115623\";s:8:\"NameHash\";s:75:\"20220508_daa9d984d8a7daa9d8aad981db8cd9_3566468850690bed6781_20230315115623\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:85:\"20220508_daa9d984d8a7daa9d8aad981db8cd9_3566468850690bed6781_20230315115623_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"20.5\";s:6:\"WPUser\";s:10:\"imahmoodzz\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:87:\"20220508_daa9d984d8a7daa9d8aad981db8cd9_3566468850690bed6781_20230315115623_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:35:\"/Users/imahmoodzz/Sites/Kelaketfilm\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:801;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:7985;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-03-15 11:56:23\";s:7:\"Version\";s:7:\"1.5.2.1\";s:9:\"VersionWP\";s:5:\"6.1.1\";s:9:\"VersionDB\";s:6:\"5.7.34\";s:10:\"VersionPHP\";s:6:\"7.4.21\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";N;s:4:\"Name\";s:39:\"20220508_daa9d984d8a7daa9d8aad981db8cd9\";s:4:\"Hash\";s:35:\"3566468850690bed6781_20230315115623\";s:8:\"NameHash\";s:75:\"20220508_daa9d984d8a7daa9d8aad981db8cd9_3566468850690bed6781_20230315115623\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:93:\"20220508_daa9d984d8a7daa9d8aad981db8cd9_3566468850690bed6781_20230315115623_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:49:\"/Users/imahmoodzz/Sites/Kelaketfilm/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:88:\"20220508_daa9d984d8a7daa9d8aad981db8cd9_3566468850690bed6781_20230315115623_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:18:\"varLowerCaseTables\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:156:\"/Users/imahmoodzz/Sites/Kelaketfilm/wp-content/backups-dup-lite/tmp/20220508_daa9d984d8a7daa9d8aad981db8cd9_3566468850690bed6781_20230315115623_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:44:\"/Users/imahmoodzz/Sites/Kelaketfilm/wp-admin\";i:1;s:47:\"/Users/imahmoodzz/Sites/Kelaketfilm/wp-includes\";i:2;s:56:\"/Users/imahmoodzz/Sites/Kelaketfilm/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:35:\"/Users/imahmoodzz/Sites/Kelaketfilm\";i:1;s:35:\"/Users/imahmoodzz/Sites/Kelaketfilm\";i:2;s:46:\"/Users/imahmoodzz/Sites/Kelaketfilm/wp-content\";i:3;s:54:\"/Users/imahmoodzz/Sites/Kelaketfilm/wp-content/uploads\";i:4;s:54:\"/Users/imahmoodzz/Sites/Kelaketfilm/wp-content/plugins\";i:5;s:57:\"/Users/imahmoodzz/Sites/Kelaketfilm/wp-content/mu-plugins\";i:6;s:53:\"/Users/imahmoodzz/Sites/Kelaketfilm/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:67:\"/Users/imahmoodzz/Sites/Kelaketfilm/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_kelaket_lists */
INSERT INTO `wp_kelaket_lists` VALUES("1", "لیست تستی", "توضیحات تست", "1", "2672,2163,2729,3079,2676,2156,2960", "0", "2022-07-29 02:03:24", "2022-12-23 14:43:54");
INSERT INTO `wp_kelaket_lists` VALUES("2", "لیست بهترین فیلم ها", "بهترین فیلم های من", "1", "2700", "0", "2022-09-22 17:59:55", "2023-01-31 14:27:24");
INSERT INTO `wp_kelaket_lists` VALUES("3", "fsdfsdfsf", "fssfsfsf", "1", "", "0", "2023-03-01 15:02:30", "0000-00-00 00:00:00");
INSERT INTO `wp_kelaket_lists` VALUES("4", "شسزسببیسیبس", "یبسیسبسیسیب", "1", "2883,2156", "0", "2023-03-12 15:44:35", "2023-03-12 15:52:11");

/* INSERT TABLE DATA: wp_kelaket_reqs */
INSERT INTO `wp_kelaket_reqs` VALUES("4", "بتمن", "2", "1", "1", "اضافه شد", "2022-07-25 14:33:42");
INSERT INTO `wp_kelaket_reqs` VALUES("10", "jsj", "3", "1", "1", "", "2022-07-25 14:41:51");
INSERT INTO `wp_kelaket_reqs` VALUES("12", "dsfsdfsfdsdfsfds", "3", "1", "1", "", "2022-07-25 14:41:59");

/* INSERT TABLE DATA: wp_mclean_refs */
INSERT INTO `wp_mclean_refs` VALUES("1", "820", NULL, "META (ID)");
INSERT INTO `wp_mclean_refs` VALUES("2", "821", NULL, "META (ID)");
INSERT INTO `wp_mclean_refs` VALUES("3", "758", NULL, "META (ID)");
INSERT INTO `wp_mclean_refs` VALUES("4", "826", NULL, "META (ID)");
INSERT INTO `wp_mclean_refs` VALUES("5", NULL, "2021/12/PINK.jpg", "CONTENT #1244 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("6", NULL, "2021/12/action.jpg", "CONTENT #1244 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("7", NULL, "2021/12/dram.jpg", "CONTENT #1244 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("8", NULL, "2021/12/irani.jpg", "CONTENT #1244 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("9", NULL, "2021/12/comedy.jpg", "CONTENT #1244 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("10", NULL, "2021/12/explore.jpg", "CONTENT #1244 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("11", NULL, "2021/12/social.jpg", "CONTENT #1244 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("12", NULL, "2022/07/MV5BYTg2Zjk0ZTctM2ZmMi00MDRmLWJjOGYtNWM0YjBmZTBjMjRkXkEyXkFqcGdeQXVyMTM1MTE1NDMx._V1_SX600-218x306.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("13", NULL, "2022/07/MV5BYTg2Zjk0ZTctM2ZmMi00MDRmLWJjOGYtNWM0YjBmZTBjMjRkXkEyXkFqcGdeQXVyMTM1MTE1NDMx._V1_SX600.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("14", NULL, "2022/07/MV5BYTg2Zjk0ZTctM2ZmMi00MDRmLWJjOGYtNWM0YjBmZTBjMjRkXkEyXkFqcGdeQXVyMTM1MTE1NDMx._V1_SX600-246x344.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("15", NULL, "2022/07/MV5BYTg2Zjk0ZTctM2ZmMi00MDRmLWJjOGYtNWM0YjBmZTBjMjRkXkEyXkFqcGdeQXVyMTM1MTE1NDMx._V1_SX600-223x313.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("16", NULL, "2022/07/MV5BYTg2Zjk0ZTctM2ZmMi00MDRmLWJjOGYtNWM0YjBmZTBjMjRkXkEyXkFqcGdeQXVyMTM1MTE1NDMx._V1_SX600-196x274.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("17", NULL, "2022/07/MV5BMmIwYzFhODAtY2I1YS00ZDdmLTkyYWQtZjI5NDIwMDc2MjEyXkEyXkFqcGdeQXVyODk4OTc3MTY@._V1_SX600-218x306.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("18", NULL, "2022/07/MV5BMmIwYzFhODAtY2I1YS00ZDdmLTkyYWQtZjI5NDIwMDc2MjEyXkEyXkFqcGdeQXVyODk4OTc3MTY@._V1_SX600.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("19", NULL, "2022/07/MV5BMmIwYzFhODAtY2I1YS00ZDdmLTkyYWQtZjI5NDIwMDc2MjEyXkEyXkFqcGdeQXVyODk4OTc3MTY@._V1_SX600-246x344.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("20", NULL, "2022/07/MV5BMmIwYzFhODAtY2I1YS00ZDdmLTkyYWQtZjI5NDIwMDc2MjEyXkEyXkFqcGdeQXVyODk4OTc3MTY@._V1_SX600-223x313.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("21", NULL, "2022/07/MV5BMmIwYzFhODAtY2I1YS00ZDdmLTkyYWQtZjI5NDIwMDc2MjEyXkEyXkFqcGdeQXVyODk4OTc3MTY@._V1_SX600-196x274.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("22", NULL, "2022/07/MV5BODkyYTRlMDItMDlhMC00MzkzLWI3NzQtOGVlMjdjYThlNDM3XkEyXkFqcGdeQXVyMTA1OTcyNDQ4._V1_SX600-218x306.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("23", NULL, "2022/07/MV5BODkyYTRlMDItMDlhMC00MzkzLWI3NzQtOGVlMjdjYThlNDM3XkEyXkFqcGdeQXVyMTA1OTcyNDQ4._V1_SX600.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("24", NULL, "2022/07/MV5BODkyYTRlMDItMDlhMC00MzkzLWI3NzQtOGVlMjdjYThlNDM3XkEyXkFqcGdeQXVyMTA1OTcyNDQ4._V1_SX600-246x344.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("25", NULL, "2022/07/MV5BODkyYTRlMDItMDlhMC00MzkzLWI3NzQtOGVlMjdjYThlNDM3XkEyXkFqcGdeQXVyMTA1OTcyNDQ4._V1_SX600-223x313.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("26", NULL, "2022/07/MV5BODkyYTRlMDItMDlhMC00MzkzLWI3NzQtOGVlMjdjYThlNDM3XkEyXkFqcGdeQXVyMTA1OTcyNDQ4._V1_SX600-196x274.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("27", NULL, "2022/07/MV5BZGNjYjQ3NjgtZWM0NS00MTY5LTlkZWMtODZlNzhkNTU3MzZiXkEyXkFqcGdeQXVyMjM2OTI3Mzk@._V1_SX600-218x306.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("28", NULL, "2022/07/MV5BZGNjYjQ3NjgtZWM0NS00MTY5LTlkZWMtODZlNzhkNTU3MzZiXkEyXkFqcGdeQXVyMjM2OTI3Mzk@._V1_SX600.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("29", NULL, "2022/07/MV5BZGNjYjQ3NjgtZWM0NS00MTY5LTlkZWMtODZlNzhkNTU3MzZiXkEyXkFqcGdeQXVyMjM2OTI3Mzk@._V1_SX600-246x344.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("30", NULL, "2022/07/MV5BZGNjYjQ3NjgtZWM0NS00MTY5LTlkZWMtODZlNzhkNTU3MzZiXkEyXkFqcGdeQXVyMjM2OTI3Mzk@._V1_SX600-223x313.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("31", NULL, "2022/07/MV5BZGNjYjQ3NjgtZWM0NS00MTY5LTlkZWMtODZlNzhkNTU3MzZiXkEyXkFqcGdeQXVyMjM2OTI3Mzk@._V1_SX600-196x274.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("32", NULL, "2022/07/MV5BY2ExOTZiMzctNTIyZC00YzkzLTgxMGQtMDViYjk5ODViMTM5XkEyXkFqcGdeQXVyMTE5MDA2NjA3._V1_SX600-218x306.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("33", NULL, "2022/07/MV5BY2ExOTZiMzctNTIyZC00YzkzLTgxMGQtMDViYjk5ODViMTM5XkEyXkFqcGdeQXVyMTE5MDA2NjA3._V1_SX600.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("34", NULL, "2022/07/MV5BY2ExOTZiMzctNTIyZC00YzkzLTgxMGQtMDViYjk5ODViMTM5XkEyXkFqcGdeQXVyMTE5MDA2NjA3._V1_SX600-246x344.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("35", NULL, "2022/07/MV5BY2ExOTZiMzctNTIyZC00YzkzLTgxMGQtMDViYjk5ODViMTM5XkEyXkFqcGdeQXVyMTE5MDA2NjA3._V1_SX600-223x313.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("36", NULL, "2022/07/MV5BY2ExOTZiMzctNTIyZC00YzkzLTgxMGQtMDViYjk5ODViMTM5XkEyXkFqcGdeQXVyMTE5MDA2NjA3._V1_SX600-196x274.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("37", NULL, "2022/07/MV5BZGQ2YmMxZmEtYjI5OS00NzlkLTlkNTEtYWMyMzkyMzc2MDU5XkEyXkFqcGdeQXVyMzQ2MDI5NjU@._V1_SX600-196x274.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("38", NULL, "2022/07/MV5BZGQ2YmMxZmEtYjI5OS00NzlkLTlkNTEtYWMyMzkyMzc2MDU5XkEyXkFqcGdeQXVyMzQ2MDI5NjU@._V1_SX600.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("39", NULL, "2022/07/MV5BZGQ2YmMxZmEtYjI5OS00NzlkLTlkNTEtYWMyMzkyMzc2MDU5XkEyXkFqcGdeQXVyMzQ2MDI5NjU@._V1_SX600-246x344.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("40", NULL, "2022/07/MV5BZGQ2YmMxZmEtYjI5OS00NzlkLTlkNTEtYWMyMzkyMzc2MDU5XkEyXkFqcGdeQXVyMzQ2MDI5NjU@._V1_SX600-218x306.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("41", NULL, "2022/07/MV5BZGQ2YmMxZmEtYjI5OS00NzlkLTlkNTEtYWMyMzkyMzc2MDU5XkEyXkFqcGdeQXVyMzQ2MDI5NjU@._V1_SX600-223x313.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("42", NULL, "2022/07/MV5BODFhZjAwNjEtZDFjNi00ZTEyLThkNzUtMjZmOWM2YjQwODFmXkEyXkFqcGdeQXVyMjQwMDg0Ng@@._V1_SX600-196x274.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("43", NULL, "2022/07/MV5BODFhZjAwNjEtZDFjNi00ZTEyLThkNzUtMjZmOWM2YjQwODFmXkEyXkFqcGdeQXVyMjQwMDg0Ng@@._V1_SX600.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("44", NULL, "2022/07/MV5BODFhZjAwNjEtZDFjNi00ZTEyLThkNzUtMjZmOWM2YjQwODFmXkEyXkFqcGdeQXVyMjQwMDg0Ng@@._V1_SX600-246x344.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("45", NULL, "2022/07/MV5BODFhZjAwNjEtZDFjNi00ZTEyLThkNzUtMjZmOWM2YjQwODFmXkEyXkFqcGdeQXVyMjQwMDg0Ng@@._V1_SX600-218x306.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("46", NULL, "2022/07/MV5BODFhZjAwNjEtZDFjNi00ZTEyLThkNzUtMjZmOWM2YjQwODFmXkEyXkFqcGdeQXVyMjQwMDg0Ng@@._V1_SX600-223x313.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("47", NULL, "2022/07/MV5BZWYxODViMGYtMGE2ZC00ZGQ3LThhMWUtYTVkNGE3OWU4NWRkL2ltYWdlL2ltYWdlXkEyXkFqcGdeQXVyMjYwNDA2MDE@._V1_SX600-196x274.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("48", NULL, "2022/07/MV5BZWYxODViMGYtMGE2ZC00ZGQ3LThhMWUtYTVkNGE3OWU4NWRkL2ltYWdlL2ltYWdlXkEyXkFqcGdeQXVyMjYwNDA2MDE@._V1_SX600.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("49", NULL, "2022/07/MV5BZWYxODViMGYtMGE2ZC00ZGQ3LThhMWUtYTVkNGE3OWU4NWRkL2ltYWdlL2ltYWdlXkEyXkFqcGdeQXVyMjYwNDA2MDE@._V1_SX600-246x344.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("50", NULL, "2022/07/MV5BZWYxODViMGYtMGE2ZC00ZGQ3LThhMWUtYTVkNGE3OWU4NWRkL2ltYWdlL2ltYWdlXkEyXkFqcGdeQXVyMjYwNDA2MDE@._V1_SX600-218x306.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("51", NULL, "2022/07/MV5BZWYxODViMGYtMGE2ZC00ZGQ3LThhMWUtYTVkNGE3OWU4NWRkL2ltYWdlL2ltYWdlXkEyXkFqcGdeQXVyMjYwNDA2MDE@._V1_SX600-223x313.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("52", NULL, "2022/07/MV5BMWMwMGQzZTItY2JlNC00OWZiLWIyMDctNDk2ZDQ2YjRjMWQ0XkEyXkFqcGdeQXVyNzkwMjQ5NzM@._V1_SX600-196x274.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("53", NULL, "2022/07/MV5BMWMwMGQzZTItY2JlNC00OWZiLWIyMDctNDk2ZDQ2YjRjMWQ0XkEyXkFqcGdeQXVyNzkwMjQ5NzM@._V1_SX600.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("54", NULL, "2022/07/MV5BMWMwMGQzZTItY2JlNC00OWZiLWIyMDctNDk2ZDQ2YjRjMWQ0XkEyXkFqcGdeQXVyNzkwMjQ5NzM@._V1_SX600-246x344.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("55", NULL, "2022/07/MV5BMWMwMGQzZTItY2JlNC00OWZiLWIyMDctNDk2ZDQ2YjRjMWQ0XkEyXkFqcGdeQXVyNzkwMjQ5NzM@._V1_SX600-218x306.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("56", NULL, "2022/07/MV5BMWMwMGQzZTItY2JlNC00OWZiLWIyMDctNDk2ZDQ2YjRjMWQ0XkEyXkFqcGdeQXVyNzkwMjQ5NzM@._V1_SX600-223x313.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("57", NULL, "2022/07/MV5BMTMxNTMwODM0NF5BMl5BanBnXkFtZTcwODAyMTk2Mw@@._V1_SX600-196x274.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("58", NULL, "2022/07/MV5BMTMxNTMwODM0NF5BMl5BanBnXkFtZTcwODAyMTk2Mw@@._V1_SX600.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("59", NULL, "2022/07/MV5BMTMxNTMwODM0NF5BMl5BanBnXkFtZTcwODAyMTk2Mw@@._V1_SX600-246x344.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("60", NULL, "2022/07/MV5BMTMxNTMwODM0NF5BMl5BanBnXkFtZTcwODAyMTk2Mw@@._V1_SX600-218x306.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("61", NULL, "2022/07/MV5BMTMxNTMwODM0NF5BMl5BanBnXkFtZTcwODAyMTk2Mw@@._V1_SX600-223x313.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("62", NULL, "2021/12/social.jpg", "CONTENT #1058 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("63", NULL, "2021/12/PINK.jpg", "CONTENT #1160 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("64", NULL, "2021/12/action.jpg", "CONTENT #1160 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("65", NULL, "2021/12/dram.jpg", "CONTENT #1160 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("66", NULL, "2021/12/irani.jpg", "CONTENT #1160 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("67", NULL, "2021/12/comedy.jpg", "CONTENT #1160 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("68", NULL, "2021/12/explore.jpg", "CONTENT #1160 (URL)");
INSERT INTO `wp_mclean_refs` VALUES("69", "2157", NULL, "META (ID)");
INSERT INTO `wp_mclean_refs` VALUES("70", "2164", NULL, "META (ID)");
INSERT INTO `wp_mclean_refs` VALUES("71", "2656", NULL, "META (ID)");
INSERT INTO `wp_mclean_refs` VALUES("72", "2658", NULL, "META (ID)");
INSERT INTO `wp_mclean_refs` VALUES("73", "2661", NULL, "META (ID)");
INSERT INTO `wp_mclean_refs` VALUES("74", "2666", NULL, "META (ID)");
INSERT INTO `wp_mclean_refs` VALUES("75", "2670", NULL, "META (ID)");
INSERT INTO `wp_mclean_refs` VALUES("76", "2673", NULL, "META (ID)");
INSERT INTO `wp_mclean_refs` VALUES("77", "2709", NULL, "META (ID)");
INSERT INTO `wp_mclean_refs` VALUES("78", "2707", NULL, "META (ID)");
INSERT INTO `wp_mclean_refs` VALUES("79", "2705", NULL, "META (ID)");
INSERT INTO `wp_mclean_refs` VALUES("80", "2701", NULL, "META (ID)");
INSERT INTO `wp_mclean_refs` VALUES("81", "554", NULL, "META (ID)");
INSERT INTO `wp_mclean_refs` VALUES("82", "556", NULL, "META (ID)");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "https://kelaketfilm.dev", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "https://kelaketfilm.dev", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "کلاکت فیلم", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "یک سایت دیگر با وردپرس فارسی", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "1", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "admin@gmail.com", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "6", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "6", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "j F Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%post_id%/%postname%", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:12:{i:0;s:29:\"RTL-CareUnit/RTL-CareUnit.php\";i:1;s:34:\"advanced-custom-fields-pro/acf.php\";i:2;s:33:\"classic-editor/classic-editor.php\";i:3;s:35:\"classic-widgets/classic-widgets.php\";i:4;s:36:\"contact-form-7/wp-contact-form-7.php\";i:5;s:25:\"duplicator/duplicator.php\";i:7;s:28:\"kelaketfilm-jwt/jwt-auth.php\";i:8;s:35:\"kelaketfilm-otp/kelaketfilm-otp.php\";i:9;s:25:\"relevanssi/relevanssi.php\";i:10;s:45:\"restrict-content-pro/restrict-content-pro.php\";i:11;s:41:\"wordpress-importer/wordpress-importer.php\";i:12;s:29:\"wp-parsidate/wp-parsidate.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "1", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "a:5:{i:0;s:89:\"/Users/imahmoodzz/Sites/Kelaketfilm/wp-content/plugins/advanced-custom-fields-pro/acf.php\";i:2;s:101:\"/Users/imahmoodzz/Sites/Kelaketfilm/wp-content/themes/KelaketFilm/inc/template_parts/posts/namava.php\";i:3;s:75:\"/Users/imahmoodzz/Sites/Kelaketfilm/wp-content/themes/KelaketFilm/style.css\";i:4;s:90:\"/Users/imahmoodzz/Sites/Kelaketfilm/wp-content/plugins/kelaketfilm-otp/kelaketfilm-otp.php\";i:5;s:81:\"/Users/imahmoodzz/Sites/Kelaketfilm/wp-content/themes/KelaketFilm-Anime/style.css\";}", "no");
INSERT INTO `wp_options` VALUES("40", "template", "KelaketFilm", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "KelaketFilm", "yes");
INSERT INTO `wp_options` VALUES("42", "comment_registration", "", "yes");
INSERT INTO `wp_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("45", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("46", "db_version", "53496", "yes");
INSERT INTO `wp_options` VALUES("47", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("48", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("49", "blog_public", "1", "yes");
INSERT INTO `wp_options` VALUES("50", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("51", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("53", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("56", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("59", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("60", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("61", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("62", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("63", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("64", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("67", "close_comments_for_old_posts", "", "yes");
INSERT INTO `wp_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("69", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("70", "thread_comments_depth", "3", "yes");
INSERT INTO `wp_options` VALUES("71", "page_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("72", "comments_per_page", "20", "yes");
INSERT INTO `wp_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("74", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("76", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("77", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "uninstall_plugins", "a:4:{s:39:\"acf-better-search/acf-better-search.php\";a:2:{i:0;s:31:\"AcfBetterSearch\\Admin\\Uninstall\";i:1;s:22:\"remove_plugin_settings\";}s:35:\"mihanpanel-lite/rename-wp-login.php\";a:2:{i:0;s:15:\"Rename_WP_Login\";i:1;s:9:\"uninstall\";}s:27:\"wp-optimize/wp-optimize.php\";s:21:\"wpo_uninstall_actions\";s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}}", "no");
INSERT INTO `wp_options` VALUES("80", "timezone_string", "Asia/Tehran", "yes");
INSERT INTO `wp_options` VALUES("81", "page_for_posts", "3502", "yes");
INSERT INTO `wp_options` VALUES("82", "page_on_front", "0", "yes");
INSERT INTO `wp_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("86", "site_icon", "0", "yes");
INSERT INTO `wp_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `wp_options` VALUES("90", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wp_options` VALUES("91", "admin_email_lifespan", "1685964283", "yes");
INSERT INTO `wp_options` VALUES("92", "disallowed_keys", "", "no");
INSERT INTO `wp_options` VALUES("93", "comment_previously_approved", "1", "yes");
INSERT INTO `wp_options` VALUES("94", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("95", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_major", "enabled", "yes");
INSERT INTO `wp_options` VALUES("98", "wp_force_deactivated_plugins", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("99", "initial_db_version", "49752", "yes");
INSERT INTO `wp_options` VALUES("100", "wp_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:72:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:16:\"rcp_view_members\";b:1;s:18:\"rcp_manage_members\";b:1;s:15:\"rcp_view_levels\";b:1;s:17:\"rcp_manage_levels\";b:1;s:18:\"rcp_view_discounts\";b:1;s:20:\"rcp_manage_discounts\";b:1;s:17:\"rcp_view_payments\";b:1;s:19:\"rcp_manage_payments\";b:1;s:19:\"rcp_manage_settings\";b:1;s:15:\"rcp_export_data\";b:1;s:13:\"rcp_view_help\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:1:{s:7:\"level_0\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("101", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("102", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("103", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("104", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("105", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("106", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("107", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("108", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("109", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("110", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("111", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("112", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("113", "widget_block", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("114", "cron", "a:18:{i:1678882284;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1678887568;a:1:{s:31:\"wpseo_permalink_structure_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1678893126;a:2:{s:23:\"rcp_expired_users_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:29:\"rcp_send_expiring_soon_notice\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1678906366;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1678910102;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1678910176;a:2:{s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:29:\"puc_cron_check_updates-digits\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1678910177;a:3:{s:15:\"dig_pcd_act_chk\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:23:\"rcp_check_member_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:27:\"rcp_mark_abandoned_payments\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1678915637;a:1:{s:28:\"dbmovies_clean_cache_expires\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1678915638;a:2:{s:27:\"dooplay_clean_cache_expires\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:20:\"google_drive_expired\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1678916506;a:1:{s:18:\"wp_https_detection\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1678916507;a:4:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1678916559;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1678921078;a:1:{s:13:\"wpseo-reindex\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1678992865;a:1:{s:16:\"wpseo_ryte_fetch\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1679063012;a:1:{s:24:\"relevanssi_update_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1679082393;a:1:{s:21:\"wpo_weekly_cron_tasks\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1679262106;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("116", "recovery_keys", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("117", "theme_mods_twentytwentyone", "a:3:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1640007136;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:9:\"sidebar-1\";a:0:{}}}s:18:\"nav_menu_locations\";a:2:{s:7:\"primary\";i:3;s:6:\"footer\";i:4;}}", "yes");
INSERT INTO `wp_options` VALUES("118", "https_detection_errors", "a:1:{s:23:\"ssl_verification_failed\";a:1:{i:0;s:35:\"تأیید SSL ناموفق بود.\";}}", "yes");
INSERT INTO `wp_options` VALUES("122", "fresh_site", "0", "yes");
INSERT INTO `wp_options` VALUES("123", "WPLANG", "fa_IR", "yes");
INSERT INTO `wp_options` VALUES("128", "sidebars_widgets", "a:6:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:7:{i:0;s:19:\"csf_widget_filter-3\";i:1;s:27:\"csf_widget_updated_series-2\";i:2;s:29:\"csf_widget_tabbed_genre_new-2\";i:3;s:21:\"csf_widget_text_ads-2\";i:4;s:26:\"csf_widget_latest_visits-2\";i:5;s:24:\"csf_widget_post_slider-2\";i:6;s:30:\"csf_widget_250top_films_imdb-2\";}s:9:\"sidebar-2\";a:0:{}s:6:\"single\";a:2:{i:0;s:25:\"csf_widget_tabbed_genre-3\";i:1;s:26:\"csf_widget_latest_visits-3\";}s:13:\"footer_widget\";a:1:{i:0;s:31:\"csf_widget_250top_series_imdb-2\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("149", "recently_activated", "a:3:{s:23:\"elementor/elementor.php\";i:1678880868;s:34:\"advanced-custom-fields-pro/acf.php\";i:1678880502;s:24:\"kelaket-jwt/jwt-auth.php\";i:1678630599;}", "yes");
INSERT INTO `wp_options` VALUES("153", "recovery_mode_email_last_sent", "1678630815", "yes");
INSERT INTO `wp_options` VALUES("159", "finished_updating_comment_type", "1", "yes");
INSERT INTO `wp_options` VALUES("169", "acf_version", "6.0.7", "yes");
INSERT INTO `wp_options` VALUES("171", "current_theme", "KelaketFilm", "yes");
INSERT INTO `wp_options` VALUES("172", "theme_mods_KelaketFilm", "a:5:{i:0;b:0;s:18:\"nav_menu_locations\";a:3:{s:8:\"category\";i:46;s:11:\"foot-menu-1\";i:3;s:11:\"foot-menu-2\";i:4;}s:18:\"custom_css_post_id\";i:-1;s:10:\"redux_demo\";a:3:{s:11:\"post_layout\";s:1:\"1\";s:11:\"show_actors\";s:1:\"1\";s:14:\"show_directors\";s:1:\"1\";}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1678880827;s:4:\"data\";a:5:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:7:{i:0;s:19:\"csf_widget_filter-3\";i:1;s:27:\"csf_widget_updated_series-2\";i:2;s:29:\"csf_widget_tabbed_genre_new-2\";i:3;s:21:\"csf_widget_text_ads-2\";i:4;s:26:\"csf_widget_latest_visits-2\";i:5;s:24:\"csf_widget_post_slider-2\";i:6;s:30:\"csf_widget_250top_films_imdb-2\";}s:9:\"sidebar-2\";a:0:{}s:6:\"single\";a:2:{i:0;s:25:\"csf_widget_tabbed_genre-3\";i:1;s:26:\"csf_widget_latest_visits-3\";}s:13:\"footer_widget\";a:1:{i:0;s:31:\"csf_widget_250top_series_imdb-2\";}}}}", "yes");
INSERT INTO `wp_options` VALUES("173", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("175", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("204", "wpsh_pro_license_status", "0", "yes");
INSERT INTO `wp_options` VALUES("273", "redux_demo", "a:23:{s:8:\"last_tab\";s:1:\"1\";s:4:\"logo\";s:19:\"کلاکت فیلم\";s:10:\"logo-image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:5:\"theme\";s:4:\"dark\";s:5:\"about\";s:454:\"لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است و برای شرایط فعلی تکنولوژی مورد نیاز و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد\";s:7:\"favicon\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:9:\"copyright\";s:76:\"تمامی حقوق برای کلاکت فیلم محفوظ می‌باشد.\";s:7:\"twitter\";s:1:\"1\";s:8:\"facebook\";s:0:\"\";s:8:\"telegram\";s:1:\"3\";s:7:\"discord\";s:0:\"\";s:9:\"instagram\";s:1:\"5\";s:5:\"skype\";s:0:\"\";s:7:\"youtube\";s:0:\"\";s:11:\"post_layout\";s:1:\"1\";s:11:\"show_actors\";s:1:\"1\";s:14:\"show_directors\";s:1:\"1\";s:17:\"show_special_cat1\";s:1:\"1\";s:12:\"special_cat1\";s:1:\"6\";s:17:\"show_special_cat2\";s:1:\"1\";s:12:\"special_cat2\";s:1:\"8\";s:10:\"serial_cat\";s:1:\"8\";s:8:\"film_cat\";s:1:\"6\";}", "yes");
INSERT INTO `wp_options` VALUES("274", "redux_demo-transients", "a:4:{s:14:\"changed_values\";a:4:{s:8:\"facebook\";s:2:\"23\";s:7:\"discord\";s:3:\"231\";s:5:\"skype\";s:3:\"123\";s:7:\"youtube\";s:3:\"132\";}s:9:\"last_save\";i:1635414927;s:13:\"last_compiler\";i:1635414927;s:11:\"last_import\";i:1635414927;}", "yes");
INSERT INTO `wp_options` VALUES("275", "redux-framework_allow_tracking", "no", "yes");
INSERT INTO `wp_options` VALUES("277", "redux-framework_tracking_skipped", "yes", "yes");
INSERT INTO `wp_options` VALUES("303", "subjects_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("399", "pld_settings", "a:2:{s:14:\"basic_settings\";a:9:{s:10:\"post_types\";a:1:{i:0;s:4:\"post\";}s:21:\"like_dislike_position\";s:5:\"after\";s:20:\"like_dislike_display\";s:4:\"both\";s:26:\"like_dislike_resistriction\";s:2:\"ip\";s:10:\"login_link\";s:0:\"\";s:13:\"display_order\";s:12:\"like-dislike\";s:15:\"like_hover_text\";s:0:\"\";s:18:\"dislike_hover_text\";s:0:\"\";s:12:\"display_zero\";s:1:\"1\";}s:15:\"design_settings\";a:5:{s:8:\"template\";s:10:\"template-1\";s:9:\"like_icon\";s:0:\"\";s:12:\"dislike_icon\";s:0:\"\";s:10:\"icon_color\";s:0:\"\";s:11:\"count_color\";s:0:\"\";}}", "yes");
INSERT INTO `wp_options` VALUES("400", "use_redux_templates", "", "yes");
INSERT INTO `wp_options` VALUES("401", "use_extendify_templates", "", "yes");
INSERT INTO `wp_options` VALUES("405", "post_titles", "a:1:{i:0;s:4:\"post\";}", "yes");
INSERT INTO `wp_options` VALUES("406", "section_padding", "0", "yes");
INSERT INTO `wp_options` VALUES("407", "section_alignment", "center", "yes");
INSERT INTO `wp_options` VALUES("408", "section_bg_color", "#ffffff", "yes");
INSERT INTO `wp_options` VALUES("409", "text_color", "#000000", "yes");
INSERT INTO `wp_options` VALUES("410", "alert_font_family", "Default", "yes");
INSERT INTO `wp_options` VALUES("411", "alert_font_style", "normal", "yes");
INSERT INTO `wp_options` VALUES("412", "alert_font_weight", "Bold", "yes");
INSERT INTO `wp_options` VALUES("413", "like_bg_color", "#ffffff", "yes");
INSERT INTO `wp_options` VALUES("414", "like_color", "#28a745", "yes");
INSERT INTO `wp_options` VALUES("415", "like_loader_color", "#28a745", "yes");
INSERT INTO `wp_options` VALUES("416", "like_loader_border_color", "#e0e0e0", "yes");
INSERT INTO `wp_options` VALUES("417", "dislike_bg_color", "#ffffff", "yes");
INSERT INTO `wp_options` VALUES("418", "dislike_color", "#dc3545", "yes");
INSERT INTO `wp_options` VALUES("419", "dislike_loader_color", "#dc3545", "yes");
INSERT INTO `wp_options` VALUES("420", "dislike_loader_border_color", "#e0e0e0", "yes");
INSERT INTO `wp_options` VALUES("421", "success_text_color", "#000000", "yes");
INSERT INTO `wp_options` VALUES("422", "error_text_color", "#000000", "yes");
INSERT INTO `wp_options` VALUES("460", "cld_settings", "a:2:{s:14:\"basic_settings\";a:10:{s:6:\"status\";s:1:\"1\";s:21:\"like_dislike_position\";s:6:\"before\";s:20:\"like_dislike_display\";s:4:\"both\";s:26:\"like_dislike_resistriction\";s:6:\"cookie\";s:10:\"login_link\";s:0:\"\";s:13:\"display_order\";s:12:\"like-dislike\";s:15:\"like_hover_text\";s:0:\"\";s:18:\"dislike_hover_text\";s:0:\"\";s:23:\"hide_like_dislike_admin\";s:1:\"0\";s:12:\"display_zero\";s:1:\"1\";}s:15:\"design_settings\";a:5:{s:8:\"template\";s:10:\"template-1\";s:9:\"like_icon\";s:0:\"\";s:12:\"dislike_icon\";s:0:\"\";s:10:\"icon_color\";s:0:\"\";s:11:\"count_color\";s:0:\"\";}}", "yes");
INSERT INTO `wp_options` VALUES("553", "asl_options", "a:190:{s:5:\"theme\";s:9:\"underline\";s:20:\"override_search_form\";s:1:\"1\";s:24:\"override_woo_search_form\";i:0;s:13:\"keyword_logic\";s:3:\"and\";s:28:\"mob_auto_focus_menu_selector\";s:12:\"#menu-toggle\";s:23:\"trigger_on_facet_change\";s:1:\"1\";s:17:\"redirect_click_to\";s:12:\"results_page\";s:17:\"redirect_enter_to\";s:12:\"results_page\";s:21:\"click_action_location\";s:4:\"same\";s:22:\"return_action_location\";s:4:\"same\";s:19:\"custom_redirect_url\";s:11:\"?s={phrase}\";s:16:\"results_per_page\";s:4:\"auto\";s:13:\"triggerontype\";s:1:\"1\";s:11:\"customtypes\";s:28:\"_decode_WyJwb3N0IiwicGFnZSJd\";s:13:\"searchintitle\";s:1:\"1\";s:15:\"searchincontent\";s:1:\"1\";s:15:\"searchinexcerpt\";s:1:\"1\";s:20:\"search_in_permalinks\";s:1:\"0\";s:23:\"post_password_protected\";s:1:\"1\";s:13:\"search_in_ids\";s:1:\"0\";s:13:\"search_all_cf\";s:1:\"0\";s:12:\"customfields\";s:0:\"\";s:11:\"post_status\";s:7:\"publish\";s:24:\"override_default_results\";s:1:\"0\";s:15:\"override_method\";s:3:\"get\";s:9:\"exactonly\";s:1:\"0\";s:20:\"exact_match_location\";s:8:\"anywhere\";s:13:\"searchinterms\";s:1:\"0\";s:9:\"charcount\";s:1:\"0\";s:10:\"maxresults\";s:2:\"10\";s:10:\"itemscount\";s:1:\"4\";s:16:\"resultitemheight\";s:4:\"70px\";s:15:\"orderby_primary\";s:14:\"relevance DESC\";s:17:\"orderby_secondary\";s:14:\"relevance DESC\";s:18:\"orderby_primary_cf\";s:0:\"\";s:20:\"orderby_secondary_cf\";s:0:\"\";s:23:\"orderby_primary_cf_type\";s:7:\"numeric\";s:25:\"orderby_secondary_cf_type\";s:7:\"numeric\";s:11:\"show_images\";s:1:\"1\";s:11:\"image_width\";s:2:\"70\";s:12:\"image_height\";s:2:\"70\";s:25:\"image_parser_image_number\";s:1:\"1\";s:30:\"image_parser_exclude_filenames\";s:0:\"\";s:18:\"image_display_mode\";s:5:\"cover\";s:26:\"image_apply_content_filter\";s:1:\"0\";s:13:\"image_sources\";a:7:{i:0;a:2:{s:6:\"option\";s:14:\"Featured image\";s:5:\"value\";s:8:\"featured\";}i:1;a:2:{s:6:\"option\";s:12:\"Post Content\";s:5:\"value\";s:7:\"content\";}i:2;a:2:{s:6:\"option\";s:12:\"Post Excerpt\";s:5:\"value\";s:7:\"excerpt\";}i:3;a:2:{s:6:\"option\";s:12:\"Custom field\";s:5:\"value\";s:6:\"custom\";}i:4;a:2:{s:6:\"option\";s:15:\"Page Screenshot\";s:5:\"value\";s:10:\"screenshot\";}i:5;a:2:{s:6:\"option\";s:13:\"Default image\";s:5:\"value\";s:7:\"default\";}i:6;a:2:{s:6:\"option\";s:8:\"Disabled\";s:5:\"value\";s:8:\"disabled\";}}s:13:\"image_source1\";s:8:\"featured\";s:13:\"image_source2\";s:7:\"content\";s:13:\"image_source3\";s:7:\"excerpt\";s:13:\"image_source4\";s:6:\"custom\";s:13:\"image_source5\";s:7:\"default\";s:13:\"image_default\";s:81:\"https://kelaketfilm.dev.local/wp-content/plugins/ajax-search-lite/img/default.jpg\";s:21:\"image_source_featured\";s:8:\"original\";s:18:\"image_custom_field\";s:0:\"\";s:12:\"use_timthumb\";i:1;s:29:\"show_frontend_search_settings\";s:1:\"0\";s:16:\"showexactmatches\";s:1:\"1\";s:17:\"showsearchintitle\";s:1:\"1\";s:19:\"showsearchincontent\";s:1:\"1\";s:15:\"showcustomtypes\";s:0:\"\";s:20:\"showsearchincomments\";i:1;s:19:\"showsearchinexcerpt\";i:1;s:19:\"showsearchinbpusers\";i:0;s:20:\"showsearchinbpgroups\";i:0;s:20:\"showsearchinbpforums\";i:0;s:16:\"exactmatchestext\";s:18:\"Exact matches only\";s:17:\"searchintitletext\";s:15:\"Search in title\";s:19:\"searchincontenttext\";s:17:\"Search in content\";s:20:\"searchincommentstext\";s:18:\"Search in comments\";s:19:\"searchinexcerpttext\";s:17:\"Search in excerpt\";s:19:\"searchinbpuserstext\";s:15:\"Search in users\";s:20:\"searchinbpgroupstext\";s:16:\"Search in groups\";s:20:\"searchinbpforumstext\";s:16:\"Search in forums\";s:22:\"showsearchincategories\";s:1:\"0\";s:17:\"showuncategorised\";s:1:\"0\";s:20:\"exsearchincategories\";s:0:\"\";s:26:\"exsearchincategoriesheight\";i:200;s:22:\"showsearchintaxonomies\";i:1;s:9:\"showterms\";s:0:\"\";s:23:\"showseparatefilterboxes\";i:1;s:24:\"exsearchintaxonomiestext\";s:9:\"Filter by\";s:24:\"exsearchincategoriestext\";s:20:\"Filter by Categories\";s:9:\"box_width\";s:4:\"100%\";s:16:\"box_width_tablet\";s:4:\"100%\";s:15:\"box_width_phone\";s:4:\"100%\";s:10:\"box_margin\";s:22:\"||0px||0px||0px||0px||\";s:8:\"box_font\";s:9:\"Open Sans\";s:11:\"override_bg\";s:1:\"0\";s:17:\"override_bg_color\";s:22:\"rgba(255, 255, 255, 1)\";s:13:\"override_icon\";s:1:\"0\";s:22:\"override_icon_bg_color\";s:22:\"rgba(255, 255, 255, 1)\";s:19:\"override_icon_color\";s:16:\"rgba(0, 0, 0, 1)\";s:15:\"override_border\";s:1:\"0\";s:21:\"override_border_style\";s:59:\"border:1px none rgb(0, 0, 0);border-radius:0px 0px 0px 0px;\";s:19:\"results_bg_override\";s:1:\"0\";s:25:\"results_bg_override_color\";s:22:\"rgba(255, 255, 255, 1)\";s:24:\"results_item_bg_override\";s:1:\"0\";s:30:\"results_item_bg_override_color\";s:22:\"rgba(255, 255, 255, 1)\";s:23:\"results_override_border\";s:1:\"0\";s:29:\"results_override_border_style\";s:59:\"border:1px none rgb(0, 0, 0);border-radius:0px 0px 0px 0px;\";s:20:\"settings_bg_override\";s:1:\"0\";s:26:\"settings_bg_override_color\";s:22:\"rgba(255, 255, 255, 1)\";s:24:\"settings_override_border\";s:1:\"0\";s:30:\"settings_override_border_style\";s:59:\"border:1px none rgb(0, 0, 0);border-radius:0px 0px 0px 0px;\";s:15:\"resultstype_def\";a:4:{i:0;a:2:{s:6:\"option\";s:16:\"Vertical Results\";s:5:\"value\";s:8:\"vertical\";}i:1;a:2:{s:6:\"option\";s:18:\"Horizontal Results\";s:5:\"value\";s:10:\"horizontal\";}i:2;a:2:{s:6:\"option\";s:16:\"Isotopic Results\";s:5:\"value\";s:8:\"isotopic\";}i:3;a:2:{s:6:\"option\";s:22:\"Polaroid style Results\";s:5:\"value\";s:8:\"polaroid\";}}s:11:\"resultstype\";s:8:\"vertical\";s:19:\"resultsposition_def\";a:2:{i:0;a:2:{s:6:\"option\";s:20:\"Hover - over content\";s:5:\"value\";s:5:\"hover\";}i:1;a:2:{s:6:\"option\";s:22:\"Block - pushes content\";s:5:\"value\";s:5:\"block\";}}s:15:\"resultsposition\";s:5:\"hover\";s:16:\"resultsmargintop\";s:4:\"12px\";s:16:\"v_res_max_height\";s:4:\"none\";s:18:\"v_res_column_count\";s:1:\"1\";s:22:\"v_res_column_min_width\";s:5:\"200px\";s:29:\"v_res_column_min_width_tablet\";s:5:\"200px\";s:28:\"v_res_column_min_width_phone\";s:5:\"200px\";s:17:\"defaultsearchtext\";s:13:\"Search here..\";s:15:\"showmoreresults\";s:1:\"0\";s:19:\"showmoreresultstext\";s:15:\"More results...\";s:19:\"results_click_blank\";s:1:\"0\";s:17:\"scroll_to_results\";s:1:\"0\";s:19:\"resultareaclickable\";s:1:\"1\";s:23:\"close_on_document_click\";s:1:\"1\";s:15:\"show_close_icon\";s:1:\"1\";s:10:\"showauthor\";s:1:\"0\";s:8:\"showdate\";s:1:\"0\";s:15:\"showdescription\";s:1:\"1\";s:17:\"descriptionlength\";s:3:\"100\";s:19:\"description_context\";s:1:\"0\";s:25:\"description_context_depth\";s:5:\"10000\";s:13:\"noresultstext\";s:11:\"No results!\";s:14:\"didyoumeantext\";s:13:\"Did you mean:\";s:12:\"kw_highlight\";s:1:\"0\";s:24:\"kw_highlight_whole_words\";s:1:\"1\";s:15:\"highlight_color\";s:20:\"rgba(217, 49, 43, 1)\";s:18:\"highlight_bg_color\";s:22:\"rgba(238, 238, 238, 1)\";s:16:\"single_highlight\";s:1:\"0\";s:26:\"single_highlightwholewords\";s:1:\"1\";s:21:\"single_highlightcolor\";s:20:\"rgba(217, 49, 43, 1)\";s:23:\"single_highlightbgcolor\";s:22:\"rgba(238, 238, 238, 1)\";s:23:\"single_highlight_scroll\";s:1:\"0\";s:23:\"single_highlight_offset\";s:1:\"0\";s:25:\"single_highlight_selector\";s:8:\"#content\";s:10:\"custom_css\";s:0:\"\";s:12:\"autocomplete\";s:1:\"1\";s:14:\"kw_suggestions\";s:1:\"1\";s:9:\"kw_length\";s:2:\"60\";s:8:\"kw_count\";s:2:\"10\";s:14:\"kw_google_lang\";s:2:\"en\";s:12:\"shortcode_op\";s:6:\"remove\";s:16:\"striptagsexclude\";s:0:\"\";s:12:\"runshortcode\";i:1;s:14:\"stripshortcode\";i:0;s:19:\"pageswithcategories\";i:0;s:18:\"primary_titlefield\";s:1:\"0\";s:21:\"primary_titlefield_cf\";s:0:\"\";s:24:\"primary_descriptionfield\";s:1:\"0\";s:27:\"primary_descriptionfield_cf\";s:0:\"\";s:20:\"secondary_titlefield\";i:-1;s:23:\"secondary_titlefield_cf\";s:0:\"\";s:26:\"secondary_descriptionfield\";i:-1;s:29:\"secondary_descriptionfield_cf\";s:0:\"\";s:13:\"advtitlefield\";s:12:\"{titlefield}\";s:19:\"advdescriptionfield\";s:18:\"{descriptionfield}\";s:22:\"woo_exclude_outofstock\";s:1:\"0\";s:18:\"exclude_woo_hidden\";s:1:\"1\";s:19:\"exclude_woo_catalog\";s:1:\"0\";s:17:\"excludecategories\";s:0:\"\";s:12:\"excludeposts\";s:0:\"\";s:18:\"wpml_compatibility\";s:1:\"1\";s:22:\"polylang_compatibility\";s:1:\"1\";s:13:\"kw_exceptions\";s:0:\"\";s:15:\"kw_exceptions_e\";s:0:\"\";s:21:\"classname-customtypes\";s:23:\"wpdreamsCustomPostTypes\";s:7:\"wdcfs_9\";s:0:\"\";s:22:\"classname-customfields\";s:20:\"wpdreamsCustomFields\";s:10:\"asl_submit\";s:1:\"1\";s:10:\"submit_asl\";s:13:\"Save options!\";s:25:\"classname-showcustomtypes\";s:31:\"wpdreamsCustomPostTypesEditable\";s:30:\"classname-exsearchincategories\";s:18:\"wpdreamsCategories\";s:7:\"topleft\";s:3:\"0px\";s:11:\"bottomright\";s:3:\"0px\";s:8:\"topright\";s:3:\"0px\";s:10:\"bottomleft\";s:3:\"0px\";s:12:\"_colorpicker\";s:12:\"rgb(0, 0, 0)\";s:27:\"classname-excludecategories\";s:18:\"wpdreamsCategories\";s:10:\"sett_tabid\";s:1:\"4\";s:20:\"selected-customtypes\";a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}s:21:\"selected-customfields\";N;s:24:\"selected-showcustomtypes\";N;s:29:\"selected-exsearchincategories\";N;s:26:\"selected-excludecategories\";N;}", "yes");
INSERT INTO `wp_options` VALUES("554", "asl_version", "4749", "yes");
INSERT INTO `wp_options` VALUES("555", "widget_ajaxsearchlitewidget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("556", "asl_debug_data", "a:1:{s:11:\"asl_options\";a:190:{s:5:\"theme\";s:9:\"underline\";s:20:\"override_search_form\";s:1:\"1\";s:24:\"override_woo_search_form\";i:0;s:13:\"keyword_logic\";s:3:\"and\";s:28:\"mob_auto_focus_menu_selector\";s:12:\"#menu-toggle\";s:23:\"trigger_on_facet_change\";s:1:\"1\";s:17:\"redirect_click_to\";s:12:\"results_page\";s:17:\"redirect_enter_to\";s:12:\"results_page\";s:21:\"click_action_location\";s:4:\"same\";s:22:\"return_action_location\";s:4:\"same\";s:19:\"custom_redirect_url\";s:11:\"?s={phrase}\";s:16:\"results_per_page\";s:4:\"auto\";s:13:\"triggerontype\";s:1:\"1\";s:11:\"customtypes\";s:28:\"_decode_WyJwb3N0IiwicGFnZSJd\";s:13:\"searchintitle\";s:1:\"1\";s:15:\"searchincontent\";s:1:\"1\";s:15:\"searchinexcerpt\";s:1:\"1\";s:20:\"search_in_permalinks\";s:1:\"0\";s:23:\"post_password_protected\";s:1:\"1\";s:13:\"search_in_ids\";s:1:\"0\";s:13:\"search_all_cf\";s:1:\"0\";s:12:\"customfields\";s:0:\"\";s:11:\"post_status\";s:7:\"publish\";s:24:\"override_default_results\";s:1:\"0\";s:15:\"override_method\";s:3:\"get\";s:9:\"exactonly\";s:1:\"0\";s:20:\"exact_match_location\";s:8:\"anywhere\";s:13:\"searchinterms\";s:1:\"0\";s:9:\"charcount\";s:1:\"0\";s:10:\"maxresults\";s:2:\"10\";s:10:\"itemscount\";s:1:\"4\";s:16:\"resultitemheight\";s:4:\"70px\";s:15:\"orderby_primary\";s:14:\"relevance DESC\";s:17:\"orderby_secondary\";s:14:\"relevance DESC\";s:18:\"orderby_primary_cf\";s:0:\"\";s:20:\"orderby_secondary_cf\";s:0:\"\";s:23:\"orderby_primary_cf_type\";s:7:\"numeric\";s:25:\"orderby_secondary_cf_type\";s:7:\"numeric\";s:11:\"show_images\";s:1:\"1\";s:11:\"image_width\";s:2:\"70\";s:12:\"image_height\";s:2:\"70\";s:25:\"image_parser_image_number\";s:1:\"1\";s:30:\"image_parser_exclude_filenames\";s:0:\"\";s:18:\"image_display_mode\";s:5:\"cover\";s:26:\"image_apply_content_filter\";s:1:\"0\";s:13:\"image_sources\";a:7:{i:0;a:2:{s:6:\"option\";s:14:\"Featured image\";s:5:\"value\";s:8:\"featured\";}i:1;a:2:{s:6:\"option\";s:12:\"Post Content\";s:5:\"value\";s:7:\"content\";}i:2;a:2:{s:6:\"option\";s:12:\"Post Excerpt\";s:5:\"value\";s:7:\"excerpt\";}i:3;a:2:{s:6:\"option\";s:12:\"Custom field\";s:5:\"value\";s:6:\"custom\";}i:4;a:2:{s:6:\"option\";s:15:\"Page Screenshot\";s:5:\"value\";s:10:\"screenshot\";}i:5;a:2:{s:6:\"option\";s:13:\"Default image\";s:5:\"value\";s:7:\"default\";}i:6;a:2:{s:6:\"option\";s:8:\"Disabled\";s:5:\"value\";s:8:\"disabled\";}}s:13:\"image_source1\";s:8:\"featured\";s:13:\"image_source2\";s:7:\"content\";s:13:\"image_source3\";s:7:\"excerpt\";s:13:\"image_source4\";s:6:\"custom\";s:13:\"image_source5\";s:7:\"default\";s:13:\"image_default\";s:81:\"https://kelaketfilm.dev.local/wp-content/plugins/ajax-search-lite/img/default.jpg\";s:21:\"image_source_featured\";s:8:\"original\";s:18:\"image_custom_field\";s:0:\"\";s:12:\"use_timthumb\";i:1;s:29:\"show_frontend_search_settings\";s:1:\"0\";s:16:\"showexactmatches\";s:1:\"1\";s:17:\"showsearchintitle\";s:1:\"1\";s:19:\"showsearchincontent\";s:1:\"1\";s:15:\"showcustomtypes\";s:0:\"\";s:20:\"showsearchincomments\";i:1;s:19:\"showsearchinexcerpt\";i:1;s:19:\"showsearchinbpusers\";i:0;s:20:\"showsearchinbpgroups\";i:0;s:20:\"showsearchinbpforums\";i:0;s:16:\"exactmatchestext\";s:18:\"Exact matches only\";s:17:\"searchintitletext\";s:15:\"Search in title\";s:19:\"searchincontenttext\";s:17:\"Search in content\";s:20:\"searchincommentstext\";s:18:\"Search in comments\";s:19:\"searchinexcerpttext\";s:17:\"Search in excerpt\";s:19:\"searchinbpuserstext\";s:15:\"Search in users\";s:20:\"searchinbpgroupstext\";s:16:\"Search in groups\";s:20:\"searchinbpforumstext\";s:16:\"Search in forums\";s:22:\"showsearchincategories\";s:1:\"0\";s:17:\"showuncategorised\";s:1:\"0\";s:20:\"exsearchincategories\";s:0:\"\";s:26:\"exsearchincategoriesheight\";i:200;s:22:\"showsearchintaxonomies\";i:1;s:9:\"showterms\";s:0:\"\";s:23:\"showseparatefilterboxes\";i:1;s:24:\"exsearchintaxonomiestext\";s:9:\"Filter by\";s:24:\"exsearchincategoriestext\";s:20:\"Filter by Categories\";s:9:\"box_width\";s:4:\"100%\";s:16:\"box_width_tablet\";s:4:\"100%\";s:15:\"box_width_phone\";s:4:\"100%\";s:10:\"box_margin\";s:22:\"||0px||0px||0px||0px||\";s:8:\"box_font\";s:9:\"Open Sans\";s:11:\"override_bg\";s:1:\"0\";s:17:\"override_bg_color\";s:22:\"rgba(255, 255, 255, 1)\";s:13:\"override_icon\";s:1:\"0\";s:22:\"override_icon_bg_color\";s:22:\"rgba(255, 255, 255, 1)\";s:19:\"override_icon_color\";s:16:\"rgba(0, 0, 0, 1)\";s:15:\"override_border\";s:1:\"0\";s:21:\"override_border_style\";s:59:\"border:1px none rgb(0, 0, 0);border-radius:0px 0px 0px 0px;\";s:19:\"results_bg_override\";s:1:\"0\";s:25:\"results_bg_override_color\";s:22:\"rgba(255, 255, 255, 1)\";s:24:\"results_item_bg_override\";s:1:\"0\";s:30:\"results_item_bg_override_color\";s:22:\"rgba(255, 255, 255, 1)\";s:23:\"results_override_border\";s:1:\"0\";s:29:\"results_override_border_style\";s:59:\"border:1px none rgb(0, 0, 0);border-radius:0px 0px 0px 0px;\";s:20:\"settings_bg_override\";s:1:\"0\";s:26:\"settings_bg_override_color\";s:22:\"rgba(255, 255, 255, 1)\";s:24:\"settings_override_border\";s:1:\"0\";s:30:\"settings_override_border_style\";s:59:\"border:1px none rgb(0, 0, 0);border-radius:0px 0px 0px 0px;\";s:15:\"resultstype_def\";a:4:{i:0;a:2:{s:6:\"option\";s:16:\"Vertical Results\";s:5:\"value\";s:8:\"vertical\";}i:1;a:2:{s:6:\"option\";s:18:\"Horizontal Results\";s:5:\"value\";s:10:\"horizontal\";}i:2;a:2:{s:6:\"option\";s:16:\"Isotopic Results\";s:5:\"value\";s:8:\"isotopic\";}i:3;a:2:{s:6:\"option\";s:22:\"Polaroid style Results\";s:5:\"value\";s:8:\"polaroid\";}}s:11:\"resultstype\";s:8:\"vertical\";s:19:\"resultsposition_def\";a:2:{i:0;a:2:{s:6:\"option\";s:20:\"Hover - over content\";s:5:\"value\";s:5:\"hover\";}i:1;a:2:{s:6:\"option\";s:22:\"Block - pushes content\";s:5:\"value\";s:5:\"block\";}}s:15:\"resultsposition\";s:5:\"hover\";s:16:\"resultsmargintop\";s:4:\"12px\";s:16:\"v_res_max_height\";s:4:\"none\";s:18:\"v_res_column_count\";s:1:\"1\";s:22:\"v_res_column_min_width\";s:5:\"200px\";s:29:\"v_res_column_min_width_tablet\";s:5:\"200px\";s:28:\"v_res_column_min_width_phone\";s:5:\"200px\";s:17:\"defaultsearchtext\";s:13:\"Search here..\";s:15:\"showmoreresults\";s:1:\"0\";s:19:\"showmoreresultstext\";s:15:\"More results...\";s:19:\"results_click_blank\";s:1:\"0\";s:17:\"scroll_to_results\";s:1:\"0\";s:19:\"resultareaclickable\";s:1:\"1\";s:23:\"close_on_document_click\";s:1:\"1\";s:15:\"show_close_icon\";s:1:\"1\";s:10:\"showauthor\";s:1:\"0\";s:8:\"showdate\";s:1:\"0\";s:15:\"showdescription\";s:1:\"1\";s:17:\"descriptionlength\";s:3:\"100\";s:19:\"description_context\";s:1:\"0\";s:25:\"description_context_depth\";s:5:\"10000\";s:13:\"noresultstext\";s:11:\"No results!\";s:14:\"didyoumeantext\";s:13:\"Did you mean:\";s:12:\"kw_highlight\";s:1:\"0\";s:24:\"kw_highlight_whole_words\";s:1:\"1\";s:15:\"highlight_color\";s:20:\"rgba(217, 49, 43, 1)\";s:18:\"highlight_bg_color\";s:22:\"rgba(238, 238, 238, 1)\";s:16:\"single_highlight\";s:1:\"0\";s:26:\"single_highlightwholewords\";s:1:\"1\";s:21:\"single_highlightcolor\";s:20:\"rgba(217, 49, 43, 1)\";s:23:\"single_highlightbgcolor\";s:22:\"rgba(238, 238, 238, 1)\";s:23:\"single_highlight_scroll\";s:1:\"0\";s:23:\"single_highlight_offset\";s:1:\"0\";s:25:\"single_highlight_selector\";s:8:\"#content\";s:10:\"custom_css\";s:0:\"\";s:12:\"autocomplete\";s:1:\"1\";s:14:\"kw_suggestions\";s:1:\"1\";s:9:\"kw_length\";s:2:\"60\";s:8:\"kw_count\";s:2:\"10\";s:14:\"kw_google_lang\";s:2:\"en\";s:12:\"shortcode_op\";s:6:\"remove\";s:16:\"striptagsexclude\";s:0:\"\";s:12:\"runshortcode\";i:1;s:14:\"stripshortcode\";i:0;s:19:\"pageswithcategories\";i:0;s:18:\"primary_titlefield\";s:1:\"0\";s:21:\"primary_titlefield_cf\";s:0:\"\";s:24:\"primary_descriptionfield\";s:1:\"0\";s:27:\"primary_descriptionfield_cf\";s:0:\"\";s:20:\"secondary_titlefield\";i:-1;s:23:\"secondary_titlefield_cf\";s:0:\"\";s:26:\"secondary_descriptionfield\";i:-1;s:29:\"secondary_descriptionfield_cf\";s:0:\"\";s:13:\"advtitlefield\";s:12:\"{titlefield}\";s:19:\"advdescriptionfield\";s:18:\"{descriptionfield}\";s:22:\"woo_exclude_outofstock\";s:1:\"0\";s:18:\"exclude_woo_hidden\";s:1:\"1\";s:19:\"exclude_woo_catalog\";s:1:\"0\";s:17:\"excludecategories\";s:0:\"\";s:12:\"excludeposts\";s:0:\"\";s:18:\"wpml_compatibility\";s:1:\"1\";s:22:\"polylang_compatibility\";s:1:\"1\";s:13:\"kw_exceptions\";s:0:\"\";s:15:\"kw_exceptions_e\";s:0:\"\";s:21:\"classname-customtypes\";s:23:\"wpdreamsCustomPostTypes\";s:7:\"wdcfs_9\";s:0:\"\";s:22:\"classname-customfields\";s:20:\"wpdreamsCustomFields\";s:10:\"asl_submit\";s:1:\"1\";s:10:\"submit_asl\";s:13:\"Save options!\";s:25:\"classname-showcustomtypes\";s:31:\"wpdreamsCustomPostTypesEditable\";s:30:\"classname-exsearchincategories\";s:18:\"wpdreamsCategories\";s:7:\"topleft\";s:3:\"0px\";s:11:\"bottomright\";s:3:\"0px\";s:8:\"topright\";s:3:\"0px\";s:10:\"bottomleft\";s:3:\"0px\";s:12:\"_colorpicker\";s:12:\"rgb(0, 0, 0)\";s:27:\"classname-excludecategories\";s:18:\"wpdreamsCategories\";s:10:\"sett_tabid\";s:1:\"4\";s:20:\"selected-customtypes\";a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}s:21:\"selected-customfields\";N;s:24:\"selected-showcustomtypes\";N;s:29:\"selected-exsearchincategories\";N;s:26:\"selected-excludecategories\";N;}}", "yes");
INSERT INTO `wp_options` VALUES("614", "wpdb_rcp_discounts_version", "202003313", "yes");
INSERT INTO `wp_options` VALUES("615", "rcp_db_version", "1.6", "yes");
INSERT INTO `wp_options` VALUES("617", "rcp_payments_db_version", "1.5", "yes");
INSERT INTO `wp_options` VALUES("618", "rcp_reminder_notices", "a:2:{i:0;a:5:{s:11:\"send_period\";s:7:\"+1month\";s:7:\"enabled\";b:0;s:4:\"type\";s:7:\"renewal\";s:7:\"subject\";s:35:\"Your Subscription is About to Renew\";s:7:\"message\";s:84:\"Hello %name%,\n\nYour subscription for %subscription_name% will renew on %expiration%.\";}i:1;a:5:{s:11:\"send_period\";s:7:\"+1month\";s:7:\"enabled\";b:0;s:4:\"type\";s:10:\"expiration\";s:7:\"subject\";s:36:\"Your Subscription is About to Expire\";s:7:\"message\";s:85:\"Hello %name%,\n\nYour subscription for %subscription_name% will expire on %expiration%.\";}}", "yes");
INSERT INTO `wp_options` VALUES("619", "rcp_settings", "a:96:{s:17:\"registration_page\";s:3:\"303\";s:8:\"redirect\";s:1:\"2\";s:12:\"account_page\";s:3:\"472\";s:12:\"edit_profile\";s:3:\"474\";s:11:\"update_card\";s:3:\"476\";s:10:\"auto_renew\";s:1:\"2\";s:19:\"restriction_message\";s:0:\"\";s:8:\"currency\";s:3:\"IRR\";s:17:\"currency_position\";s:5:\"after\";s:23:\"stripe_test_publishable\";s:0:\"\";s:18:\"stripe_test_secret\";s:0:\"\";s:23:\"stripe_live_publishable\";s:0:\"\";s:18:\"stripe_live_secret\";s:0:\"\";s:24:\"disable_sitewide_scripts\";s:1:\"1\";s:12:\"paypal_email\";s:0:\"\";s:24:\"test_paypal_api_username\";s:0:\"\";s:24:\"test_paypal_api_password\";s:0:\"\";s:25:\"test_paypal_api_signature\";s:0:\"\";s:24:\"live_paypal_api_username\";s:0:\"\";s:24:\"live_paypal_api_password\";s:0:\"\";s:25:\"live_paypal_api_signature\";s:0:\"\";s:17:\"paypal_page_style\";s:0:\"\";s:23:\"twocheckout_secret_word\";s:0:\"\";s:24:\"twocheckout_test_private\";s:0:\"\";s:28:\"twocheckout_test_publishable\";s:0:\"\";s:26:\"twocheckout_test_seller_id\";s:0:\"\";s:24:\"twocheckout_live_private\";s:0:\"\";s:28:\"twocheckout_live_publishable\";s:0:\"\";s:26:\"twocheckout_live_seller_id\";s:0:\"\";s:25:\"braintree_live_merchantId\";s:0:\"\";s:24:\"braintree_live_publicKey\";s:0:\"\";s:25:\"braintree_live_privateKey\";s:0:\"\";s:28:\"braintree_live_encryptionKey\";s:0:\"\";s:28:\"braintree_sandbox_merchantId\";s:0:\"\";s:27:\"braintree_sandbox_publicKey\";s:0:\"\";s:28:\"braintree_sandbox_privateKey\";s:0:\"\";s:31:\"braintree_sandbox_encryptionKey\";s:0:\"\";s:14:\"email_template\";s:7:\"default\";s:17:\"email_header_text\";s:8:\"سلام\";s:16:\"email_header_img\";s:0:\"\";s:9:\"from_name\";s:19:\"کلاکت فیلم\";s:10:\"from_email\";s:15:\"admin@gmail.com\";s:19:\"admin_notice_emails\";s:15:\"admin@gmail.com\";s:18:\"email_verification\";s:3:\"off\";s:20:\"verification_subject\";s:33:\"Please confirm your email address\";s:18:\"verification_email\";s:86:\"Click here to confirm your email address and activate your account: %verificationlink%\";s:14:\"active_subject\";s:0:\"\";s:12:\"active_email\";s:0:\"\";s:20:\"active_subject_admin\";s:0:\"\";s:18:\"active_email_admin\";s:0:\"\";s:12:\"free_subject\";s:0:\"\";s:10:\"free_email\";s:0:\"\";s:18:\"free_subject_admin\";s:0:\"\";s:16:\"free_email_admin\";s:0:\"\";s:13:\"trial_subject\";s:0:\"\";s:11:\"trial_email\";s:0:\"\";s:19:\"trial_subject_admin\";s:0:\"\";s:17:\"trial_email_admin\";s:0:\"\";s:17:\"cancelled_subject\";s:0:\"\";s:15:\"cancelled_email\";s:0:\"\";s:23:\"cancelled_subject_admin\";s:0:\"\";s:21:\"cancelled_email_admin\";s:0:\"\";s:15:\"expired_subject\";s:0:\"\";s:13:\"expired_email\";s:0:\"\";s:21:\"expired_subject_admin\";s:0:\"\";s:19:\"expired_email_admin\";s:0:\"\";s:24:\"payment_received_subject\";s:0:\"\";s:22:\"payment_received_email\";s:0:\"\";s:30:\"payment_received_subject_admin\";s:0:\"\";s:28:\"payment_received_email_admin\";s:0:\"\";s:30:\"renewal_payment_failed_subject\";s:0:\"\";s:28:\"renewal_payment_failed_email\";s:0:\"\";s:36:\"renewal_payment_failed_subject_admin\";s:0:\"\";s:34:\"renewal_payment_failed_email_admin\";s:0:\"\";s:12:\"invoice_logo\";s:0:\"\";s:15:\"invoice_company\";s:0:\"\";s:12:\"invoice_name\";s:0:\"\";s:15:\"invoice_address\";s:0:\"\";s:17:\"invoice_address_2\";s:0:\"\";s:22:\"invoice_city_state_zip\";s:0:\"\";s:13:\"invoice_email\";s:0:\"\";s:14:\"invoice_header\";s:0:\"\";s:13:\"invoice_notes\";s:0:\"\";s:14:\"invoice_footer\";s:0:\"\";s:21:\"redirect_from_premium\";s:1:\"2\";s:14:\"login_redirect\";s:3:\"478\";s:20:\"auto_add_users_level\";s:1:\"1\";s:16:\"content_excerpts\";s:10:\"individual\";s:16:\"no_login_sharing\";s:1:\"0\";s:11:\"terms_label\";s:0:\"\";s:10:\"terms_link\";s:0:\"\";s:20:\"privacy_policy_label\";s:0:\"\";s:19:\"privacy_policy_link\";s:0:\"\";s:17:\"recaptcha_version\";s:1:\"2\";s:20:\"recaptcha_public_key\";s:0:\"\";s:21:\"recaptcha_private_key\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("620", "rcp_is_installed", "1", "yes");
INSERT INTO `wp_options` VALUES("621", "rcp_version", "3.5.12", "yes");
INSERT INTO `wp_options` VALUES("624", "wpdb_rcp_customers_version", "202003311", "yes");
INSERT INTO `wp_options` VALUES("626", "wpdb_rcp_logs_version", "202003051", "yes");
INSERT INTO `wp_options` VALUES("627", "wpdb_rcp_membership_counts_version", "202003311", "yes");
INSERT INTO `wp_options` VALUES("628", "wpdb_restrict_content_pro_version", "202003093", "yes");
INSERT INTO `wp_options` VALUES("629", "wpdb_rcp_memberships_version", "202003315", "yes");
INSERT INTO `wp_options` VALUES("630", "wpdb_rcp_membershipmeta_version", "201901291", "yes");
INSERT INTO `wp_options` VALUES("631", "wpdb_rcp_queue_version", "202003312", "yes");
INSERT INTO `wp_options` VALUES("633", "rcp_install_pages_created", "2021-10-15 16:36:59", "yes");
INSERT INTO `wp_options` VALUES("635", "ithemes-updater-cache", "a:13:{s:18:\"timeout-multiplier\";i:1;s:10:\"expiration\";i:1678835983;s:9:\"timestamp\";i:1678792682;s:8:\"packages\";a:1:{i:0;s:20:\"restrict-content-pro\";}s:14:\"update_plugins\";a:0:{}s:24:\"update_plugins_no_update\";a:1:{s:11:\"backupbuddy\";O:8:\"stdClass\":12:{s:2:\"id\";i:0;s:4:\"slug\";s:1:\".\";s:6:\"plugin\";s:11:\"backupbuddy\";s:11:\"new_version\";b:1;s:3:\"url\";N;s:7:\"package\";s:45:\"restrict-content-pro/restrict-content-pro.php\";s:5:\"icons\";a:0:{}s:7:\"banners\";a:0:{}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:0:\"\";s:12:\"requires_php\";s:0:\"\";s:13:\"compatibility\";O:8:\"stdClass\":0:{}}}s:13:\"update_themes\";a:0:{}s:23:\"update_themes_no_update\";a:0:{}s:12:\"use_ca_patch\";b:0;s:7:\"use_ssl\";b:1;s:14:\"quick_releases\";b:0;s:16:\"site_url_history\";a:2:{s:29:\"https://kelaketfilm.dev.local\";i:1669984761;s:23:\"https://kelaketfilm.dev\";i:1678881303;}s:18:\"timeout-mulitplier\";i:1;}", "no");
INSERT INTO `wp_options` VALUES("638", "rcp_version_upgraded_from", "3.5.22", "yes");
INSERT INTO `wp_options` VALUES("639", "rcp_version_upgraded_on", "2022-09-26 15:06:24", "yes");
INSERT INTO `wp_options` VALUES("711", "_wp_suggested_policy_text_has_changed", "changed", "yes");
INSERT INTO `wp_options` VALUES("791", "widget_recent-comments", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("794", "widget_recent-posts", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("889", "acfbs_notice_hidden", "1635856192", "yes");
INSERT INTO `wp_options` VALUES("890", "acfbs_fields_types", "a:4:{i:0;s:4:\"text\";i:1;s:8:\"textarea\";i:2;s:7:\"wysiwyg\";i:3;s:6:\"select\";}", "yes");
INSERT INTO `wp_options` VALUES("891", "acfbs_whole_phrases", "", "yes");
INSERT INTO `wp_options` VALUES("892", "acfbs_whole_words", "", "yes");
INSERT INTO `wp_options` VALUES("893", "acfbs_lite_mode", "", "yes");
INSERT INTO `wp_options` VALUES("894", "acfbs_selected_mode", "", "yes");
INSERT INTO `wp_options` VALUES("895", "acfbs_regex_spencer", "", "yes");
INSERT INTO `wp_options` VALUES("967", "year_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("1000", "score_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("1108", "mp_logo_width", "120", "yes");
INSERT INTO `wp_options` VALUES("1109", "mp_logo_height", "120", "yes");
INSERT INTO `wp_options` VALUES("1110", "mp_bg_image", "https://kelaketfilm.dev.local/wp-content/plugins/mihanpanel-lite/img/bg.jpg", "yes");
INSERT INTO `wp_options` VALUES("1111", "mp_logo_image", "https://kelaketfilm.dev.local/wp-content/plugins/mihanpanel-lite/img/logo.png", "yes");
INSERT INTO `wp_options` VALUES("1112", "mp_disable_wordpress_bar", "1", "yes");
INSERT INTO `wp_options` VALUES("1113", "mp_panelslug", "panel", "yes");
INSERT INTO `wp_options` VALUES("1114", "mp_account_activation_type", "auto", "yes");
INSERT INTO `wp_options` VALUES("1115", "mihanpanel_db_version", "7", "yes");
INSERT INTO `wp_options` VALUES("1116", "widget_mpp_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("1117", "rwl_page", "login", "yes");
INSERT INTO `wp_options` VALUES("1118", "login_button_color", "#5454ff", "yes");
INSERT INTO `wp_options` VALUES("1121", "mwpl_disable_font_family", "1", "yes");
INSERT INTO `wp_options` VALUES("1122", "mp_use_mihan_avatar", "", "yes");
INSERT INTO `wp_options` VALUES("1123", "mp_offer_code", "", "yes");
INSERT INTO `wp_options` VALUES("1124", "mp_offer_perc", "", "yes");
INSERT INTO `wp_options` VALUES("1450", "simplefavorites_dependencies", "a:2:{s:3:\"css\";s:4:\"true\";s:2:\"js\";s:4:\"true\";}", "yes");
INSERT INTO `wp_options` VALUES("1451", "simplefavorites_users", "a:5:{s:7:\"consent\";a:3:{s:5:\"modal\";s:0:\"\";s:19:\"consent_button_text\";s:0:\"\";s:16:\"deny_button_text\";s:0:\"\";}s:13:\"require_login\";s:4:\"true\";s:20:\"authentication_modal\";s:117:\"<p>لطفا وارد شوید تا ذخیره کنید</p>\r\n<a data-favorites-modal-close><i class=\"bi bi-x\"></i></a>\";s:21:\"anonymous_redirect_id\";s:0:\"\";s:9:\"anonymous\";a:1:{s:6:\"saveas\";s:6:\"cookie\";}}", "yes");
INSERT INTO `wp_options` VALUES("1452", "simplefavorites_display", "a:10:{s:9:\"posttypes\";a:1:{s:4:\"post\";a:1:{s:7:\"display\";s:4:\"true\";}}s:19:\"button_element_type\";s:6:\"button\";s:10:\"buttontype\";s:6:\"custom\";s:13:\"button_colors\";a:10:{s:18:\"background_default\";s:0:\"\";s:14:\"border_default\";s:0:\"\";s:12:\"text_default\";s:0:\"\";s:12:\"icon_default\";s:0:\"\";s:13:\"count_default\";s:0:\"\";s:17:\"background_active\";s:0:\"\";s:13:\"border_active\";s:0:\"\";s:11:\"text_active\";s:0:\"\";s:11:\"icon_active\";s:0:\"\";s:12:\"count_active\";s:0:\"\";}s:10:\"buttontext\";s:30:\"<i class=\"bi bi-bookmark\"></i>\";s:19:\"buttontextfavorited\";s:41:\"<i class=\"bi bi-bookmark-check-fill\"></i>\";s:16:\"loadingindicator\";a:1:{s:4:\"text\";s:7:\"Loading\";}s:7:\"listing\";a:5:{s:12:\"wrapper_type\";s:2:\"ul\";s:11:\"wrapper_css\";s:0:\"\";s:12:\"listing_type\";s:2:\"li\";s:11:\"listing_css\";s:0:\"\";s:18:\"custom_markup_html\";s:0:\"\";}s:14:\"clearfavorites\";s:15:\"Clear Favorites\";s:11:\"nofavorites\";s:12:\"No Favorites\";}", "yes");
INSERT INTO `wp_options` VALUES("1453", "simplefavorites_cache_enabled", "true", "yes");
INSERT INTO `wp_options` VALUES("1489", "wpcf7", "a:2:{s:7:\"version\";s:5:\"5.7.4\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1664023699;s:7:\"version\";s:5:\"5.6.1\";s:11:\"count_valid\";i:0;s:13:\"count_invalid\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("1490", "secret_key", "bC,*Jvmoat)fG[?_95IvAj d1+Q^yA_TI3#l`3DPhT$,hZ{OaTcA%(9!0yW@*fxi", "no");
INSERT INTO `wp_options` VALUES("1493", "ithemes-updater-keys", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("1702", "my_framework", "a:107:{s:9:\"logo_text\";s:19:\"کلاکت فیلم\";s:10:\"logo_image\";a:8:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:7:\"favicon\";a:8:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:4:\"font\";s:9:\"IRANYekan\";s:16:\"post_like_system\";s:3:\"all\";s:15:\"post_like_count\";s:1:\"1\";s:14:\"use_relevanssi\";s:1:\"1\";s:9:\"lightMode\";s:1:\"0\";s:3:\"vip\";s:1:\"1\";s:8:\"internet\";s:4:\"full\";s:9:\"just_iran\";s:1:\"0\";s:5:\"about\";s:361:\"لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است. چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است و برای شرایط فعلی تکنولوژی مورد نیاز است.\";s:15:\"contact_us_text\";s:183:\"جهت تماس با واحد پشتیبانی کلاکت فیلم از طریق  تلگرم و همچنین ارسال تیک میتوانید با ما در ارتباط باشید.\";s:9:\"copyright\";s:76:\"تمامی حقوق برای کلاکت فیلم محفوظ می‌باشد.\";s:13:\"color_palette\";s:4:\"set2\";s:21:\"custom_palette_active\";s:1:\"0\";s:20:\"custom_color_pallete\";a:7:{s:2:\"bg\";s:7:\"#ff604f\";s:3:\"bg2\";s:7:\"#ff595e\";s:9:\"bg_darker\";s:7:\"#1e73be\";s:10:\"bg_darker2\";s:7:\"#5e40ce\";s:10:\"bg_lighter\";s:7:\"#1e73be\";s:11:\"bg_lighter2\";s:7:\"#eeee22\";s:4:\"text\";s:7:\"#ffffff\";}s:27:\"light_custom_palette_active\";s:1:\"1\";s:26:\"light_custom_color_pallete\";a:8:{s:2:\"bg\";s:7:\"#f9fbff\";s:3:\"bg2\";s:7:\"#ffffff\";s:9:\"bg_darker\";s:7:\"#6881bc\";s:10:\"bg_darker2\";s:7:\"#d2def1\";s:10:\"bg_lighter\";s:7:\"#e0ebfc\";s:11:\"bg_lighter2\";s:7:\"#6aa7fc\";s:4:\"text\";s:7:\"#6881a9\";s:12:\"shadow_color\";s:7:\"#dce3f7\";}s:11:\"theme_color\";s:7:\"#4050b5\";s:11:\"adminNotice\";s:1:\"0\";s:20:\"adminNotice_location\";s:1:\"1\";s:16:\"adminNotice_text\";s:115:\"پیام این قسمت از پنل تنظیمات می‌توانید حذف یا تغییر دهید. 💚❤️\";s:19:\"adminNotice_btnText\";s:8:\"دکمه\";s:19:\"adminNotice_btnLink\";s:0:\"\";s:17:\"adminNotice_timer\";s:0:\"\";s:14:\"adminNotice_bg\";a:8:{s:16:\"background-color\";s:7:\"#81d742\";s:25:\"background-gradient-color\";s:7:\"#1e73be\";s:29:\"background-gradient-direction\";s:7:\"-135deg\";s:16:\"background-image\";a:8:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:19:\"background-position\";s:13:\"center center\";s:17:\"background-repeat\";s:6:\"repeat\";s:21:\"background-attachment\";s:0:\"\";s:15:\"background-size\";s:5:\"cover\";}s:11:\"blog_slider\";s:1:\"1\";s:17:\"blog_slider_count\";s:1:\"2\";s:14:\"blog_lastposts\";s:1:\"1\";s:19:\"blog_carousel_count\";s:1:\"6\";s:16:\"blog_custom_cats\";a:2:{i:0;a:3:{s:21:\"blog_custom_cats__cat\";s:3:\"210\";s:23:\"blog_custom_cats__title\";s:21:\"اخبار سریال\";s:23:\"blog_custom_cats__count\";s:1:\"6\";}i:1;a:3:{s:21:\"blog_custom_cats__cat\";s:3:\"155\";s:23:\"blog_custom_cats__title\";s:21:\"اخبار سینما\";s:23:\"blog_custom_cats__count\";s:1:\"6\";}}s:7:\"twitter\";s:1:\"1\";s:8:\"facebook\";s:1:\"2\";s:8:\"telegram\";s:1:\"5\";s:11:\"telegram_id\";s:0:\"\";s:9:\"instagram\";s:1:\"3\";s:12:\"instagram_id\";s:0:\"\";s:7:\"discord\";s:0:\"\";s:5:\"skype\";s:0:\"\";s:7:\"youtube\";s:0:\"\";s:14:\"post_show_type\";s:7:\"default\";s:10:\"post_style\";s:6:\"modern\";s:15:\"film_card_style\";s:6:\"style3\";s:20:\"blog_lastposts_index\";s:1:\"1\";s:19:\"show_updated_serial\";s:1:\"1\";s:13:\"show_en_title\";s:1:\"1\";s:13:\"film_cat_home\";a:3:{i:0;a:5:{s:13:\"film_cat_item\";s:1:\"1\";s:19:\"film_cat_item_title\";s:30:\"فیلم های اجتماعی\";s:19:\"film_cat_item_count\";s:1:\"9\";s:20:\"film_cat_item__style\";s:0:\"\";s:23:\"film_cat_item_sub_title\";s:0:\"\";}i:1;a:5:{s:13:\"film_cat_item\";s:1:\"1\";s:19:\"film_cat_item_title\";s:43:\"فیلم های زیرنویس چسبیده\";s:19:\"film_cat_item_count\";s:1:\"7\";s:20:\"film_cat_item__style\";s:1:\"1\";s:23:\"film_cat_item_sub_title\";s:21:\"بروزترین ها\";}i:2;a:5:{s:13:\"film_cat_item\";s:1:\"1\";s:19:\"film_cat_item_title\";s:39:\"سریال های دوبله فارسی\";s:19:\"film_cat_item_count\";s:1:\"7\";s:20:\"film_cat_item__style\";s:0:\"\";s:23:\"film_cat_item_sub_title\";s:0:\"\";}}s:13:\"updated_first\";s:1:\"1\";s:12:\"single_style\";s:7:\"default\";s:13:\"count_relpots\";s:1:\"6\";s:11:\"show_actors\";s:1:\"1\";s:10:\"pro_player\";s:1:\"1\";s:17:\"dont_pass_quality\";s:1:\"0\";s:12:\"footer_style\";s:7:\"minimal\";s:11:\"slider_type\";s:7:\"comfort\";s:14:\"disable_slider\";s:1:\"0\";s:23:\"disable_advanced_search\";s:1:\"0\";s:12:\"count_slider\";s:2:\"10\";s:17:\"slider_in_archive\";s:1:\"0\";s:12:\"header-fluid\";s:1:\"0\";s:13:\"series_active\";s:1:\"1\";s:13:\"series_tabbed\";a:3:{s:3:\"Sat\";a:1:{i:0;s:4:\"2669\";}s:3:\"Sun\";a:1:{i:0;s:4:\"2665\";}s:3:\"Fri\";a:3:{i:0;s:4:\"2665\";i:1;s:4:\"2660\";i:2;s:4:\"2669\";}}s:11:\"mobile-auth\";s:1:\"0\";s:12:\"sms_provider\";s:12:\"meli_payamak\";s:11:\"api_key_sms\";s:0:\"\";s:8:\"sms_user\";s:0:\"\";s:8:\"sms_pass\";s:0:\"\";s:11:\"pattern_sms\";s:0:\"\";s:10:\"number_sms\";s:0:\"\";s:10:\"collection\";s:3:\"161\";s:6:\"report\";s:61:\"[contact-form-7 id=\"1393\" title=\"فرم خرابی لینک\"]\";s:13:\"poster_bridge\";s:1:\"0\";s:18:\"selected_actor_api\";s:8:\"imdb_api\";s:12:\"actors_limit\";s:1:\"1\";s:14:\"get_cover_tmdb\";s:1:\"0\";s:10:\"omdb-token\";s:0:\"\";s:14:\"imdb-api-token\";s:0:\"\";s:13:\"mal-api-token\";s:0:\"\";s:15:\"ads_afterSlider\";s:0:\"\";s:14:\"ads_beforePost\";s:0:\"\";s:13:\"ads_afterPost\";s:0:\"\";s:10:\"api-active\";s:1:\"1\";s:16:\"showWeeklySeries\";s:1:\"1\";s:14:\"active_vip_app\";s:1:\"1\";s:17:\"mobileAuth_Method\";s:5:\"email\";s:16:\"appInstallBanner\";s:1:\"0\";s:8:\"app_icon\";a:8:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:8:\"app_link\";s:36:\"http://kelaketfilmapp.imahmoodzz.ir/\";s:8:\"app_text\";s:49:\"دانلود اپلیکیشن کلاکت فیلم\";s:9:\"appBanner\";s:1:\"0\";s:8:\"app_home\";a:3:{i:0;a:1:{s:13:\"app_home_item\";s:2:\"42\";}i:1;a:1:{s:13:\"app_home_item\";s:1:\"6\";}i:2;a:1:{s:13:\"app_home_item\";s:1:\"9\";}}s:11:\"tickets_vip\";s:1:\"0\";s:7:\"sendSMS\";s:1:\"0\";s:14:\"pattern_ticket\";s:0:\"\";s:10:\"ticket_dep\";a:3:{i:0;a:2:{s:15:\"ticket_dep_name\";s:6:\"فنی\";s:13:\"ticket_dep_id\";s:9:\"technical\";}i:1;a:2:{s:15:\"ticket_dep_name\";s:16:\"پشتیبانی\";s:13:\"ticket_dep_id\";s:7:\"support\";}i:2;a:2:{s:15:\"ticket_dep_name\";s:12:\"مدیریت\";s:13:\"ticket_dep_id\";s:5:\"admin\";}}s:14:\"ticket_support\";a:1:{i:0;s:1:\"2\";}s:10:\"pwa_active\";s:1:\"0\";s:10:\"pwa_icon_1\";a:8:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:10:\"pwa_icon_2\";a:8:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:12:\"status_color\";s:7:\"#101014\";s:15:\"theme_pwa_color\";s:7:\"#101014\";s:9:\"pwa_name1\";s:19:\"کلاکت فیلم\";s:9:\"pwa_desc1\";s:14:\"توضیحات\";s:13:\"footer_script\";s:0:\"\";s:12:\"header_style\";s:0:\"\";s:13:\"tags_template\";s:439:\"دانلود فیلم\r\nدانلود فیلم {en_title}\r\nدانلود فیلم {en_title} {site_title}\r\n{title}\r\n{title} {en_title} {site_title} جدید\r\n{title} {en_title} {site_title} باحال\r\nدانلود فیلم {en_title} با لینک مستقیم\r\nدانلود {type_fa} {en_title} بصورت رایگان\r\nدانلود {type_fa} {en_title} با لینک مستقیم\r\nکلاکت فیلم\r\nkelaketfilm\r\ndownload {en_title} free\";}", "yes");
INSERT INTO `wp_options` VALUES("1719", "wpsh", "a:27:{s:15:\"activate-shamsi\";s:3:\"yes\";s:14:\"country-select\";s:2:\"ir\";s:23:\"activate-shamsi-archive\";s:3:\"yes\";s:24:\"activate-shamsi-calendar\";s:3:\"yes\";s:14:\"admin-bar-date\";s:3:\"yes\";s:17:\"persian-admin-num\";s:3:\"yes\";s:22:\"dashboard-font-default\";s:11:\"IRANSansWeb\";s:8:\"fa-theme\";s:3:\"yes\";s:20:\"activate-woocommerce\";s:3:\"yes\";s:23:\"activate-classic-editor\";s:3:\"yes\";s:20:\"activate-contactform\";s:3:\"yes\";s:17:\"activate-rankmath\";s:3:\"yes\";s:18:\"activate-elementor\";s:3:\"yes\";s:12:\"activate-ssl\";s:3:\"yes\";s:16:\"activate-bbpress\";s:3:\"yes\";s:18:\"activate-buddyboss\";s:3:\"yes\";s:21:\"activate-gravityforms\";s:3:\"yes\";s:21:\"activate-admin-shamsi\";s:3:\"yes\";s:26:\"activate-no-lang-no-shamsi\";s:3:\"yes\";s:13:\"fa-custom-css\";s:0:\"\";s:14:\"activate-stats\";s:2:\"no\";s:11:\"persian-num\";s:2:\"no\";s:13:\"disable_admin\";s:2:\"no\";s:17:\"disable_admin_bar\";s:2:\"no\";s:12:\"disable_copy\";s:2:\"no\";s:11:\"maintenance\";s:2:\"no\";s:9:\"woo_price\";s:2:\"no\";}", "yes");
INSERT INTO `wp_options` VALUES("2040", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:15:\"admin@gmail.com\";s:7:\"version\";s:5:\"6.0.3\";s:9:\"timestamp\";i:1666811367;}", "no");
INSERT INTO `wp_options` VALUES("2198", "RTL-CareUnit-PIL", "q1bKSS1LzVGyUnJMLsksSyzJzM9T0lEqLkksKS0GigaXJienFhcDhVJSi5OLMgvACqyUlGoB", "no");
INSERT INTO `wp_options` VALUES("2199", "RTL-CareUnit-FPA", "1", "yes");
INSERT INTO `wp_options` VALUES("2200", "auto_update_plugins", "a:1:{i:0;s:29:\"RTL-CareUnit/RTL-CareUnit.php\";}", "no");
INSERT INTO `wp_options` VALUES("2201", "RTL-CareUnit-PCS", "S7Qo9Crwci6MLAgPyTVPSooMSjUqyy0MMjEoyY0o9ivXdinwdMpyrqwoLkv3KfSpdM-oTAsJDQ0vzQirKA_UL7IIN9T2sEgMdw21MMk1C9MOjszOKiky980vdPMKD_Z2zAhwdM5xD6sIyrGwBQA", "no");
INSERT INTO `wp_options` VALUES("2546", "my_plugin_version", "2.0", "yes");
INSERT INTO `wp_options` VALUES("2728", "dig_hide_countrycode", "0", "yes");
INSERT INTO `wp_options` VALUES("2729", "digits_db_migrate7010", "1", "yes");
INSERT INTO `wp_options` VALUES("2730", "dig_reg_custom_field_data_backup", "e30=", "yes");
INSERT INTO `wp_options` VALUES("2731", "dig_reg_lb_data_backup", "", "yes");
INSERT INTO `wp_options` VALUES("2732", "dig_reg_custom_field_data", "W10=", "yes");
INSERT INTO `wp_options` VALUES("2733", "digits_do_activation_redirect", "1", "yes");
INSERT INTO `wp_options` VALUES("2735", "external_updates-digits", "O:8:\"stdClass\":5:{s:9:\"lastCheck\";i:1638195918;s:14:\"checkedVersion\";s:7:\"7.8.0.1\";s:6:\"update\";O:8:\"stdClass\":10:{s:4:\"slug\";s:6:\"digits\";s:7:\"version\";s:3:\"7.9\";s:12:\"download_url\";N;s:12:\"translations\";a:0:{}s:2:\"id\";i:0;s:8:\"homepage\";s:29:\"https://digits.unitedover.com\";s:6:\"tested\";s:7:\"5.6.999\";s:14:\"upgrade_notice\";N;s:5:\"icons\";a:2:{s:2:\"1x\";s:48:\"https://unitedover.com/images/digits/icon128.png\";s:2:\"2x\";s:48:\"https://unitedover.com/images/digits/icon256.png\";}s:8:\"filename\";s:16:\"digits/digit.php\";}s:11:\"updateClass\";s:22:\"Puc_v4p6_Plugin_Update\";s:15:\"updateBaseClass\";s:13:\"Plugin_Update\";}", "no");
INSERT INTO `wp_options` VALUES("2736", "digits_activation_time", "1638195919", "yes");
INSERT INTO `wp_options` VALUES("2737", "digits_addon_update_page_redirect", "a:2:{s:4:\"time\";i:1638195919;s:7:\"version\";s:7:\"7.8.0.1\";}", "yes");
INSERT INTO `wp_options` VALUES("2739", "dig_purchasecode", "12345678901234567890123456789012", "no");
INSERT INTO `wp_options` VALUES("2740", "dig_license_type", "", "no");
INSERT INTO `wp_options` VALUES("2741", "dig_bill_merge_phone", "0", "yes");
INSERT INTO `wp_options` VALUES("2742", "dig_old_account_migrator", "a:3:{s:19:\"add_phone_old_users\";s:1:\"1\";s:15:\"add_phone_force\";s:1:\"1\";s:12:\"when_to_show\";s:1:\"1\";}", "yes");
INSERT INTO `wp_options` VALUES("2743", "dig_one_click_login_signup", "0", "yes");
INSERT INTO `wp_options` VALUES("2744", "dig_one_click_login_signup_third_party_actions", "0", "yes");
INSERT INTO `wp_options` VALUES("2745", "digits_sameorigin_protection", "1", "yes");
INSERT INTO `wp_options` VALUES("2746", "enable_guest_checkout_verification", "1", "yes");
INSERT INTO `wp_options` VALUES("2747", "enable_billing_phone_verification", "1", "yes");
INSERT INTO `wp_options` VALUES("2748", "dig_login_rememberme", "1", "yes");
INSERT INTO `wp_options` VALUES("2749", "dig_login_fields", "a:6:{s:18:\"dig_login_username\";s:1:\"1\";s:15:\"dig_login_email\";s:1:\"1\";s:22:\"dig_login_mobilenumber\";s:1:\"1\";s:13:\"dig_login_otp\";s:1:\"1\";s:18:\"dig_login_password\";s:1:\"1\";s:17:\"dig_login_captcha\";s:1:\"1\";}", "yes");
INSERT INTO `wp_options` VALUES("2750", "dig_reg_fields", "a:5:{s:12:\"dig_reg_name\";s:1:\"1\";s:13:\"dig_reg_uname\";s:1:\"0\";s:13:\"dig_reg_email\";s:1:\"1\";s:20:\"dig_reg_mobilenumber\";s:1:\"1\";s:16:\"dig_reg_password\";s:1:\"1\";}", "yes");
INSERT INTO `wp_options` VALUES("2751", "woocommerce_registration_generate_username", "yes", "yes");
INSERT INTO `wp_options` VALUES("2752", "woocommerce_registration_generate_password", "no", "yes");
INSERT INTO `wp_options` VALUES("2753", "dig_sortorder", "", "yes");
INSERT INTO `wp_options` VALUES("2754", "digit_tapp", "10001", "yes");
INSERT INTO `wp_options` VALUES("2755", "digit_api", "a:3:{s:5:\"appid\";s:0:\"\";s:9:\"appsecret\";s:0:\"\";s:15:\"accountkit_type\";s:5:\"modal\";}", "yes");
INSERT INTO `wp_options` VALUES("2756", "digit_twilio_api", "a:3:{s:9:\"twiliosid\";s:0:\"\";s:11:\"twiliotoken\";s:0:\"\";s:14:\"twiliosenderid\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("2757", "digit_msg91_api", "a:4:{s:12:\"msg91authkey\";s:0:\"\";s:13:\"msg91senderid\";s:0:\"\";s:10:\"msg91route\";s:1:\"1\";s:14:\"msg91dlt_te_id\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("2758", "digit_yunpianapi", "", "yes");
INSERT INTO `wp_options` VALUES("2759", "digit_ippanel", "a:7:{s:8:\"username\";s:0:\"\";s:8:\"password\";s:0:\"\";s:6:\"sender\";s:0:\"\";s:6:\"domain\";s:0:\"\";s:11:\"sendpattern\";s:1:\"0\";s:11:\"patterncode\";s:0:\"\";s:11:\"patternvars\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("2760", "digit_ippanelapikey", "a:6:{s:6:\"apikey\";s:44:\"-5ZVtaa_nWLBpCGzE16L2MH39mOK58NiPkAjRjtz4-8=\";s:6:\"sender\";s:9:\"983000505\";s:6:\"domain\";s:0:\"\";s:11:\"sendpattern\";s:1:\"1\";s:11:\"patterncode\";s:10:\"lnd5se6fzd\";s:11:\"patternvars\";s:6:\"{code}\";}", "yes");
INSERT INTO `wp_options` VALUES("2761", "digit_whatsappغیرفعال", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("2762", "digit_whatsapptwilio", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("2763", "digit_whatsappmessagebird", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("2764", "digit_whatsappkarix", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("2765", "digit_whatsappgupshup", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("2766", "digit_whatsapp_gateway", "", "yes");
INSERT INTO `wp_options` VALUES("2767", "digonlylogintrans", "ورود", "yes");
INSERT INTO `wp_options` VALUES("2768", "diglogintrans", "ورود / عضویت", "yes");
INSERT INTO `wp_options` VALUES("2769", "digregistertrans", "ثبت نام", "yes");
INSERT INTO `wp_options` VALUES("2770", "digforgottrans", "رمز عبور خود را فراموش کرده اید؟", "yes");
INSERT INTO `wp_options` VALUES("2771", "digmyaccounttrans", "حساب کاربری من", "yes");
INSERT INTO `wp_options` VALUES("2772", "diglogouttrans", "خروج", "yes");
INSERT INTO `wp_options` VALUES("2773", "dig_messagetemplate", "Your OTP for {NAME} is {OTP}", "yes");
INSERT INTO `wp_options` VALUES("2774", "dig_whatsapp_messagetemplate", "", "yes");
INSERT INTO `wp_options` VALUES("2775", "dig_otp_size", "6", "yes");
INSERT INTO `wp_options` VALUES("2776", "digit_custom_css", "", "yes");
INSERT INTO `wp_options` VALUES("2777", "dig_mobilein_uname", "0", "yes");
INSERT INTO `wp_options` VALUES("2778", "dig_wp_login_inte", "1", "yes");
INSERT INTO `wp_options` VALUES("2779", "dig_redirect_wc_to_dig", "1", "yes");
INSERT INTO `wp_options` VALUES("2780", "dig_mobile_no_formatting", "1", "yes");
INSERT INTO `wp_options` VALUES("2781", "digforgotpass", "1", "yes");
INSERT INTO `wp_options` VALUES("2782", "dig_overwrite_forgotpass_link", "1", "yes");
INSERT INTO `wp_options` VALUES("2783", "dig_enable_registration", "1", "yes");
INSERT INTO `wp_options` VALUES("2784", "dig_show_asterisk", "1", "yes");
INSERT INTO `wp_options` VALUES("2785", "dig_mob_otp_resend_time", "30", "yes");
INSERT INTO `wp_options` VALUES("2786", "dig_use_strongpass", "1", "yes");
INSERT INTO `wp_options` VALUES("2787", "login_reg_success_msg", "1", "yes");
INSERT INTO `wp_options` VALUES("2788", "dig_autofill_wc_billing", "1", "yes");
INSERT INTO `wp_options` VALUES("2789", "dig_reqfieldbilling", "0", "yes");
INSERT INTO `wp_options` VALUES("2790", "enable_createcustomeronorder", "0", "yes");
INSERT INTO `wp_options` VALUES("2791", "defaultuserrole", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("2792", "dig_default_ccode", "Iran", "yes");
INSERT INTO `wp_options` VALUES("2793", "digit_color", "a:23:{s:7:\"bgcolor\";s:7:\"#4cc2fc\";s:13:\"loginboxcolor\";s:19:\"rgba(255,255,255,1)\";s:2:\"sx\";s:1:\"0\";s:2:\"sy\";s:1:\"2\";s:5:\"sblur\";s:1:\"4\";s:7:\"sspread\";s:1:\"0\";s:7:\"sradius\";s:1:\"4\";s:6:\"scolor\";s:18:\"rgba(0, 0, 0, 0.5)\";s:10:\"fontcolor1\";s:16:\"rgba(20,20,20,1)\";s:10:\"fontcolor2\";s:19:\"rgba(255,255,255,1)\";s:9:\"backcolor\";s:13:\"rgba(0,0,0,1)\";s:4:\"type\";s:1:\"1\";s:10:\"left_color\";s:19:\"rgba(255,255,255,1)\";s:14:\"input_bg_color\";s:13:\"rgba(0,0,0,0)\";s:18:\"input_border_color\";s:13:\"rgba(0,0,0,0)\";s:16:\"input_text_color\";s:13:\"rgba(0,0,0,0)\";s:15:\"button_bg_color\";s:13:\"rgba(0,0,0,0)\";s:19:\"signup_button_color\";s:13:\"rgba(0,0,0,0)\";s:26:\"signup_button_border_color\";s:13:\"rgba(0,0,0,0)\";s:17:\"button_text_color\";s:13:\"rgba(0,0,0,0)\";s:24:\"signup_button_text_color\";s:13:\"rgba(0,0,0,0)\";s:12:\"left_bg_size\";s:4:\"auto\";s:16:\"left_bg_position\";s:13:\"Center Center\";}", "yes");
INSERT INTO `wp_options` VALUES("2794", "digit_color_modal", "a:22:{s:7:\"bgcolor\";s:18:\"rgba(6, 6, 6, 0.8)\";s:13:\"loginboxcolor\";s:19:\"rgba(255,255,255,1)\";s:2:\"sx\";s:1:\"0\";s:2:\"sy\";s:1:\"0\";s:5:\"sblur\";s:2:\"20\";s:7:\"sspread\";s:1:\"0\";s:7:\"sradius\";s:1:\"0\";s:6:\"scolor\";s:18:\"rgba(0, 0, 0, 0.3)\";s:10:\"fontcolor1\";s:16:\"rgba(20,20,20,1)\";s:10:\"fontcolor2\";s:19:\"rgba(255,255,255,1)\";s:4:\"type\";s:1:\"1\";s:10:\"left_color\";s:13:\"rgba(0,0,0,1)\";s:14:\"input_bg_color\";s:13:\"rgba(0,0,0,0)\";s:18:\"input_border_color\";s:13:\"rgba(0,0,0,0)\";s:16:\"input_text_color\";s:13:\"rgba(0,0,0,0)\";s:15:\"button_bg_color\";s:13:\"rgba(0,0,0,0)\";s:19:\"signup_button_color\";s:13:\"rgba(0,0,0,0)\";s:26:\"signup_button_border_color\";s:13:\"rgba(0,0,0,0)\";s:17:\"button_text_color\";s:13:\"rgba(0,0,0,0)\";s:24:\"signup_button_text_color\";s:13:\"rgba(0,0,0,0)\";s:12:\"left_bg_size\";s:4:\"auto\";s:16:\"left_bg_position\";s:13:\"Center Center\";}", "yes");
INSERT INTO `wp_options` VALUES("2795", "digits_logo_image", "", "yes");
INSERT INTO `wp_options` VALUES("2796", "digits_bg_image_modal", "", "yes");
INSERT INTO `wp_options` VALUES("2797", "digits_bg_image", "", "yes");
INSERT INTO `wp_options` VALUES("2798", "digits_left_bg_image", "", "yes");
INSERT INTO `wp_options` VALUES("2799", "digits_left_bg_image_modal", "", "yes");
INSERT INTO `wp_options` VALUES("2800", "dig_preset", "0", "yes");
INSERT INTO `wp_options` VALUES("2801", "login_page_footer", "", "yes");
INSERT INTO `wp_options` VALUES("2802", "login_page_footer_text_color", "rgba(255,255,255,1)", "yes");
INSERT INTO `wp_options` VALUES("2803", "digits_myaccount_redirect", "", "yes");
INSERT INTO `wp_options` VALUES("2804", "digits_loginred", "", "yes");
INSERT INTO `wp_options` VALUES("2805", "digits_regred", "", "yes");
INSERT INTO `wp_options` VALUES("2806", "digits_forgotred", "", "yes");
INSERT INTO `wp_options` VALUES("2807", "digits_logoutred", "", "yes");
INSERT INTO `wp_options` VALUES("3523", "blog_category_children", "a:1:{i:155;a:1:{i:0;i:210;}}", "yes");
INSERT INTO `wp_options` VALUES("4160", "dbi_example_plugin_options", "a:1:{s:11:\"income_rate\";s:3:\"120\";}", "yes");
INSERT INTO `wp_options` VALUES("4165", "kelaket_options", "a:2:{s:11:\"income_rate\";s:4:\"2000\";s:10:\"chart_type\";s:4:\"line\";}", "yes");
INSERT INTO `wp_options` VALUES("4546", "new_admin_email", "admin@gmail.com", "yes");
INSERT INTO `wp_options` VALUES("4559", "wpp_settings", "a:4:{s:11:\"news_source\";s:5:\"parsi\";s:9:\"dis_input\";s:21:\"get_field\r\n the_field\";s:12:\"persian_date\";s:6:\"enable\";s:12:\"submenu_move\";s:6:\"enable\";}", "yes");
INSERT INTO `wp_options` VALUES("4560", "widget_parsidate_archive", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("4561", "widget_parsidate_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("4897", "widget_most_commented_posts", "a:2:{i:2;a:2:{s:5:\"title\";s:30:\"پربحث ترین مطالب\";s:6:\"number\";s:1:\"2\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("4903", "theme_mods_dooplay 2.5.5 Theme/dooplay", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:6:\"header\";i:3;s:6:\"footer\";i:4;}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1642886899;s:4:\"data\";a:7:{s:19:\"wp_inactive_widgets\";a:0:{}s:12:\"sidebar-home\";a:0:{}s:14:\"sidebar-movies\";a:0:{}s:15:\"sidebar-tvshows\";a:0:{}s:15:\"sidebar-seasons\";a:0:{}s:13:\"sidebar-posts\";a:0:{}s:12:\"widgets-home\";a:0:{}}}}", "yes");
INSERT INTO `wp_options` VALUES("4904", "dooplay_database", "2.8", "yes");
INSERT INTO `wp_options` VALUES("4905", "dooplay_update_linksmodule", "1", "yes");
INSERT INTO `wp_options` VALUES("4906", "dt_author_slug", "profile", "yes");
INSERT INTO `wp_options` VALUES("4907", "dt_movies_slug", "movies", "yes");
INSERT INTO `wp_options` VALUES("4908", "dt_requests_slug", "requests", "yes");
INSERT INTO `wp_options` VALUES("4909", "dt_tvshows_slug", "tvshows", "yes");
INSERT INTO `wp_options` VALUES("4910", "dt_seasons_slug", "seasons", "yes");
INSERT INTO `wp_options` VALUES("4911", "dt_episodes_slug", "episodes", "yes");
INSERT INTO `wp_options` VALUES("4912", "dt_links_slug", "links", "yes");
INSERT INTO `wp_options` VALUES("4913", "dt_genre_slug", "genre", "yes");
INSERT INTO `wp_options` VALUES("4914", "dt_release_slug", "release", "yes");
INSERT INTO `wp_options` VALUES("4915", "dt_network_slug", "network", "yes");
INSERT INTO `wp_options` VALUES("4916", "dt_studio_slug", "studio", "yes");
INSERT INTO `wp_options` VALUES("4917", "dt_cast_slug", "cast", "yes");
INSERT INTO `wp_options` VALUES("4918", "dt_creator_slug", "creator", "yes");
INSERT INTO `wp_options` VALUES("4919", "dt_director_slug", "director", "yes");
INSERT INTO `wp_options` VALUES("4920", "dt_quality_slug", "quality", "yes");
INSERT INTO `wp_options` VALUES("4921", "_dbmovies_settings", "a:44:{s:8:\"dbmovies\";s:0:\"\";s:10:\"themoviedb\";s:32:\"05902896074695709d7763505bb88b4d\";s:8:\"language\";s:5:\"en-US\";s:6:\"upload\";i:1;s:6:\"genres\";i:1;s:7:\"release\";i:1;s:10:\"autoscroll\";i:1;s:10:\"nospostimp\";i:0;s:8:\"repeated\";i:0;s:8:\"safemode\";i:0;s:17:\"autoscrollresults\";s:3:\"200\";s:9:\"delaytime\";s:4:\"1000\";s:11:\"titlemovies\";s:6:\"{name}\";s:12:\"titletvshows\";s:6:\"{name}\";s:12:\"titleseasons\";s:23:\"{name}: Season {season}\";s:12:\"titlepisodes\";s:26:\"{name}: {season}x{episode}\";s:14:\"content-movies\";s:60:\"<!-- wp:paragraph --><p>{synopsis}</p><!-- /wp:paragraph -->\";s:15:\"content-tvshows\";s:60:\"<!-- wp:paragraph --><p>{synopsis}</p><!-- /wp:paragraph -->\";s:13:\"updatermethod\";s:7:\"wp-ajax\";s:13:\"updatermovies\";i:1;s:12:\"updatershows\";i:1;s:14:\"updaterseasons\";i:1;s:15:\"updaterepisodes\";i:1;s:13:\"request-email\";s:0:\"\";s:11:\"requestsunk\";i:0;s:11:\"reqauto-adm\";i:1;s:11:\"reqauto-edi\";i:1;s:11:\"reqauto-aut\";i:1;s:11:\"reqauto-con\";i:1;s:11:\"reqauto-sub\";i:1;s:11:\"reqauto-unk\";i:0;s:12:\"phptimelimit\";s:3:\"300\";s:14:\"phpmemorylimit\";s:3:\"256\";s:12:\"orderseasons\";s:3:\"ASC\";s:13:\"orderepisodes\";s:3:\"ASC\";s:13:\"pstatusmovies\";s:7:\"publish\";s:14:\"pstatustvshows\";s:7:\"publish\";s:14:\"pstatusseasons\";s:7:\"publish\";s:15:\"pstatusepisodes\";s:7:\"publish\";s:16:\"gutenberg-movies\";i:1;s:17:\"gutenberg-tvshows\";i:1;s:17:\"gutenberg-seasons\";i:1;s:17:\"gutenberg-episode\";i:1;s:15:\"gutenberg-links\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("4922", "_dbmovies_imdbdata", "a:2:{s:4:\"time\";i:1642886838;s:4:\"page\";s:1:\"1\";}", "yes");
INSERT INTO `wp_options` VALUES("4923", "_dooplay_options", "a:156:{s:6:\"online\";b:1;s:14:\"offlinemessage\";s:42:\"We are in maintenance, please try it later\";s:14:\"classic_editor\";s:0:\"\";s:10:\"ganalytics\";s:0:\"\";s:8:\"iperpage\";s:2:\"30\";s:8:\"bperpage\";s:2:\"10\";s:8:\"itopimdb\";s:2:\"50\";s:8:\"pagrange\";s:1:\"2\";s:7:\"permits\";a:5:{i:0;s:4:\"enls\";i:1;s:4:\"esst\";i:2;s:4:\"demj\";i:3;s:4:\"mhtm\";i:4;s:4:\"slgl\";}s:15:\"view_count_mode\";s:7:\"regular\";s:17:\"gcaptchasitekeyv3\";s:0:\"\";s:16:\"gcaptchasecretv3\";s:0:\"\";s:11:\"pageaccount\";s:0:\"\";s:12:\"pagetrending\";s:0:\"\";s:11:\"pageratings\";s:0:\"\";s:11:\"pagecontact\";s:0:\"\";s:11:\"pagetopimdb\";s:0:\"\";s:8:\"pageblog\";s:0:\"\";s:14:\"cachescheduler\";s:5:\"daily\";s:9:\"cachetime\";s:5:\"86400\";s:5:\"style\";s:7:\"default\";s:9:\"max_width\";i:1200;s:9:\"dynamicbg\";b:0;s:4:\"font\";s:6:\"Roboto\";s:9:\"maincolor\";s:7:\"#408BEA\";s:7:\"bgcolor\";s:7:\"#F5F7FA\";s:10:\"featucolor\";s:7:\"#00be08\";s:8:\"fbgcolor\";s:7:\"#000000\";s:7:\"facolor\";s:7:\"#ffffff\";s:7:\"fhcolor\";s:7:\"#408bea\";s:9:\"play_icon\";s:5:\"play1\";s:21:\"sidebar_position_home\";s:5:\"right\";s:25:\"sidebar_position_archives\";s:5:\"right\";s:23:\"sidebar_position_single\";s:5:\"right\";s:13:\"homefullwidth\";s:0:\"\";s:8:\"homepage\";a:2:{s:7:\"enabled\";a:9:{s:6:\"slider\";s:6:\"Slider\";s:13:\"featured-post\";s:15:\"Featured titles\";s:6:\"movies\";s:6:\"Movies\";s:3:\"ads\";s:11:\"Advertising\";s:7:\"tvshows\";s:8:\"TV Shows\";s:7:\"seasons\";s:16:\"TV Show > Season\";s:8:\"episodes\";s:17:\"TV Show > Episode\";s:8:\"top-imdb\";s:8:\"TOP IMDb\";s:4:\"blog\";s:12:\"Blog entries\";}s:8:\"disabled\";a:3:{s:10:\"widgethome\";s:13:\"Genres Widget\";s:13:\"slider-movies\";s:13:\"Slider Movies\";s:14:\"slider-tvshows\";s:15:\"Slider TV Shows\";}}s:8:\"headlogo\";s:0:\"\";s:7:\"favicon\";s:0:\"\";s:9:\"touchlogo\";s:0:\"\";s:14:\"adminloginlogo\";s:0:\"\";s:6:\"footer\";s:6:\"simple\";s:15:\"footercopyright\";s:0:\"\";s:10:\"logofooter\";s:0:\"\";s:10:\"footertext\";s:0:\"\";s:8:\"footerc1\";s:0:\"\";s:8:\"footerc2\";s:0:\"\";s:8:\"footerc3\";s:0:\"\";s:3:\"css\";s:0:\"\";s:8:\"comments\";s:2:\"wp\";s:12:\"commentspage\";s:0:\"\";s:7:\"fbappid\";s:0:\"\";s:6:\"fblang\";s:5:\"en_US\";s:7:\"fbadmin\";s:0:\"\";s:8:\"fbscheme\";s:5:\"light\";s:8:\"fbnumber\";s:2:\"10\";s:11:\"dqshortname\";s:0:\"\";s:14:\"linkslanguages\";s:0:\"\";s:12:\"linksquality\";s:0:\"\";s:20:\"linksfrontpublishers\";a:5:{i:0;s:3:\"adm\";i:1;s:3:\"edt\";i:2;s:3:\"atr\";i:3;s:3:\"ctr\";i:4;s:3:\"sbr\";}s:15:\"linkspublishers\";a:4:{i:0;s:3:\"adm\";i:1;s:3:\"edt\";i:2;s:3:\"atr\";i:3;s:3:\"ctr\";}s:12:\"linksrowshow\";a:6:{i:0;s:3:\"qua\";i:1;s:3:\"lan\";i:2;s:3:\"siz\";i:3;s:3:\"cli\";i:4;s:3:\"add\";i:5;s:3:\"use\";}s:14:\"linkshoweditor\";s:0:\"\";s:12:\"linktimewait\";s:2:\"30\";s:14:\"linkoutputtype\";s:3:\"btn\";s:11:\"linkbtntext\";s:8:\"Continue\";s:16:\"linkbtntextunder\";s:31:\"Click on the button to continue\";s:12:\"linkbtncolor\";s:7:\"#1e73be\";s:10:\"shorteners\";s:0:\"\";s:10:\"auto_embed\";b:1;s:8:\"playajax\";b:1;s:14:\"playajaxmethod\";s:10:\"admin_ajax\";s:12:\"playautoload\";s:0:\"\";s:8:\"playwait\";s:2:\"10\";s:8:\"playauto\";s:0:\"\";s:8:\"playsize\";s:7:\"regular\";s:10:\"playsource\";b:1;s:19:\"playsourcescrolling\";b:1;s:6:\"jwpage\";s:0:\"\";s:6:\"player\";s:4:\"plyr\";s:11:\"playercolor\";s:7:\"#0b7ef4\";s:5:\"jwkey\";s:40:\"IMtAJf5X9E17C1gol8B45QJL5vWOCxYUDyznpA==\";s:6:\"jw8key\";s:48:\"64HPbvSQorQcd52B8XFuhMtEoitbvY/EXJmMBfKcXZQU2Rnn\";s:7:\"jwabout\";s:20:\"Powered by JW Player\";s:6:\"jwlogo\";s:0:\"\";s:10:\"jwposition\";s:0:\"\";s:10:\"fakeplayer\";s:0:\"\";s:12:\"fakebackdrop\";s:0:\"\";s:11:\"fakeoptions\";a:3:{i:0;s:3:\"pla\";i:1;s:3:\"ads\";i:2;s:3:\"qua\";}s:15:\"fakeplayerlinks\";s:0:\"\";s:10:\"welcomesjt\";s:21:\"Welcome to {sitename}\";s:10:\"welcomemsg\";s:57:\"Hello {username}, Thank you for registering at {sitename}\";s:4:\"smtp\";b:0;s:10:\"smtpserver\";s:14:\"smtp.gmail.com\";s:8:\"smtpport\";s:3:\"587\";s:10:\"smtpencryp\";s:3:\"tsl\";s:12:\"smtpfromname\";s:0:\"\";s:13:\"smtpfromemail\";s:0:\"\";s:12:\"smtpusername\";s:0:\"\";s:12:\"smtppassword\";s:0:\"\";s:11:\"report_form\";b:1;s:12:\"contact_form\";b:1;s:13:\"contact_email\";s:15:\"admin@gmail.com\";s:19:\"report_notify_email\";b:1;s:20:\"contact_notify_email\";b:1;s:21:\"reports_numbers_by_ip\";i:10;s:21:\"contact_numbers_by_ip\";i:10;s:9:\"whitelist\";s:0:\"\";s:9:\"blacklist\";s:0:\"\";s:13:\"featuredtitle\";s:15:\"Featured titles\";s:13:\"featureditems\";s:1:\"8\";s:15:\"featuredcontrol\";a:1:{i:0;s:6:\"slider\";}s:18:\"featuredmodorderby\";s:8:\"modified\";s:16:\"featuredmodorder\";s:4:\"DESC\";s:9:\"blogtitle\";s:12:\"Last entries\";s:9:\"blogitems\";s:1:\"5\";s:9:\"blogwords\";s:3:\"180\";s:17:\"autocontentslider\";b:1;s:14:\"sliderpostypes\";s:3:\"all\";s:11:\"slideritems\";s:2:\"10\";s:16:\"slidermodorderby\";s:4:\"date\";s:14:\"slidermodorder\";s:4:\"DESC\";s:13:\"sliderpostids\";s:0:\"\";s:21:\"sliderautoplaycontrol\";s:0:\"\";s:11:\"sliderspeed\";s:0:\"\";s:12:\"topimdbtitle\";s:8:\"TOP IMDb\";s:13:\"topimdblayout\";s:5:\"movtv\";s:12:\"topimdbrangt\";s:2:\"12\";s:12:\"topimdbminvt\";s:3:\"100\";s:12:\"topimdbitems\";s:2:\"10\";s:10:\"movietitle\";s:6:\"Movies\";s:10:\"movieitems\";s:2:\"10\";s:15:\"moviemodcontrol\";a:1:{i:0;s:6:\"slider\";}s:15:\"moviemodorderby\";s:4:\"date\";s:13:\"moviemodorder\";s:4:\"DESC\";s:7:\"tvtitle\";s:8:\"TV Shows\";s:7:\"tvitems\";s:2:\"10\";s:12:\"tvmodcontrol\";a:1:{i:0;s:6:\"slider\";}s:12:\"tvmodorderby\";s:4:\"date\";s:10:\"tvmodorder\";s:4:\"DESC\";s:12:\"seasonstitle\";s:7:\"Seasons\";s:12:\"seasonsitems\";s:2:\"10\";s:17:\"seasonsmodcontrol\";a:1:{i:0;s:6:\"slider\";}s:17:\"seasonsmodorderby\";s:4:\"date\";s:15:\"seasonsmodorder\";s:4:\"DESC\";s:13:\"episodestitle\";s:8:\"Episodes\";s:13:\"episodesitems\";s:2:\"10\";s:18:\"episodesmodcontrol\";a:1:{i:0;s:6:\"slider\";}s:18:\"episodesmodorderby\";s:4:\"date\";s:16:\"episodesmodorder\";s:4:\"DESC\";s:3:\"seo\";s:0:\"\";s:7:\"seoname\";s:0:\"\";s:11:\"seokeywords\";s:0:\"\";s:14:\"seodescription\";s:0:\"\";s:10:\"seogooglev\";s:0:\"\";s:8:\"seobingv\";s:0:\"\";s:10:\"seoyandexv\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("4924", "widget_dtw_content", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("4925", "widget_dtw_content_views", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("4926", "widget_dtw_socialbox", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("4927", "widget_dtw_content_related", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("4928", "widget_dts_content_genres", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("4929", "widget_dtw_mgenres", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("4930", "widget_dtw_mreleases", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("4934", "dooplay-search-nonce", "ef8774cb28", "yes");
INSERT INTO `wp_options` VALUES("4958", "widget_csf_widget_example_1", "a:4:{i:2;a:4:{s:5:\"title\";s:3:\"dsf\";s:8:\"opt-text\";s:21:\"Deasdfault text value\";s:12:\"opt-switcher\";s:1:\"1\";s:12:\"opt-textarea\";s:6:\"dasdas\";}i:3;a:4:{s:5:\"title\";s:3:\"324\";s:8:\"opt-text\";s:18:\"Default text value\";s:12:\"opt-switcher\";s:0:\"\";s:12:\"opt-textarea\";s:3:\"324\";}i:4;a:4:{s:5:\"title\";s:3:\"asd\";s:8:\"opt-text\";s:18:\"Default text value\";s:12:\"opt-switcher\";s:0:\"\";s:12:\"opt-textarea\";s:3:\"asd\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("4959", "widget_textads", "a:2:{i:3;a:5:{s:5:\"title\";s:0:\"\";s:8:\"opt-text\";s:0:\"\";s:14:\"opt-repeater-1\";s:0:\"\";s:12:\"opt-switcher\";s:0:\"\";s:12:\"opt-textarea\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("4960", "widget__textads", "a:2:{i:2;a:5:{s:5:\"title\";s:0:\"\";s:8:\"opt-text\";s:0:\"\";s:14:\"opt-repeater-1\";s:0:\"\";s:12:\"opt-switcher\";s:0:\"\";s:12:\"opt-textarea\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("4961", "widget_widget_textads", "a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:8:\"opt-text\";s:0:\"\";s:12:\"opt-switcher\";s:0:\"\";s:12:\"opt-textarea\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("4962", "widget_csf_widget_example_2", "a:2:{i:2;a:4:{s:5:\"title\";s:3:\"asd\";s:8:\"opt-text\";s:18:\"Default text value\";s:12:\"opt-switcher\";s:0:\"\";s:12:\"opt-textarea\";s:3:\"asd\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("4963", "widget_csf_widget_text_ads", "a:2:{i:2;a:3:{s:5:\"title\";s:23:\"تبلیغات متنی\";s:9:\"ads_price\";s:68:\"https://community.cloudflare.com/t/i-suddenly-got-a-520-error/118876\";s:8:\"text_ads\";a:2:{i:0;a:3:{s:14:\"text_ads_title\";s:33:\"محل تبلیغ متنی شما\";s:13:\"text_ads_desc\";s:37:\"متن زیر تبلیغات متنی\";s:13:\"text_ads_link\";s:7:\"rlt.com\";}i:1;a:3:{s:14:\"text_ads_title\";s:24:\"محل تبلیغ شما\";s:13:\"text_ads_desc\";s:0:\"\";s:13:\"text_ads_link\";s:1:\"#\";}}}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("4966", "widget_csf_widget_updated_series", "a:2:{i:2;a:4:{s:5:\"title\";s:26:\"آپدیت سریال ها\";s:12:\"widget_style\";s:6:\"style2\";s:10:\"serial_cat\";s:1:\"8\";s:5:\"count\";s:1:\"5\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("4967", "widget_csf_widget_250top_films_imdb", "a:2:{i:2;a:2:{s:5:\"title\";s:29:\"۲۵۰ فیلم برتر IMDb\";s:5:\"count\";s:2:\"10\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("4968", "widget_csf_widget_tabbed_genre", "a:2:{i:3;a:3:{s:5:\"title\";s:12:\"ژانرها\";s:10:\"serial_cat\";s:1:\"8\";s:8:\"film_cat\";s:1:\"6\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("4971", "widget_csf_widget_ads", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("5012", "widget_csf_widget_250top_series_imdb", "a:2:{i:2;a:2:{s:5:\"title\";s:31:\"۲۵۰ سریال برتر IMDb\";s:5:\"count\";s:2:\"10\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("5024", "widget_csf_widget_carousel", "a:3:{i:4;a:5:{s:5:\"title\";s:30:\"جدیدترین فیلم ها\";s:4:\"icon\";s:23:\"fa fa-clapperboard-play\";s:5:\"count\";s:2:\"15\";s:7:\"archive\";s:1:\"0\";s:8:\"film_cat\";s:0:\"\";}i:5;a:5:{s:5:\"title\";s:45:\"فیلم های که حتما باید دید\";s:4:\"icon\";s:4:\"film\";s:5:\"count\";s:2:\"10\";s:7:\"archive\";s:1:\"0\";s:8:\"film_cat\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("5033", "widget_csf_widget_boxoffice", "a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:4:\"icon\";s:0:\"\";s:5:\"count\";s:0:\"\";s:8:\"film_cat\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("5034", "widget_csf_widget_box_office", "a:3:{i:2;a:4:{s:5:\"title\";s:17:\"جدول فروش\";s:4:\"icon\";s:14:\"receipt-cutoff\";s:5:\"count\";s:1:\"3\";s:8:\"film_cat\";s:4:\"1013\";}i:3;a:4:{s:5:\"title\";s:17:\"باکس آفیس\";s:4:\"icon\";s:0:\"\";s:5:\"count\";s:1:\"5\";s:8:\"film_cat\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("5095", "elementor_active_kit", "1056", "yes");
INSERT INTO `wp_options` VALUES("5098", "elementor_version", "3.11.5", "yes");
INSERT INTO `wp_options` VALUES("5099", "elementor_install_history", "a:11:{s:5:\"3.5.4\";i:1643131624;s:5:\"3.5.5\";i:1643914291;s:5:\"3.6.5\";i:1653317765;s:5:\"3.6.6\";i:1654967233;s:5:\"3.6.7\";i:1657983680;s:5:\"3.7.7\";i:1664190971;s:5:\"3.7.8\";i:1665570087;s:5:\"3.8.0\";i:1667940813;s:6:\"3.11.1\";i:1677053309;s:6:\"3.11.4\";i:1678791500;s:6:\"3.11.5\";i:1678791515;}", "yes");
INSERT INTO `wp_options` VALUES("5101", "_elementor_installed_time", "1643116975", "yes");
INSERT INTO `wp_options` VALUES("5102", "elementor_remote_info_library", "a:3:{s:10:\"types_data\";a:4:{s:5:\"block\";a:2:{s:10:\"categories\";a:27:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:3:\"faq\";i:9;s:8:\"features\";i:10;s:6:\"footer\";i:11;s:7:\"Gallery\";i:12;s:6:\"header\";i:13;s:4:\"hero\";i:14;s:9:\"portfolio\";i:15;s:7:\"pricing\";i:16;s:15:\"product archive\";i:17;s:5:\"Quote\";i:18;s:15:\"Service Details\";i:19;s:8:\"services\";i:20;s:11:\"single page\";i:21;s:11:\"single post\";i:22;s:14:\"single product\";i:23;s:5:\"stats\";i:24;s:9:\"subscribe\";i:25;s:4:\"team\";i:26;s:12:\"testimonials\";}s:4:\"sets\";a:5:{i:0;s:11:\"Boxing Club\";i:1;s:19:\"Business Consultant\";i:2;s:16:\"Marketing Agency\";i:3;s:9:\"Wireframe\";i:4;s:15:\"Workshop Center\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}s:2:\"lb\";a:1:{s:10:\"categories\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}}}s:10:\"categories\";a:27:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:3:\"faq\";i:9;s:8:\"features\";i:10;s:6:\"footer\";i:11;s:7:\"Gallery\";i:12;s:6:\"header\";i:13;s:4:\"hero\";i:14;s:9:\"portfolio\";i:15;s:7:\"pricing\";i:16;s:15:\"product archive\";i:17;s:5:\"Quote\";i:18;s:15:\"Service Details\";i:19;s:8:\"services\";i:20;s:11:\"single page\";i:21;s:11:\"single post\";i:22;s:14:\"single product\";i:23;s:5:\"stats\";i:24;s:9:\"subscribe\";i:25;s:4:\"team\";i:26;s:12:\"testimonials\";}s:9:\"templates\";a:825:{i:0;a:18:{s:4:\"tmpl\";i:1280;s:2:\"id\";i:22403;s:5:\"title\";s:40:\"Hello Bar | Subscribe | Aesthetic Clinic\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/aesthetic-clinic-19.jpg\";s:12:\"tmpl_created\";i:1647354307;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/hello-bar-subscribe-aesthetic-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:48:\"[\"Barbershop\",\"Business\",\"Discount\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:1;a:18:{s:4:\"tmpl\";i:1281;s:2:\"id\";i:22410;s:5:\"title\";s:32:\"Fly-In | Discount | Hair Stylist\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/hair-stylist-20.jpg\";s:12:\"tmpl_created\";i:1647354614;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-discount-hair-stylist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:32:\"[\"Barbershop\",\"Discount\",\"Hair\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:2;a:18:{s:4:\"tmpl\";i:1285;s:2:\"id\";i:22440;s:5:\"title\";s:32:\"Classic | Subscribe | Shoe Store\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/shoes-store-21.jpg\";s:12:\"tmpl_created\";i:1647418620;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-subscribe-shoe-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:37:\"[\"Ecommerce\",\"Marketing\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:3;a:18:{s:4:\"tmpl\";i:1286;s:2:\"id\";i:22446;s:5:\"title\";s:37:\"Full Screen | Subscribe | Denim Store\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/denim-store-22.jpg\";s:12:\"tmpl_created\";i:1647419614;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/full-screen-subscribe-denim-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:35:\"[\"Ecommerce\",\"Fashion\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:4;a:18:{s:4:\"tmpl\";i:1287;s:2:\"id\";i:22452;s:5:\"title\";s:37:\"Fly-In | Subscribe | Pizza Restaurant\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/pizza-restaurant-23.jpg\";s:12:\"tmpl_created\";i:1647420733;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-subscribe-pizza-restaurant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:19:\"[\"Business\",\"Food\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:5;a:18:{s:4:\"tmpl\";i:1288;s:2:\"id\";i:22458;s:5:\"title\";s:38:\"Full Screen | Subscribe | Fashion Shop\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/fashion-shop-24.jpg\";s:12:\"tmpl_created\";i:1647426379;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-subscribe-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:31:\"[\"Ecommerce\",\"Fashion\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:6;a:18:{s:4:\"tmpl\";i:1289;s:2:\"id\";i:22464;s:5:\"title\";s:32:\"Fly-In | Contact | Makeup Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/makeup-studio-25.jpg\";s:12:\"tmpl_created\";i:1647427026;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-contact-makeup-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:22:\"[\"Business\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:7;a:18:{s:4:\"tmpl\";i:1290;s:2:\"id\";i:22470;s:5:\"title\";s:32:\"Fly-In | Contact | Design Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/design-studio-26.jpg\";s:12:\"tmpl_created\";i:1647428250;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-contact-design-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:39:\"[\"Business\",\"Contact\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:8;a:18:{s:4:\"tmpl\";i:1291;s:2:\"id\";i:22480;s:5:\"title\";s:27:\"Classic | CTA | MasterClass\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/master-class-27.jpg\";s:12:\"tmpl_created\";i:1647428474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-masterclass/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"cta\",\"Magazine\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:9;a:18:{s:4:\"tmpl\";i:1292;s:2:\"id\";i:22489;s:5:\"title\";s:29:\"Classic | CTA | Music Concert\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/music-concert-29.jpg\";s:12:\"tmpl_created\";i:1647429738;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-music-concert/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"cta\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:10;a:18:{s:4:\"tmpl\";i:1293;s:2:\"id\";i:22495;s:5:\"title\";s:27:\"Classic | CTA | Music Album\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/music-album-30.jpg\";s:12:\"tmpl_created\";i:1647430056;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-music-album/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Ba\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:11;a:18:{s:4:\"tmpl\";i:1294;s:2:\"id\";i:22501;s:5:\"title\";s:37:\"Fly-In | CTA | Photography Exhibition\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/photography-exhibition-31.jpg\";s:12:\"tmpl_created\";i:1647430512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-cta-photography-exhibition/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:33:\"[\"cta\",\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:12;a:18:{s:4:\"tmpl\";i:1295;s:2:\"id\";i:22507;s:5:\"title\";s:34:\"Classic | CTA | Clothing Shop Sale\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/clothing-shop-sale-32.jpg\";s:12:\"tmpl_created\";i:1647430774;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-cta-clothing-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:35:\"[\"Ecommerce\",\"Fashion\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:13;a:18:{s:4:\"tmpl\";i:1296;s:2:\"id\";i:22486;s:5:\"title\";s:30:\"Classic | CTA | Shop Promotion\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/shop-promotion-28.jpg\";s:12:\"tmpl_created\";i:1647430951;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-shop-promotion/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"cta\",\"Magazine\",\"Photography\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:14;a:18:{s:4:\"tmpl\";i:1297;s:2:\"id\";i:22516;s:5:\"title\";s:32:\"Fly-In | CTA | Glasses Shop Sale\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/glasses-shop-sale-33.jpg\";s:12:\"tmpl_created\";i:1647431136;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-cta-glasses-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:30:\"[\"Business\",\"cta\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:15;a:18:{s:4:\"tmpl\";i:1298;s:2:\"id\";i:22522;s:5:\"title\";s:30:\"Fly-In | Discount | Skate Shop\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/50-skate-shop-Discount.jpg\";s:12:\"tmpl_created\";i:1647434058;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-discount-skate-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:32:\"[\"Discount\",\"Ecommerce\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:16;a:18:{s:4:\"tmpl\";i:1299;s:2:\"id\";i:22532;s:5:\"title\";s:43:\"Classic | Subscription | Basketball Academy\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/21-basketball-academy-Subscription.jpg\";s:12:\"tmpl_created\";i:1647434608;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/classic-subscription-basketball-academy/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Education\",\"Marketing\",\"Sport\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:17;a:18:{s:4:\"tmpl\";i:1300;s:2:\"id\";i:22543;s:5:\"title\";s:38:\"Classic | Discount | Veterinary Clinic\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/veterinery-clinic-small.jpg\";s:12:\"tmpl_created\";i:1647435581;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/classic-discount-veterinary-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Discount\",\"Pets\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:18;a:18:{s:4:\"tmpl\";i:1301;s:2:\"id\";i:22553;s:5:\"title\";s:39:\"Classic | Contact | Business Consulting\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/27-business-consulting-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647439935;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/classic-contact-business-consulting/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Business\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:19;a:18:{s:4:\"tmpl\";i:1302;s:2:\"id\";i:22562;s:5:\"title\";s:28:\"Classic | Contact | Handyman\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/handyman-small.jpg\";s:12:\"tmpl_created\";i:1647440333;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-contact-handyman/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:20;a:18:{s:4:\"tmpl\";i:1303;s:2:\"id\";i:22573;s:5:\"title\";s:40:\"Classic | Discount | Online Fashion Shop\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/31-online-fashion-shop-Discount.jpg\";s:12:\"tmpl_created\";i:1647462549;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-online-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Discount\",\"Ecommerce\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:21;a:18:{s:4:\"tmpl\";i:1304;s:2:\"id\";i:22583;s:5:\"title\";s:36:\"Fly-In | Discount | Personal Trainer\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/personal-trainer-small.jpg\";s:12:\"tmpl_created\";i:1647503781;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-discount-personal-trainer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Discount\",\"Sport\",\"Training\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:22;a:18:{s:4:\"tmpl\";i:1305;s:2:\"id\";i:22592;s:5:\"title\";s:41:\"Classic | Contact | Illustrator Portfolio\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/illustrator-protfolio-small.jpg\";s:12:\"tmpl_created\";i:1647504218;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-contact-illustrator-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:49:\"[\"Contact\",\"Creative Portfolio\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:23;a:18:{s:4:\"tmpl\";i:1306;s:2:\"id\";i:22602;s:5:\"title\";s:46:\"Bottom Bar | Discount | Handmade Ceramics Shop\";s:9:\"thumbnail\";s:91:\"https://library.elementor.com/wp-content/uploads/2022/03/handmade-ceramic-shop-36-small.jpg\";s:12:\"tmpl_created\";i:1647507007;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/bottom-bar-discount-handmade-ceramics-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:48:\"[\"Business\",\"cta\",\"Ecommerce\",\"Interior Design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:24;a:18:{s:4:\"tmpl\";i:1307;s:2:\"id\";i:22612;s:5:\"title\";s:51:\"Classic | Contact | Classic Car Restoration Company\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/restoration-car-shop-37-small.jpg\";s:12:\"tmpl_created\";i:1647507310;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:153:\"https://library.elementor.com/popups/classic-contact-classic-car-restoration-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Booking\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:25;a:18:{s:4:\"tmpl\";i:1308;s:2:\"id\";i:22621;s:5:\"title\";s:30:\"Classic | Booking | Life Coach\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/38-life-coach-Booking.jpg\";s:12:\"tmpl_created\";i:1647508596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-booking-life-coach/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Booking\",\"Business\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:26;a:18:{s:4:\"tmpl\";i:1309;s:2:\"id\";i:22632;s:5:\"title\";s:42:\"Classic |  Subscription | Merchandise Shop\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/Merchandise-Shop-39-small.jpg\";s:12:\"tmpl_created\";i:1647509196;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-subscription-merchandise-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Ecommerce\",\"Marketing\",\"Shop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:27;a:18:{s:4:\"tmpl\";i:1310;s:2:\"id\";i:22643;s:5:\"title\";s:48:\"Fly-In | Contact | Non-Governmental Organization\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/NGO-41-small.jpg\";s:12:\"tmpl_created\";i:1647509528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:150:\"https://library.elementor.com/popups/fly-in-contact-non-governmental-organization/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:28;a:18:{s:4:\"tmpl\";i:1311;s:2:\"id\";i:22654;s:5:\"title\";s:35:\"Hello Bar | Contact | Family Doctor\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/family-doctor-44-small.jpg\";s:12:\"tmpl_created\";i:1647509732;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/hello-bar-contact-family-doctor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:31:\"[\"Contact\",\"Health\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:29;a:18:{s:4:\"tmpl\";i:1312;s:2:\"id\";i:22663;s:5:\"title\";s:36:\"Classic | Subscription | Sports Blog\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/45-sport-blog-Subscription.jpg\";s:12:\"tmpl_created\";i:1647509908;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-sports-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Blog\",\"Sport\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:30;a:18:{s:4:\"tmpl\";i:1313;s:2:\"id\";i:22673;s:5:\"title\";s:30:\"Hello Bar | Booking | Event DJ\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/DJ-service-46-small.jpg\";s:12:\"tmpl_created\";i:1647510160;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/hello-bar-booking-event-dj/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:31:\"[\"Booking\",\"Events\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:31;a:18:{s:4:\"tmpl\";i:1314;s:2:\"id\";i:22684;s:5:\"title\";s:36:\"Fly-In | Discount | Cleaning Company\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/51-cleaning-company-Discount.jpg\";s:12:\"tmpl_created\";i:1647510546;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-discount-cleaning-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Discount\",\"Offer\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:32;a:18:{s:4:\"tmpl\";i:1315;s:2:\"id\";i:22693;s:5:\"title\";s:28:\"Fly-In | Contact | Carpenter\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/carpenter-53-small.jpg\";s:12:\"tmpl_created\";i:1647511972;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-contact-carpenter/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:22:\"[\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:33;a:18:{s:4:\"tmpl\";i:1316;s:2:\"id\";i:22703;s:5:\"title\";s:31:\"Classic | Booking | Yoga Studio\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/55-yoga-studio-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647512209;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-booking-yoga-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:30:\"[\"Booking\",\"Contact\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:34;a:18:{s:4:\"tmpl\";i:1317;s:2:\"id\";i:22714;s:5:\"title\";s:37:\"Classic | Discount | Pet Care Company\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/56-Pet-Care-Discount.jpg\";s:12:\"tmpl_created\";i:1647513031;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-discount-pet-care-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:17:\"[\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:35;a:18:{s:4:\"tmpl\";i:1318;s:2:\"id\";i:22725;s:5:\"title\";s:38:\"Fly-In | Discount | Online Coffee Shop\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/online-coffee-shop-57-small.jpg\";s:12:\"tmpl_created\";i:1647513325;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/fly-in-discount-online-coffee-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:29:\"[\"Food\",\"Offer\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:36;a:18:{s:4:\"tmpl\";i:1319;s:2:\"id\";i:22737;s:5:\"title\";s:44:\"Fly-In | CTA | Moving &#038; Storage Company\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/moving-company-59-small.jpg\";s:12:\"tmpl_created\";i:1647520956;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-cta-moving-storage-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:37;a:18:{s:4:\"tmpl\";i:1320;s:2:\"id\";i:22749;s:5:\"title\";s:47:\"Classic | Contact | Industrial Design Portfolio\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/60-industrial-design-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647528116;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/classic-contact-industrial-design-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:40:\"[\"Contact\",\"Interior Design\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:38;a:18:{s:4:\"tmpl\";i:1321;s:2:\"id\";i:22759;s:5:\"title\";s:25:\"Classic | Contact | Drone\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/drone-61-small.jpg\";s:12:\"tmpl_created\";i:1647528899;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/classic-contact-drone/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:39;a:18:{s:4:\"tmpl\";i:1322;s:2:\"id\";i:22768;s:5:\"title\";s:46:\"Full Screen | Menu | Fashion Stylist Portfolio\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/62-Fashion-Stylist-Menu.jpg\";s:12:\"tmpl_created\";i:1647529434;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/full-screen-menu-fashion-stylist-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:31:\"[\"Fashion\",\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:40;a:18:{s:4:\"tmpl\";i:1323;s:2:\"id\";i:22780;s:5:\"title\";s:31:\"Fly-In | CTA | Landscape Design\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/64-Landscape-Design-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647530337;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-cta-landscape-design/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"cta\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:41;a:18:{s:4:\"tmpl\";i:1324;s:2:\"id\";i:22790;s:5:\"title\";s:48:\"Bottom Bar  | Contact | Architecture Photography\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/architecture-photography-65-small.jpg\";s:12:\"tmpl_created\";i:1647532358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/bottom-bar-contact-architecture-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:26:\"[\"Architecture\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:42;a:18:{s:4:\"tmpl\";i:1325;s:2:\"id\";i:22800;s:5:\"title\";s:41:\"Fly-In  | CTA | Speech-Language Therapist\";s:9:\"thumbnail\";s:103:\"https://library.elementor.com/wp-content/uploads/2022/03/66-Speech-Language-Therapist-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647532720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/fly-in-cta-speech-language-therapist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:25:\"[\"cta\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:43;a:18:{s:4:\"tmpl\";i:1326;s:2:\"id\";i:22812;s:5:\"title\";s:35:\"Full Screen | Verification | Winery\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/67-Winery-Verification.jpg\";s:12:\"tmpl_created\";i:1647761384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/full-screen-verification-winery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:24:\"[\"Alert\",\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:44;a:18:{s:4:\"tmpl\";i:1327;s:2:\"id\";i:22822;s:5:\"title\";s:36:\"Fly-In | Subscription | Nutritionist\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/nutritionist-69-small.jpg\";s:12:\"tmpl_created\";i:1647762620;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-subscription-nutritionist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Food\",\"Health\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:45;a:18:{s:4:\"tmpl\";i:1328;s:2:\"id\";i:22833;s:5:\"title\";s:40:\"Classic | Subscription | App &#038; SaaS\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/app-70-small.jpg\";s:12:\"tmpl_created\";i:1647762955;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-subscription-app-saas/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:14:\"[\"App\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:46;a:18:{s:4:\"tmpl\";i:1329;s:2:\"id\";i:22844;s:5:\"title\";s:41:\"Bottom Bar | Discount | Handmade Cupcakes\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/72-Handmade-Cupcakes-Discount.jpg\";s:12:\"tmpl_created\";i:1647763350;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/bottom-bar-discount-handmade-cupcakes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:21:\"[\"Food\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:47;a:18:{s:4:\"tmpl\";i:1330;s:2:\"id\";i:22855;s:5:\"title\";s:40:\"Bottom Bar | Subscription | Fashion Blog\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/fashion-blog-75-small.jpg\";s:12:\"tmpl_created\";i:1647763907;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/bottom-bar-subscription-fashion-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:30:\"[\"Blog\",\"Fashion\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:48;a:18:{s:4:\"tmpl\";i:1331;s:2:\"id\";i:22866;s:5:\"title\";s:28:\"Fly-In | CTA | Private Tutor\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/private-tutor-77-small.jpg\";s:12:\"tmpl_created\";i:1647764062;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-cta-private-tutor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:49;a:18:{s:4:\"tmpl\";i:1332;s:2:\"id\";i:22876;s:5:\"title\";s:30:\"Classic | CTA | Tennis Academy\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/78-Tennis-Academy-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647765192;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-tennis-academy/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:50;a:18:{s:4:\"tmpl\";i:1333;s:2:\"id\";i:22887;s:5:\"title\";s:31:\"Fly-In | CTA | Shared Workspace\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/shared-workspace-79-small.jpg\";s:12:\"tmpl_created\";i:1647765419;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-cta-shared-workspace/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"Business\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:51;a:18:{s:4:\"tmpl\";i:1334;s:2:\"id\";i:22899;s:5:\"title\";s:30:\"Bottom Bar | CTA | Art Gallery\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/80-Art-Gallery-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647765652;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/bottom-bar-cta-art-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:13:\"[\"Art\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:52;a:18:{s:4:\"tmpl\";i:1335;s:2:\"id\";i:22910;s:5:\"title\";s:44:\"Fly-In | Subscription | Hiking Tours Company\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/hiking-tours-company-81-small.jpg\";s:12:\"tmpl_created\";i:1647765835;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/fly-in-subscription-hiking-tours-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:29:\"[\"Subscribe\",\"Travel\",\"Trip\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:53;a:18:{s:4:\"tmpl\";i:1336;s:2:\"id\";i:22921;s:5:\"title\";s:26:\"Classic | CTA | Music Band\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/music-band-82-small.jpg\";s:12:\"tmpl_created\";i:1647769462;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/classic-cta-music-band/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Marketing\",\"Music\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:54;a:18:{s:4:\"tmpl\";i:1337;s:2:\"id\";i:22935;s:5:\"title\";s:35:\"Classic | CTA | Computer Technician\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/comuter-technician-83-small.jpg\";s:12:\"tmpl_created\";i:1647769843;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/classic-cta-computer-technician/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:18:\"[\"cta\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:55;a:18:{s:4:\"tmpl\";i:1338;s:2:\"id\";i:22945;s:5:\"title\";s:37:\"Classic | Discount | Delivery Company\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/delivery-company-88-small.jpg\";s:12:\"tmpl_created\";i:1647770834;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-discount-delivery-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Discount\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:56;a:18:{s:4:\"tmpl\";i:1339;s:2:\"id\";i:22959;s:5:\"title\";s:29:\"Classic | Discount | Eco Shop\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/echo-shop-89-small.jpg\";s:12:\"tmpl_created\";i:1647771211;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-discount-eco-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Discount\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:57;a:18:{s:4:\"tmpl\";i:1340;s:2:\"id\";i:22972;s:5:\"title\";s:54:\"Fly-In | Subscription | Health &#038; Mindfulness Blog\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/health-blog-91-small.jpg\";s:12:\"tmpl_created\";i:1647771461;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/fly-in-subscription-health-mindfulness-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:21:\"[\"Health\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:58;a:18:{s:4:\"tmpl\";i:1341;s:2:\"id\";i:22982;s:5:\"title\";s:31:\"Full Screen | Menu | Art Museum\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/art-museum-112-small.jpg\";s:12:\"tmpl_created\";i:1647771938;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/full-screen-menu-art-museum/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:59;a:18:{s:4:\"tmpl\";i:1342;s:2:\"id\";i:22992;s:5:\"title\";s:40:\"Classic | Discount | Urban Clothing Shop\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/health-blog-91-small-1.jpg\";s:12:\"tmpl_created\";i:1647773067;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-urban-clothing-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Discount\",\"Ecommerce\",\"Fashion\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:60;a:18:{s:4:\"tmpl\";i:1343;s:2:\"id\";i:23004;s:5:\"title\";s:60:\"Full Screen | Menu | Digital &#038; Technology Design School\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-design-tech-school-small-1.jpg\";s:12:\"tmpl_created\";i:1647773366;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:155:\"https://library.elementor.com/popups/full-screen-menu-digital-technology-design-school/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:61;a:18:{s:4:\"tmpl\";i:1344;s:2:\"id\";i:23015;s:5:\"title\";s:62:\"Bottom Bar | Contact | Digital &#038; Technology Design School\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-design-tech-school-small.jpg\";s:12:\"tmpl_created\";i:1647773492;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:157:\"https://library.elementor.com/popups/bottom-bar-contact-digital-technology-design-school/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:23:\"[\"Contact\",\"Portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:62;a:18:{s:4:\"tmpl\";i:1345;s:2:\"id\";i:23025;s:5:\"title\";s:32:\"Full Screen | Menu | Flower Shop\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/flower-shop-small.jpg\";s:12:\"tmpl_created\";i:1647773820;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/full-screen-menu-flower-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:63;a:18:{s:4:\"tmpl\";i:1346;s:2:\"id\";i:23037;s:5:\"title\";s:36:\"Classic | Subscription | Flower Shop\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/flower-shop-small-1.jpg\";s:12:\"tmpl_created\";i:1647773949;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-flower-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Discount\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:64;a:18:{s:4:\"tmpl\";i:1347;s:2:\"id\";i:23056;s:5:\"title\";s:48:\"Classic | Discount | Health &#038; Fitness eBook\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/fitness-ebook-small-1.jpg\";s:12:\"tmpl_created\";i:1647774468;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-discount-health-fitness-ebook/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:65;a:18:{s:4:\"tmpl\";i:1348;s:2:\"id\";i:23067;s:5:\"title\";s:37:\"Fly-In | Menu | Baby Sleep Consultant\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/baby-sleep-consultant-small-1.jpg\";s:12:\"tmpl_created\";i:1647778954;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/baby-sleep-consultant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:66;a:18:{s:4:\"tmpl\";i:1349;s:2:\"id\";i:23077;s:5:\"title\";s:46:\"Classic | Subscription | Baby Sleep Consultant\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/baby-sleep-consultant-small.jpg\";s:12:\"tmpl_created\";i:1647779074;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/classic-subscription-baby-sleep-consultant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:12:\"[\"Discount\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:67;a:18:{s:4:\"tmpl\";i:1350;s:2:\"id\";i:23090;s:5:\"title\";s:33:\"Full Screen | Menu | Luxury Hotel\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/luxury-hotel-small.jpg\";s:12:\"tmpl_created\";i:1647779390;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/full-screen-menu-luxury-hotel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:68;a:18:{s:4:\"tmpl\";i:1351;s:2:\"id\";i:23100;s:5:\"title\";s:31:\"Fly-In | Booking | Luxury Hotel\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/luxury-hotel-small-1.jpg\";s:12:\"tmpl_created\";i:1647779500;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-booking-luxury-hotel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Booking\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:69;a:18:{s:4:\"tmpl\";i:1352;s:2:\"id\";i:23109;s:5:\"title\";s:38:\"Full Screen | Menu | Design Conference\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/design-conference-35-small.jpg\";s:12:\"tmpl_created\";i:1647779675;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-menu-design-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:70;a:18:{s:4:\"tmpl\";i:1353;s:2:\"id\";i:23120;s:5:\"title\";s:41:\"Full Screen | Booking | Design Conference\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/design-conference-35-small-1.jpg\";s:12:\"tmpl_created\";i:1647779793;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/full-screen-booking-design-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:35:\"[\"Booking\",\"Conference\",\"Creative\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:71;a:18:{s:4:\"tmpl\";i:1354;s:2:\"id\";i:23129;s:5:\"title\";s:29:\"Slide-In | Menu | VR Headsets\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/VR-headset-small.jpg\";s:12:\"tmpl_created\";i:1647781211;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/slide-in-menu-vr-headsets/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:72;a:18:{s:4:\"tmpl\";i:1355;s:2:\"id\";i:23139;s:5:\"title\";s:31:\"Classic | Contact | VR Headsets\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/VR-headset-small-1.jpg\";s:12:\"tmpl_created\";i:1647781384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-contact-vr-headsets/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:73;a:18:{s:4:\"tmpl\";i:1356;s:2:\"id\";i:23149;s:5:\"title\";s:38:\"Slide-In | Menu | Portrait Photography\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/48-portrair-photography-Menu.jpg\";s:12:\"tmpl_created\";i:1647782336;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/slide-in-menu-portrait-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:74;a:18:{s:4:\"tmpl\";i:1357;s:2:\"id\";i:23159;s:5:\"title\";s:47:\"Hello Bar | Subscription | Portrait Photography\";s:9:\"thumbnail\";s:97:\"https://library.elementor.com/wp-content/uploads/2022/03/48-portrair-photography-Subscription.jpg\";s:12:\"tmpl_created\";i:1647782478;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/hello-bar-subscription-portrait-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:34:\"[\"Blog\",\"Photography\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:75;a:18:{s:4:\"tmpl\";i:1358;s:2:\"id\";i:23169;s:5:\"title\";s:32:\"Full Screen | Menu | English Pub\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/49-englisg-pub-Menu.jpg\";s:12:\"tmpl_created\";i:1647782664;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/full-screen-menu-english-pub/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:76;a:18:{s:4:\"tmpl\";i:1359;s:2:\"id\";i:23179;s:5:\"title\";s:32:\"Classic | Discount | English Pub\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/49-englisg-pub-Discount.jpg\";s:12:\"tmpl_created\";i:1647782796;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-discount-english-pub/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:20:\"[\"Discount\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:77;a:18:{s:4:\"tmpl\";i:1360;s:2:\"id\";i:23189;s:5:\"title\";s:27:\"Full Screen | Menu | Singer\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/58-Music-Artist-Menu.jpg\";s:12:\"tmpl_created\";i:1647783070;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/full-screen-menu-singer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:29:\"[\"Fullscreen\",\"menu\",\"Music\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:78;a:18:{s:4:\"tmpl\";i:1361;s:2:\"id\";i:23200;s:5:\"title\";s:31:\"Classic | Subscription | Singer\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/58-Music-Artist-Subscription.jpg\";s:12:\"tmpl_created\";i:1647783249;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-subscription-singer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Music\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:79;a:18:{s:4:\"tmpl\";i:1362;s:2:\"id\";i:23210;s:5:\"title\";s:38:\"Full Screen | Menu | Virtual Assistant\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/virtual-assistnt-73-small.jpg\";s:12:\"tmpl_created\";i:1647784292;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-menu-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:80;a:18:{s:4:\"tmpl\";i:1363;s:2:\"id\";i:23223;s:5:\"title\";s:39:\"Hello Bar | Contact | Virtual Assistant\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/73-Virtual-Assistant-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647784616;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-contact-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:37:\"[\"Contact\",\"Psychologist\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:81;a:18:{s:4:\"tmpl\";i:1364;s:2:\"id\";i:23234;s:5:\"title\";s:32:\"Slide-In  | Menu | Personal Chef\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/74-Personal-Chef-Menu.jpg\";s:12:\"tmpl_created\";i:1647798194;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/slide-in-menu-personal-chef/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:82;a:18:{s:4:\"tmpl\";i:1365;s:2:\"id\";i:23244;s:5:\"title\";s:29:\"Classic | CTA | Personal Chef\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/74-Personal-Chef-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647798297;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-personal-chef/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Booking\",\"Chef\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:83;a:18:{s:4:\"tmpl\";i:1366;s:2:\"id\";i:23254;s:5:\"title\";s:31:\"Full Screen | Menu | Food Truck\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/food-truck-76-small-1.jpg\";s:12:\"tmpl_created\";i:1647798447;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/full-screen-menu-food-truck/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:84;a:18:{s:4:\"tmpl\";i:1367;s:2:\"id\";i:23265;s:5:\"title\";s:30:\"Fly-In | Discount | Food Truck\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/food-truck-76-small.jpg\";s:12:\"tmpl_created\";i:1647798657;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-discount-food-truck/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Discount\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:85;a:18:{s:4:\"tmpl\";i:1369;s:2:\"id\";i:23323;s:5:\"title\";s:28:\"Classic | CTA | Black Friday\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-6-Small.jpg\";s:12:\"tmpl_created\";i:1647855505;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-cta-black-friday/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:86;a:18:{s:4:\"tmpl\";i:1370;s:2:\"id\";i:23329;s:5:\"title\";s:29:\"Slide-In | CTA | Black Friday\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-5-Small.jpg\";s:12:\"tmpl_created\";i:1647855865;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/slide-in-cta-black-friday/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:87;a:18:{s:4:\"tmpl\";i:1371;s:2:\"id\";i:23335;s:5:\"title\";s:31:\"Slide-In | CTA | Black Friday 1\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-1-Small.jpg\";s:12:\"tmpl_created\";i:1647856357;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/slide-in-cta-black-friday-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:88;a:18:{s:4:\"tmpl\";i:1372;s:2:\"id\";i:23341;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 2\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-3-Small.jpg\";s:12:\"tmpl_created\";i:1647856493;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:89;a:18:{s:4:\"tmpl\";i:1373;s:2:\"id\";i:23347;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 3\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-2-Small.jpg\";s:12:\"tmpl_created\";i:1647856891;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:90;a:18:{s:4:\"tmpl\";i:1374;s:2:\"id\";i:23354;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 4\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-4-Small.jpg\";s:12:\"tmpl_created\";i:1647856996;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:91;a:18:{s:4:\"tmpl\";i:1375;s:2:\"id\";i:23394;s:5:\"title\";s:27:\"Classic | CTA | Halloween 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-3-Small.jpg\";s:12:\"tmpl_created\";i:1647857351;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-halloween-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:31:\"[\"cta\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:92;a:18:{s:4:\"tmpl\";i:1376;s:2:\"id\";i:23401;s:5:\"title\";s:33:\"Slide-In | Discount | Halloween 2\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-2-Small.jpg\";s:12:\"tmpl_created\";i:1647857567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-halloween-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:36:\"[\"Discount\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:93;a:18:{s:4:\"tmpl\";i:1377;s:2:\"id\";i:23407;s:5:\"title\";s:33:\"Slide-In | Discount | Halloween 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-1-Small.jpg\";s:12:\"tmpl_created\";i:1647857814;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-halloween-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:36:\"[\"Discount\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:94;a:18:{s:4:\"tmpl\";i:1378;s:2:\"id\";i:23416;s:5:\"title\";s:31:\"Fly-In | Discount | Halloween 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-5-Small.jpg\";s:12:\"tmpl_created\";i:1647858024;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-discount-halloween-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:44:\"[\"Discount\",\"Ecommerce\",\"Halloween\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:95;a:18:{s:4:\"tmpl\";i:1379;s:2:\"id\";i:23422;s:5:\"title\";s:36:\"Classic | Subscription | Halloween 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-4-Small.jpg\";s:12:\"tmpl_created\";i:1647858246;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-halloween-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:48:\"[\"Discount\",\"Ecommerce\",\"Halloween\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:96;a:18:{s:4:\"tmpl\";i:1380;s:2:\"id\";i:23471;s:5:\"title\";s:28:\"Slide-In | CTA | Christmas 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-2-Small.jpg\";s:12:\"tmpl_created\";i:1647859193;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/slide-in-cta-christmas-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Christmas\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:97;a:18:{s:4:\"tmpl\";i:1381;s:2:\"id\";i:23477;s:5:\"title\";s:28:\"Slide-In | CTA | Christmas 2\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-4-Small.jpg\";s:12:\"tmpl_created\";i:1647859838;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/slide-in-cta-christmas-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Christmas\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:98;a:18:{s:4:\"tmpl\";i:1382;s:2:\"id\";i:23483;s:5:\"title\";s:26:\"Fly-In | CTA | Christmas 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-1-Small.jpg\";s:12:\"tmpl_created\";i:1647860157;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/fly-in-cta-christmas-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Christmas\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:99;a:18:{s:4:\"tmpl\";i:1383;s:2:\"id\";i:23489;s:5:\"title\";s:33:\"Slide-In | Discount | Christmas 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-5-Small.jpg\";s:12:\"tmpl_created\";i:1647860302;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-christmas-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:31:\"[\"Christmas\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:100;a:18:{s:4:\"tmpl\";i:1384;s:2:\"id\";i:23496;s:5:\"title\";s:32:\"Classic | Discount | Christmas 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-3-Small.jpg\";s:12:\"tmpl_created\";i:1647860454;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-discount-christmas-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Christmas\",\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:101;a:18:{s:4:\"tmpl\";i:1385;s:2:\"id\";i:23523;s:5:\"title\";s:30:\"Classic | CTA | Valentines Day\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-2-Small.jpg\";s:12:\"tmpl_created\";i:1647860912;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-valentines-day/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"cta\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:102;a:18:{s:4:\"tmpl\";i:1386;s:2:\"id\";i:23529;s:5:\"title\";s:39:\"Hello Bar | Discount | Valentines Day 2\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-1-Small.jpg\";s:12:\"tmpl_created\";i:1647861064;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-discount-valentines-day-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:30:\"[\"Discount\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:103;a:18:{s:4:\"tmpl\";i:1387;s:2:\"id\";i:23536;s:5:\"title\";s:32:\"Classic | CTA | Valentines Day 3\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-3-Small.jpg\";s:12:\"tmpl_created\";i:1647861536;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-cta-valentines-day-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"cta\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:104;a:18:{s:4:\"tmpl\";i:1388;s:2:\"id\";i:23586;s:5:\"title\";s:51:\"Fly-In | Subscribe | Health &#038; Wellness Company\";s:9:\"thumbnail\";s:103:\"https://library.elementor.com/wp-content/uploads/2022/03/35-Subscribe-Health-Wellness-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647862008;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/fly-in-subscribe-health-wellness-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:24:\"[\"Business\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:105;a:18:{s:4:\"tmpl\";i:1389;s:2:\"id\";i:23592;s:5:\"title\";s:34:\"Classic | Subscribe | Tech Company\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/36-Subscribe-Tech-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647866706;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-subscribe-tech-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"Marketing\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:106;a:18:{s:4:\"tmpl\";i:1390;s:2:\"id\";i:23598;s:5:\"title\";s:36:\"Classic | Contact Us | Fight Classes\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/37-Contact-Us-Fight-Classes-Small.jpg\";s:12:\"tmpl_created\";i:1647866869;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-contact-us-fight-classes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:107;a:18:{s:4:\"tmpl\";i:1391;s:2:\"id\";i:23611;s:5:\"title\";s:31:\"Classic | CTA | Mochi Shop Sale\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2022/03/39-Click-Through-Mochi-Shop-Sale-Small.jpg\";s:12:\"tmpl_created\";i:1647867750;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-cta-mochi-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"cta\",\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:108;a:18:{s:4:\"tmpl\";i:1392;s:2:\"id\";i:23618;s:5:\"title\";s:28:\"Classic | CTA | Fashion Shop\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2022/03/40-Click-Through-Fashion-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1647868251;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-cta-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:109;a:18:{s:4:\"tmpl\";i:1393;s:2:\"id\";i:23624;s:5:\"title\";s:29:\"Fly-In | Login | Tech Company\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/41-Login-Tech-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647868704;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/fly-in-login-tech-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:9:\"[\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:110;a:18:{s:4:\"tmpl\";i:1394;s:2:\"id\";i:23630;s:5:\"title\";s:36:\"Fly-In | Verification | Liquor Store\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/42-Verification-Liquor-Store-Small.jpg\";s:12:\"tmpl_created\";i:1647870308;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-verification-liquor-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:16:\"[\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:111;a:18:{s:4:\"tmpl\";i:1395;s:2:\"id\";i:23636;s:5:\"title\";s:39:\"Hello Bar | Subscribe | Online Magazine\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/44-Subscribe-Online-Magazine-Small.jpg\";s:12:\"tmpl_created\";i:1647870465;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-subscribe-online-magazine/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:20:\"[\"Blog\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:112;a:18:{s:4:\"tmpl\";i:1396;s:2:\"id\";i:23642;s:5:\"title\";s:27:\"Fly-In | Login | Health Spa\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/43-Login-Health-Spa-Small.jpg\";s:12:\"tmpl_created\";i:1647872427;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/fly-in-login-health-spa/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Login\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:113;a:18:{s:4:\"tmpl\";i:1397;s:2:\"id\";i:23648;s:5:\"title\";s:33:\"Fly-In | Verification | Wine Shop\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/45-Verification-Wine-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1647872627;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/fly-in-verification-wine-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:16:\"[\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:114;a:18:{s:4:\"tmpl\";i:899;s:2:\"id\";i:11839;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/09/Header_small.png\";s:12:\"tmpl_created\";i:1569430015;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:43:\"[\"creative portfolio\",\"header\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:189;s:11:\"trend_index\";i:20;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:115;a:18:{s:4:\"tmpl\";i:1421;s:2:\"id\";i:24235;s:5:\"title\";s:24:\"Ladydog Club &#8211; NFT\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/05/Ladydog_Club.jpg\";s:12:\"tmpl_created\";i:1651525072;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/ladydog-club-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:116;a:18:{s:4:\"tmpl\";i:1422;s:2:\"id\";i:24166;s:5:\"title\";s:15:\"Dot &#8211; NFT\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2022/05/Dot-250_280.jpg\";s:12:\"tmpl_created\";i:1651525117;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/lp/dot-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:117;a:18:{s:4:\"tmpl\";i:1423;s:2:\"id\";i:24191;s:5:\"title\";s:28:\"Cosmic Neighbors &#8211; NFT\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Cosmic_Neighbors-250_280.jpg\";s:12:\"tmpl_created\";i:1651525124;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/cosmic-neighbors-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:118;a:18:{s:4:\"tmpl\";i:1424;s:2:\"id\";i:24255;s:5:\"title\";s:30:\"Happy Food Friends &#8211; NFT\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/05/Featured_Image.jpg\";s:12:\"tmpl_created\";i:1651525475;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/happy-food-friends-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:119;a:18:{s:4:\"tmpl\";i:1443;s:2:\"id\";i:24599;s:5:\"title\";s:27:\"Wireframe &#8211; Courses 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Courses-1.jpg\";s:12:\"tmpl_created\";i:1653989626;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/wireframe-courses-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:180:\"[\"About\",\"Academy\",\"Booking\",\"Business\",\"Course Online\",\"Features\",\"Footer\",\"Landing Pages\",\"Online Service\",\"Professional\",\"School\",\"Services\",\"Subscribe\",\"Teacher\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:120;a:18:{s:4:\"tmpl\";i:1444;s:2:\"id\";i:24614;s:5:\"title\";s:28:\"Wireframe &#8211; Services 1\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-1-2.jpg\";s:12:\"tmpl_created\";i:1653990084;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:139:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Form\",\"Header\",\"Landing Pages\",\"Online Service\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:121;a:18:{s:4:\"tmpl\";i:1445;s:2:\"id\";i:24629;s:5:\"title\";s:28:\"Wireframe &#8211; Services 2\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-2-2.jpg\";s:12:\"tmpl_created\";i:1653990132;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:123:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Form\",\"Gallery\",\"Landing Pages\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:122;a:18:{s:4:\"tmpl\";i:1446;s:2:\"id\";i:24644;s:5:\"title\";s:27:\"Wireframe &#8211; Webinar 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Webinar-1.jpg\";s:12:\"tmpl_created\";i:1653990164;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/wireframe-webinar-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:177:\"[\"About\",\"Academy\",\"Booking\",\"Conference\",\"Course Online\",\"Education\",\"Features\",\"Footer\",\"Form\",\"Landing Pages\",\"Online Event\",\"Online Service\",\"Subscribe\",\"Virtual\",\"Webinar\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:123;a:18:{s:4:\"tmpl\";i:1447;s:2:\"id\";i:24655;s:5:\"title\";s:28:\"Wireframe &#8211; Services 3\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-3-2.jpg\";s:12:\"tmpl_created\";i:1653990198;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:143:\"[\"About\",\"Agency\",\"Business\",\"Contact\",\"Footer\",\"Form\",\"Gallery\",\"Landing Pages\",\"Portfolio\",\"Professional\",\"Project\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:124;a:18:{s:4:\"tmpl\";i:1448;s:2:\"id\";i:24677;s:5:\"title\";s:28:\"Wireframe &#8211; Services 4\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-4.jpg\";s:12:\"tmpl_created\";i:1653990233;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:102:\"[\"About\",\"Business\",\"Contact\",\"Footer\",\"Form\",\"Landing Pages\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:125;a:18:{s:4:\"tmpl\";i:1449;s:2:\"id\";i:24687;s:5:\"title\";s:28:\"Wireframe &#8211; Products 1\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Products-1.jpg\";s:12:\"tmpl_created\";i:1653990273;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-products-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:128:\"[\"About\",\"Booking\",\"Business\",\"Clients\",\"Ecommerce\",\"Features\",\"Footer\",\"Landing Pages\",\"Products\",\"Sales\",\"Shop\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:126;a:18:{s:4:\"tmpl\";i:1450;s:2:\"id\";i:24706;s:5:\"title\";s:28:\"Wireframe &#8211; Services 5\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-5.jpg\";s:12:\"tmpl_created\";i:1653990322;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:149:\"[\"About\",\"Booking\",\"Consulting\",\"Contact\",\"Doctor\",\"Footer\",\"Form\",\"Header\",\"Landing Pages\",\"Online Service\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:127;a:18:{s:4:\"tmpl\";i:1451;s:2:\"id\";i:23604;s:5:\"title\";s:38:\"Classic | Subscribe | Nail Polish Shop\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2022/03/38-Subscribe-Nail-Polish-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1660205114;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/classic-subscribe-nail-polish-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:20:\"[\"Blog\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:128;a:18:{s:4:\"tmpl\";i:1452;s:2:\"id\";i:23047;s:5:\"title\";s:46:\"Fly-In | Contact | Health &#038; Fitness eBook\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/fitness-ebook-small.jpg\";s:12:\"tmpl_created\";i:1660205149;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/fly-in-contact-health-fitness-ebook/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Contact\",\"Ebook\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:129;a:18:{s:4:\"tmpl\";i:1199;s:2:\"id\";i:18839;s:5:\"title\";s:27:\"Hello Bar | CTA | eCommerce\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/05/350x250.png\";s:12:\"tmpl_created\";i:1621870603;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/hello-bar-cta-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:41:\"[\"Ecommerce\",\"Online Shop\",\"Sale\",\"Shop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:130;a:18:{s:4:\"tmpl\";i:1247;s:2:\"id\";i:21907;s:5:\"title\";s:50:\"Fly-In | Team Details  | Electronic Music Festival\";s:9:\"thumbnail\";s:104:\"https://library.elementor.com/wp-content/uploads/2022/03/Kit-8-electronic-music-festival-CTA-image-1.jpg\";s:12:\"tmpl_created\";i:1646660881;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:157:\"https://library.elementor.com/popups/fly-in-team-details-popup-electronic-music-festival/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:131;a:18:{s:4:\"tmpl\";i:1253;s:2:\"id\";i:22162;s:5:\"title\";s:46:\"Full Screen | Menu | Electronic Music Festival\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/8-music-festival-Team-Details.jpg\";s:12:\"tmpl_created\";i:1647272934;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:154:\"https://library.elementor.com/popups/full-screen-menu-popup-electronic-music-festival/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:132;a:18:{s:4:\"tmpl\";i:1254;s:2:\"id\";i:22172;s:5:\"title\";s:45:\"Classic | Discount | Health &#038; Beauty Spa\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/health-beauty-spa-small.jpg\";s:12:\"tmpl_created\";i:1647273547;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/classic-discount-popup-health-beauty-spa/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:36:\"[\"Hair\",\"Health\",\"Sales\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:133;a:18:{s:4:\"tmpl\";i:1255;s:2:\"id\";i:22183;s:5:\"title\";s:44:\"Hello Bar | CTA | Environmental Organization\";s:9:\"thumbnail\";s:104:\"https://library.elementor.com/wp-content/uploads/2022/03/11-Environmental-Organization-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647274384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:152:\"https://library.elementor.com/popups/hello-bar-cta-popup-environmental-organization/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:134;a:18:{s:4:\"tmpl\";i:1256;s:2:\"id\";i:22195;s:5:\"title\";s:39:\"Classic | Discount | Italian Restaurant\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/restaurant-small.jpg\";s:12:\"tmpl_created\";i:1647329432;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:147:\"https://library.elementor.com/popups/classic-discount-popup-italian-restaurant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Restaurant\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:135;a:18:{s:4:\"tmpl\";i:1257;s:2:\"id\";i:22210;s:5:\"title\";s:45:\"Bottom Bar | Discount | Technology Conference\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/tech-conference-small.jpg\";s:12:\"tmpl_created\";i:1647330423;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:153:\"https://library.elementor.com/popups/bottom-bar-discount-popup-technology-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:38:\"[\"Conference\",\"Sales\",\"Save the Date\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:136;a:18:{s:4:\"tmpl\";i:1258;s:2:\"id\";i:22221;s:5:\"title\";s:32:\"Hello Bar | Menu | Tattoo Studio\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/tattoo-studio-small-1.jpg\";s:12:\"tmpl_created\";i:1647330705;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/hello-bar-menu-popup-tattoo-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:17:\"[\"Header\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:137;a:18:{s:4:\"tmpl\";i:1259;s:2:\"id\";i:22231;s:5:\"title\";s:37:\"Full Screen | Booking | Tattoo Studio\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/tattoo-studio-small.jpg\";s:12:\"tmpl_created\";i:1647331823;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-booking-popup-tattoo-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:32:\"[\"Booking\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:138;a:18:{s:4:\"tmpl\";i:1260;s:2:\"id\";i:22251;s:5:\"title\";s:34:\"Classic | Discount | Dental Clinic\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/dental-clinic-small.jpg\";s:12:\"tmpl_created\";i:1647332171;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-popup-dental-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:30:\"[\"Health\",\"Marketing\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:139;a:18:{s:4:\"tmpl\";i:1261;s:2:\"id\";i:22261;s:5:\"title\";s:34:\"Slide-In | Contact | Makeup Artist\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/20-Makeup-Artist-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647333946;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/slide-in-contact-popup-makeup-artist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:140;a:18:{s:4:\"tmpl\";i:1262;s:2:\"id\";i:22271;s:5:\"title\";s:24:\"Fly-In | CTA | Headphone\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/headphones-1-small.jpg\";s:12:\"tmpl_created\";i:1647334784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-cta-popup-headphone/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:41:\"[\"cta\",\"Ecommerce\",\"Marketing\",\"Product\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:141;a:18:{s:4:\"tmpl\";i:1263;s:2:\"id\";i:22277;s:5:\"title\";s:29:\"Classic | CTA | Online Course\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/online-course-2.jpg\";s:12:\"tmpl_created\";i:1647337110;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/classic-cta-popup-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:35:\"[\"Course Online\",\"cta\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:142;a:18:{s:4:\"tmpl\";i:1264;s:2:\"id\";i:22283;s:5:\"title\";s:40:\"Bottom Bar | Contact | Virtual Assistant\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/virtual-assistant-3.jpg\";s:12:\"tmpl_created\";i:1647337517;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/bottom-bar-contact-popup-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:143;a:18:{s:4:\"tmpl\";i:1265;s:2:\"id\";i:22289;s:5:\"title\";s:32:\"Fly-In | Contact | Private Tutor\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/private-tutor-4.jpg\";s:12:\"tmpl_created\";i:1647337676;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/fly-in-contact-popup-private-tutor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:27:\"[\"Contact\",\"Course Online\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:144;a:18:{s:4:\"tmpl\";i:1266;s:2:\"id\";i:22295;s:5:\"title\";s:31:\"Classic |  Login | Login Travel\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/login-travel-6.jpg\";s:12:\"tmpl_created\";i:1647339467;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-login-popup-login-travel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:9:\"[\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:145;a:18:{s:4:\"tmpl\";i:1267;s:2:\"id\";i:22301;s:5:\"title\";s:36:\"Full Screen | Login | Login Business\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/login-business-7.jpg\";s:12:\"tmpl_created\";i:1647339782;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/full-screen-login-popup-login-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:16:\"[\"Login\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:146;a:18:{s:4:\"tmpl\";i:1268;s:2:\"id\";i:22307;s:5:\"title\";s:28:\"Classic | Login | Login Blog\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/login-blog-8.jpg\";s:12:\"tmpl_created\";i:1647339986;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-login-popup-login-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Blog\",\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:147;a:18:{s:4:\"tmpl\";i:1269;s:2:\"id\";i:22313;s:5:\"title\";s:31:\"Classic | Login | Login Fashion\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/login-fashion-9.jpg\";s:12:\"tmpl_created\";i:1647340204;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-login-popup-login-fashion/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Fashion\",\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:148;a:18:{s:4:\"tmpl\";i:1270;s:2:\"id\";i:22319;s:5:\"title\";s:40:\"Classic |  Login | Login Design Platform\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/03/login-design-platform-10.jpg\";s:12:\"tmpl_created\";i:1647340531;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:147:\"https://library.elementor.com/popups/classic-login-popup-login-design-platform/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"Design\",\"Login\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:149;a:18:{s:4:\"tmpl\";i:1271;s:2:\"id\";i:22325;s:5:\"title\";s:36:\"Fly-In | Contact | Digital Marketing\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-marketing-11.jpg\";s:12:\"tmpl_created\";i:1647340770;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/fly-in-contact-popup-digital-marketing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:51:\"[\"Business\",\"Contact\",\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:150;a:18:{s:4:\"tmpl\";i:1272;s:2:\"id\";i:22331;s:5:\"title\";s:36:\"Fly-In | CTA | Dog Cat Food Delivery\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/dog-cat-food-delivery-5.jpg\";s:12:\"tmpl_created\";i:1647341069;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/fly-in-cta-popup-dog-cat-food-delivery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:33:\"[\"cta\",\"Delivery Service\",\"Pets\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:151;a:18:{s:4:\"tmpl\";i:1273;s:2:\"id\";i:22337;s:5:\"title\";s:37:\"Full Screen | Contact | Design Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/design-studio-12.jpg\";s:12:\"tmpl_created\";i:1647341370;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-contact-popup-design-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:39:\"[\"Business\",\"Contact\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:152;a:18:{s:4:\"tmpl\";i:1274;s:2:\"id\";i:22343;s:5:\"title\";s:44:\"Classic | Contact | Support Product Platform\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2022/03/support-13.jpg\";s:12:\"tmpl_created\";i:1647341972;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/classic-contact-support-product-platform/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Contact\",\"Support\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:153;a:18:{s:4:\"tmpl\";i:1275;s:2:\"id\";i:22371;s:5:\"title\";s:38:\"Full Screen | Contact | Small Business\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/small-business-14.jpg\";s:12:\"tmpl_created\";i:1647342508;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-contact-small-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:40:\"[\"Business\",\"Contact\",\"Interior Design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:154;a:18:{s:4:\"tmpl\";i:1276;s:2:\"id\";i:22377;s:5:\"title\";s:31:\"Classic | Contact | Online Shop\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/online-shop-15.jpg\";s:12:\"tmpl_created\";i:1647352786;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-contact-online-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:155;a:18:{s:4:\"tmpl\";i:1277;s:2:\"id\";i:22383;s:5:\"title\";s:40:\"Classic | Booking | Children Optometrist\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/children-optometrist-16.jpg\";s:12:\"tmpl_created\";i:1647352963;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-booking-children-optometrist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:53:\"[\"Booking\",\"Business\",\"Contact\",\"Education\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:156;a:18:{s:4:\"tmpl\";i:1278;s:2:\"id\";i:22389;s:5:\"title\";s:28:\"Fly-In | Contact | Open Week\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2022/03/open-week17.jpg\";s:12:\"tmpl_created\";i:1647353281;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-contact-open-week/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:34:\"[\"Business\",\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:157;a:18:{s:4:\"tmpl\";i:1279;s:2:\"id\";i:22397;s:5:\"title\";s:43:\"Full Screen | CTA | Plant Pots Online Store\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/plant-pots-online-store-18.jpg\";s:12:\"tmpl_created\";i:1647353429;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-cta-plant-pots-online-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:33:\"[\"Ecommerce\",\"Marketing\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:158;a:18:{s:4:\"tmpl\";i:1054;s:2:\"id\";i:15414;s:5:\"title\";s:32:\"Classic | Contact | Dance Studio\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/10/PopUp.jpg\";s:12:\"tmpl_created\";i:1603180596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-contact-dance-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:762;s:11:\"trend_index\";i:650;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:159;a:18:{s:4:\"tmpl\";i:1398;s:2:\"id\";i:23687;s:5:\"title\";s:32:\"Pizza Promotion &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/48-Pizza-Promotion.jpg\";s:12:\"tmpl_created\";i:1649670575;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/pizza-promotion-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:92:\"[\"Business\",\"Cooking\",\"Delivery\",\"Discount\",\"Fast Food\",\"Food\",\"Landing Pages\",\"Restaurant\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:160;a:18:{s:4:\"tmpl\";i:1400;s:2:\"id\";i:23751;s:5:\"title\";s:33:\"Baby Sleep Webinar &#8211; Events\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/04/63-Baby-Sleep-Webinar.jpg\";s:12:\"tmpl_created\";i:1649676065;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/baby-sleep-webinar-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:227:\"[\"Baby\",\"Booking\",\"Business\",\"Children\",\"Course Online\",\"Education\",\"Events\",\"Health\",\"Landing Pages\",\"Life Coach\",\"Lifestyle\",\"Online Event\",\"Online Service\",\"Parenting\",\"Professional\",\"Remote\",\"Services\",\"Training\",\"Webinar\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:161;a:18:{s:4:\"tmpl\";i:1401;s:2:\"id\";i:23776;s:5:\"title\";s:34:\"Ski Hotel Promotion &#8211; Travel\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/04/64-Ski-Hotel-Promotion.jpg\";s:12:\"tmpl_created\";i:1649691720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/ski-hotel-promotion-travel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Travel\";s:4:\"tags\";s:118:\"[\"Accommodation\",\"Booking\",\"Discount. Landing Pages\",\"Lifestyle\",\"Luxury\",\"Services\",\"Spa\",\"Travel\",\"Trip\",\"Vacation\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:162;a:18:{s:4:\"tmpl\";i:1402;s:2:\"id\";i:23804;s:5:\"title\";s:30:\"Cake Delivery &#8211; Business\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/04/67-Cake-Delivery.jpg\";s:12:\"tmpl_created\";i:1649692909;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/cake-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:101:\"[\"Bakery\",\"Business\",\"Cake\",\"Cooking\",\"Delivery\",\"Discount\",\"Food\",\"Landing Pages\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:163;a:18:{s:4:\"tmpl\";i:1403;s:2:\"id\";i:23832;s:5:\"title\";s:32:\"Furniture Store &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/87-Furniture-Store.jpg\";s:12:\"tmpl_created\";i:1649694812;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/furniture-store-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:232:\"[\"Architecture\",\"Art\",\"Business\",\"Construction\",\"Coupon\",\"Creative\",\"Decor\",\"Designer\",\"Discount\",\"Fashion\",\"Furniture Design\",\"Home\",\"House\",\"Interior Design\",\"Landing Pages\",\"Lifestyle\",\"Products\",\"Professional\",\"Services\",\"Shop\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:164;a:18:{s:4:\"tmpl\";i:1404;s:2:\"id\";i:23746;s:5:\"title\";s:22:\"Nails &#8211; Business\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2022/04/62-Nails-1.jpg\";s:12:\"tmpl_created\";i:1649704635;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/lp/nails-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:173:\"[\"Art\",\"Beauty\",\"Business\",\"Colorful\",\"Cosmetics\",\"Creative\",\"Design\",\"Discount\",\"Fashion\",\"Girly\",\"Landing Pages\",\"Lifestyle\",\"Manicure\",\"Modern\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:165;a:18:{s:4:\"tmpl\";i:1405;s:2:\"id\";i:23846;s:5:\"title\";s:29:\"Music Festival &#8211; Events\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/04/88-Music-Festival.jpg\";s:12:\"tmpl_created\";i:1649707763;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/music-festival-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:128:\"[\"Author\",\"Booking\",\"Business\",\"Creative\",\"Discount\",\"Events\",\"Landing Pages\",\"Music\",\"Online\",\"Online Event\",\"Party\",\"Virtual\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:166;a:18:{s:4:\"tmpl\";i:1406;s:2:\"id\";i:23872;s:5:\"title\";s:40:\"Fashion Styling Course &#8211; Education\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/89-Fashion-Styling-Course.jpg\";s:12:\"tmpl_created\";i:1649708569;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/fashion-styling-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:173:\"[\"Aesthetic\",\"Art\",\"Beauty\",\"Business\",\"Course Online\",\"Creative\",\"Discount\",\"Education\",\"Fashion\",\"Landing Pages\",\"Lifestyle\",\"Online\",\"Online Service\",\"Stylist\",\"Virtual\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:167;a:18:{s:4:\"tmpl\";i:1407;s:2:\"id\";i:23897;s:5:\"title\";s:33:\"Bags Online Shop &#8211; Business\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/04/90-Bags-Online-Shop.jpg\";s:12:\"tmpl_created\";i:1649709513;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/bags-online-shop-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:170:\"[\"Art\",\"Bag\",\"Business\",\"Creative\",\"Design\",\"Discount\",\"Fashion\",\"Landing Pages\",\"Lifestyle\",\"Luxury\",\"Modern\",\"Online\",\"Online Shop\",\"Products\",\"Sales\",\"Shop\",\"Stylist\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:168;a:18:{s:4:\"tmpl\";i:1408;s:2:\"id\";i:23932;s:5:\"title\";s:32:\"Cooking Academy &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/91-Cooking-Academy.jpg\";s:12:\"tmpl_created\";i:1649710216;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/cooking-academy-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:145:\"[\"Academy\",\"Booking\",\"Business\",\"Chef\",\"Cooking\",\"Education\",\"Food\",\"Free Trial\",\"Landing Pages\",\"Professional\",\"School\",\"Teacher\",\"Testimonial\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:169;a:18:{s:4:\"tmpl\";i:1409;s:2:\"id\";i:23970;s:5:\"title\";s:45:\"Ophthalmology Medical Clinic &#8211; Business\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/04/92-Ophthalmology-Medical-Clinic.jpg\";s:12:\"tmpl_created\";i:1649711096;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/lp/ophthalmology-medical-clinic-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:165:\"[\"About\",\"Business\",\"Care\",\"Consulting\",\"Eye\",\"Free Trial\",\"Glasses\",\"Health\",\"Landing Pages\",\"Lifestyle\",\"Medical\",\"Modern\",\"Optometrist\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:170;a:18:{s:4:\"tmpl\";i:1425;s:2:\"id\";i:24331;s:5:\"title\";s:24:\"Wireframe &#8211; Home 1\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-1.jpg\";s:12:\"tmpl_created\";i:1653988363;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/wireframe-home-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:102:\"[\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Homepage\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:171;a:18:{s:4:\"tmpl\";i:674;s:2:\"id\";i:8505;s:5:\"title\";s:11:\"404 page 01\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/001.jpg\";s:12:\"tmpl_created\";i:1526415501;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:533;s:11:\"trend_index\";i:222;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:172;a:18:{s:4:\"tmpl\";i:1218;s:2:\"id\";i:20792;s:5:\"title\";s:26:\"Luxury Car &#8211; Product\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/11/250x280-1.jpg\";s:12:\"tmpl_created\";i:1636903770;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/lp/luxury-car-product/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:54:\"[\"car\",\"Ecommerce\",\"Landing Pages\",\"Luxury\",\"Product\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:173;a:18:{s:4:\"tmpl\";i:1428;s:2:\"id\";i:24398;s:5:\"title\";s:25:\"Wireframe &#8211; About 1\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-1.jpg\";s:12:\"tmpl_created\";i:1653988534;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:83:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Professional\",\"Services\",\"Team\"]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:174;a:18:{s:4:\"tmpl\";i:675;s:2:\"id\";i:8511;s:5:\"title\";s:11:\"404 page 02\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/002.jpg\";s:12:\"tmpl_created\";i:1526415528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-02/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:347;s:11:\"trend_index\";i:155;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:175;a:18:{s:4:\"tmpl\";i:1204;s:2:\"id\";i:20208;s:5:\"title\";s:49:\"Alternative Medicine Acupuncture &#8211; Business\";s:9:\"thumbnail\";s:112:\"https://library.elementor.com/wp-content/uploads/2021/10/Alternative-Medicine-Acupuncture-Business-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633880557;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/lp/alternative-medicine-acupuncture-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:47:\"[\"Health\",\"Landing Pages\",\"Medical\",\"Services\"]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:176;a:18:{s:4:\"tmpl\";i:991;s:2:\"id\";i:13413;s:5:\"title\";s:33:\"Classic | Contact | Online Course\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Help.jpg\";s:12:\"tmpl_created\";i:1587474761;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-contact-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:530;s:11:\"trend_index\";i:369;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:177;a:18:{s:4:\"tmpl\";i:1053;s:2:\"id\";i:15272;s:5:\"title\";s:32:\"Classic | Contact | Psychologist\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/09/PopUp.png\";s:12:\"tmpl_created\";i:1600170487;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-contact-psychologist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:578;s:11:\"trend_index\";i:312;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:178;a:18:{s:4:\"tmpl\";i:1433;s:2:\"id\";i:24477;s:5:\"title\";s:27:\"Wireframe &#8211; Gallery 2\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Gallery-2.jpg\";s:12:\"tmpl_created\";i:1653988835;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-gallery-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:82:\"[\"Business\",\"Contact\",\"Design\",\"Footer\",\"Gallery\",\"Header\",\"Portfolio\",\"Services\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:179;a:18:{s:4:\"tmpl\";i:672;s:2:\"id\";i:8512;s:5:\"title\";s:11:\"404 page 03\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/003.jpg\";s:12:\"tmpl_created\";i:1526415449;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-03/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:450;s:11:\"trend_index\";i:375;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:180;a:18:{s:4:\"tmpl\";i:1205;s:2:\"id\";i:20233;s:5:\"title\";s:32:\"Art Magazine &#8211; Coming Soon\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/10/Art-Magazine-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633881371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/art-magazine-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:48:\"[\"Art\",\"Coming Soon\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:181;a:18:{s:4:\"tmpl\";i:671;s:2:\"id\";i:8513;s:5:\"title\";s:11:\"404 page 04\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/004.jpg\";s:12:\"tmpl_created\";i:1526415417;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-04/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:420;s:11:\"trend_index\";i:176;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:182;a:18:{s:4:\"tmpl\";i:1214;s:2:\"id\";i:20539;s:5:\"title\";s:31:\"Design Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2021/10/Design-Blog-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1634022706;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/design-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:47:\"[\"Blog\",\"Coming Soon\",\"Design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:183;a:18:{s:4:\"tmpl\";i:1224;s:2:\"id\";i:21013;s:5:\"title\";s:24:\"Restaurant &#8211; About\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/12/7-About-Restaurant.jpg\";s:12:\"tmpl_created\";i:1638795588;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/restaurant-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:36:\"[\"About\",\"Chef\",\"Food\",\"Restaurant\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:184;a:18:{s:4:\"tmpl\";i:992;s:2:\"id\";i:13402;s:5:\"title\";s:29:\"Classic | CTA | Online Course\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2020/04/Popup-Course-Completed.jpg\";s:12:\"tmpl_created\";i:1587474772;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:619;s:11:\"trend_index\";i:582;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:185;a:18:{s:4:\"tmpl\";i:676;s:2:\"id\";i:8514;s:5:\"title\";s:11:\"404 Page 05\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/005.jpg\";s:12:\"tmpl_created\";i:1526415558;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-05/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:419;s:11:\"trend_index\";i:220;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:186;a:18:{s:4:\"tmpl\";i:1206;s:2:\"id\";i:20254;s:5:\"title\";s:41:\"Digital Marketing Agency &#8211; Business\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/10/Digital-Marketing-Agency-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633882427;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/lp/digital-marketing-agency-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:65:\"[\"Agency\",\"Business\",\"Digital Agency\",\"Landing Pages\",\"Services\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:187;a:18:{s:4:\"tmpl\";i:1235;s:2:\"id\";i:21281;s:5:\"title\";s:25:\"Law Firm &#8211; Services\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/12/16-Services-Law-firm.jpg\";s:12:\"tmpl_created\";i:1638819128;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/law-firm-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:56:\"[\"Consulting\",\"Law\",\"Law Firm\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:188;a:18:{s:4:\"tmpl\";i:1017;s:2:\"id\";i:14111;s:5:\"title\";s:36:\"Classic | Japanese restaurant | Sale\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/06/Pop-Up-Page-Small.jpg\";s:12:\"tmpl_created\";i:1592300400;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-japanese-restaurant-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:717;s:11:\"trend_index\";i:697;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:189;a:18:{s:4:\"tmpl\";i:668;s:2:\"id\";i:8523;s:5:\"title\";s:11:\"404 page 06\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/006.jpg\";s:12:\"tmpl_created\";i:1526415291;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-06/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:298;s:11:\"trend_index\";i:268;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:190;a:18:{s:4:\"tmpl\";i:1213;s:2:\"id\";i:20509;s:5:\"title\";s:40:\"Dogs Adoption &#8211; Social Involvement\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/10/Dog-Adoption-250x280-1.jpg\";s:12:\"tmpl_created\";i:1634022353;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/dogs-adoption-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Social Involvement\";s:4:\"tags\";s:49:\"[\"Adoption\",\"Involvement\",\"Landing Pages\",\"Pets\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:191;a:18:{s:4:\"tmpl\";i:1233;s:2:\"id\";i:21205;s:5:\"title\";s:29:\"Photographer &#8211; Projects\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/12/25-Projects-Photographer.jpg\";s:12:\"tmpl_created\";i:1638818372;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/photographer-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:43:\"[\"Black and white\",\"Photography\",\"Project\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:192;a:18:{s:4:\"tmpl\";i:993;s:2:\"id\";i:13422;s:5:\"title\";s:30:\"Classic | Menu | Online Course\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Menu.jpg\";s:12:\"tmpl_created\";i:1587474782;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-menu-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:516;s:11:\"trend_index\";i:432;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:193;a:18:{s:4:\"tmpl\";i:669;s:2:\"id\";i:8524;s:5:\"title\";s:11:\"404 page 07\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/007.jpg\";s:12:\"tmpl_created\";i:1526415337;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-07/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:303;s:11:\"trend_index\";i:171;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:194;a:18:{s:4:\"tmpl\";i:925;s:2:\"id\";i:12540;s:5:\"title\";s:33:\"Classic | Menu | Travel and tours\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_Menu_s.png\";s:12:\"tmpl_created\";i:1575960267;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-menu-travel-and-tours/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:690;s:11:\"trend_index\";i:714;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:195;a:18:{s:4:\"tmpl\";i:1208;s:2:\"id\";i:20361;s:5:\"title\";s:51:\"Exercise &#038; Fitness Equipment &#8211; eCommerce\";s:9:\"thumbnail\";s:97:\"https://library.elementor.com/wp-content/uploads/2021/10/Exercise-Fitness-Equipment-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633883766;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/lp/exercise-fitness-equipment-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:50:\"[\"Fitness\",\"Health\",\"Landing Pages\",\"Online Shop\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:196;a:18:{s:4:\"tmpl\";i:1239;s:2:\"id\";i:21373;s:5:\"title\";s:28:\"Photographer &#8211; Gallery\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/18-Gallery-Photographer.jpg\";s:12:\"tmpl_created\";i:1638821177;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/photographer-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:56:\"[\"Gallery\",\"Photography\",\"Portfolio\",\"Project\",\"Travel\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:197;a:18:{s:4:\"tmpl\";i:1426;s:2:\"id\";i:24348;s:5:\"title\";s:24:\"Wireframe &#8211; Home 2\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-2.jpg\";s:12:\"tmpl_created\";i:1653988444;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/wireframe-home-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:102:\"[\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Homepage\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:198;a:18:{s:4:\"tmpl\";i:673;s:2:\"id\";i:8526;s:5:\"title\";s:11:\"404 page 09\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/009.jpg\";s:12:\"tmpl_created\";i:1526415474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-09/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:477;s:11:\"trend_index\";i:285;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:199;a:18:{s:4:\"tmpl\";i:958;s:2:\"id\";i:13129;s:5:\"title\";s:28:\"Classic | Menu | Photography\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/PopUp_s.png\";s:12:\"tmpl_created\";i:1582092645;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-menu-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:646;s:11:\"trend_index\";i:521;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:200;a:18:{s:4:\"tmpl\";i:1215;s:2:\"id\";i:20556;s:5:\"title\";s:41:\"Faroe Islands Trip Planner &#8211; Travel\";s:9:\"thumbnail\";s:97:\"https://library.elementor.com/wp-content/uploads/2021/10/Faroe-Islands-Trip-Planner-250x280-1.jpg\";s:12:\"tmpl_created\";i:1634026480;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/lp/faroe-islands-trip-planner-travel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Travel\";s:4:\"tags\";s:26:\"[\"Landing Pages\",\"Travel\"]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:201;a:18:{s:4:\"tmpl\";i:1427;s:2:\"id\";i:24366;s:5:\"title\";s:24:\"Wireframe &#8211; Home 3\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-3.jpg\";s:12:\"tmpl_created\";i:1653988491;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/wireframe-home-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:102:\"[\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Homepage\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:202;a:18:{s:4:\"tmpl\";i:670;s:2:\"id\";i:8525;s:5:\"title\";s:11:\"404 page 08\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/008.jpg\";s:12:\"tmpl_created\";i:1526415374;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-08/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:510;s:11:\"trend_index\";i:575;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:203;a:18:{s:4:\"tmpl\";i:1207;s:2:\"id\";i:20299;s:5:\"title\";s:51:\"Interior Design Consultation &#8211; Online Service\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2021/10/Interior-Design-Consultation-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633882989;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/lp/interior-design-consultation-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:65:\"[\"Consulting\",\"Interior Design\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:204;a:18:{s:4:\"tmpl\";i:952;s:2:\"id\";i:12726;s:5:\"title\";s:52:\"Classic | Newsletter | Subscribe | Magazine and Blog\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_Newsletter_s.png\";s:12:\"tmpl_created\";i:1579061019;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:152:\"https://library.elementor.com/popups/classic-newsletter-subscribe-magazine-and-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:357;s:11:\"trend_index\";i:281;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:205;a:18:{s:4:\"tmpl\";i:883;s:2:\"id\";i:11468;s:5:\"title\";s:20:\"Classic | Sale | Gym\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/08/PopUp_Small.png\";s:12:\"tmpl_created\";i:1567393182;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/classic-sale-gym/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:696;s:11:\"trend_index\";i:740;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:206;a:18:{s:4:\"tmpl\";i:1216;s:2:\"id\";i:20623;s:5:\"title\";s:57:\"Luxurious Camping Accommodation For Events &#8211; Events\";s:9:\"thumbnail\";s:113:\"https://library.elementor.com/wp-content/uploads/2021/10/Luxurious-Camping-Accommodation-For-Events-250x280-2.jpg\";s:12:\"tmpl_created\";i:1634041681;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:151:\"https://library.elementor.com/lp/luxurious-camping-accommodation-for-events-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:43:\"[\"Event\",\"Events\",\"Landing Pages\",\"Travel\"]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:207;a:18:{s:4:\"tmpl\";i:1219;s:2:\"id\";i:20886;s:5:\"title\";s:28:\"Online Training &#8211; Home\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/12/2-Home-Online-Training.jpg\";s:12:\"tmpl_created\";i:1638784769;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/online-training-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Fitness\",\"Online\",\"Sport\",\"Training\"]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:208;a:18:{s:4:\"tmpl\";i:502;s:2:\"id\";i:5438;s:5:\"title\";s:7:\"About 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_4.png\";s:12:\"tmpl_created\";i:1520443512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/about-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:147;s:11:\"trend_index\";i:9;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:209;a:18:{s:4:\"tmpl\";i:1065;s:2:\"id\";i:15570;s:5:\"title\";s:33:\"Classic | Subscribe | Travel Blog\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/11/PopUp.jpg\";s:12:\"tmpl_created\";i:1606215555;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-subscribe-travel-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:709;s:11:\"trend_index\";i:459;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:210;a:18:{s:4:\"tmpl\";i:557;s:2:\"id\";i:6135;s:5:\"title\";s:8:\"About 10\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_2.png\";s:12:\"tmpl_created\";i:1520443663;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:77;s:11:\"trend_index\";i:47;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:211;a:18:{s:4:\"tmpl\";i:1431;s:2:\"id\";i:24437;s:5:\"title\";s:25:\"Wireframe &#8211; About 4\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-4.jpg\";s:12:\"tmpl_created\";i:1653988733;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:74:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Professional\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:212;a:18:{s:4:\"tmpl\";i:1210;s:2:\"id\";i:20414;s:5:\"title\";s:45:\"Online English Courses &#8211; Online Service\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2021/10/Online-English-Courses-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633884482;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/lp/online-english-courses-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:50:\"[\"Course Online\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:213;a:18:{s:4:\"tmpl\";i:1132;s:2:\"id\";i:16553;s:5:\"title\";s:31:\"Fly-In | Contact | Beauty Salon\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/12/PopUp.jpg\";s:12:\"tmpl_created\";i:1608622602;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-contact-beauty-salon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:691;s:11:\"trend_index\";i:428;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:214;a:18:{s:4:\"tmpl\";i:1441;s:2:\"id\";i:24574;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 5\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-5.jpg\";s:12:\"tmpl_created\";i:1653989135;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:88:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Google Maps\",\"Header\",\"Professional\",\"Subscribe\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:215;a:18:{s:4:\"tmpl\";i:1217;s:2:\"id\";i:20333;s:5:\"title\";s:40:\"Plant Pots Online Shop &#8211; eCommerce\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2021/10/Plant-Pots-Online-Shop-250x280-2.jpg\";s:12:\"tmpl_created\";i:1634042184;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/plant-pots-online-shop-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:50:\"[\"Ecommerce\",\"Landing Pages\",\"Online Shop\",\"Shop\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:216;a:18:{s:4:\"tmpl\";i:497;s:2:\"id\";i:5397;s:5:\"title\";s:8:\"About 11\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_1.png\";s:12:\"tmpl_created\";i:1520443503;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:148;s:11:\"trend_index\";i:43;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:217;a:18:{s:4:\"tmpl\";i:1211;s:2:\"id\";i:20447;s:5:\"title\";s:33:\"Shared Workspace &#8211; Business\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/10/250x280-Shared-Workspace.jpg\";s:12:\"tmpl_created\";i:1633884934;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/shared-workspace-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:28:\"[\"Business\",\"Landing Pages\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:218;a:18:{s:4:\"tmpl\";i:1237;s:2:\"id\";i:21313;s:5:\"title\";s:34:\"Spa &#038; Beauty &#8211; Services\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/12/Spa-Beauty-Treatments-page-1.jpg\";s:12:\"tmpl_created\";i:1638819709;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/spa-beauty-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:55:\"[\"Beauty\",\"Hair\",\"Health\",\"Services\",\"Spa\",\"Treatment\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:219;a:18:{s:4:\"tmpl\";i:1004;s:2:\"id\";i:13538;s:5:\"title\";s:32:\"Fly-In | Newsletter | Barbershop\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/05/Pop-Up-Page-Small.jpg\";s:12:\"tmpl_created\";i:1589893364;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-newsletter-barbershop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:710;s:11:\"trend_index\";i:667;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:220;a:18:{s:4:\"tmpl\";i:498;s:2:\"id\";i:5405;s:5:\"title\";s:8:\"About 12\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_1.png\";s:12:\"tmpl_created\";i:1520443505;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:216;s:11:\"trend_index\";i:50;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:221;a:18:{s:4:\"tmpl\";i:924;s:2:\"id\";i:12550;s:5:\"title\";s:32:\"Fly-in | Sale | Travel and Tours\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_s.png\";s:12:\"tmpl_created\";i:1575960263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/flyin-sale-travel-and-tours/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:754;s:11:\"trend_index\";i:791;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:222;a:18:{s:4:\"tmpl\";i:1212;s:2:\"id\";i:20479;s:5:\"title\";s:49:\"Teeth Straightening &#8211; Health &#038; Fitness\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/10/250x280-Teeth-Whitening.jpg\";s:12:\"tmpl_created\";i:1633886115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/teeth-straightening-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:46:\"[\"Business\",\"Dental\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:223;a:18:{s:4:\"tmpl\";i:1234;s:2:\"id\";i:21234;s:5:\"title\";s:34:\"Insurance Company &#8211; Services\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2021/12/15-Services-Insurance-Company.jpg\";s:12:\"tmpl_created\";i:1638818688;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/insurance-company-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:51:\"[\"Faq\",\"Form\",\"Insurance\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:224;a:18:{s:4:\"tmpl\";i:500;s:2:\"id\";i:5421;s:5:\"title\";s:8:\"About 13\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_3.png\";s:12:\"tmpl_created\";i:1520443509;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:215;s:11:\"trend_index\";i:77;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:225;a:18:{s:4:\"tmpl\";i:513;s:2:\"id\";i:5533;s:5:\"title\";s:8:\"About 15\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_10.png\";s:12:\"tmpl_created\";i:1520443534;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-15/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:21;s:11:\"trend_index\";i:57;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:226;a:18:{s:4:\"tmpl\";i:1035;s:2:\"id\";i:15062;s:5:\"title\";s:35:\"Fly-In | Sign up | Flooring Company\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/08/PopUp.png\";s:12:\"tmpl_created\";i:1597739629;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/fly-in-sign-up-flooring-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:625;s:11:\"trend_index\";i:309;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:227;a:18:{s:4:\"tmpl\";i:1209;s:2:\"id\";i:20394;s:5:\"title\";s:30:\"Time Management &#8211; Events\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/10/Time-Management-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633884077;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/time-management-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:17:\"[\"Landing Pages\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:228;a:18:{s:4:\"tmpl\";i:1229;s:2:\"id\";i:21118;s:5:\"title\";s:28:\"Contact &#8211; Plants Store\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/12-Contact-Plants-Store.jpg\";s:12:\"tmpl_created\";i:1638802472;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/contact-plants-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:40:\"[\"Contact\",\"Info\",\"Plant\",\"Testimonial\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:229;a:18:{s:4:\"tmpl\";i:512;s:2:\"id\";i:5525;s:5:\"title\";s:8:\"About 14\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_10.png\";s:12:\"tmpl_created\";i:1520443532;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-14/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:9;s:11:\"trend_index\";i:29;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:230;a:18:{s:4:\"tmpl\";i:893;s:2:\"id\";i:11822;s:5:\"title\";s:30:\"Full Screen | Menu | Portfolio\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/09/PopUp_small.png\";s:12:\"tmpl_created\";i:1569429896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/full-screen-menu-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:654;s:11:\"trend_index\";i:626;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:231;a:18:{s:4:\"tmpl\";i:1203;s:2:\"id\";i:18591;s:5:\"title\";s:28:\"Coffee Sale &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/04/250x280-7.png\";s:12:\"tmpl_created\";i:1633877319;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/coffee-sale-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:33:\"[\"Coffee\",\"Landing Pages\",\"Sale\"]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:232;a:18:{s:4:\"tmpl\";i:1231;s:2:\"id\";i:21184;s:5:\"title\";s:28:\"Dental Care &#8211; Services\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/14-Services-Dental-Care.jpg\";s:12:\"tmpl_created\";i:1638807148;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/dental-care-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:45:\"[\"Dental\",\"Medical\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:233;a:18:{s:4:\"tmpl\";i:1064;s:2:\"id\";i:15580;s:5:\"title\";s:31:\"Fullscreen | Menu | Travel Blog\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/11/PopUp-Menu.jpg\";s:12:\"tmpl_created\";i:1606215358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fullscreen-menu-travel-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:673;s:11:\"trend_index\";i:348;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:234;a:18:{s:4:\"tmpl\";i:1133;s:2:\"id\";i:16645;s:5:\"title\";s:28:\"Headphones &#8211; eCommerce\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/lp_headphones.png\";s:12:\"tmpl_created\";i:1609944115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/commerce-headphones/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:39:\"[\"Ecommerce\",\"Landing Pages\",\"Product\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:633;s:11:\"trend_index\";i:87;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:235;a:18:{s:4:\"tmpl\";i:1442;s:2:\"id\";i:24584;s:5:\"title\";s:27:\"Wireframe &#8211; Pricing 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Pricing-1.jpg\";s:12:\"tmpl_created\";i:1653989152;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-pricing-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:146:\"[\"Booking\",\"Business\",\"Clients\",\"Contact\",\"Faq\",\"Features\",\"Footer\",\"Online Service\",\"Pricing\",\"Products\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:236;a:18:{s:4:\"tmpl\";i:501;s:2:\"id\";i:5429;s:5:\"title\";s:8:\"About 16\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_4.png\";s:12:\"tmpl_created\";i:1520443510;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-16/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:59;s:11:\"trend_index\";i:8;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:237;a:18:{s:4:\"tmpl\";i:1138;s:2:\"id\";i:16762;s:5:\"title\";s:25:\"Conference &#8211; Events\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Conference.png\";s:12:\"tmpl_created\";i:1610455119;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/conference-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:60:\"[\"Conference\",\"Convention\",\"Event\",\"Events\",\"Landing Pages\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:705;s:11:\"trend_index\";i:216;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:238;a:18:{s:4:\"tmpl\";i:1438;s:2:\"id\";i:24539;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 2\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-2.jpg\";s:12:\"tmpl_created\";i:1653989019;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:69:\"[\"Business\",\"Contact\",\"Footer\",\"Google Maps\",\"Header\",\"Professional\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:239;a:18:{s:4:\"tmpl\";i:981;s:2:\"id\";i:13281;s:5:\"title\";s:37:\"Hello Bar | Contact | Interior Design\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp.png\";s:12:\"tmpl_created\";i:1586148801;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/hello-bar-contact-interior-design/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:19:\"[\"Interior Design\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:763;s:11:\"trend_index\";i:679;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:240;a:18:{s:4:\"tmpl\";i:505;s:2:\"id\";i:5464;s:5:\"title\";s:8:\"About 17\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_6.png\";s:12:\"tmpl_created\";i:1520443518;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-17/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:220;s:11:\"trend_index\";i:142;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:241;a:18:{s:4:\"tmpl\";i:1052;s:2:\"id\";i:15259;s:5:\"title\";s:31:\"Hello Bar | Menu | Psychologist\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/09/Menu-PopUp.png\";s:12:\"tmpl_created\";i:1600170209;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/hello-bar-menu-psychologist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:739;s:11:\"trend_index\";i:583;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:242;a:18:{s:4:\"tmpl\";i:1434;s:2:\"id\";i:24494;s:5:\"title\";s:28:\"Wireframe &#8211; Services 1\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-1.jpg\";s:12:\"tmpl_created\";i:1653988874;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/wireframe-services-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:53:\"[\"Business\",\"Faq\",\"Footer\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:243;a:18:{s:4:\"tmpl\";i:1194;s:2:\"id\";i:18701;s:5:\"title\";s:32:\"Digital Course &#8211; eCommerce\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/04/250x280.jpg\";s:12:\"tmpl_created\";i:1618995134;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/digital-course-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:57:\"[\"Course Online\",\"Ecommerce\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:244;a:18:{s:4:\"tmpl\";i:510;s:2:\"id\";i:5504;s:5:\"title\";s:8:\"About 18\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_9.png\";s:12:\"tmpl_created\";i:1520443528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-18/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:104;s:11:\"trend_index\";i:46;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:245;a:18:{s:4:\"tmpl\";i:1192;s:2:\"id\";i:18612;s:5:\"title\";s:34:\"Bag Product Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Bag-Product.jpeg\";s:12:\"tmpl_created\";i:1618395406;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/bag-product-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:61:\"[\"Bag\",\"Ecommerce\",\"Landing Pages\",\"Product\",\"Sale\",\"Travel\"]\";s:10:\"menu_order\";i:20;s:16:\"popularity_index\";i:875;s:11:\"trend_index\";i:605;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:246;a:18:{s:4:\"tmpl\";i:1227;s:2:\"id\";i:21083;s:5:\"title\";s:26:\"Conference &#8211; Contact\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/12/10-Contact-Conference.jpg\";s:12:\"tmpl_created\";i:1638799208;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/conference-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:44:\"[\"Conference\",\"Contact\",\"Form\",\"Info\",\"Map\"]\";s:10:\"menu_order\";i:20;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:247;a:18:{s:4:\"tmpl\";i:511;s:2:\"id\";i:5515;s:5:\"title\";s:8:\"About 19\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_9.png\";s:12:\"tmpl_created\";i:1520443530;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-19/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:20;s:16:\"popularity_index\";i:268;s:11:\"trend_index\";i:161;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:248;a:18:{s:4:\"tmpl\";i:1193;s:2:\"id\";i:18644;s:5:\"title\";s:37:\"Camera Product Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/camera_sale_featured-img.jpg\";s:12:\"tmpl_created\";i:1618396388;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/lp/camera-product-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:59:\"[\"Camera\",\"Ecommerce\",\"Landing Pages\",\"Photography\",\"Sale\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:873;s:11:\"trend_index\";i:535;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:249;a:18:{s:4:\"tmpl\";i:951;s:2:\"id\";i:12736;s:5:\"title\";s:41:\"Slide In | Contact Us | Magazine and Blog\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_contact_s.png\";s:12:\"tmpl_created\";i:1579060978;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/slide-in-contact-us/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:734;s:11:\"trend_index\";i:686;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:250;a:18:{s:4:\"tmpl\";i:1222;s:2:\"id\";i:20960;s:5:\"title\";s:26:\"Travel Agency &#8211; Home\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/12/5-Home-Travel-Agency.jpg\";s:12:\"tmpl_created\";i:1638788432;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/travel-agency-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:53:\"[\"Adventures\",\"Experience\",\"Explore\",\"Travel\",\"Trip\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:251;a:18:{s:4:\"tmpl\";i:506;s:2:\"id\";i:5472;s:5:\"title\";s:7:\"About 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_7.png\";s:12:\"tmpl_created\";i:1520443520;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/about-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:210;s:11:\"trend_index\";i:116;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:252;a:18:{s:4:\"tmpl\";i:1196;s:2:\"id\";i:18815;s:5:\"title\";s:25:\"Car Wash &#8211; Business\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Car-Wash.png\";s:12:\"tmpl_created\";i:1621336431;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/car-wash-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:45:\"[\"Business\",\"car\",\"Discount\",\"Landing Pages\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:253;a:18:{s:4:\"tmpl\";i:1242;s:2:\"id\";i:21473;s:5:\"title\";s:40:\"Architecture Photography &#8211; Gallery\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2021/12/20-Gallery-Architecture-Photography.jpg\";s:12:\"tmpl_created\";i:1638822115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/architecture-photography-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:52:\"[\"Architecture\",\"Gallery\",\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:254;a:18:{s:4:\"tmpl\";i:1015;s:2:\"id\";i:14067;s:5:\"title\";s:37:\"Slide In | Japanese restaurant | Menu\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/06/Menu-Pop-Up-Small.jpg\";s:12:\"tmpl_created\";i:1592290352;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/slide-in-japanese-restaurant-menu/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:650;s:11:\"trend_index\";i:565;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:255;a:18:{s:4:\"tmpl\";i:504;s:2:\"id\";i:5455;s:5:\"title\";s:8:\"About 20\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_6.png\";s:12:\"tmpl_created\";i:1520443516;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-20/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:134;s:11:\"trend_index\";i:70;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:256;a:18:{s:4:\"tmpl\";i:923;s:2:\"id\";i:12229;s:5:\"title\";s:33:\"Slide In | Law Firm | Information\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2019/11/popup.png\";s:12:\"tmpl_created\";i:1572847842;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-law-firm-information/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:547;s:11:\"trend_index\";i:413;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:257;a:18:{s:4:\"tmpl\";i:1198;s:2:\"id\";i:18824;s:5:\"title\";s:33:\"Design School &#8211; Coming Soon\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/05/250x280-1.png\";s:12:\"tmpl_created\";i:1621336756;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/design-school-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:49:\"[\"Coming Soon\",\"Design\",\"Landing Pages\",\"School\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:258;a:18:{s:4:\"tmpl\";i:1236;s:2:\"id\";i:21259;s:5:\"title\";s:28:\"3D Designer &#8211; Projects\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/24-Projects-3D-Designer.jpg\";s:12:\"tmpl_created\";i:1638819185;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/3d-designer-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:69:\"[\"3D\",\"Creative Portfolio\",\"Design\",\"Designer\",\"Portfolio\",\"Project\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:259;a:18:{s:4:\"tmpl\";i:499;s:2:\"id\";i:5413;s:5:\"title\";s:8:\"About 21\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_2.png\";s:12:\"tmpl_created\";i:1520443507;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-21/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:83;s:11:\"trend_index\";i:52;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:260;a:18:{s:4:\"tmpl\";i:1028;s:2:\"id\";i:14827;s:5:\"title\";s:39:\"Slide-In | Contact | Luxury Real Estate\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/07/PopUp.png\";s:12:\"tmpl_created\";i:1595323523;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/slide-in-contact-luxury-real-estate/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:559;s:11:\"trend_index\";i:284;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:261;a:18:{s:4:\"tmpl\";i:1197;s:2:\"id\";i:18819;s:5:\"title\";s:27:\"Dog Walker &#8211; Business\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Dog-Walker.png\";s:12:\"tmpl_created\";i:1621336601;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/dog-walker-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:41:\"[\"Business\",\"Dog\",\"Landing Pages\",\"Pets\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:262;a:18:{s:4:\"tmpl\";i:1238;s:2:\"id\";i:21349;s:5:\"title\";s:29:\"Architecture &#8211; Projects\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/12/23-Projects-Architecture.jpg\";s:12:\"tmpl_created\";i:1638820870;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/architecture-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:70:\"[\"Architecture\",\"Creative\",\"Creative Portfolio\",\"Portfolio\",\"Project\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:263;a:18:{s:4:\"tmpl\";i:503;s:2:\"id\";i:5447;s:5:\"title\";s:7:\"About 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_5.png\";s:12:\"tmpl_created\";i:1520443514;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/about-3-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:48;s:11:\"trend_index\";i:12;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:264;a:18:{s:4:\"tmpl\";i:1034;s:2:\"id\";i:15075;s:5:\"title\";s:34:\"Slide-In | Menu | Flooring Company\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/08/PopUp-1.png\";s:12:\"tmpl_created\";i:1597739605;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/slide-in-menu-flooring-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:383;s:11:\"trend_index\";i:162;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:265;a:18:{s:4:\"tmpl\";i:1414;s:2:\"id\";i:24079;s:5:\"title\";s:32:\"Fashion Shop &#8211; Coming Soon\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Fashion-Shop.jpg\";s:12:\"tmpl_created\";i:1650988089;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/fashion-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:88:\"[\"Aesthetic\",\"Business\",\"Coming Soon\",\"Ecommerce\",\"Girly\",\"Lifestyle\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:266;a:18:{s:4:\"tmpl\";i:1195;s:2:\"id\";i:18761;s:5:\"title\";s:33:\"Fashion Store &#8211; Coming Soon\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Fashion-Store.png\";s:12:\"tmpl_created\";i:1621336146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/fashion-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:56:\"[\"Coming Soon\",\"Fashion\",\"Landing Pages\",\"Shop\",\"store\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:267;a:18:{s:4:\"tmpl\";i:507;s:2:\"id\";i:5480;s:5:\"title\";s:7:\"About 4\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_7-1.png\";s:12:\"tmpl_created\";i:1520443522;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/about-4-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:428;s:11:\"trend_index\";i:303;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:268;a:18:{s:4:\"tmpl\";i:545;s:2:\"id\";i:6027;s:5:\"title\";s:7:\"About 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_1-1.png\";s:12:\"tmpl_created\";i:1520443639;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/about-5-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:26;s:16:\"popularity_index\";i:40;s:11:\"trend_index\";i:40;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:269;a:18:{s:4:\"tmpl\";i:1153;s:2:\"id\";i:17060;s:5:\"title\";s:36:\"Private Tutor &#8211; Online Service\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Tutor-2.png\";s:12:\"tmpl_created\";i:1610631042;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/private-tutor-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:64:\"[\"Education\",\"Landing Pages\",\"Online Service\",\"Teacher\",\"Tutor\"]\";s:10:\"menu_order\";i:26;s:16:\"popularity_index\";i:780;s:11:\"trend_index\";i:628;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:270;a:18:{s:4:\"tmpl\";i:1430;s:2:\"id\";i:24434;s:5:\"title\";s:25:\"Wireframe &#8211; About 3\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-3.jpg\";s:12:\"tmpl_created\";i:1653988697;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:76:\"[\"About\",\"Business\",\"Contact\",\"Faq\",\"Footer\",\"Header\",\"Professional\",\"Team\"]\";s:10:\"menu_order\";i:26;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:271;a:18:{s:4:\"tmpl\";i:546;s:2:\"id\";i:6036;s:5:\"title\";s:7:\"About 6\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_1-1.png\";s:12:\"tmpl_created\";i:1520443641;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/about-6-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:27;s:16:\"popularity_index\";i:90;s:11:\"trend_index\";i:123;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:272;a:18:{s:4:\"tmpl\";i:1158;s:2:\"id\";i:17232;s:5:\"title\";s:33:\"Life Coach &#8211; Online Service\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Life-Coach.png\";s:12:\"tmpl_created\";i:1610902793;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/life-coach-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:38:\"[\"Coach\",\"Landing Pages\",\"Life Coach\"]\";s:10:\"menu_order\";i:27;s:16:\"popularity_index\";i:787;s:11:\"trend_index\";i:751;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:273;a:18:{s:4:\"tmpl\";i:1436;s:2:\"id\";i:24515;s:5:\"title\";s:28:\"Wireframe &#8211; Services 3\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-3.jpg\";s:12:\"tmpl_created\";i:1653988946;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/wireframe-services-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:66:\"[\"Business\",\"Contact\",\"Footer\",\"Header\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:27;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:274;a:18:{s:4:\"tmpl\";i:875;s:2:\"id\";i:11241;s:5:\"title\";s:36:\"Classic | Digital Agency | Marketing\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/07/PopUp_small.jpg\";s:12:\"tmpl_created\";i:1564643043;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-digital-agency-marketing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:362;s:11:\"trend_index\";i:315;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:275;a:18:{s:4:\"tmpl\";i:1146;s:2:\"id\";i:16932;s:5:\"title\";s:35:\"Finance Consulting &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/01/Finance-Consulting.png\";s:12:\"tmpl_created\";i:1610532170;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/lp/finance-consulting-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:80:\"[\"Advisor\",\"Business\",\"Consulting\",\"Finance\",\"Investment\",\"Landing Pages\",\"Tax\"]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:790;s:11:\"trend_index\";i:630;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:276;a:18:{s:4:\"tmpl\";i:1429;s:2:\"id\";i:24421;s:5:\"title\";s:25:\"Wireframe &#8211; About 2\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-2.jpg\";s:12:\"tmpl_created\";i:1653988579;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:87:\"[\"About\",\"Business\",\"Contact\",\"Faq\",\"Features\",\"Footer\",\"Header\",\"Professional\",\"Team\"]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:277;a:18:{s:4:\"tmpl\";i:508;s:2:\"id\";i:5488;s:5:\"title\";s:7:\"About 7\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_8.png\";s:12:\"tmpl_created\";i:1520443524;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/about-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:307;s:11:\"trend_index\";i:169;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:278;a:18:{s:4:\"tmpl\";i:556;s:2:\"id\";i:6122;s:5:\"title\";s:7:\"About 8\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_2-1.png\";s:12:\"tmpl_created\";i:1520443661;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/about-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:29;s:16:\"popularity_index\";i:38;s:11:\"trend_index\";i:26;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:279;a:18:{s:4:\"tmpl\";i:1136;s:2:\"id\";i:16721;s:5:\"title\";s:35:\"Dental &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2021/01/Dental.jpg\";s:12:\"tmpl_created\";i:1610448567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/dental-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:44:\"[\"Dental\",\"Doctor\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:29;s:16:\"popularity_index\";i:801;s:11:\"trend_index\";i:655;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:280;a:18:{s:4:\"tmpl\";i:1417;s:2:\"id\";i:24116;s:5:\"title\";s:32:\"Tech Company &#8211; Coming Soon\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Tech-Company.jpg\";s:12:\"tmpl_created\";i:1650989265;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/tech-company-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:87:\"[\"Business\",\"Coding\",\"Coming Soon\",\"Computer\",\"Developer\",\"IT\",\"Services\",\"Technology\"]\";s:10:\"menu_order\";i:29;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:281;a:18:{s:4:\"tmpl\";i:1161;s:2:\"id\";i:17269;s:5:\"title\";s:34:\"Electronics Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/01/Electronic-Products.png\";s:12:\"tmpl_created\";i:1610903298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/electronics-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:29:\"[\"Ecommerce\",\"Landing Pages\"]\";s:10:\"menu_order\";i:30;s:16:\"popularity_index\";i:800;s:11:\"trend_index\";i:556;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:282;a:18:{s:4:\"tmpl\";i:1220;s:2:\"id\";i:20908;s:5:\"title\";s:42:\"Packing &#038; Moving Company &#8211; Home\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2021/12/3-Home-Packing-Moving-Company.jpg\";s:12:\"tmpl_created\";i:1638786127;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/packing-moving-company-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Movers\",\"Moving\",\"Storge\"]\";s:10:\"menu_order\";i:30;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:283;a:18:{s:4:\"tmpl\";i:509;s:2:\"id\";i:5496;s:5:\"title\";s:7:\"About 9\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_8-1.png\";s:12:\"tmpl_created\";i:1520443526;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/about-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:30;s:16:\"popularity_index\";i:523;s:11:\"trend_index\";i:453;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:284;a:18:{s:4:\"tmpl\";i:1152;s:2:\"id\";i:17032;s:5:\"title\";s:42:\"Donate Computer &#8211; Social Involvement\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Donation-2.png\";s:12:\"tmpl_created\";i:1610630585;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/donate-computer-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Social Involvement\";s:4:\"tags\";s:67:\"[\"Computer\",\"Donate\",\"Donation\",\"Kids\",\"Landing Pages\",\"Nonprofit\"]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:718;s:11:\"trend_index\";i:278;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:285;a:18:{s:4:\"tmpl\";i:684;s:2:\"id\";i:8961;s:5:\"title\";s:9:\"archive 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.1.jpg\";s:12:\"tmpl_created\";i:1528639909;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:79;s:11:\"trend_index\";i:15;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:286;a:18:{s:4:\"tmpl\";i:1245;s:2:\"id\";i:21546;s:5:\"title\";s:28:\"Interior Design &#8211; Home\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/12/1-Home-Interior-Design-1.jpg\";s:12:\"tmpl_created\";i:1639046269;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/interior-design-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:68:\"[\"Design\",\"Form\",\"Furniture Design\",\"Interior Design\",\"Testimonial\"]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:287;a:18:{s:4:\"tmpl\";i:1135;s:2:\"id\";i:16684;s:5:\"title\";s:34:\"SaaS HR Management &#8211; Product\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2021/01/lp_hr.png\";s:12:\"tmpl_created\";i:1609945486;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/saas-hr-management-product/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:39:\"[\"HR\",\"Landing Pages\",\"Product\",\"SaaS\"]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:708;s:11:\"trend_index\";i:292;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:288;a:18:{s:4:\"tmpl\";i:685;s:2:\"id\";i:8969;s:5:\"title\";s:9:\"archive 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.2.jpg\";s:12:\"tmpl_created\";i:1528700014;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:250;s:11:\"trend_index\";i:124;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:289;a:18:{s:4:\"tmpl\";i:1249;s:2:\"id\";i:22137;s:5:\"title\";s:31:\"Design Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2021/10/Design-Blog-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1647177194;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/design-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:47:\"[\"Blog\",\"Coming Soon\",\"Design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:290;a:18:{s:4:\"tmpl\";i:1134;s:2:\"id\";i:16660;s:5:\"title\";s:37:\"Medical center &#8211; Online service\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-medical-cosultation-250_280.png\";s:12:\"tmpl_created\";i:1609945122;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/lp/medical-center-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:44:\"[\"Landing Pages\",\"Medical\",\"Online Service\"]\";s:10:\"menu_order\";i:33;s:16:\"popularity_index\";i:750;s:11:\"trend_index\";i:332;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:291;a:18:{s:4:\"tmpl\";i:686;s:2:\"id\";i:8973;s:5:\"title\";s:9:\"archive 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.3.jpg\";s:12:\"tmpl_created\";i:1528700205;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:33;s:16:\"popularity_index\";i:176;s:11:\"trend_index\";i:54;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:292;a:18:{s:4:\"tmpl\";i:1226;s:2:\"id\";i:21069;s:5:\"title\";s:21:\"Hotel &#8211; Contact\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/12/9-Contact-Hotel.jpg\";s:12:\"tmpl_created\";i:1638798545;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/hotel-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:36:\"[\"Contact\",\"from\",\"Info\",\"Vacation\"]\";s:10:\"menu_order\";i:33;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:293;a:18:{s:4:\"tmpl\";i:1150;s:2:\"id\";i:17001;s:5:\"title\";s:36:\"Parental Counseling &#8211; Business\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2021/01/Parenting-Coach-2.png\";s:12:\"tmpl_created\";i:1610534999;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/parental-counseling-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:99:\"[\"Advisor\",\"Business\",\"Coach\",\"Counseling\",\"Landing Pages\",\"Online Service\",\"Parental\",\"Parenting\"]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:817;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:294;a:18:{s:4:\"tmpl\";i:1432;s:2:\"id\";i:24461;s:5:\"title\";s:27:\"Wireframe &#8211; Gallery 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Gallery-1.jpg\";s:12:\"tmpl_created\";i:1653988784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-gallery-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:82:\"[\"Business\",\"Contact\",\"Design\",\"Footer\",\"Gallery\",\"Header\",\"Portfolio\",\"Services\"]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:295;a:18:{s:4:\"tmpl\";i:687;s:2:\"id\";i:8977;s:5:\"title\";s:9:\"archive 4\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.4.jpg\";s:12:\"tmpl_created\";i:1528700326;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:354;s:11:\"trend_index\";i:396;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:296;a:18:{s:4:\"tmpl\";i:1137;s:2:\"id\";i:16742;s:5:\"title\";s:31:\"Online Course &#8211; Education\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Course.png\";s:12:\"tmpl_created\";i:1610454122;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/online-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:55:\"[\"Academy\",\"Course Online\",\"Education\",\"Landing Pages\"]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:777;s:11:\"trend_index\";i:776;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:297;a:18:{s:4:\"tmpl\";i:1440;s:2:\"id\";i:24563;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 4\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-4.jpg\";s:12:\"tmpl_created\";i:1653989095;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:84:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Gallery\",\"Header\",\"Professional\",\"Subscribe\"]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:298;a:18:{s:4:\"tmpl\";i:688;s:2:\"id\";i:8981;s:5:\"title\";s:9:\"archive 5\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.5.jpg\";s:12:\"tmpl_created\";i:1528700484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:333;s:11:\"trend_index\";i:195;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:299;a:18:{s:4:\"tmpl\";i:1162;s:2:\"id\";i:17284;s:5:\"title\";s:38:\"Dietitian &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/01/Dietitian.png\";s:12:\"tmpl_created\";i:1610903484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/dietitian-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:39:\"[\"Fitness\",\"Health\",\"landscape design\"]\";s:10:\"menu_order\";i:36;s:16:\"popularity_index\";i:814;s:11:\"trend_index\";i:800;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:300;a:18:{s:4:\"tmpl\";i:1439;s:2:\"id\";i:24553;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 3\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-3.jpg\";s:12:\"tmpl_created\";i:1653989057;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:67:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Professional\",\"Testimonial\"]\";s:10:\"menu_order\";i:36;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:301;a:18:{s:4:\"tmpl\";i:689;s:2:\"id\";i:8985;s:5:\"title\";s:9:\"archive 6\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.6.jpg\";s:12:\"tmpl_created\";i:1528700612;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:36;s:16:\"popularity_index\";i:204;s:11:\"trend_index\";i:95;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:302;a:18:{s:4:\"tmpl\";i:1144;s:2:\"id\";i:16897;s:5:\"title\";s:30:\"Personal Chef &#8211; Business\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/Personal-Chef.png\";s:12:\"tmpl_created\";i:1610466247;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/personal-chef-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:53:\"[\"Business\",\"Chef\",\"Food\",\"Landing Pages\",\"Services\"]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:795;s:11:\"trend_index\";i:617;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:303;a:18:{s:4:\"tmpl\";i:1435;s:2:\"id\";i:24504;s:5:\"title\";s:28:\"Wireframe &#8211; Services 2\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-2.jpg\";s:12:\"tmpl_created\";i:1653988910;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/wireframe-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:80:\"[\"Business\",\"Contact\",\"Footer\",\"Header\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:304;a:18:{s:4:\"tmpl\";i:690;s:2:\"id\";i:8989;s:5:\"title\";s:9:\"archive 7\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.7.jpg\";s:12:\"tmpl_created\";i:1528701063;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:208;s:11:\"trend_index\";i:111;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:305;a:18:{s:4:\"tmpl\";i:1147;s:2:\"id\";i:16946;s:5:\"title\";s:52:\"Online Full-Stack Developer Course &#8211; Education\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Full-Stack-Developer-Course.png\";s:12:\"tmpl_created\";i:1610532778;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/lp/online-full-stack-developer-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:76:\"[\"Academy\",\"Coding\",\"Course Online\",\"Developer\",\"Education\",\"Landing Pages\"]\";s:10:\"menu_order\";i:38;s:16:\"popularity_index\";i:805;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:306;a:18:{s:4:\"tmpl\";i:1437;s:2:\"id\";i:24528;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-1.jpg\";s:12:\"tmpl_created\";i:1653988981;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:76:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Google Maps\",\"Header\",\"Professional\"]\";s:10:\"menu_order\";i:38;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:307;a:18:{s:4:\"tmpl\";i:691;s:2:\"id\";i:8996;s:5:\"title\";s:9:\"archive 8\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.8.jpg\";s:12:\"tmpl_created\";i:1528701290;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:38;s:16:\"popularity_index\";i:227;s:11:\"trend_index\";i:153;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:308;a:18:{s:4:\"tmpl\";i:1143;s:2:\"id\";i:16868;s:5:\"title\";s:40:\"Virtual Assistant &#8211; Online Service\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2021/01/Virtual-Assistant-250x280-1.png\";s:12:\"tmpl_created\";i:1610465656;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/virtual-assistant-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:46:\"[\"Assistant\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:793;s:11:\"trend_index\";i:757;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:309;a:18:{s:4:\"tmpl\";i:692;s:2:\"id\";i:9001;s:5:\"title\";s:9:\"archive 9\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.9.jpg\";s:12:\"tmpl_created\";i:1528701433;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:265;s:11:\"trend_index\";i:208;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:310;a:18:{s:4:\"tmpl\";i:1228;s:2:\"id\";i:21104;s:5:\"title\";s:26:\"Restaurant &#8211; Contact\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/12/11-Contact-Restaurant.jpg\";s:12:\"tmpl_created\";i:1638800146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/restaurant-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:60:\"[\"Contact\",\"Food\",\"Form\",\"Google Maps\",\"Info\",\"Testimonial\"]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:311;a:18:{s:4:\"tmpl\";i:1140;s:2:\"id\";i:16812;s:5:\"title\";s:40:\"Construction Project &#8211; Real Estate\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/01/Construction-Project.png\";s:12:\"tmpl_created\";i:1610463582;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/construction-project-real-estate/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:11:\"Real Estate\";s:4:\"tags\";s:59:\"[\"Construction\",\"Landing Pages\",\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:40;s:16:\"popularity_index\";i:796;s:11:\"trend_index\";i:724;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:312;a:18:{s:4:\"tmpl\";i:1244;s:2:\"id\";i:21393;s:5:\"title\";s:34:\"Interior Designer &#8211; Projects\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2021/12/big-22-Projects-Interior-Designer-New.jpeg\";s:12:\"tmpl_created\";i:1638823945;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/interior-designer-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:93:\"[\"Creative\",\"Creative Portfolio\",\"Design\",\"Designer\",\"Interior Design\",\"Portfolio\",\"Project\"]\";s:10:\"menu_order\";i:40;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:313;a:18:{s:4:\"tmpl\";i:997;s:2:\"id\";i:13528;s:5:\"title\";s:22:\"Barbershop &#8211; 404\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/05/404-Page.jpg\";s:12:\"tmpl_created\";i:1589893152;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/barbershop-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:34:\"[\"404\",\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:40;s:16:\"popularity_index\";i:768;s:11:\"trend_index\";i:681;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:314;a:18:{s:4:\"tmpl\";i:1148;s:2:\"id\";i:16960;s:5:\"title\";s:44:\"Dog &amp; Cat Food Delivery &#8211; Business\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2021/01/Dog-Food.png\";s:12:\"tmpl_created\";i:1610533581;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/lp/dog-cat-food-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:71:\"[\"Business\",\"Cat\",\"Delivery\",\"Dog\",\"Food\",\"Landing Pages\",\"Pet\",\"Pets\"]\";s:10:\"menu_order\";i:41;s:16:\"popularity_index\";i:782;s:11:\"trend_index\";i:510;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:315;a:18:{s:4:\"tmpl\";i:1251;s:2:\"id\";i:22143;s:5:\"title\";s:33:\"Fashion Store &#8211; Coming Soon\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Fashion-Store.png\";s:12:\"tmpl_created\";i:1647177389;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/fashion-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:56:\"[\"Coming Soon\",\"Fashion\",\"Landing Pages\",\"Shop\",\"store\"]\";s:10:\"menu_order\";i:41;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:316;a:18:{s:4:\"tmpl\";i:998;s:2:\"id\";i:13518;s:5:\"title\";s:26:\"Barbershop &#8211; Archive\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/05/Blog-Page.jpg\";s:12:\"tmpl_created\";i:1589893157;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/blocks/barbershop-archive/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:41;s:16:\"popularity_index\";i:737;s:11:\"trend_index\";i:523;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:317;a:18:{s:4:\"tmpl\";i:1155;s:2:\"id\";i:17095;s:5:\"title\";s:36:\"Mobile Pet Grooming &#8211; Business\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/01/Mobile-Pet-Grooming.png\";s:12:\"tmpl_created\";i:1610632115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/mobile-pet-grooming-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:38:\"[\"Dog\",\"Groom\",\"Landing Pages\",\"Pets\"]\";s:10:\"menu_order\";i:42;s:16:\"popularity_index\";i:786;s:11:\"trend_index\";i:731;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:318;a:18:{s:4:\"tmpl\";i:1241;s:2:\"id\";i:21451;s:5:\"title\";s:26:\"Exhibition &#8211; Gallery\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/12/21-Gallery-Exhibition.jpg\";s:12:\"tmpl_created\";i:1638821855;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/exhibition-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:74:\"[\"Art\",\"Creative\",\"Creative Portfolio\",\"Exhibition\",\"Gallery\",\"Portfolio\"]\";s:10:\"menu_order\";i:42;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:319;a:18:{s:4:\"tmpl\";i:996;s:2:\"id\";i:13604;s:5:\"title\";s:25:\"Barbershop &#8211; Footer\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/05/Footer-Small.jpg\";s:12:\"tmpl_created\";i:1589893147;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/barbershop-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:37:\"[\"Barber Shop\",\"Barbershop\",\"Footer\"]\";s:10:\"menu_order\";i:42;s:16:\"popularity_index\";i:555;s:11:\"trend_index\";i:267;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:320;a:18:{s:4:\"tmpl\";i:1159;s:2:\"id\";i:17245;s:5:\"title\";s:34:\"Marketing Course &#8211; Education\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2021/01/PPC.png\";s:12:\"tmpl_created\";i:1610902958;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/marketing-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:45:\"[\"Course Online\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:43;s:16:\"popularity_index\";i:770;s:11:\"trend_index\";i:430;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:321;a:18:{s:4:\"tmpl\";i:1240;s:2:\"id\";i:21430;s:5:\"title\";s:30:\"Travel Blogger &#8211; Gallery\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/12/19-Gallery-Travel-Blogger.jpg\";s:12:\"tmpl_created\";i:1638821592;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/travel-blogger-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:43:\"[\"Gallery\",\"Photography\",\"Slider\",\"Travel\"]\";s:10:\"menu_order\";i:43;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:322;a:18:{s:4:\"tmpl\";i:995;s:2:\"id\";i:13612;s:5:\"title\";s:25:\"Barbershop &#8211; Header\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2020/06/barber-shop-header.jpg\";s:12:\"tmpl_created\";i:1589893142;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/barbershop-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:37:\"[\"Barber Shop\",\"Barbershop\",\"Header\"]\";s:10:\"menu_order\";i:43;s:16:\"popularity_index\";i:343;s:11:\"trend_index\";i:137;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:323;a:18:{s:4:\"tmpl\";i:1149;s:2:\"id\";i:16983;s:5:\"title\";s:41:\"Pilates Instructor &#8211; Online Service\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/01/Pilates-Instructor.png\";s:12:\"tmpl_created\";i:1610534138;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/lp/pilates-instructor-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:70:\"[\"Free Trial\",\"Instructor\",\"Landing Pages\",\"Online Service\",\"Pilates\"]\";s:10:\"menu_order\";i:44;s:16:\"popularity_index\";i:778;s:11:\"trend_index\";i:412;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:324;a:18:{s:4:\"tmpl\";i:1416;s:2:\"id\";i:24104;s:5:\"title\";s:33:\"Ceramics Shop &#8211; Coming Soon\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Ceramics-Shop.jpg\";s:12:\"tmpl_created\";i:1650988949;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/ceramics-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:115:\"[\"Art\",\"Business\",\"Coming Soon\",\"Creative\",\"Decor\",\"Design\",\"Furniture Design\",\"Interior Design\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:44;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:325;a:18:{s:4:\"tmpl\";i:994;s:2:\"id\";i:13621;s:5:\"title\";s:30:\"Barbershop &#8211; Single Post\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/05/Single-Page.jpg\";s:12:\"tmpl_created\";i:1589893137;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/blocks/barbershop-single-post/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:44;s:16:\"popularity_index\";i:736;s:11:\"trend_index\";i:580;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:326;a:18:{s:4:\"tmpl\";i:1131;s:2:\"id\";i:16527;s:5:\"title\";s:24:\"Beauty Salon &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/12/404.jpg\";s:12:\"tmpl_created\";i:1608622517;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/beauty-salon-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:29:\"[\"404\",\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:45;s:16:\"popularity_index\";i:742;s:11:\"trend_index\";i:563;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:327;a:18:{s:4:\"tmpl\";i:1412;s:2:\"id\";i:24033;s:5:\"title\";s:37:\"Dance Studio &#8211; Maintenance Mode\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-Dance-Studio.jpg\";s:12:\"tmpl_created\";i:1649881344;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/dance-studio-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:113:\"[\"Academy\",\"Business\",\"Dance Studio\",\"Form\",\"Pilates\",\"School\",\"Sport\",\"Teacher\",\"Training\",\"Under Construction\"]\";s:10:\"menu_order\";i:45;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:328;a:18:{s:4:\"tmpl\";i:1190;s:2:\"id\";i:18568;s:5:\"title\";s:32:\"Flower Delivery &#8211; Business\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/04/Flower-Delivery.png\";s:12:\"tmpl_created\";i:1617546716;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/flower-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:37:\"[\"Delivery\",\"Flower\",\"Landing Pages\"]\";s:10:\"menu_order\";i:45;s:16:\"popularity_index\";i:874;s:11:\"trend_index\";i:763;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:329;a:18:{s:4:\"tmpl\";i:1130;s:2:\"id\";i:16535;s:5:\"title\";s:27:\"Beauty Salon &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/12/Footer.jpg\";s:12:\"tmpl_created\";i:1608622498;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/beauty-salon-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:32:\"[\"Beauty Salon\",\"Footer\",\"Hair\"]\";s:10:\"menu_order\";i:46;s:16:\"popularity_index\";i:524;s:11:\"trend_index\";i:126;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:330;a:18:{s:4:\"tmpl\";i:1145;s:2:\"id\";i:16917;s:5:\"title\";s:22:\"Webinar &#8211; Events\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/01/Webinar-Library-Pic.jpg\";s:12:\"tmpl_created\";i:1610466822;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/lp/webinar-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:36:\"[\"Events\",\"Landing Pages\",\"Webinar\"]\";s:10:\"menu_order\";i:46;s:16:\"popularity_index\";i:821;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:331;a:18:{s:4:\"tmpl\";i:1413;s:2:\"id\";i:24049;s:5:\"title\";s:33:\"ECO Shop &#8211; Maintenance Mode\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-ECO-Shop.jpg\";s:12:\"tmpl_created\";i:1649882053;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/eco-shop-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:110:\"[\"Aesthetic\",\"Business\",\"Creative\",\"Decor\",\"Health\",\"Help\",\"Lifestyle\",\"Products\",\"Shop\",\"Under Construction\"]\";s:10:\"menu_order\";i:46;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:332;a:18:{s:4:\"tmpl\";i:1129;s:2:\"id\";i:16545;s:5:\"title\";s:27:\"Beauty Salon &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/12/Header.jpg\";s:12:\"tmpl_created\";i:1608622495;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/beauty-salon-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:32:\"[\"Beauty Salon\",\"Hair\",\"Header\"]\";s:10:\"menu_order\";i:47;s:16:\"popularity_index\";i:356;s:11:\"trend_index\";i:49;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:333;a:18:{s:4:\"tmpl\";i:1154;s:2:\"id\";i:17079;s:5:\"title\";s:42:\"Calls Volunteer &#8211; Social Involvement\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/01/Calls-Volunteer.png\";s:12:\"tmpl_created\";i:1610631774;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/calls-volunteer-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Social Involvement\";s:4:\"tags\";s:68:\"[\"Care\",\"Covid-19\",\"Help\",\"Involvement\",\"Landing Pages\",\"Volunteer\"]\";s:10:\"menu_order\";i:47;s:16:\"popularity_index\";i:854;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:334;a:18:{s:4:\"tmpl\";i:1419;s:2:\"id\";i:24136;s:5:\"title\";s:29:\"Food Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Food-Blog.jpg\";s:12:\"tmpl_created\";i:1650990034;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/food-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:62:\"[\"Blog\",\"Business\",\"Coming Soon\",\"Cooking\",\"Education\",\"Food\"]\";s:10:\"menu_order\";i:47;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:335;a:18:{s:4:\"tmpl\";i:1142;s:2:\"id\";i:16836;s:5:\"title\";s:33:\"Marketing Agency &#8211; Business\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/01/Marketing-Agency-Library-Pic.jpg\";s:12:\"tmpl_created\";i:1610464490;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/marketing-agency-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:74:\"[\"Agency\",\"Business\",\"Landing Pages\",\"Marketing\",\"Marketing Landing Page\"]\";s:10:\"menu_order\";i:48;s:16:\"popularity_index\";i:816;s:11:\"trend_index\";i:787;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:336;a:18:{s:4:\"tmpl\";i:641;s:2:\"id\";i:7686;s:5:\"title\";s:12:\"Blog Posts 1\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2018/03/blog_posts.png\";s:12:\"tmpl_created\";i:1521558047;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/blog-posts-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:26:\"[\"Archive\",\"Blog\",\"posts\"]\";s:10:\"menu_order\";i:48;s:16:\"popularity_index\";i:131;s:11:\"trend_index\";i:152;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:337;a:18:{s:4:\"tmpl\";i:1411;s:2:\"id\";i:24020;s:5:\"title\";s:35:\"Mobile App &#8211; Maintenance Mode\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-Mobile-App.jpg\";s:12:\"tmpl_created\";i:1649880955;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/mobile-app-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:77:\"[\"App\",\"Business\",\"Coding\",\"Computer\",\"Launch\",\"Mobile\",\"Under Construction\"]\";s:10:\"menu_order\";i:48;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:338;a:18:{s:4:\"tmpl\";i:1139;s:2:\"id\";i:16785;s:5:\"title\";s:42:\"Gym Promotion &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2021/01/Gym-LP.jpg\";s:12:\"tmpl_created\";i:1610455496;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/gym-promotion-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:42:\"[\"Fitness\",\"Gym\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:49;s:16:\"popularity_index\";i:820;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:339;a:18:{s:4:\"tmpl\";i:1420;s:2:\"id\";i:24152;s:5:\"title\";s:32:\"Perfume Shop &#8211; Coming Soon\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Perfume-Shop.jpg\";s:12:\"tmpl_created\";i:1650990353;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/perfume-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:68:\"[\"Business\",\"Coming Soon\",\"Cosmetics\",\"Lifestyle\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:49;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:340;a:18:{s:4:\"tmpl\";i:484;s:2:\"id\";i:5283;s:5:\"title\";s:9:\"Clients 1\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_white_2.png\";s:12:\"tmpl_created\";i:1520443478;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/clients-1-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:49;s:16:\"popularity_index\";i:294;s:11:\"trend_index\";i:202;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:341;a:18:{s:4:\"tmpl\";i:1185;s:2:\"id\";i:18492;s:5:\"title\";s:34:\"Bicycle Pre-Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Bike-Landing-Page.png\";s:12:\"tmpl_created\";i:1617535552;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/bicycle-pre-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:34:\"[\"Bicycle\",\"Landing Pages\",\"Sale\"]\";s:10:\"menu_order\";i:50;s:16:\"popularity_index\";i:871;s:11:\"trend_index\";i:826;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:342;a:18:{s:4:\"tmpl\";i:487;s:2:\"id\";i:5306;s:5:\"title\";s:10:\"Clients 10\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_3.png\";s:12:\"tmpl_created\";i:1520443484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/clients-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:50;s:16:\"popularity_index\";i:657;s:11:\"trend_index\";i:581;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:343;a:18:{s:4:\"tmpl\";i:1418;s:2:\"id\";i:24126;s:5:\"title\";s:28:\"Skincare &#8211; Coming Soon\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Skincare.jpg\";s:12:\"tmpl_created\";i:1650989585;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/skincare-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:128:\"[\"Aesthetic\",\"Beauty\",\"Beauty Salon\",\"Business\",\"Coming Soon\",\"Cosmetics\",\"Girly\",\"Lifestyle\",\"Services\",\"Skincare\",\"Treatment\"]\";s:10:\"menu_order\";i:51;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:344;a:18:{s:4:\"tmpl\";i:1181;s:2:\"id\";i:18349;s:5:\"title\";s:39:\"Virtual try-on glasses &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280-8.png\";s:12:\"tmpl_created\";i:1614772569;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/lp/virtual-try-on-glasses-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:64:\"[\"Fashion\",\"Glasses\",\"Landing Pages\",\"Online Service\",\"Virtual\"]\";s:10:\"menu_order\";i:51;s:16:\"popularity_index\";i:848;s:11:\"trend_index\";i:803;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:345;a:18:{s:4:\"tmpl\";i:491;s:2:\"id\";i:5341;s:5:\"title\";s:10:\"Clients 11\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_4.png\";s:12:\"tmpl_created\";i:1520443491;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/clients-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:51;s:16:\"popularity_index\";i:603;s:11:\"trend_index\";i:633;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:346;a:18:{s:4:\"tmpl\";i:1410;s:2:\"id\";i:24004;s:5:\"title\";s:33:\"Skincare &#8211; Maintenance Mode\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-Skincare.jpg\";s:12:\"tmpl_created\";i:1649880534;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/skincare-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:144:\"[\"Aesthetic\",\"Beauty\",\"Beauty Salon\",\"Business\",\"Cosmetics\",\"Girly\",\"Lifestyle\",\"Makeup\",\"Services\",\"Skincare\",\"Treatment\",\"Under Construction\"]\";s:10:\"menu_order\";i:52;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:347;a:18:{s:4:\"tmpl\";i:1172;s:2:\"id\";i:17458;s:5:\"title\";s:31:\"Moving Company &#8211; Business\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-Moving-Company.png\";s:12:\"tmpl_created\";i:1612727025;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/moving-company-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:46:\"[\"Business\",\"Landing Pages\",\"Movers\",\"Moving\"]\";s:10:\"menu_order\";i:52;s:16:\"popularity_index\";i:826;s:11:\"trend_index\";i:767;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:348;a:18:{s:4:\"tmpl\";i:488;s:2:\"id\";i:5315;s:5:\"title\";s:10:\"Clients 12\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_4-1.png\";s:12:\"tmpl_created\";i:1520443486;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/clients-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:52;s:16:\"popularity_index\";i:485;s:11:\"trend_index\";i:263;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:349;a:18:{s:4:\"tmpl\";i:1415;s:2:\"id\";i:24092;s:5:\"title\";s:29:\"Vase Shop &#8211; Coming Soon\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Vase-Shop.jpg\";s:12:\"tmpl_created\";i:1650988613;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/vase-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:115:\"[\"Art\",\"Business\",\"Coming Soon\",\"Creative\",\"Decor\",\"Design\",\"Furniture Design\",\"Interior Design\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:53;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:350;a:18:{s:4:\"tmpl\";i:1186;s:2:\"id\";i:18517;s:5:\"title\";s:29:\"Food Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Food-Blog.png\";s:12:\"tmpl_created\";i:1617539897;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/food-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:45:\"[\"Blog\",\"Coming Soon\",\"Food\",\"Landing Pages\"]\";s:10:\"menu_order\";i:53;s:16:\"popularity_index\";i:844;s:11:\"trend_index\";i:672;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:351;a:18:{s:4:\"tmpl\";i:490;s:2:\"id\";i:5333;s:5:\"title\";s:10:\"Clients 13\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_6.png\";s:12:\"tmpl_created\";i:1520443489;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/clients-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:53;s:16:\"popularity_index\";i:234;s:11:\"trend_index\";i:128;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:352;a:18:{s:4:\"tmpl\";i:1167;s:2:\"id\";i:17379;s:5:\"title\";s:33:\"IT Service &#8211; Online Service\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-IT-Service.png\";s:12:\"tmpl_created\";i:1612713022;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/it-service-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:41:\"[\"IT\",\"Landing Pages\",\"Remote\",\"Support\"]\";s:10:\"menu_order\";i:54;s:16:\"popularity_index\";i:806;s:11:\"trend_index\";i:634;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:353;a:18:{s:4:\"tmpl\";i:1248;s:2:\"id\";i:22134;s:5:\"title\";s:32:\"Art Magazine &#8211; Coming Soon\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/10/Art-Magazine-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1647176713;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/art-magazine-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:48:\"[\"Art\",\"Coming Soon\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:54;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:354;a:18:{s:4:\"tmpl\";i:496;s:2:\"id\";i:5389;s:5:\"title\";s:10:\"Clients 14\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_black_9.png\";s:12:\"tmpl_created\";i:1520443501;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/clients-14/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:54;s:16:\"popularity_index\";i:407;s:11:\"trend_index\";i:307;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:355;a:18:{s:4:\"tmpl\";i:1189;s:2:\"id\";i:18560;s:5:\"title\";s:52:\"Finance Learning Platform &#8211; Under Construction\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Finance-Platform.png\";s:12:\"tmpl_created\";i:1617542761;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/lp/finance-learning-platform-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Under Construction\";s:4:\"tags\";s:27:\"[\"Finance\",\"Landing Pages\"]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:843;s:11:\"trend_index\";i:561;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:356;a:18:{s:4:\"tmpl\";i:1225;s:2:\"id\";i:21041;s:5:\"title\";s:41:\"Business Consulting Company &#8211; About\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2021/12/8-About-Business-Consulting-Company.jpg\";s:12:\"tmpl_created\";i:1638797560;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/business-consulting-company-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:51:\"[\"Coach\",\"Collaboration\",\"Consulting\",\"Life Coach\"]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:357;a:18:{s:4:\"tmpl\";i:486;s:2:\"id\";i:5298;s:5:\"title\";s:10:\"Clients 15\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_white_3.png\";s:12:\"tmpl_created\";i:1520443482;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/clients-15/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:465;s:11:\"trend_index\";i:520;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:358;a:18:{s:4:\"tmpl\";i:1187;s:2:\"id\";i:18528;s:5:\"title\";s:36:\"Home Decor Store &#8211; Coming Soon\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Home-Decore.png\";s:12:\"tmpl_created\";i:1617541784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/home-decor-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:57:\"[\"Coming Soon\",\"Decor\",\"Interior Design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:56;s:16:\"popularity_index\";i:872;s:11:\"trend_index\";i:819;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:359;a:18:{s:4:\"tmpl\";i:1243;s:2:\"id\";i:21135;s:5:\"title\";s:28:\"Construction &#8211; Service\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/13-Service-Construction.jpg\";s:12:\"tmpl_created\";i:1638823202;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/construction-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:48:\"[\"Architecture\",\"Construction\",\"Faq\",\"Services\"]\";s:10:\"menu_order\";i:56;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:360;a:18:{s:4:\"tmpl\";i:495;s:2:\"id\";i:5381;s:5:\"title\";s:10:\"Clients 16\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_9.png\";s:12:\"tmpl_created\";i:1520443499;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/clients-16/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:56;s:16:\"popularity_index\";i:198;s:11:\"trend_index\";i:168;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:361;a:18:{s:4:\"tmpl\";i:1174;s:2:\"id\";i:17504;s:5:\"title\";s:29:\"Hair Stylist &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/02/250x280-3.png\";s:12:\"tmpl_created\";i:1612883014;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/hair-stylist-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:59:\"[\"Business\",\"Hair\",\"hairdresser\",\"Landing Pages\",\"Stylist\"]\";s:10:\"menu_order\";i:57;s:16:\"popularity_index\";i:840;s:11:\"trend_index\";i:806;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:362;a:18:{s:4:\"tmpl\";i:1223;s:2:\"id\";i:20981;s:5:\"title\";s:37:\"Creative Digital Agency &#8211; About\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2021/12/6-About-Creative-Digital-Agency.jpg\";s:12:\"tmpl_created\";i:1638789303;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/creative-digital-agency-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:51:\"[\"About\",\"Advisor\",\"Creative\",\"Creative Portfolio\"]\";s:10:\"menu_order\";i:57;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:363;a:18:{s:4:\"tmpl\";i:493;s:2:\"id\";i:5357;s:5:\"title\";s:9:\"Clients 2\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_7.png\";s:12:\"tmpl_created\";i:1520443495;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/clients-2-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:57;s:16:\"popularity_index\";i:341;s:11:\"trend_index\";i:232;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:364;a:18:{s:4:\"tmpl\";i:1184;s:2:\"id\";i:18449;s:5:\"title\";s:45:\"Aesthetic Clinic &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2021/03/Aesthetic-Clinic.png\";s:12:\"tmpl_created\";i:1616682181;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/lp/aesthetic-clinic-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:57:\"[\"Aesthetic\",\"Beauty\",\"Fitness\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:58;s:16:\"popularity_index\";i:859;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:365;a:18:{s:4:\"tmpl\";i:1221;s:2:\"id\";i:20926;s:5:\"title\";s:33:\"Doctors Online Consultation -Home\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/12/4-Home-Doctors-Online-Consultation.jpg\";s:12:\"tmpl_created\";i:1638787371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/doctors-online-consultation-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:35:\"[\"App\",\"Health\",\"Medical\",\"Online\"]\";s:10:\"menu_order\";i:58;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:366;a:18:{s:4:\"tmpl\";i:485;s:2:\"id\";i:5290;s:5:\"title\";s:9:\"Clients 3\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_2.png\";s:12:\"tmpl_created\";i:1520443480;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/clients-3-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:58;s:16:\"popularity_index\";i:545;s:11:\"trend_index\";i:502;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:367;a:18:{s:4:\"tmpl\";i:1165;s:2:\"id\";i:17353;s:5:\"title\";s:44:\"Online Cooking Course &#8211; Online Service\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/02/250x280-2.png\";s:12:\"tmpl_created\";i:1612705144;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/lp/online-cooking-course-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:50:\"[\"Cooking\",\"Course Online\",\"Food\",\"Landing Pages\"]\";s:10:\"menu_order\";i:59;s:16:\"popularity_index\";i:845;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:368;a:18:{s:4:\"tmpl\";i:482;s:2:\"id\";i:5266;s:5:\"title\";s:9:\"Clients 4\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_white_1.png\";s:12:\"tmpl_created\";i:1520443474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/clients-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:59;s:16:\"popularity_index\";i:95;s:11:\"trend_index\";i:134;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:369;a:18:{s:4:\"tmpl\";i:1188;s:2:\"id\";i:18550;s:5:\"title\";s:39:\"Online Store &#8211; Under Construction\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Online-Store.png\";s:12:\"tmpl_created\";i:1617542506;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/lp/online-store-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Under Construction\";s:4:\"tags\";s:59:\"[\"Landing Pages\",\"Online Shop\",\"Shop\",\"Under Construction\"]\";s:10:\"menu_order\";i:60;s:16:\"popularity_index\";i:832;s:11:\"trend_index\";i:600;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:370;a:18:{s:4:\"tmpl\";i:1250;s:2:\"id\";i:22140;s:5:\"title\";s:33:\"Design School &#8211; Coming Soon\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/05/250x280-1.png\";s:12:\"tmpl_created\";i:1647177317;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/design-school-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:49:\"[\"Coming Soon\",\"Design\",\"Landing Pages\",\"School\"]\";s:10:\"menu_order\";i:60;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:371;a:18:{s:4:\"tmpl\";i:483;s:2:\"id\";i:5275;s:5:\"title\";s:9:\"Clients 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_1.png\";s:12:\"tmpl_created\";i:1520443476;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/clients-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:60;s:16:\"popularity_index\";i:334;s:11:\"trend_index\";i:321;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:372;a:18:{s:4:\"tmpl\";i:1191;s:2:\"id\";i:18539;s:5:\"title\";s:40:\"Travel Agency &#8211; Under Construction\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Travel-Agency-1.png\";s:12:\"tmpl_created\";i:1617610273;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/travel-agency-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Under Construction\";s:4:\"tags\";s:56:\"[\"Agency\",\"Landing Pages\",\"Travel\",\"Under Construction\"]\";s:10:\"menu_order\";i:61;s:16:\"popularity_index\";i:876;s:11:\"trend_index\";i:652;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:373;a:18:{s:4:\"tmpl\";i:492;s:2:\"id\";i:5349;s:5:\"title\";s:9:\"Clients 7\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_7.png\";s:12:\"tmpl_created\";i:1520443493;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/clients-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:61;s:16:\"popularity_index\";i:233;s:11:\"trend_index\";i:92;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:374;a:18:{s:4:\"tmpl\";i:1175;s:2:\"id\";i:18270;s:5:\"title\";s:24:\"Open week &#8211; Events\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280.png\";s:12:\"tmpl_created\";i:1614767186;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/open-week-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:59:\"[\"Education\",\"Event\",\"Events\",\"Landing Pages\",\"University\"]\";s:10:\"menu_order\";i:62;s:16:\"popularity_index\";i:831;s:11:\"trend_index\";i:673;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:375;a:18:{s:4:\"tmpl\";i:489;s:2:\"id\";i:5324;s:5:\"title\";s:9:\"Clients 8\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_5-1.png\";s:12:\"tmpl_created\";i:1520443488;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/clients-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:62;s:16:\"popularity_index\";i:526;s:11:\"trend_index\";i:381;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:376;a:18:{s:4:\"tmpl\";i:1177;s:2:\"id\";i:18300;s:5:\"title\";s:30:\"Makeup Artist &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280-2.png\";s:12:\"tmpl_created\";i:1614768608;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/makeup-artist-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:79:\"[\"Beauty\",\"Business\",\"Course Online\",\"Landing Pages\",\"Makeup\",\"Online Service\"]\";s:10:\"menu_order\";i:63;s:16:\"popularity_index\";i:861;s:11:\"trend_index\";i:783;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:377;a:18:{s:4:\"tmpl\";i:494;s:2:\"id\";i:5368;s:5:\"title\";s:9:\"Clients 9\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_8.png\";s:12:\"tmpl_created\";i:1520443497;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/clients-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:63;s:16:\"popularity_index\";i:253;s:11:\"trend_index\";i:273;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:378;a:18:{s:4:\"tmpl\";i:1179;s:2:\"id\";i:18329;s:5:\"title\";s:63:\"Online Real Estate Investment Conference &#8211; Online Service\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280-5.png\";s:12:\"tmpl_created\";i:1614770404;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:157:\"https://library.elementor.com/lp/online-real-estate-investment-conference-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:76:\"[\"Conference\",\"Event\",\"Events\",\"Landing Pages\",\"Online Event\",\"Real estate\"]\";s:10:\"menu_order\";i:64;s:16:\"popularity_index\";i:866;s:11:\"trend_index\";i:779;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:379;a:18:{s:4:\"tmpl\";i:425;s:2:\"id\";i:4436;s:5:\"title\";s:11:\"Contact  16\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_black_2.png\";s:12:\"tmpl_created\";i:1520443293;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/contact-16/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:64;s:16:\"popularity_index\";i:161;s:11:\"trend_index\";i:68;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:380;a:18:{s:4:\"tmpl\";i:1183;s:2:\"id\";i:18391;s:5:\"title\";s:45:\"Children&#8217;s Optometrist &#8211; Business\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Childrens-Optometrist.png\";s:12:\"tmpl_created\";i:1614773564;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/lp/childrens-optometrist-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:85:\"[\"Business\",\"Children\",\"Eye\",\"Glasses\",\"Health\",\"Kids\",\"Landing Pages\",\"Optometrist\"]\";s:10:\"menu_order\";i:65;s:16:\"popularity_index\";i:877;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:381;a:18:{s:4:\"tmpl\";i:423;s:2:\"id\";i:4420;s:5:\"title\";s:9:\"Contact 1\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_black_1.png\";s:12:\"tmpl_created\";i:1520443289;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/contact-1-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:65;s:16:\"popularity_index\";i:196;s:11:\"trend_index\";i:127;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:382;a:18:{s:4:\"tmpl\";i:534;s:2:\"id\";i:5836;s:5:\"title\";s:10:\"Contact 10\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/contact_white_2.png\";s:12:\"tmpl_created\";i:1520443597;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/contact-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:66;s:16:\"popularity_index\";i:114;s:11:\"trend_index\";i:76;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:383;a:18:{s:4:\"tmpl\";i:1182;s:2:\"id\";i:18366;s:5:\"title\";s:30:\"Car Insurance &#8211; Business\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Car-Insurance.png\";s:12:\"tmpl_created\";i:1614773263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/car-insurance-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:46:\"[\"Business\",\"car\",\"Insurance\",\"Landing Pages\"]\";s:10:\"menu_order\";i:66;s:16:\"popularity_index\";i:869;s:11:\"trend_index\";i:797;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:384;a:18:{s:4:\"tmpl\";i:1201;s:2:\"id\";i:19144;s:5:\"title\";s:25:\"Birthday Party Invitation\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/06/250x280.png\";s:12:\"tmpl_created\";i:1623848691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/birthday-party-invitation/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:67:\"[\"Birthday\",\"Event\",\"Landing Pages\",\"Party\",\"RSVD\",\"Save the Date\"]\";s:10:\"menu_order\";i:66;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:385;a:18:{s:4:\"tmpl\";i:535;s:2:\"id\";i:5844;s:5:\"title\";s:10:\"Contact 11\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/contact_black_2.png\";s:12:\"tmpl_created\";i:1520443599;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/contact-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:67;s:16:\"popularity_index\";i:289;s:11:\"trend_index\";i:313;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:386;a:18:{s:4:\"tmpl\";i:1124;s:2:\"id\";i:16473;s:5:\"title\";s:26:\"Beauty Salon &#8211; About\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/12/about-1.jpg\";s:12:\"tmpl_created\";i:1608622373;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/beauty-salon-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:67;s:16:\"popularity_index\";i:615;s:11:\"trend_index\";i:184;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:387;a:18:{s:4:\"tmpl\";i:1176;s:2:\"id\";i:18291;s:5:\"title\";s:47:\"Grill Restaurant Food Delivery &#8211; Business\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Food-Delivery-LP.png\";s:12:\"tmpl_created\";i:1614767830;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/lp/grill-restaurant-food-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:79:\"[\"Delivery\",\"Delivery Service\",\"Fast Food\",\"Food\",\"Landing Pages\",\"Restaurant\"]\";s:10:\"menu_order\";i:67;s:16:\"popularity_index\";i:819;s:11:\"trend_index\";i:685;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:388;a:18:{s:4:\"tmpl\";i:1125;s:2:\"id\";i:16488;s:5:\"title\";s:28:\"Beauty Salon &#8211; Contact\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/12/contact.jpg\";s:12:\"tmpl_created\";i:1608622374;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/beauty-salon-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:68;s:16:\"popularity_index\";i:548;s:11:\"trend_index\";i:101;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:389;a:18:{s:4:\"tmpl\";i:1180;s:2:\"id\";i:18340;s:5:\"title\";s:30:\"Restaurant &#8211; Coming Soon\";s:9:\"thumbnail\";s:98:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Restuarant-Coming-Soon-LP.png\";s:12:\"tmpl_created\";i:1614772183;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/restaurant-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:51:\"[\"Coming Soon\",\"Food\",\"Landing Pages\",\"Restaurant\"]\";s:10:\"menu_order\";i:68;s:16:\"popularity_index\";i:810;s:11:\"trend_index\";i:809;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:390;a:18:{s:4:\"tmpl\";i:430;s:2:\"id\";i:4476;s:5:\"title\";s:10:\"Contact 15\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_4.png\";s:12:\"tmpl_created\";i:1520443303;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/contact-15/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"Contact\",\"Form\"]\";s:10:\"menu_order\";i:68;s:16:\"popularity_index\";i:229;s:11:\"trend_index\";i:187;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:391;a:18:{s:4:\"tmpl\";i:1126;s:2:\"id\";i:16496;s:5:\"title\";s:28:\"Beauty Salon &#8211; Gallery\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/12/gallery-1.jpg\";s:12:\"tmpl_created\";i:1608622379;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/beauty-salon-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:69;s:16:\"popularity_index\";i:491;s:11:\"trend_index\";i:90;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:392;a:18:{s:4:\"tmpl\";i:1173;s:2:\"id\";i:17480;s:5:\"title\";s:42:\"At-home Massage Therapist &#8211; Business\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/02/At-Home-Massage-Therapist.jpg\";s:12:\"tmpl_created\";i:1612879264;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/at-home-massage-therapist-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:60:\"[\"Business\",\"Health\",\"Landing Pages\",\"Services\",\"Therapist\"]\";s:10:\"menu_order\";i:69;s:16:\"popularity_index\";i:856;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:393;a:18:{s:4:\"tmpl\";i:476;s:2:\"id\";i:5214;s:5:\"title\";s:10:\"Contact 16\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_2.png\";s:12:\"tmpl_created\";i:1520443462;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/contact-16-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"Contact\",\"Form\"]\";s:10:\"menu_order\";i:69;s:16:\"popularity_index\";i:194;s:11:\"trend_index\";i:106;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:394;a:18:{s:4:\"tmpl\";i:1127;s:2:\"id\";i:16457;s:5:\"title\";s:25:\"Beauty Salon &#8211; Home\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/12/home-1.jpg\";s:12:\"tmpl_created\";i:1608622383;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/beauty-salon-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:70;s:16:\"popularity_index\";i:408;s:11:\"trend_index\";i:56;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:395;a:18:{s:4:\"tmpl\";i:1178;s:2:\"id\";i:18317;s:5:\"title\";s:26:\"Insurance &#8211; Business\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Life-Insirance.png\";s:12:\"tmpl_created\";i:1614769488;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/lp/insurance-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:61:\"[\"Business\",\"Family\",\"Financial\",\"Insurance\",\"Landing Pages\"]\";s:10:\"menu_order\";i:70;s:16:\"popularity_index\";i:870;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:396;a:18:{s:4:\"tmpl\";i:478;s:2:\"id\";i:5230;s:5:\"title\";s:10:\"Contact 17\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_3.png\";s:12:\"tmpl_created\";i:1520443466;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/contact-17/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"Contact\",\"Form\"]\";s:10:\"menu_order\";i:70;s:16:\"popularity_index\";i:339;s:11:\"trend_index\";i:335;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:397;a:18:{s:4:\"tmpl\";i:1128;s:2:\"id\";i:16518;s:5:\"title\";s:29:\"Beauty Salon &#8211; Services\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/12/services-1.jpg\";s:12:\"tmpl_created\";i:1608622386;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/beauty-salon-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:71;s:16:\"popularity_index\";i:664;s:11:\"trend_index\";i:261;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:398;a:18:{s:4:\"tmpl\";i:1168;s:2:\"id\";i:17401;s:5:\"title\";s:40:\"Conference Thank You Page &#8211; Events\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/02/250x280.png\";s:12:\"tmpl_created\";i:1612724753;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/conference-thank-you-page-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Thank You Page\";s:4:\"tags\";s:59:\"[\"Conference\",\"Event\",\"Events\",\"Landing Pages\",\"Thank You\"]\";s:10:\"menu_order\";i:71;s:16:\"popularity_index\";i:799;s:11:\"trend_index\";i:540;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:399;a:18:{s:4:\"tmpl\";i:481;s:2:\"id\";i:5257;s:5:\"title\";s:10:\"Contact 18\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_5.png\";s:12:\"tmpl_created\";i:1520443472;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/contact-18/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:8:\"[\"Form\"]\";s:10:\"menu_order\";i:71;s:16:\"popularity_index\";i:438;s:11:\"trend_index\";i:490;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:400;a:18:{s:4:\"tmpl\";i:532;s:2:\"id\";i:5820;s:5:\"title\";s:9:\"Contact 2\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/contact_white_1.png\";s:12:\"tmpl_created\";i:1520443593;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/contact-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:72;s:16:\"popularity_index\";i:183;s:11:\"trend_index\";i:357;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:401;a:18:{s:4:\"tmpl\";i:1073;s:2:\"id\";i:15486;s:5:\"title\";s:25:\"Travel Blog &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/11/About.jpg\";s:12:\"tmpl_created\";i:1606215720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/travel-blog-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:72;s:16:\"popularity_index\";i:608;s:11:\"trend_index\";i:343;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:402;a:18:{s:4:\"tmpl\";i:1166;s:2:\"id\";i:17368;s:5:\"title\";s:38:\"Real Estate Agency &#8211; Real-Estate\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-Real-Estate.png\";s:12:\"tmpl_created\";i:1612711814;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/lp/real-estate-agency-real-estate/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:11:\"Real Estate\";s:4:\"tags\";s:73:\"[\"Landing Pages\",\"listing\",\"Real estate\",\"Realestate\",\"realtor\",\"realty\"]\";s:10:\"menu_order\";i:72;s:16:\"popularity_index\";i:858;s:11:\"trend_index\";i:777;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:403;a:18:{s:4:\"tmpl\";i:1074;s:2:\"id\";i:15478;s:5:\"title\";s:27:\"Travel Blog &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/11/Contact-Us.jpg\";s:12:\"tmpl_created\";i:1606215735;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/travel-blog-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:73;s:16:\"popularity_index\";i:687;s:11:\"trend_index\";i:564;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:404;a:18:{s:4:\"tmpl\";i:1170;s:2:\"id\";i:17423;s:5:\"title\";s:57:\"Volunteer Calls Thank You Page &#8211; Social Involvement\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/02/Volunteer-Calls-TYP.jpg\";s:12:\"tmpl_created\";i:1612726058;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:151:\"https://library.elementor.com/lp/volunteer-calls-thank-you-page-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Thank You Page\";s:4:\"tags\";s:62:\"[\"Care\",\"Involvement\",\"Landing Pages\",\"Thank You\",\"Volunteer\"]\";s:10:\"menu_order\";i:73;s:16:\"popularity_index\";i:857;s:11:\"trend_index\";i:818;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:405;a:18:{s:4:\"tmpl\";i:422;s:2:\"id\";i:4411;s:5:\"title\";s:9:\"Contact 3\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_white_1.png\";s:12:\"tmpl_created\";i:1520443287;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/contact-3-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:73;s:16:\"popularity_index\";i:113;s:11:\"trend_index\";i:217;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:406;a:18:{s:4:\"tmpl\";i:533;s:2:\"id\";i:5828;s:5:\"title\";s:9:\"Contact 3\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/contact_black_1.png\";s:12:\"tmpl_created\";i:1520443595;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/contact-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:74;s:16:\"popularity_index\";i:312;s:11:\"trend_index\";i:495;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:407;a:18:{s:4:\"tmpl\";i:1075;s:2:\"id\";i:15467;s:5:\"title\";s:24:\"Travel Blog &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/11/Home.jpg\";s:12:\"tmpl_created\";i:1606215756;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/travel-blog-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:74;s:16:\"popularity_index\";i:567;s:11:\"trend_index\";i:224;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:408;a:18:{s:4:\"tmpl\";i:1169;s:2:\"id\";i:17409;s:5:\"title\";s:37:\"Webinar Thank You Page &#8211; Events\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-Webinar-TYP.png\";s:12:\"tmpl_created\";i:1612725644;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/lp/webinar-thank-you-page-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Thank You Page\";s:4:\"tags\";s:56:\"[\"Event\",\"Events\",\"Landing Pages\",\"Thank You\",\"Webinar\"]\";s:10:\"menu_order\";i:74;s:16:\"popularity_index\";i:868;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:409;a:18:{s:4:\"tmpl\";i:1056;s:2:\"id\";i:15317;s:5:\"title\";s:25:\"Dance Studio &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/10/Home.jpg\";s:12:\"tmpl_created\";i:1603181291;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/dance-studio-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:75;s:16:\"popularity_index\";i:596;s:11:\"trend_index\";i:301;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:410;a:18:{s:4:\"tmpl\";i:1160;s:2:\"id\";i:17258;s:5:\"title\";s:32:\"Beauty Product &#8211; eCommerce\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2021/01/Beauty-Product.png\";s:12:\"tmpl_created\";i:1610903153;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/beauty-product-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:38:\"[\"Beauty\",\"Ecommerce\",\"Landing Pages\"]\";s:10:\"menu_order\";i:75;s:16:\"popularity_index\";i:797;s:11:\"trend_index\";i:703;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:411;a:18:{s:4:\"tmpl\";i:424;s:2:\"id\";i:4428;s:5:\"title\";s:9:\"Contact 4\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_white_2.png\";s:12:\"tmpl_created\";i:1520443291;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/contact-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:75;s:16:\"popularity_index\";i:118;s:11:\"trend_index\";i:131;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:412;a:18:{s:4:\"tmpl\";i:1057;s:2:\"id\";i:15334;s:5:\"title\";s:26:\"Dance Studio &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/10/About.jpg\";s:12:\"tmpl_created\";i:1603181364;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/dance-studio-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:76;s:16:\"popularity_index\";i:626;s:11:\"trend_index\";i:373;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:413;a:18:{s:4:\"tmpl\";i:1171;s:2:\"id\";i:17435;s:5:\"title\";s:39:\"Gym &#8211; App Service &#8211; Product\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/02/250x280-4.png\";s:12:\"tmpl_created\";i:1612726462;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/gym-app-service-product/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:58:\"[\"App\",\"Fitness\",\"Gym\",\"Health\",\"Landing Pages\",\"Product\"]\";s:10:\"menu_order\";i:76;s:16:\"popularity_index\";i:767;s:11:\"trend_index\";i:577;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:414;a:18:{s:4:\"tmpl\";i:426;s:2:\"id\";i:4444;s:5:\"title\";s:9:\"Contact 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_1.png\";s:12:\"tmpl_created\";i:1520443295;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/contact-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:76;s:16:\"popularity_index\";i:84;s:11:\"trend_index\";i:93;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:415;a:18:{s:4:\"tmpl\";i:1058;s:2:\"id\";i:15349;s:5:\"title\";s:28:\"Dance Studio &#8211; Classes\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/10/Classes.jpg\";s:12:\"tmpl_created\";i:1603181425;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/dance-studio-classes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:77;s:16:\"popularity_index\";i:629;s:11:\"trend_index\";i:458;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:416;a:18:{s:4:\"tmpl\";i:1156;s:2:\"id\";i:17111;s:5:\"title\";s:33:\"Sunglasses Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/01/Sunglasses-LP-Library-Pic.jpg\";s:12:\"tmpl_created\";i:1610632408;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/sunglasses-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:59:\"[\"Ecommerce\",\"Fashion\",\"Landing Pages\",\"Sale\",\"Sunglasses\"]\";s:10:\"menu_order\";i:77;s:16:\"popularity_index\";i:812;s:11:\"trend_index\";i:732;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:417;a:18:{s:4:\"tmpl\";i:432;s:2:\"id\";i:4492;s:5:\"title\";s:9:\"Contact 5\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_white_3.png\";s:12:\"tmpl_created\";i:1520443307;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/contact-5-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:77;s:16:\"popularity_index\";i:37;s:11:\"trend_index\";i:31;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:418;a:18:{s:4:\"tmpl\";i:1055;s:2:\"id\";i:15366;s:5:\"title\";s:29:\"Dance Studio &#8211; Schedule\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2020/10/Classes-Schedule.jpg\";s:12:\"tmpl_created\";i:1603181056;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/dance-studio-schedule/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:78;s:16:\"popularity_index\";i:698;s:11:\"trend_index\";i:602;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:419;a:18:{s:4:\"tmpl\";i:1157;s:2:\"id\";i:17223;s:5:\"title\";s:25:\"Fashion &#8211; eCommerce\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2021/01/Commerce-Fashion.png\";s:12:\"tmpl_created\";i:1610902553;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/fashion-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:29:\"[\"Ecommerce\",\"Landing Pages\"]\";s:10:\"menu_order\";i:78;s:16:\"popularity_index\";i:808;s:11:\"trend_index\";i:745;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:420;a:18:{s:4:\"tmpl\";i:427;s:2:\"id\";i:4452;s:5:\"title\";s:9:\"Contact 6\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_black_1.png\";s:12:\"tmpl_created\";i:1520443296;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/contact-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:78;s:16:\"popularity_index\";i:139;s:11:\"trend_index\";i:150;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:421;a:18:{s:4:\"tmpl\";i:1059;s:2:\"id\";i:15373;s:5:\"title\";s:28:\"Dance Studio &#8211; Pricing\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/10/Pricing.jpg\";s:12:\"tmpl_created\";i:1603181678;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/dance-studio-pricing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:79;s:16:\"popularity_index\";i:731;s:11:\"trend_index\";i:661;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:422;a:18:{s:4:\"tmpl\";i:1151;s:2:\"id\";i:17017;s:5:\"title\";s:28:\"Shoes Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/01/Shoes-LP-Library-Pic.jpg\";s:12:\"tmpl_created\";i:1610535361;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/shoes-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:55:\"[\"Discount\",\"Ecommerce\",\"Landing Pages\",\"Sale\",\"Shoes\"]\";s:10:\"menu_order\";i:79;s:16:\"popularity_index\";i:803;s:11:\"trend_index\";i:642;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:423;a:18:{s:4:\"tmpl\";i:429;s:2:\"id\";i:4468;s:5:\"title\";s:9:\"Contact 7\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_3.png\";s:12:\"tmpl_created\";i:1520443301;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/contact-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"Contact\",\"Form\"]\";s:10:\"menu_order\";i:79;s:16:\"popularity_index\";i:127;s:11:\"trend_index\";i:72;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:424;a:18:{s:4:\"tmpl\";i:1060;s:2:\"id\";i:15384;s:5:\"title\";s:28:\"Dance Studio &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/10/Contact-Us.jpg\";s:12:\"tmpl_created\";i:1603181738;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/dance-studio-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:80;s:16:\"popularity_index\";i:741;s:11:\"trend_index\";i:721;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:425;a:18:{s:4:\"tmpl\";i:1163;s:2:\"id\";i:17301;s:5:\"title\";s:53:\"Personal Chef &#8211; Thank You Page &#8211; Business\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2021/01/TYP-Personal-Chef.jpg\";s:12:\"tmpl_created\";i:1610903622;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/lp/personal-chef-thank-you-page-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Thank You Page\";s:4:\"tags\";s:43:\"[\"Chef\",\"Food\",\"Landing Pages\",\"Thank You\"]\";s:10:\"menu_order\";i:80;s:16:\"popularity_index\";i:823;s:11:\"trend_index\";i:754;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:426;a:18:{s:4:\"tmpl\";i:431;s:2:\"id\";i:4484;s:5:\"title\";s:9:\"Contact 8\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_black_3.png\";s:12:\"tmpl_created\";i:1520443305;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/contact-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"Contact\",\"Form\"]\";s:10:\"menu_order\";i:80;s:16:\"popularity_index\";i:328;s:11:\"trend_index\";i:260;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:427;a:18:{s:4:\"tmpl\";i:1042;s:2:\"id\";i:15158;s:5:\"title\";s:26:\"Psychologist &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/09/About.jpg\";s:12:\"tmpl_created\";i:1600157561;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/psychologist-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:81;s:16:\"popularity_index\";i:618;s:11:\"trend_index\";i:426;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:428;a:18:{s:4:\"tmpl\";i:1164;s:2:\"id\";i:17313;s:5:\"title\";s:60:\"Development Course  &#8211; Thank You Page &#8211; Education\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/01/Dev-Course-TYP-.png\";s:12:\"tmpl_created\";i:1610903776;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/lp/development-course-thank-you-page-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Thank You Page\";s:4:\"tags\";s:57:\"[\"Course Online\",\"Education\",\"Landing Pages\",\"Thank You\"]\";s:10:\"menu_order\";i:81;s:16:\"popularity_index\";i:834;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:429;a:18:{s:4:\"tmpl\";i:428;s:2:\"id\";i:4460;s:5:\"title\";s:9:\"Contact 9\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_2.png\";s:12:\"tmpl_created\";i:1520443298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/contact-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:81;s:16:\"popularity_index\";i:99;s:11:\"trend_index\";i:80;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:430;a:18:{s:4:\"tmpl\";i:1045;s:2:\"id\";i:15197;s:5:\"title\";s:28:\"Psychologist &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/09/Contact-Us.jpg\";s:12:\"tmpl_created\";i:1600160499;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/psychologist-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:82;s:16:\"popularity_index\";i:666;s:11:\"trend_index\";i:558;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:431;a:18:{s:4:\"tmpl\";i:613;s:2:\"id\";i:5558;s:5:\"title\";s:5:\"CTA 1\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_2.png\";s:12:\"tmpl_created\";i:1520520684;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/cta-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:82;s:16:\"popularity_index\";i:129;s:11:\"trend_index\";i:69;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:432;a:18:{s:4:\"tmpl\";i:1041;s:2:\"id\";i:15142;s:5:\"title\";s:25:\"Psychologist &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/09/Home.jpg\";s:12:\"tmpl_created\";i:1600156308;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/psychologist-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:83;s:16:\"popularity_index\";i:464;s:11:\"trend_index\";i:297;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:433;a:18:{s:4:\"tmpl\";i:634;s:2:\"id\";i:5939;s:5:\"title\";s:6:\"CTA 10\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_13-1.png\";s:12:\"tmpl_created\";i:1520520760;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:83;s:16:\"popularity_index\";i:190;s:11:\"trend_index\";i:118;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:434;a:18:{s:4:\"tmpl\";i:1044;s:2:\"id\";i:15188;s:5:\"title\";s:28:\"Psychologist &#8211; Pricing\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/09/Pricing.jpg\";s:12:\"tmpl_created\";i:1600159731;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/psychologist-pricing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:84;s:16:\"popularity_index\";i:732;s:11:\"trend_index\";i:537;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:435;a:18:{s:4:\"tmpl\";i:633;s:2:\"id\";i:5930;s:5:\"title\";s:6:\"CTA 11\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_15.png\";s:12:\"tmpl_created\";i:1520520758;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:84;s:16:\"popularity_index\";i:76;s:11:\"trend_index\";i:84;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:436;a:18:{s:4:\"tmpl\";i:1043;s:2:\"id\";i:15167;s:5:\"title\";s:29:\"Psychologist &#8211; Services\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/09/Services.jpg\";s:12:\"tmpl_created\";i:1600158206;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/psychologist-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:85;s:16:\"popularity_index\";i:606;s:11:\"trend_index\";i:379;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:437;a:18:{s:4:\"tmpl\";i:632;s:2:\"id\";i:5921;s:5:\"title\";s:6:\"CTA 12\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_14.png\";s:12:\"tmpl_created\";i:1520520757;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:85;s:16:\"popularity_index\";i:278;s:11:\"trend_index\";i:234;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:438;a:18:{s:4:\"tmpl\";i:1036;s:2:\"id\";i:14932;s:5:\"title\";s:30:\"Flooring Company &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/08/About.png\";s:12:\"tmpl_created\";i:1597740110;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/flooring-company-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:86;s:16:\"popularity_index\";i:488;s:11:\"trend_index\";i:319;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:439;a:18:{s:4:\"tmpl\";i:618;s:2:\"id\";i:5607;s:5:\"title\";s:6:\"CTA 13\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_5.png\";s:12:\"tmpl_created\";i:1520520695;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:86;s:16:\"popularity_index\";i:42;s:11:\"trend_index\";i:11;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:440;a:18:{s:4:\"tmpl\";i:1037;s:2:\"id\";i:14998;s:5:\"title\";s:32:\"Flooring Company &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/08/Contact-Us.png\";s:12:\"tmpl_created\";i:1597740222;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/flooring-company-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:87;s:16:\"popularity_index\";i:553;s:11:\"trend_index\";i:380;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:441;a:18:{s:4:\"tmpl\";i:574;s:2:\"id\";i:6017;s:5:\"title\";s:6:\"CTA 14\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_14.png\";s:12:\"tmpl_created\";i:1520520331;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-14/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:87;s:16:\"popularity_index\";i:152;s:11:\"trend_index\";i:122;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:442;a:18:{s:4:\"tmpl\";i:1038;s:2:\"id\";i:14965;s:5:\"title\";s:32:\"Flooring Company &#8211; Gallery\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/08/Gallery.png\";s:12:\"tmpl_created\";i:1597740353;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/flooring-company-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:88;s:16:\"popularity_index\";i:371;s:11:\"trend_index\";i:291;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:443;a:18:{s:4:\"tmpl\";i:628;s:2:\"id\";i:5885;s:5:\"title\";s:6:\"CTA 15\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_11.png\";s:12:\"tmpl_created\";i:1520520751;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-15/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:88;s:16:\"popularity_index\";i:274;s:11:\"trend_index\";i:256;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:444;a:18:{s:4:\"tmpl\";i:1282;s:2:\"id\";i:22417;s:5:\"title\";s:52:\"Finance Learning Platform &#8211; Under Construction\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Finance-Platform.png\";s:12:\"tmpl_created\";i:1647354987;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/finance-learning-platform-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Finance\",\"Landing Pages\"]\";s:10:\"menu_order\";i:89;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:445;a:18:{s:4:\"tmpl\";i:627;s:2:\"id\";i:5877;s:5:\"title\";s:6:\"CTA 16\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_10.png\";s:12:\"tmpl_created\";i:1520520749;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-16/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:89;s:16:\"popularity_index\";i:564;s:11:\"trend_index\";i:677;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:446;a:18:{s:4:\"tmpl\";i:1040;s:2:\"id\";i:14947;s:5:\"title\";s:33:\"Flooring company &#8211; Services\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/08/Services.png\";s:12:\"tmpl_created\";i:1597740551;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/flooring-company-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:90;s:16:\"popularity_index\";i:538;s:11:\"trend_index\";i:392;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:447;a:18:{s:4:\"tmpl\";i:625;s:2:\"id\";i:5860;s:5:\"title\";s:6:\"CTA 17\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_9.png\";s:12:\"tmpl_created\";i:1520520746;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-17/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:90;s:16:\"popularity_index\";i:120;s:11:\"trend_index\";i:63;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:448;a:18:{s:4:\"tmpl\";i:1039;s:2:\"id\";i:14901;s:5:\"title\";s:29:\"Flooring Company &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/08/Home.png\";s:12:\"tmpl_created\";i:1597740474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/flooring-company-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:91;s:16:\"popularity_index\";i:387;s:11:\"trend_index\";i:185;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:449;a:18:{s:4:\"tmpl\";i:626;s:2:\"id\";i:5869;s:5:\"title\";s:6:\"CTA 18\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_10.png\";s:12:\"tmpl_created\";i:1520520747;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-18/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:91;s:16:\"popularity_index\";i:345;s:11:\"trend_index\";i:486;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:450;a:18:{s:4:\"tmpl\";i:611;s:2:\"id\";i:5542;s:5:\"title\";s:6:\"CTA 19\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_1.png\";s:12:\"tmpl_created\";i:1520520681;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-19/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:92;s:16:\"popularity_index\";i:169;s:11:\"trend_index\";i:270;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:451;a:18:{s:4:\"tmpl\";i:1252;s:2:\"id\";i:22146;s:5:\"title\";s:36:\"Home Decor Store &#8211; Coming Soon\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Home-Decore.png\";s:12:\"tmpl_created\";i:1647177514;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/home-decor-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:57:\"[\"Coming Soon\",\"Decor\",\"Interior Design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:92;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:452;a:18:{s:4:\"tmpl\";i:614;s:2:\"id\";i:5567;s:5:\"title\";s:5:\"CTA 2\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_2.png\";s:12:\"tmpl_created\";i:1520520685;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/cta-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:93;s:16:\"popularity_index\";i:143;s:11:\"trend_index\";i:225;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:453;a:18:{s:4:\"tmpl\";i:1021;s:2:\"id\";i:14737;s:5:\"title\";s:32:\"Luxury Real Estate &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/07/About.png\";s:12:\"tmpl_created\";i:1595313527;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/luxury-real-estate-about-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:93;s:16:\"popularity_index\";i:150;s:11:\"trend_index\";i:447;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:454;a:18:{s:4:\"tmpl\";i:629;s:2:\"id\";i:5893;s:5:\"title\";s:6:\"CTA 21\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_12.png\";s:12:\"tmpl_created\";i:1520520752;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-21/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:94;s:16:\"popularity_index\";i:259;s:11:\"trend_index\";i:457;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:455;a:18:{s:4:\"tmpl\";i:1020;s:2:\"id\";i:14756;s:5:\"title\";s:34:\"Luxury Real Estate &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/07/Contact-Us.png\";s:12:\"tmpl_created\";i:1595313519;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/luxury-real-estate-contact-us-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:94;s:16:\"popularity_index\";i:610;s:11:\"trend_index\";i:569;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:456;a:18:{s:4:\"tmpl\";i:619;s:2:\"id\";i:5634;s:5:\"title\";s:6:\"CTA 24\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_6.png\";s:12:\"tmpl_created\";i:1520520699;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-24/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:95;s:16:\"popularity_index\";i:188;s:11:\"trend_index\";i:255;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:457;a:18:{s:4:\"tmpl\";i:1019;s:2:\"id\";i:14716;s:5:\"title\";s:31:\"Luxury Real Estate &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/07/Home.png\";s:12:\"tmpl_created\";i:1595313512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/luxury-real-estate-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:95;s:16:\"popularity_index\";i:394;s:11:\"trend_index\";i:165;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:458;a:18:{s:4:\"tmpl\";i:620;s:2:\"id\";i:5642;s:5:\"title\";s:6:\"CTA 25\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_6.png\";s:12:\"tmpl_created\";i:1520520701;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-25/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:96;s:16:\"popularity_index\";i:226;s:11:\"trend_index\";i:262;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:459;a:18:{s:4:\"tmpl\";i:1018;s:2:\"id\";i:14763;s:5:\"title\";s:31:\"Luxury Real Estate &#8211; News\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/07/news-Archive.png\";s:12:\"tmpl_created\";i:1595313273;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/luxury-real-estate-news-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:96;s:16:\"popularity_index\";i:404;s:11:\"trend_index\";i:167;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:460;a:18:{s:4:\"tmpl\";i:1283;s:2:\"id\";i:22423;s:5:\"title\";s:39:\"Online Store &#8211; Under Construction\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Online-Store.png\";s:12:\"tmpl_created\";i:1647355154;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/online-store-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:59:\"[\"Landing Pages\",\"Online Shop\",\"Shop\",\"Under Construction\"]\";s:10:\"menu_order\";i:97;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:461;a:18:{s:4:\"tmpl\";i:615;s:2:\"id\";i:5583;s:5:\"title\";s:6:\"CTA 26\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_3.png\";s:12:\"tmpl_created\";i:1520520689;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-26/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:97;s:16:\"popularity_index\";i:117;s:11:\"trend_index\";i:117;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:462;a:18:{s:4:\"tmpl\";i:630;s:2:\"id\";i:5904;s:5:\"title\";s:6:\"CTA 27\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_13.png\";s:12:\"tmpl_created\";i:1520520754;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-27/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:98;s:16:\"popularity_index\";i:528;s:11:\"trend_index\";i:517;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:463;a:18:{s:4:\"tmpl\";i:1010;s:2:\"id\";i:13960;s:5:\"title\";s:32:\"Japanese restaurant &#8211; Home\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/06/Home-Page.jpg\";s:12:\"tmpl_created\";i:1592289775;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/japanese-restaurant-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:98;s:16:\"popularity_index\";i:537;s:11:\"trend_index\";i:287;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:464;a:18:{s:4:\"tmpl\";i:1284;s:2:\"id\";i:22428;s:5:\"title\";s:40:\"Travel Agency &#8211; Under Construction\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Travel-Agency-1.png\";s:12:\"tmpl_created\";i:1647355339;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/travel-agency-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:56:\"[\"Agency\",\"Landing Pages\",\"Travel\",\"Under Construction\"]\";s:10:\"menu_order\";i:99;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:465;a:18:{s:4:\"tmpl\";i:631;s:2:\"id\";i:5912;s:5:\"title\";s:6:\"CTA 28\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_11.png\";s:12:\"tmpl_created\";i:1520520755;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-28/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:99;s:16:\"popularity_index\";i:665;s:11:\"trend_index\";i:702;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:466;a:18:{s:4:\"tmpl\";i:473;s:2:\"id\";i:5189;s:5:\"title\";s:6:\"CTA 29\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_1.png\";s:12:\"tmpl_created\";i:1520443456;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-29/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:8:\"[\"Form\"]\";s:10:\"menu_order\";i:100;s:16:\"popularity_index\";i:472;s:11:\"trend_index\";i:631;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:467;a:18:{s:4:\"tmpl\";i:1007;s:2:\"id\";i:13993;s:5:\"title\";s:45:\"Japanese restaurant &#8211; Chef&#8217;s Menu\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2020/06/Chef_s-Menu-Page.jpg\";s:12:\"tmpl_created\";i:1592289691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/japanese-restaurant-chefs-menu/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:100;s:16:\"popularity_index\";i:651;s:11:\"trend_index\";i:675;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:468;a:18:{s:4:\"tmpl\";i:623;s:2:\"id\";i:5667;s:5:\"title\";s:5:\"CTA 3\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_8.png\";s:12:\"tmpl_created\";i:1520520705;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/cta-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:101;s:16:\"popularity_index\";i:171;s:11:\"trend_index\";i:250;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:469;a:18:{s:4:\"tmpl\";i:1006;s:2:\"id\";i:14012;s:5:\"title\";s:36:\"Japanese restaurant &#8211; Bar Menu\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2020/06/Bar-Menu-Page.jpg\";s:12:\"tmpl_created\";i:1592289665;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/japanese-restaurant-bar-menu/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:101;s:16:\"popularity_index\";i:735;s:11:\"trend_index\";i:829;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:470;a:18:{s:4:\"tmpl\";i:474;s:2:\"id\";i:5198;s:5:\"title\";s:6:\"CTA 30\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_black_1.png\";s:12:\"tmpl_created\";i:1520443458;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-30/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:8:\"[\"Form\"]\";s:10:\"menu_order\";i:102;s:16:\"popularity_index\";i:572;s:11:\"trend_index\";i:511;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:471;a:18:{s:4:\"tmpl\";i:1005;s:2:\"id\";i:13917;s:5:\"title\";s:33:\"Japanese restaurant &#8211; About\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/06/About-Page.jpg\";s:12:\"tmpl_created\";i:1592289629;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/japanese-restaurant-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:102;s:16:\"popularity_index\";i:640;s:11:\"trend_index\";i:389;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:472;a:18:{s:4:\"tmpl\";i:475;s:2:\"id\";i:5206;s:5:\"title\";s:6:\"CTA 31\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_black_2.png\";s:12:\"tmpl_created\";i:1520443459;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-31/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:8:\"[\"Form\"]\";s:10:\"menu_order\";i:103;s:16:\"popularity_index\";i:593;s:11:\"trend_index\";i:611;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:473;a:18:{s:4:\"tmpl\";i:1009;s:2:\"id\";i:13937;s:5:\"title\";s:35:\"Japanese restaurant &#8211; Gallery\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/06/Gallery-Page.jpg\";s:12:\"tmpl_created\";i:1592289748;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/japanese-restaurant-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:103;s:16:\"popularity_index\";i:648;s:11:\"trend_index\";i:551;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:474;a:18:{s:4:\"tmpl\";i:480;s:2:\"id\";i:5249;s:5:\"title\";s:6:\"CTA 32\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_black_4.png\";s:12:\"tmpl_created\";i:1520443470;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-32/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:8:\"[\"Form\"]\";s:10:\"menu_order\";i:104;s:16:\"popularity_index\";i:512;s:11:\"trend_index\";i:409;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:475;a:18:{s:4:\"tmpl\";i:1008;s:2:\"id\";i:14030;s:5:\"title\";s:34:\"Japanese restaurant &#8211; Events\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/06/Events-Page.jpg\";s:12:\"tmpl_created\";i:1592289713;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/japanese-restaurant-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:104;s:16:\"popularity_index\";i:723;s:11:\"trend_index\";i:711;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:476;a:18:{s:4:\"tmpl\";i:612;s:2:\"id\";i:5550;s:5:\"title\";s:6:\"CTA 33\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_1.png\";s:12:\"tmpl_created\";i:1520520682;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-33/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:105;s:16:\"popularity_index\";i:260;s:11:\"trend_index\";i:562;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:477;a:18:{s:4:\"tmpl\";i:1016;s:2:\"id\";i:13984;s:5:\"title\";s:40:\"Japanese restaurant &#8211; Reservations\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/06/reservations.jpg\";s:12:\"tmpl_created\";i:1592294757;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/japanese-restaurant-reservations/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:105;s:16:\"popularity_index\";i:715;s:11:\"trend_index\";i:727;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:478;a:18:{s:4:\"tmpl\";i:536;s:2:\"id\";i:5852;s:5:\"title\";s:6:\"CTA 34\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2018/03/form_1.png\";s:12:\"tmpl_created\";i:1520443600;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-34/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:8:\"[\"Form\"]\";s:10:\"menu_order\";i:106;s:16:\"popularity_index\";i:563;s:11:\"trend_index\";i:828;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:479;a:18:{s:4:\"tmpl\";i:999;s:2:\"id\";i:13479;s:5:\"title\";s:23:\"Barbershop &#8211; Home\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/05/Home-Page.jpg\";s:12:\"tmpl_created\";i:1589893275;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/barbershop-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:106;s:16:\"popularity_index\";i:683;s:11:\"trend_index\";i:832;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:480;a:18:{s:4:\"tmpl\";i:624;s:2:\"id\";i:5675;s:5:\"title\";s:5:\"CTA 4\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_8.png\";s:12:\"tmpl_created\";i:1520520707;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/cta-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:107;s:16:\"popularity_index\";i:391;s:11:\"trend_index\";i:484;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:481;a:18:{s:4:\"tmpl\";i:1000;s:2:\"id\";i:13503;s:5:\"title\";s:24:\"Barbershop &#8211; About\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/05/About-Page.jpg\";s:12:\"tmpl_created\";i:1589893289;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/barbershop-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:107;s:16:\"popularity_index\";i:744;s:11:\"trend_index\";i:739;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:482;a:18:{s:4:\"tmpl\";i:616;s:2:\"id\";i:5591;s:5:\"title\";s:5:\"CTA 5\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_4.png\";s:12:\"tmpl_created\";i:1520520691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/cta-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:108;s:16:\"popularity_index\";i:133;s:11:\"trend_index\";i:130;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:483;a:18:{s:4:\"tmpl\";i:1001;s:2:\"id\";i:13548;s:5:\"title\";s:27:\"Barbershop &#8211; Services\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2020/05/Services-Page.jpg\";s:12:\"tmpl_created\";i:1589893298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/barbershop-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:108;s:16:\"popularity_index\";i:761;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:484;a:18:{s:4:\"tmpl\";i:617;s:2:\"id\";i:5599;s:5:\"title\";s:5:\"CTA 6\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_4.png\";s:12:\"tmpl_created\";i:1520520693;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/cta-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:109;s:16:\"popularity_index\";i:252;s:11:\"trend_index\";i:362;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:485;a:18:{s:4:\"tmpl\";i:1002;s:2:\"id\";i:13560;s:5:\"title\";s:26:\"Barbershop &#8211; Gallery\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/05/Gallery-Page.jpg\";s:12:\"tmpl_created\";i:1589893307;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/barbershop-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:109;s:16:\"popularity_index\";i:756;s:11:\"trend_index\";i:822;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:486;a:18:{s:4:\"tmpl\";i:514;s:2:\"id\";i:5575;s:5:\"title\";s:5:\"CTA 7\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_3.png\";s:12:\"tmpl_created\";i:1520443543;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/cta-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:110;s:16:\"popularity_index\";i:13;s:11:\"trend_index\";i:586;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:487;a:18:{s:4:\"tmpl\";i:1003;s:2:\"id\";i:13587;s:5:\"title\";s:26:\"Barbershop &#8211; Contact\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/05/Contact-Us-Page.jpg\";s:12:\"tmpl_created\";i:1589893315;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/barbershop-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:110;s:16:\"popularity_index\";i:753;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:488;a:18:{s:4:\"tmpl\";i:622;s:2:\"id\";i:5658;s:5:\"title\";s:5:\"CTA 8\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_7.png\";s:12:\"tmpl_created\";i:1520520704;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/cta-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:111;s:16:\"popularity_index\";i:187;s:11:\"trend_index\";i:235;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:489;a:18:{s:4:\"tmpl\";i:982;s:2:\"id\";i:13307;s:5:\"title\";s:26:\"Online Course &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/04/Home.jpg\";s:12:\"tmpl_created\";i:1587474541;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/online-course-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:111;s:16:\"popularity_index\";i:230;s:11:\"trend_index\";i:125;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:490;a:18:{s:4:\"tmpl\";i:621;s:2:\"id\";i:5650;s:5:\"title\";s:5:\"CTA 9\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_7.png\";s:12:\"tmpl_created\";i:1520520702;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/cta-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:112;s:16:\"popularity_index\";i:94;s:11:\"trend_index\";i:148;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:491;a:18:{s:4:\"tmpl\";i:983;s:2:\"id\";i:13328;s:5:\"title\";s:27:\"Online Course &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/04/About.jpg\";s:12:\"tmpl_created\";i:1587474558;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/online-course-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:112;s:16:\"popularity_index\";i:508;s:11:\"trend_index\";i:429;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:492;a:18:{s:4:\"tmpl\";i:1061;s:2:\"id\";i:15407;s:5:\"title\";s:24:\"Dance Studio &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/10/404.jpg\";s:12:\"tmpl_created\";i:1603181958;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/dance-studio-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:22:\"[\"404\",\"Dance Studio\"]\";s:10:\"menu_order\";i:113;s:16:\"popularity_index\";i:783;s:11:\"trend_index\";i:710;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:493;a:18:{s:4:\"tmpl\";i:984;s:2:\"id\";i:13338;s:5:\"title\";s:33:\"Online Course &#8211; Course Page\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/04/Course-Page.png\";s:12:\"tmpl_created\";i:1587474574;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/online-course-course-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:113;s:16:\"popularity_index\";i:337;s:11:\"trend_index\";i:310;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:494;a:18:{s:4:\"tmpl\";i:1062;s:2:\"id\";i:15400;s:5:\"title\";s:27:\"Dance Studio &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/10/Footer.jpg\";s:12:\"tmpl_created\";i:1603181989;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/dance-studio-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:25:\"[\"Dance Studio\",\"Footer\"]\";s:10:\"menu_order\";i:114;s:16:\"popularity_index\";i:586;s:11:\"trend_index\";i:243;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:495;a:18:{s:4:\"tmpl\";i:985;s:2:\"id\";i:13352;s:5:\"title\";s:29:\"Online Course &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/Contact-Us.jpg\";s:12:\"tmpl_created\";i:1587474591;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/online-course-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:114;s:16:\"popularity_index\";i:565;s:11:\"trend_index\";i:533;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:496;a:18:{s:4:\"tmpl\";i:1063;s:2:\"id\";i:15391;s:5:\"title\";s:27:\"Dance Studio &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/10/Header.jpg\";s:12:\"tmpl_created\";i:1603182011;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/dance-studio-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:25:\"[\"Dance Studio\",\"Header\"]\";s:10:\"menu_order\";i:115;s:16:\"popularity_index\";i:352;s:11:\"trend_index\";i:67;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:497;a:18:{s:4:\"tmpl\";i:971;s:2:\"id\";i:13187;s:5:\"title\";s:33:\"Interior Design &#8211; Home Page\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/04/Home.png\";s:12:\"tmpl_created\";i:1586148661;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/interior-design-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Business\",\"Interior Design\"]\";s:10:\"menu_order\";i:115;s:16:\"popularity_index\";i:331;s:11:\"trend_index\";i:264;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:498;a:18:{s:4:\"tmpl\";i:874;s:2:\"id\";i:11192;s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/07/Footer_small.jpg\";s:12:\"tmpl_created\";i:1564642399;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/digital-agency-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:39:\"[\"Digital Agency\",\"Footer\",\"Marketing\"]\";s:10:\"menu_order\";i:116;s:16:\"popularity_index\";i:172;s:11:\"trend_index\";i:105;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:499;a:18:{s:4:\"tmpl\";i:1453;s:2:\"id\";i:16346;s:5:\"title\";s:33:\"Your New Home &#8211; Real Estate\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2017/03/lp3-l.png\";s:12:\"tmpl_created\";i:1660205402;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/your-new-home-real-estate/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:11:\"Real Estate\";s:4:\"tags\";s:31:\"[\"Landing Pages\",\"Real estate\"]\";s:10:\"menu_order\";i:116;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:500;a:18:{s:4:\"tmpl\";i:972;s:2:\"id\";i:13199;s:5:\"title\";s:29:\"Interior Design &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/04/About.png\";s:12:\"tmpl_created\";i:1586148666;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/interior-design-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Business\",\"Interior Design\"]\";s:10:\"menu_order\";i:116;s:16:\"popularity_index\";i:316;s:11:\"trend_index\";i:334;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:501;a:18:{s:4:\"tmpl\";i:873;s:2:\"id\";i:11198;s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-digital-marketing-agency.png\";s:12:\"tmpl_created\";i:1564642395;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/digital-agency-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:39:\"[\"Digital Agency\",\"Header\",\"Marketing\"]\";s:10:\"menu_order\";i:117;s:16:\"popularity_index\";i:34;s:11:\"trend_index\";i:10;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:502;a:18:{s:4:\"tmpl\";i:973;s:2:\"id\";i:13214;s:5:\"title\";s:32:\"Interior Design &#8211; Projects\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/04/portfolio_s.jpg\";s:12:\"tmpl_created\";i:1586148672;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/interior-design-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Business\",\"Interior Design\"]\";s:10:\"menu_order\";i:117;s:16:\"popularity_index\";i:367;s:11:\"trend_index\";i:323;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:503;a:18:{s:4:\"tmpl\";i:872;s:2:\"id\";i:11204;s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/07/404_small.jpg\";s:12:\"tmpl_created\";i:1564642389;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/digital-agency-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:36:\"[\"404\",\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:118;s:16:\"popularity_index\";i:301;s:11:\"trend_index\";i:239;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:504;a:18:{s:4:\"tmpl\";i:974;s:2:\"id\";i:13229;s:5:\"title\";s:31:\"Interior Design &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/Contact-Us.png\";s:12:\"tmpl_created\";i:1586148677;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/interior-design-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Business\",\"Interior Design\"]\";s:10:\"menu_order\";i:118;s:16:\"popularity_index\";i:395;s:11:\"trend_index\";i:337;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:505;a:18:{s:4:\"tmpl\";i:871;s:2:\"id\";i:11220;s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/08/Archive_small1.png\";s:12:\"tmpl_created\";i:1564642385;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/digital-agency-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:119;s:16:\"popularity_index\";i:116;s:11:\"trend_index\";i:73;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:506;a:18:{s:4:\"tmpl\";i:959;s:2:\"id\";i:12948;s:5:\"title\";s:29:\"Photography &#8211; Home Page\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/02/Home_s.png\";s:12:\"tmpl_created\";i:1582093442;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/photography-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:119;s:16:\"popularity_index\";i:241;s:11:\"trend_index\";i:201;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:507;a:18:{s:4:\"tmpl\";i:870;s:2:\"id\";i:11231;s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/07/Post_small1.png\";s:12:\"tmpl_created\";i:1564642380;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/digital-agency/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:120;s:16:\"popularity_index\";i:145;s:11:\"trend_index\";i:71;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:508;a:18:{s:4:\"tmpl\";i:960;s:2:\"id\";i:12798;s:5:\"title\";s:25:\"Photography &#8211; About\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/About_s.png\";s:12:\"tmpl_created\";i:1582093446;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/photography-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:120;s:16:\"popularity_index\";i:499;s:11:\"trend_index\";i:374;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:509;a:18:{s:4:\"tmpl\";i:520;s:2:\"id\";i:5711;s:5:\"title\";s:5:\"FAQ 1\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_2.png\";s:12:\"tmpl_created\";i:1520443571;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/faq-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"Faq\"]\";s:10:\"menu_order\";i:121;s:16:\"popularity_index\";i:200;s:11:\"trend_index\";i:231;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:510;a:18:{s:4:\"tmpl\";i:961;s:2:\"id\";i:12868;s:5:\"title\";s:27:\"Photography &#8211; Contact\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/02/Contact_s.png\";s:12:\"tmpl_created\";i:1582093450;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/photography-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:121;s:16:\"popularity_index\";i:531;s:11:\"trend_index\";i:350;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:511;a:18:{s:4:\"tmpl\";i:523;s:2:\"id\";i:5737;s:5:\"title\";s:6:\"FAQ 10\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_4.png\";s:12:\"tmpl_created\";i:1520443576;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/faq-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"Faq\"]\";s:10:\"menu_order\";i:122;s:16:\"popularity_index\";i:155;s:11:\"trend_index\";i:112;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:512;a:18:{s:4:\"tmpl\";i:962;s:2:\"id\";i:13056;s:5:\"title\";s:28:\"Photography &#8211; Wildlife\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/02/Wildlife_s.png\";s:12:\"tmpl_created\";i:1582093454;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/photography-wildlife/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:122;s:16:\"popularity_index\";i:579;s:11:\"trend_index\";i:656;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:513;a:18:{s:4:\"tmpl\";i:524;s:2:\"id\";i:5746;s:5:\"title\";s:6:\"FAQ 11\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_4.png\";s:12:\"tmpl_created\";i:1520443578;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/faq-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"Faq\"]\";s:10:\"menu_order\";i:123;s:16:\"popularity_index\";i:212;s:11:\"trend_index\";i:305;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:514;a:18:{s:4:\"tmpl\";i:963;s:2:\"id\";i:12922;s:5:\"title\";s:37:\"Photography &#8211; Glowing Jellyfish\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/02/Jellyfish_S.png\";s:12:\"tmpl_created\";i:1582093457;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/photography-glowing-jellyfish/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:123;s:16:\"popularity_index\";i:628;s:11:\"trend_index\";i:532;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:515;a:18:{s:4:\"tmpl\";i:519;s:2:\"id\";i:5703;s:5:\"title\";s:6:\"FAQ 13\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_2.png\";s:12:\"tmpl_created\";i:1520443569;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/faq-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"Faq\"]\";s:10:\"menu_order\";i:124;s:16:\"popularity_index\";i:29;s:11:\"trend_index\";i:38;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:516;a:18:{s:4:\"tmpl\";i:964;s:2:\"id\";i:12875;s:5:\"title\";s:36:\"Photography &#8211; Fluttering Birds\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/Birds_s.png\";s:12:\"tmpl_created\";i:1582093461;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/photography-fluttering-birds/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:124;s:16:\"popularity_index\";i:693;s:11:\"trend_index\";i:766;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:517;a:18:{s:4:\"tmpl\";i:521;s:2:\"id\";i:5719;s:5:\"title\";s:5:\"FAQ 4\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_3.png\";s:12:\"tmpl_created\";i:1520443573;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/faq-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"Faq\"]\";s:10:\"menu_order\";i:125;s:16:\"popularity_index\";i:125;s:11:\"trend_index\";i:251;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:518;a:18:{s:4:\"tmpl\";i:965;s:2:\"id\";i:12962;s:5:\"title\";s:26:\"Photography &#8211; Nature\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/02/Nature_s.png\";s:12:\"tmpl_created\";i:1582093465;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/photography-nature/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:125;s:16:\"popularity_index\";i:592;s:11:\"trend_index\";i:778;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:519;a:18:{s:4:\"tmpl\";i:522;s:2:\"id\";i:5729;s:5:\"title\";s:5:\"FAQ 5\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_3.png\";s:12:\"tmpl_created\";i:1520443575;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/faq-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"Faq\"]\";s:10:\"menu_order\";i:126;s:16:\"popularity_index\";i:319;s:11:\"trend_index\";i:327;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:520;a:18:{s:4:\"tmpl\";i:966;s:2:\"id\";i:12833;s:5:\"title\";s:38:\"Photography &#8211; Blossoming Flowers\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/02/Flowers_s.png\";s:12:\"tmpl_created\";i:1582093469;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/photography-blossoming-flowers/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:126;s:16:\"popularity_index\";i:597;s:11:\"trend_index\";i:750;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:521;a:18:{s:4:\"tmpl\";i:525;s:2:\"id\";i:5755;s:5:\"title\";s:5:\"FAQ 6\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_5.png\";s:12:\"tmpl_created\";i:1520443580;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/faq-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"Faq\"]\";s:10:\"menu_order\";i:127;s:16:\"popularity_index\";i:112;s:11:\"trend_index\";i:180;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:522;a:18:{s:4:\"tmpl\";i:967;s:2:\"id\";i:12898;s:5:\"title\";s:36:\"Photography &#8211; Forest Mushrooms\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/02/Mushrooms_s.png\";s:12:\"tmpl_created\";i:1582093473;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/photography-forest-mushrooms/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:127;s:16:\"popularity_index\";i:667;s:11:\"trend_index\";i:649;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:523;a:18:{s:4:\"tmpl\";i:526;s:2:\"id\";i:5764;s:5:\"title\";s:5:\"FAQ 7\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_5.png\";s:12:\"tmpl_created\";i:1520443582;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/faq-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"Faq\"]\";s:10:\"menu_order\";i:128;s:16:\"popularity_index\";i:338;s:11:\"trend_index\";i:474;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:524;a:18:{s:4:\"tmpl\";i:968;s:2:\"id\";i:12994;s:5:\"title\";s:24:\"Photography &#8211; Pets\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/02/Pets_s.png\";s:12:\"tmpl_created\";i:1582093477;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/photography-pets/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:128;s:16:\"popularity_index\";i:612;s:11:\"trend_index\";i:508;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:525;a:18:{s:4:\"tmpl\";i:517;s:2:\"id\";i:5684;s:5:\"title\";s:5:\"FAQ 8\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_1.png\";s:12:\"tmpl_created\";i:1520443565;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/faq-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"Faq\"]\";s:10:\"menu_order\";i:129;s:16:\"popularity_index\";i:74;s:11:\"trend_index\";i:193;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:526;a:18:{s:4:\"tmpl\";i:969;s:2:\"id\";i:12805;s:5:\"title\";s:37:\"Photography &#8211; B&amp;W Portraits\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/Black_s.png\";s:12:\"tmpl_created\";i:1582093481;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/photography-bw-portraits/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:129;s:16:\"popularity_index\";i:695;s:11:\"trend_index\";i:735;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:527;a:18:{s:4:\"tmpl\";i:518;s:2:\"id\";i:5693;s:5:\"title\";s:5:\"FAQ 9\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_1.png\";s:12:\"tmpl_created\";i:1520443567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/faq-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"Faq\"]\";s:10:\"menu_order\";i:130;s:16:\"popularity_index\";i:224;s:11:\"trend_index\";i:515;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:528;a:18:{s:4:\"tmpl\";i:970;s:2:\"id\";i:13031;s:5:\"title\";s:33:\"Photography &#8211; Vivid Parrots\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/02/Parrots_s.png\";s:12:\"tmpl_created\";i:1582093484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/photography-vivid-parrots/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:130;s:16:\"popularity_index\";i:660;s:11:\"trend_index\";i:643;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:529;a:18:{s:4:\"tmpl\";i:548;s:2:\"id\";i:6053;s:5:\"title\";s:10:\"Features 1\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_black_5.png\";s:12:\"tmpl_created\";i:1520443645;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/features-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"Features\"]\";s:10:\"menu_order\";i:131;s:16:\"popularity_index\";i:179;s:11:\"trend_index\";i:463;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:530;a:18:{s:4:\"tmpl\";i:940;s:2:\"id\";i:12621;s:5:\"title\";s:26:\"Magazine &#8211; Home Page\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/01/Home_s.png\";s:12:\"tmpl_created\";i:1579060604;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/magazine-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:131;s:16:\"popularity_index\";i:167;s:11:\"trend_index\";i:121;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:531;a:18:{s:4:\"tmpl\";i:542;s:2:\"id\";i:5991;s:5:\"title\";s:11:\"Features 10\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_4.png\";s:12:\"tmpl_created\";i:1520443632;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/features-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"Features\"]\";s:10:\"menu_order\";i:132;s:16:\"popularity_index\";i:135;s:11:\"trend_index\";i:265;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:532;a:18:{s:4:\"tmpl\";i:936;s:2:\"id\";i:12352;s:5:\"title\";s:24:\"Travel &#8211; Home Page\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2019/12/Home_s.png\";s:12:\"tmpl_created\";i:1575960464;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/travel-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:132;s:16:\"popularity_index\";i:291;s:11:\"trend_index\";i:194;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:533;a:18:{s:4:\"tmpl\";i:547;s:2:\"id\";i:6044;s:5:\"title\";s:11:\"Features 11\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_5.png\";s:12:\"tmpl_created\";i:1520443643;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/features-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"Features\"]\";s:10:\"menu_order\";i:133;s:16:\"popularity_index\";i:70;s:11:\"trend_index\";i:163;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:534;a:18:{s:4:\"tmpl\";i:932;s:2:\"id\";i:12400;s:5:\"title\";s:20:\"Travel &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2019/12/About.png\";s:12:\"tmpl_created\";i:1575960441;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/travel-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:133;s:16:\"popularity_index\";i:444;s:11:\"trend_index\";i:445;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:535;a:18:{s:4:\"tmpl\";i:566;s:2:\"id\";i:6212;s:5:\"title\";s:11:\"Features 12\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_7.png\";s:12:\"tmpl_created\";i:1520443684;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/features-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"Features\"]\";s:10:\"menu_order\";i:134;s:16:\"popularity_index\";i:81;s:11:\"trend_index\";i:98;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:536;a:18:{s:4:\"tmpl\";i:938;s:2:\"id\";i:12479;s:5:\"title\";s:20:\"Travel &#8211; Tours\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/12/Tours_s.png\";s:12:\"tmpl_created\";i:1575960474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/travel-tours/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:134;s:16:\"popularity_index\";i:539;s:11:\"trend_index\";i:726;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:537;a:18:{s:4:\"tmpl\";i:567;s:2:\"id\";i:6220;s:5:\"title\";s:10:\"Features 2\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_8.png\";s:12:\"tmpl_created\";i:1520443685;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/features-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"Features\"]\";s:10:\"menu_order\";i:135;s:16:\"popularity_index\";i:88;s:11:\"trend_index\";i:189;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:538;a:18:{s:4:\"tmpl\";i:937;s:2:\"id\";i:12466;s:5:\"title\";s:27:\"Travel &#8211; Testimonials\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/12/Testimonials.png\";s:12:\"tmpl_created\";i:1575960469;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/travel-testimonials/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:135;s:16:\"popularity_index\";i:527;s:11:\"trend_index\";i:481;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:539;a:18:{s:4:\"tmpl\";i:541;s:2:\"id\";i:5983;s:5:\"title\";s:10:\"Features 3\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_black_3.png\";s:12:\"tmpl_created\";i:1520443630;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/features-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:136;s:16:\"popularity_index\";i:231;s:11:\"trend_index\";i:351;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:540;a:18:{s:4:\"tmpl\";i:935;s:2:\"id\";i:12443;s:5:\"title\";s:22:\"Travel &#8211; Gallery\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/12/Gallery.png\";s:12:\"tmpl_created\";i:1575960459;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/travel-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:136;s:16:\"popularity_index\";i:467;s:11:\"trend_index\";i:501;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:541;a:18:{s:4:\"tmpl\";i:540;s:2:\"id\";i:5974;s:5:\"title\";s:10:\"Features 4\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_3.png\";s:12:\"tmpl_created\";i:1520443629;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/features-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"Features\"]\";s:10:\"menu_order\";i:137;s:16:\"popularity_index\";i:69;s:11:\"trend_index\";i:181;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:542;a:18:{s:4:\"tmpl\";i:934;s:2:\"id\";i:12431;s:5:\"title\";s:18:\"Travel &#8211; FAQ\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2019/12/FAQ.png\";s:12:\"tmpl_created\";i:1575960453;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/travel-faq/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:137;s:16:\"popularity_index\";i:501;s:11:\"trend_index\";i:387;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:543;a:18:{s:4:\"tmpl\";i:516;s:2:\"id\";i:5624;s:5:\"title\";s:10:\"Features 5\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_black_1.png\";s:12:\"tmpl_created\";i:1520443553;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/features-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"Features\"]\";s:10:\"menu_order\";i:138;s:16:\"popularity_index\";i:93;s:11:\"trend_index\";i:352;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:544;a:18:{s:4:\"tmpl\";i:933;s:2:\"id\";i:12421;s:5:\"title\";s:27:\"Travel &#8211; Contact Page\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/12/Contsct-Us.png\";s:12:\"tmpl_created\";i:1575960445;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/travel-contact-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:138;s:16:\"popularity_index\";i:571;s:11:\"trend_index\";i:536;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:545;a:18:{s:4:\"tmpl\";i:515;s:2:\"id\";i:5615;s:5:\"title\";s:10:\"Features 6\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_5.png\";s:12:\"tmpl_created\";i:1520443551;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/features-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"Features\"]\";s:10:\"menu_order\";i:139;s:16:\"popularity_index\";i:41;s:11:\"trend_index\";i:119;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:546;a:18:{s:4:\"tmpl\";i:892;s:2:\"id\";i:11763;s:5:\"title\";s:27:\"Portfolio &#8211; Home Page\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Homepage_small.png\";s:12:\"tmpl_created\";i:1569428959;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/portfolio-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Creative Portfolio\",\"Portfolio\"]\";s:10:\"menu_order\";i:139;s:16:\"popularity_index\";i:280;s:11:\"trend_index\";i:241;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:547;a:18:{s:4:\"tmpl\";i:539;s:2:\"id\";i:5963;s:5:\"title\";s:10:\"Features 7\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_2.png\";s:12:\"tmpl_created\";i:1520443626;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/features-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"Features\"]\";s:10:\"menu_order\";i:140;s:16:\"popularity_index\";i:67;s:11:\"trend_index\";i:133;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:548;a:18:{s:4:\"tmpl\";i:891;s:2:\"id\";i:11781;s:5:\"title\";s:23:\"Portfolio &#8211; About\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/09/About_small.png\";s:12:\"tmpl_created\";i:1569428955;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/portfolio-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Creative Portfolio\",\"Portfolio\"]\";s:10:\"menu_order\";i:140;s:16:\"popularity_index\";i:349;s:11:\"trend_index\";i:290;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:549;a:18:{s:4:\"tmpl\";i:565;s:2:\"id\";i:6204;s:5:\"title\";s:10:\"Features 8\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_black_6.png\";s:12:\"tmpl_created\";i:1520443681;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/features-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"Features\"]\";s:10:\"menu_order\";i:141;s:16:\"popularity_index\";i:217;s:11:\"trend_index\";i:223;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:550;a:18:{s:4:\"tmpl\";i:890;s:2:\"id\";i:11793;s:5:\"title\";s:26:\"Portfolio &#8211; Projects\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Projects_small.png\";s:12:\"tmpl_created\";i:1569428951;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/portfolio-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Creative Portfolio\",\"Portfolio\"]\";s:10:\"menu_order\";i:141;s:16:\"popularity_index\";i:448;s:11:\"trend_index\";i:467;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:551;a:18:{s:4:\"tmpl\";i:564;s:2:\"id\";i:6196;s:5:\"title\";s:10:\"Features 9\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_6.png\";s:12:\"tmpl_created\";i:1520443680;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/features-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"Features\"]\";s:10:\"menu_order\";i:142;s:16:\"popularity_index\";i:106;s:11:\"trend_index\";i:113;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:552;a:18:{s:4:\"tmpl\";i:889;s:2:\"id\";i:11800;s:5:\"title\";s:25:\"Portfolio &#8211; Contact\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/09/Contact_small.png\";s:12:\"tmpl_created\";i:1569428946;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/portfolio-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Creative Portfolio\",\"Portfolio\"]\";s:10:\"menu_order\";i:142;s:16:\"popularity_index\";i:494;s:11:\"trend_index\";i:449;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:553;a:18:{s:4:\"tmpl\";i:1033;s:2:\"id\";i:15033;s:5:\"title\";s:28:\"Flooring Company &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/08/404.png\";s:12:\"tmpl_created\";i:1597739459;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/blocks/flooring-company-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:45:\"[\"404\",\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:143;s:16:\"popularity_index\";i:655;s:11:\"trend_index\";i:671;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:554;a:18:{s:4:\"tmpl\";i:866;s:2:\"id\";i:11163;s:5:\"title\";s:32:\"Digital Agency &#8211; Home Page\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/07/Home_small.png\";s:12:\"tmpl_created\";i:1564641877;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/digital-agency-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:143;s:16:\"popularity_index\";i:57;s:11:\"trend_index\";i:32;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:555;a:18:{s:4:\"tmpl\";i:1032;s:2:\"id\";i:15042;s:5:\"title\";s:32:\"Flooring Company &#8211; Archive\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/08/Blog.png\";s:12:\"tmpl_created\";i:1597739084;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/blocks/flooring-company-archive/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:144;s:16:\"popularity_index\";i:320;s:11:\"trend_index\";i:275;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:556;a:18:{s:4:\"tmpl\";i:1031;s:2:\"id\";i:15017;s:5:\"title\";s:31:\"Flooring Company &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/08/Footer.png\";s:12:\"tmpl_created\";i:1597738933;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/blocks/flooring-company-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:48:\"[\"Flooring company\",\"Flooring website\",\"Footer\"]\";s:10:\"menu_order\";i:145;s:16:\"popularity_index\";i:323;s:11:\"trend_index\";i:192;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:557;a:18:{s:4:\"tmpl\";i:1030;s:2:\"id\";i:15007;s:5:\"title\";s:31:\"Flooring Company &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/08/Header.png\";s:12:\"tmpl_created\";i:1597738896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/blocks/flooring-company-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:48:\"[\"Flooring company\",\"Flooring website\",\"Header\"]\";s:10:\"menu_order\";i:146;s:16:\"popularity_index\";i:459;s:11:\"trend_index\";i:333;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:558;a:18:{s:4:\"tmpl\";i:916;s:2:\"id\";i:12143;s:5:\"title\";s:22:\"Law Firm &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2019/11/about.png\";s:12:\"tmpl_created\";i:1572847069;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/law-firm-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:146;s:16:\"popularity_index\";i:350;s:11:\"trend_index\";i:344;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:559;a:18:{s:4:\"tmpl\";i:1029;s:2:\"id\";i:15052;s:5:\"title\";s:36:\"Flooring Company &#8211; Single post\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/08/Single.png\";s:12:\"tmpl_created\";i:1597738858;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/blocks/flooring-company-single-post/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:147;s:16:\"popularity_index\";i:392;s:11:\"trend_index\";i:226;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:560;a:18:{s:4:\"tmpl\";i:920;s:2:\"id\";i:12091;s:5:\"title\";s:21:\"Law Firm &#8211; Team\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2019/11/team.png\";s:12:\"tmpl_created\";i:1572847113;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/law-firm-team/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:147;s:16:\"popularity_index\";i:318;s:11:\"trend_index\";i:314;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:561;a:18:{s:4:\"tmpl\";i:869;s:2:\"id\";i:11129;s:5:\"title\";s:28:\"Digital Agency &#8211; About\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/07/About_small.png\";s:12:\"tmpl_created\";i:1564641889;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/digital-agency-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:148;s:16:\"popularity_index\";i:182;s:11:\"trend_index\";i:166;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:562;a:18:{s:4:\"tmpl\";i:651;s:2:\"id\";i:7837;s:5:\"title\";s:9:\"footer 01\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.14.jpg\";s:12:\"tmpl_created\";i:1524582852;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/footer-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:148;s:16:\"popularity_index\";i:495;s:11:\"trend_index\";i:539;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:563;a:18:{s:4:\"tmpl\";i:880;s:2:\"id\";i:11572;s:5:\"title\";s:19:\"Gym &#8211; Trainer\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/08/Trainer_Small.png\";s:12:\"tmpl_created\";i:1567392934;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/gym-trainer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:149;s:16:\"popularity_index\";i:521;s:11:\"trend_index\";i:590;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:564;a:18:{s:4:\"tmpl\";i:647;s:2:\"id\";i:7937;s:5:\"title\";s:10:\"footer 010\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.5.jpg\";s:12:\"tmpl_created\";i:1524582665;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/footer-010/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:149;s:16:\"popularity_index\";i:185;s:11:\"trend_index\";i:115;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:565;a:18:{s:4:\"tmpl\";i:646;s:2:\"id\";i:7950;s:5:\"title\";s:10:\"footer 011\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.4.jpg\";s:12:\"tmpl_created\";i:1524582631;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/footer-011/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:150;s:16:\"popularity_index\";i:244;s:11:\"trend_index\";i:203;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:566;a:18:{s:4:\"tmpl\";i:645;s:2:\"id\";i:7959;s:5:\"title\";s:10:\"footer 012\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.3.jpg\";s:12:\"tmpl_created\";i:1524582605;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/footer-012/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:151;s:16:\"popularity_index\";i:177;s:11:\"trend_index\";i:140;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:567;a:18:{s:4:\"tmpl\";i:917;s:2:\"id\";i:12133;s:5:\"title\";s:24:\"Law Firm &#8211; Careers\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/11/careers.png\";s:12:\"tmpl_created\";i:1572847078;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/law-firm-careers/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:151;s:16:\"popularity_index\";i:583;s:11:\"trend_index\";i:640;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:568;a:18:{s:4:\"tmpl\";i:644;s:2:\"id\";i:7982;s:5:\"title\";s:10:\"footer 013\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.2.jpg\";s:12:\"tmpl_created\";i:1524582468;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/footer-013/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:152;s:16:\"popularity_index\";i:209;s:11:\"trend_index\";i:212;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:569;a:18:{s:4:\"tmpl\";i:915;s:2:\"id\";i:12155;s:5:\"title\";s:26:\"Law Firm &#8211; Home Page\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2019/11/home.png\";s:12:\"tmpl_created\";i:1572847054;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/law-firm-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:152;s:16:\"popularity_index\";i:193;s:11:\"trend_index\";i:110;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:570;a:18:{s:4:\"tmpl\";i:643;s:2:\"id\";i:7997;s:5:\"title\";s:10:\"footer 014\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.1.jpg\";s:12:\"tmpl_created\";i:1524582343;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/footer-014/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:153;s:16:\"popularity_index\";i:64;s:11:\"trend_index\";i:41;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:571;a:18:{s:4:\"tmpl\";i:921;s:2:\"id\";i:12080;s:5:\"title\";s:24:\"Law Firm &#8211; Partner\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/11/partner-1.png\";s:12:\"tmpl_created\";i:1572847120;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/law-firm-partner/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:153;s:16:\"popularity_index\";i:556;s:11:\"trend_index\";i:471;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:572;a:18:{s:4:\"tmpl\";i:865;s:2:\"id\";i:11074;s:5:\"title\";s:31:\"Digital Agency &#8211; Services\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/07/Services_small.png\";s:12:\"tmpl_created\";i:1564641872;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/digital-agency-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:154;s:16:\"popularity_index\";i:163;s:11:\"trend_index\";i:170;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:573;a:18:{s:4:\"tmpl\";i:693;s:2:\"id\";i:9119;s:5:\"title\";s:10:\"footer 015\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/07/Footer_GetStarted_350.png\";s:12:\"tmpl_created\";i:1532428138;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/demo/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:154;s:16:\"popularity_index\";i:240;s:11:\"trend_index\";i:154;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:574;a:18:{s:4:\"tmpl\";i:879;s:2:\"id\";i:11506;s:5:\"title\";s:19:\"Gym &#8211; Classes\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/08/Classes_Small.png\";s:12:\"tmpl_created\";i:1567392930;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/gym-classes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:155;s:16:\"popularity_index\";i:514;s:11:\"trend_index\";i:554;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:575;a:18:{s:4:\"tmpl\";i:652;s:2:\"id\";i:7852;s:5:\"title\";s:9:\"footer 02\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.13.jpg\";s:12:\"tmpl_created\";i:1524582875;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/footer-02/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:155;s:16:\"popularity_index\";i:199;s:11:\"trend_index\";i:96;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:576;a:18:{s:4:\"tmpl\";i:653;s:2:\"id\";i:7862;s:5:\"title\";s:9:\"footer 03\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.12.jpg\";s:12:\"tmpl_created\";i:1524582903;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/footer-03/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:156;s:16:\"popularity_index\";i:137;s:11:\"trend_index\";i:91;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:577;a:18:{s:4:\"tmpl\";i:654;s:2:\"id\";i:7871;s:5:\"title\";s:9:\"footer 04\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.11.jpg\";s:12:\"tmpl_created\";i:1524582927;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/footer-04/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:157;s:16:\"popularity_index\";i:97;s:11:\"trend_index\";i:55;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:578;a:18:{s:4:\"tmpl\";i:922;s:2:\"id\";i:12044;s:5:\"title\";s:24:\"Law Firm &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/11/contsct_us.png\";s:12:\"tmpl_created\";i:1572847130;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/law-firm-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:157;s:16:\"popularity_index\";i:437;s:11:\"trend_index\";i:304;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:579;a:18:{s:4:\"tmpl\";i:655;s:2:\"id\";i:7884;s:5:\"title\";s:9:\"footer 05\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.10.jpg\";s:12:\"tmpl_created\";i:1524582944;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/footer-05/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:158;s:16:\"popularity_index\";i:92;s:11:\"trend_index\";i:109;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:580;a:18:{s:4:\"tmpl\";i:918;s:2:\"id\";i:12124;s:5:\"title\";s:25:\"Law Firm &#8211; Services\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2019/11/services.png\";s:12:\"tmpl_created\";i:1572847096;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/law-firm-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:158;s:16:\"popularity_index\";i:433;s:11:\"trend_index\";i:296;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:581;a:18:{s:4:\"tmpl\";i:864;s:2:\"id\";i:11056;s:5:\"title\";s:35:\"Digital Agency &#8211; Social Media\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2019/07/Social-Media_small.png\";s:12:\"tmpl_created\";i:1564641867;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/digital-agency-social-media/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:159;s:16:\"popularity_index\";i:297;s:11:\"trend_index\";i:361;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:582;a:18:{s:4:\"tmpl\";i:656;s:2:\"id\";i:7892;s:5:\"title\";s:9:\"footer 06\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.9.jpg\";s:12:\"tmpl_created\";i:1524583015;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/footer-06/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:159;s:16:\"popularity_index\";i:132;s:11:\"trend_index\";i:146;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:583;a:18:{s:4:\"tmpl\";i:878;s:2:\"id\";i:11536;s:5:\"title\";s:19:\"Gym &#8211; Fitness\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/08/Fitness_Small.png\";s:12:\"tmpl_created\";i:1567392927;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/gym-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:160;s:16:\"popularity_index\";i:621;s:11:\"trend_index\";i:674;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:584;a:18:{s:4:\"tmpl\";i:650;s:2:\"id\";i:7904;s:5:\"title\";s:9:\"footer 07\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.8.jpg\";s:12:\"tmpl_created\";i:1524582814;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/footer-07/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:160;s:16:\"popularity_index\";i:203;s:11:\"trend_index\";i:186;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:585;a:18:{s:4:\"tmpl\";i:882;s:2:\"id\";i:11545;s:5:\"title\";s:21:\"Gym &#8211; Home Page\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/08/Home_Small.png\";s:12:\"tmpl_created\";i:1567392943;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/gym-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:161;s:16:\"popularity_index\";i:310;s:11:\"trend_index\";i:229;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:586;a:18:{s:4:\"tmpl\";i:649;s:2:\"id\";i:7917;s:5:\"title\";s:9:\"footer 08\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.7.jpg\";s:12:\"tmpl_created\";i:1524582788;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/footer-08/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:161;s:16:\"popularity_index\";i:89;s:11:\"trend_index\";i:144;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:587;a:18:{s:4:\"tmpl\";i:648;s:2:\"id\";i:7927;s:5:\"title\";s:9:\"footer 09\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.6.jpg\";s:12:\"tmpl_created\";i:1524582691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/footer-09/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:162;s:16:\"popularity_index\";i:178;s:11:\"trend_index\";i:100;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:588;a:18:{s:4:\"tmpl\";i:919;s:2:\"id\";i:12116;s:5:\"title\";s:24:\"Law Firm &#8211; Service\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/11/family_law.png\";s:12:\"tmpl_created\";i:1572847105;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/law-firm-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:162;s:16:\"popularity_index\";i:489;s:11:\"trend_index\";i:339;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:589;a:18:{s:4:\"tmpl\";i:868;s:2:\"id\";i:11094;s:5:\"title\";s:30:\"Digital Agency &#8211; Clients\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/07/Clients_small.png\";s:12:\"tmpl_created\";i:1564641885;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/digital-agency-clients/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:163;s:16:\"popularity_index\";i:424;s:11:\"trend_index\";i:424;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:590;a:18:{s:4:\"tmpl\";i:881;s:2:\"id\";i:11478;s:5:\"title\";s:17:\"Gym &#8211; About\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/08/About_Small.png\";s:12:\"tmpl_created\";i:1567392939;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/gym-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:164;s:16:\"popularity_index\";i:481;s:11:\"trend_index\";i:579;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:591;a:18:{s:4:\"tmpl\";i:877;s:2:\"id\";i:11563;s:5:\"title\";s:19:\"Gym &#8211; Pricing\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/08/Pricing_Small.png\";s:12:\"tmpl_created\";i:1567392923;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/gym-pricing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:166;s:16:\"popularity_index\";i:577;s:11:\"trend_index\";i:736;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:592;a:18:{s:4:\"tmpl\";i:867;s:2:\"id\";i:11034;s:5:\"title\";s:30:\"Digital Agency &#8211; Contact\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2019/07/Contsct-Us_small.png\";s:12:\"tmpl_created\";i:1564641881;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/contact-digital-agency/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:168;s:16:\"popularity_index\";i:191;s:11:\"trend_index\";i:156;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:593;a:18:{s:4:\"tmpl\";i:642;s:2:\"id\";i:4676;s:5:\"title\";s:8:\"Footer 7\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/footer_7.png\";s:12:\"tmpl_created\";i:1522014215;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/footer_7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:10:\"[\"Footer\"]\";s:10:\"menu_order\";i:169;s:16:\"popularity_index\";i:237;s:11:\"trend_index\";i:346;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:594;a:18:{s:4:\"tmpl\";i:637;s:2:\"id\";i:7627;s:5:\"title\";s:8:\"Footer 8\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/footer_hero_1.png\";s:12:\"tmpl_created\";i:1521547332;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/footer-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:10:\"[\"Footer\"]\";s:10:\"menu_order\";i:170;s:16:\"popularity_index\";i:100;s:11:\"trend_index\";i:83;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:595;a:18:{s:4:\"tmpl\";i:876;s:2:\"id\";i:11528;s:5:\"title\";s:19:\"Gym &#8211; Contact\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/08/Contact_Small.png\";s:12:\"tmpl_created\";i:1567392917;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/gym-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:171;s:16:\"popularity_index\";i:505;s:11:\"trend_index\";i:624;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:596;a:18:{s:4:\"tmpl\";i:638;s:2:\"id\";i:7638;s:5:\"title\";s:8:\"Footer 9\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/footer_hero_2.png\";s:12:\"tmpl_created\";i:1521547502;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/footer-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:10:\"[\"Footer\"]\";s:10:\"menu_order\";i:171;s:16:\"popularity_index\";i:124;s:11:\"trend_index\";i:147;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:597;a:18:{s:4:\"tmpl\";i:888;s:2:\"id\";i:11424;s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/08/404_Small.png\";s:12:\"tmpl_created\";i:1567393309;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/gym-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:13:\"[\"404\",\"Gym\"]\";s:10:\"menu_order\";i:172;s:16:\"popularity_index\";i:679;s:11:\"trend_index\";i:769;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:598;a:18:{s:4:\"tmpl\";i:887;s:2:\"id\";i:11435;s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/08/Archiv_Small.png\";s:12:\"tmpl_created\";i:1567393296;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/gym-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:173;s:16:\"popularity_index\";i:441;s:11:\"trend_index\";i:507;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:599;a:18:{s:4:\"tmpl\";i:886;s:2:\"id\";i:11445;s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/08/Post_Small.png\";s:12:\"tmpl_created\";i:1567393229;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/gym-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:174;s:16:\"popularity_index\";i:452;s:11:\"trend_index\";i:479;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:600;a:18:{s:4:\"tmpl\";i:885;s:2:\"id\";i:11453;s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/08/Footer_Small.png\";s:12:\"tmpl_created\";i:1567393224;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/gym-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:16:\"[\"Footer\",\"Gym\"]\";s:10:\"menu_order\";i:175;s:16:\"popularity_index\";i:270;s:11:\"trend_index\";i:331;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:601;a:18:{s:4:\"tmpl\";i:884;s:2:\"id\";i:11461;s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-gym-and-fitness.png\";s:12:\"tmpl_created\";i:1567393219;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/gym/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:16:\"[\"Gym\",\"Header\"]\";s:10:\"menu_order\";i:176;s:16:\"popularity_index\";i:201;s:11:\"trend_index\";i:135;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:602;a:18:{s:4:\"tmpl\";i:635;s:2:\"id\";i:7596;s:5:\"title\";s:8:\"Header 1\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.12.jpg\";s:12:\"tmpl_created\";i:1521546999;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/header-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:10:\"[\"Header\"]\";s:10:\"menu_order\";i:177;s:16:\"popularity_index\";i:33;s:11:\"trend_index\";i:17;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:603;a:18:{s:4:\"tmpl\";i:663;s:2:\"id\";i:7801;s:5:\"title\";s:9:\"header 10\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.9.jpg\";s:12:\"tmpl_created\";i:1524583659;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/header-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:178;s:16:\"popularity_index\";i:51;s:11:\"trend_index\";i:14;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:604;a:18:{s:4:\"tmpl\";i:658;s:2:\"id\";i:7812;s:5:\"title\";s:9:\"header 11\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.10.jpg\";s:12:\"tmpl_created\";i:1524583298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/header-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:179;s:16:\"popularity_index\";i:96;s:11:\"trend_index\";i:103;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:605;a:18:{s:4:\"tmpl\";i:657;s:2:\"id\";i:7825;s:5:\"title\";s:9:\"header 12\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.11.jpg\";s:12:\"tmpl_created\";i:1524583273;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/header-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:180;s:16:\"popularity_index\";i:63;s:11:\"trend_index\";i:75;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:606;a:18:{s:4:\"tmpl\";i:694;s:2:\"id\";i:9127;s:5:\"title\";s:9:\"header 13\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2018/07/Header_get_started_1200V3.png\";s:12:\"tmpl_created\";i:1532428699;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/header-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:181;s:16:\"popularity_index\";i:61;s:11:\"trend_index\";i:58;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:607;a:18:{s:4:\"tmpl\";i:636;s:2:\"id\";i:7615;s:5:\"title\";s:8:\"Header 2\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.1.jpg\";s:12:\"tmpl_created\";i:1521547237;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/header-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:10:\"[\"Header\"]\";s:10:\"menu_order\";i:182;s:16:\"popularity_index\";i:30;s:11:\"trend_index\";i:33;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:608;a:18:{s:4:\"tmpl\";i:665;s:2:\"id\";i:7713;s:5:\"title\";s:8:\"header 3\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.2.jpg\";s:12:\"tmpl_created\";i:1524584780;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/header-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:183;s:16:\"popularity_index\";i:43;s:11:\"trend_index\";i:28;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:609;a:18:{s:4:\"tmpl\";i:659;s:2:\"id\";i:7724;s:5:\"title\";s:8:\"header 4\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.3.jpg\";s:12:\"tmpl_created\";i:1524583367;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/header-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:184;s:16:\"popularity_index\";i:24;s:11:\"trend_index\";i:13;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:610;a:18:{s:4:\"tmpl\";i:660;s:2:\"id\";i:7734;s:5:\"title\";s:8:\"header 5\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.4.jpg\";s:12:\"tmpl_created\";i:1524583436;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/header-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:185;s:16:\"popularity_index\";i:36;s:11:\"trend_index\";i:18;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:611;a:18:{s:4:\"tmpl\";i:666;s:2:\"id\";i:7744;s:5:\"title\";s:8:\"Header 6\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.5.jpg\";s:12:\"tmpl_created\";i:1524584784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/header-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:186;s:16:\"popularity_index\";i:65;s:11:\"trend_index\";i:94;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:612;a:18:{s:4:\"tmpl\";i:664;s:2:\"id\";i:7754;s:5:\"title\";s:8:\"header 7\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.6.jpg\";s:12:\"tmpl_created\";i:1524583712;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/header-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:187;s:16:\"popularity_index\";i:111;s:11:\"trend_index\";i:143;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:613;a:18:{s:4:\"tmpl\";i:661;s:2:\"id\";i:7771;s:5:\"title\";s:8:\"header 8\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.7.jpg\";s:12:\"tmpl_created\";i:1524583540;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/header-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:188;s:16:\"popularity_index\";i:91;s:11:\"trend_index\";i:60;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:614;a:18:{s:4:\"tmpl\";i:662;s:2:\"id\";i:7787;s:5:\"title\";s:8:\"header 9\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.8.jpg\";s:12:\"tmpl_created\";i:1524583598;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/header-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:189;s:16:\"popularity_index\";i:102;s:11:\"trend_index\";i:78;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:615;a:18:{s:4:\"tmpl\";i:572;s:2:\"id\";i:6266;s:5:\"title\";s:6:\"Hero 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_4.png\";s:12:\"tmpl_created\";i:1520443695;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/hero-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:190;s:16:\"popularity_index\";i:52;s:11:\"trend_index\";i:35;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:616;a:18:{s:4:\"tmpl\";i:528;s:2:\"id\";i:5783;s:5:\"title\";s:7:\"Hero 10\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/header_2.png\";s:12:\"tmpl_created\";i:1520443586;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/hero-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:191;s:16:\"popularity_index\";i:365;s:11:\"trend_index\";i:567;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:617;a:18:{s:4:\"tmpl\";i:527;s:2:\"id\";i:5773;s:5:\"title\";s:7:\"Hero 11\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/header_1.png\";s:12:\"tmpl_created\";i:1520443584;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/hero-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:192;s:16:\"popularity_index\";i:39;s:11:\"trend_index\";i:179;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:618;a:18:{s:4:\"tmpl\";i:479;s:2:\"id\";i:5238;s:5:\"title\";s:7:\"Hero 12\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_4.png\";s:12:\"tmpl_created\";i:1520443468;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/hero-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:193;s:16:\"popularity_index\";i:611;s:11:\"trend_index\";i:555;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:619;a:18:{s:4:\"tmpl\";i:573;s:2:\"id\";i:6274;s:5:\"title\";s:6:\"Hero 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_5.png\";s:12:\"tmpl_created\";i:1520443698;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/hero-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:194;s:16:\"popularity_index\";i:87;s:11:\"trend_index\";i:88;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:620;a:18:{s:4:\"tmpl\";i:569;s:2:\"id\";i:6239;s:5:\"title\";s:6:\"Hero 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_1.png\";s:12:\"tmpl_created\";i:1520443689;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/hero-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:195;s:16:\"popularity_index\";i:23;s:11:\"trend_index\";i:34;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:621;a:18:{s:4:\"tmpl\";i:571;s:2:\"id\";i:6258;s:5:\"title\";s:6:\"Hero 4\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_3.png\";s:12:\"tmpl_created\";i:1520443693;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/hero-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:196;s:16:\"popularity_index\";i:479;s:11:\"trend_index\";i:470;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:622;a:18:{s:4:\"tmpl\";i:570;s:2:\"id\";i:6249;s:5:\"title\";s:6:\"Hero 5\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_2.png\";s:12:\"tmpl_created\";i:1520443691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/hero-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:197;s:16:\"popularity_index\";i:56;s:11:\"trend_index\";i:85;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:623;a:18:{s:4:\"tmpl\";i:568;s:2:\"id\";i:6230;s:5:\"title\";s:6:\"Hero 6\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_white_1.png\";s:12:\"tmpl_created\";i:1520443687;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/hero-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:198;s:16:\"popularity_index\";i:406;s:11:\"trend_index\";i:542;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:624;a:18:{s:4:\"tmpl\";i:530;s:2:\"id\";i:5801;s:5:\"title\";s:6:\"Hero 7\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/header_4.png\";s:12:\"tmpl_created\";i:1520443589;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/hero-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:199;s:16:\"popularity_index\";i:15;s:11:\"trend_index\";i:37;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:625;a:18:{s:4:\"tmpl\";i:531;s:2:\"id\";i:5811;s:5:\"title\";s:6:\"Hero 8\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/header_5.png\";s:12:\"tmpl_created\";i:1520443591;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/hero-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:200;s:16:\"popularity_index\";i:105;s:11:\"trend_index\";i:86;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:626;a:18:{s:4:\"tmpl\";i:529;s:2:\"id\";i:5792;s:5:\"title\";s:6:\"Hero 9\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/header_3.png\";s:12:\"tmpl_created\";i:1520443588;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/hero-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:201;s:16:\"popularity_index\";i:225;s:11:\"trend_index\";i:244;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:627;a:18:{s:4:\"tmpl\";i:978;s:2:\"id\";i:13251;s:5:\"title\";s:27:\"Interior Design &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/04/404.png\";s:12:\"tmpl_created\";i:1586148737;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/interior-design-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:30:\"[\"Business\",\"Interior Design\"]\";s:10:\"menu_order\";i:202;s:16:\"popularity_index\";i:730;s:11:\"trend_index\";i:795;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:628;a:18:{s:4:\"tmpl\";i:979;s:2:\"id\";i:13244;s:5:\"title\";s:30:\"Interior Design &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/04/Footer.png\";s:12:\"tmpl_created\";i:1586148742;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/blocks/interior-design-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:39:\"[\"Business\",\"Footer\",\"Interior Design\"]\";s:10:\"menu_order\";i:203;s:16:\"popularity_index\";i:322;s:11:\"trend_index\";i:178;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:629;a:18:{s:4:\"tmpl\";i:980;s:2:\"id\";i:13236;s:5:\"title\";s:30:\"Interior Design &#8211; Header\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-interior-design.png\";s:12:\"tmpl_created\";i:1586148746;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/blocks/interior-design-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:39:\"[\"Business\",\"Header\",\"Interior Design\"]\";s:10:\"menu_order\";i:204;s:16:\"popularity_index\";i:146;s:11:\"trend_index\";i:64;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:630;a:18:{s:4:\"tmpl\";i:977;s:2:\"id\";i:13259;s:5:\"title\";s:36:\"Interior Design &#8211; News Archive\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/04/Archiv-Blog.png\";s:12:\"tmpl_created\";i:1586148733;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/blocks/interior-design-news-archive/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:30:\"[\"Business\",\"Interior Design\"]\";s:10:\"menu_order\";i:205;s:16:\"popularity_index\";i:436;s:11:\"trend_index\";i:132;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:631;a:18:{s:4:\"tmpl\";i:976;s:2:\"id\";i:13267;s:5:\"title\";s:35:\"Interior Design &#8211; Single News\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/04/Post.png\";s:12:\"tmpl_created\";i:1586148728;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/blocks/interior-design-single-news/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:30:\"[\"Business\",\"Interior Design\"]\";s:10:\"menu_order\";i:206;s:16:\"popularity_index\";i:402;s:11:\"trend_index\";i:108;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:632;a:18:{s:4:\"tmpl\";i:975;s:2:\"id\";i:13274;s:5:\"title\";s:38:\"Interior Design &#8211; Single Project\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/04/Single-Project-.png\";s:12:\"tmpl_created\";i:1586148723;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/blocks/interior-design-single-project/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:30:\"[\"Business\",\"Interior Design\"]\";s:10:\"menu_order\";i:207;s:16:\"popularity_index\";i:601;s:11:\"trend_index\";i:324;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:633;a:18:{s:4:\"tmpl\";i:1011;s:2:\"id\";i:14058;s:5:\"title\";s:36:\"Japanese restaurant &#8211; 404 page\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/06/404-Page.jpg\";s:12:\"tmpl_created\";i:1592290211;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/blocks/japanese-restaurant-404-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:38:\"[\"404\",\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:208;s:16:\"popularity_index\";i:724;s:11:\"trend_index\";i:647;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:634;a:18:{s:4:\"tmpl\";i:1012;s:2:\"id\";i:14050;s:5:\"title\";s:34:\"Japanese restaurant &#8211; Footer\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/06/Footer-Small.jpg\";s:12:\"tmpl_created\";i:1592290247;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/blocks/japanese-restaurant-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:41:\"[\"Food\",\"Footer\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:209;s:16:\"popularity_index\";i:317;s:11:\"trend_index\";i:238;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:635;a:18:{s:4:\"tmpl\";i:1013;s:2:\"id\";i:14042;s:5:\"title\";s:34:\"Japanese Restaurant &#8211; Header\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2020/06/japanese-restaurant-header.jpg\";s:12:\"tmpl_created\";i:1592290277;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/blocks/japanese-restaurant-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:41:\"[\"Food\",\"Header\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:210;s:16:\"popularity_index\";i:411;s:11:\"trend_index\";i:274;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:636;a:18:{s:4:\"tmpl\";i:914;s:2:\"id\";i:12164;s:5:\"title\";s:20:\"Law Firm &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2019/11/404.png\";s:12:\"tmpl_created\";i:1572846979;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/law-firm-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:24:\"[\"404\",\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:211;s:16:\"popularity_index\";i:704;s:11:\"trend_index\";i:716;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:637;a:18:{s:4:\"tmpl\";i:913;s:2:\"id\";i:12170;s:5:\"title\";s:23:\"Law Firm &#8211; Archiv\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2019/11/archiv.png\";s:12:\"tmpl_created\";i:1572846967;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/blocks/law-firm-archiv/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:212;s:16:\"popularity_index\";i:431;s:11:\"trend_index\";i:294;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:638;a:18:{s:4:\"tmpl\";i:912;s:2:\"id\";i:12179;s:5:\"title\";s:23:\"Law Firm &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2019/11/footer.png\";s:12:\"tmpl_created\";i:1572846958;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/blocks/law-firm-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:27:\"[\"Footer\",\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:213;s:16:\"popularity_index\";i:388;s:11:\"trend_index\";i:240;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:639;a:18:{s:4:\"tmpl\";i:911;s:2:\"id\";i:12194;s:5:\"title\";s:23:\"Law Firm &#8211; Header\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-law-firm.png\";s:12:\"tmpl_created\";i:1572846935;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/blocks/law-firm-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:27:\"[\"Header\",\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:214;s:16:\"popularity_index\";i:80;s:11:\"trend_index\";i:39;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:640;a:18:{s:4:\"tmpl\";i:910;s:2:\"id\";i:12203;s:5:\"title\";s:30:\"Law Firm &#8211; Search Archiv\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/11/search_result.png\";s:12:\"tmpl_created\";i:1572846925;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/blocks/law-firm-search-archiv/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:215;s:16:\"popularity_index\";i:493;s:11:\"trend_index\";i:433;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:641;a:18:{s:4:\"tmpl\";i:909;s:2:\"id\";i:12212;s:5:\"title\";s:28:\"Law Firm &#8211; Single Post\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2019/11/single.png\";s:12:\"tmpl_created\";i:1572846914;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/blocks/law-firm-single-post/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:216;s:16:\"popularity_index\";i:326;s:11:\"trend_index\";i:214;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:642;a:18:{s:4:\"tmpl\";i:1022;s:2:\"id\";i:14772;s:5:\"title\";s:35:\"Luxury Real Estate &#8211; 404 page\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/07/404.png\";s:12:\"tmpl_created\";i:1595315728;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/blocks/luxury-real-estate-404-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:34:\"[\"404\",\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:217;s:16:\"popularity_index\";i:759;s:11:\"trend_index\";i:720;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:643;a:18:{s:4:\"tmpl\";i:1023;s:2:\"id\";i:14779;s:5:\"title\";s:33:\"Luxury Real Estate &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/07/Footer.png\";s:12:\"tmpl_created\";i:1595315743;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/blocks/luxury-real-estate-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:37:\"[\"Footer\",\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:218;s:16:\"popularity_index\";i:536;s:11:\"trend_index\";i:505;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:644;a:18:{s:4:\"tmpl\";i:1024;s:2:\"id\";i:14790;s:5:\"title\";s:33:\"Luxury Real Estate &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/07/Header.png\";s:12:\"tmpl_created\";i:1595315760;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/blocks/luxury-real-estate-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:37:\"[\"Header\",\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:219;s:16:\"popularity_index\";i:101;s:11:\"trend_index\";i:157;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:645;a:18:{s:4:\"tmpl\";i:1026;s:2:\"id\";i:14809;s:5:\"title\";s:45:\"Luxury Real Estate &#8211; Properties Archive\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/07/Properties.png\";s:12:\"tmpl_created\";i:1595315826;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/blocks/luxury-real-estate-properties-archive/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:220;s:16:\"popularity_index\";i:414;s:11:\"trend_index\";i:420;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:646;a:18:{s:4:\"tmpl\";i:1027;s:2:\"id\";i:14816;s:5:\"title\";s:47:\"Luxury Real Estate &#8211; Property single post\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2020/07/Single-Property-.png\";s:12:\"tmpl_created\";i:1595315847;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/blocks/luxury-real-estate-property-single-post/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:221;s:16:\"popularity_index\";i:541;s:11:\"trend_index\";i:665;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:647;a:18:{s:4:\"tmpl\";i:1025;s:2:\"id\";i:14799;s:5:\"title\";s:38:\"Luxury Real Estate &#8211; single post\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/07/Post.png\";s:12:\"tmpl_created\";i:1595315792;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/blocks/luxury-real-estate-single-post/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:222;s:16:\"popularity_index\";i:369;s:11:\"trend_index\";i:441;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:648;a:18:{s:4:\"tmpl\";i:950;s:2:\"id\";i:12635;s:5:\"title\";s:20:\"Magazine &#8211; 404\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/01/404_s.png\";s:12:\"tmpl_created\";i:1579060746;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/magazine-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:25:\"[\"404\",\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:223;s:16:\"popularity_index\";i:645;s:11:\"trend_index\";i:734;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:649;a:18:{s:4:\"tmpl\";i:949;s:2:\"id\";i:12643;s:5:\"title\";s:24:\"Magazine &#8211; Archiv1\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/01/Archiv1_s.png\";s:12:\"tmpl_created\";i:1579060737;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/magazine-archiv1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:224;s:16:\"popularity_index\";i:346;s:11:\"trend_index\";i:272;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:650;a:18:{s:4:\"tmpl\";i:946;s:2:\"id\";i:12669;s:5:\"title\";s:23:\"Magazine &#8211; Footer\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/01/Footer_s.png\";s:12:\"tmpl_created\";i:1579060715;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/blocks/magazine-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:28:\"[\"Blog\",\"Footer\",\"Magazine\"]\";s:10:\"menu_order\";i:225;s:16:\"popularity_index\";i:442;s:11:\"trend_index\";i:349;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:651;a:18:{s:4:\"tmpl\";i:945;s:2:\"id\";i:12678;s:5:\"title\";s:23:\"Magazine &#8211; Header\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-magazine.png\";s:12:\"tmpl_created\";i:1579060701;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/blocks/magazine-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:28:\"[\"Blog\",\"Header\",\"Magazine\"]\";s:10:\"menu_order\";i:226;s:16:\"popularity_index\";i:295;s:11:\"trend_index\";i:197;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:652;a:18:{s:4:\"tmpl\";i:947;s:2:\"id\";i:12661;s:5:\"title\";s:23:\"Magazine &#8211; Search\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/01/Search_s.png\";s:12:\"tmpl_created\";i:1579060722;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/blocks/magazine-search/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:227;s:16:\"popularity_index\";i:396;s:11:\"trend_index\";i:509;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:653;a:18:{s:4:\"tmpl\";i:944;s:2:\"id\";i:12688;s:5:\"title\";s:30:\"Magazine &#8211; Single Post 1\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/01/Post2_s.png\";s:12:\"tmpl_created\";i:1579060692;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/blocks/magazine-single-post-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:228;s:16:\"popularity_index\";i:342;s:11:\"trend_index\";i:175;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:654;a:18:{s:4:\"tmpl\";i:943;s:2:\"id\";i:12699;s:5:\"title\";s:30:\"Magazine &#8211; Single Post 2\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/01/Post3_s.png\";s:12:\"tmpl_created\";i:1579060680;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/blocks/magazine-single-post-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:229;s:16:\"popularity_index\";i:348;s:11:\"trend_index\";i:129;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:655;a:18:{s:4:\"tmpl\";i:942;s:2:\"id\";i:12707;s:5:\"title\";s:30:\"Magazine &#8211; Single Post 3\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/01/Post1_s.png\";s:12:\"tmpl_created\";i:1579060669;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/blocks/magazine-single-post-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:230;s:16:\"popularity_index\";i:476;s:11:\"trend_index\";i:246;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:656;a:18:{s:4:\"tmpl\";i:941;s:2:\"id\";i:12716;s:5:\"title\";s:30:\"Magazine &#8211; Single Post 3\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/01/Post4_s.png\";s:12:\"tmpl_created\";i:1579060659;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/blocks/magazine-single-post-3-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:231;s:16:\"popularity_index\";i:513;s:11:\"trend_index\";i:489;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:657;a:18:{s:4:\"tmpl\";i:948;s:2:\"id\";i:12652;s:5:\"title\";s:17:\"Magazine- Archiv2\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/01/Archiv2_s.png\";s:12:\"tmpl_created\";i:1579060730;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/magazine-archiv2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:232;s:16:\"popularity_index\";i:525;s:11:\"trend_index\";i:585;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:658;a:18:{s:4:\"tmpl\";i:990;s:2:\"id\";i:13361;s:5:\"title\";s:25:\"Online Course &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/04/404.jpg\";s:12:\"tmpl_created\";i:1587474710;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/online-course-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:35:\"[\"404\",\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:233;s:16:\"popularity_index\";i:682;s:11:\"trend_index\";i:498;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:659;a:18:{s:4:\"tmpl\";i:987;s:2:\"id\";i:13387;s:5:\"title\";s:32:\"Online Course &#8211; End Lesson\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/04/Lesson-End-.jpg\";s:12:\"tmpl_created\";i:1587474682;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/blocks/online-course-end-lesson/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:234;s:16:\"popularity_index\";i:653;s:11:\"trend_index\";i:408;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:660;a:18:{s:4:\"tmpl\";i:989;s:2:\"id\";i:13369;s:5:\"title\";s:28:\"Online Course &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/04/Footer.jpg\";s:12:\"tmpl_created\";i:1587474701;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/blocks/online-course-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:38:\"[\"Course Online\",\"Education\",\"Footer\"]\";s:10:\"menu_order\";i:235;s:16:\"popularity_index\";i:389;s:11:\"trend_index\";i:308;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:661;a:18:{s:4:\"tmpl\";i:988;s:2:\"id\";i:13378;s:5:\"title\";s:28:\"Online Course &#8211; Header\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-education-online-courses.jpg\";s:12:\"tmpl_created\";i:1587474693;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/blocks/online-course-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:38:\"[\"Course Online\",\"Education\",\"Header\"]\";s:10:\"menu_order\";i:236;s:16:\"popularity_index\";i:492;s:11:\"trend_index\";i:519;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:662;a:18:{s:4:\"tmpl\";i:986;s:2:\"id\";i:13395;s:5:\"title\";s:34:\"Online Course &#8211; Start Lesson\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/04/Lesson-Start.jpg\";s:12:\"tmpl_created\";i:1587474673;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/blocks/online-course-start-lesson/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:237;s:16:\"popularity_index\";i:672;s:11:\"trend_index\";i:578;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:663;a:18:{s:4:\"tmpl\";i:953;s:2:\"id\";i:13089;s:5:\"title\";s:23:\"Photography &#8211; 404\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/02/404_s.png\";s:12:\"tmpl_created\";i:1582091623;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/blocks/photography-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:33:\"[\"404\",\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:238;s:16:\"popularity_index\";i:702;s:11:\"trend_index\";i:706;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:664;a:18:{s:4:\"tmpl\";i:954;s:2:\"id\";i:13096;s:5:\"title\";s:32:\"Photography &#8211; Archiv Media\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/02/Archiv_s.png\";s:12:\"tmpl_created\";i:1582091742;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/blocks/photography-archiv-media/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:239;s:16:\"popularity_index\";i:631;s:11:\"trend_index\";i:405;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:665;a:18:{s:4:\"tmpl\";i:955;s:2:\"id\";i:13103;s:5:\"title\";s:26:\"Photography &#8211; Footer\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/02/Footer_s.png\";s:12:\"tmpl_created\";i:1582091903;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/blocks/photography-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:36:\"[\"Footer\",\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:240;s:16:\"popularity_index\";i:422;s:11:\"trend_index\";i:230;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:666;a:18:{s:4:\"tmpl\";i:957;s:2:\"id\";i:13112;s:5:\"title\";s:26:\"Photography &#8211; Header\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-photography-portfolio.png\";s:12:\"tmpl_created\";i:1582092483;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/blocks/photography-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:36:\"[\"Header\",\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:241;s:16:\"popularity_index\";i:325;s:11:\"trend_index\";i:205;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:667;a:18:{s:4:\"tmpl\";i:956;s:2:\"id\";i:13120;s:5:\"title\";s:31:\"Photography &#8211; Single Post\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/02/Post_s.png\";s:12:\"tmpl_created\";i:1582092351;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/blocks/photography-single-post/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:242;s:16:\"popularity_index\";i:671;s:11:\"trend_index\";i:645;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:668;a:18:{s:4:\"tmpl\";i:901;s:2:\"id\";i:11807;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/09/404_small.png\";s:12:\"tmpl_created\";i:1569430070;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/portfolio-20/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:40:\"[\"404\",\"Creative Portfolio\",\"Portfolio\"]\";s:10:\"menu_order\";i:243;s:16:\"popularity_index\";i:480;s:11:\"trend_index\";i:497;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:669;a:18:{s:4:\"tmpl\";i:900;s:2:\"id\";i:11832;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/09/Footer_small.png\";s:12:\"tmpl_created\";i:1569430019;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/portfolio-19/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:43:\"[\"Creative Portfolio\",\"Footer\",\"Portfolio\"]\";s:10:\"menu_order\";i:244;s:16:\"popularity_index\";i:246;s:11:\"trend_index\";i:102;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:670;a:18:{s:4:\"tmpl\";i:898;s:2:\"id\";i:11847;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/09/Archiv_small.png\";s:12:\"tmpl_created\";i:1569430010;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/portfolio-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:34:\"[\"Creative Portfolio\",\"Portfolio\"]\";s:10:\"menu_order\";i:245;s:16:\"popularity_index\";i:336;s:11:\"trend_index\";i:455;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:671;a:18:{s:4:\"tmpl\";i:897;s:2:\"id\";i:11854;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/09/Post_small.png\";s:12:\"tmpl_created\";i:1569429983;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"Creative Portfolio\",\"Portfolio\"]\";s:10:\"menu_order\";i:246;s:16:\"popularity_index\";i:482;s:11:\"trend_index\";i:609;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:672;a:18:{s:4:\"tmpl\";i:904;s:2:\"id\";i:11890;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-design-portfolio.png\";s:12:\"tmpl_created\";i:1571907344;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/portfolio-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:43:\"[\"Creative Portfolio\",\"Header\",\"Portfolio\"]\";s:10:\"menu_order\";i:247;s:16:\"popularity_index\";i:306;s:11:\"trend_index\";i:364;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:673;a:18:{s:4:\"tmpl\";i:896;s:2:\"id\";i:11861;s:5:\"title\";s:27:\"Portfolio &#8211; Project 1\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Project1_small.png\";s:12:\"tmpl_created\";i:1569429975;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/portfolio-project-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"Creative Portfolio\",\"Portfolio\"]\";s:10:\"menu_order\";i:248;s:16:\"popularity_index\";i:643;s:11:\"trend_index\";i:764;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:674;a:18:{s:4:\"tmpl\";i:895;s:2:\"id\";i:11870;s:5:\"title\";s:27:\"Portfolio &#8211; Project 2\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Project2_small.png\";s:12:\"tmpl_created\";i:1569429964;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/portfolio-project-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"Creative Portfolio\",\"Portfolio\"]\";s:10:\"menu_order\";i:249;s:16:\"popularity_index\";i:662;s:11:\"trend_index\";i:816;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:675;a:18:{s:4:\"tmpl\";i:903;s:2:\"id\";i:11897;s:5:\"title\";s:27:\"Portfolio &#8211; Project 2\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Project2_small.png\";s:12:\"tmpl_created\";i:1569494236;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/blocks/portfolio-project-2-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"Creative Portfolio\",\"Portfolio\"]\";s:10:\"menu_order\";i:250;s:16:\"popularity_index\";i:733;s:11:\"trend_index\";i:744;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:676;a:18:{s:4:\"tmpl\";i:894;s:2:\"id\";i:11877;s:5:\"title\";s:27:\"Portfolio &#8211; Project 3\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Project3_small.png\";s:12:\"tmpl_created\";i:1569429954;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/portfolio-project-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"Creative Portfolio\",\"Portfolio\"]\";s:10:\"menu_order\";i:251;s:16:\"popularity_index\";i:692;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:677;a:18:{s:4:\"tmpl\";i:597;s:2:\"id\";i:5019;s:5:\"title\";s:11:\"Portfolio 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_1.png\";s:12:\"tmpl_created\";i:1520520580;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/portfolio-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"Portfolio\"]\";s:10:\"menu_order\";i:252;s:16:\"popularity_index\";i:170;s:11:\"trend_index\";i:236;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:678;a:18:{s:4:\"tmpl\";i:609;s:2:\"id\";i:5141;s:5:\"title\";s:12:\"Portfolio 10\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_10.png\";s:12:\"tmpl_created\";i:1520520601;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/portfolio-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"Portfolio\"]\";s:10:\"menu_order\";i:253;s:16:\"popularity_index\";i:416;s:11:\"trend_index\";i:478;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:679;a:18:{s:4:\"tmpl\";i:598;s:2:\"id\";i:5027;s:5:\"title\";s:12:\"Portfolio 11\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_2.png\";s:12:\"tmpl_created\";i:1520520581;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/portfolio-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"Portfolio\"]\";s:10:\"menu_order\";i:254;s:16:\"popularity_index\";i:304;s:11:\"trend_index\";i:421;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:680;a:18:{s:4:\"tmpl\";i:599;s:2:\"id\";i:5037;s:5:\"title\";s:12:\"Portfolio 12\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_3.png\";s:12:\"tmpl_created\";i:1520520583;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/portfolio-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"Portfolio\"]\";s:10:\"menu_order\";i:255;s:16:\"popularity_index\";i:279;s:11:\"trend_index\";i:399;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:681;a:18:{s:4:\"tmpl\";i:600;s:2:\"id\";i:5057;s:5:\"title\";s:12:\"Portfolio 13\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_4.png\";s:12:\"tmpl_created\";i:1520520586;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/portfolio-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"Portfolio\"]\";s:10:\"menu_order\";i:256;s:16:\"popularity_index\";i:239;s:11:\"trend_index\";i:288;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:682;a:18:{s:4:\"tmpl\";i:601;s:2:\"id\";i:5071;s:5:\"title\";s:12:\"Portfolio 14\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_5.png\";s:12:\"tmpl_created\";i:1520520588;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/portfolio-14/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"Portfolio\"]\";s:10:\"menu_order\";i:257;s:16:\"popularity_index\";i:276;s:11:\"trend_index\";i:329;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:683;a:18:{s:4:\"tmpl\";i:603;s:2:\"id\";i:5090;s:5:\"title\";s:12:\"Portfolio 15\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_6.png\";s:12:\"tmpl_created\";i:1520520591;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/portfolio-15/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"Portfolio\"]\";s:10:\"menu_order\";i:258;s:16:\"popularity_index\";i:186;s:11:\"trend_index\";i:283;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:684;a:18:{s:4:\"tmpl\";i:604;s:2:\"id\";i:5098;s:5:\"title\";s:12:\"Portfolio 16\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_7.png\";s:12:\"tmpl_created\";i:1520520593;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/portfolio-16/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"Portfolio\"]\";s:10:\"menu_order\";i:259;s:16:\"popularity_index\";i:156;s:11:\"trend_index\";i:211;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:685;a:18:{s:4:\"tmpl\";i:606;s:2:\"id\";i:5115;s:5:\"title\";s:12:\"Portfolio 17\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_8.png\";s:12:\"tmpl_created\";i:1520520596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/portfolio-17/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"Portfolio\"]\";s:10:\"menu_order\";i:260;s:16:\"popularity_index\";i:19;s:11:\"trend_index\";i:22;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:686;a:18:{s:4:\"tmpl\";i:608;s:2:\"id\";i:5133;s:5:\"title\";s:12:\"Portfolio 18\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_9.png\";s:12:\"tmpl_created\";i:1520520599;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/portfolio-18/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"Portfolio\"]\";s:10:\"menu_order\";i:261;s:16:\"popularity_index\";i:180;s:11:\"trend_index\";i:280;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:687;a:18:{s:4:\"tmpl\";i:610;s:2:\"id\";i:5149;s:5:\"title\";s:11:\"Portfolio 2\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_10.png\";s:12:\"tmpl_created\";i:1520520602;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/portfolio-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"Portfolio\"]\";s:10:\"menu_order\";i:262;s:16:\"popularity_index\";i:413;s:11:\"trend_index\";i:635;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:688;a:18:{s:4:\"tmpl\";i:468;s:2:\"id\";i:5045;s:5:\"title\";s:11:\"Portfolio 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_2.png\";s:12:\"tmpl_created\";i:1520443423;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/portfolio-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"Portfolio\"]\";s:10:\"menu_order\";i:263;s:16:\"popularity_index\";i:636;s:11:\"trend_index\";i:608;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:689;a:18:{s:4:\"tmpl\";i:602;s:2:\"id\";i:5082;s:5:\"title\";s:11:\"Portfolio 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_4.png\";s:12:\"tmpl_created\";i:1520520589;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/portfolio-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"Portfolio\"]\";s:10:\"menu_order\";i:264;s:16:\"popularity_index\";i:558;s:11:\"trend_index\";i:654;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:690;a:18:{s:4:\"tmpl\";i:605;s:2:\"id\";i:5107;s:5:\"title\";s:11:\"Portfolio 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_7.png\";s:12:\"tmpl_created\";i:1520520594;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/portfolio-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"Portfolio\"]\";s:10:\"menu_order\";i:265;s:16:\"popularity_index\";i:380;s:11:\"trend_index\";i:347;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:691;a:18:{s:4:\"tmpl\";i:607;s:2:\"id\";i:5125;s:5:\"title\";s:11:\"Portfolio 6\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_8.png\";s:12:\"tmpl_created\";i:1520520597;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/portfolio-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"Portfolio\"]\";s:10:\"menu_order\";i:266;s:16:\"popularity_index\";i:236;s:11:\"trend_index\";i:386;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:692;a:18:{s:4:\"tmpl\";i:596;s:2:\"id\";i:5007;s:5:\"title\";s:11:\"Portfolio 7\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_1.png\";s:12:\"tmpl_created\";i:1520520578;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/portfolio-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"Portfolio\"]\";s:10:\"menu_order\";i:267;s:16:\"popularity_index\";i:44;s:11:\"trend_index\";i:183;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:693;a:18:{s:4:\"tmpl\";i:434;s:2:\"id\";i:4509;s:5:\"title\";s:9:\"Pricing 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_1.png\";s:12:\"tmpl_created\";i:1520443310;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/pricing-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"Pricing\"]\";s:10:\"menu_order\";i:268;s:16:\"popularity_index\";i:703;s:11:\"trend_index\";i:641;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:694;a:18:{s:4:\"tmpl\";i:439;s:2:\"id\";i:4553;s:5:\"title\";s:10:\"Pricing 10\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_4.png\";s:12:\"tmpl_created\";i:1520443319;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/pricing-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"Pricing\"]\";s:10:\"menu_order\";i:269;s:16:\"popularity_index\";i:511;s:11:\"trend_index\";i:506;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:695;a:18:{s:4:\"tmpl\";i:441;s:2:\"id\";i:4572;s:5:\"title\";s:10:\"Pricing 11\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_5.png\";s:12:\"tmpl_created\";i:1520443324;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/pricing-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"Pricing\"]\";s:10:\"menu_order\";i:270;s:16:\"popularity_index\";i:308;s:11:\"trend_index\";i:248;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:696;a:18:{s:4:\"tmpl\";i:442;s:2:\"id\";i:4580;s:5:\"title\";s:10:\"Pricing 12\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_6.png\";s:12:\"tmpl_created\";i:1520443326;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/pricing-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"Pricing\"]\";s:10:\"menu_order\";i:271;s:16:\"popularity_index\";i:576;s:11:\"trend_index\";i:526;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:697;a:18:{s:4:\"tmpl\";i:444;s:2:\"id\";i:4597;s:5:\"title\";s:10:\"Pricing 13\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_7.png\";s:12:\"tmpl_created\";i:1520443330;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/pricing-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"Pricing\"]\";s:10:\"menu_order\";i:272;s:16:\"popularity_index\";i:613;s:11:\"trend_index\";i:450;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:698;a:18:{s:4:\"tmpl\";i:446;s:2:\"id\";i:4613;s:5:\"title\";s:10:\"Pricing 14\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_8.png\";s:12:\"tmpl_created\";i:1520443334;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/pricing-14/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"Pricing\"]\";s:10:\"menu_order\";i:273;s:16:\"popularity_index\";i:581;s:11:\"trend_index\";i:568;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:699;a:18:{s:4:\"tmpl\";i:436;s:2:\"id\";i:4529;s:5:\"title\";s:9:\"Pricing 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_2.png\";s:12:\"tmpl_created\";i:1520443314;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/pricing-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"Pricing\"]\";s:10:\"menu_order\";i:274;s:16:\"popularity_index\";i:609;s:11:\"trend_index\";i:613;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:700;a:18:{s:4:\"tmpl\";i:438;s:2:\"id\";i:4545;s:5:\"title\";s:9:\"Pricing 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_3.png\";s:12:\"tmpl_created\";i:1520443317;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/pricing-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"Pricing\"]\";s:10:\"menu_order\";i:275;s:16:\"popularity_index\";i:707;s:11:\"trend_index\";i:825;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:701;a:18:{s:4:\"tmpl\";i:440;s:2:\"id\";i:4562;s:5:\"title\";s:9:\"Pricing 4\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_4.png\";s:12:\"tmpl_created\";i:1520443322;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/pricing-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"Pricing\"]\";s:10:\"menu_order\";i:276;s:16:\"popularity_index\";i:697;s:11:\"trend_index\";i:821;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:702;a:18:{s:4:\"tmpl\";i:443;s:2:\"id\";i:4589;s:5:\"title\";s:9:\"Pricing 5\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_6.png\";s:12:\"tmpl_created\";i:1520443327;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/pricing-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"Pricing\"]\";s:10:\"menu_order\";i:277;s:16:\"popularity_index\";i:716;s:11:\"trend_index\";i:639;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:703;a:18:{s:4:\"tmpl\";i:445;s:2:\"id\";i:4605;s:5:\"title\";s:9:\"Pricing 6\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_7.png\";s:12:\"tmpl_created\";i:1520443332;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/pricing-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"Pricing\"]\";s:10:\"menu_order\";i:278;s:16:\"popularity_index\";i:738;s:11:\"trend_index\";i:773;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:704;a:18:{s:4:\"tmpl\";i:433;s:2:\"id\";i:4500;s:5:\"title\";s:9:\"Pricing 7\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_1.png\";s:12:\"tmpl_created\";i:1520443308;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/pricing-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"Pricing\"]\";s:10:\"menu_order\";i:279;s:16:\"popularity_index\";i:500;s:11:\"trend_index\";i:451;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:705;a:18:{s:4:\"tmpl\";i:435;s:2:\"id\";i:4521;s:5:\"title\";s:9:\"Pricing 8\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_2.png\";s:12:\"tmpl_created\";i:1520443312;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/pricing-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"Pricing\"]\";s:10:\"menu_order\";i:280;s:16:\"popularity_index\";i:311;s:11:\"trend_index\";i:372;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:706;a:18:{s:4:\"tmpl\";i:437;s:2:\"id\";i:4537;s:5:\"title\";s:9:\"Pricing 9\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_3.png\";s:12:\"tmpl_created\";i:1520443315;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/pricing-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"Pricing\"]\";s:10:\"menu_order\";i:281;s:16:\"popularity_index\";i:589;s:11:\"trend_index\";i:841;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:707;a:18:{s:4:\"tmpl\";i:701;s:2:\"id\";i:9239;s:5:\"title\";s:17:\"product archive 1\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/07/product-archive-350-1.png\";s:12:\"tmpl_created\";i:1532953482;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/product-archive-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:15:\"product archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:282;s:16:\"popularity_index\";i:60;s:11:\"trend_index\";i:25;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:708;a:18:{s:4:\"tmpl\";i:702;s:2:\"id\";i:9247;s:5:\"title\";s:17:\"product archive 2\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/07/product-archive-350-2.png\";s:12:\"tmpl_created\";i:1532953793;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/product-archive-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:15:\"product archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:283;s:16:\"popularity_index\";i:71;s:11:\"trend_index\";i:30;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:709;a:18:{s:4:\"tmpl\";i:703;s:2:\"id\";i:9254;s:5:\"title\";s:17:\"product archive 3\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/07/product-archive-350-3.png\";s:12:\"tmpl_created\";i:1532954032;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/product-archive-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:15:\"product archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:284;s:16:\"popularity_index\";i:73;s:11:\"trend_index\";i:44;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:710;a:18:{s:4:\"tmpl\";i:1046;s:2:\"id\";i:15204;s:5:\"title\";s:24:\"Psychologist &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/09/404.jpg\";s:12:\"tmpl_created\";i:1600161419;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/psychologist-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:40:\"[\"404\",\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:285;s:16:\"popularity_index\";i:574;s:11:\"trend_index\";i:493;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:711;a:18:{s:4:\"tmpl\";i:1047;s:2:\"id\";i:15212;s:5:\"title\";s:28:\"Psychologist &#8211; Archive\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/09/Blog.jpg\";s:12:\"tmpl_created\";i:1600162340;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/blocks/psychologist-archive/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:286;s:16:\"popularity_index\";i:379;s:11:\"trend_index\";i:358;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:712;a:18:{s:4:\"tmpl\";i:1048;s:2:\"id\";i:15219;s:5:\"title\";s:27:\"Psychologist &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/09/Footer.jpg\";s:12:\"tmpl_created\";i:1600163069;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/psychologist-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:43:\"[\"Footer\",\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:287;s:16:\"popularity_index\";i:599;s:11:\"trend_index\";i:500;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:713;a:18:{s:4:\"tmpl\";i:1049;s:2:\"id\";i:15230;s:5:\"title\";s:27:\"Psychologist &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/09/Header.png\";s:12:\"tmpl_created\";i:1600163444;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/psychologist-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:43:\"[\"Header\",\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:288;s:16:\"popularity_index\";i:429;s:11:\"trend_index\";i:423;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:714;a:18:{s:4:\"tmpl\";i:1050;s:2:\"id\";i:15240;s:5:\"title\";s:34:\"Psychologist &#8211; single post 1\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/09/Single-Post.png\";s:12:\"tmpl_created\";i:1600164087;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/blocks/psychologist-single-post-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:289;s:16:\"popularity_index\";i:562;s:11:\"trend_index\";i:570;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:715;a:18:{s:4:\"tmpl\";i:1051;s:2:\"id\";i:15251;s:5:\"title\";s:34:\"Psychologist &#8211; single post 2\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2020/09/Single-Service-Page.png\";s:12:\"tmpl_created\";i:1600165179;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/blocks/psychologist-single-post-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:290;s:16:\"popularity_index\";i:507;s:11:\"trend_index\";i:368;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:716;a:18:{s:4:\"tmpl\";i:412;s:2:\"id\";i:4313;s:5:\"title\";s:11:\"Services 13\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_8.png\";s:12:\"tmpl_created\";i:1520443268;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/services-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:291;s:16:\"popularity_index\";i:115;s:11:\"trend_index\";i:53;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:717;a:18:{s:4:\"tmpl\";i:413;s:2:\"id\";i:4324;s:5:\"title\";s:11:\"Services 14\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_9.png\";s:12:\"tmpl_created\";i:1520443270;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/services-14/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:292;s:16:\"popularity_index\";i:277;s:11:\"trend_index\";i:138;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:718;a:18:{s:4:\"tmpl\";i:418;s:2:\"id\";i:4368;s:5:\"title\";s:11:\"Services 16\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_13.png\";s:12:\"tmpl_created\";i:1520443279;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/services-16/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:293;s:16:\"popularity_index\";i:62;s:11:\"trend_index\";i:59;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:719;a:18:{s:4:\"tmpl\";i:420;s:2:\"id\";i:4391;s:5:\"title\";s:11:\"Services 17\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_14.png\";s:12:\"tmpl_created\";i:1520443283;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/services-17/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:294;s:16:\"popularity_index\";i:153;s:11:\"trend_index\";i:120;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:720;a:18:{s:4:\"tmpl\";i:403;s:2:\"id\";i:4235;s:5:\"title\";s:11:\"Services 18\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_2.png\";s:12:\"tmpl_created\";i:1520443251;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/services-18/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:295;s:16:\"popularity_index\";i:273;s:11:\"trend_index\";i:172;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:721;a:18:{s:4:\"tmpl\";i:417;s:2:\"id\";i:4357;s:5:\"title\";s:11:\"Services 20\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_12.png\";s:12:\"tmpl_created\";i:1520443277;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/services-20/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:296;s:16:\"popularity_index\";i:45;s:11:\"trend_index\";i:45;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:722;a:18:{s:4:\"tmpl\";i:415;s:2:\"id\";i:4341;s:5:\"title\";s:11:\"Services 21\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_11.png\";s:12:\"tmpl_created\";i:1520443274;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/services-21/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:297;s:16:\"popularity_index\";i:142;s:11:\"trend_index\";i:114;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:723;a:18:{s:4:\"tmpl\";i:414;s:2:\"id\";i:4332;s:5:\"title\";s:11:\"Services 22\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_10.png\";s:12:\"tmpl_created\";i:1520443272;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/services-22/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:298;s:16:\"popularity_index\";i:138;s:11:\"trend_index\";i:149;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:724;a:18:{s:4:\"tmpl\";i:401;s:2:\"id\";i:4212;s:5:\"title\";s:11:\"Services 23\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_1.png\";s:12:\"tmpl_created\";i:1520443248;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/services-23/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:299;s:16:\"popularity_index\";i:136;s:11:\"trend_index\";i:302;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:725;a:18:{s:4:\"tmpl\";i:408;s:2:\"id\";i:4276;s:5:\"title\";s:11:\"Services 24\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_4.png\";s:12:\"tmpl_created\";i:1520443261;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/services-24/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:300;s:16:\"popularity_index\";i:353;s:11:\"trend_index\";i:514;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:726;a:18:{s:4:\"tmpl\";i:406;s:2:\"id\";i:4260;s:5:\"title\";s:11:\"Services 25\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_3.png\";s:12:\"tmpl_created\";i:1520443257;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/services-25/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:301;s:16:\"popularity_index\";i:184;s:11:\"trend_index\";i:209;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:727;a:18:{s:4:\"tmpl\";i:404;s:2:\"id\";i:4244;s:5:\"title\";s:11:\"Services 26\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_2.png\";s:12:\"tmpl_created\";i:1520443253;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/services-26/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:302;s:16:\"popularity_index\";i:544;s:11:\"trend_index\";i:596;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:728;a:18:{s:4:\"tmpl\";i:421;s:2:\"id\";i:4400;s:5:\"title\";s:11:\"Services 27\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_13.png\";s:12:\"tmpl_created\";i:1520443285;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/services-27/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:303;s:16:\"popularity_index\";i:286;s:11:\"trend_index\";i:438;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:729;a:18:{s:4:\"tmpl\";i:419;s:2:\"id\";i:4376;s:5:\"title\";s:11:\"Services 28\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_12.png\";s:12:\"tmpl_created\";i:1520443281;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/services-28/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:304;s:16:\"popularity_index\";i:151;s:11:\"trend_index\";i:249;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:730;a:18:{s:4:\"tmpl\";i:416;s:2:\"id\";i:4349;s:5:\"title\";s:11:\"Services 29\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_11.png\";s:12:\"tmpl_created\";i:1520443275;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/services-29/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:305;s:16:\"popularity_index\";i:330;s:11:\"trend_index\";i:483;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:731;a:18:{s:4:\"tmpl\";i:402;s:2:\"id\";i:4227;s:5:\"title\";s:11:\"Services 30\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_1.png\";s:12:\"tmpl_created\";i:1520443250;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/services-30/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:306;s:16:\"popularity_index\";i:351;s:11:\"trend_index\";i:553;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:732;a:18:{s:4:\"tmpl\";i:560;s:2:\"id\";i:6162;s:5:\"title\";s:11:\"Services 31\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_white_1.png\";s:12:\"tmpl_created\";i:1520443668;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/services-31/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:307;s:16:\"popularity_index\";i:372;s:11:\"trend_index\";i:550;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:733;a:18:{s:4:\"tmpl\";i:411;s:2:\"id\";i:4302;s:5:\"title\";s:10:\"Services 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_7.png\";s:12:\"tmpl_created\";i:1520443266;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/services-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:308;s:16:\"popularity_index\";i:58;s:11:\"trend_index\";i:97;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:734;a:18:{s:4:\"tmpl\";i:410;s:2:\"id\";i:4293;s:5:\"title\";s:10:\"Services 6\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_6.png\";s:12:\"tmpl_created\";i:1520443265;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/services-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:309;s:16:\"popularity_index\";i:288;s:11:\"trend_index\";i:269;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:735;a:18:{s:4:\"tmpl\";i:409;s:2:\"id\";i:4284;s:5:\"title\";s:10:\"Services 7\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_5.png\";s:12:\"tmpl_created\";i:1520443263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/services-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:310;s:16:\"popularity_index\";i:27;s:11:\"trend_index\";i:21;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:736;a:18:{s:4:\"tmpl\";i:407;s:2:\"id\";i:4268;s:5:\"title\";s:10:\"Services 8\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_4.png\";s:12:\"tmpl_created\";i:1520443259;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/services-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:311;s:16:\"popularity_index\";i:173;s:11:\"trend_index\";i:213;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:737;a:18:{s:4:\"tmpl\";i:405;s:2:\"id\";i:4252;s:5:\"title\";s:10:\"Services 9\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_3.png\";s:12:\"tmpl_created\";i:1520443255;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/services-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:312;s:16:\"popularity_index\";i:46;s:11:\"trend_index\";i:99;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:738;a:18:{s:4:\"tmpl\";i:677;s:2:\"id\";i:8676;s:5:\"title\";s:13:\"single page 1\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.6.jpg\";s:12:\"tmpl_created\";i:1527682423;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/single-page-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:313;s:16:\"popularity_index\";i:285;s:11:\"trend_index\";i:145;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:739;a:18:{s:4:\"tmpl\";i:678;s:2:\"id\";i:8678;s:5:\"title\";s:13:\"single page 2\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.2.jpg\";s:12:\"tmpl_created\";i:1527682780;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/single-page-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:314;s:16:\"popularity_index\";i:140;s:11:\"trend_index\";i:82;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:740;a:18:{s:4:\"tmpl\";i:679;s:2:\"id\";i:8679;s:5:\"title\";s:13:\"single page 3\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.3.jpg\";s:12:\"tmpl_created\";i:1527682847;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/single-page-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:315;s:16:\"popularity_index\";i:122;s:11:\"trend_index\";i:23;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:741;a:18:{s:4:\"tmpl\";i:680;s:2:\"id\";i:8680;s:5:\"title\";s:13:\"single page 4\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.1.jpg\";s:12:\"tmpl_created\";i:1527682896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/single-page-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:316;s:16:\"popularity_index\";i:373;s:11:\"trend_index\";i:190;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:742;a:18:{s:4:\"tmpl\";i:681;s:2:\"id\";i:8681;s:5:\"title\";s:13:\"single page 5\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.5.jpg\";s:12:\"tmpl_created\";i:1527682969;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/single-page-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:317;s:16:\"popularity_index\";i:287;s:11:\"trend_index\";i:218;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:743;a:18:{s:4:\"tmpl\";i:682;s:2:\"id\";i:8682;s:5:\"title\";s:13:\"single page 6\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.4.jpg\";s:12:\"tmpl_created\";i:1527683026;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/single-page-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:318;s:16:\"popularity_index\";i:412;s:11:\"trend_index\";i:227;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:744;a:18:{s:4:\"tmpl\";i:683;s:2:\"id\";i:8703;s:5:\"title\";s:13:\"single page 7\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.7.jpg\";s:12:\"tmpl_created\";i:1527683072;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/single-page-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:319;s:16:\"popularity_index\";i:401;s:11:\"trend_index\";i:316;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:745;a:18:{s:4:\"tmpl\";i:640;s:2:\"id\";i:7650;s:5:\"title\";s:13:\"Single Post 1\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/single_post_1_v2.jpg\";s:12:\"tmpl_created\";i:1521557736;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/single-post-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:24:\"[\"Blog\",\"Post\",\"Single\"]\";s:10:\"menu_order\";i:320;s:16:\"popularity_index\";i:119;s:11:\"trend_index\";i:266;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:746;a:18:{s:4:\"tmpl\";i:639;s:2:\"id\";i:7663;s:5:\"title\";s:13:\"Single Post 2\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/single_post_2_v2.jpg\";s:12:\"tmpl_created\";i:1521547761;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/single-post-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:24:\"[\"Blog\",\"Post\",\"Single\"]\";s:10:\"menu_order\";i:321;s:16:\"popularity_index\";i:50;s:11:\"trend_index\";i:139;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:747;a:18:{s:4:\"tmpl\";i:705;s:2:\"id\";i:9296;s:5:\"title\";s:13:\"Single Post 3\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2018/09/3002.jpg\";s:12:\"tmpl_created\";i:1537440673;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/single-post-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:322;s:16:\"popularity_index\";i:213;s:11:\"trend_index\";i:204;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:748;a:18:{s:4:\"tmpl\";i:704;s:2:\"id\";i:9301;s:5:\"title\";s:13:\"Single Post 4\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2018/09/3003.jpg\";s:12:\"tmpl_created\";i:1537440661;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/single-post-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:323;s:16:\"popularity_index\";i:248;s:11:\"trend_index\";i:336;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:749;a:18:{s:4:\"tmpl\";i:706;s:2:\"id\";i:9313;s:5:\"title\";s:13:\"Single Post 5\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2018/09/3001.jpg\";s:12:\"tmpl_created\";i:1537440798;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/single-post-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:324;s:16:\"popularity_index\";i:197;s:11:\"trend_index\";i:177;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:750;a:18:{s:4:\"tmpl\";i:707;s:2:\"id\";i:9343;s:5:\"title\";s:13:\"Single Post 6\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2018/09/3004.jpg\";s:12:\"tmpl_created\";i:1537443531;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/single-post-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:325;s:16:\"popularity_index\";i:228;s:11:\"trend_index\";i:279;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:751;a:18:{s:4:\"tmpl\";i:708;s:2:\"id\";i:9349;s:5:\"title\";s:13:\"Single Post 7\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2018/09/3005.jpg\";s:12:\"tmpl_created\";i:1537443903;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/single-post-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:326;s:16:\"popularity_index\";i:158;s:11:\"trend_index\";i:253;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:752;a:18:{s:4:\"tmpl\";i:697;s:2:\"id\";i:9174;s:5:\"title\";s:17:\"single product 01\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/07/single_product01_350.png\";s:12:\"tmpl_created\";i:1532950125;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/single-product-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"single product\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:327;s:16:\"popularity_index\";i:31;s:11:\"trend_index\";i:6;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:753;a:18:{s:4:\"tmpl\";i:698;s:2:\"id\";i:9178;s:5:\"title\";s:17:\"single product 02\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2018/07/single_product02_350new.png\";s:12:\"tmpl_created\";i:1532951997;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/single-product-02/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"single product\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:328;s:16:\"popularity_index\";i:66;s:11:\"trend_index\";i:42;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:754;a:18:{s:4:\"tmpl\";i:699;s:2:\"id\";i:9180;s:5:\"title\";s:17:\"single product 03\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/07/single_product03_350.png\";s:12:\"tmpl_created\";i:1532952302;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/single-product-03/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"single product\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:329;s:16:\"popularity_index\";i:108;s:11:\"trend_index\";i:66;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:755;a:18:{s:4:\"tmpl\";i:700;s:2:\"id\";i:9182;s:5:\"title\";s:17:\"single product 04\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/07/single_product040_350.png\";s:12:\"tmpl_created\";i:1532952606;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/single-product-04/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"single product\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:330;s:16:\"popularity_index\";i:123;s:11:\"trend_index\";i:81;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:756;a:18:{s:4:\"tmpl\";i:555;s:2:\"id\";i:6114;s:5:\"title\";s:7:\"Stats 1\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_black_6.png\";s:12:\"tmpl_created\";i:1520443659;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/stats-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:331;s:16:\"popularity_index\";i:434;s:11:\"trend_index\";i:692;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:757;a:18:{s:4:\"tmpl\";i:562;s:2:\"id\";i:6178;s:5:\"title\";s:8:\"Stats 10\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_white_2.png\";s:12:\"tmpl_created\";i:1520443676;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/stats-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:332;s:16:\"popularity_index\";i:435;s:11:\"trend_index\";i:755;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:758;a:18:{s:4:\"tmpl\";i:561;s:2:\"id\";i:6170;s:5:\"title\";s:8:\"Stats 11\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_black_2.png\";s:12:\"tmpl_created\";i:1520443670;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/stats-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:333;s:16:\"popularity_index\";i:366;s:11:\"trend_index\";i:552;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:759;a:18:{s:4:\"tmpl\";i:563;s:2:\"id\";i:6186;s:5:\"title\";s:8:\"Stats 12\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_white_3.png\";s:12:\"tmpl_created\";i:1520443678;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/stats-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:334;s:16:\"popularity_index\";i:569;s:11:\"trend_index\";i:811;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:760;a:18:{s:4:\"tmpl\";i:550;s:2:\"id\";i:6071;s:5:\"title\";s:8:\"Stats 13\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_3.png\";s:12:\"tmpl_created\";i:1520443649;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/stats-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:335;s:16:\"popularity_index\";i:168;s:11:\"trend_index\";i:328;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:761;a:18:{s:4:\"tmpl\";i:554;s:2:\"id\";i:6106;s:5:\"title\";s:7:\"Stats 2\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_6.png\";s:12:\"tmpl_created\";i:1520443657;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/stats-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:336;s:16:\"popularity_index\";i:361;s:11:\"trend_index\";i:784;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:762;a:18:{s:4:\"tmpl\";i:551;s:2:\"id\";i:6079;s:5:\"title\";s:7:\"Stats 3\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_4.png\";s:12:\"tmpl_created\";i:1520443651;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/stats-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:337;s:16:\"popularity_index\";i:284;s:11:\"trend_index\";i:385;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:763;a:18:{s:4:\"tmpl\";i:552;s:2:\"id\";i:6089;s:5:\"title\";s:7:\"Stats 4\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_5.png\";s:12:\"tmpl_created\";i:1520443653;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/stats-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:338;s:16:\"popularity_index\";i:205;s:11:\"trend_index\";i:452;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:764;a:18:{s:4:\"tmpl\";i:549;s:2:\"id\";i:6063;s:5:\"title\";s:7:\"Stats 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_2.png\";s:12:\"tmpl_created\";i:1520443647;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/stats-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:339;s:16:\"popularity_index\";i:181;s:11:\"trend_index\";i:419;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:765;a:18:{s:4:\"tmpl\";i:553;s:2:\"id\";i:6097;s:5:\"title\";s:7:\"Stats 6\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_black_2.png\";s:12:\"tmpl_created\";i:1520443655;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/stats-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:340;s:16:\"popularity_index\";i:264;s:11:\"trend_index\";i:492;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:766;a:18:{s:4:\"tmpl\";i:538;s:2:\"id\";i:5956;s:5:\"title\";s:7:\"Stats 7\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_black_1.png\";s:12:\"tmpl_created\";i:1520443623;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/stats-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:341;s:16:\"popularity_index\";i:532;s:11:\"trend_index\";i:541;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:767;a:18:{s:4:\"tmpl\";i:537;s:2:\"id\";i:5947;s:5:\"title\";s:7:\"Stats 8\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_1.png\";s:12:\"tmpl_created\";i:1520443621;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/stats-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:342;s:16:\"popularity_index\";i:368;s:11:\"trend_index\";i:531;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:768;a:18:{s:4:\"tmpl\";i:559;s:2:\"id\";i:6152;s:5:\"title\";s:7:\"Stats 9\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_black_1.png\";s:12:\"tmpl_created\";i:1520443666;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/stats-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:343;s:16:\"popularity_index\";i:272;s:11:\"trend_index\";i:557;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:769;a:18:{s:4:\"tmpl\";i:469;s:2:\"id\";i:5157;s:5:\"title\";s:11:\"Subscribe 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_white_1.png\";s:12:\"tmpl_created\";i:1520443448;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/subscribe-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"subscribe\";s:4:\"tags\";s:20:\"[\"Form\",\"Subscribe\"]\";s:10:\"menu_order\";i:344;s:16:\"popularity_index\";i:340;s:11:\"trend_index\";i:293;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:770;a:18:{s:4:\"tmpl\";i:472;s:2:\"id\";i:5181;s:5:\"title\";s:11:\"Subscribe 2\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_black_2.png\";s:12:\"tmpl_created\";i:1520443454;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/subscribe-2-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"subscribe\";s:4:\"tags\";s:20:\"[\"Form\",\"Subscribe\"]\";s:10:\"menu_order\";i:345;s:16:\"popularity_index\";i:451;s:11:\"trend_index\";i:340;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:771;a:18:{s:4:\"tmpl\";i:470;s:2:\"id\";i:5165;s:5:\"title\";s:11:\"Subscribe 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_black_1.png\";s:12:\"tmpl_created\";i:1520443450;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/subscribe-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"subscribe\";s:4:\"tags\";s:20:\"[\"Form\",\"Subscribe\"]\";s:10:\"menu_order\";i:346;s:16:\"popularity_index\";i:520;s:11:\"trend_index\";i:620;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:772;a:18:{s:4:\"tmpl\";i:477;s:2:\"id\";i:5222;s:5:\"title\";s:11:\"Subscribe 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_black_3.png\";s:12:\"tmpl_created\";i:1520443464;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/subscribe-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"subscribe\";s:4:\"tags\";s:20:\"[\"Form\",\"Subscribe\"]\";s:10:\"menu_order\";i:347;s:16:\"popularity_index\";i:397;s:11:\"trend_index\";i:427;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:773;a:18:{s:4:\"tmpl\";i:471;s:2:\"id\";i:5173;s:5:\"title\";s:11:\"Subscribe 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_white_2.png\";s:12:\"tmpl_created\";i:1520443452;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/subscribe-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"subscribe\";s:4:\"tags\";s:20:\"[\"Form\",\"Subscribe\"]\";s:10:\"menu_order\";i:348;s:16:\"popularity_index\";i:261;s:11:\"trend_index\";i:237;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:774;a:18:{s:4:\"tmpl\";i:465;s:2:\"id\";i:4801;s:5:\"title\";s:7:\"Team 11\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_8.png\";s:12:\"tmpl_created\";i:1520443369;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/team-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:349;s:16:\"popularity_index\";i:332;s:11:\"trend_index\";i:188;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:775;a:18:{s:4:\"tmpl\";i:462;s:2:\"id\";i:4770;s:5:\"title\";s:7:\"Team 12\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_6.png\";s:12:\"tmpl_created\";i:1520443364;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/team-12-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:350;s:16:\"popularity_index\";i:432;s:11:\"trend_index\";i:488;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:776;a:18:{s:4:\"tmpl\";i:458;s:2:\"id\";i:4727;s:5:\"title\";s:7:\"Team 13\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_2.png\";s:12:\"tmpl_created\";i:1520443356;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/team-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:351;s:16:\"popularity_index\";i:375;s:11:\"trend_index\";i:345;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:777;a:18:{s:4:\"tmpl\";i:543;s:2:\"id\";i:5999;s:5:\"title\";s:7:\"Team 14\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_10.png\";s:12:\"tmpl_created\";i:1520443634;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/team-14/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:352;s:16:\"popularity_index\";i:110;s:11:\"trend_index\";i:318;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:778;a:18:{s:4:\"tmpl\";i:455;s:2:\"id\";i:4698;s:5:\"title\";s:7:\"Team 15\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_1.png\";s:12:\"tmpl_created\";i:1520443350;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/team-15/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:353;s:16:\"popularity_index\";i:449;s:11:\"trend_index\";i:410;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:779;a:18:{s:4:\"tmpl\";i:463;s:2:\"id\";i:4781;s:5:\"title\";s:7:\"Team 16\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_7.png\";s:12:\"tmpl_created\";i:1520443365;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/team-16/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:354;s:16:\"popularity_index\";i:267;s:11:\"trend_index\";i:330;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:780;a:18:{s:4:\"tmpl\";i:558;s:2:\"id\";i:6144;s:5:\"title\";s:7:\"Team 17\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_11.png\";s:12:\"tmpl_created\";i:1520443664;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/team-17/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:355;s:16:\"popularity_index\";i:166;s:11:\"trend_index\";i:365;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:781;a:18:{s:4:\"tmpl\";i:464;s:2:\"id\";i:4793;s:5:\"title\";s:7:\"Team 18\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_8.png\";s:12:\"tmpl_created\";i:1520443367;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/team-18/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:356;s:16:\"popularity_index\";i:207;s:11:\"trend_index\";i:173;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:782;a:18:{s:4:\"tmpl\";i:466;s:2:\"id\";i:4809;s:5:\"title\";s:7:\"Team 19\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_9.png\";s:12:\"tmpl_created\";i:1520443371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/team-19/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:357;s:16:\"popularity_index\";i:300;s:11:\"trend_index\";i:465;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:783;a:18:{s:4:\"tmpl\";i:459;s:2:\"id\";i:4736;s:5:\"title\";s:7:\"Team 20\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_4.png\";s:12:\"tmpl_created\";i:1520443358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/team-20/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:358;s:16:\"popularity_index\";i:144;s:11:\"trend_index\";i:159;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:784;a:18:{s:4:\"tmpl\";i:467;s:2:\"id\";i:4818;s:5:\"title\";s:7:\"Team 21\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_9.png\";s:12:\"tmpl_created\";i:1520443373;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/team-21/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:359;s:16:\"popularity_index\";i:515;s:11:\"trend_index\";i:606;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:785;a:18:{s:4:\"tmpl\";i:461;s:2:\"id\";i:4759;s:5:\"title\";s:7:\"Team 22\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_5.png\";s:12:\"tmpl_created\";i:1520443362;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/team-22/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:360;s:16:\"popularity_index\";i:299;s:11:\"trend_index\";i:376;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:786;a:18:{s:4:\"tmpl\";i:460;s:2:\"id\";i:4746;s:5:\"title\";s:7:\"Team 23\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_4.png\";s:12:\"tmpl_created\";i:1520443360;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/team-23/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:361;s:16:\"popularity_index\";i:282;s:11:\"trend_index\";i:378;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:787;a:18:{s:4:\"tmpl\";i:457;s:2:\"id\";i:4718;s:5:\"title\";s:6:\"Team 4\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_3.png\";s:12:\"tmpl_created\";i:1520443354;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/team-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:362;s:16:\"popularity_index\";i:192;s:11:\"trend_index\";i:359;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:788;a:18:{s:4:\"tmpl\";i:456;s:2:\"id\";i:4706;s:5:\"title\";s:6:\"Team 5\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_2.png\";s:12:\"tmpl_created\";i:1520443352;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/team-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:363;s:16:\"popularity_index\";i:149;s:11:\"trend_index\";i:299;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:789;a:18:{s:4:\"tmpl\";i:544;s:2:\"id\";i:6008;s:5:\"title\";s:6:\"Team 6\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_10.png\";s:12:\"tmpl_created\";i:1520443636;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/team-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:364;s:16:\"popularity_index\";i:75;s:11:\"trend_index\";i:277;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:790;a:18:{s:4:\"tmpl\";i:454;s:2:\"id\";i:4690;s:5:\"title\";s:6:\"Team 7\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_1.png\";s:12:\"tmpl_created\";i:1520443348;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/team-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:365;s:16:\"popularity_index\";i:243;s:11:\"trend_index\";i:402;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:791;a:18:{s:4:\"tmpl\";i:586;s:2:\"id\";i:4921;s:5:\"title\";s:14:\"Testimonial 10\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_5.png\";s:12:\"tmpl_created\";i:1520520562;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/testimonial-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:366;s:16:\"popularity_index\";i:219;s:11:\"trend_index\";i:198;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:792;a:18:{s:4:\"tmpl\";i:582;s:2:\"id\";i:4889;s:5:\"title\";s:14:\"Testimonial 11\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/customers-2.jpg\";s:12:\"tmpl_created\";i:1520520556;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/testimonial-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:367;s:16:\"popularity_index\";i:557;s:11:\"trend_index\";i:522;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:793;a:18:{s:4:\"tmpl\";i:580;s:2:\"id\";i:4871;s:5:\"title\";s:14:\"Testimonial 12\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_3.png\";s:12:\"tmpl_created\";i:1520520552;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/testimonial-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:368;s:16:\"popularity_index\";i:262;s:11:\"trend_index\";i:391;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:794;a:18:{s:4:\"tmpl\";i:578;s:2:\"id\";i:4854;s:5:\"title\";s:14:\"Testimonial 13\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_2.png\";s:12:\"tmpl_created\";i:1520520549;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/testimonial-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:369;s:16:\"popularity_index\";i:637;s:11:\"trend_index\";i:741;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:795;a:18:{s:4:\"tmpl\";i:595;s:2:\"id\";i:4995;s:5:\"title\";s:14:\"Testimonial 14\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_12.png\";s:12:\"tmpl_created\";i:1520520577;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/testimonial-14/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:370;s:16:\"popularity_index\";i:400;s:11:\"trend_index\";i:411;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:796;a:18:{s:4:\"tmpl\";i:593;s:2:\"id\";i:4979;s:5:\"title\";s:14:\"Testimonial 15\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_10.png\";s:12:\"tmpl_created\";i:1520520573;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/testimonial-15/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:371;s:16:\"popularity_index\";i:568;s:11:\"trend_index\";i:544;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:797;a:18:{s:4:\"tmpl\";i:576;s:2:\"id\";i:4835;s:5:\"title\";s:14:\"Testimonial 16\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_1.png\";s:12:\"tmpl_created\";i:1520520546;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/testimonial-16/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:372;s:16:\"popularity_index\";i:399;s:11:\"trend_index\";i:401;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:798;a:18:{s:4:\"tmpl\";i:594;s:2:\"id\";i:4987;s:5:\"title\";s:14:\"Testimonial 17\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_12-1.png\";s:12:\"tmpl_created\";i:1520520575;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/testimonial-17/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:373;s:16:\"popularity_index\";i:159;s:11:\"trend_index\";i:199;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:799;a:18:{s:4:\"tmpl\";i:577;s:2:\"id\";i:4843;s:5:\"title\";s:14:\"Testimonial 18\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_2.png\";s:12:\"tmpl_created\";i:1520520548;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/testimonial-18/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:374;s:16:\"popularity_index\";i:457;s:11:\"trend_index\";i:780;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:800;a:18:{s:4:\"tmpl\";i:579;s:2:\"id\";i:4863;s:5:\"title\";s:14:\"Testimonial 19\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_3.png\";s:12:\"tmpl_created\";i:1520520551;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/testimonial-19/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:375;s:16:\"popularity_index\";i:245;s:11:\"trend_index\";i:599;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:801;a:18:{s:4:\"tmpl\";i:581;s:2:\"id\";i:4880;s:5:\"title\";s:14:\"Testimonial 20\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/customers-1.jpg\";s:12:\"tmpl_created\";i:1520520554;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/testimonial-20/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:376;s:16:\"popularity_index\";i:446;s:11:\"trend_index\";i:653;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:802;a:18:{s:4:\"tmpl\";i:583;s:2:\"id\";i:4897;s:5:\"title\";s:14:\"Testimonial 21\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_5.png\";s:12:\"tmpl_created\";i:1520520557;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/testimonial-21/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:377;s:16:\"popularity_index\";i:78;s:11:\"trend_index\";i:289;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:803;a:18:{s:4:\"tmpl\";i:584;s:2:\"id\";i:4905;s:5:\"title\";s:14:\"Testimonial 22\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_6.png\";s:12:\"tmpl_created\";i:1520520559;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/testimonial-22/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:378;s:16:\"popularity_index\";i:121;s:11:\"trend_index\";i:221;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:804;a:18:{s:4:\"tmpl\";i:585;s:2:\"id\";i:4913;s:5:\"title\";s:14:\"Testimonial 23\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_7.png\";s:12:\"tmpl_created\";i:1520520561;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/testimonial-23/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:379;s:16:\"popularity_index\";i:247;s:11:\"trend_index\";i:566;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:805;a:18:{s:4:\"tmpl\";i:575;s:2:\"id\";i:4826;s:5:\"title\";s:14:\"Testimonial 24\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_1.png\";s:12:\"tmpl_created\";i:1520520544;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/testimonial-24-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:380;s:16:\"popularity_index\";i:256;s:11:\"trend_index\";i:395;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:806;a:18:{s:4:\"tmpl\";i:587;s:2:\"id\";i:4929;s:5:\"title\";s:14:\"Testimonial 24\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_8.png\";s:12:\"tmpl_created\";i:1520520564;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/testimonial-24/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:381;s:16:\"popularity_index\";i:49;s:11:\"trend_index\";i:206;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:807;a:18:{s:4:\"tmpl\";i:591;s:2:\"id\";i:4963;s:5:\"title\";s:14:\"Testimonial 25\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_10.png\";s:12:\"tmpl_created\";i:1520520570;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/testimonial-25-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:382;s:16:\"popularity_index\";i:417;s:11:\"trend_index\";i:546;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:808;a:18:{s:4:\"tmpl\";i:592;s:2:\"id\";i:4971;s:5:\"title\";s:14:\"Testimonial 26\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_11.png\";s:12:\"tmpl_created\";i:1520520572;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/testimonial-26/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:383;s:16:\"popularity_index\";i:649;s:11:\"trend_index\";i:718;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:809;a:18:{s:4:\"tmpl\";i:589;s:2:\"id\";i:4947;s:5:\"title\";s:14:\"Testimonial 27\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_9.png\";s:12:\"tmpl_created\";i:1520520567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/testimonial-27/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:384;s:16:\"popularity_index\";i:221;s:11:\"trend_index\";i:496;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:810;a:18:{s:4:\"tmpl\";i:590;s:2:\"id\";i:4955;s:5:\"title\";s:14:\"Testimonial 29\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_9.png\";s:12:\"tmpl_created\";i:1520520569;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/testimonial-29/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:385;s:16:\"popularity_index\";i:378;s:11:\"trend_index\";i:695;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:811;a:18:{s:4:\"tmpl\";i:588;s:2:\"id\";i:4939;s:5:\"title\";s:13:\"Testimonial 9\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_8.png\";s:12:\"tmpl_created\";i:1520520565;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/testimonial-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:386;s:16:\"popularity_index\";i:103;s:11:\"trend_index\";i:341;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:812;a:18:{s:4:\"tmpl\";i:928;s:2:\"id\";i:12509;s:5:\"title\";s:18:\"Travel &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2019/12/404.png\";s:12:\"tmpl_created\";i:1575960378;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/travel-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:24:\"[\"404\",\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:387;s:16:\"popularity_index\";i:747;s:11:\"trend_index\";i:712;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:813;a:18:{s:4:\"tmpl\";i:929;s:2:\"id\";i:12516;s:5:\"title\";s:27:\"Travel &#8211; Archive Blog\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2019/12/Archiv_s.png\";s:12:\"tmpl_created\";i:1575960387;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/travel-archive-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:388;s:16:\"popularity_index\";i:496;s:11:\"trend_index\";i:487;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:814;a:18:{s:4:\"tmpl\";i:927;s:2:\"id\";i:12500;s:5:\"title\";s:21:\"Travel &#8211; Header\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-travel-and-tours.png\";s:12:\"tmpl_created\";i:1575960371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/travel-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:27:\"[\"Header\",\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:389;s:16:\"popularity_index\";i:443;s:11:\"trend_index\";i:434;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:815;a:18:{s:4:\"tmpl\";i:930;s:2:\"id\";i:12524;s:5:\"title\";s:26:\"Travel &#8211; Single Post\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/12/Single_Post_s.png\";s:12:\"tmpl_created\";i:1575960397;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/blocks/travel-single-post/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:390;s:16:\"popularity_index\";i:591;s:11:\"trend_index\";i:663;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:816;a:18:{s:4:\"tmpl\";i:931;s:2:\"id\";i:12531;s:5:\"title\";s:31:\"Travel &#8211; Single Post Tour\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/12/Single_Tour_s.png\";s:12:\"tmpl_created\";i:1575960404;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/blocks/travel-single-post-tour/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:391;s:16:\"popularity_index\";i:630;s:11:\"trend_index\";i:548;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:817;a:18:{s:4:\"tmpl\";i:926;s:2:\"id\";i:12492;s:5:\"title\";s:14:\"Travel -Footer\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2019/12/Footer_s.png\";s:12:\"tmpl_created\";i:1575960358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/travel-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:27:\"[\"Footer\",\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:392;s:16:\"popularity_index\";i:453;s:11:\"trend_index\";i:322;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:818;a:18:{s:4:\"tmpl\";i:1068;s:2:\"id\";i:15498;s:5:\"title\";s:23:\"Travel Blog &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/11/404.jpg\";s:12:\"tmpl_created\";i:1606215636;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/blocks/travel-blog-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:23:\"[\"404\",\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:393;s:16:\"popularity_index\";i:749;s:11:\"trend_index\";i:759;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:819;a:18:{s:4:\"tmpl\";i:1069;s:2:\"id\";i:15508;s:5:\"title\";s:29:\"Travel Blog &#8211; Archive 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2020/11/Archive-1-350.jpg\";s:12:\"tmpl_created\";i:1606215649;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/blocks/travel-blog-archive-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:394;s:16:\"popularity_index\";i:659;s:11:\"trend_index\";i:468;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:820;a:18:{s:4:\"tmpl\";i:1070;s:2:\"id\";i:15518;s:5:\"title\";s:29:\"Travel Blog &#8211; Archive 2\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2020/11/Archive-2-350-Copy.jpg\";s:12:\"tmpl_created\";i:1606215663;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/blocks/travel-blog-archive-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:395;s:16:\"popularity_index\";i:688;s:11:\"trend_index\";i:431;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:821;a:18:{s:4:\"tmpl\";i:1071;s:2:\"id\";i:15528;s:5:\"title\";s:26:\"Travel Blog &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/11/Footer.jpg\";s:12:\"tmpl_created\";i:1606215673;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/blocks/travel-blog-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:26:\"[\"Blog\",\"Footer\",\"Travel\"]\";s:10:\"menu_order\";i:396;s:16:\"popularity_index\";i:656;s:11:\"trend_index\";i:377;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:822;a:18:{s:4:\"tmpl\";i:1067;s:2:\"id\";i:15536;s:5:\"title\";s:26:\"Travel Blog &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/11/Header.jpg\";s:12:\"tmpl_created\";i:1606215625;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/blocks/travel-blog-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:26:\"[\"Blog\",\"Header\",\"Travel\"]\";s:10:\"menu_order\";i:397;s:16:\"popularity_index\";i:584;s:11:\"trend_index\";i:228;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:823;a:18:{s:4:\"tmpl\";i:1072;s:2:\"id\";i:15545;s:5:\"title\";s:33:\"Travel Blog &#8211; Single Post 1\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/11/Single-1-350.jpg\";s:12:\"tmpl_created\";i:1606215684;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/blocks/travel-blog-single-post-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:398;s:16:\"popularity_index\";i:669;s:11:\"trend_index\";i:482;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:824;a:18:{s:4:\"tmpl\";i:1066;s:2:\"id\";i:15556;s:5:\"title\";s:33:\"Travel Blog &#8211; Single Post 2\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/11/Single-2-350.jpg\";s:12:\"tmpl_created\";i:1606215613;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/blocks/travel-blog-single-post-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:399;s:16:\"popularity_index\";i:652;s:11:\"trend_index\";i:454;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}}}", "no");
INSERT INTO `wp_options` VALUES("5103", "elementor_remote_info_feed_data", "a:3:{i:0;a:5:{s:5:\"title\";s:77:\"Introducing New Nested Elements - the Future of Design with Elementor widgets\";s:7:\"excerpt\";s:416:\"Elementor and Elementor Pro 3.10 include new design capabilities that will unlock a whole new world of creativity when it comes to designing your websites with Nested Elements, and introduces a new custom unit in sizing controls that will enable you to reach a higher level of accuracy when it comes to designing your websites. These versions also include a new container-based library, and performance improvements.\";s:7:\"created\";i:1674137711;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:137:\"https://elementor.com/blog/new-nested-elements-tabs-custom-units/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:1;a:5:{s:5:\"title\";s:98:\"Introducing Elementor 3.9: New Save as Default Option for Elements To Enhance Your Design Workflow\";s:7:\"excerpt\";s:253:\"Elementor 3.9 includes the new Save as a Default option, broadens the capabilities of the Loop Builder to support WooCommerce and the section-based layout, and several additional features that improve the design of your website and its user experience. \";s:7:\"created\";i:1670943042;s:5:\"badge\";s:0:\"\";s:3:\"url\";s:141:\"https://elementor.com/blog/introducing-elementor-3-9-save-as-default/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:2;a:5:{s:5:\"title\";s:82:\"Introducing Loop Builder: Design Every Aspect of your Post and Product Collections\";s:7:\"excerpt\";s:306:\"Elementor 3.8 includes some highly anticipated features, including the first phase of the Loop Builder, with additional functions and capabilities added in upcoming versions. With the Loop Builder, you gain more creative freedom to design your posts and listings, so you can design it any way you’d like.\";s:7:\"created\";i:1667397460;s:5:\"badge\";s:3:\"New\";s:3:\"url\";s:128:\"https://elementor.com/blog/introducing-the-loop-builder/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}}", "no");
INSERT INTO `wp_options` VALUES("5106", "elementor_scheme_color", "a:4:{i:1;s:7:\"#6ec1e4\";i:2;s:7:\"#54595f\";i:3;s:7:\"#7a7a7a\";i:4;s:7:\"#61ce70\";}", "yes");
INSERT INTO `wp_options` VALUES("5107", "elementor_scheme_typography", "a:4:{i:1;a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:11:\"font_weight\";s:3:\"600\";}i:2;a:2:{s:11:\"font_family\";s:11:\"Roboto Slab\";s:11:\"font_weight\";s:3:\"400\";}i:3;a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:11:\"font_weight\";s:3:\"400\";}i:4;a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:11:\"font_weight\";s:3:\"500\";}}", "yes");
INSERT INTO `wp_options` VALUES("5108", "elementor_scheme_color-picker", "a:8:{i:1;s:7:\"#6ec1e4\";i:2;s:7:\"#54595f\";i:3;s:7:\"#7a7a7a\";i:4;s:7:\"#61ce70\";i:5;s:7:\"#4054b2\";i:6;s:7:\"#23a455\";i:7;s:4:\"#000\";i:8;s:4:\"#fff\";}", "yes");
INSERT INTO `wp_options` VALUES("5109", "elementor_library_category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("5151", "elementor_pro_license_key", "activated", "yes");
INSERT INTO `wp_options` VALUES("5152", "_elementor_pro_license_data", "a:2:{s:7:\"timeout\";i:1650360384;s:5:\"value\";s:42:\"{\"license\":\"valid\",\"expires\":\"01.01.2030\"}\";}", "no");
INSERT INTO `wp_options` VALUES("5153", "elementor_pro_version", "3.5.2", "yes");
INSERT INTO `wp_options` VALUES("5154", "_elementor_pro_api_requests_lock", "a:2:{s:16:\"get_license_data\";i:1643576815;s:11:\"get_version\";i:1650131769;}", "yes");
INSERT INTO `wp_options` VALUES("5155", "_elementor_pro_license_data_fallback", "a:2:{s:7:\"timeout\";i:1643675816;s:5:\"value\";s:50:\"{\"error\":\"subscription not found\",\"success\":false}\";}", "no");
INSERT INTO `wp_options` VALUES("5156", "widget_elementor-library", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("5157", "_elementor_pro_installed_time", "1643131625", "yes");
INSERT INTO `wp_options` VALUES("5158", "elementor_submissions_db_version", "5", "yes");
INSERT INTO `wp_options` VALUES("5161", "elementor_log", "a:43:{s:32:\"f4c0725a11a7ff60f5c29eb7e29c5940\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-06-11 21:37:13\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.6.5\";s:2:\"to\";s:5:\"3.6.6\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-06-11 21:37:13\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.6.5\";s:2:\"to\";s:5:\"3.6.6\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"61aab8d345a2a1e356f9efa17dbae629\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-06-11 21:37:13\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-06-11 21:37:13\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"a031be196965874d45cf0fb1ba8aad8b\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-06-11 21:37:13\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-06-11 21:37:13\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"b3c4cdbcd513b1c2f8a1d21b653a1e7c\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-06-11 21:37:13\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-06-11 21:37:13\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"f35dcfc3e8781dd7235e98125c459f5c\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-06-11 21:37:13\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.6.5\";s:2:\"to\";s:5:\"3.6.6\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-06-11 21:37:13\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.6.5\";s:2:\"to\";s:5:\"3.6.6\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"edcdcbfef85c74e91dfff5e15913dc4c\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-07-16 19:31:20\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.6.6\";s:2:\"to\";s:5:\"3.6.7\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-07-16 19:31:20\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.6.6\";s:2:\"to\";s:5:\"3.6.7\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"b4c5baeb421b2ab428f9a73aa778a764\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-07-16 19:31:20\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-07-16 19:31:20\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"53133809505abaccb81a1bc82fd3d92e\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-07-16 19:31:20\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-07-16 19:31:20\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"bc2801667d9978e34035a46a45f54c39\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-07-16 19:31:20\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-07-16 19:31:20\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"f81b78b302eec52fc9e2617e86a0062e\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-07-16 19:31:20\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.6.6\";s:2:\"to\";s:5:\"3.6.7\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-07-16 19:31:20\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.6.6\";s:2:\"to\";s:5:\"3.6.7\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"2a2150bae5d22f02f0a9de4a1e04379b\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-09-26 14:46:11\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.6.7\";s:2:\"to\";s:5:\"3.7.7\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-09-26 14:46:11\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.6.7\";s:2:\"to\";s:5:\"3.7.7\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"4bf0c76a4b85e67d8a6f7af7b8ea0423\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-09-26 14:46:11\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-09-26 14:46:11\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"769bc540fcad642a74fc63808c18a844\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-09-26 14:46:11\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-09-26 14:46:11\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"c61a351ecf913a812fc93c847a76465d\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-09-26 14:46:11\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-09-26 14:46:11\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"3d957e0994a2f014dbff646f3c3e6f28\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-09-26 14:46:11\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.6.7\";s:2:\"to\";s:5:\"3.7.7\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-09-26 14:46:11\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.6.7\";s:2:\"to\";s:5:\"3.7.7\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"196a9203d75b6659dde849c921854a01\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-10-12 13:51:26\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.7.7\";s:2:\"to\";s:5:\"3.7.8\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-10-12 13:51:26\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.7.7\";s:2:\"to\";s:5:\"3.7.8\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"37aa239f6fe0212bfe03a5b5943db4b8\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-10-12 13:51:27\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-10-12 13:51:27\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"8f9581e776fade2831da1876359ea9b4\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-10-12 13:51:27\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-10-12 13:51:27\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"db46ac610458dc9a854dca2381ad6209\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-10-12 13:51:27\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-10-12 13:51:27\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"a276d2b5d84095d43e710638a013f419\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-10-12 13:51:27\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.7.7\";s:2:\"to\";s:5:\"3.7.8\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-10-12 13:51:27\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.7.7\";s:2:\"to\";s:5:\"3.7.8\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"8801e8a699ae4acd1097d4e1d849a8f1\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-11-09 00:23:32\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.7.8\";s:2:\"to\";s:5:\"3.8.0\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-11-09 00:23:32\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.7.8\";s:2:\"to\";s:5:\"3.8.0\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"e0e8c0695faa1a222d4c6ec2a957438c\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-11-09 00:23:33\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-11-09 00:23:33\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"d7591ef246da41f603b7c9109e8a4043\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-11-09 00:23:33\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-11-09 00:23:33\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"6e94d5c5026663187d3e1daf8741c6ef\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-11-09 00:23:33\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-11-09 00:23:33\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"fca52cdc0e1bc766688e7a5ded61199b\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-11-09 00:23:33\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:68:\"المنتور/Upgrades - _v_3_8_0_fix_php8_image_custom_size Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-11-09 00:23:33\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:68:\"المنتور/Upgrades - _v_3_8_0_fix_php8_image_custom_size Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"d9fdbc9ca60d605c22ce78cd35323f9e\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-11-09 00:23:33\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:70:\"المنتور/Upgrades - _v_3_8_0_fix_php8_image_custom_size Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-11-09 00:23:33\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:70:\"المنتور/Upgrades - _v_3_8_0_fix_php8_image_custom_size Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"f4acb853cf3695eb6f3c284b6162067a\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-11-09 00:23:33\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.7.8\";s:2:\"to\";s:5:\"3.8.0\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-11-09 00:23:33\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.7.8\";s:2:\"to\";s:5:\"3.8.0\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"1f71900646cdf31b19c627bc84b511d3\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-02-22 11:38:28\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.8.0\";s:2:\"to\";s:6:\"3.11.1\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-02-22 11:38:28\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.8.0\";s:2:\"to\";s:6:\"3.11.1\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"fe1947f8e89911f560bfb41e35f699b0\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-02-22 11:38:29\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-02-22 11:38:29\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"8e993d8097924c4f1bbeb18034b8ed02\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-02-22 11:38:29\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-02-22 11:38:29\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"beb487d02294a58be42b7695cee7f89f\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-02-22 11:38:29\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-02-22 11:38:29\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"0a410ed058f5d19081c6bc7e80ac51e8\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-02-22 11:38:29\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.8.0\";s:2:\"to\";s:6:\"3.11.1\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-02-22 11:38:29\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.8.0\";s:2:\"to\";s:6:\"3.11.1\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"ed1afca3bef60ff6e0a2d75a4ea0f191\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:1:\"8\";s:7:\"\0*\0file\";s:88:\"https://kelaketfilm.dev/wp-content/themes/KelaketFilm/js/carousel.elementor.js?ver=1.0.0\";s:7:\"\0*\0line\";s:2:\"43\";s:7:\"\0*\0date\";s:19:\"2023-02-22 09:27:12\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:21:\"Swiper is not defined\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:3;s:14:\"\0*\0times_dates\";a:3:{i:0;s:19:\"2023-02-22 09:27:12\";i:1;s:19:\"2023-02-22 09:27:12\";i:2;s:19:\"2023-02-22 09:27:12\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1677058032\";s:7:\"message\";s:21:\"Swiper is not defined\";s:3:\"url\";s:88:\"https://kelaketfilm.dev/wp-content/themes/KelaketFilm/js/carousel.elementor.js?ver=1.0.0\";s:4:\"line\";s:2:\"43\";s:6:\"column\";s:1:\"8\";}}s:32:\"61ab5651eb4a61ae8b176619b924d493\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-03-14 14:28:20\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.11.1\";s:2:\"to\";s:6:\"3.11.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-03-14 14:28:20\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.11.1\";s:2:\"to\";s:6:\"3.11.4\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"5a2e8e2f2bc9076410d787f4d233eaf6\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-03-14 14:28:20\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-03-14 14:28:20\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"0633e36e24c0df27e88e11a4694196fc\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-03-14 14:28:20\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-03-14 14:28:20\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"b54f65852024cfa6a37c7a968bc040de\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-03-14 14:28:20\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-03-14 14:28:20\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"62b4601f5bca16fda3296a7f1092b5d5\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-03-14 14:28:20\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.11.1\";s:2:\"to\";s:6:\"3.11.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-03-14 14:28:20\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.11.1\";s:2:\"to\";s:6:\"3.11.4\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"40eda98140f0fc19fd20e1cdc9650bb6\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-03-14 14:28:35\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-03-14 14:28:35\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"dbe252a50d48fc96704ac6fc84e273ba\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-03-14 14:28:35\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-03-14 14:28:35\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"414f18a2ffbde4d80b4c0c9a065be473\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-03-14 14:28:35\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-03-14 14:28:35\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"d7e08c1c69812a3d5d4e436999bafc3b\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-03-14 14:28:35\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.11.4\";s:2:\"to\";s:6:\"3.11.5\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-03-14 14:28:35\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.11.4\";s:2:\"to\";s:6:\"3.11.5\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"98002d9ecf0233d20058384d17954c98\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-03-14 14:28:35\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.11.4\";s:2:\"to\";s:6:\"3.11.5\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-03-14 14:28:35\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.11.4\";s:2:\"to\";s:6:\"3.11.5\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}}", "no");
INSERT INTO `wp_options` VALUES("5162", "elementor_pro_theme_builder_conditions", "a:1:{s:6:\"footer\";a:1:{i:1244;a:1:{i:0;s:15:\"exclude/general\";}}}", "yes");
INSERT INTO `wp_options` VALUES("5163", "elementor_fonts_manager_font_types", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("5164", "elementor_fonts_manager_fonts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("5165", "elementor_custom_icon_sets_config", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("5212", "db_upgraded", "", "yes");
INSERT INTO `wp_options` VALUES("5216", "elementor_pro_remote_info_api_data_3.5.2", "a:2:{s:7:\"timeout\";i:1643613805;s:5:\"value\";s:41931:\"{\"stable_version\":\"3.5.2\",\"last_updated\":\"2021-11-28 17:01:54\",\"sections\":\"a:2:{s:11:\\\"description\\\";s:161:\\\"Elementor Pro adds new features to the Elementor Page Builder plugin. Control your conversions, your user engagement, your entire website, from one page builder.\\\";s:9:\\\"changelog\\\";s:37617:\\\"<h4>3.5.2 - 2021-11-28<\\/h4>\\n<ul>\\n<li>Tweak: Adjusted license mechanism to support trial period<\\/li>\\n<li>Fix: Updates made to Global Widgets do not reflect accordingly to linked widgets (#16815)<\\/li>\\n<li>Fix: Hamburger toggle button doesn\'t change to \\u201cclose\\u201d when menu is collapsed in Nav Menu widget when Inline Font Awesome experiment is active<\\/li>\\n<li>Fix: Global Widget cannot be unlinked<\\/li>\\n<\\/ul>\\n<h4>3.5.1 - 2021-11-10<\\/h4>\\n<ul>\\n<li>Fix: Inline HTML elements appear as plain text in Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16816\\\">#16816<\\/a>)<\\/li>\\n<li>Fix: Dropdown items inherited values from Main Menu space between control in Nav Menu widget (<a href=\\\"(https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16815)\\\">#16815<\\/a><\\/li>\\n<li>Fix: Order Summary titles style controls not applying on various devices in Cart widget<\\/li>\\n<li>Fix: Panel &quot;Need Help&quot; link is not correct in WooCommerce section in Site Settings<\\/li>\\n<\\/ul>\\n<h4>3.5.0 - 2021-11-01<\\/h4>\\n<ul>\\n<li>New: WooCommerce Checkout widget - Fully customize the content and style of your checkout page (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15282\\\">#15282<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15990\\\">#15990<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11014\\\">#11014<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13218\\\">#13218<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5383\\\">#5383<\\/a>)<\\/li>\\n<li>New: WooCommerce Cart widget - Style your cart page the way you want with design flexibility (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15282\\\">#15282<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11014\\\">#11014<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13218\\\">#13218<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5383\\\">#5383<\\/a>)<\\/li>\\n<li>New: WooCommerce My Account widget - Create a custom design for your my account pages (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11014\\\">#11014<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5383\\\">#5383<\\/a>)<\\/li>\\n<li>New: Progress Tracker widget - Motivate your customers to keep reading your site content (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16576\\\">#16576<\\/a>)<\\/li>\\n<li>New: Meet WooCommerce Site Settings - Set your store pages within Elementor<\\/li>\\n<li>Experiment: Scroll Snap - Set the scene of every scroll (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10752\\\">#10752<\\/a>)<\\/li>\\n<li>Tweak: Changed infrastructure to prevent rendering bugs in Global Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16354\\\">#16354<\\/a>)<\\/li>\\n<li>Tweak: Added the option to open submission in a new tab in Form Submissions (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14967\\\">#14967<\\/a>)<\\/li>\\n<li>Tweak: Added various responsive controls in Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1851\\\">#1851<\\/a>)<\\/li>\\n<li>Tweak: Split Title and Price styling controls in Price List widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7688\\\">#7688<\\/a>)<\\/li>\\n<li>Tweak: Added various responsive capabilities to controls in Posts Archive widget<\\/li>\\n<li>Tweak: Adjusted Motion Effects module to support future feature<\\/li>\\n<li>Tweak: Changed admin notice content when Pro installed without Core installed<\\/li>\\n<li>Tweak: Cleanup in <code>wp_options<\\/code> table<\\/li>\\n<li>Tweak: Changed Connect logic in Elementor top bar to simplefy the connect process<\\/li>\\n<li>Tweak: Marked new Theme Builder as an Experiment and set to default for new sites<\\/li>\\n<li>Tweak: Enforced better security policies in various widgets and modules<\\/li>\\n<li>Tweak: Added load more button functionality to the Posts Archive widget<\\/li>\\n<li>Tweak: Renamed Elementor\'s responsive SCSS variables<\\/li>\\n<li>Tweak: Added dividers to horizontal layout in Nav Menu widget<\\/li>\\n<li>Tweak: Removed Google+ social network from Share Buttons widget<\\/li>\\n<li>Tweak: Convert usage of old Responsive class to use the new Breakpoints Manager<\\/li>\\n<li>Fix: jQuery in Heading doesn\'t work for not logged in users in Custom Code (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14515\\\">#14515<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14266\\\">#14266<\\/a>)<\\/li>\\n<li>Fix: Menu animation causing page horizontal scroll in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15184\\\">#15184<\\/a>)<\\/li>\\n<li>Fix: Wrong function call in Table of Content &amp; Post Excerpt widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16547\\\">#16547<\\/a>)<\\/li>\\n<li>Fix: Slides to Scroll control can\'t be set to Default if Widescreen mode has a value in Testimonial Carousel widget<\\/li>\\n<li>Fix: Sticky offset not working properly when changing device mode<\\/li>\\n<li>Fix: UTF character issues when exporting CSV file in Form Submissions<\\/li>\\n<li>Fix: Load More functionality doesn\'t work when the Posts widget placed inside an Archive template<\\/li>\\n<li>Fix: UI glitches and editing issues in Video Playlist widget\\n<h4>3.4.2 - 2021-10-12<\\/h4><\\/li>\\n<li>Fix: Icons color style conflicts when Font-Awesome Inline experiment is active in Share Buttons widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16435\\\">#16435<\\/a>)<\\/li>\\n<li>Fix: Mini Cart hides page content when closed in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16305\\\">#16305<\\/a>)<\\/li>\\n<li>Fix: UI glitches in the Editor edit mode when inserting Post Content widget and Font-Awesome Inline experiment is active in Single Post template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16358\\\">#16358<\\/a>)<\\/li>\\n<li>Fix: Slides per view controls disappeared from multiple breakpoints in Testimonial Carousel<\\/li>\\n<li>Fix: Product variations UI glitch in Menu Cart widget<\\/li>\\n<li>Fix: Buttons UI glitch on Safari browser in Menu Cart widget<\\/li>\\n<\\/ul>\\n<h4>3.4.1 - 2021-09-01<\\/h4>\\n<ul>\\n<li>Fix: Sticky functionality is not working if the Additional Custom Breakpoints experiment is active (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16186\\\">#16186<\\/a>)<\\/li>\\n<li>Fix: Slideshow skin UI glitch in Media Carousel widget<\\/li>\\n<li>Fix: Product price typography weight control is not working as expected in Menu Cart widget<\\/li>\\n<\\/ul>\\n<h4>3.4.0 - 2021-09-01<\\/h4>\\n<ul>\\n<li>Tweak: Added new Mini Cart layout type in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11312\\\">#11312<\\/a>)<\\/li>\\n<li>Tweak: Added styling options for Cart, Products, and Cart buttons in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14952\\\">#14952<\\/a>)<\\/li>\\n<li>Tweak: Added the ability to open cart automatically when an item is added in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14119\\\">#14119<\\/a>)<\\/li>\\n<li>Tweak: Added the ability to remove an item from cart without reloading the page with an AJAX request (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9531\\\">#9531<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10875\\\">#10875<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11309\\\">#11309<\\/a>)<\\/li>\\n<li>Tweak: Added Load More AJAX functionality to Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12126\\\">#12126<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1284\\\">#1284<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14557\\\">#14557<\\/a>)<\\/li>\\n<li>Tweak: Added Vimeo support to the Video Playlist widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15319\\\">#15319<\\/a>)<\\/li>\\n<li>Tweak: Improved asset loading performance by serving lighter JS files (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8572\\\">#8572<\\/a>)<\\/li>\\n<li>Tweak: Added query string to the URL only after the first video is played in Video Playlist widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15348\\\">#15348<\\/a>)<\\/li>\\n<li>Tweak: Added various layout options with more responsive controls and cart structure options in Menu Cart widget<\\/li>\\n<li>Tweak: Added the option to open the menu cart by click or hover in Menu Cart widget<\\/li>\\n<li>Tweak: Added the ability to choose a specific product to draw data from in WooCommerce Dynamic tags<\\/li>\\n<li>Tweak: Removed auto-scroll to the widget location when arriving from external URL in Video Playlist widget<\\/li>\\n<li>Tweak: Removed the Video Playlist widget from the Experiments list<\\/li>\\n<li>Tweak: Added descriptive error messages for MailChimp action after submit and on form submit in Forms widget<\\/li>\\n<li>Tweak: Added tooltip trigger None and Hover for link in Hotspot widget<\\/li>\\n<li>Tweak: Added responsive controls to Offset and Effects Offset in Sticky options<\\/li>\\n<li>Tweak: Added responsive control to Alignment in Testimonial Carousel widget<\\/li>\\n<li>Tweak: Adjusted Motion Effects module to support future feature<\\/li>\\n<li>Tweak: Added future compatibility to support better loading of <code>eicons<\\/code> font<\\/li>\\n<li>Tweak: Changed Rename Part title and button color in Theme Builder<\\/li>\\n<li>Fix: Products don\'t appear on the cart while editing in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15451\\\">#15451<\\/a>)<\\/li>\\n<li>Fix: Videos always start muted in the Video Playlist widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15292\\\">#15292<\\/a>)<\\/li>\\n<li>Fix: Unnecessary spacing if submenu indicator is set to None in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15365\\\">#15365<\\/a>)<\\/li>\\n<li>Fix: MailChimp double opt-in feature doesn\'t work in Forms widget<\\/li>\\n<li>Fix: Fetching MailChimp groups field blocks the loading of the rest of the fields in the Form widget<\\/li>\\n<li>Fix: Missing field IDs causes forms not to be sent in Forms widget<\\/li>\\n<li>Fix: Full Content Skin is not working properly when inserted twice on the same page in Posts widget<\\/li>\\n<li>Fix: Avoid Duplicates option doesn\'t exclude manual selections in Posts widget<\\/li>\\n<li>Fix: Submenu indicator alignment issue in Nav menu widget<\\/li>\\n<li>Fix: Query control deprecated message appears when debug mode is defined<\\/li>\\n<li>Fix: Tweet Button icon incorrect color and size when the icon is rendered as SVG in Blockquote widget<\\/li>\\n<li>Fix: Video icon size is not changing on Active state in Video Playlist widget<\\/li>\\n<li>Fix: Header icon color is not working in Table Of Content widget<\\/li>\\n<li>Fix: Icons style glitches when Font Awesome Inline experiment is active in Video Playlist widget<\\/li>\\n<li>Fix: Bullet markers are not visible on preview mode when Font Awesome Inline experiment is active in Table of Content widget<\\/li>\\n<li>Fix: UI Glitch when Font-Awesome Inline experiment is active in Price Table widget<\\/li>\\n<li>Fix: Submenu Indicator appears larger when Font Awesome Inline experiment is active in Nav Menu widget<\\/li>\\n<li>Fix: Part name is deleted when clicking on the &quot;Change&quot; Button without changing the name in Theme Builder<\\/li>\\n<li>Fix: Redundant pagination queries in the Editor<\\/li>\\n<li>Deprecated: Remove all usages of <code>ElementorUtils::get_create_new_post_url()<\\/code><\\/li>\\n<li>Deprecated: See all deprecations to this version in our <a href=\\\"https:\\/\\/developers.elementor.com\\/v3-4-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a><\\/li>\\n<\\/ul>\\n<h4>3.3.8 - 2021-08-23<\\/h4>\\n<ul>\\n<li>Fix: Products grid width issue when adjusting columns and rows in Products widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16001\\\">#16001<\\/a>)<\\/li>\\n<li>Fix: Font Awesome Inline experiment causes icons glitch in Price Table widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16045\\\">#16045<\\/a>)<\\/li>\\n<li>Fix: reCAPTCHA v3 <code>z-index<\\/code> is lower than the Section\'s background color<\\/li>\\n<li>Fix: Style missing when Font Awesome inline experiment is active in Post Info widget<\\/li>\\n<li>Fix: Font Awesome icons were not loaded in Post Info widget<\\/li>\\n<li>Fix: Zero character can\'t be used as a placeholder in Number field in Form widget<\\/li>\\n<li>Fix: Carousels are not working properly in the Editor when Additional Custom Breakpoints experiment is active<\\/li>\\n<\\/ul>\\n<h4>3.3.7 - 2021-08-15<\\/h4>\\n<ul>\\n<li>Tweak: Added support for Additional Custom Breakpoints in Nav Menu widget<\\/li>\\n<li>Tweak: Added support for Additional Custom breakpoints in Motion Effects<\\/li>\\n<li>Fix: Columns didn\'t respond to changes in Gallery widget if Additional Custom Breakpoints Experiment is active<\\/li>\\n<\\/ul>\\n<h4>3.3.6 - 2021-08-10<\\/h4>\\n<ul>\\n<li>Tweak: Added support for future feature in Nav Menu widget<\\/li>\\n<li>Fix: WooCommerce responsive grid styles are not being reflected in Product Related widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15857\\\">#15857<\\/a>)<\\/li>\\n<li>Fix: WooCommerce responsive grid styles are not being reflected in Upsells widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15857\\\">#15857<\\/a>)<\\/li>\\n<li>Fix: WooCommerce responsive grid styles are not being reflected in Product Categories widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15857\\\">#15857<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.3.5 - 2021-08-01<\\/h4>\\n<ul>\\n<li>Fix: Responsive layout glitches in Products and Products Archive widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15773\\\">#15773<\\/a>)<\\/li>\\n<li>Fix: reCAPTCHA V3 integration conflict with required fields validation in Forms widget<\\/li>\\n<\\/ul>\\n<h4>3.3.4 - 2021-07-21<\\/h4>\\n<ul>\\n<li>Fix: Grid layout glitch in WooCommerce Products Archive widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15718\\\">#15718<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.3.3 - 2021-07-20<\\/h4>\\n<ul>\\n<li>Tweak: Added a descriptive message in Collect Submissions action after submit<\\/li>\\n<li>Tweak: Added future compatibility for Additional Custom Breakpoints for Pro widgets<\\/li>\\n<li>Fix: Some widget style breaks when Improved CSS Loading Experiment is active in certain cases (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15632\\\">#15632<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15683\\\">#15683<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15660\\\">#15660<\\/a>)<\\/li>\\n<li>Fix: Translation update keep appearing as available after install (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14297\\\">#14297<\\/a>)<\\/li>\\n<li>Fix: Wrong default icon color when using Font Awesome icons as inline SVG in Call to Action widget<\\/li>\\n<\\/ul>\\n<h4>3.3.2 - 2021-07-13<\\/h4>\\n<ul>\\n<li>Tweak: Updated plugin description<\\/li>\\n<li>Fix: MailChimp tags in form widget replaced existing tags (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11111\\\">#11111<\\/a>)<\\/li>\\n<li>Fix: Clicking videos from the items list in edit mode doesn\\u2019t initiate videos properly<\\/li>\\n<li>Fix: User unauthorized message when activated but not connected in Kit Library<\\/li>\\n<li>Fix: Carousel widgets did not support additional custom breakpoint responsive values<\\/li>\\n<li>Fix: Tab border is overridden by the Section background color in Video Playlist widget<\\/li>\\n<li>Fix: Widgets style breaks when Improved CSS Load experiment is active in a Single Page template and Post Content widget<\\/li>\\n<\\/ul>\\n<h4>3.3.1 - 2021-06-20<\\/h4>\\n<ul>\\n<li>Tweak: Added support for more Theme Builder display conditions in Export \\/ Import experiment<\\/li>\\n<li>Tweak: Adjusted License page heading structure for future feature<\\/li>\\n<li>Tweak: Adjusted Font Awesome icon for allowing support for future feature<\\/li>\\n<li>Fix: <code>frontend.min.js<\\/code> file size increased in Elementor Pro 3.3.0 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15278\\\">#15278<\\/a>)<\\/li>\\n<li>Fix: Prevent conditions from being reset when object cache is enabled in site (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13299\\\">#13299<\\/a>)<\\/li>\\n<li>Fix: Custom Code publish modal responsiveness issues (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14519\\\">#14519<\\/a>)<\\/li>\\n<li>Fix: Populating fields with options programmatically doesn\'t appear in Submissions screen (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10671\\\">#10671<\\/a>)<\\/li>\\n<li>Fix: Large images are not shown on the Image Carousel widget when set via Toolset dynamic tag<\\/li>\\n<li>Fix: Enable inline editing to the inner content tabs in Video Playlist widget<\\/li>\\n<li>Fix: Clicking on the video list doesn\'t play videos properly in Video Playlist widget<\\/li>\\n<li>Fix: Hide Play Icon control when Image overlay is toggled off in Video Playlist widget<\\/li>\\n<li>Fix: Removed extra space below the player when viewing from mobile view in Video Playlist widget<\\/li>\\n<li>Fix: Import button is not working properly in Theme Builder interface<\\/li>\\n<li>Fix: Preview Dynamic Content as control is not updating preview and throws an error in Popup Builder<\\/li>\\n<\\/ul>\\n<h4>3.3.0 - 2021-06-08<\\/h4>\\n<ul>\\n<li>New: Video Playlist widget - Add Engaging Video Content to Your Website (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11859\\\">#11859<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7803\\\">#7803<\\/a>)<\\/li>\\n<li>New: Hotspot widget - Create Interactive Images With Contextually Relevant Information (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7282\\\">#7282<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2768\\\">#2768<\\/a>)<\\/li>\\n<li>Tweak: Accessibility improvements for sub-menus in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13859\\\">#13859<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13810\\\">#13810<\\/a>)<\\/li>\\n<li>Tweak: MailChimp action after submit can now add new tags to existing subscribers in Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11111\\\">#11111<\\/a>)<\\/li>\\n<li>Tweak: Added <code>elementor_pro\\/forms\\/record\\/actions_before<\\/code> to filter the record before it sent to Actions After Submit in Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14261\\\">#14261<\\/a>)<\\/li>\\n<li>Tweak: Yoast SEO breadcrumbs widget can be used in Elementor without the need of enabling them in Yoast setting<\\/li>\\n<li>Tweak: Added future support for widgets CSS conditional loading (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10329\\\">#10329<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14229\\\">#14229<\\/a>)<\\/li>\\n<li>Tweak: Added future support for Sticky JS library conditional loading<\\/li>\\n<li>Tweak: Added future support for Import \\/ Export experiment<\\/li>\\n<li>Tweak: Preparations and fixes for Import Export Experiment in Pro version<\\/li>\\n<li>Tweak: Added gradient button capabilities to Login widget buttons<\\/li>\\n<li>Tweak: Added gradient button capabilities to Slides widget button<\\/li>\\n<li>Tweak: Added gradient button capabilities to Price Table widget button<\\/li>\\n<li>Tweak: Added gradient button capabilities to Flip Box widget button<\\/li>\\n<li>Tweak: Added Code Highlight widget Developers Documentation<\\/li>\\n<li>Tweak: Adjusted Submissions page for future updates<\\/li>\\n<li>Tweak: Added <code>em<\\/code> and <code>%<\\/code> units for padding control in Carousel widgets<\\/li>\\n<li>Tweak: Shorten currency name to currency symbol in PayPal button widget<\\/li>\\n<li>Fix: Custom Fonts URLs should be replaced when replace URL is triggered (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7376\\\">#7376<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10382\\\">#10382<\\/a>)<\\/li>\\n<li>Fix: The currency symbol size changed in the Price Table widget if enabling sale (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13519\\\">#13519<\\/a>)<\\/li>\\n<li>Fix: Nav Menu widget is not loading Font Awesome submenu icons (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9907\\\">#9907<\\/a>)<\\/li>\\n<li>Fix: Hamburger toggle is not working in Nav menu widget<\\/li>\\n<li>Fix: Activation bug for IDN domains<\\/li>\\n<li>Fix: Conditions modal responsive glitches in Custom Code<\\/li>\\n<li>Fix: Duplicated strings in Custom Code module<\\/li>\\n<li>Fix: Enable resize option for code input field in Custom Code<\\/li>\\n<li>Fix: &quot;Save &amp; Close &quot;button in Custom Code\'s Conditions modal was not visible on small screen sizes<\\/li>\\n<li>Fix: Removing a column from a section in the navigator resulted in an empty section<\\/li>\\n<li>Fix: Recommend option is cut If the layout is not &quot;Standard&quot; in the Facebook Button widget<\\/li>\\n<li>Fix: Video item does not play without adding an image in Media Carousel widget<\\/li>\\n<li>Fix: <code>search-plus<\\/code> icon missing from panel in Media Carousel widget<\\/li>\\n<li>Fix: UI hover state glitch in Media Carousel widget<\\/li>\\n<li>Fix: PHP notice was thrown when trying to import a kit without overrideConditions parameter in Kit Import flow<\\/li>\\n<li>Fix: Templates conditions not imported if there are no conflicts in Import Export Experiment<\\/li>\\n<li>Fix: Non english values are not encoded properly on Submissions export<\\/li>\\n<li>Fix: Theme Builder import is not working properly<\\/li>\\n<li>Fix: UI glitch when no global widgets were found in Editor Panel<\\/li>\\n<li>Deprecated: See all deprecations to this version in our <a href=\\\"https:\\/\\/developers.elementor.com\\/v3-3-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a><\\/li>\\n<\\/ul>\\n<h4>3.2.2 - 2021-05-05<\\/h4>\\n<ul>\\n<li>Tweak: Added support for Expert tier templates in Templates Library<\\/li>\\n<li>Tweak: Updated compatibility tag to support Elementor v3.2.x<\\/li>\\n<li>Tweak: Added compatibility for future Library improvements<\\/li>\\n<li>Fix: Toolset image dynamic field is not working with Gallery widget<\\/li>\\n<\\/ul>\\n<h4>3.2.1 - 2021-03-21<\\/h4>\\n<ul>\\n<li>Tweak: Added strings context in PayPal button and Price Table widgets<\\/li>\\n<li>Tweak: Added support for future Import \\/ Export Kit feature<\\/li>\\n<li>Fix: Submissions with over than 191 characters weren\'t indexed properly<\\/li>\\n<\\/ul>\\n<h4>3.2.0 - 2021-03-16<\\/h4>\\n<ul>\\n<li>New: PayPal Button widget - Collect PayPal payments directly from your site<\\/li>\\n<li>Experiment: Submissions - Save all of your form submissions in one place (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1686\\\">#1686<\\/a>)<\\/li>\\n<li>Tweak: Added Stay In Column option to Inner Section element (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7956\\\">#7956<\\/a>)<\\/li>\\n<li>Tweak: Adjusted \'Max Height\' control range in Table of Contents widget<\\/li>\\n<li>Tweak: Changed descriptive text in Create Custom Code screen<\\/li>\\n<li>Tweak: Added support for dynamic capabilities in Code Highlight widget<\\/li>\\n<li>Tweak: Added support for future load on demand for <code>share-link<\\/code> library<\\/li>\\n<li>Tweak: Added support for future load on demand for <code>dialog<\\/code> library in Popup<\\/li>\\n<li>Tweak: Allow overwriting the assets URL when using a mirror domain<\\/li>\\n<li>Fix: Animation was triggered multiple times when accessing the viewport in certain cases in Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13951\\\">#13951<\\/a>)<\\/li>\\n<li>Fix: Location is not being updated after a Custom Code snippet is published (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13971\\\">#13971<\\/a>)<\\/li>\\n<li>Fix: Custom Fonts CSS files were not updated after regenerating CSS files<\\/li>\\n<li>Fix: Conditions modal is not responsive in Custom Code<\\/li>\\n<li>Fix: Empty order buttons are displayed in Custom Fonts screen<\\/li>\\n<li>Fix: Typo in \'Reply To\' Email action after submit placeholder in Forms widget<\\/li>\\n<li>Fix: Unnecessary Save Draft button in Custom Code<\\/li>\\n<li>Fix: RTL glitches in Custom Code<\\/li>\\n<li>Fix: Sanitized options in the editor to enforce better security policies<\\/li>\\n<li>Deprecated: See all deprecations to this version in our (<a href=\\\"https:\\/\\/developers.elementor.com\\/v3-2-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.1.1 - 2021-02-23<\\/h4>\\n<ul>\\n<li>Tweak: Adjusted \'Max Height\' control range in Table of Contents widget<\\/li>\\n<li>Fix: Popup event handler is undefined (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11475\\\">#11475<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10690\\\">#10690<\\/a>)<\\/li>\\n<li>Fix: Conditions modal is not responsive in Custom Code<\\/li>\\n<li>Fix: RTL glitches in Code Highlight widget<\\/li>\\n<li>Fix: Minor UI glitches in Code Highlight widget<\\/li>\\n<li>Fix: Users can\'t get Pro Developer Edition version updates<\\/li>\\n<\\/ul>\\n<h4>3.1.0 - 2021-02-16<\\/h4>\\n<ul>\\n<li>New: Introducing Custom Code - Add custom code snippets to your site, including <code>head<\\/code>, <code>body<\\/code> start and <code>body<\\/code> end<\\/li>\\n<li>New: Meet Code Highlight widget - showcase any syntax with highlighted UI (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5815\\\">#5815<\\/a>)<\\/li>\\n<li>Experiment: Improved Pro widgets performance by loading JS and Swiper assets conditionally in frontend (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8572\\\">#8572<\\/a>, <a href=\\\"https:\\/\\/developers.elementor.com\\/experiment-optimized-asset-loading\\/\\\">Developer Documentation<\\/a>)<\\/li>\\n<li>Tweak: Added Compatibility Tag support in Elementor Pro (<a href=\\\"https:\\/\\/developers.elementor.com\\/compatibility-tag\\/\\\">Developer Documentation<\\/a>)<\\/li>\\n<li>Tweak: Added Dynamic capabilities to Rotating Text animation in Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4625\\\">#4625<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8569\\\">#8569<\\/a>)<\\/li>\\n<li>Tweak: Added an option to set Selected color for Typing effect in Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5403\\\">#5403<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7826\\\">#7826<\\/a>)<\\/li>\\n<li>Tweak: Added animation Loop option for Animated Headline (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9749\\\">#9749<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2457\\\">#2457<\\/a>)<\\/li>\\n<li>Tweak: Added timing options for Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4392\\\">#4392<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic capabilities for Testimonial Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8569\\\">#8569<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic capabilities for Price Table widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4242\\\">#4242<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8569\\\">#8569<\\/a>)<\\/li>\\n<li>Tweak: Added Word Wrap control to Code Highlight widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13577\\\">#13577<\\/a>)<\\/li>\\n<li>Tweak: Upgraded Font Awesome Pro library to v5.15.1<\\/li>\\n<li>Tweak: Improved method of loading field mapping repeater in Form widget (<a href=\\\"https:\\/\\/developers.elementor.com\\/how-to-add-a-repeater-control-to-elementor-add-on\\/\\\">Developer Documentation<\\/a>)<\\/li>\\n<li>Tweak: Added &quot;Show on Browsers&quot; Popup Advanced Rule<\\/li>\\n<li>Tweak: Added real-time JS handling to prevent redundant renders in Slides widget and all Carousel widgets<\\/li>\\n<li>Tweak: Import scroll utility from core and remove it from Pro<\\/li>\\n<li>Tweak: Added alignment options for Post Excerpt widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9757\\\">#9757<\\/a>)<\\/li>\\n<li>Tweak: Changed alignment control to work with selectors in Share Buttons<\\/li>\\n<li>Tweak: Upgraded to Webpack 5, Grunt-Webpack 4 and TerserPlugin instead of UglifyJsPlugin<\\/li>\\n<li>Fix: Steps Divider is not vertically aligned in Multi Step Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12569\\\">#12569<\\/a>)<\\/li>\\n<li>Fix: Slides are playing in an infinite loop mode even when the option is disabled in Slides Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6726\\\">#6726<\\/a>)<\\/li>\\n<li>Fix: Redundant spacing is added to Share Buttons widget<\\/li>\\n<li>Fix: Step buttons text is not updated without a page reload in Forms widget<\\/li>\\n<li>Fix: Overflow issue in certain animations in Animated Headline widget<\\/li>\\n<li>Fix: When dragging a new Testimonial Carousel there is a console error thrown<\\/li>\\n<li>Fix: Step Buttons are cut in mobile view in Multi Step Form<\\/li>\\n<li>Fix: Submit and Step buttons size differences when using Twenty Twenty theme<\\/li>\\n<li>Fix: Duplicate button Text Color control in Slides widget<\\/li>\\n<li>Fix: JS error is thrown when editing and saving global widgets<\\/li>\\n<li>Fix: <code>get_version<\\/code> API function may fail with Redis \\/ DB cache<\\/li>\\n<li>Fix: Multiple license check requests are created in certain cases<\\/li>\\n<li>Deprecated: Deprecate methods prefixed with an underscore and replace them with unprefixed methods<\\/li>\\n<li>Deprecated: See all deprecations to this version in our <a href=\\\"https:\\/\\/developers.elementor.com\\/v3-1-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a><\\/li>\\n<\\/ul>\\n<h4>3.0.10 - 2021-01-20<\\/h4>\\n<ul>\\n<li>Tweak: Added Editing Handles string translation compatibility with Elementor Pro v3.1<\\/li>\\n<\\/ul>\\n<h4>3.0.9 - 2020-12-29<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility to support Elementor 3.1.0<\\/li>\\n<li>Fix: Wrong phrasing of Import template success message in Theme Builder<\\/li>\\n<li>Fix: Border color glitch in Theme Builder<\\/li>\\n<\\/ul>\\n<h4>3.0.8 - 2020-11-26<\\/h4>\\n<ul>\\n<li>Fix: Navigation arrows UI glitch in Media Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13172\\\">#13172<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.0.7 - 2020-11-25<\\/h4>\\n<ul>\\n<li>Fix: Console Error when dragging Testimonials Carousel widget<\\/li>\\n<li>Fix: Arrows of Testimonial and Reviews Carousel widgets navigate to the wrong direction in RTL websites<\\/li>\\n<li>Fix: Removed the conditional loading of Webpack<\\/li>\\n<li>Fix: Fatal error is thrown after deleting an associated custom taxonomy when Posts widget with Cards skin has a badge<\\/li>\\n<li>Fix: Upload JSON files only when the user allowed to prevent security issues<\\/li>\\n<li>Fix: Gallery not displayed in Theme Builder templates preview<\\/li>\\n<\\/ul>\\n<h4>3.0.6 - 2020-11-04<\\/h4>\\n<ul>\\n<li>Tweak: Updated the embedded post in Facebook Embed widget<\\/li>\\n<li>Fix: Minor UI glitches in Theme Builder\'s conditions screen footer<\\/li>\\n<li>Fix: Template type changes into Single Page after conditions change in Theme Builder<\\/li>\\n<li>Fix: Redundant Custom Caption option in Site Logo widget<\\/li>\\n<li>Fix: Removed unused code in Drip integration<\\/li>\\n<li>Fix: Removed Weibo and WeChat social networks due to website and links inactivity from Share Buttons widget<\\/li>\\n<li>Fix: Removed redundant code from Portfolio and Post Navigation widgets<\\/li>\\n<\\/ul>\\n<h4>3.0.5 - 2020-09-23<\\/h4>\\n<ul>\\n<li>Fix: If the default page layout is set to &quot;Canvas&quot; Headers and Footers cannot be edited<\\/li>\\n<li>Fix: Product Image Dynamic Tag throws an error when no image is set<\\/li>\\n<li>Fix: Missing Single document placeholder in Theme Builder<\\/li>\\n<li>Fix: Document editing handles inherit the <code>font-family<\\/code> from 3rd party source<\\/li>\\n<li>Fix: Can\'t add linebreaks to Textarea input when used as Multi Step Form<\\/li>\\n<li>Fix: Incorrect width in Facebook Page widget<\\/li>\\n<li>Fix: Added compatibility to allow the use of \'get_create_url\' in Theme Builder<\\/li>\\n<\\/ul>\\n<h4>3.0.4 - 2020-09-09<\\/h4>\\n<ul>\\n<li>Fix: Autogenerated screenshots appear in WP Media Library modal (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12304\\\">#12304<\\/a>)<\\/li>\\n<li>Fix: Make sure Elementor Posts widget Pagination doesn\'t interfere with 3rd party plugins (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12126\\\">#12126<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12127\\\">#12127<\\/a>)<\\/li>\\n<li>Fix: Shrinking conditions indicator in Theme Builder<\\/li>\\n<li>Fix: Column can\'t be dragged and dropped if it populates a Global widget<\\/li>\\n<li>Fix: Styles are missing from Single templates in some edge cases<\\/li>\\n<\\/ul>\\n<h4>3.0.3 - 2020-09-02<\\/h4>\\n<ul>\\n<li>Fix: Pagination doesn\'t work in WordPress 5.5 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12126\\\">#12126<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12127\\\">#12127<\\/a>)<\\/li>\\n<li>Fix: Change delete template action to &quot;Move to Trash&quot; in the new Theme Builder view<\\/li>\\n<\\/ul>\\n<h4>3.0.2 - 2020-08-31<\\/h4>\\n<ul>\\n<li>Tweak: Replaced WordPress &quot;Learn More&quot; links with dynamic links for better control over time (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12312\\\">#12312<\\/a>)<\\/li>\\n<li>Tweak: UI tweaks to the Conditions screen In the new Theme Builder<\\/li>\\n<li>Fix: Motion Effects not working when assigned to a column and throws JS error when DOM optimization is disabled (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12299\\\">#12299<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12275\\\">#12275<\\/a>)<\\/li>\\n<li>Fix: Multiple Galleries display all the images in the Lightbox slideshow (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11809\\\">#11809<\\/a>)<\\/li>\\n<li>Fix: Old Theme Builder is being opened when accessing through the Finder<\\/li>\\n<li>Fix: Mixed templates import glitch in Theme Builder<\\/li>\\n<li>Fix: Card icon sizes in Theme Builder<\\/li>\\n<li>Fix: Preview button leads to <code>render_mode<\\/code> instead of preview when importing a template from the new Theme Builder<\\/li>\\n<\\/ul>\\n<h4>3.0.1 - 2020-08-26<\\/h4>\\n<ul>\\n<li>Tweak: Keep previous Theme Builder when accessing from the WP Dashboard for legacy support<\\/li>\\n<li>Tweak: Updated video tutorials in Theme Builder<\\/li>\\n<li>Tweak: Don\'t show auto-screenshots in the Media Library (Props <a href=\\\"https:\\/\\/github.com\\/black-eye\\\">@black-eye<\\/a>)<\\/li>\\n<li>Fix: Repeater items throws <code>childView<\\/code> is undefined message in Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12239\\\">#12239<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12221\\\">#12221<\\/a>)<\\/li>\\n<li>Fix: Misspelling of the word &quot;occurred&quot; in Form widget default error message (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12137\\\">#12137<\\/a>)<\\/li>\\n<li>Fix: Facebook comments not showing up (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12157\\\">#12157<\\/a>)<\\/li>\\n<li>Fix: Check for conflicts in Theme Builder doesn\'t work properly<\\/li>\\n<li>Fix: Minor UI fixes in Theme Builder<\\/li>\\n<li>Fix: Dark mode glitches in Theme Builder<\\/li>\\n<li>Fix: Global Site Part toaster appears when you publish a Popup<\\/li>\\n<li>Fix: Site Parts aren\'t in the correct order in Theme Builder<\\/li>\\n<li>Fix: Date field caused forms to get corrupted in Forms widget<\\/li>\\n<li>Fix: Theme Builder application page is forbidden<\\/li>\\n<\\/ul>\\n<h4>3.0.0 - 2020-08-23<\\/h4>\\n<ul>\\n<li>New: Introducing the new and improved Theme Builder<\\/li>\\n<li>Tweak: Removed <code>.elementor-inner<\\/code> and <code>.elementor-column-wrap<\\/code> from DOM output to improve performance (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7351\\\">#7351<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7817\\\">#7817<\\/a>, <a href=\\\"https:\\/\\/developers.elementor.com\\/dom-improvements-ahead-html-wrappers-removal-from-v3-0\\/\\\">Developers Blog Post<\\/a>)<\\/li>\\n<li>Tweak: Added contextual anchors ID support to Table of Contents widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10052\\\">#10052<\\/a>)<\\/li>\\n<li>Tweak: Added WeChat and Weibo social networks to Share Buttons widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11554\\\">#11554<\\/a>)<\\/li>\\n<li>Tweak: Added Dynamic capabilities for Redirect after Login\\/Logout in Login widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11343\\\">#11343<\\/a>)<\\/li>\\n<li>Tweak: Added Blend Mode and CSS Filters controls to adjust the Background Overlay in Flipbox widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11653\\\">#11653<\\/a>)<\\/li>\\n<li>Tweak: Added responsive capabilities to Toggle Button styling in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8269\\\">#8269<\\/a>)<\\/li>\\n<li>Tweak: Added responsive Text Alignment control in Call to Action widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11968\\\">#11968<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic content to Ribbon element in Call to Action widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10364\\\">#10364<\\/a>)<\\/li>\\n<li>Tweak: Converted uses of Color and Typography Schemes to Global Colors and Fonts<\\/li>\\n<li>Tweak: Separated Title and Description control fields labels in Call to Action widget<\\/li>\\n<li>Tweak: Removed unnecessary style in WC Product with variations<\\/li>\\n<li>Tweak: Converted Portfolio, Posts and Share Buttons widgets to use CSS Variable-based Elementor Grid (<a href=\\\"https:\\/\\/developers.elementor.com\\/elementor-dropping-support-ie\\/\\\">Developers Blog Post<\\/a>)<\\/li>\\n<li>Tweak: Added Date Modified option to Posts widget metadata<\\/li>\\n<li>Fix: PHP 7.4 compatibility to Media Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11355\\\">#11355<\\/a>)<\\/li>\\n<li>Fix: Divider alignment issue in Post Info widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11628\\\">#11628<\\/a>)<\\/li>\\n<li>Fix: Color doesn\\u2019t change in Products Archive Description widget<\\/li>\\n<li>Fix: WC Product variations layout breaks when using Variation Swatches plugin<\\/li>\\n<li>Fix: WC Product variations layout issue<\\/li>\\n<li>Fix: WC Product variations mobile zoom-in glitch<\\/li>\\n<li>Fix: Can\'t edit a Popup after accessing Theme Style<\\/li>\\n<li>Fix: Twitter icon missing in Blockquote widget<\\/li>\\n<li>Fix: Removed redundant default text color from Share Buttons minimal skin<\\/li>\\n<li>Fix: UI glitch in Display Conditions modal<\\/li>\\n<li>Fix: Insert template button UI glitch in Templates Library<\\/li>\\n<li>Fix: Added sanitization to post titles in WordPress dashboard for better security<\\/li>\\n<li>Fix: Show when arriving from search engines rule doesn\'t work in Popup<\\/li>\\n<li>Fix: Child categories are shown with a different parent category in Query control<\\/li>\\n<li>Deprecated: See all deprecations to this version in our <a href=\\\"https:\\/\\/developers.elementor.com\\/v3-0-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a><\\/li>\\n<\\/ul>\\\";}\",\"new_version\":\"3.5.2\",\"name\":\"Elementor Pro\",\"slug\":\"elementor-pro\",\"url\":\"https:\\/\\/elementor.com\\/pro\\/changelog\\/\",\"homepage\":\"https:\\/\\/elementor.com\\/pro\\/\",\"requires\":\"5.0\",\"tested\":\"5.9\",\"elementor_requires\":\"3.0.1\",\"package\":\"https:\\/\\/plugin-downloads.elementor.com\\/v1\\/plugin\\/package_download\\/MTY0MzY0NDQwOTp2YWxpZDoxOjFiMTcxNmYyYzM3NDljNjVlZmM1OGFiZmUzMDA4NTU2Omh0dHBALy9sb2NhbGhvc3Q6MA==\",\"download_link\":\"https:\\/\\/plugin-downloads.elementor.com\\/v1\\/plugin\\/package_download\\/MTY0MzY0NDQwOTp2YWxpZDoxOjFiMTcxNmYyYzM3NDljNjVlZmM1OGFiZmUzMDA4NTU2Omh0dHBALy9sb2NhbGhvc3Q6MA==\",\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/elementor\\/assets\\/banner-1544x500.png?rev=1475479\",\"1x\":\"https:\\/\\/ps.w.org\\/elementor\\/assets\\/banner-772x250.png?rev=1475479\"},\"icons\":{\"svg\":\"https:\\/\\/storage.googleapis.com\\/web-public-files\\/Web%20Assets\\/icons\\/icon.svg\"},\"canary_deployment\":{\"plugin_info\":{\"new_version\":\"3.5.0\",\"name\":\"Elementor Pro\",\"slug\":\"elementor-pro\",\"url\":\"https:\\/\\/elementor.com\\/pro\\/changelog\\/\",\"homepage\":\"https:\\/\\/elementor.com\\/pro\\/\",\"requires\":\"5.0\",\"tested\":\"5.9\",\"elementor_requires\":\"3.0.1\",\"package\":\"https:\\/\\/plugin-downloads.elementor.com\\/v1\\/plugin\\/previous_download\\/MTY0MzY0NDQwOTp2YWxpZDoxOjMuNS4wOjIyZTY2OWQwMDVhZGQ1YmNkYjdiMzFjOTZjMWNjMzJkOmh0dHBALy9sb2NhbGhvc3Q=\",\"download_link\":\"https:\\/\\/plugin-downloads.elementor.com\\/v1\\/plugin\\/previous_download\\/MTY0MzY0NDQwOTp2YWxpZDoxOjMuNS4wOjIyZTY2OWQwMDVhZGQ1YmNkYjdiMzFjOTZjMWNjMzJkOmh0dHBALy9sb2NhbGhvc3Q=\",\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/elementor\\/assets\\/banner-1544x500.png?rev=1475479\",\"1x\":\"https:\\/\\/ps.w.org\\/elementor\\/assets\\/banner-772x250.png?rev=1475479\"},\"icons\":{\"svg\":\"https:\\/\\/storage.googleapis.com\\/web-public-files\\/Web%20Assets\\/icons\\/icon.svg\"}},\"conditions\":[[{\"type\":\"language\",\"languages\":[\"he_IL\",\"nl_NL\",\"en_GB\",\"en_NZ\",\"en_ZA\",\"en_AU\",\"en_CA\",\"sv_SE\",\"da_DK\",\"fr_FR\",\"nl_NL\",\"nb_NO\",\"de_AT\",\"fi\",\"it_IT\",\"nn_NO\",\"de_CH\",\"en_GB\",\"is_IS\",\"ga\",\"fr_BE\",\"nl_BE\",\"ast\",\"lb_LU\",\"es_ES\",\"pt_PT\",\"mlt\"],\"operator\":\"in\"}]]}}\";}", "no");
INSERT INTO `wp_options` VALUES("5434", "elementor_pro_tracker_notice", "1", "yes");
INSERT INTO `wp_options` VALUES("5435", "elementor_allow_tracking", "no", "yes");
INSERT INTO `wp_options` VALUES("5436", "elementor_tracker_notice", "1", "yes");
INSERT INTO `wp_options` VALUES("5526", "widget_csf_widget_filter", "a:2:{i:3;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("6355", "elementor_connect_site_key", "398089dab73688f8ed7458ad57d584fd", "yes");
INSERT INTO `wp_options` VALUES("6448", "yoast_migrations_free", "a:1:{s:7:\"version\";s:4:\"18.1\";}", "yes");
INSERT INTO `wp_options` VALUES("6451", "wpseo", "a:56:{s:8:\"tracking\";b:0;s:22:\"license_server_version\";b:0;s:15:\"ms_defaults_set\";b:0;s:40:\"ignore_search_engines_discouraged_notice\";b:0;s:19:\"indexing_first_time\";b:0;s:16:\"indexing_started\";b:0;s:15:\"indexing_reason\";s:0:\"\";s:29:\"indexables_indexing_completed\";b:1;s:7:\"version\";s:4:\"18.1\";s:16:\"previous_version\";s:4:\"18.0\";s:20:\"disableadvanced_meta\";b:1;s:30:\"enable_headless_rest_endpoints\";b:1;s:17:\"ryte_indexability\";b:1;s:11:\"baiduverify\";s:0:\"\";s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";s:9:\"site_type\";s:0:\"\";s:20:\"has_multiple_authors\";s:0:\"\";s:16:\"environment_type\";s:0:\"\";s:23:\"content_analysis_active\";b:1;s:23:\"keyword_analysis_active\";b:1;s:21:\"enable_admin_bar_menu\";b:1;s:26:\"enable_cornerstone_content\";b:1;s:18:\"enable_xml_sitemap\";b:1;s:24:\"enable_text_link_counter\";b:1;s:22:\"show_onboarding_notice\";b:1;s:18:\"first_activated_on\";i:1643914465;s:13:\"myyoast-oauth\";b:0;s:26:\"semrush_integration_active\";b:1;s:14:\"semrush_tokens\";a:0:{}s:20:\"semrush_country_code\";s:2:\"us\";s:19:\"permalink_structure\";s:21:\"/%post_id%/%postname%\";s:8:\"home_url\";s:29:\"https://kelaketfilm.dev.local\";s:18:\"dynamic_permalinks\";b:0;s:17:\"category_base_url\";s:0:\"\";s:12:\"tag_base_url\";s:0:\"\";s:21:\"custom_taxonomy_slugs\";a:12:{s:11:\"wp_log_type\";s:11:\"wp_log_type\";s:5:\"actor\";s:5:\"actor\";s:8:\"director\";s:8:\"director\";s:5:\"genre\";s:5:\"genre\";s:12:\"type_of_post\";s:12:\"type_of_post\";s:5:\"yearr\";s:4:\"year\";s:7:\"country\";s:7:\"country\";s:4:\"rate\";s:4:\"rate\";s:5:\"score\";s:5:\"score\";s:13:\"blog_category\";s:13:\"blog_category\";s:20:\"flamingo_contact_tag\";s:20:\"flamingo_contact_tag\";s:24:\"flamingo_inbound_channel\";s:24:\"flamingo_inbound_channel\";}s:29:\"enable_enhanced_slack_sharing\";b:1;s:25:\"zapier_integration_active\";b:0;s:19:\"zapier_subscription\";a:0:{}s:14:\"zapier_api_key\";s:0:\"\";s:23:\"enable_metabox_insights\";b:1;s:23:\"enable_link_suggestions\";b:1;s:26:\"algolia_integration_active\";b:0;s:14:\"import_cursors\";a:0:{}s:13:\"workouts_data\";a:1:{s:13:\"configuration\";a:1:{s:13:\"finishedSteps\";a:0:{}}}s:36:\"dismiss_configuration_workout_notice\";b:1;s:19:\"importing_completed\";a:0:{}s:26:\"wincher_integration_active\";b:1;s:14:\"wincher_tokens\";a:0:{}s:36:\"wincher_automatically_add_keyphrases\";b:0;s:18:\"wincher_website_id\";s:0:\"\";s:18:\"first_time_install\";b:1;s:34:\"should_redirect_after_install_free\";b:1;s:34:\"activation_redirect_timestamp_free\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("6452", "wpseo_titles", "a:238:{s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-dash\";s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:51:\"%%name%%, نویسنده در %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:84:\"شما برای %%searchphrase%% جستجو کردید %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:45:\"صفحه پیدا نشد %%sep%% %%sitename%%\";s:25:\"social-title-author-wpseo\";s:8:\"%%name%%\";s:26:\"social-title-archive-wpseo\";s:8:\"%%date%%\";s:31:\"social-description-author-wpseo\";s:0:\"\";s:32:\"social-description-archive-wpseo\";s:0:\"\";s:29:\"social-image-url-author-wpseo\";s:0:\"\";s:30:\"social-image-url-archive-wpseo\";s:0:\"\";s:28:\"social-image-id-author-wpseo\";i:0;s:29:\"social-image-id-archive-wpseo\";i:0;s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:79:\"نوشته %%POSTLINK%% اولین بار در %%BLOGLINK%%. پدیدار شد.\";s:20:\"noindex-author-wpseo\";b:0;s:28:\"noindex-author-noposts-wpseo\";b:1;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:19:\"disable-post_format\";b:0;s:18:\"disable-attachment\";b:1;s:20:\"breadcrumbs-404crumb\";s:38:\"خطای 404: صفحه پیدا نشد\";s:29:\"breadcrumbs-display-blog-page\";b:0;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:30:\"بایگانی‌ها برای\";s:18:\"breadcrumbs-enable\";b:1;s:16:\"breadcrumbs-home\";s:8:\"خانه\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:39:\"شما جستجو نمودید برای\";s:15:\"breadcrumbs-sep\";s:2:\"»\";s:12:\"website_name\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:11:\"person_logo\";s:0:\"\";s:22:\"alternate_website_name\";s:0:\"\";s:12:\"company_logo\";s:0:\"\";s:12:\"company_name\";s:0:\"\";s:17:\"company_or_person\";s:7:\"company\";s:25:\"company_or_person_user_id\";b:0;s:17:\"stripcategorybase\";b:0;s:26:\"open_graph_frontpage_title\";s:12:\"%%sitename%%\";s:25:\"open_graph_frontpage_desc\";s:0:\"\";s:26:\"open_graph_frontpage_image\";s:0:\"\";s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:23:\"display-metabox-pt-post\";b:1;s:23:\"post_types-post-maintax\";i:0;s:21:\"schema-page-type-post\";s:7:\"WebPage\";s:24:\"schema-article-type-post\";s:7:\"Article\";s:17:\"social-title-post\";s:9:\"%%title%%\";s:23:\"social-description-post\";s:0:\"\";s:21:\"social-image-url-post\";s:0:\"\";s:20:\"social-image-id-post\";i:0;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:23:\"display-metabox-pt-page\";b:1;s:23:\"post_types-page-maintax\";s:1:\"0\";s:21:\"schema-page-type-page\";s:7:\"WebPage\";s:24:\"schema-article-type-page\";s:4:\"None\";s:17:\"social-title-page\";s:9:\"%%title%%\";s:23:\"social-description-page\";s:0:\"\";s:21:\"social-image-url-page\";s:0:\"\";s:20:\"social-image-id-page\";i:0;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:29:\"display-metabox-pt-attachment\";b:1;s:29:\"post_types-attachment-maintax\";s:1:\"0\";s:27:\"schema-page-type-attachment\";s:7:\"WebPage\";s:30:\"schema-article-type-attachment\";s:4:\"None\";s:18:\"title-tax-category\";s:68:\"بایگانی‌های %%term_title%% %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:28:\"display-metabox-tax-category\";b:1;s:20:\"noindex-tax-category\";b:0;s:25:\"social-title-tax-category\";s:38:\"بایگانی‌های %%term_title%%\";s:31:\"social-description-tax-category\";s:0:\"\";s:29:\"social-image-url-tax-category\";s:0:\"\";s:28:\"social-image-id-tax-category\";i:0;s:18:\"title-tax-post_tag\";s:68:\"بایگانی‌های %%term_title%% %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:28:\"display-metabox-tax-post_tag\";b:1;s:20:\"noindex-tax-post_tag\";b:0;s:25:\"social-title-tax-post_tag\";s:38:\"بایگانی‌های %%term_title%%\";s:31:\"social-description-tax-post_tag\";s:0:\"\";s:29:\"social-image-url-tax-post_tag\";s:0:\"\";s:28:\"social-image-id-tax-post_tag\";i:0;s:21:\"title-tax-post_format\";s:68:\"بایگانی‌های %%term_title%% %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:31:\"display-metabox-tax-post_format\";b:0;s:23:\"noindex-tax-post_format\";b:1;s:28:\"social-title-tax-post_format\";s:38:\"بایگانی‌های %%term_title%%\";s:34:\"social-description-tax-post_format\";s:0:\"\";s:32:\"social-image-url-tax-post_format\";s:0:\"\";s:31:\"social-image-id-tax-post_format\";i:0;s:20:\"title-e-landing-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:23:\"metadesc-e-landing-page\";s:0:\"\";s:22:\"noindex-e-landing-page\";b:0;s:33:\"display-metabox-pt-e-landing-page\";b:1;s:33:\"post_types-e-landing-page-maintax\";i:0;s:31:\"schema-page-type-e-landing-page\";s:7:\"WebPage\";s:34:\"schema-article-type-e-landing-page\";s:4:\"None\";s:27:\"social-title-e-landing-page\";s:9:\"%%title%%\";s:33:\"social-description-e-landing-page\";s:0:\"\";s:31:\"social-image-url-e-landing-page\";s:0:\"\";s:30:\"social-image-id-e-landing-page\";i:0;s:23:\"title-elementor_library\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:26:\"metadesc-elementor_library\";s:0:\"\";s:25:\"noindex-elementor_library\";b:0;s:36:\"display-metabox-pt-elementor_library\";b:1;s:36:\"post_types-elementor_library-maintax\";i:0;s:34:\"schema-page-type-elementor_library\";s:7:\"WebPage\";s:37:\"schema-article-type-elementor_library\";s:4:\"None\";s:30:\"social-title-elementor_library\";s:9:\"%%title%%\";s:36:\"social-description-elementor_library\";s:0:\"\";s:34:\"social-image-url-elementor_library\";s:0:\"\";s:33:\"social-image-id-elementor_library\";i:0;s:10:\"title-blog\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-blog\";s:0:\"\";s:12:\"noindex-blog\";b:0;s:23:\"display-metabox-pt-blog\";b:1;s:23:\"post_types-blog-maintax\";i:0;s:21:\"schema-page-type-blog\";s:7:\"WebPage\";s:24:\"schema-article-type-blog\";s:4:\"None\";s:17:\"social-title-blog\";s:9:\"%%title%%\";s:23:\"social-description-blog\";s:0:\"\";s:21:\"social-image-url-blog\";s:0:\"\";s:20:\"social-image-id-blog\";i:0;s:20:\"title-ptarchive-blog\";s:58:\"بایگانی %%pt_plural%% %%page%% %%sep%% %%sitename%%\";s:23:\"metadesc-ptarchive-blog\";s:0:\"\";s:22:\"bctitle-ptarchive-blog\";s:0:\"\";s:22:\"noindex-ptarchive-blog\";b:0;s:27:\"social-title-ptarchive-blog\";s:28:\"بایگانی %%pt_plural%%\";s:33:\"social-description-ptarchive-blog\";s:0:\"\";s:31:\"social-image-url-ptarchive-blog\";s:0:\"\";s:30:\"social-image-id-ptarchive-blog\";i:0;s:21:\"title-tax-wp_log_type\";s:68:\"بایگانی‌های %%term_title%% %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-wp_log_type\";s:0:\"\";s:31:\"display-metabox-tax-wp_log_type\";b:1;s:23:\"noindex-tax-wp_log_type\";b:0;s:28:\"social-title-tax-wp_log_type\";s:38:\"بایگانی‌های %%term_title%%\";s:34:\"social-description-tax-wp_log_type\";s:0:\"\";s:32:\"social-image-url-tax-wp_log_type\";s:0:\"\";s:31:\"social-image-id-tax-wp_log_type\";i:0;s:29:\"taxonomy-wp_log_type-ptparent\";i:0;s:15:\"title-tax-actor\";s:68:\"بایگانی‌های %%term_title%% %%page%% %%sep%% %%sitename%%\";s:18:\"metadesc-tax-actor\";s:0:\"\";s:25:\"display-metabox-tax-actor\";b:1;s:17:\"noindex-tax-actor\";b:0;s:22:\"social-title-tax-actor\";s:38:\"بایگانی‌های %%term_title%%\";s:28:\"social-description-tax-actor\";s:0:\"\";s:26:\"social-image-url-tax-actor\";s:0:\"\";s:25:\"social-image-id-tax-actor\";i:0;s:23:\"taxonomy-actor-ptparent\";i:0;s:18:\"title-tax-director\";s:68:\"بایگانی‌های %%term_title%% %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-director\";s:0:\"\";s:28:\"display-metabox-tax-director\";b:1;s:20:\"noindex-tax-director\";b:0;s:25:\"social-title-tax-director\";s:38:\"بایگانی‌های %%term_title%%\";s:31:\"social-description-tax-director\";s:0:\"\";s:29:\"social-image-url-tax-director\";s:0:\"\";s:28:\"social-image-id-tax-director\";i:0;s:26:\"taxonomy-director-ptparent\";i:0;s:15:\"title-tax-genre\";s:68:\"بایگانی‌های %%term_title%% %%page%% %%sep%% %%sitename%%\";s:18:\"metadesc-tax-genre\";s:0:\"\";s:25:\"display-metabox-tax-genre\";b:1;s:17:\"noindex-tax-genre\";b:0;s:22:\"social-title-tax-genre\";s:38:\"بایگانی‌های %%term_title%%\";s:28:\"social-description-tax-genre\";s:0:\"\";s:26:\"social-image-url-tax-genre\";s:0:\"\";s:25:\"social-image-id-tax-genre\";i:0;s:23:\"taxonomy-genre-ptparent\";i:0;s:22:\"title-tax-type_of_post\";s:68:\"بایگانی‌های %%term_title%% %%page%% %%sep%% %%sitename%%\";s:25:\"metadesc-tax-type_of_post\";s:0:\"\";s:32:\"display-metabox-tax-type_of_post\";b:1;s:24:\"noindex-tax-type_of_post\";b:0;s:29:\"social-title-tax-type_of_post\";s:38:\"بایگانی‌های %%term_title%%\";s:35:\"social-description-tax-type_of_post\";s:0:\"\";s:33:\"social-image-url-tax-type_of_post\";s:0:\"\";s:32:\"social-image-id-tax-type_of_post\";i:0;s:30:\"taxonomy-type_of_post-ptparent\";i:0;s:15:\"title-tax-yearr\";s:68:\"بایگانی‌های %%term_title%% %%page%% %%sep%% %%sitename%%\";s:18:\"metadesc-tax-yearr\";s:0:\"\";s:25:\"display-metabox-tax-yearr\";b:1;s:17:\"noindex-tax-yearr\";b:0;s:22:\"social-title-tax-yearr\";s:38:\"بایگانی‌های %%term_title%%\";s:28:\"social-description-tax-yearr\";s:0:\"\";s:26:\"social-image-url-tax-yearr\";s:0:\"\";s:25:\"social-image-id-tax-yearr\";i:0;s:23:\"taxonomy-yearr-ptparent\";i:0;s:17:\"title-tax-country\";s:68:\"بایگانی‌های %%term_title%% %%page%% %%sep%% %%sitename%%\";s:20:\"metadesc-tax-country\";s:0:\"\";s:27:\"display-metabox-tax-country\";b:1;s:19:\"noindex-tax-country\";b:0;s:24:\"social-title-tax-country\";s:38:\"بایگانی‌های %%term_title%%\";s:30:\"social-description-tax-country\";s:0:\"\";s:28:\"social-image-url-tax-country\";s:0:\"\";s:27:\"social-image-id-tax-country\";i:0;s:25:\"taxonomy-country-ptparent\";i:0;s:14:\"title-tax-rate\";s:68:\"بایگانی‌های %%term_title%% %%page%% %%sep%% %%sitename%%\";s:17:\"metadesc-tax-rate\";s:0:\"\";s:24:\"display-metabox-tax-rate\";b:1;s:16:\"noindex-tax-rate\";b:0;s:21:\"social-title-tax-rate\";s:38:\"بایگانی‌های %%term_title%%\";s:27:\"social-description-tax-rate\";s:0:\"\";s:25:\"social-image-url-tax-rate\";s:0:\"\";s:24:\"social-image-id-tax-rate\";i:0;s:22:\"taxonomy-rate-ptparent\";i:0;s:15:\"title-tax-score\";s:68:\"بایگانی‌های %%term_title%% %%page%% %%sep%% %%sitename%%\";s:18:\"metadesc-tax-score\";s:0:\"\";s:25:\"display-metabox-tax-score\";b:1;s:17:\"noindex-tax-score\";b:0;s:22:\"social-title-tax-score\";s:38:\"بایگانی‌های %%term_title%%\";s:28:\"social-description-tax-score\";s:0:\"\";s:26:\"social-image-url-tax-score\";s:0:\"\";s:25:\"social-image-id-tax-score\";i:0;s:23:\"taxonomy-score-ptparent\";i:0;s:23:\"title-tax-blog_category\";s:68:\"بایگانی‌های %%term_title%% %%page%% %%sep%% %%sitename%%\";s:26:\"metadesc-tax-blog_category\";s:0:\"\";s:33:\"display-metabox-tax-blog_category\";b:1;s:25:\"noindex-tax-blog_category\";b:0;s:30:\"social-title-tax-blog_category\";s:38:\"بایگانی‌های %%term_title%%\";s:36:\"social-description-tax-blog_category\";s:0:\"\";s:34:\"social-image-url-tax-blog_category\";s:0:\"\";s:33:\"social-image-id-tax-blog_category\";i:0;s:31:\"taxonomy-blog_category-ptparent\";i:0;s:14:\"person_logo_id\";i:0;s:15:\"company_logo_id\";i:0;s:29:\"open_graph_frontpage_image_id\";i:0;s:26:\"taxonomy-category-ptparent\";s:1:\"0\";s:26:\"taxonomy-post_tag-ptparent\";s:1:\"0\";s:29:\"taxonomy-post_format-ptparent\";s:1:\"0\";}", "yes");
INSERT INTO `wp_options` VALUES("6453", "wpseo_social", "a:18:{s:13:\"facebook_site\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:19:\"og_default_image_id\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:21:\"og_frontpage_image_id\";s:0:\"\";s:9:\"opengraph\";b:1;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:7:\"twitter\";b:1;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:19:\"summary_large_image\";s:11:\"youtube_url\";s:0:\"\";s:13:\"wikipedia_url\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("6470", "wpseo_ryte", "a:2:{s:6:\"status\";i:-1;s:10:\"last_fetch\";i:1651780798;}", "yes");
INSERT INTO `wp_options` VALUES("6480", "rocket_cache_dir_size_check", "1", "yes");
INSERT INTO `wp_options` VALUES("6949", "wp_calendar_block_has_published_posts", "1", "yes");
INSERT INTO `wp_options` VALUES("7678", "widget_csf_widget_countdown", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("8063", "wpseo_taxonomy_meta", "a:1:{s:8:\"category\";a:1:{i:8;a:3:{s:13:\"wpseo_focuskw\";s:10:\"سریال\";s:13:\"wpseo_linkdex\";s:2:\"26\";s:19:\"wpseo_content_score\";s:2:\"60\";}}}", "yes");
INSERT INTO `wp_options` VALUES("8173", "flamingo_inbound_channel_children", "a:1:{i:249;a:1:{i:0;i:250;}}", "yes");
INSERT INTO `wp_options` VALUES("8247", "elementor_pro_remote_info_api_data_3.3.7", "a:2:{s:7:\"timeout\";i:1650191169;s:5:\"value\";s:42:\"{\"license\":\"valid\",\"expires\":\"01.01.2030\"}\";}", "yes");
INSERT INTO `wp_options` VALUES("9622", "rewrite_rules", "a:188:{s:27:\"(lists)/(\\d*)/(page)/(\\d*)$\";s:64:\"index.php?pagename=$matches[1]&id=$matches[2]&paged=$mateched[3]\";s:14:\"(lists)/(\\d*)$\";s:45:\"index.php?pagename=$matches[1]&id=$matches[2]\";s:7:\"blog/?$\";s:24:\"index.php?post_type=blog\";s:37:\"blog/feed/(feed|rdf|rss|rss2|atom)/?$\";s:41:\"index.php?post_type=blog&feed=$matches[1]\";s:32:\"blog/(feed|rdf|rss|rss2|atom)/?$\";s:41:\"index.php?post_type=blog&feed=$matches[1]\";s:24:\"blog/page/([0-9]{1,})/?$\";s:42:\"index.php?post_type=blog&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:19:\"(profile)/([^/]*)/?\";s:51:\"index.php?pagename=$matches[1]&username=$matches[2]\";s:52:\"wp_log_type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?wp_log_type=$matches[1]&feed=$matches[2]\";s:47:\"wp_log_type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?wp_log_type=$matches[1]&feed=$matches[2]\";s:28:\"wp_log_type/([^/]+)/embed/?$\";s:44:\"index.php?wp_log_type=$matches[1]&embed=true\";s:40:\"wp_log_type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?wp_log_type=$matches[1]&paged=$matches[2]\";s:22:\"wp_log_type/([^/]+)/?$\";s:33:\"index.php?wp_log_type=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:46:\"actor/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?actor=$matches[1]&feed=$matches[2]\";s:41:\"actor/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?actor=$matches[1]&feed=$matches[2]\";s:22:\"actor/([^/]+)/embed/?$\";s:38:\"index.php?actor=$matches[1]&embed=true\";s:34:\"actor/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?actor=$matches[1]&paged=$matches[2]\";s:16:\"actor/([^/]+)/?$\";s:27:\"index.php?actor=$matches[1]\";s:49:\"director/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?director=$matches[1]&feed=$matches[2]\";s:44:\"director/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?director=$matches[1]&feed=$matches[2]\";s:25:\"director/([^/]+)/embed/?$\";s:41:\"index.php?director=$matches[1]&embed=true\";s:37:\"director/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?director=$matches[1]&paged=$matches[2]\";s:19:\"director/([^/]+)/?$\";s:30:\"index.php?director=$matches[1]\";s:46:\"genre/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?genre=$matches[1]&feed=$matches[2]\";s:41:\"genre/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?genre=$matches[1]&feed=$matches[2]\";s:22:\"genre/([^/]+)/embed/?$\";s:38:\"index.php?genre=$matches[1]&embed=true\";s:34:\"genre/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?genre=$matches[1]&paged=$matches[2]\";s:16:\"genre/([^/]+)/?$\";s:27:\"index.php?genre=$matches[1]\";s:53:\"type_of_post/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?type_of_post=$matches[1]&feed=$matches[2]\";s:48:\"type_of_post/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?type_of_post=$matches[1]&feed=$matches[2]\";s:29:\"type_of_post/([^/]+)/embed/?$\";s:45:\"index.php?type_of_post=$matches[1]&embed=true\";s:41:\"type_of_post/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?type_of_post=$matches[1]&paged=$matches[2]\";s:23:\"type_of_post/([^/]+)/?$\";s:34:\"index.php?type_of_post=$matches[1]\";s:45:\"year/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?yearr=$matches[1]&feed=$matches[2]\";s:40:\"year/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?yearr=$matches[1]&feed=$matches[2]\";s:21:\"year/([^/]+)/embed/?$\";s:38:\"index.php?yearr=$matches[1]&embed=true\";s:33:\"year/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?yearr=$matches[1]&paged=$matches[2]\";s:15:\"year/([^/]+)/?$\";s:27:\"index.php?yearr=$matches[1]\";s:48:\"country/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?country=$matches[1]&feed=$matches[2]\";s:43:\"country/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?country=$matches[1]&feed=$matches[2]\";s:24:\"country/([^/]+)/embed/?$\";s:40:\"index.php?country=$matches[1]&embed=true\";s:36:\"country/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?country=$matches[1]&paged=$matches[2]\";s:18:\"country/([^/]+)/?$\";s:29:\"index.php?country=$matches[1]\";s:45:\"rate/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?rate=$matches[1]&feed=$matches[2]\";s:40:\"rate/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?rate=$matches[1]&feed=$matches[2]\";s:21:\"rate/([^/]+)/embed/?$\";s:37:\"index.php?rate=$matches[1]&embed=true\";s:33:\"rate/([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?rate=$matches[1]&paged=$matches[2]\";s:15:\"rate/([^/]+)/?$\";s:26:\"index.php?rate=$matches[1]\";s:46:\"score/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?score=$matches[1]&feed=$matches[2]\";s:41:\"score/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?score=$matches[1]&feed=$matches[2]\";s:22:\"score/([^/]+)/embed/?$\";s:38:\"index.php?score=$matches[1]&embed=true\";s:34:\"score/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?score=$matches[1]&paged=$matches[2]\";s:16:\"score/([^/]+)/?$\";s:27:\"index.php?score=$matches[1]\";s:54:\"blog_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?blog_category=$matches[1]&feed=$matches[2]\";s:49:\"blog_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?blog_category=$matches[1]&feed=$matches[2]\";s:30:\"blog_category/([^/]+)/embed/?$\";s:46:\"index.php?blog_category=$matches[1]&embed=true\";s:42:\"blog_category/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?blog_category=$matches[1]&paged=$matches[2]\";s:24:\"blog_category/([^/]+)/?$\";s:35:\"index.php?blog_category=$matches[1]\";s:32:\"blog/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"blog/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"blog/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"blog/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"blog/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"blog/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:21:\"blog/([^/]+)/embed/?$\";s:37:\"index.php?blog=$matches[1]&embed=true\";s:25:\"blog/([^/]+)/trackback/?$\";s:31:\"index.php?blog=$matches[1]&tb=1\";s:45:\"blog/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?blog=$matches[1]&feed=$matches[2]\";s:40:\"blog/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?blog=$matches[1]&feed=$matches[2]\";s:33:\"blog/([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?blog=$matches[1]&paged=$matches[2]\";s:40:\"blog/([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?blog=$matches[1]&cpage=$matches[2]\";s:29:\"blog/([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?blog=$matches[1]&page=$matches[2]\";s:21:\"blog/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:31:\"blog/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:51:\"blog/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"blog/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"blog/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:27:\"blog/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:74:\"date/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:69:\"date/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:50:\"date/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:62:\"date/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:44:\"date/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:61:\"date/([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:56:\"date/([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:37:\"date/([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:49:\"date/([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:31:\"date/([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:48:\"date/([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:43:\"date/([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:24:\"date/([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:36:\"date/([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:18:\"date/([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:34:\"[0-9]+/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"[0-9]+/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"[0-9]+/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"[0-9]+/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"[0-9]+/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"[0-9]+/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:25:\"([0-9]+)/([^/]+)/embed/?$\";s:51:\"index.php?p=$matches[1]&name=$matches[2]&embed=true\";s:29:\"([0-9]+)/([^/]+)/trackback/?$\";s:45:\"index.php?p=$matches[1]&name=$matches[2]&tb=1\";s:49:\"([0-9]+)/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?p=$matches[1]&name=$matches[2]&feed=$matches[3]\";s:44:\"([0-9]+)/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?p=$matches[1]&name=$matches[2]&feed=$matches[3]\";s:37:\"([0-9]+)/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?p=$matches[1]&name=$matches[2]&paged=$matches[3]\";s:44:\"([0-9]+)/([^/]+)/comment-page-([0-9]{1,})/?$\";s:58:\"index.php?p=$matches[1]&name=$matches[2]&cpage=$matches[3]\";s:33:\"([0-9]+)/([^/]+)(?:/([0-9]+))?/?$\";s:57:\"index.php?p=$matches[1]&name=$matches[2]&page=$matches[3]\";s:23:\"[0-9]+/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:33:\"[0-9]+/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:53:\"[0-9]+/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"[0-9]+/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"[0-9]+/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:29:\"[0-9]+/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"[0-9]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"[0-9]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"[0-9]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"[0-9]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"[0-9]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"[0-9]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:17:\"([0-9]+)/embed/?$\";s:34:\"index.php?p=$matches[1]&embed=true\";s:21:\"([0-9]+)/trackback/?$\";s:28:\"index.php?p=$matches[1]&tb=1\";s:41:\"([0-9]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?p=$matches[1]&feed=$matches[2]\";s:36:\"([0-9]+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?p=$matches[1]&feed=$matches[2]\";s:29:\"([0-9]+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?p=$matches[1]&paged=$matches[2]\";s:36:\"([0-9]+)/comment-page-([0-9]{1,})/?$\";s:41:\"index.php?p=$matches[1]&cpage=$matches[2]\";s:25:\"([0-9]+)(?:/([0-9]+))?/?$\";s:40:\"index.php?p=$matches[1]&page=$matches[2]\";s:17:\"[0-9]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:27:\"[0-9]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:47:\"[0-9]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:42:\"[0-9]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:42:\"[0-9]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:23:\"[0-9]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}", "yes");
INSERT INTO `wp_options` VALUES("10035", "relevanssi_admin_search", "off", "yes");
INSERT INTO `wp_options` VALUES("10036", "relevanssi_bg_col", "#ffaf75", "yes");
INSERT INTO `wp_options` VALUES("10037", "relevanssi_cat", "0", "yes");
INSERT INTO `wp_options` VALUES("10038", "relevanssi_class", "relevanssi-query-term", "yes");
INSERT INTO `wp_options` VALUES("10039", "relevanssi_comment_boost", "0.75", "yes");
INSERT INTO `wp_options` VALUES("10040", "relevanssi_content_boost", "1", "yes");
INSERT INTO `wp_options` VALUES("10041", "relevanssi_css", "text-decoration: underline; text-color: #ff0000", "yes");
INSERT INTO `wp_options` VALUES("10042", "relevanssi_db_version", "6", "yes");
INSERT INTO `wp_options` VALUES("10043", "relevanssi_default_orderby", "relevance", "yes");
INSERT INTO `wp_options` VALUES("10044", "relevanssi_disable_or_fallback", "off", "yes");
INSERT INTO `wp_options` VALUES("10045", "relevanssi_exact_match_bonus", "on", "yes");
INSERT INTO `wp_options` VALUES("10046", "relevanssi_excat", "0", "yes");
INSERT INTO `wp_options` VALUES("10047", "relevanssi_excerpt_allowable_tags", "", "yes");
INSERT INTO `wp_options` VALUES("10048", "relevanssi_excerpt_custom_fields", "off", "yes");
INSERT INTO `wp_options` VALUES("10049", "relevanssi_excerpt_length", "30", "yes");
INSERT INTO `wp_options` VALUES("10050", "relevanssi_excerpt_type", "words", "yes");
INSERT INTO `wp_options` VALUES("10051", "relevanssi_excerpts", "on", "yes");
INSERT INTO `wp_options` VALUES("10052", "relevanssi_exclude_posts", "", "yes");
INSERT INTO `wp_options` VALUES("10053", "relevanssi_expand_highlights", "off", "yes");
INSERT INTO `wp_options` VALUES("10054", "relevanssi_expand_shortcodes", "on", "yes");
INSERT INTO `wp_options` VALUES("10055", "relevanssi_extag", "0", "yes");
INSERT INTO `wp_options` VALUES("10056", "relevanssi_fuzzy", "always", "yes");
INSERT INTO `wp_options` VALUES("10057", "relevanssi_highlight", "strong", "yes");
INSERT INTO `wp_options` VALUES("10058", "relevanssi_highlight_comments", "off", "yes");
INSERT INTO `wp_options` VALUES("10059", "relevanssi_highlight_docs", "off", "yes");
INSERT INTO `wp_options` VALUES("10060", "relevanssi_hilite_title", "", "yes");
INSERT INTO `wp_options` VALUES("10061", "relevanssi_implicit_operator", "OR", "yes");
INSERT INTO `wp_options` VALUES("10062", "relevanssi_index_author", "off", "no");
INSERT INTO `wp_options` VALUES("10063", "relevanssi_index_comments", "none", "yes");
INSERT INTO `wp_options` VALUES("10064", "relevanssi_index_excerpt", "off", "yes");
INSERT INTO `wp_options` VALUES("10065", "relevanssi_index_fields", "", "yes");
INSERT INTO `wp_options` VALUES("10066", "relevanssi_index_image_files", "on", "yes");
INSERT INTO `wp_options` VALUES("10067", "relevanssi_index_post_types", "a:3:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:5:\"bogus\";}", "yes");
INSERT INTO `wp_options` VALUES("10068", "relevanssi_index_taxonomies_list", "a:8:{i:0;s:8:\"category\";i:1;s:5:\"actor\";i:2;s:8:\"director\";i:3;s:5:\"genre\";i:4;s:5:\"yearr\";i:5;s:7:\"country\";i:6;s:4:\"rate\";i:7;s:5:\"score\";}", "no");
INSERT INTO `wp_options` VALUES("10069", "relevanssi_indexed", "done", "yes");
INSERT INTO `wp_options` VALUES("10070", "relevanssi_log_queries", "on", "yes");
INSERT INTO `wp_options` VALUES("10071", "relevanssi_log_queries_with_ip", "off", "yes");
INSERT INTO `wp_options` VALUES("10072", "relevanssi_min_word_length", "3", "yes");
INSERT INTO `wp_options` VALUES("10073", "relevanssi_omit_from_logs", "", "yes");
INSERT INTO `wp_options` VALUES("10074", "relevanssi_polylang_all_languages", "off", "yes");
INSERT INTO `wp_options` VALUES("10075", "relevanssi_punctuation", "a:4:{s:6:\"quotes\";s:7:\"replace\";s:7:\"hyphens\";s:7:\"replace\";s:10:\"ampersands\";s:7:\"replace\";s:8:\"decimals\";s:6:\"remove\";}", "yes");
INSERT INTO `wp_options` VALUES("10076", "relevanssi_respect_exclude", "on", "yes");
INSERT INTO `wp_options` VALUES("10077", "relevanssi_seo_noindex", "on", "yes");
INSERT INTO `wp_options` VALUES("10078", "relevanssi_show_matches", "", "yes");
INSERT INTO `wp_options` VALUES("10079", "relevanssi_show_matches_text", "(Search hits: %body% in body, %title% in title, %categories% in categories, %tags% in tags, %taxonomies% in other taxonomies, %comments% in comments. Score: %score%)", "yes");
INSERT INTO `wp_options` VALUES("10080", "relevanssi_stopwords", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("10081", "relevanssi_synonyms", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("10082", "relevanssi_throttle", "on", "yes");
INSERT INTO `wp_options` VALUES("10083", "relevanssi_throttle_limit", "500", "yes");
INSERT INTO `wp_options` VALUES("10084", "relevanssi_title_boost", "5", "yes");
INSERT INTO `wp_options` VALUES("10085", "relevanssi_txt_col", "#ff0000", "yes");
INSERT INTO `wp_options` VALUES("10086", "relevanssi_wpml_only_current", "on", "yes");
INSERT INTO `wp_options` VALUES("10088", "relevanssi_doc_count", "41", "yes");
INSERT INTO `wp_options` VALUES("10089", "relevanssi_terms_count", "2016", "no");
INSERT INTO `wp_options` VALUES("10090", "relevanssi_trim_logs", "0", "yes");
INSERT INTO `wp_options` VALUES("10217", "duplicator_settings", "a:17:{s:7:\"version\";s:7:\"1.5.2.1\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:16:\"uninstall_tables\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";b:1;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"wpcont\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";i:2;s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:17;}", "yes");
INSERT INTO `wp_options` VALUES("10218", "duplicator_version_plugin", "1.5.2.1", "yes");
INSERT INTO `wp_options` VALUES("10221", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-03-15 11:56:23\";s:7:\"Version\";s:7:\"1.5.2.1\";s:9:\"VersionWP\";s:5:\"6.1.1\";s:9:\"VersionDB\";s:6:\"5.7.34\";s:10:\"VersionPHP\";s:6:\"7.4.21\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";N;s:4:\"Name\";s:39:\"20220508_daa9d984d8a7daa9d8aad981db8cd9\";s:4:\"Hash\";s:35:\"3566468850690bed6781_20230315115623\";s:8:\"NameHash\";s:75:\"20220508_daa9d984d8a7daa9d8aad981db8cd9_3566468850690bed6781_20230315115623\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:85:\"20220508_daa9d984d8a7daa9d8aad981db8cd9_3566468850690bed6781_20230315115623_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:35:\"/Users/imahmoodzz/Sites/Kelaketfilm\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:801;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:7985;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-03-15 11:56:23\";s:7:\"Version\";s:7:\"1.5.2.1\";s:9:\"VersionWP\";s:5:\"6.1.1\";s:9:\"VersionDB\";s:6:\"5.7.34\";s:10:\"VersionPHP\";s:6:\"7.4.21\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";N;s:4:\"Name\";s:39:\"20220508_daa9d984d8a7daa9d8aad981db8cd9\";s:4:\"Hash\";s:35:\"3566468850690bed6781_20230315115623\";s:8:\"NameHash\";s:75:\"20220508_daa9d984d8a7daa9d8aad981db8cd9_3566468850690bed6781_20230315115623\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:49:\"/Users/imahmoodzz/Sites/Kelaketfilm/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":14:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:18:\"varLowerCaseTables\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:65;s:24:\"\0DUP_Database\0tempDbPath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:44:\"/Users/imahmoodzz/Sites/Kelaketfilm/wp-admin\";i:1;s:47:\"/Users/imahmoodzz/Sites/Kelaketfilm/wp-includes\";i:2;s:56:\"/Users/imahmoodzz/Sites/Kelaketfilm/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:35:\"/Users/imahmoodzz/Sites/Kelaketfilm\";i:1;s:35:\"/Users/imahmoodzz/Sites/Kelaketfilm\";i:2;s:46:\"/Users/imahmoodzz/Sites/Kelaketfilm/wp-content\";i:3;s:54:\"/Users/imahmoodzz/Sites/Kelaketfilm/wp-content/uploads\";i:4;s:54:\"/Users/imahmoodzz/Sites/Kelaketfilm/wp-content/plugins\";i:5;s:57:\"/Users/imahmoodzz/Sites/Kelaketfilm/wp-content/mu-plugins\";i:6;s:53:\"/Users/imahmoodzz/Sites/Kelaketfilm/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:67:\"/Users/imahmoodzz/Sites/Kelaketfilm/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:143;}", "yes");
INSERT INTO `wp_options` VALUES("10222", "duplicator_ui_view_state", "a:5:{s:22:\"dup-pack-archive-panel\";s:1:\"1\";s:24:\"dup-pack-installer-panel\";s:1:\"1\";s:22:\"dup-pack-storage-panel\";s:1:\"0\";s:19:\"dup-pack-build-try3\";s:1:\"1\";s:19:\"dup-pack-build-try1\";s:1:\"1\";}", "yes");
INSERT INTO `wp_options` VALUES("10509", "theme_mods_KelaketFilm-child", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:3:{s:8:\"category\";i:46;s:11:\"foot-menu-1\";i:3;s:11:\"foot-menu-2\";i:4;}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1669737270;s:4:\"data\";a:5:{s:19:\"wp_inactive_widgets\";a:1:{i:0;s:23:\"csf_widget_box_office-2\";}s:9:\"sidebar-1\";a:11:{i:0;s:19:\"csf_widget_filter-3\";i:1;s:29:\"csf_widget_updated_series_2-2\";i:2;s:22:\"csf_widget_countdown-2\";i:3;s:27:\"csf_widget_updated_series-2\";i:4;s:25:\"csf_widget_tabbed_genre-2\";i:5;s:21:\"csf_widget_text_ads-2\";i:6;s:30:\"csf_widget_250top_films_imdb-2\";i:7;s:21:\"csf_widget_carousel-4\";i:8;s:28:\"csf_widget_box_office_auto-2\";i:9;s:26:\"csf_widget_latest_visits-2\";i:10;s:24:\"csf_widget_post_slider-2\";}s:9:\"sidebar-2\";a:0:{}s:6:\"single\";a:3:{i:0;s:21:\"csf_widget_carousel-5\";i:1;s:25:\"csf_widget_tabbed_genre-3\";i:2;s:26:\"csf_widget_latest_visits-3\";}s:13:\"footer_widget\";a:1:{i:0;s:31:\"csf_widget_250top_series_imdb-2\";}}}}", "yes");
INSERT INTO `wp_options` VALUES("10525", "theme_mods_KelaketFilm-Anime", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:3:{s:8:\"category\";i:46;s:11:\"foot-menu-1\";i:3;s:11:\"foot-menu-2\";i:4;}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1653318450;s:4:\"data\";a:5:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:9:{i:0;s:19:\"csf_widget_filter-3\";i:1;s:22:\"csf_widget_countdown-2\";i:2;s:27:\"csf_widget_updated_series-2\";i:3;s:25:\"csf_widget_tabbed_genre-2\";i:4;s:21:\"csf_widget_text_ads-2\";i:5;s:30:\"csf_widget_250top_films_imdb-2\";i:6;s:16:\"csf_widget_ads-2\";i:7;s:21:\"csf_widget_carousel-4\";i:8;s:23:\"csf_widget_box_office-2\";}s:9:\"sidebar-2\";a:0:{}s:6:\"single\";a:2:{i:0;s:21:\"csf_widget_carousel-5\";i:1;s:25:\"csf_widget_tabbed_genre-3\";}s:13:\"footer_widget\";a:1:{i:0;s:31:\"csf_widget_250top_series_imdb-2\";}}}}", "yes");
INSERT INTO `wp_options` VALUES("10587", "elementor_events_db_version", "1.0.0", "no");
INSERT INTO `wp_options` VALUES("10610", "_elementor_editor_upgrade_notice_dismissed", "1678880141", "yes");
INSERT INTO `wp_options` VALUES("10937", "widget_csf_widget_box_office_auto", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("10952", "widget_csf_widget_latest_visits", "a:3:{i:2;a:5:{s:5:\"title\";s:35:\"بازدید های اخیر شما\";s:4:\"icon\";s:0:\"\";s:5:\"count\";s:0:\"\";s:7:\"archive\";s:0:\"\";s:8:\"film_cat\";s:0:\"\";}i:3;a:5:{s:5:\"title\";s:28:\"بازدید های اخیر\";s:4:\"icon\";s:0:\"\";s:5:\"count\";s:0:\"\";s:7:\"archive\";s:0:\"\";s:8:\"film_cat\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("10965", "user_count", "2", "no");
INSERT INTO `wp_options` VALUES("11793", "theme_mods_KelaketFilm2", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:3:{s:8:\"category\";i:46;s:11:\"foot-menu-1\";i:3;s:11:\"foot-menu-2\";i:4;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1656687845;s:4:\"data\";a:5:{s:19:\"wp_inactive_widgets\";a:1:{i:0;s:23:\"csf_widget_box_office-2\";}s:9:\"sidebar-1\";a:10:{i:0;s:19:\"csf_widget_filter-3\";i:1;s:22:\"csf_widget_countdown-2\";i:2;s:27:\"csf_widget_updated_series-2\";i:3;s:25:\"csf_widget_tabbed_genre-2\";i:4;s:21:\"csf_widget_text_ads-2\";i:5;s:30:\"csf_widget_250top_films_imdb-2\";i:6;s:16:\"csf_widget_ads-2\";i:7;s:21:\"csf_widget_carousel-4\";i:8;s:28:\"csf_widget_box_office_auto-2\";i:9;s:26:\"csf_widget_latest_visits-2\";}s:9:\"sidebar-2\";a:0:{}s:6:\"single\";a:3:{i:0;s:21:\"csf_widget_carousel-5\";i:1;s:25:\"csf_widget_tabbed_genre-3\";i:2;s:26:\"csf_widget_latest_visits-3\";}s:13:\"footer_widget\";a:1:{i:0;s:31:\"csf_widget_250top_series_imdb-2\";}}}}", "yes");
INSERT INTO `wp_options` VALUES("12334", "duplicator_exe_safe_mode", "", "yes");
INSERT INTO `wp_options` VALUES("12353", "_transient_health-check-site-status-result", "{\"good\":13,\"recommended\":5,\"critical\":3}", "yes");
INSERT INTO `wp_options` VALUES("12410", "can_compress_scripts", "1", "no");
INSERT INTO `wp_options` VALUES("12493", "widget_csf_widget_taghvim", "a:2:{i:2;a:3:{s:5:\"title\";s:25:\"تولد گویندگان\";s:10:\"serial_cat\";s:0:\"\";s:5:\"count\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("12656", "country_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("13743", "rate_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("13913", "updraft_task_manager_dbversion", "1.1", "yes");
INSERT INTO `wp_options` VALUES("16398", "wpmc_rating_date", "1659447775", "no");
INSERT INTO `wp_options` VALUES("16399", "wpmc_images_only", "1", "yes");
INSERT INTO `wp_options` VALUES("16400", "wpmc_attach_is_use", "1", "yes");
INSERT INTO `wp_options` VALUES("16578", "theme_mods_twentytwentytwo", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1667940800;s:4:\"data\";a:1:{s:19:\"wp_inactive_widgets\";a:0:{}}}s:18:\"custom_css_post_id\";i:-1;}", "yes");
INSERT INTO `wp_options` VALUES("19578", "restrict_content_chosen_version", "3.0", "yes");
INSERT INTO `wp_options` VALUES("19580", "rc_settings", "a:6:{s:17:\"shortcode_message\";s:36:\"You do not have access to this post.\";s:21:\"administrator_message\";s:40:\"This content is for Administrator Users.\";s:14:\"editor_message\";s:33:\"This content is for Editor Users.\";s:14:\"author_message\";s:33:\"This content is for Author Users.\";s:19:\"contributor_message\";s:38:\"This content is for Contributor Users.\";s:18:\"subscriber_message\";s:37:\"This content is for Subscribers Users\";}", "yes");
INSERT INTO `wp_options` VALUES("19581", "rc_user_level_post_meta_updated", "1", "yes");
INSERT INTO `wp_options` VALUES("19582", "rc_version", "3.1.5", "yes");
INSERT INTO `wp_options` VALUES("20888", "widget_csf_widget_post_slider", "a:2:{i:2;a:5:{s:5:\"title\";s:23:\"برترین مطالب\";s:4:\"icon\";s:10:\"fa fa-film\";s:5:\"count\";s:1:\"5\";s:7:\"archive\";s:1:\"0\";s:8:\"film_cat\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("21372", "my_framework2", "a:7:{s:9:\"ads_image\";a:8:{s:3:\"url\";s:93:\"https://kelaketfilm.dev.local/wp-content/uploads/2022/11/c516ce1c98fe4a32840dff1aa96e4bbb.jpg\";s:2:\"id\";s:4:\"3130\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:3:\"359\";s:9:\"thumbnail\";s:101:\"https://kelaketfilm.dev.local/wp-content/uploads/2022/11/c516ce1c98fe4a32840dff1aa96e4bbb-150x150.jpg\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:32:\"c516ce1c98fe4a32840dff1aa96e4bbb\";s:11:\"description\";s:0:\"\";}s:8:\"ads_link\";s:47:\"https://www.rtl-theme.com/dashboard/#/dashboard\";s:17:\"ads_link_position\";s:1:\"1\";s:11:\"active_live\";s:1:\"1\";s:8:\"live_cat\";s:1:\"1\";s:17:\"active_collection\";s:1:\"1\";s:19:\"collection_position\";s:1:\"1\";}", "yes");
INSERT INTO `wp_options` VALUES("21550", "category_children", "a:4:{i:6;a:4:{i:0;i:7;i:1;i:18;i:2;i:19;i:3;i:26;}i:8;a:7:{i:0;i:9;i:1;i:17;i:2;i:23;i:3;i:31;i:4;i:39;i:5;i:42;i:6;i:214;}i:1;a:1:{i:0;i:20;}i:161;a:2:{i:0;i:162;i:1;i:163;}}", "yes");
INSERT INTO `wp_options` VALUES("22469", "widget_csf_widget_updated_series_2", "a:2:{i:2;a:3:{s:5:\"title\";s:39:\"سریال آپدیت شده درنوس\";s:10:\"serial_cat\";s:1:\"8\";s:5:\"count\";s:1:\"2\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("22516", "sub_lang_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("26180", "imdb_top_250_movies", "a:2:{s:11:\"update_date\";s:19:\"2022-12-25 10:11:18\";s:4:\"data\";a:250:{i:0;a:5:{s:2:\"id\";s:9:\"tt0111161\";s:4:\"rank\";s:1:\"1\";s:5:\"title\";s:24:\"The Shawshank Redemption\";s:9:\"imdb_rate\";s:3:\"9.2\";s:5:\"image\";s:106:\"/kelaket_images/MV5BMDFkYTc0MGEtZmNhMC00ZDIzLWFmNTEtODM1ZmRlYWMwMWFmXkEyXkFqcGdeQXVyMTMxODk2OTU@.UX256.jpg\";}i:1;a:5:{s:2:\"id\";s:9:\"tt0068646\";s:4:\"rank\";s:1:\"2\";s:5:\"title\";s:13:\"The Godfather\";s:9:\"imdb_rate\";s:3:\"9.2\";s:5:\"image\";s:106:\"/kelaket_images/MV5BM2MyNjYxNmUtYTAwNi00MTYxLWJmNWYtYzZlODY3ZTk3OTFlXkEyXkFqcGdeQXVyNzkwMjQ5NzM@.UX256.jpg\";}i:2;a:5:{s:2:\"id\";s:9:\"tt0468569\";s:4:\"rank\";s:1:\"3\";s:5:\"title\";s:15:\"The Dark Knight\";s:9:\"imdb_rate\";s:3:\"9.0\";s:5:\"image\";s:74:\"/kelaket_images/MV5BMTMxNTMwODM0NF5BMl5BanBnXkFtZTcwODAyMTk2Mw@@.UX256.jpg\";}i:3;a:5:{s:2:\"id\";s:9:\"tt0071562\";s:4:\"rank\";s:1:\"4\";s:5:\"title\";s:21:\"The Godfather Part II\";s:9:\"imdb_rate\";s:3:\"9.0\";s:5:\"image\";s:106:\"/kelaket_images/MV5BMWMwMGQzZTItY2JlNC00OWZiLWIyMDctNDk2ZDQ2YjRjMWQ0XkEyXkFqcGdeQXVyNzkwMjQ5NzM@.UX256.jpg\";}i:4;a:5:{s:2:\"id\";s:9:\"tt0050083\";s:4:\"rank\";s:1:\"5\";s:5:\"title\";s:12:\"12 Angry Men\";s:9:\"imdb_rate\";s:3:\"9.0\";s:5:\"image\";s:106:\"/kelaket_images/MV5BMWU4N2FjNzYtNTVkNC00NzQ0LTg0MjAtYTJlMjFhNGUxZDFmXkEyXkFqcGdeQXVyNjc1NTYyMjg@.UX256.jpg\";}i:5;a:5:{s:2:\"id\";s:9:\"tt0108052\";s:4:\"rank\";s:1:\"6\";s:5:\"title\";s:16:\"Schindler\'s List\";s:9:\"imdb_rate\";s:3:\"8.9\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNDE4OTMxMTctNmRhYy00NWE2LTg3YzItYTk3M2UwOTU5Njg4XkEyXkFqcGdeQXVyNjU0OTQ0OTY@.UX256.jpg\";}i:6;a:5:{s:2:\"id\";s:9:\"tt0167260\";s:4:\"rank\";s:1:\"7\";s:5:\"title\";s:45:\"The Lord of the Rings: The Return of the King\";s:9:\"imdb_rate\";s:3:\"8.9\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNzA5ZDNlZWMtM2NhNS00NDJjLTk4NDItYTRmY2EwMWZlMTY3XkEyXkFqcGdeQXVyNzkwMjQ5NzM@.UX256.jpg\";}i:7;a:5:{s:2:\"id\";s:9:\"tt0110912\";s:4:\"rank\";s:1:\"8\";s:5:\"title\";s:12:\"Pulp Fiction\";s:9:\"imdb_rate\";s:3:\"8.8\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNGNhMDIzZTUtNTBlZi00MTRlLWFjM2ItYzViMjE3YzI5MjljXkEyXkFqcGdeQXVyNzkwMjQ5NzM@.UX256.jpg\";}i:8;a:5:{s:2:\"id\";s:9:\"tt0120737\";s:4:\"rank\";s:1:\"9\";s:5:\"title\";s:49:\"The Lord of the Rings: The Fellowship of the Ring\";s:9:\"imdb_rate\";s:3:\"8.8\";s:5:\"image\";s:106:\"/kelaket_images/MV5BN2EyZjM3NzUtNWUzMi00MTgxLWI0NTctMzY4M2VlOTdjZWRiXkEyXkFqcGdeQXVyNDUzOTQ5MjY@.UX256.jpg\";}i:9;a:5:{s:2:\"id\";s:9:\"tt0060196\";s:4:\"rank\";s:2:\"10\";s:5:\"title\";s:30:\"The Good, the Bad and the Ugly\";s:9:\"imdb_rate\";s:3:\"8.8\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNjJlYmNkZGItM2NhYy00MjlmLTk5NmQtNjg1NmM2ODU4OTMwXkEyXkFqcGdeQXVyMjUzOTY1NTc@.UX256.jpg\";}i:10;a:5:{s:2:\"id\";s:9:\"tt0109830\";s:4:\"rank\";s:2:\"11\";s:5:\"title\";s:12:\"Forrest Gump\";s:9:\"imdb_rate\";s:3:\"8.8\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNWIwODRlZTUtY2U3ZS00Yzg1LWJhNzYtMmZiYmEyNmU1NjMzXkEyXkFqcGdeQXVyMTQxNzMzNDI@.UX256.jpg\";}i:11;a:5:{s:2:\"id\";s:9:\"tt0137523\";s:4:\"rank\";s:2:\"12\";s:5:\"title\";s:10:\"Fight Club\";s:9:\"imdb_rate\";s:3:\"8.7\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNDIzNDU0YzEtYzE5Ni00ZjlkLTk5ZjgtNjM3NWE4YzA3Nzk3XkEyXkFqcGdeQXVyMjUzOTY1NTc@.UX256.jpg\";}i:12;a:5:{s:2:\"id\";s:9:\"tt0167261\";s:4:\"rank\";s:2:\"13\";s:5:\"title\";s:37:\"The Lord of the Rings: The Two Towers\";s:9:\"imdb_rate\";s:3:\"8.7\";s:5:\"image\";s:106:\"/kelaket_images/MV5BZGMxZTdjZmYtMmE2Ni00ZTdkLWI5NTgtNjlmMjBiNzU2MmI5XkEyXkFqcGdeQXVyNjU0OTQ0OTY@.UX256.jpg\";}i:13;a:5:{s:2:\"id\";s:9:\"tt1375666\";s:4:\"rank\";s:2:\"14\";s:5:\"title\";s:9:\"Inception\";s:9:\"imdb_rate\";s:3:\"8.7\";s:5:\"image\";s:74:\"/kelaket_images/MV5BMjAxMzY3NjcxNF5BMl5BanBnXkFtZTcwNTI5OTM0Mw@@.UX256.jpg\";}i:14;a:5:{s:2:\"id\";s:9:\"tt0080684\";s:4:\"rank\";s:2:\"15\";s:5:\"title\";s:46:\"Star Wars: Episode V - The Empire Strikes Back\";s:9:\"imdb_rate\";s:3:\"8.7\";s:5:\"image\";s:106:\"/kelaket_images/MV5BYmU1NDRjNDgtMzhiMi00NjZmLTg5NGItZDNiZjU5NTU4OTE0XkEyXkFqcGdeQXVyNzkwMjQ5NzM@.UX256.jpg\";}i:15;a:5:{s:2:\"id\";s:9:\"tt0133093\";s:4:\"rank\";s:2:\"16\";s:5:\"title\";s:10:\"The Matrix\";s:9:\"imdb_rate\";s:3:\"8.7\";s:5:\"image\";s:114:\"/kelaket_images/MV5BNzQzOTk3OTAtNDQ0Zi00ZTVkLWI0MTEtMDllZjNkYzNjNTc4L2ltYWdlXkEyXkFqcGdeQXVyNjU0OTQ0OTY@.UX256.jpg\";}i:16;a:5:{s:2:\"id\";s:9:\"tt0099685\";s:4:\"rank\";s:2:\"17\";s:5:\"title\";s:10:\"Goodfellas\";s:9:\"imdb_rate\";s:3:\"8.7\";s:5:\"image\";s:106:\"/kelaket_images/MV5BY2NkZjEzMDgtN2RjYy00YzM1LWI4ZmQtMjIwYjFjNmI3ZGEwXkEyXkFqcGdeQXVyNzkwMjQ5NzM@.UX256.jpg\";}i:17;a:5:{s:2:\"id\";s:9:\"tt0073486\";s:4:\"rank\";s:2:\"18\";s:5:\"title\";s:31:\"One Flew Over the Cuckoo\'s Nest\";s:9:\"imdb_rate\";s:3:\"8.6\";s:5:\"image\";s:122:\"/kelaket_images/MV5BZjA0OWVhOTAtYWQxNi00YzNhLWI4ZjYtNjFjZTEyYjJlNDVlL2ltYWdlL2ltYWdlXkEyXkFqcGdeQXVyMTQxNzMzNDI@.UX256.jpg\";}i:18;a:5:{s:2:\"id\";s:9:\"tt0114369\";s:4:\"rank\";s:2:\"19\";s:5:\"title\";s:5:\"Se7en\";s:9:\"imdb_rate\";s:3:\"8.6\";s:5:\"image\";s:106:\"/kelaket_images/MV5BOTUwODM5MTctZjczMi00OTk4LTg3NWUtNmVhMTAzNTNjYjcyXkEyXkFqcGdeQXVyNjU0OTQ0OTY@.UX256.jpg\";}i:19;a:5:{s:2:\"id\";s:9:\"tt0047478\";s:4:\"rank\";s:2:\"20\";s:5:\"title\";s:13:\"Seven Samurai\";s:9:\"imdb_rate\";s:3:\"8.6\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNWQ3OTM4ZGItMWEwZi00MjI5LWI3YzgtNTYwNWRkNmIzMGI5XkEyXkFqcGdeQXVyNDY2MTk1ODk@.UX256.jpg\";}i:20;a:5:{s:2:\"id\";s:9:\"tt0038650\";s:4:\"rank\";s:2:\"21\";s:5:\"title\";s:21:\"It\'s a Wonderful Life\";s:9:\"imdb_rate\";s:3:\"8.6\";s:5:\"image\";s:106:\"/kelaket_images/MV5BZjc4NDZhZWMtNGEzYS00ZWU2LThlM2ItNTA0YzQ0OTExMTE2XkEyXkFqcGdeQXVyNjUwMzI2NzU@.UX256.jpg\";}i:21;a:5:{s:2:\"id\";s:9:\"tt0102926\";s:4:\"rank\";s:2:\"22\";s:5:\"title\";s:24:\"The Silence of the Lambs\";s:9:\"imdb_rate\";s:3:\"8.6\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNjNhZTk0ZmEtNjJhMi00YzFlLWE1MmEtYzM1M2ZmMGMwMTU4XkEyXkFqcGdeQXVyNjU0OTQ0OTY@.UX256.jpg\";}i:22;a:5:{s:2:\"id\";s:9:\"tt0317248\";s:4:\"rank\";s:2:\"23\";s:5:\"title\";s:11:\"City of God\";s:9:\"imdb_rate\";s:3:\"8.6\";s:5:\"image\";s:106:\"/kelaket_images/MV5BOTMwYjc5ZmItYTFjZC00ZGQ3LTlkNTMtMjZiNTZlMWQzNzI5XkEyXkFqcGdeQXVyNzkwMjQ5NzM@.UX256.jpg\";}i:23;a:5:{s:2:\"id\";s:9:\"tt0120815\";s:4:\"rank\";s:2:\"24\";s:5:\"title\";s:19:\"Saving Private Ryan\";s:9:\"imdb_rate\";s:3:\"8.6\";s:5:\"image\";s:106:\"/kelaket_images/MV5BZjhkMDM4MWItZTVjOC00ZDRhLThmYTAtM2I5NzBmNmNlMzI1XkEyXkFqcGdeQXVyNDYyMDk5MTU@.UX256.jpg\";}i:24;a:5:{s:2:\"id\";s:9:\"tt0118799\";s:4:\"rank\";s:2:\"25\";s:5:\"title\";s:17:\"Life Is Beautiful\";s:9:\"imdb_rate\";s:3:\"8.6\";s:5:\"image\";s:106:\"/kelaket_images/MV5BYmJmM2Q4NmMtYThmNC00ZjRlLWEyZmItZTIwOTBlZDQ3NTQ1XkEyXkFqcGdeQXVyMTQxNzMzNDI@.UX256.jpg\";}i:25;a:5:{s:2:\"id\";s:9:\"tt0816692\";s:4:\"rank\";s:2:\"26\";s:5:\"title\";s:12:\"Interstellar\";s:9:\"imdb_rate\";s:3:\"8.6\";s:5:\"image\";s:106:\"/kelaket_images/MV5BZjdkOTU3MDktN2IxOS00OGEyLWFmMjktY2FiMmZkNWIyODZiXkEyXkFqcGdeQXVyMTMxODk2OTU@.UX256.jpg\";}i:26;a:5:{s:2:\"id\";s:9:\"tt0120689\";s:4:\"rank\";s:2:\"27\";s:5:\"title\";s:14:\"The Green Mile\";s:9:\"imdb_rate\";s:3:\"8.6\";s:5:\"image\";s:70:\"/kelaket_images/MV5BMTUxMzQyNjA5MF5BMl5BanBnXkFtZTYwOTU2NTY3.UX256.jpg\";}i:27;a:5:{s:2:\"id\";s:9:\"tt0076759\";s:4:\"rank\";s:2:\"28\";s:5:\"title\";s:34:\"Star Wars: Episode IV - A New Hope\";s:9:\"imdb_rate\";s:3:\"8.5\";s:5:\"image\";s:106:\"/kelaket_images/MV5BOTA5NjhiOTAtZWM0ZC00MWNhLThiMzEtZDFkOTk2OTU1ZDJkXkEyXkFqcGdeQXVyMTA4NDI1NTQx.UX256.jpg\";}i:28;a:5:{s:2:\"id\";s:9:\"tt0103064\";s:4:\"rank\";s:2:\"29\";s:5:\"title\";s:26:\"Terminator 2: Judgment Day\";s:9:\"imdb_rate\";s:3:\"8.5\";s:5:\"image\";s:106:\"/kelaket_images/MV5BMGU2NzRmZjUtOGUxYS00ZjdjLWEwZWItY2NlM2JhNjkxNTFmXkEyXkFqcGdeQXVyNjU0OTQ0OTY@.UX256.jpg\";}i:29;a:5:{s:2:\"id\";s:9:\"tt0088763\";s:4:\"rank\";s:2:\"30\";s:5:\"title\";s:18:\"Back to the Future\";s:9:\"imdb_rate\";s:3:\"8.5\";s:5:\"image\";s:106:\"/kelaket_images/MV5BZmU0M2Y1OGUtZjIxNi00ZjBkLTg1MjgtOWIyNThiZWIwYjRiXkEyXkFqcGdeQXVyMTQxNzMzNDI@.UX256.jpg\";}i:30;a:5:{s:2:\"id\";s:9:\"tt0245429\";s:4:\"rank\";s:2:\"31\";s:5:\"title\";s:13:\"Spirited Away\";s:9:\"imdb_rate\";s:3:\"8.5\";s:5:\"image\";s:106:\"/kelaket_images/MV5BMjlmZmI5MDctNDE2YS00YWE0LWE5ZWItZDBhYWQ0NTcxNWRhXkEyXkFqcGdeQXVyMTMxODk2OTU@.UX256.jpg\";}i:31;a:5:{s:2:\"id\";s:9:\"tt0054215\";s:4:\"rank\";s:2:\"32\";s:5:\"title\";s:6:\"Psycho\";s:9:\"imdb_rate\";s:3:\"8.5\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNTQwNDM1YzItNDAxZC00NWY2LTk0M2UtNDIwNWI5OGUyNWUxXkEyXkFqcGdeQXVyNzkwMjQ5NzM@.UX256.jpg\";}i:32;a:5:{s:2:\"id\";s:9:\"tt0253474\";s:4:\"rank\";s:2:\"33\";s:5:\"title\";s:11:\"The Pianist\";s:9:\"imdb_rate\";s:3:\"8.5\";s:5:\"image\";s:106:\"/kelaket_images/MV5BOWRiZDIxZjktMTA1NC00MDQ2LWEzMjUtMTliZmY3NjQ3ODJiXkEyXkFqcGdeQXVyNjU0OTQ0OTY@.UX256.jpg\";}i:33;a:5:{s:2:\"id\";s:9:\"tt6751668\";s:4:\"rank\";s:2:\"34\";s:5:\"title\";s:8:\"Parasite\";s:9:\"imdb_rate\";s:3:\"8.5\";s:5:\"image\";s:106:\"/kelaket_images/MV5BYWZjMjk3ZTItODQ2ZC00NTY5LWE0ZDYtZTI3MjcwN2Q5NTVkXkEyXkFqcGdeQXVyODk4OTc3MTY@.UX256.jpg\";}i:34;a:5:{s:2:\"id\";s:9:\"tt0110413\";s:4:\"rank\";s:2:\"35\";s:5:\"title\";s:23:\"Léon: The Professional\";s:9:\"imdb_rate\";s:3:\"8.5\";s:5:\"image\";s:106:\"/kelaket_images/MV5BOTgyMWQ0ZWUtN2Q2MS00NmY0LWI3OWMtNjFkMzZlNDZjNTk0XkEyXkFqcGdeQXVyMjUzOTY1NTc@.UX256.jpg\";}i:35;a:5:{s:2:\"id\";s:9:\"tt0110357\";s:4:\"rank\";s:2:\"36\";s:5:\"title\";s:13:\"The Lion King\";s:9:\"imdb_rate\";s:3:\"8.5\";s:5:\"image\";s:106:\"/kelaket_images/MV5BYTYxNGMyZTYtMjE3MS00MzNjLWFjNmYtMDk3N2FmM2JiM2M1XkEyXkFqcGdeQXVyNjY5NDU4NzI@.UX256.jpg\";}i:36;a:5:{s:2:\"id\";s:9:\"tt0172495\";s:4:\"rank\";s:2:\"37\";s:5:\"title\";s:9:\"Gladiator\";s:9:\"imdb_rate\";s:3:\"8.5\";s:5:\"image\";s:114:\"/kelaket_images/MV5BMDliMmNhNDEtODUyOS00MjNlLTgxODEtN2U3NzIxMGVkZTA1L2ltYWdlXkEyXkFqcGdeQXVyNjU0OTQ0OTY@.UX256.jpg\";}i:37;a:5:{s:2:\"id\";s:9:\"tt0120586\";s:4:\"rank\";s:2:\"38\";s:5:\"title\";s:18:\"American History X\";s:9:\"imdb_rate\";s:3:\"8.5\";s:5:\"image\";s:106:\"/kelaket_images/MV5BZTJhN2FkYWEtMGI0My00YWM4LWI2MjAtM2UwNjY4MTI2ZTQyXkEyXkFqcGdeQXVyNjc3MjQzNTI@.UX256.jpg\";}i:38;a:5:{s:2:\"id\";s:9:\"tt0407887\";s:4:\"rank\";s:2:\"39\";s:5:\"title\";s:12:\"The Departed\";s:9:\"imdb_rate\";s:3:\"8.5\";s:5:\"image\";s:70:\"/kelaket_images/MV5BMTI1MTY2OTIxNV5BMl5BanBnXkFtZTYwNjQ4NjY3.UX256.jpg\";}i:39;a:5:{s:2:\"id\";s:9:\"tt0114814\";s:4:\"rank\";s:2:\"40\";s:5:\"title\";s:18:\"The Usual Suspects\";s:9:\"imdb_rate\";s:3:\"8.5\";s:5:\"image\";s:106:\"/kelaket_images/MV5BYTViNjMyNmUtNDFkNC00ZDRlLThmMDUtZDU2YWE4NGI2ZjVmXkEyXkFqcGdeQXVyNjU0OTQ0OTY@.UX256.jpg\";}i:40;a:5:{s:2:\"id\";s:9:\"tt0482571\";s:4:\"rank\";s:2:\"41\";s:5:\"title\";s:12:\"The Prestige\";s:9:\"imdb_rate\";s:3:\"8.5\";s:5:\"image\";s:70:\"/kelaket_images/MV5BMjA4NDI0MTIxNF5BMl5BanBnXkFtZTYwNTM0MzY2.UX256.jpg\";}i:41;a:5:{s:2:\"id\";s:9:\"tt2582802\";s:4:\"rank\";s:2:\"42\";s:5:\"title\";s:8:\"Whiplash\";s:9:\"imdb_rate\";s:3:\"8.5\";s:5:\"image\";s:106:\"/kelaket_images/MV5BOTA5NDZlZGUtMjAxOS00YTRkLTkwYmMtYWQ0NWEwZDZiNjEzXkEyXkFqcGdeQXVyMTMxODk2OTU@.UX256.jpg\";}i:42;a:5:{s:2:\"id\";s:9:\"tt0034583\";s:4:\"rank\";s:2:\"43\";s:5:\"title\";s:10:\"Casablanca\";s:9:\"imdb_rate\";s:3:\"8.5\";s:5:\"image\";s:106:\"/kelaket_images/MV5BY2IzZGY2YmEtYzljNS00NTM5LTgwMzUtMzM1NjQ4NGI0OTk0XkEyXkFqcGdeQXVyNDYyMDk5MTU@.UX256.jpg\";}i:43;a:5:{s:2:\"id\";s:9:\"tt0056058\";s:4:\"rank\";s:2:\"44\";s:5:\"title\";s:8:\"Harakiri\";s:9:\"imdb_rate\";s:3:\"8.5\";s:5:\"image\";s:106:\"/kelaket_images/MV5BYjBmYTQ1NjItZWU5MS00YjI0LTg2OTYtYmFkN2JkMmNiNWVkXkEyXkFqcGdeQXVyMTMxMTY0OTQ@.UX256.jpg\";}i:44;a:5:{s:2:\"id\";s:9:\"tt0095327\";s:4:\"rank\";s:2:\"45\";s:5:\"title\";s:22:\"Grave of the Fireflies\";s:9:\"imdb_rate\";s:3:\"8.5\";s:5:\"image\";s:106:\"/kelaket_images/MV5BZmY2NjUzNDQtNTgxNC00M2Q4LTljOWQtMjNjNDBjNWUxNmJlXkEyXkFqcGdeQXVyNTA4NzY1MzY@.UX256.jpg\";}i:45;a:5:{s:2:\"id\";s:9:\"tt1675434\";s:4:\"rank\";s:2:\"46\";s:5:\"title\";s:16:\"The Intouchables\";s:9:\"imdb_rate\";s:3:\"8.5\";s:5:\"image\";s:74:\"/kelaket_images/MV5BMTYxNDA3MDQwNl5BMl5BanBnXkFtZTcwNTU4Mzc1Nw@@.UX256.jpg\";}i:46;a:5:{s:2:\"id\";s:9:\"tt0027977\";s:4:\"rank\";s:2:\"47\";s:5:\"title\";s:12:\"Modern Times\";s:9:\"imdb_rate\";s:3:\"8.4\";s:5:\"image\";s:122:\"/kelaket_images/MV5BYjJiZjMzYzktNjU0NS00OTkxLWEwYzItYzdhYWJjN2QzMTRlL2ltYWdlL2ltYWdlXkEyXkFqcGdeQXVyNjU0OTQ0OTY@.UX256.jpg\";}i:47;a:5:{s:2:\"id\";s:9:\"tt0064116\";s:4:\"rank\";s:2:\"48\";s:5:\"title\";s:28:\"Once Upon a Time in the West\";s:9:\"imdb_rate\";s:3:\"8.4\";s:5:\"image\";s:106:\"/kelaket_images/MV5BODQ3NDExOGYtMzI3Mi00NWRlLTkwNjAtNjc4MDgzZGJiZTA1XkEyXkFqcGdeQXVyMjUzOTY1NTc@.UX256.jpg\";}i:48;a:5:{s:2:\"id\";s:9:\"tt0047396\";s:4:\"rank\";s:2:\"49\";s:5:\"title\";s:11:\"Rear Window\";s:9:\"imdb_rate\";s:3:\"8.4\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNGUxYWM3M2MtMGM3Mi00ZmRiLWE0NGQtZjE5ODI2OTJhNTU0XkEyXkFqcGdeQXVyMTQxNzMzNDI@.UX256.jpg\";}i:49;a:5:{s:2:\"id\";s:9:\"tt0095765\";s:4:\"rank\";s:2:\"50\";s:5:\"title\";s:15:\"Cinema Paradiso\";s:9:\"imdb_rate\";s:3:\"8.4\";s:5:\"image\";s:106:\"/kelaket_images/MV5BM2FhYjEyYmYtMDI1Yy00YTdlLWI2NWQtYmEzNzAxOGY1NjY2XkEyXkFqcGdeQXVyNTA3NTIyNDg@.UX256.jpg\";}i:50;a:5:{s:2:\"id\";s:9:\"tt0078748\";s:4:\"rank\";s:2:\"51\";s:5:\"title\";s:5:\"Alien\";s:9:\"imdb_rate\";s:3:\"8.4\";s:5:\"image\";s:106:\"/kelaket_images/MV5BOGQzZTBjMjQtOTVmMS00NGE5LWEyYmMtOGQ1ZGZjNmRkYjFhXkEyXkFqcGdeQXVyMjUzOTY1NTc@.UX256.jpg\";}i:51;a:5:{s:2:\"id\";s:9:\"tt0021749\";s:4:\"rank\";s:2:\"52\";s:5:\"title\";s:11:\"City Lights\";s:9:\"imdb_rate\";s:3:\"8.4\";s:5:\"image\";s:106:\"/kelaket_images/MV5BY2I4MmM1N2EtM2YzOS00OWUzLTkzYzctNDc5NDg2N2IyODJmXkEyXkFqcGdeQXVyNzkwMjQ5NzM@.UX256.jpg\";}i:52;a:5:{s:2:\"id\";s:9:\"tt0078788\";s:4:\"rank\";s:2:\"53\";s:5:\"title\";s:14:\"Apocalypse Now\";s:9:\"imdb_rate\";s:3:\"8.4\";s:5:\"image\";s:106:\"/kelaket_images/MV5BYmQyNTA1ZGItNjZjMi00NzFlLWEzMWEtNWMwN2Q2MjJhYzEyXkEyXkFqcGdeQXVyMjUzOTY1NTc@.UX256.jpg\";}i:53;a:5:{s:2:\"id\";s:9:\"tt0209144\";s:4:\"rank\";s:2:\"54\";s:5:\"title\";s:7:\"Memento\";s:9:\"imdb_rate\";s:3:\"8.4\";s:5:\"image\";s:106:\"/kelaket_images/MV5BZTcyNjk1MjgtOWI3Mi00YzQwLWI5MTktMzY4ZmI2NDAyNzYzXkEyXkFqcGdeQXVyNjU0OTQ0OTY@.UX256.jpg\";}i:54;a:5:{s:2:\"id\";s:9:\"tt0082971\";s:4:\"rank\";s:2:\"55\";s:5:\"title\";s:45:\"Indiana Jones and the Raiders of the Lost Ark\";s:9:\"imdb_rate\";s:3:\"8.4\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNTU2ODkyY2MtMjU1NC00NjE1LWEzYjgtMWQ3MzRhMTE0NDc0XkEyXkFqcGdeQXVyMjM4MzQ4OTQ@.UX256.jpg\";}i:55;a:5:{s:2:\"id\";s:9:\"tt1853728\";s:4:\"rank\";s:2:\"56\";s:5:\"title\";s:16:\"Django Unchained\";s:9:\"imdb_rate\";s:3:\"8.4\";s:5:\"image\";s:74:\"/kelaket_images/MV5BMjIyNTQ5NjQ1OV5BMl5BanBnXkFtZTcwODg1MDU4OA@@.UX256.jpg\";}i:56;a:5:{s:2:\"id\";s:9:\"tt0910970\";s:4:\"rank\";s:2:\"57\";s:5:\"title\";s:7:\"WALL·E\";s:9:\"imdb_rate\";s:3:\"8.4\";s:5:\"image\";s:74:\"/kelaket_images/MV5BMjExMTg5OTU0NF5BMl5BanBnXkFtZTcwMjMxMzMzMw@@.UX256.jpg\";}i:57;a:5:{s:2:\"id\";s:9:\"tt0405094\";s:4:\"rank\";s:2:\"58\";s:5:\"title\";s:19:\"The Lives of Others\";s:9:\"imdb_rate\";s:3:\"8.4\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNmQyNmJjM2ItNTQzYi00ZjMxLWFjMDYtZjUyN2YwZDk5YWQ2XkEyXkFqcGdeQXVyMjUzOTY1NTc@.UX256.jpg\";}i:58;a:5:{s:2:\"id\";s:9:\"tt0043014\";s:4:\"rank\";s:2:\"59\";s:5:\"title\";s:12:\"Sunset Blvd.\";s:9:\"imdb_rate\";s:3:\"8.4\";s:5:\"image\";s:74:\"/kelaket_images/MV5BMTU0NTkyNzYwMF5BMl5BanBnXkFtZTgwMDU0NDk5MTI@.UX256.jpg\";}i:59;a:5:{s:2:\"id\";s:9:\"tt0050825\";s:4:\"rank\";s:2:\"60\";s:5:\"title\";s:14:\"Paths of Glory\";s:9:\"imdb_rate\";s:3:\"8.4\";s:5:\"image\";s:106:\"/kelaket_images/MV5BOTI5Nzc0OTMtYzBkMS00NjkxLThmM2UtNjM2ODgxN2M5NjNkXkEyXkFqcGdeQXVyNjQ2MjQ5NzM@.UX256.jpg\";}i:60;a:5:{s:2:\"id\";s:9:\"tt0081505\";s:4:\"rank\";s:2:\"61\";s:5:\"title\";s:11:\"The Shining\";s:9:\"imdb_rate\";s:3:\"8.4\";s:5:\"image\";s:106:\"/kelaket_images/MV5BZWFlYmY2MGEtZjVkYS00YzU4LTg0YjQtYzY1ZGE3NTA5NGQxXkEyXkFqcGdeQXVyMTQxNzMzNDI@.UX256.jpg\";}i:61;a:5:{s:2:\"id\";s:9:\"tt0032553\";s:4:\"rank\";s:2:\"62\";s:5:\"title\";s:18:\"The Great Dictator\";s:9:\"imdb_rate\";s:3:\"8.4\";s:5:\"image\";s:106:\"/kelaket_images/MV5BMmExYWJjNTktNGUyZS00ODhmLTkxYzAtNWIzOGEyMGNiMmUwXkEyXkFqcGdeQXVyNjU0OTQ0OTY@.UX256.jpg\";}i:62;a:5:{s:2:\"id\";s:9:\"tt4154756\";s:4:\"rank\";s:2:\"63\";s:5:\"title\";s:22:\"Avengers: Infinity War\";s:9:\"imdb_rate\";s:3:\"8.4\";s:5:\"image\";s:74:\"/kelaket_images/MV5BMjMxNjY2MDU1OV5BMl5BanBnXkFtZTgwNzY1MTUwNTM@.UX256.jpg\";}i:63;a:5:{s:2:\"id\";s:9:\"tt0051201\";s:4:\"rank\";s:2:\"64\";s:5:\"title\";s:27:\"Witness for the Prosecution\";s:9:\"imdb_rate\";s:3:\"8.4\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNDQwODU5OWYtNDcyNi00MDQ1LThiOGMtZDkwNWJiM2Y3MDg0XkEyXkFqcGdeQXVyMDI2NDg0NQ@@.UX256.jpg\";}i:64;a:5:{s:2:\"id\";s:9:\"tt0090605\";s:4:\"rank\";s:2:\"65\";s:5:\"title\";s:6:\"Aliens\";s:9:\"imdb_rate\";s:3:\"8.3\";s:5:\"image\";s:106:\"/kelaket_images/MV5BZGU2OGY5ZTYtMWNhYy00NjZiLWI0NjUtZmNhY2JhNDRmODU3XkEyXkFqcGdeQXVyNzkwMjQ5NzM@.UX256.jpg\";}i:65;a:5:{s:2:\"id\";s:9:\"tt4633694\";s:4:\"rank\";s:2:\"66\";s:5:\"title\";s:33:\"Spider-Man: Into the Spider-Verse\";s:9:\"imdb_rate\";s:3:\"8.3\";s:5:\"image\";s:74:\"/kelaket_images/MV5BMjMwNDkxMTgzOF5BMl5BanBnXkFtZTgwNTkwNTQ3NjM@.UX256.jpg\";}i:66;a:5:{s:2:\"id\";s:9:\"tt0169547\";s:4:\"rank\";s:2:\"67\";s:5:\"title\";s:15:\"American Beauty\";s:9:\"imdb_rate\";s:3:\"8.3\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNTBmZWJkNjctNDhiNC00MGE2LWEwOTctZTk5OGVhMWMyNmVhXkEyXkFqcGdeQXVyMTMxODk2OTU@.UX256.jpg\";}i:67;a:5:{s:2:\"id\";s:9:\"tt0057012\";s:4:\"rank\";s:2:\"68\";s:5:\"title\";s:68:\"Dr. Strangelove or: How I Learned to Stop Worrying and Love the Bomb\";s:9:\"imdb_rate\";s:3:\"8.3\";s:5:\"image\";s:106:\"/kelaket_images/MV5BZWI3ZTMxNjctMjdlNS00NmUwLWFiM2YtZDUyY2I3N2MxYTE0XkEyXkFqcGdeQXVyNzkwMjQ5NzM@.UX256.jpg\";}i:68;a:5:{s:2:\"id\";s:9:\"tt1345836\";s:4:\"rank\";s:2:\"69\";s:5:\"title\";s:21:\"The Dark Knight Rises\";s:9:\"imdb_rate\";s:3:\"8.3\";s:5:\"image\";s:74:\"/kelaket_images/MV5BMTk4ODQzNDY3Ml5BMl5BanBnXkFtZTcwODA0NTM4Nw@@.UX256.jpg\";}i:69;a:5:{s:2:\"id\";s:9:\"tt0364569\";s:4:\"rank\";s:2:\"70\";s:5:\"title\";s:6:\"Oldboy\";s:9:\"imdb_rate\";s:3:\"8.3\";s:5:\"image\";s:74:\"/kelaket_images/MV5BMTI3NTQyMzU5M15BMl5BanBnXkFtZTcwMTM2MjgyMQ@@.UX256.jpg\";}i:70;a:5:{s:2:\"id\";s:9:\"tt0086879\";s:4:\"rank\";s:2:\"71\";s:5:\"title\";s:7:\"Amadeus\";s:9:\"imdb_rate\";s:3:\"8.3\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNWJlNzUzNGMtYTAwMS00ZjI2LWFmNWQtODcxNWUxODA5YmU1XkEyXkFqcGdeQXVyNTIzOTk5ODM@.UX256.jpg\";}i:71;a:5:{s:2:\"id\";s:9:\"tt0361748\";s:4:\"rank\";s:2:\"72\";s:5:\"title\";s:20:\"Inglourious Basterds\";s:9:\"imdb_rate\";s:3:\"8.3\";s:5:\"image\";s:106:\"/kelaket_images/MV5BOTJiNDEzOWYtMTVjOC00ZjlmLWE0NGMtZmE1OWVmZDQ2OWJhXkEyXkFqcGdeQXVyNTIzOTk5ODM@.UX256.jpg\";}i:72;a:5:{s:2:\"id\";s:9:\"tt7286456\";s:4:\"rank\";s:2:\"73\";s:5:\"title\";s:5:\"Joker\";s:9:\"imdb_rate\";s:3:\"8.3\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNGVjNWI4ZGUtNzE0MS00YTJmLWE0ZDctN2ZiYTk2YmI3NTYyXkEyXkFqcGdeQXVyMTkxNjUyNQ@@.UX256.jpg\";}i:73;a:5:{s:2:\"id\";s:9:\"tt2380307\";s:4:\"rank\";s:2:\"74\";s:5:\"title\";s:4:\"Coco\";s:9:\"imdb_rate\";s:3:\"8.3\";s:5:\"image\";s:106:\"/kelaket_images/MV5BYjQ5NjM0Y2YtNjZkNC00ZDhkLWJjMWItN2QyNzFkMDE3ZjAxXkEyXkFqcGdeQXVyODIxMzk5NjA@.UX256.jpg\";}i:74;a:5:{s:2:\"id\";s:9:\"tt0114709\";s:4:\"rank\";s:2:\"75\";s:5:\"title\";s:9:\"Toy Story\";s:9:\"imdb_rate\";s:3:\"8.3\";s:5:\"image\";s:106:\"/kelaket_images/MV5BMDU2ZWJlMjktMTRhMy00ZTA5LWEzNDgtYmNmZTEwZTViZWJkXkEyXkFqcGdeQXVyNDQ2OTk4MzI@.UX256.jpg\";}i:75;a:5:{s:2:\"id\";s:9:\"tt0112573\";s:4:\"rank\";s:2:\"76\";s:5:\"title\";s:10:\"Braveheart\";s:9:\"imdb_rate\";s:3:\"8.3\";s:5:\"image\";s:106:\"/kelaket_images/MV5BMzkzMmU0YTYtOWM3My00YzBmLWI0YzctOGYyNTkwMWE5MTJkXkEyXkFqcGdeQXVyNzkwMjQ5NzM@.UX256.jpg\";}i:76;a:5:{s:2:\"id\";s:9:\"tt0082096\";s:4:\"rank\";s:2:\"77\";s:5:\"title\";s:8:\"The Boat\";s:9:\"imdb_rate\";s:3:\"8.3\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNDBjMWUxNTUtNjZiNi00YzJhLTgzNzUtMTRiY2FkZmMzYTNjXkEyXkFqcGdeQXVyMTUzMDUzNTI3.UX256.jpg\";}i:77;a:5:{s:2:\"id\";s:9:\"tt4154796\";s:4:\"rank\";s:2:\"78\";s:5:\"title\";s:17:\"Avengers: Endgame\";s:9:\"imdb_rate\";s:3:\"8.3\";s:5:\"image\";s:74:\"/kelaket_images/MV5BMTc5MDE2ODcwNV5BMl5BanBnXkFtZTgwMzI2NzQ2NzM@.UX256.jpg\";}i:78;a:5:{s:2:\"id\";s:9:\"tt0119698\";s:4:\"rank\";s:2:\"79\";s:5:\"title\";s:17:\"Princess Mononoke\";s:9:\"imdb_rate\";s:3:\"8.3\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNGIzY2IzODQtNThmMi00ZDE4LWI5YzAtNzNlZTM1ZjYyYjUyXkEyXkFqcGdeQXVyODEzNjM5OTQ@.UX256.jpg\";}i:79;a:5:{s:2:\"id\";s:9:\"tt0087843\";s:4:\"rank\";s:2:\"80\";s:5:\"title\";s:27:\"Once Upon a Time in America\";s:9:\"imdb_rate\";s:3:\"8.3\";s:5:\"image\";s:106:\"/kelaket_images/MV5BMGFkNWI4MTMtNGQ0OC00MWVmLTk3MTktOGYxN2Y2YWVkZWE2XkEyXkFqcGdeQXVyNjU0OTQ0OTY@.UX256.jpg\";}i:80;a:5:{s:2:\"id\";s:9:\"tt0119217\";s:4:\"rank\";s:2:\"81\";s:5:\"title\";s:17:\"Good Will Hunting\";s:9:\"imdb_rate\";s:3:\"8.3\";s:5:\"image\";s:106:\"/kelaket_images/MV5BOTI0MzcxMTYtZDVkMy00NjY1LTgyMTYtZmUxN2M3NmQ2NWJhXkEyXkFqcGdeQXVyMTQxNzMzNDI@.UX256.jpg\";}i:81;a:5:{s:2:\"id\";s:9:\"tt5311514\";s:4:\"rank\";s:2:\"82\";s:5:\"title\";s:10:\"Your Name.\";s:9:\"imdb_rate\";s:3:\"8.3\";s:5:\"image\";s:114:\"/kelaket_images/MV5BODRmZDVmNzUtZDA4ZC00NjhkLWI2M2UtN2M0ZDIzNDcxYThjL2ltYWdlXkEyXkFqcGdeQXVyNTk0MzMzODA@.UX256.jpg\";}i:82;a:5:{s:2:\"id\";s:9:\"tt0180093\";s:4:\"rank\";s:2:\"83\";s:5:\"title\";s:19:\"Requiem for a Dream\";s:9:\"imdb_rate\";s:3:\"8.3\";s:5:\"image\";s:106:\"/kelaket_images/MV5BOTdiNzJlOWUtNWMwNS00NmFlLWI0YTEtZmI3YjIzZWUyY2Y3XkEyXkFqcGdeQXVyNjU0OTQ0OTY@.UX256.jpg\";}i:83;a:5:{s:2:\"id\";s:9:\"tt1745960\";s:4:\"rank\";s:2:\"84\";s:5:\"title\";s:17:\"Top Gun: Maverick\";s:9:\"imdb_rate\";s:3:\"8.3\";s:5:\"image\";s:106:\"/kelaket_images/MV5BZWYzOGEwNTgtNWU3NS00ZTQ0LWJkODUtMmVhMjIwMjA1ZmQwXkEyXkFqcGdeQXVyMjkwOTAyMDU@.UX256.jpg\";}i:84;a:5:{s:2:\"id\";s:9:\"tt0045152\";s:4:\"rank\";s:2:\"85\";s:5:\"title\";s:19:\"Singin\' in the Rain\";s:9:\"imdb_rate\";s:3:\"8.3\";s:5:\"image\";s:106:\"/kelaket_images/MV5BZDRjNGViMjQtOThlMi00MTA3LThkYzQtNzJkYjBkMGE0YzE1XkEyXkFqcGdeQXVyNDYyMDk5MTU@.UX256.jpg\";}i:85;a:5:{s:2:\"id\";s:9:\"tt1187043\";s:4:\"rank\";s:2:\"86\";s:5:\"title\";s:8:\"3 Idiots\";s:9:\"imdb_rate\";s:3:\"8.3\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNTkyOGVjMGEtNmQzZi00NzFlLTlhOWQtODYyMDc2ZGJmYzFhXkEyXkFqcGdeQXVyNjU0OTQ0OTY@.UX256.jpg\";}i:86;a:5:{s:2:\"id\";s:9:\"tt0435761\";s:4:\"rank\";s:2:\"87\";s:5:\"title\";s:11:\"Toy Story 3\";s:9:\"imdb_rate\";s:3:\"8.3\";s:5:\"image\";s:74:\"/kelaket_images/MV5BMTgxOTY4Mjc0MF5BMl5BanBnXkFtZTcwNTA4MDQyMw@@.UX256.jpg\";}i:87;a:5:{s:2:\"id\";s:9:\"tt0057565\";s:4:\"rank\";s:2:\"88\";s:5:\"title\";s:12:\"High and Low\";s:9:\"imdb_rate\";s:3:\"8.3\";s:5:\"image\";s:106:\"/kelaket_images/MV5BZGQ1NWZlYjctNDJmOS00MmU2LTg1ODItNmZiM2ZkNzJhNDI0XkEyXkFqcGdeQXVyNjc1NTYyMjg@.UX256.jpg\";}i:88;a:5:{s:2:\"id\";s:9:\"tt0086190\";s:4:\"rank\";s:2:\"89\";s:5:\"title\";s:42:\"Star Wars: Episode VI - Return of the Jedi\";s:9:\"imdb_rate\";s:3:\"8.3\";s:5:\"image\";s:106:\"/kelaket_images/MV5BOWZlMjFiYzgtMTUzNC00Y2IzLTk1NTMtZmNhMTczNTk0ODk1XkEyXkFqcGdeQXVyNTAyODkwOQ@@.UX256.jpg\";}i:89;a:5:{s:2:\"id\";s:9:\"tt8267604\";s:4:\"rank\";s:2:\"90\";s:5:\"title\";s:9:\"Capernaum\";s:9:\"imdb_rate\";s:3:\"8.3\";s:5:\"image\";s:106:\"/kelaket_images/MV5BY2Y3OWNkMTctYzNjYS00NWVkLTg4OWEtY2YxN2I3NDhlYzE0XkEyXkFqcGdeQXVyMTI3ODAyMzE2.UX256.jpg\";}i:90;a:5:{s:2:\"id\";s:9:\"tt0338013\";s:4:\"rank\";s:2:\"91\";s:5:\"title\";s:37:\"Eternal Sunshine of the Spotless Mind\";s:9:\"imdb_rate\";s:3:\"8.3\";s:5:\"image\";s:74:\"/kelaket_images/MV5BMTY4NzcwODg3Nl5BMl5BanBnXkFtZTcwNTEwOTMyMw@@.UX256.jpg\";}i:91;a:5:{s:2:\"id\";s:9:\"tt0062622\";s:4:\"rank\";s:2:\"92\";s:5:\"title\";s:21:\"2001: A Space Odyssey\";s:9:\"imdb_rate\";s:3:\"8.3\";s:5:\"image\";s:106:\"/kelaket_images/MV5BMmNlYzRiNDctZWNhMi00MzI4LThkZTctMTUzMmZkMmFmNThmXkEyXkFqcGdeQXVyNzkwMjQ5NzM@.UX256.jpg\";}i:92;a:5:{s:2:\"id\";s:9:\"tt0105236\";s:4:\"rank\";s:2:\"93\";s:5:\"title\";s:14:\"Reservoir Dogs\";s:9:\"imdb_rate\";s:3:\"8.3\";s:5:\"image\";s:106:\"/kelaket_images/MV5BZmExNmEwYWItYmQzOS00YjA5LTk2MjktZjEyZDE1Y2QxNjA1XkEyXkFqcGdeQXVyMTQxNzMzNDI@.UX256.jpg\";}i:93;a:5:{s:2:\"id\";s:9:\"tt2106476\";s:4:\"rank\";s:2:\"94\";s:5:\"title\";s:8:\"The Hunt\";s:9:\"imdb_rate\";s:3:\"8.3\";s:5:\"image\";s:74:\"/kelaket_images/MV5BMTg2NDg3ODg4NF5BMl5BanBnXkFtZTcwNzk3NTc3Nw@@.UX256.jpg\";}i:94;a:5:{s:2:\"id\";s:9:\"tt0091251\";s:4:\"rank\";s:2:\"95\";s:5:\"title\";s:12:\"Come and See\";s:9:\"imdb_rate\";s:3:\"8.3\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNzU3OTI1MjItYTJiZC00NDI0LWFlNGYtOTQ1OTVhNDgwM2U3XkEyXkFqcGdeQXVyNTc2MDU0NDE@.UX256.jpg\";}i:95;a:5:{s:2:\"id\";s:9:\"tt0033467\";s:4:\"rank\";s:2:\"96\";s:5:\"title\";s:12:\"Citizen Kane\";s:9:\"imdb_rate\";s:3:\"8.3\";s:5:\"image\";s:106:\"/kelaket_images/MV5BYjBiOTYxZWItMzdiZi00NjlkLWIzZTYtYmFhZjhiMTljOTdkXkEyXkFqcGdeQXVyNzkwMjQ5NzM@.UX256.jpg\";}i:96;a:5:{s:2:\"id\";s:9:\"tt0022100\";s:4:\"rank\";s:2:\"97\";s:5:\"title\";s:1:\"M\";s:9:\"imdb_rate\";s:3:\"8.3\";s:5:\"image\";s:74:\"/kelaket_images/MV5BODA4ODk3OTEzMF5BMl5BanBnXkFtZTgwMTQ2ODMwMzE@.UX256.jpg\";}i:97;a:5:{s:2:\"id\";s:9:\"tt0056172\";s:4:\"rank\";s:2:\"98\";s:5:\"title\";s:18:\"Lawrence of Arabia\";s:9:\"imdb_rate\";s:3:\"8.3\";s:5:\"image\";s:106:\"/kelaket_images/MV5BYWY5ZjhjNGYtZmI2Ny00ODM0LWFkNzgtZmI1YzA2N2MxMzA0XkEyXkFqcGdeQXVyNjUwNzk3NDc@.UX256.jpg\";}i:98;a:5:{s:2:\"id\";s:9:\"tt0053125\";s:4:\"rank\";s:2:\"99\";s:5:\"title\";s:18:\"North by Northwest\";s:9:\"imdb_rate\";s:3:\"8.2\";s:5:\"image\";s:106:\"/kelaket_images/MV5BZDA3NDExMTUtMDlhOC00MmQ5LWExZGUtYmI1NGVlZWI4OWNiXkEyXkFqcGdeQXVyNjc1NTYyMjg@.UX256.jpg\";}i:99;a:5:{s:2:\"id\";s:9:\"tt0052357\";s:4:\"rank\";s:3:\"100\";s:5:\"title\";s:7:\"Vertigo\";s:9:\"imdb_rate\";s:3:\"8.2\";s:5:\"image\";s:122:\"/kelaket_images/MV5BYTE4ODEwZDUtNDFjOC00NjAxLWEzYTQtYTI1NGVmZmFlNjdiL2ltYWdlL2ltYWdlXkEyXkFqcGdeQXVyNjc1NTYyMjg@.UX256.jpg\";}i:100;a:5:{s:2:\"id\";s:9:\"tt0211915\";s:4:\"rank\";s:3:\"101\";s:5:\"title\";s:7:\"Amélie\";s:9:\"imdb_rate\";s:3:\"8.2\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNDg4NjM1YjMtYmNhZC00MjM0LWFiZmYtNGY1YjA3MzZmODc5XkEyXkFqcGdeQXVyNDk3NzU2MTQ@.UX256.jpg\";}i:101;a:5:{s:2:\"id\";s:9:\"tt0053604\";s:4:\"rank\";s:3:\"102\";s:5:\"title\";s:13:\"The Apartment\";s:9:\"imdb_rate\";s:3:\"8.2\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNzkwODFjNzItMmMwNi00MTU5LWE2MzktM2M4ZDczZGM1MmViXkEyXkFqcGdeQXVyNDY2MTk1ODk@.UX256.jpg\";}i:102;a:5:{s:2:\"id\";s:9:\"tt0066921\";s:4:\"rank\";s:3:\"103\";s:5:\"title\";s:18:\"A Clockwork Orange\";s:9:\"imdb_rate\";s:3:\"8.2\";s:5:\"image\";s:74:\"/kelaket_images/MV5BMTY3MjM1Mzc4N15BMl5BanBnXkFtZTgwODM0NzAxMDE@.UX256.jpg\";}i:103;a:5:{s:2:\"id\";s:9:\"tt0044741\";s:4:\"rank\";s:3:\"104\";s:5:\"title\";s:5:\"Ikiru\";s:9:\"imdb_rate\";s:3:\"8.2\";s:5:\"image\";s:106:\"/kelaket_images/MV5BZTcyYmQ2NDMtNWI1NS00MTNiLTk0NDctNWMwNWExYTNlYzk3XkEyXkFqcGdeQXVyMTA0MTM5NjI2.UX256.jpg\";}i:104;a:5:{s:2:\"id\";s:9:\"tt0036775\";s:4:\"rank\";s:3:\"105\";s:5:\"title\";s:16:\"Double Indemnity\";s:9:\"imdb_rate\";s:3:\"8.2\";s:5:\"image\";s:106:\"/kelaket_images/MV5BOTdlNjgyZGUtOTczYi00MDdhLTljZmMtYTEwZmRiOWFkYjRhXkEyXkFqcGdeQXVyNDY2MTk1ODk@.UX256.jpg\";}i:105;a:5:{s:2:\"id\";s:9:\"tt0093058\";s:4:\"rank\";s:3:\"106\";s:5:\"title\";s:17:\"Full Metal Jacket\";s:9:\"imdb_rate\";s:3:\"8.2\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNzkxODk0NjEtYjc4Mi00ZDI0LTgyYjEtYzc1NDkxY2YzYTgyXkEyXkFqcGdeQXVyNzkwMjQ5NzM@.UX256.jpg\";}i:106;a:5:{s:2:\"id\";s:9:\"tt8503618\";s:4:\"rank\";s:3:\"107\";s:5:\"title\";s:8:\"Hamilton\";s:9:\"imdb_rate\";s:3:\"8.2\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNjViNWRjYWEtZTI0NC00N2E3LTk0NGQtMjY4NTM3OGNkZjY0XkEyXkFqcGdeQXVyMjUxMTY3ODM@.UX256.jpg\";}i:107;a:5:{s:2:\"id\";s:9:\"tt0086250\";s:4:\"rank\";s:3:\"108\";s:5:\"title\";s:8:\"Scarface\";s:9:\"imdb_rate\";s:3:\"8.2\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNjdjNGQ4NDEtNTEwYS00MTgxLTliYzQtYzE2ZDRiZjFhZmNlXkEyXkFqcGdeQXVyNjU0OTQ0OTY@.UX256.jpg\";}i:108;a:5:{s:2:\"id\";s:9:\"tt0056592\";s:4:\"rank\";s:3:\"109\";s:5:\"title\";s:21:\"To Kill a Mockingbird\";s:9:\"imdb_rate\";s:3:\"8.2\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNmVmYzcwNzMtMWM1NS00MWIyLThlMDEtYzUwZDgzODE1NmE2XkEyXkFqcGdeQXVyNzkwMjQ5NzM@.UX256.jpg\";}i:109;a:5:{s:2:\"id\";s:9:\"tt0070735\";s:4:\"rank\";s:3:\"110\";s:5:\"title\";s:9:\"The Sting\";s:9:\"imdb_rate\";s:3:\"8.2\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNGU3NjQ4YTMtZGJjOS00YTQ3LThmNmItMTI5MDE2ODI3NzY3XkEyXkFqcGdeQXVyMjUzOTY1NTc@.UX256.jpg\";}i:110;a:5:{s:2:\"id\";s:9:\"tt1255953\";s:4:\"rank\";s:3:\"111\";s:5:\"title\";s:9:\"Incendies\";s:9:\"imdb_rate\";s:3:\"8.2\";s:5:\"image\";s:106:\"/kelaket_images/MV5BMWE3MGYzZjktY2Q5Mi00Y2NiLWIyYWUtMmIyNzA3YmZlMGFhXkEyXkFqcGdeQXVyMTMxODk2OTU@.UX256.jpg\";}i:111;a:5:{s:2:\"id\";s:9:\"tt1049413\";s:4:\"rank\";s:3:\"112\";s:5:\"title\";s:2:\"Up\";s:9:\"imdb_rate\";s:3:\"8.2\";s:5:\"image\";s:74:\"/kelaket_images/MV5BMTk3NDE2NzI4NF5BMl5BanBnXkFtZTgwNzE1MzEyMTE@.UX256.jpg\";}i:112;a:5:{s:2:\"id\";s:9:\"tt0113277\";s:4:\"rank\";s:3:\"113\";s:5:\"title\";s:4:\"Heat\";s:9:\"imdb_rate\";s:3:\"8.2\";s:5:\"image\";s:106:\"/kelaket_images/MV5BYjZjNTJlZGUtZTE1Ny00ZDc4LTgwYjUtMzk0NDgwYzZjYTk1XkEyXkFqcGdeQXVyNjU0OTQ0OTY@.UX256.jpg\";}i:113;a:5:{s:2:\"id\";s:9:\"tt0075314\";s:4:\"rank\";s:3:\"114\";s:5:\"title\";s:11:\"Taxi Driver\";s:9:\"imdb_rate\";s:3:\"8.2\";s:5:\"image\";s:106:\"/kelaket_images/MV5BM2M1MmVhNDgtNmI0YS00ZDNmLTkyNjctNTJiYTQ2N2NmYzc2XkEyXkFqcGdeQXVyNzkwMjQ5NzM@.UX256.jpg\";}i:114;a:5:{s:2:\"id\";s:9:\"tt1832382\";s:4:\"rank\";s:3:\"115\";s:5:\"title\";s:12:\"A Separation\";s:9:\"imdb_rate\";s:3:\"8.2\";s:5:\"image\";s:106:\"/kelaket_images/MV5BN2JmMjViMjMtZTM5Mi00ZGZkLTk5YzctZDg5MjFjZDE4NjNkXkEyXkFqcGdeQXVyMTMxODk2OTU@.UX256.jpg\";}i:115;a:5:{s:2:\"id\";s:9:\"tt0017136\";s:4:\"rank\";s:3:\"116\";s:5:\"title\";s:10:\"Metropolis\";s:9:\"imdb_rate\";s:3:\"8.2\";s:5:\"image\";s:106:\"/kelaket_images/MV5BMTg5YWIyMWUtZDY5My00Zjc1LTljOTctYmI0MWRmY2M2NmRkXkEyXkFqcGdeQXVyMTMxODk2OTU@.UX256.jpg\";}i:116;a:5:{s:2:\"id\";s:9:\"tt0119488\";s:4:\"rank\";s:3:\"117\";s:5:\"title\";s:17:\"L.A. Confidential\";s:9:\"imdb_rate\";s:3:\"8.2\";s:5:\"image\";s:106:\"/kelaket_images/MV5BMDQ2YzEyZGItYWRhOS00MjBmLTkzMDUtMTdjYzkyMmQxZTJlXkEyXkFqcGdeQXVyNjU0OTQ0OTY@.UX256.jpg\";}i:117;a:5:{s:2:\"id\";s:9:\"tt0095016\";s:4:\"rank\";s:3:\"118\";s:5:\"title\";s:8:\"Die Hard\";s:9:\"imdb_rate\";s:3:\"8.2\";s:5:\"image\";s:106:\"/kelaket_images/MV5BZjRlNDUxZjAtOGQ4OC00OTNlLTgxNmQtYTBmMDgwZmNmNjkxXkEyXkFqcGdeQXVyNzkwMjQ5NzM@.UX256.jpg\";}i:118;a:5:{s:2:\"id\";s:9:\"tt0208092\";s:4:\"rank\";s:3:\"119\";s:5:\"title\";s:6:\"Snatch\";s:9:\"imdb_rate\";s:3:\"8.2\";s:5:\"image\";s:106:\"/kelaket_images/MV5BMTA2NDYxOGYtYjU1Mi00Y2QzLTgxMTQtMWI1MGI0ZGQ5MmU4XkEyXkFqcGdeQXVyNDk3NzU2MTQ@.UX256.jpg\";}i:119;a:5:{s:2:\"id\";s:9:\"tt0097576\";s:4:\"rank\";s:3:\"120\";s:5:\"title\";s:34:\"Indiana Jones and the Last Crusade\";s:9:\"imdb_rate\";s:3:\"8.2\";s:5:\"image\";s:106:\"/kelaket_images/MV5BY2Q0ODg4ZmItNDZiYi00ZWY5LTg2NzctNmYwZjA5OThmNzE1XkEyXkFqcGdeQXVyMjM4MzQ4OTQ@.UX256.jpg\";}i:120;a:5:{s:2:\"id\";s:9:\"tt0040522\";s:4:\"rank\";s:3:\"121\";s:5:\"title\";s:15:\"Bicycle Thieves\";s:9:\"imdb_rate\";s:3:\"8.2\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNmI1ODdjODctMDlmMC00ZWViLWI5MzYtYzRhNDdjYmM3MzFjXkEyXkFqcGdeQXVyMTMxODk2OTU@.UX256.jpg\";}i:121;a:5:{s:2:\"id\";s:9:\"tt0986264\";s:4:\"rank\";s:3:\"122\";s:5:\"title\";s:19:\"Like Stars on Earth\";s:9:\"imdb_rate\";s:3:\"8.2\";s:5:\"image\";s:106:\"/kelaket_images/MV5BMDhjZWViN2MtNzgxOS00NmI4LThiZDQtZDI3MzM4MDE4NTc0XkEyXkFqcGdeQXVyMTMxODk2OTU@.UX256.jpg\";}i:122;a:5:{s:2:\"id\";s:9:\"tt8579674\";s:4:\"rank\";s:3:\"123\";s:5:\"title\";s:4:\"1917\";s:9:\"imdb_rate\";s:3:\"8.2\";s:5:\"image\";s:106:\"/kelaket_images/MV5BOTdmNTFjNDEtNzg0My00ZjkxLTg1ZDAtZTdkMDc2ZmFiNWQ1XkEyXkFqcGdeQXVyNTAzNzgwNTg@.UX256.jpg\";}i:123;a:5:{s:2:\"id\";s:9:\"tt0363163\";s:4:\"rank\";s:3:\"124\";s:5:\"title\";s:8:\"Downfall\";s:9:\"imdb_rate\";s:3:\"8.2\";s:5:\"image\";s:70:\"/kelaket_images/MV5BMTU0NTU5NTAyMl5BMl5BanBnXkFtZTYwNzYwMDg2.UX256.jpg\";}i:124;a:5:{s:2:\"id\";s:9:\"tt0059578\";s:4:\"rank\";s:3:\"125\";s:5:\"title\";s:22:\"For a Few Dollars More\";s:9:\"imdb_rate\";s:3:\"8.2\";s:5:\"image\";s:106:\"/kelaket_images/MV5BMzJlZTNkYjQtMTE1OS00YTJlLTgxNjItYzg4NTllODdkMzBiXkEyXkFqcGdeQXVyMjUzOTY1NTc@.UX256.jpg\";}i:125;a:5:{s:2:\"id\";s:9:\"tt5074352\";s:4:\"rank\";s:3:\"126\";s:5:\"title\";s:6:\"Dangal\";s:9:\"imdb_rate\";s:3:\"8.2\";s:5:\"image\";s:74:\"/kelaket_images/MV5BMTQ4MzQzMzM2Nl5BMl5BanBnXkFtZTgwMTQ1NzU3MDI@.UX256.jpg\";}i:126;a:5:{s:2:\"id\";s:9:\"tt0372784\";s:4:\"rank\";s:3:\"127\";s:5:\"title\";s:13:\"Batman Begins\";s:9:\"imdb_rate\";s:3:\"8.2\";s:5:\"image\";s:106:\"/kelaket_images/MV5BOTY4YjI2N2MtYmFlMC00ZjcyLTg3YjEtMDQyM2ZjYzQ5YWFkXkEyXkFqcGdeQXVyMTQxNzMzNDI@.UX256.jpg\";}i:127;a:5:{s:2:\"id\";s:9:\"tt0012349\";s:4:\"rank\";s:3:\"128\";s:5:\"title\";s:7:\"The Kid\";s:9:\"imdb_rate\";s:3:\"8.2\";s:5:\"image\";s:106:\"/kelaket_images/MV5BZjhhMThhNDItNTY2MC00MmU1LTliNDEtNDdhZjdlNTY5ZDQ1XkEyXkFqcGdeQXVyNjc1NTYyMjg@.UX256.jpg\";}i:128;a:5:{s:2:\"id\";s:9:\"tt0053291\";s:4:\"rank\";s:3:\"129\";s:5:\"title\";s:16:\"Some Like It Hot\";s:9:\"imdb_rate\";s:3:\"8.2\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNzAyOGIxYjAtMGY2NC00ZTgyLWIwMWEtYzY0OWQ4NDFjOTc5XkEyXkFqcGdeQXVyNjU0OTQ0OTY@.UX256.jpg\";}i:129;a:5:{s:2:\"id\";s:10:\"tt10272386\";s:4:\"rank\";s:3:\"130\";s:5:\"title\";s:10:\"The Father\";s:9:\"imdb_rate\";s:3:\"8.2\";s:5:\"image\";s:106:\"/kelaket_images/MV5BZGJhNWRiOWQtMjI4OS00ZjcxLTgwMTAtMzQ2ODkxY2JkOTVlXkEyXkFqcGdeQXVyMTkxNjUyNQ@@.UX256.jpg\";}i:130;a:5:{s:2:\"id\";s:9:\"tt0042192\";s:4:\"rank\";s:3:\"131\";s:5:\"title\";s:13:\"All About Eve\";s:9:\"imdb_rate\";s:3:\"8.2\";s:5:\"image\";s:74:\"/kelaket_images/MV5BMTY2MTAzODI5NV5BMl5BanBnXkFtZTgwMjM4NzQ0MjE@.UX256.jpg\";}i:131;a:5:{s:2:\"id\";s:9:\"tt6966692\";s:4:\"rank\";s:3:\"132\";s:5:\"title\";s:10:\"Green Book\";s:9:\"imdb_rate\";s:3:\"8.2\";s:5:\"image\";s:106:\"/kelaket_images/MV5BYzIzYmJlYTYtNGNiYy00N2EwLTk4ZjItMGYyZTJiOTVkM2RlXkEyXkFqcGdeQXVyODY1NDk1NjE@.UX256.jpg\";}i:132;a:5:{s:2:\"id\";s:9:\"tt0993846\";s:4:\"rank\";s:3:\"133\";s:5:\"title\";s:23:\"The Wolf of Wall Street\";s:9:\"imdb_rate\";s:3:\"8.2\";s:5:\"image\";s:74:\"/kelaket_images/MV5BMjIxMjgxNTk0MF5BMl5BanBnXkFtZTgwNjIyOTg2MDE@.UX256.jpg\";}i:133;a:5:{s:2:\"id\";s:9:\"tt0055031\";s:4:\"rank\";s:3:\"134\";s:5:\"title\";s:21:\"Judgment at Nuremberg\";s:9:\"imdb_rate\";s:3:\"8.2\";s:5:\"image\";s:74:\"/kelaket_images/MV5BNDc2ODQ5NTE2MV5BMl5BanBnXkFtZTcwODExMjUyNA@@.UX256.jpg\";}i:134;a:5:{s:2:\"id\";s:9:\"tt0089881\";s:4:\"rank\";s:3:\"135\";s:5:\"title\";s:3:\"Ran\";s:9:\"imdb_rate\";s:3:\"8.2\";s:5:\"image\";s:106:\"/kelaket_images/MV5BMmU1NGYwZWYtOWExNi00ZTEyLTgwMmUtM2ZlMDVjNWM4YjVlXkEyXkFqcGdeQXVyMjUzOTY1NTc@.UX256.jpg\";}i:135;a:5:{s:2:\"id\";s:9:\"tt0112641\";s:4:\"rank\";s:3:\"136\";s:5:\"title\";s:6:\"Casino\";s:9:\"imdb_rate\";s:3:\"8.2\";s:5:\"image\";s:106:\"/kelaket_images/MV5BMTcxOWYzNDYtYmM4YS00N2NkLTk0NTAtNjg1ODgwZjAxYzI3XkEyXkFqcGdeQXVyNTA4NzY1MzY@.UX256.jpg\";}i:136;a:5:{s:2:\"id\";s:9:\"tt0457430\";s:4:\"rank\";s:3:\"137\";s:5:\"title\";s:15:\"Pan\'s Labyrinth\";s:9:\"imdb_rate\";s:3:\"8.2\";s:5:\"image\";s:106:\"/kelaket_images/MV5BYzFjMThiMGItOWRlMC00MDI4LThmOGUtYTNlZGZiYWI1YjMyXkEyXkFqcGdeQXVyMjUzOTY1NTc@.UX256.jpg\";}i:137;a:5:{s:2:\"id\";s:9:\"tt0105695\";s:4:\"rank\";s:3:\"138\";s:5:\"title\";s:10:\"Unforgiven\";s:9:\"imdb_rate\";s:3:\"8.2\";s:5:\"image\";s:106:\"/kelaket_images/MV5BODM3YWY4NmQtN2Y3Ni00OTg0LWFhZGQtZWE3ZWY4MTJlOWU4XkEyXkFqcGdeQXVyNjU0OTQ0OTY@.UX256.jpg\";}i:138;a:5:{s:2:\"id\";s:9:\"tt0469494\";s:4:\"rank\";s:3:\"139\";s:5:\"title\";s:19:\"There Will Be Blood\";s:9:\"imdb_rate\";s:3:\"8.2\";s:5:\"image\";s:74:\"/kelaket_images/MV5BMjAxODQ4MDU5NV5BMl5BanBnXkFtZTcwMDU4MjU1MQ@@.UX256.jpg\";}i:139;a:5:{s:2:\"id\";s:9:\"tt0120382\";s:4:\"rank\";s:3:\"140\";s:5:\"title\";s:15:\"The Truman Show\";s:9:\"imdb_rate\";s:3:\"8.2\";s:5:\"image\";s:106:\"/kelaket_images/MV5BMDIzODcyY2EtMmY2MC00ZWVlLTgwMzAtMjQwOWUyNmJjNTYyXkEyXkFqcGdeQXVyNDk3NzU2MTQ@.UX256.jpg\";}i:140;a:5:{s:2:\"id\";s:9:\"tt0167404\";s:4:\"rank\";s:3:\"141\";s:5:\"title\";s:15:\"The Sixth Sense\";s:9:\"imdb_rate\";s:3:\"8.2\";s:5:\"image\";s:106:\"/kelaket_images/MV5BMWM4NTFhYjctNzUyNi00NGMwLTk3NTYtMDIyNTZmMzRlYmQyXkEyXkFqcGdeQXVyMTAwMzUyOTc@.UX256.jpg\";}i:141;a:5:{s:2:\"id\";s:9:\"tt0268978\";s:4:\"rank\";s:3:\"142\";s:5:\"title\";s:16:\"A Beautiful Mind\";s:9:\"imdb_rate\";s:3:\"8.2\";s:5:\"image\";s:106:\"/kelaket_images/MV5BMzcwYWFkYzktZjAzNC00OGY1LWI4YTgtNzc5MzVjMDVmNjY0XkEyXkFqcGdeQXVyMTQxNzMzNDI@.UX256.jpg\";}i:142;a:5:{s:2:\"id\";s:9:\"tt1130884\";s:4:\"rank\";s:3:\"143\";s:5:\"title\";s:14:\"Shutter Island\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:106:\"/kelaket_images/MV5BYzhiNDkyNzktNTZmYS00ZTBkLTk2MDAtM2U0YjU1MzgxZjgzXkEyXkFqcGdeQXVyMTMxODk2OTU@.UX256.jpg\";}i:143;a:5:{s:2:\"id\";s:9:\"tt0055630\";s:4:\"rank\";s:3:\"144\";s:5:\"title\";s:7:\"Yojimbo\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:106:\"/kelaket_images/MV5BZThiZjAzZjgtNDU3MC00YThhLThjYWUtZGRkYjc2ZWZlOTVjXkEyXkFqcGdeQXVyNTA4NzY1MzY@.UX256.jpg\";}i:144;a:5:{s:2:\"id\";s:9:\"tt0040897\";s:4:\"rank\";s:3:\"145\";s:5:\"title\";s:32:\"The Treasure of the Sierra Madre\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:106:\"/kelaket_images/MV5BOTJlZWMxYzEtMjlkMS00ODE0LThlM2ItMDI3NGQ2YjhmMzkxXkEyXkFqcGdeQXVyMDI2NDg0NQ@@.UX256.jpg\";}i:145;a:5:{s:2:\"id\";s:9:\"tt0071853\";s:4:\"rank\";s:3:\"146\";s:5:\"title\";s:31:\"Monty Python and the Holy Grail\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:106:\"/kelaket_images/MV5BN2IyNTE4YzUtZWU0Mi00MGIwLTgyMmQtMzQ4YzQxYWNlYWE2XkEyXkFqcGdeQXVyNjU0OTQ0OTY@.UX256.jpg\";}i:146;a:5:{s:2:\"id\";s:10:\"tt10872600\";s:4:\"rank\";s:3:\"147\";s:5:\"title\";s:23:\"Spider-Man: No Way Home\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:106:\"/kelaket_images/MV5BZWMyYzFjYTYtNTRjYi00OGExLWE2YzgtOGRmYjAxZTU3NzBiXkEyXkFqcGdeQXVyMzQ0MzA0NTM@.UX256.jpg\";}i:147;a:5:{s:2:\"id\";s:9:\"tt0107290\";s:4:\"rank\";s:3:\"148\";s:5:\"title\";s:13:\"Jurassic Park\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:74:\"/kelaket_images/MV5BMjM2MDgxMDg0Nl5BMl5BanBnXkFtZTgwNTM2OTM5NDE@.UX256.jpg\";}i:148;a:5:{s:2:\"id\";s:9:\"tt0057115\";s:4:\"rank\";s:3:\"149\";s:5:\"title\";s:16:\"The Great Escape\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNzA2NmYxMWUtNzBlMC00MWM2LTkwNmQtYTFlZjQwODNhOWE0XkEyXkFqcGdeQXVyNTIzOTk5ODM@.UX256.jpg\";}i:149;a:5:{s:2:\"id\";s:9:\"tt0042876\";s:4:\"rank\";s:3:\"150\";s:5:\"title\";s:8:\"Rashomon\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:74:\"/kelaket_images/MV5BMjEzMzA4NDE2OF5BMl5BanBnXkFtZTcwNTc5MDI2NQ@@.UX256.jpg\";}i:150;a:5:{s:2:\"id\";s:9:\"tt0266697\";s:4:\"rank\";s:3:\"151\";s:5:\"title\";s:17:\"Kill Bill: Vol. 1\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNzM3NDFhYTAtYmU5Mi00NGRmLTljYjgtMDkyODQ4MjNkMGY2XkEyXkFqcGdeQXVyNzkwMjQ5NzM@.UX256.jpg\";}i:151;a:5:{s:2:\"id\";s:9:\"tt0477348\";s:4:\"rank\";s:3:\"152\";s:5:\"title\";s:22:\"No Country for Old Men\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:74:\"/kelaket_images/MV5BMjA5Njk3MjM4OV5BMl5BanBnXkFtZTcwMTc5MTE1MQ@@.UX256.jpg\";}i:152;a:5:{s:2:\"id\";s:9:\"tt0084787\";s:4:\"rank\";s:3:\"153\";s:5:\"title\";s:9:\"The Thing\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNGViZWZmM2EtNGYzZi00ZDAyLTk3ODMtNzIyZTBjN2Y1NmM1XkEyXkFqcGdeQXVyNTAyODkwOQ@@.UX256.jpg\";}i:153;a:5:{s:2:\"id\";s:9:\"tt0266543\";s:4:\"rank\";s:3:\"154\";s:5:\"title\";s:12:\"Finding Nemo\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:106:\"/kelaket_images/MV5BZTAzNWZlNmUtZDEzYi00ZjA5LWIwYjEtZGM1NWE1MjE4YWRhXkEyXkFqcGdeQXVyNjU0OTQ0OTY@.UX256.jpg\";}i:154;a:5:{s:2:\"id\";s:9:\"tt0080678\";s:4:\"rank\";s:3:\"155\";s:5:\"title\";s:16:\"The Elephant Man\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:106:\"/kelaket_images/MV5BMDVjNjIwOGItNDE3Ny00OThjLWE0NzQtZTU3YjMzZTZjMzhkXkEyXkFqcGdeQXVyMTQxNzMzNDI@.UX256.jpg\";}i:155;a:5:{s:2:\"id\";s:9:\"tt0071315\";s:4:\"rank\";s:3:\"156\";s:5:\"title\";s:9:\"Chinatown\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:106:\"/kelaket_images/MV5BMjJkMDZhYzItZTFhMi00ZGI4LThlNTAtZDNlYmEwNjFkNDYzXkEyXkFqcGdeQXVyMjUzOTY1NTc@.UX256.jpg\";}i:156;a:5:{s:2:\"id\";s:9:\"tt0081398\";s:4:\"rank\";s:3:\"157\";s:5:\"title\";s:11:\"Raging Bull\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:106:\"/kelaket_images/MV5BYjRmODkzNDItMTNhNi00YjJlLTg0ZjAtODlhZTM0YzgzYThlXkEyXkFqcGdeQXVyNzQ1ODk3MTQ@.UX256.jpg\";}i:157;a:5:{s:2:\"id\";s:9:\"tt0434409\";s:4:\"rank\";s:3:\"158\";s:5:\"title\";s:14:\"V for Vendetta\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:74:\"/kelaket_images/MV5BOTI5ODc3NzExNV5BMl5BanBnXkFtZTcwNzYxNzQzMw@@.UX256.jpg\";}i:158;a:5:{s:2:\"id\";s:9:\"tt0031381\";s:4:\"rank\";s:3:\"159\";s:5:\"title\";s:18:\"Gone with the Wind\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:106:\"/kelaket_images/MV5BYjUyZWZkM2UtMzYxYy00ZmQ3LWFmZTQtOGE2YjBkNjA3YWZlXkEyXkFqcGdeQXVyNzkwMjQ5NzM@.UX256.jpg\";}i:159;a:5:{s:2:\"id\";s:9:\"tt2096673\";s:4:\"rank\";s:3:\"160\";s:5:\"title\";s:10:\"Inside Out\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:74:\"/kelaket_images/MV5BOTgxMDQwMDk0OF5BMl5BanBnXkFtZTgwNjU5OTg2NDE@.UX256.jpg\";}i:160;a:5:{s:2:\"id\";s:9:\"tt0120735\";s:4:\"rank\";s:3:\"161\";s:5:\"title\";s:35:\"Lock, Stock and Two Smoking Barrels\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:106:\"/kelaket_images/MV5BMTAyN2JmZmEtNjAyMy00NzYwLThmY2MtYWQ3OGNhNjExMmM4XkEyXkFqcGdeQXVyNDk3NzU2MTQ@.UX256.jpg\";}i:161;a:5:{s:2:\"id\";s:9:\"tt0046912\";s:4:\"rank\";s:3:\"162\";s:5:\"title\";s:17:\"Dial M for Murder\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:114:\"/kelaket_images/MV5BOWIwODIxYWItZDI4MS00YzhhLWE3MmYtMzlhZDIwOTMzZmE5L2ltYWdlXkEyXkFqcGdeQXVyNjc1NTYyMjg@.UX256.jpg\";}i:162;a:5:{s:2:\"id\";s:9:\"tt1305806\";s:4:\"rank\";s:3:\"163\";s:5:\"title\";s:24:\"The Secret in Their Eyes\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:106:\"/kelaket_images/MV5BY2FhZGI5M2QtZWFiZS00NjkwLWE4NWQtMzg3ZDZjNjdkYTJiXkEyXkFqcGdeQXVyMTMxODk2OTU@.UX256.jpg\";}i:163;a:5:{s:2:\"id\";s:9:\"tt0347149\";s:4:\"rank\";s:3:\"164\";s:5:\"title\";s:20:\"Howl\'s Moving Castle\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:74:\"/kelaket_images/MV5BMTY1OTg0MjE3MV5BMl5BanBnXkFtZTcwNTUxMTkyMQ@@.UX256.jpg\";}i:164;a:5:{s:2:\"id\";s:9:\"tt0050212\";s:4:\"rank\";s:3:\"165\";s:5:\"title\";s:28:\"The Bridge on the River Kwai\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:106:\"/kelaket_images/MV5BOGY5NmNlMmQtYzRlYy00NGQ5LWFkYjYtNzExZmQyMTg0ZDA0XkEyXkFqcGdeQXVyNDIzMzcwNjc@.UX256.jpg\";}i:165;a:5:{s:2:\"id\";s:9:\"tt5027774\";s:4:\"rank\";s:3:\"166\";s:5:\"title\";s:41:\"Three Billboards Outside Ebbing, Missouri\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:74:\"/kelaket_images/MV5BMjI0ODcxNzM1N15BMl5BanBnXkFtZTgwMzIwMTEwNDI@.UX256.jpg\";}i:166;a:5:{s:2:\"id\";s:9:\"tt0117951\";s:4:\"rank\";s:3:\"167\";s:5:\"title\";s:13:\"Trainspotting\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:106:\"/kelaket_images/MV5BMzA5Zjc3ZTMtMmU5YS00YTMwLWI4MWUtYTU0YTVmNjVmODZhXkEyXkFqcGdeQXVyNjU0OTQ0OTY@.UX256.jpg\";}i:167;a:5:{s:2:\"id\";s:9:\"tt1291584\";s:4:\"rank\";s:3:\"168\";s:5:\"title\";s:7:\"Warrior\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:74:\"/kelaket_images/MV5BMTk4ODk5MTMyNV5BMl5BanBnXkFtZTcwMDMyNTg0Ng@@.UX256.jpg\";}i:168;a:5:{s:2:\"id\";s:9:\"tt1392214\";s:4:\"rank\";s:3:\"169\";s:5:\"title\";s:9:\"Prisoners\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:74:\"/kelaket_images/MV5BMTg0NTIzMjQ1NV5BMl5BanBnXkFtZTcwNDc3MzM5OQ@@.UX256.jpg\";}i:169;a:5:{s:2:\"id\";s:9:\"tt0116282\";s:4:\"rank\";s:3:\"170\";s:5:\"title\";s:5:\"Fargo\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNDJiZDgyZjctYmRjMS00ZjdkLTkwMTEtNGU1NDg3NDQ0Yzk1XkEyXkFqcGdeQXVyNzkwMjQ5NzM@.UX256.jpg\";}i:170;a:5:{s:2:\"id\";s:9:\"tt1205489\";s:4:\"rank\";s:3:\"171\";s:5:\"title\";s:11:\"Gran Torino\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:74:\"/kelaket_images/MV5BMTc5NTk2OTU1Nl5BMl5BanBnXkFtZTcwMDc3NjAwMg@@.UX256.jpg\";}i:171;a:5:{s:2:\"id\";s:9:\"tt0096283\";s:4:\"rank\";s:3:\"172\";s:5:\"title\";s:18:\"My Neighbor Totoro\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:106:\"/kelaket_images/MV5BYzJjMTYyMjQtZDI0My00ZjE2LTkyNGYtOTllNGQxNDMyZjE0XkEyXkFqcGdeQXVyMTMxODk2OTU@.UX256.jpg\";}i:172;a:5:{s:2:\"id\";s:9:\"tt0264464\";s:4:\"rank\";s:3:\"173\";s:5:\"title\";s:19:\"Catch Me If You Can\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:70:\"/kelaket_images/MV5BMTY5MzYzNjc5NV5BMl5BanBnXkFtZTYwNTUyNTc2.UX256.jpg\";}i:173;a:5:{s:2:\"id\";s:9:\"tt0405159\";s:4:\"rank\";s:3:\"174\";s:5:\"title\";s:19:\"Million Dollar Baby\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:74:\"/kelaket_images/MV5BMTkxNzA1NDQxOV5BMl5BanBnXkFtZTcwNTkyMTIzMw@@.UX256.jpg\";}i:174;a:5:{s:2:\"id\";s:9:\"tt0118849\";s:4:\"rank\";s:3:\"175\";s:5:\"title\";s:18:\"Children of Heaven\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:106:\"/kelaket_images/MV5BZTYwZWQ4ZTQtZWU0MS00N2YwLWEzMDItZWFkZWY0MWVjODVhXkEyXkFqcGdeQXVyNjU0OTQ0OTY@.UX256.jpg\";}i:175;a:5:{s:2:\"id\";s:9:\"tt0083658\";s:4:\"rank\";s:3:\"176\";s:5:\"title\";s:12:\"Blade Runner\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNzQzMzJhZTEtOWM4NS00MTdhLTg0YjgtMjM4MDRkZjUwZDBlXkEyXkFqcGdeQXVyNjU0OTQ0OTY@.UX256.jpg\";}i:176;a:5:{s:2:\"id\";s:9:\"tt0015864\";s:4:\"rank\";s:3:\"177\";s:5:\"title\";s:13:\"The Gold Rush\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:114:\"/kelaket_images/MV5BZjEyOTE4MzMtNmMzMy00Mzc3LWJlOTQtOGJiNDE0ZmJiOTU4L2ltYWdlXkEyXkFqcGdeQXVyNTAyODkwOQ@@.UX256.jpg\";}i:177;a:5:{s:2:\"id\";s:9:\"tt0047296\";s:4:\"rank\";s:3:\"178\";s:5:\"title\";s:17:\"On the Waterfront\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:106:\"/kelaket_images/MV5BY2I0MWFiZDMtNWQyYy00Njk5LTk3MDktZjZjNTNmZmVkYjkxXkEyXkFqcGdeQXVyNjc1NTYyMjg@.UX256.jpg\";}i:178;a:5:{s:2:\"id\";s:9:\"tt0112471\";s:4:\"rank\";s:3:\"179\";s:5:\"title\";s:14:\"Before Sunrise\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:106:\"/kelaket_images/MV5BZDdiZTAwYzAtMDI3Ni00OTRjLTkzN2UtMGE3MDMyZmU4NTU4XkEyXkFqcGdeQXVyNjU0OTQ0OTY@.UX256.jpg\";}i:179;a:5:{s:2:\"id\";s:9:\"tt2024544\";s:4:\"rank\";s:3:\"180\";s:5:\"title\";s:16:\"12 Years a Slave\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:74:\"/kelaket_images/MV5BMjExMTEzODkyN15BMl5BanBnXkFtZTcwNTU4NTc4OQ@@.UX256.jpg\";}i:180;a:5:{s:2:\"id\";s:9:\"tt1201607\";s:4:\"rank\";s:3:\"181\";s:5:\"title\";s:44:\"Harry Potter and the Deathly Hallows: Part 2\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:106:\"/kelaket_images/MV5BMGVmMWNiMDktYjQ0Mi00MWIxLTk0N2UtN2ZlYTdkN2IzNDNlXkEyXkFqcGdeQXVyODE5NzE3OTE@.UX256.jpg\";}i:181;a:5:{s:2:\"id\";s:9:\"tt0052618\";s:4:\"rank\";s:3:\"182\";s:5:\"title\";s:7:\"Ben-Hur\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:122:\"/kelaket_images/MV5BNjgxY2JiZDYtZmMwOC00ZmJjLWJmODUtMTNmNWNmYWI5ODkwL2ltYWdlL2ltYWdlXkEyXkFqcGdeQXVyNjc1NTYyMjg@.UX256.jpg\";}i:182;a:5:{s:2:\"id\";s:9:\"tt0050986\";s:4:\"rank\";s:3:\"183\";s:5:\"title\";s:17:\"Wild Strawberries\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:106:\"/kelaket_images/MV5BYWQxYzdhMDMtNjAyZC00NzE0LWFjYmQtYjk0YzMyYjA5NzZkXkEyXkFqcGdeQXVyMjUzOTY1NTc@.UX256.jpg\";}i:183;a:5:{s:2:\"id\";s:9:\"tt2267998\";s:4:\"rank\";s:3:\"184\";s:5:\"title\";s:9:\"Gone Girl\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:74:\"/kelaket_images/MV5BMTk0MDQ3MzAzOV5BMl5BanBnXkFtZTgwNzU1NzE3MjE@.UX256.jpg\";}i:184;a:5:{s:2:\"id\";s:9:\"tt0041959\";s:4:\"rank\";s:3:\"185\";s:5:\"title\";s:13:\"The Third Man\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:106:\"/kelaket_images/MV5BYjE2OTdhMWUtOGJlMy00ZDViLWIzZjgtYjZkZGZmMDZjYmEyXkEyXkFqcGdeQXVyNzkwMjQ5NzM@.UX256.jpg\";}i:185;a:5:{s:2:\"id\";s:9:\"tt0017925\";s:4:\"rank\";s:3:\"186\";s:5:\"title\";s:11:\"The General\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:106:\"/kelaket_images/MV5BYmRiMDFlYjYtOTMwYy00OGY2LWE0Y2QtYzQxOGNhZmUwNTIxXkEyXkFqcGdeQXVyNzkwMjQ5NzM@.UX256.jpg\";}i:186;a:5:{s:2:\"id\";s:9:\"tt2278388\";s:4:\"rank\";s:3:\"187\";s:5:\"title\";s:24:\"The Grand Budapest Hotel\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:74:\"/kelaket_images/MV5BMzM5NjUxOTEyMl5BMl5BanBnXkFtZTgwNjEyMDM0MDE@.UX256.jpg\";}i:187;a:5:{s:2:\"id\";s:9:\"tt4729430\";s:4:\"rank\";s:3:\"188\";s:5:\"title\";s:5:\"Klaus\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:106:\"/kelaket_images/MV5BMWYwOThjM2ItZGYxNy00NTQwLWFlZWEtM2MzM2Q5MmY3NDU5XkEyXkFqcGdeQXVyMTkxNjUyNQ@@.UX256.jpg\";}i:188;a:5:{s:2:\"id\";s:9:\"tt0077416\";s:4:\"rank\";s:3:\"189\";s:5:\"title\";s:15:\"The Deer Hunter\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNDhmNTA0ZDMtYjhkNS00NzEzLWIzYTItOGNkMTVmYjE2YmI3XkEyXkFqcGdeQXVyNzkwMjQ5NzM@.UX256.jpg\";}i:189;a:5:{s:2:\"id\";s:9:\"tt0107207\";s:4:\"rank\";s:3:\"190\";s:5:\"title\";s:25:\"In the Name of the Father\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:106:\"/kelaket_images/MV5BMmYyOTgwYWItYmU3Ny00M2E2LTk0NWMtMDVlNmQ0MWZiMTMxXkEyXkFqcGdeQXVyNzkwMjQ5NzM@.UX256.jpg\";}i:190;a:5:{s:2:\"id\";s:9:\"tt0046268\";s:4:\"rank\";s:3:\"191\";s:5:\"title\";s:17:\"The Wages of Fear\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:106:\"/kelaket_images/MV5BZDdkNzMwZmUtY2Q5MS00ZmM2LWJhYjItYTBjMWY0MGM4MDRjXkEyXkFqcGdeQXVyNTA4NzY1MzY@.UX256.jpg\";}i:191;a:5:{s:2:\"id\";s:9:\"tt0072684\";s:4:\"rank\";s:3:\"192\";s:5:\"title\";s:12:\"Barry Lyndon\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNmY0MWY2NDctZDdmMi00MjA1LTk0ZTQtZDMyZTQ1NTNlYzVjXkEyXkFqcGdeQXVyMjUzOTY1NTc@.UX256.jpg\";}i:192;a:5:{s:2:\"id\";s:9:\"tt2119532\";s:4:\"rank\";s:3:\"193\";s:5:\"title\";s:13:\"Hacksaw Ridge\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:74:\"/kelaket_images/MV5BMjQ1NjM3MTUxNV5BMl5BanBnXkFtZTgwMDc5MTY5OTE@.UX256.jpg\";}i:193;a:5:{s:2:\"id\";s:9:\"tt0015324\";s:4:\"rank\";s:3:\"194\";s:5:\"title\";s:12:\"Sherlock Jr.\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:106:\"/kelaket_images/MV5BZWFhOGU5NDctY2Q3YS00Y2VlLWI1NzEtZmIwY2ZiZjY4OTA2XkEyXkFqcGdeQXVyMDI2NDg0NQ@@.UX256.jpg\";}i:194;a:5:{s:2:\"id\";s:9:\"tt0031679\";s:4:\"rank\";s:3:\"195\";s:5:\"title\";s:28:\"Mr. Smith Goes to Washington\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:114:\"/kelaket_images/MV5BZTYwYjYxYzgtMDE1Ni00NzU4LWJlMTEtODQ5YmJmMGJhZjI5L2ltYWdlXkEyXkFqcGdeQXVyMDI2NDg0NQ@@.UX256.jpg\";}i:195;a:5:{s:2:\"id\";s:9:\"tt0353969\";s:4:\"rank\";s:3:\"196\";s:5:\"title\";s:18:\"Memories of Murder\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:106:\"/kelaket_images/MV5BOGViNTg4YTktYTQ2Ni00MTU0LTk2NWUtMTI4OTc1YTM0NzQ2XkEyXkFqcGdeQXVyMDM2NDM2MQ@@.UX256.jpg\";}i:196;a:5:{s:2:\"id\";s:9:\"tt3011894\";s:4:\"rank\";s:3:\"197\";s:5:\"title\";s:10:\"Wild Tales\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNGQzY2Y0MTgtMDA4OC00NjM3LWI0ZGQtNTJlM2UxZDQxZjI0XkEyXkFqcGdeQXVyNDUzOTQ5MjY@.UX256.jpg\";}i:197;a:5:{s:2:\"id\";s:9:\"tt0050976\";s:4:\"rank\";s:3:\"198\";s:5:\"title\";s:16:\"The Seventh Seal\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:106:\"/kelaket_images/MV5BOWM3MmE0OGYtOGVlNC00OWE1LTk5ZTAtYmUwMDIwM2ZlNWJiXkEyXkFqcGdeQXVyMjUzOTY1NTc@.UX256.jpg\";}i:198;a:5:{s:2:\"id\";s:9:\"tt1392190\";s:4:\"rank\";s:3:\"199\";s:5:\"title\";s:18:\"Mad Max: Fury Road\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:106:\"/kelaket_images/MV5BN2EwM2I5OWMtMGQyMi00Zjg1LWJkNTctZTdjYTA4OGUwZjMyXkEyXkFqcGdeQXVyMTMxODk2OTU@.UX256.jpg\";}i:199;a:5:{s:2:\"id\";s:9:\"tt3170832\";s:4:\"rank\";s:3:\"200\";s:5:\"title\";s:4:\"Room\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:74:\"/kelaket_images/MV5BMjE4NzgzNzEwMl5BMl5BanBnXkFtZTgwMTMzMDE0NjE@.UX256.jpg\";}i:200;a:5:{s:2:\"id\";s:9:\"tt0978762\";s:4:\"rank\";s:3:\"201\";s:5:\"title\";s:12:\"Mary and Max\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:114:\"/kelaket_images/MV5BMDgzYjQwMDMtNGUzYi00MTRmLWIyMGMtNjE1OGZkNzY2YWIzL2ltYWdlXkEyXkFqcGdeQXVyNjU0OTQ0OTY@.UX256.jpg\";}i:201;a:5:{s:2:\"id\";s:9:\"tt0892769\";s:4:\"rank\";s:3:\"202\";s:5:\"title\";s:24:\"How to Train Your Dragon\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:74:\"/kelaket_images/MV5BMjA5NDQyMjc2NF5BMl5BanBnXkFtZTcwMjg5ODcyMw@@.UX256.jpg\";}i:202;a:5:{s:2:\"id\";s:9:\"tt0198781\";s:4:\"rank\";s:3:\"203\";s:5:\"title\";s:14:\"Monsters, Inc.\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:74:\"/kelaket_images/MV5BMTY1NTI0ODUyOF5BMl5BanBnXkFtZTgwNTEyNjQ0MDE@.UX256.jpg\";}i:203;a:5:{s:2:\"id\";s:9:\"tt0118715\";s:4:\"rank\";s:3:\"204\";s:5:\"title\";s:16:\"The Big Lebowski\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:74:\"/kelaket_images/MV5BMTQ0NjUzMDMyOF5BMl5BanBnXkFtZTgwODA1OTU0MDE@.UX256.jpg\";}i:204;a:5:{s:2:\"id\";s:9:\"tt0073195\";s:4:\"rank\";s:3:\"205\";s:5:\"title\";s:4:\"Jaws\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:106:\"/kelaket_images/MV5BMmVmODY1MzEtYTMwZC00MzNhLWFkNDMtZjAwM2EwODUxZTA5XkEyXkFqcGdeQXVyNTAyODkwOQ@@.UX256.jpg\";}i:205;a:5:{s:2:\"id\";s:9:\"tt0097165\";s:4:\"rank\";s:3:\"206\";s:5:\"title\";s:18:\"Dead Poets Society\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:106:\"/kelaket_images/MV5BOGYwYWNjMzgtNGU4ZC00NWQ2LWEwZjUtMzE1Zjc3NjY3YTU1XkEyXkFqcGdeQXVyMTQxNzMzNDI@.UX256.jpg\";}i:206;a:5:{s:2:\"id\";s:9:\"tt0019254\";s:4:\"rank\";s:3:\"207\";s:5:\"title\";s:26:\"The Passion of Joan of Arc\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNjBjNDJiYTUtOWY0OS00OGVmLTg2YzctMTE0NzVhODM1ZWJmXkEyXkFqcGdeQXVyNjU0OTQ0OTY@.UX256.jpg\";}i:207;a:5:{s:2:\"id\";s:9:\"tt0046438\";s:4:\"rank\";s:3:\"208\";s:5:\"title\";s:11:\"Tokyo Story\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:106:\"/kelaket_images/MV5BYWQ4ZTRiODktNjAzZC00Nzg1LTk1YWQtNDFmNDI0NmZiNGIwXkEyXkFqcGdeQXVyNzkwMjQ5NzM@.UX256.jpg\";}i:208;a:5:{s:2:\"id\";s:9:\"tt0395169\";s:4:\"rank\";s:3:\"209\";s:5:\"title\";s:12:\"Hotel Rwanda\";s:9:\"imdb_rate\";s:3:\"8.1\";s:5:\"image\";s:106:\"/kelaket_images/MV5BZGJjYmIzZmQtNWE4Yy00ZGVmLWJkZGEtMzUzNmQ4ZWFlMjRhXkEyXkFqcGdeQXVyMTMxODk2OTU@.UX256.jpg\";}i:209;a:5:{s:2:\"id\";s:9:\"tt1950186\";s:4:\"rank\";s:3:\"210\";s:5:\"title\";s:14:\"Ford v Ferrari\";s:9:\"imdb_rate\";s:3:\"8.0\";s:5:\"image\";s:106:\"/kelaket_images/MV5BM2UwMDVmMDItM2I2Yi00NGZmLTk4ZTUtY2JjNTQ3OGQ5ZjM2XkEyXkFqcGdeQXVyMTA1OTYzOTUx.UX256.jpg\";}i:210;a:5:{s:2:\"id\";s:9:\"tt0075148\";s:4:\"rank\";s:3:\"211\";s:5:\"title\";s:5:\"Rocky\";s:9:\"imdb_rate\";s:3:\"8.0\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNTBkMjg2MjYtYTZjOS00ODQ0LTg0MDEtM2FiNmJmOGU1NGEwXkEyXkFqcGdeQXVyMjUzOTY1NTc@.UX256.jpg\";}i:211;a:5:{s:2:\"id\";s:9:\"tt0091763\";s:4:\"rank\";s:3:\"212\";s:5:\"title\";s:7:\"Platoon\";s:9:\"imdb_rate\";s:3:\"8.0\";s:5:\"image\";s:106:\"/kelaket_images/MV5BMzRjZjdlMjQtODVkYS00N2YzLWJlYWYtMGVlN2E5MWEwMWQzXkEyXkFqcGdeQXVyMTQxNzMzNDI@.UX256.jpg\";}i:212;a:5:{s:2:\"id\";s:9:\"tt1895587\";s:4:\"rank\";s:3:\"213\";s:5:\"title\";s:9:\"Spotlight\";s:9:\"imdb_rate\";s:3:\"8.0\";s:5:\"image\";s:74:\"/kelaket_images/MV5BMjIyOTM5OTIzNV5BMl5BanBnXkFtZTgwMDkzODE2NjE@.UX256.jpg\";}i:213;a:5:{s:2:\"id\";s:9:\"tt0088247\";s:4:\"rank\";s:3:\"214\";s:5:\"title\";s:14:\"The Terminator\";s:9:\"imdb_rate\";s:3:\"8.0\";s:5:\"image\";s:106:\"/kelaket_images/MV5BYTViNzMxZjEtZGEwNy00MDNiLWIzNGQtZDY2MjQ1OWViZjFmXkEyXkFqcGdeQXVyNzkwMjQ5NzM@.UX256.jpg\";}i:214;a:5:{s:2:\"id\";s:9:\"tt0092005\";s:4:\"rank\";s:3:\"215\";s:5:\"title\";s:11:\"Stand by Me\";s:9:\"imdb_rate\";s:3:\"8.0\";s:5:\"image\";s:106:\"/kelaket_images/MV5BODJmY2Y2OGQtMDg2My00N2Q3LWJmZTUtYTc2ODBjZDVlNDlhXkEyXkFqcGdeQXVyMTQxNzMzNDI@.UX256.jpg\";}i:215;a:5:{s:2:\"id\";s:9:\"tt0382932\";s:4:\"rank\";s:3:\"216\";s:5:\"title\";s:11:\"Ratatouille\";s:9:\"imdb_rate\";s:3:\"8.0\";s:5:\"image\";s:74:\"/kelaket_images/MV5BMTMzODU0NTkxMF5BMl5BanBnXkFtZTcwMjQ4MzMzMw@@.UX256.jpg\";}i:216;a:5:{s:2:\"id\";s:9:\"tt3315342\";s:4:\"rank\";s:3:\"217\";s:5:\"title\";s:5:\"Logan\";s:9:\"imdb_rate\";s:3:\"8.0\";s:5:\"image\";s:106:\"/kelaket_images/MV5BYzc5MTU4N2EtYTkyMi00NjdhLTg3NWEtMTY4OTEyMzJhZTAzXkEyXkFqcGdeQXVyNjc1NTYyMjg@.UX256.jpg\";}i:217;a:5:{s:2:\"id\";s:9:\"tt1979320\";s:4:\"rank\";s:3:\"218\";s:5:\"title\";s:4:\"Rush\";s:9:\"imdb_rate\";s:3:\"8.0\";s:5:\"image\";s:106:\"/kelaket_images/MV5BOWEwODJmZDItYTNmZC00OGM4LThlNDktOTQzZjIzMGQxODA4XkEyXkFqcGdeQXVyNjU0OTQ0OTY@.UX256.jpg\";}i:218;a:5:{s:2:\"id\";s:9:\"tt0074958\";s:4:\"rank\";s:3:\"219\";s:5:\"title\";s:7:\"Network\";s:9:\"imdb_rate\";s:3:\"8.0\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNzY0NjU5ODUtOTAzMC00NTU5LWJkZjctYWMyOWY2MTZmOWM1XkEyXkFqcGdeQXVyMTI3ODAyMzE2.UX256.jpg\";}i:219;a:5:{s:2:\"id\";s:9:\"tt0048473\";s:4:\"rank\";s:3:\"220\";s:5:\"title\";s:15:\"Pather Panchali\";s:9:\"imdb_rate\";s:3:\"8.0\";s:5:\"image\";s:106:\"/kelaket_images/MV5BMmFkNDY5OTktNzY3Yy00OTFlLThhNjktOTRhMmZjZmIxYjAxXkEyXkFqcGdeQXVyNTgyNTA4MjM@.UX256.jpg\";}i:220;a:5:{s:2:\"id\";s:9:\"tt0758758\";s:4:\"rank\";s:3:\"221\";s:5:\"title\";s:13:\"Into the Wild\";s:9:\"imdb_rate\";s:3:\"8.0\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNjQ0ODlhMWUtNmUwMS00YjExLWI4MjQtNjVmMmE2Y2E0MGRmXkEyXkFqcGdeQXVyNDk3NzU2MTQ@.UX256.jpg\";}i:221;a:5:{s:2:\"id\";s:9:\"tt0032138\";s:4:\"rank\";s:3:\"222\";s:5:\"title\";s:16:\"The Wizard of Oz\";s:9:\"imdb_rate\";s:3:\"8.0\";s:5:\"image\";s:74:\"/kelaket_images/MV5BNjUyMTc4MDExMV5BMl5BanBnXkFtZTgwNDg0NDIwMjE@.UX256.jpg\";}i:222;a:5:{s:2:\"id\";s:9:\"tt0381681\";s:4:\"rank\";s:3:\"223\";s:5:\"title\";s:13:\"Before Sunset\";s:9:\"imdb_rate\";s:3:\"8.0\";s:5:\"image\";s:70:\"/kelaket_images/MV5BMTQ1MjAwNTM5Ml5BMl5BanBnXkFtZTYwNDM0MTc3.UX256.jpg\";}i:223;a:5:{s:2:\"id\";s:9:\"tt0107048\";s:4:\"rank\";s:3:\"224\";s:5:\"title\";s:13:\"Groundhog Day\";s:9:\"imdb_rate\";s:3:\"8.0\";s:5:\"image\";s:106:\"/kelaket_images/MV5BZWIxNzM5YzQtY2FmMS00Yjc3LWI1ZjUtNGVjMjMzZTIxZTIxXkEyXkFqcGdeQXVyNjU0OTQ0OTY@.UX256.jpg\";}i:224;a:5:{s:2:\"id\";s:9:\"tt0036868\";s:4:\"rank\";s:3:\"225\";s:5:\"title\";s:27:\"The Best Years of Our Lives\";s:9:\"imdb_rate\";s:3:\"8.0\";s:5:\"image\";s:106:\"/kelaket_images/MV5BY2RmNTRjYzctODI4Ni00MzQyLWEyNTAtNjU0N2JkMTNhNjJkXkEyXkFqcGdeQXVyNjU0OTQ0OTY@.UX256.jpg\";}i:225;a:5:{s:2:\"id\";s:9:\"tt0070047\";s:4:\"rank\";s:3:\"226\";s:5:\"title\";s:12:\"The Exorcist\";s:9:\"imdb_rate\";s:3:\"8.0\";s:5:\"image\";s:106:\"/kelaket_images/MV5BYWFlZGY2NDktY2ZjOS00ZWNkLTg0ZDAtZDY4MTM1ODU4ZjljXkEyXkFqcGdeQXVyMjUzOTY1NTc@.UX256.jpg\";}i:226;a:5:{s:2:\"id\";s:9:\"tt0035446\";s:4:\"rank\";s:3:\"227\";s:5:\"title\";s:18:\"To Be or Not to Be\";s:9:\"imdb_rate\";s:3:\"8.0\";s:5:\"image\";s:106:\"/kelaket_images/MV5BMGY3ZDgzY2MtNTllNi00ZWI1LTk1NTUtNWEzN2Q4YTA1ZGZiXkEyXkFqcGdeQXVyNzI1NzMxNzM@.UX256.jpg\";}i:227;a:5:{s:2:\"id\";s:9:\"tt0317705\";s:4:\"rank\";s:3:\"228\";s:5:\"title\";s:15:\"The Incredibles\";s:9:\"imdb_rate\";s:3:\"8.0\";s:5:\"image\";s:74:\"/kelaket_images/MV5BMTY5OTU0OTc2NV5BMl5BanBnXkFtZTcwMzU4MDcyMQ@@.UX256.jpg\";}i:228;a:5:{s:2:\"id\";s:9:\"tt0058946\";s:4:\"rank\";s:3:\"229\";s:5:\"title\";s:21:\"The Battle of Algiers\";s:9:\"imdb_rate\";s:3:\"8.0\";s:5:\"image\";s:106:\"/kelaket_images/MV5BN2M4YTA4ZTEtN2EyNy00YTlmLWE4YzYtYjYyYjRkMWM4ZDM0XkEyXkFqcGdeQXVyMjUzOTY1NTc@.UX256.jpg\";}i:229;a:5:{s:2:\"id\";s:10:\"tt15097216\";s:4:\"rank\";s:3:\"230\";s:5:\"title\";s:8:\"Jai Bhim\";s:9:\"imdb_rate\";s:3:\"8.0\";s:5:\"image\";s:106:\"/kelaket_images/MV5BOTM0NWFjNGYtNjExMS00ZTZlLWFiYmMtZmU4ZjZkMmMxZTNjXkEyXkFqcGdeQXVyODEyNjEwMDk@.UX256.jpg\";}i:230;a:5:{s:2:\"id\";s:9:\"tt1028532\";s:4:\"rank\";s:3:\"231\";s:5:\"title\";s:19:\"Hachi: A Dog\'s Tale\";s:9:\"imdb_rate\";s:3:\"8.0\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNzE4NDg5OWMtMzg3NC00ZDRjLTllMDMtZTRjNWZmNjBmMGZlXkEyXkFqcGdeQXVyMTMxODk2OTU@.UX256.jpg\";}i:231;a:5:{s:2:\"id\";s:9:\"tt0113247\";s:4:\"rank\";s:3:\"232\";s:5:\"title\";s:8:\"La haine\";s:9:\"imdb_rate\";s:3:\"8.0\";s:5:\"image\";s:106:\"/kelaket_images/MV5BOTQxOGU0OWUtMzExYy00ZjIxLWJmMzAtNTI1Y2YxYTMxN2RkXkEyXkFqcGdeQXVyMjUzOTY1NTc@.UX256.jpg\";}i:232;a:5:{s:2:\"id\";s:9:\"tt0476735\";s:4:\"rank\";s:3:\"233\";s:5:\"title\";s:20:\"My Father and My Son\";s:9:\"imdb_rate\";s:3:\"8.0\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNjAzMzEwYzctNjc1MC00Nzg5LWFmMGItMTgzYmMyNTY2OTQ4XkEyXkFqcGdeQXVyNjU0OTQ0OTY@.UX256.jpg\";}i:233;a:5:{s:2:\"id\";s:9:\"tt0325980\";s:4:\"rank\";s:3:\"234\";s:5:\"title\";s:54:\"Pirates of the Caribbean: The Curse of the Black Pearl\";s:9:\"imdb_rate\";s:3:\"8.0\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNGYyZGM5MGMtYTY2Ni00M2Y1LWIzNjQtYWUzM2VlNGVhMDNhXkEyXkFqcGdeQXVyMTMxODk2OTU@.UX256.jpg\";}i:234;a:5:{s:2:\"id\";s:9:\"tt0032551\";s:4:\"rank\";s:3:\"235\";s:5:\"title\";s:19:\"The Grapes of Wrath\";s:9:\"imdb_rate\";s:3:\"8.0\";s:5:\"image\";s:114:\"/kelaket_images/MV5BNzJiOGI2MjctYjUyMS00ZjkzLWE2ZmUtOTg4NTZkOTNhZDc1L2ltYWdlXkEyXkFqcGdeQXVyNjc1NTYyMjg@.UX256.jpg\";}i:235;a:5:{s:2:\"id\";s:9:\"tt0032976\";s:4:\"rank\";s:3:\"236\";s:5:\"title\";s:7:\"Rebecca\";s:9:\"imdb_rate\";s:3:\"8.0\";s:5:\"image\";s:114:\"/kelaket_images/MV5BYTcxYWExOTMtMWFmYy00ZjgzLWI0YjktNWEzYzJkZTg0NDdmL2ltYWdlXkEyXkFqcGdeQXVyNjc1NTYyMjg@.UX256.jpg\";}i:236;a:5:{s:2:\"id\";s:9:\"tt0245712\";s:4:\"rank\";s:3:\"237\";s:5:\"title\";s:13:\"Amores Perros\";s:9:\"imdb_rate\";s:3:\"8.0\";s:5:\"image\";s:106:\"/kelaket_images/MV5BZjUxNmEwOGItMTBmYi00MWQ1LWExY2MtNDUxMjI0OWM4M2NiXkEyXkFqcGdeQXVyMjUzOTY1NTc@.UX256.jpg\";}i:237;a:5:{s:2:\"id\";s:9:\"tt0061512\";s:4:\"rank\";s:3:\"238\";s:5:\"title\";s:14:\"Cool Hand Luke\";s:9:\"imdb_rate\";s:3:\"8.0\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNjcwNTQ3Y2EtMjdmZi00ODBhLWFhNzQtOTc3MWU5NTZlMDViXkEyXkFqcGdeQXVyMjUzOTY1NTc@.UX256.jpg\";}i:238;a:5:{s:2:\"id\";s:9:\"tt0053198\";s:4:\"rank\";s:3:\"239\";s:5:\"title\";s:13:\"The 400 Blows\";s:9:\"imdb_rate\";s:3:\"8.0\";s:5:\"image\";s:122:\"/kelaket_images/MV5BYTQ4MjA4NmYtYjRhNi00MTEwLTg0NjgtNjk3ODJlZGU4NjRkL2ltYWdlL2ltYWdlXkEyXkFqcGdeQXVyNjU0OTQ0OTY@.UX256.jpg\";}i:239;a:5:{s:2:\"id\";s:9:\"tt4016934\";s:4:\"rank\";s:3:\"240\";s:5:\"title\";s:14:\"The Handmaiden\";s:9:\"imdb_rate\";s:3:\"8.0\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNDJhYTk2MTctZmVmOS00OTViLTgxNjQtMzQxOTRiMDdmNGRjXkEyXkFqcGdeQXVyMTMxODk2OTU@.UX256.jpg\";}i:240;a:5:{s:2:\"id\";s:9:\"tt0059742\";s:4:\"rank\";s:3:\"241\";s:5:\"title\";s:18:\"The Sound of Music\";s:9:\"imdb_rate\";s:3:\"8.0\";s:5:\"image\";s:122:\"/kelaket_images/MV5BODIxNjhkYjEtYzUyMi00YTNjLWE1YjktNjAyY2I2MWNkNmNmL2ltYWdlL2ltYWdlXkEyXkFqcGdeQXVyMTQxNzMzNDI@.UX256.jpg\";}i:241;a:5:{s:2:\"id\";s:9:\"tt0025316\";s:4:\"rank\";s:3:\"242\";s:5:\"title\";s:21:\"It Happened One Night\";s:9:\"imdb_rate\";s:3:\"8.0\";s:5:\"image\";s:106:\"/kelaket_images/MV5BYzJmMWE5NjAtNWMyZS00NmFiLWIwMDgtZDE2NzczYWFhNzIzXkEyXkFqcGdeQXVyNjc1NTYyMjg@.UX256.jpg\";}i:242;a:5:{s:2:\"id\";s:9:\"tt0060827\";s:4:\"rank\";s:3:\"243\";s:5:\"title\";s:7:\"Persona\";s:9:\"imdb_rate\";s:3:\"8.0\";s:5:\"image\";s:106:\"/kelaket_images/MV5BYmFlOTcxMWUtZTMzMi00NWIyLTkwOTEtNjIxNmViNzc2Yzc1XkEyXkFqcGdeQXVyMjUzOTY1NTc@.UX256.jpg\";}i:243;a:5:{s:2:\"id\";s:9:\"tt0079470\";s:4:\"rank\";s:3:\"244\";s:5:\"title\";s:13:\"Life of Brian\";s:9:\"imdb_rate\";s:3:\"8.0\";s:5:\"image\";s:106:\"/kelaket_images/MV5BMDA1ZWI4ZDItOTRlYi00OTUxLWFlNWQtMzM5NDI0YjA4ZGI2XkEyXkFqcGdeQXVyMjUzOTY1NTc@.UX256.jpg\";}i:244;a:5:{s:2:\"id\";s:9:\"tt0071411\";s:4:\"rank\";s:3:\"245\";s:5:\"title\";s:11:\"Dersu Uzala\";s:9:\"imdb_rate\";s:3:\"8.0\";s:5:\"image\";s:106:\"/kelaket_images/MV5BYWY0OWJlZTgtMWUzNy00MGJhLTk5YzQtNmY5MDEwOTIxNjMyXkEyXkFqcGdeQXVyNjc1NTYyMjg@.UX256.jpg\";}i:245;a:5:{s:2:\"id\";s:9:\"tt0129167\";s:4:\"rank\";s:3:\"246\";s:5:\"title\";s:14:\"The Iron Giant\";s:9:\"imdb_rate\";s:3:\"8.0\";s:5:\"image\";s:106:\"/kelaket_images/MV5BYzBjZTNkMzQtZmNkOC00Yzk0LTljMjktZjk3YWVlZjY3NTk2XkEyXkFqcGdeQXVyMTUzMDUzNTI3.UX256.jpg\";}i:246;a:5:{s:2:\"id\";s:9:\"tt0103639\";s:4:\"rank\";s:3:\"247\";s:5:\"title\";s:7:\"Aladdin\";s:9:\"imdb_rate\";s:3:\"8.0\";s:5:\"image\";s:106:\"/kelaket_images/MV5BY2Q2NDI1MjUtM2Q5ZS00MTFlLWJiYWEtNTZmNjQ3OGJkZDgxXkEyXkFqcGdeQXVyNTI4MjkwNjA@.UX256.jpg\";}i:247;a:5:{s:2:\"id\";s:9:\"tt1454029\";s:4:\"rank\";s:3:\"248\";s:5:\"title\";s:8:\"The Help\";s:9:\"imdb_rate\";s:3:\"8.0\";s:5:\"image\";s:74:\"/kelaket_images/MV5BMTM5OTMyMjIxOV5BMl5BanBnXkFtZTcwNzU4MjIwNQ@@.UX256.jpg\";}i:248;a:5:{s:2:\"id\";s:9:\"tt0083987\";s:4:\"rank\";s:3:\"249\";s:5:\"title\";s:6:\"Gandhi\";s:9:\"imdb_rate\";s:3:\"8.0\";s:5:\"image\";s:106:\"/kelaket_images/MV5BOGVmZGU2M2EtZTVjYy00OWU2LWI0YjEtZjQ4YjNmODhmMzhkXkEyXkFqcGdeQXVyNjk1Njg5NTA@.UX256.jpg\";}i:249;a:5:{s:2:\"id\";s:9:\"tt0048021\";s:4:\"rank\";s:3:\"250\";s:5:\"title\";s:6:\"Rififi\";s:9:\"imdb_rate\";s:3:\"8.0\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNjk1NjBkN2ItZTI1Yi00NDcyLTkwN2ItZGQ3MWU1NzU0NjYwXkEyXkFqcGdeQXVyMjUzOTY1NTc@.UX256.jpg\";}}}", "yes");
INSERT INTO `wp_options` VALUES("26410", "imdb_top_250_series", "a:2:{s:11:\"update_date\";s:19:\"2022-12-25 10:34:53\";s:4:\"data\";a:250:{i:0;a:5:{s:2:\"id\";s:9:\"tt5491994\";s:4:\"rank\";s:1:\"1\";s:5:\"title\";s:15:\"Planet Earth II\";s:9:\"imdb_rate\";s:3:\"9.4\";s:5:\"image\";s:106:\"/kelaket_images/MV5BMGZmYmQ5NGQtNWQ1MC00NWZlLTg0MjYtYjJjMzQ5ODgxYzRkXkEyXkFqcGdeQXVyNjAwNDUxODI@.UX256.jpg\";}i:1;a:5:{s:2:\"id\";s:9:\"tt0903747\";s:4:\"rank\";s:1:\"2\";s:5:\"title\";s:12:\"Breaking Bad\";s:9:\"imdb_rate\";s:3:\"9.4\";s:5:\"image\";s:106:\"/kelaket_images/MV5BYTU3NWI5OGMtZmZhNy00MjVmLTk1YzAtZjA3ZDA3NzcyNDUxXkEyXkFqcGdeQXVyODY5Njk4Njc@.UX256.jpg\";}i:2;a:5:{s:2:\"id\";s:9:\"tt0795176\";s:4:\"rank\";s:1:\"3\";s:5:\"title\";s:12:\"Planet Earth\";s:9:\"imdb_rate\";s:3:\"9.4\";s:5:\"image\";s:106:\"/kelaket_images/MV5BMzMyYjg0MGMtMTlkMy00OGFiLWFiNTYtYmFmZWNmMDFlMzkwXkEyXkFqcGdeQXVyNjAwNDUxODI@.UX256.jpg\";}i:3;a:5:{s:2:\"id\";s:9:\"tt0185906\";s:4:\"rank\";s:1:\"4\";s:5:\"title\";s:16:\"Band of Brothers\";s:9:\"imdb_rate\";s:3:\"9.4\";s:5:\"image\";s:70:\"/kelaket_images/MV5BMTI3ODc2ODc0M15BMl5BanBnXkFtZTYwMjgzNjc3.UX256.jpg\";}i:4;a:5:{s:2:\"id\";s:9:\"tt7366338\";s:4:\"rank\";s:1:\"5\";s:5:\"title\";s:9:\"Chernobyl\";s:9:\"imdb_rate\";s:3:\"9.3\";s:5:\"image\";s:106:\"/kelaket_images/MV5BZGQ2YmMxZmEtYjI5OS00NzlkLTlkNTEtYWMyMzkyMzc2MDU5XkEyXkFqcGdeQXVyMzQ2MDI5NjU@.UX256.jpg\";}i:5;a:5:{s:2:\"id\";s:9:\"tt0306414\";s:4:\"rank\";s:1:\"6\";s:5:\"title\";s:8:\"The Wire\";s:9:\"imdb_rate\";s:3:\"9.3\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNTllYzFhMjAtZjExNS00MjM4LWE5YmMtOGFiZGRlOTU5YzJiXkEyXkFqcGdeQXVyNDIzMzcwNjc@.UX256.jpg\";}i:6;a:5:{s:2:\"id\";s:9:\"tt6769208\";s:4:\"rank\";s:1:\"7\";s:5:\"title\";s:14:\"Blue Planet II\";s:9:\"imdb_rate\";s:3:\"9.2\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNDZiNDllMTAtOTgxZi00NzNiLWFhNzUtOGUwZWZjZGNjZTMyXkEyXkFqcGdeQXVyNjAwNDUxODI@.UX256.jpg\";}i:7;a:5:{s:2:\"id\";s:9:\"tt0417299\";s:4:\"rank\";s:1:\"8\";s:5:\"title\";s:26:\"Avatar: The Last Airbender\";s:9:\"imdb_rate\";s:3:\"9.2\";s:5:\"image\";s:106:\"/kelaket_images/MV5BODc5YTBhMTItMjhkNi00ZTIxLWI0YjAtNTZmOTY0YjRlZGQ0XkEyXkFqcGdeQXVyODUwNjEzMzg@.UX256.jpg\";}i:8;a:5:{s:2:\"id\";s:9:\"tt2395695\";s:4:\"rank\";s:1:\"9\";s:5:\"title\";s:27:\"Cosmos: A Spacetime Odyssey\";s:9:\"imdb_rate\";s:3:\"9.2\";s:5:\"image\";s:106:\"/kelaket_images/MV5BZTk5OTQyZjYtMDk3Yy00YjhmLWE2MTYtZmY4NTg1YWUzZTQ0XkEyXkFqcGdeQXVyNTA4NzY1MzY@.UX256.jpg\";}i:9;a:5:{s:2:\"id\";s:9:\"tt0141842\";s:4:\"rank\";s:2:\"10\";s:5:\"title\";s:12:\"The Sopranos\";s:9:\"imdb_rate\";s:3:\"9.2\";s:5:\"image\";s:106:\"/kelaket_images/MV5BZGJjYzhjYTYtMDBjYy00OWU1LTg5OTYtNmYwOTZmZjE3ZDdhXkEyXkFqcGdeQXVyNTAyODkwOQ@@.UX256.jpg\";}i:10;a:5:{s:2:\"id\";s:9:\"tt0081846\";s:4:\"rank\";s:2:\"11\";s:5:\"title\";s:6:\"Cosmos\";s:9:\"imdb_rate\";s:3:\"9.2\";s:5:\"image\";s:106:\"/kelaket_images/MV5BM2YzYzc0OWUtNmIwZi00MTBlLThjYTgtYmU1ODlhMzdjMzdjXkEyXkFqcGdeQXVyNjAwNDUxODI@.UX256.jpg\";}i:11;a:5:{s:2:\"id\";s:9:\"tt9253866\";s:4:\"rank\";s:2:\"12\";s:5:\"title\";s:10:\"Our Planet\";s:9:\"imdb_rate\";s:3:\"9.2\";s:5:\"image\";s:106:\"/kelaket_images/MV5BZmM2OWEyN2EtZWY2NS00ZDA3LWFlNTAtNzUzMGQwZWVlZmE4XkEyXkFqcGdeQXVyNjAwNDUxODI@.UX256.jpg\";}i:12;a:5:{s:2:\"id\";s:9:\"tt0944947\";s:4:\"rank\";s:2:\"13\";s:5:\"title\";s:15:\"Game of Thrones\";s:9:\"imdb_rate\";s:3:\"9.1\";s:5:\"image\";s:106:\"/kelaket_images/MV5BYTRiNDQwYzAtMzVlZS00NTI5LWJjYjUtMzkwNTUzMWMxZTllXkEyXkFqcGdeQXVyNDIzMzcwNjc@.UX256.jpg\";}i:13;a:5:{s:2:\"id\";s:9:\"tt2861424\";s:4:\"rank\";s:2:\"14\";s:5:\"title\";s:14:\"Rick and Morty\";s:9:\"imdb_rate\";s:3:\"9.1\";s:5:\"image\";s:106:\"/kelaket_images/MV5BZjRjOTFkOTktZWUzMi00YzMyLThkMmYtMjEwNmQyNzliYTNmXkEyXkFqcGdeQXVyNzQ1ODk3MTQ@.UX256.jpg\";}i:14;a:5:{s:2:\"id\";s:9:\"tt0071075\";s:4:\"rank\";s:2:\"15\";s:5:\"title\";s:16:\"The World at War\";s:9:\"imdb_rate\";s:3:\"9.1\";s:5:\"image\";s:106:\"/kelaket_images/MV5BZTIwOWEyMjctMjQwNS00ODZiLThmMWEtYWQ1OWFiYzQ2OWYwXkEyXkFqcGdeQXVyNjAwNDUxODI@.UX256.jpg\";}i:15;a:5:{s:2:\"id\";s:9:\"tt1355642\";s:4:\"rank\";s:2:\"16\";s:5:\"title\";s:32:\"Fullmetal Alchemist: Brotherhood\";s:9:\"imdb_rate\";s:3:\"9.1\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNTM4MzMxMWItYzc3NC00ODY0LTg0M2MtYjg4NDg0ZjM0MjdiXkEyXkFqcGdeQXVyNjAwNDUxODI@.UX256.jpg\";}i:16;a:5:{s:2:\"id\";s:9:\"tt8420184\";s:4:\"rank\";s:2:\"17\";s:5:\"title\";s:14:\"The Last Dance\";s:9:\"imdb_rate\";s:3:\"9.0\";s:5:\"image\";s:106:\"/kelaket_images/MV5BY2U1ZTU4OWItNGU2MC00MTg1LTk4NzUtYTk3ODhjYjI0MzlmXkEyXkFqcGdeQXVyMTkxNjUyNQ@@.UX256.jpg\";}i:17;a:5:{s:2:\"id\";s:9:\"tt1533395\";s:4:\"rank\";s:2:\"18\";s:5:\"title\";s:4:\"Life\";s:9:\"imdb_rate\";s:3:\"9.0\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNjJhMTAxZjYtNWZkYy00Nzg1LTlkYjItZTNhZWRjNzkxMDg3XkEyXkFqcGdeQXVyNTA4NzY1MzY@.UX256.jpg\";}i:18;a:5:{s:2:\"id\";s:9:\"tt1475582\";s:4:\"rank\";s:2:\"19\";s:5:\"title\";s:8:\"Sherlock\";s:9:\"imdb_rate\";s:3:\"9.0\";s:5:\"image\";s:122:\"/kelaket_images/MV5BMWY3NTljMjEtYzRiMi00NWM2LTkzNjItZTVmZjE0MTdjMjJhL2ltYWdlL2ltYWdlXkEyXkFqcGdeQXVyNTQ4NTc5OTU@.UX256.jpg\";}i:19;a:5:{s:2:\"id\";s:9:\"tt0052520\";s:4:\"rank\";s:2:\"20\";s:5:\"title\";s:17:\"The Twilight Zone\";s:9:\"imdb_rate\";s:3:\"9.0\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNTAzMDI5MzgtMGNkMC00MzllLWJhNjctNjA1NmViNGUxMzYxXkEyXkFqcGdeQXVyMTQxNzMzNDI@.UX256.jpg\";}i:20;a:5:{s:2:\"id\";s:9:\"tt1877514\";s:4:\"rank\";s:2:\"21\";s:5:\"title\";s:15:\"The Vietnam War\";s:9:\"imdb_rate\";s:3:\"9.0\";s:5:\"image\";s:106:\"/kelaket_images/MV5BZmY2NGMyY2EtMjJiMS00MmFlLTk1MmItZDA1NTQ0ODg0MDA4XkEyXkFqcGdeQXVyNjAwNDUxODI@.UX256.jpg\";}i:21;a:5:{s:2:\"id\";s:9:\"tt7678620\";s:4:\"rank\";s:2:\"22\";s:5:\"title\";s:5:\"Bluey\";s:9:\"imdb_rate\";s:3:\"9.0\";s:5:\"image\";s:106:\"/kelaket_images/MV5BMDBiNDI3YjQtNDdkNS00ZDliLTlmMmQtMDE4ZWM1ZGIyNjljXkEyXkFqcGdeQXVyNTE1NjY5Mg@@.UX256.jpg\";}i:22;a:5:{s:2:\"id\";s:9:\"tt0103359\";s:4:\"rank\";s:2:\"23\";s:5:\"title\";s:27:\"Batman: The Animated Series\";s:9:\"imdb_rate\";s:3:\"9.0\";s:5:\"image\";s:106:\"/kelaket_images/MV5BOTM3MTRkZjQtYjBkMy00YWE1LTkxOTQtNDQyNGY0YjYzNzAzXkEyXkFqcGdeQXVyOTgwMzk1MTA@.UX256.jpg\";}i:23;a:5:{s:2:\"id\";s:10:\"tt12392504\";s:4:\"rank\";s:2:\"24\";s:5:\"title\";s:34:\"Scam 1992: The Harshad Mehta Story\";s:9:\"imdb_rate\";s:3:\"9.0\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNjgxZTMxNmQtZGFkZS00NDUyLTllMzYtOTE0ZjdlMjM1ZWU0XkEyXkFqcGdeQXVyMTAyMTE1MDA1.UX256.jpg\";}i:24;a:5:{s:2:\"id\";s:10:\"tt11126994\";s:4:\"rank\";s:2:\"25\";s:5:\"title\";s:6:\"Arcane\";s:9:\"imdb_rate\";s:3:\"8.9\";s:5:\"image\";s:106:\"/kelaket_images/MV5BYmU5OWM5ZTAtNjUzOC00NmUyLTgyOWMtMjlkNjdlMDAzMzU1XkEyXkFqcGdeQXVyMDM2NDM2MQ@@.UX256.jpg\";}i:25;a:5:{s:2:\"id\";s:9:\"tt0296310\";s:4:\"rank\";s:2:\"26\";s:5:\"title\";s:15:\"The Blue Planet\";s:9:\"imdb_rate\";s:3:\"8.9\";s:5:\"image\";s:106:\"/kelaket_images/MV5BMjA4N2QzZGItY2IzOS00YTUyLWI5MzItNjRjNWEyODE3ZWQ4XkEyXkFqcGdeQXVyNjAwNDUxODI@.UX256.jpg\";}i:26;a:5:{s:2:\"id\";s:9:\"tt2560140\";s:4:\"rank\";s:2:\"27\";s:5:\"title\";s:15:\"Attack on Titan\";s:9:\"imdb_rate\";s:3:\"8.9\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNzc5MTczNDQtNDFjNi00ZDU5LWFkNzItOTE1NzQzMzdhNzMxXkEyXkFqcGdeQXVyNTgyNTA4MjM@.UX256.jpg\";}i:27;a:5:{s:2:\"id\";s:9:\"tt0386676\";s:4:\"rank\";s:2:\"28\";s:5:\"title\";s:10:\"The Office\";s:9:\"imdb_rate\";s:3:\"8.9\";s:5:\"image\";s:106:\"/kelaket_images/MV5BMDNkOTE4NDQtMTNmYi00MWE0LWE4ZTktYTc0NzhhNWIzNzJiXkEyXkFqcGdeQXVyMzQ2MDI5NjU@.UX256.jpg\";}i:28;a:5:{s:2:\"id\";s:9:\"tt0303461\";s:4:\"rank\";s:2:\"29\";s:5:\"title\";s:7:\"Firefly\";s:9:\"imdb_rate\";s:3:\"8.9\";s:5:\"image\";s:106:\"/kelaket_images/MV5BOTcwNzkwMDItZmM1OC00MmQ2LTgxYjgtOTNiNDgxZDAxMjk0XkEyXkFqcGdeQXVyNDQ0MTYzMDA@.UX256.jpg\";}i:29;a:5:{s:2:\"id\";s:9:\"tt1806234\";s:4:\"rank\";s:2:\"30\";s:5:\"title\";s:12:\"Human Planet\";s:9:\"imdb_rate\";s:3:\"8.9\";s:5:\"image\";s:106:\"/kelaket_images/MV5BMjM4NWMzNDgtZjQ4Zi00NWEyLWIzNTYtZjVjZGVhMmY1NTQyXkEyXkFqcGdeQXVyNjAwNDUxODI@.UX256.jpg\";}i:30;a:5:{s:2:\"id\";s:9:\"tt2092588\";s:4:\"rank\";s:2:\"31\";s:5:\"title\";s:13:\"Frozen Planet\";s:9:\"imdb_rate\";s:3:\"8.9\";s:5:\"image\";s:106:\"/kelaket_images/MV5BYjdlMGYwYWQtODVlMi00Y2I0LThiYzgtYTM0YmU5NzdhYTI0XkEyXkFqcGdeQXVyNjAwNDUxODI@.UX256.jpg\";}i:31;a:5:{s:2:\"id\";s:9:\"tt0877057\";s:4:\"rank\";s:2:\"32\";s:5:\"title\";s:10:\"Death Note\";s:9:\"imdb_rate\";s:3:\"8.9\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNjRiNmNjMmMtN2U2Yi00ODgxLTk3OTMtMmI1MTI1NjYyZTEzXkEyXkFqcGdeQXVyNjAwNDUxODI@.UX256.jpg\";}i:32;a:5:{s:2:\"id\";s:9:\"tt0081912\";s:4:\"rank\";s:2:\"33\";s:5:\"title\";s:21:\"Only Fools and Horses\";s:9:\"imdb_rate\";s:3:\"8.9\";s:5:\"image\";s:106:\"/kelaket_images/MV5BYmI1NGIwNzYtOTVlMS00ZGYwLWE0ZTktYzVmMGVlMmRmN2QxXkEyXkFqcGdeQXVyNTA4NzY1MzY@.UX256.jpg\";}i:33;a:5:{s:2:\"id\";s:9:\"tt0098769\";s:4:\"rank\";s:2:\"34\";s:5:\"title\";s:13:\"The Civil War\";s:9:\"imdb_rate\";s:3:\"8.9\";s:5:\"image\";s:106:\"/kelaket_images/MV5BZjE1ODNkYzctNjM0Ni00MmM3LTkyMjctZGRhYzA3YzhjMTFlXkEyXkFqcGdeQXVyNjAwNDUxODI@.UX256.jpg\";}i:34;a:5:{s:2:\"id\";s:9:\"tt2098220\";s:4:\"rank\";s:2:\"35\";s:5:\"title\";s:15:\"Hunter x Hunter\";s:9:\"imdb_rate\";s:3:\"8.9\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNGM0YTk3MWEtN2JlZC00ZmZmLWIwMDktZTMxZGE5Zjc2MGExXkEyXkFqcGdeQXVyNjAwNDUxODI@.UX256.jpg\";}i:35;a:5:{s:2:\"id\";s:9:\"tt2356777\";s:4:\"rank\";s:2:\"36\";s:5:\"title\";s:14:\"True Detective\";s:9:\"imdb_rate\";s:3:\"8.9\";s:5:\"image\";s:106:\"/kelaket_images/MV5BMmRlYmE0Y2UtNDk2Yi00NzczLWEwZTEtZmE2OTcyYzcxYmU5XkEyXkFqcGdeQXVyNTMxMjgxMzA@.UX256.jpg\";}i:36;a:5:{s:2:\"id\";s:9:\"tt3032476\";s:4:\"rank\";s:2:\"37\";s:5:\"title\";s:16:\"Better Call Saul\";s:9:\"imdb_rate\";s:3:\"8.9\";s:5:\"image\";s:106:\"/kelaket_images/MV5BMTMxOGM0NzItM2E0OS00YWYzLWEzNzUtODUzZTBjM2I4MTZkXkEyXkFqcGdeQXVyMTM1MTE1NDMx.UX256.jpg\";}i:37;a:5:{s:2:\"id\";s:9:\"tt0098904\";s:4:\"rank\";s:2:\"38\";s:5:\"title\";s:8:\"Seinfeld\";s:9:\"imdb_rate\";s:3:\"8.9\";s:5:\"image\";s:106:\"/kelaket_images/MV5BZjZjMzQ2ZmUtZWEyZC00NWJiLWFjM2UtMzhmYzZmZDcxMzllXkEyXkFqcGdeQXVyNTA4NzY1MzY@.UX256.jpg\";}i:38;a:5:{s:2:\"id\";s:9:\"tt9735318\";s:4:\"rank\";s:2:\"39\";s:5:\"title\";s:21:\"The Beatles: Get Back\";s:9:\"imdb_rate\";s:3:\"8.9\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNjMxMjE5ZTEtMjgyOC00ODM4LWJjZDAtMjcwZDBlNzZhZTkyXkEyXkFqcGdeQXVyMDM2NDM2MQ@@.UX256.jpg\";}i:39;a:5:{s:2:\"id\";s:9:\"tt0092337\";s:4:\"rank\";s:2:\"40\";s:5:\"title\";s:7:\"Dekalog\";s:9:\"imdb_rate\";s:3:\"8.9\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNDgzZDVmZjYtYmNhNi00YTE0LWJmNDAtODZiNWIwMjJhZDhhXkEyXkFqcGdeQXVyNjAwNDUxODI@.UX256.jpg\";}i:40;a:5:{s:2:\"id\";s:9:\"tt7920978\";s:4:\"rank\";s:2:\"41\";s:5:\"title\";s:7:\"Persona\";s:9:\"imdb_rate\";s:3:\"8.9\";s:5:\"image\";s:106:\"/kelaket_images/MV5BOTJkNzJmYzgtZTZmNC00MTQ2LWE2ZGQtM2EyYjliNGViMTY5XkEyXkFqcGdeQXVyNDg4MjkzNDk@.UX256.jpg\";}i:41;a:5:{s:2:\"id\";s:9:\"tt2802850\";s:4:\"rank\";s:2:\"42\";s:5:\"title\";s:5:\"Fargo\";s:9:\"imdb_rate\";s:3:\"8.9\";s:5:\"image\";s:106:\"/kelaket_images/MV5BN2NiMGE5M2UtNWNlNC00N2Y4LTkwOWUtMDlkMzEwNTcyOTcyXkEyXkFqcGdeQXVyMTkxNjUyNQ@@.UX256.jpg\";}i:42;a:5:{s:2:\"id\";s:9:\"tt0213338\";s:4:\"rank\";s:2:\"43\";s:5:\"title\";s:12:\"Cowboy Bebop\";s:9:\"imdb_rate\";s:3:\"8.9\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNGNlNjBkODEtZThlOC00YzUxLWI0MjMtMjk3YzJmMDFlNWZlXkEyXkFqcGdeQXVyNjI0MDg2NzE@.UX256.jpg\";}i:43;a:5:{s:2:\"id\";s:10:\"tt10541088\";s:4:\"rank\";s:2:\"44\";s:5:\"title\";s:15:\"Clarkson\'s Farm\";s:9:\"imdb_rate\";s:3:\"8.9\";s:5:\"image\";s:106:\"/kelaket_images/MV5BYWI5M2YyYmYtMzBkNy00YWYyLThjZGUtYzEyOTQxZDQyYmVhXkEyXkFqcGdeQXVyNjAwNDUxODI@.UX256.jpg\";}i:44;a:5:{s:2:\"id\";s:9:\"tt2297757\";s:4:\"rank\";s:2:\"45\";s:5:\"title\";s:14:\"Nathan for You\";s:9:\"imdb_rate\";s:3:\"8.8\";s:5:\"image\";s:106:\"/kelaket_images/MV5BOGY4ZWM1MDUtZmM3MS00ZjAxLTkyYzMtMjgxODI1YzkzNGUwXkEyXkFqcGdeQXVyNzk2NzE5Mjk@.UX256.jpg\";}i:45;a:5:{s:2:\"id\";s:9:\"tt1865718\";s:4:\"rank\";s:2:\"46\";s:5:\"title\";s:13:\"Gravity Falls\";s:9:\"imdb_rate\";s:3:\"8.8\";s:5:\"image\";s:74:\"/kelaket_images/MV5BMTEzNDc3MDQ2NzNeQTJeQWpwZ15BbWU4MDYzMzUwMDIx.UX256.jpg\";}i:46;a:5:{s:2:\"id\";s:9:\"tt3530232\";s:4:\"rank\";s:2:\"47\";s:5:\"title\";s:34:\"Last Week Tonight with John Oliver\";s:9:\"imdb_rate\";s:3:\"8.8\";s:5:\"image\";s:106:\"/kelaket_images/MV5BYTE2MTcwZmYtNDk2OC00YzkwLTllYjgtMmJkODczZTkxNjllXkEyXkFqcGdeQXVyMTMxNjUyMDkx.UX256.jpg\";}i:47;a:5:{s:2:\"id\";s:9:\"tt7137906\";s:4:\"rank\";s:2:\"48\";s:5:\"title\";s:16:\"When They See Us\";s:9:\"imdb_rate\";s:3:\"8.8\";s:5:\"image\";s:106:\"/kelaket_images/MV5BZmJjM2YzOWEtOTYxYi00YjhkLTliMzgtMTA2MTc0NDQ1MDM4XkEyXkFqcGdeQXVyODY5OTk4MA@@.UX256.jpg\";}i:48;a:5:{s:2:\"id\";s:9:\"tt0108778\";s:4:\"rank\";s:2:\"49\";s:5:\"title\";s:7:\"Friends\";s:9:\"imdb_rate\";s:3:\"8.8\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNDVkYjU0MzctMWRmZi00NTkxLTgwZWEtOWVhYjZlYjllYmU4XkEyXkFqcGdeQXVyNTA4NzY1MzY@.UX256.jpg\";}i:49;a:5:{s:2:\"id\";s:9:\"tt4742876\";s:4:\"rank\";s:2:\"50\";s:5:\"title\";s:12:\"TVF Pitchers\";s:9:\"imdb_rate\";s:3:\"8.8\";s:5:\"image\";s:106:\"/kelaket_images/MV5BYzA2NGM5MjAtMGJhMC00ZmE3LWFmYmEtZTVjNjA0MzQ4YmI1XkEyXkFqcGdeQXVyMTIyNzY0NTMx.UX256.jpg\";}i:50;a:5:{s:2:\"id\";s:9:\"tt2571774\";s:4:\"rank\";s:2:\"51\";s:5:\"title\";s:6:\"Africa\";s:9:\"imdb_rate\";s:3:\"8.8\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNDdkZGViNzctZTJkMy00N2ZmLTg4NTUtZWM3YTE3ZTE3NjYwXkEyXkFqcGdeQXVyNjAwNDUxODI@.UX256.jpg\";}i:51;a:5:{s:2:\"id\";s:9:\"tt1508238\";s:4:\"rank\";s:2:\"52\";s:5:\"title\";s:32:\"Apocalypse: The Second World War\";s:9:\"imdb_rate\";s:3:\"8.8\";s:5:\"image\";s:114:\"/kelaket_images/MV5BMzEyMmM1ZGMtZTgwMS00Y2Y4LTg0MTItMGRiZGE3YTVhYjU3L2ltYWdlXkEyXkFqcGdeQXVyNTAyODkwOQ@@.UX256.jpg\";}i:52;a:5:{s:2:\"id\";s:9:\"tt0063929\";s:4:\"rank\";s:2:\"53\";s:5:\"title\";s:28:\"Monty Python\'s Flying Circus\";s:9:\"imdb_rate\";s:3:\"8.8\";s:5:\"image\";s:106:\"/kelaket_images/MV5BZGI1N2FiYTYtOWU3Mi00MjBlLWJkMGMtMjZmZTQwMDdiYjY3XkEyXkFqcGdeQXVyMTIwMjIwNjQ2.UX256.jpg\";}i:53;a:5:{s:2:\"id\";s:9:\"tt0472954\";s:4:\"rank\";s:2:\"54\";s:5:\"title\";s:33:\"It\'s Always Sunny in Philadelphia\";s:9:\"imdb_rate\";s:3:\"8.8\";s:5:\"image\";s:106:\"/kelaket_images/MV5BMzg3ODVjZTYtZTAyNC00MzVjLTk3NmUtMGI4ZjZmNGQ1NmY4XkEyXkFqcGdeQXVyMzQ2MDI5NjU@.UX256.jpg\";}i:54;a:5:{s:2:\"id\";s:9:\"tt4934214\";s:4:\"rank\";s:2:\"55\";s:5:\"title\";s:10:\"Taskmaster\";s:9:\"imdb_rate\";s:3:\"8.8\";s:5:\"image\";s:106:\"/kelaket_images/MV5BMTNlYzY0MTItZmI5Ni00ODEwLTkxNDktOTI3MGI1ODRmODJlXkEyXkFqcGdeQXVyMDE4MzA0NQ@@.UX256.jpg\";}i:55;a:5:{s:2:\"id\";s:9:\"tt0081834\";s:4:\"rank\";s:2:\"56\";s:5:\"title\";s:8:\"Das Boot\";s:9:\"imdb_rate\";s:3:\"8.8\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNTBhZTQzZGEtZmRiOS00MzAwLWI5MzQtYTc1YTRhMzU3NzQ5XkEyXkFqcGdeQXVyNzkwMjQ5NzM@.UX256.jpg\";}i:56;a:5:{s:2:\"id\";s:9:\"tt0200276\";s:4:\"rank\";s:2:\"57\";s:5:\"title\";s:13:\"The West Wing\";s:9:\"imdb_rate\";s:3:\"8.8\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNjk3ZWE3ZDctN2Q1YS00NzNhLWFjNmYtZTkwYWQxZmQ3NzM3XkEyXkFqcGdeQXVyNTE1NjY5Mg@@.UX256.jpg\";}i:57;a:5:{s:2:\"id\";s:9:\"tt0264235\";s:4:\"rank\";s:2:\"58\";s:5:\"title\";s:20:\"Curb Your Enthusiasm\";s:9:\"imdb_rate\";s:3:\"8.8\";s:5:\"image\";s:106:\"/kelaket_images/MV5BMzE3ZDA4OWItOGY2ZC00MzVmLTk0Y2QtNzEzMjc5YWI5ZWFiXkEyXkFqcGdeQXVyMTEyMjM2NDc2.UX256.jpg\";}i:58;a:5:{s:2:\"id\";s:9:\"tt0112130\";s:4:\"rank\";s:2:\"59\";s:5:\"title\";s:19:\"Pride and Prejudice\";s:9:\"imdb_rate\";s:3:\"8.8\";s:5:\"image\";s:106:\"/kelaket_images/MV5BMDM0MjFlOGYtNTg2ZC00MmRkLTg5OTQtM2U5ZjUyYTgxZThiXkEyXkFqcGdeQXVyNTAyODkwOQ@@.UX256.jpg\";}i:59;a:5:{s:2:\"id\";s:9:\"tt0072500\";s:4:\"rank\";s:2:\"60\";s:5:\"title\";s:13:\"Fawlty Towers\";s:9:\"imdb_rate\";s:3:\"8.8\";s:5:\"image\";s:106:\"/kelaket_images/MV5BNzg2NWQ5MDQtMWY0MC00MWFiLWIyMDEtYTI2MTMzN2YzOTI0XkEyXkFqcGdeQXVyNTA4NzExMDg@.UX256.jpg\";}i:60;a:5:{s:2:\"id\";s:9:\"tt1831164\";s:4:\"rank\";s:2:\"61\";s:5:\"title\";s:16:\"Leyla and Mecnun\";s:9:\"imdb_rate\";s:3:\"8.8\";s:5:\"image\";s:106:\"/kelaket_images/MV5BZGZlN2QzYTQtNmZkMy00YjdiLWIwOGUtMzlhZTJlMmIyNmJhXkEyXkFqcGdeQXVyOTQ2MjQ3MTI@.UX256.jpg\";}i:61;a:5:{s:2:\"id\";s:9:\"tt0193676\";s:4:\"rank\";s:2:\"62\";s:5:\"title\";s:16:\"Freaks and Geeks\";s:9:\"imdb_rate\";s:3:\"8.8\";s:5:\"image\";s:106:\"/kelaket_images/MV5BZWJhOGFiZWMtYTY5Ni00NGU1LWE5OWItNzA5NThkNWUwYzc4XkEyXkFqcGdeQXVyNTA4NzY1MzY@.UX256.jpg\";}i:62;a:5:{s:2:\"id\";s:10:\"tt13675832\";s:4:\"rank\";s:2:\"63\";s:5:\"title\";s:5:\"As If\";s:9:\"imdb_rate\";s:3:\"8.7\";s:5:\"image\";s:106:\"/kelaket_images/MV5BZTUzZjU0M2MtZGFmYy00ZWU0LWJjZGUtOGJlMTI4MWI4ZDUxXkEyXkFqcGdeQXVyNDg4MjkzNDk@.UX256.jpg\";}i:63;a:5:{s:2:\"id\";s:9:\"tt0096548\";s:4:\"rank\";s:2:\"64\";s:5:\"title\";s:21:\"Blackadder Goes Forth\";s:9:\"imdb_rate\";s:3:\"8.7\";s:5:\"image\";s:74:\"/kelaket_images/MV5BMTQ0OTc1NTU1NV5BMl5BanBnXkFtZTcwNDk1NDYxMQ@@.UX256.jpg\";}i:64;a:5:{s:2:\"id\";s:9:\"tt0098936\";s:4:\"rank\";s:2:\"65\";s:5:\"title\";s:10:\"Twin Peaks\";s:9:\"imdb_rate\";s:3:\"8.7\";s:5:\"