<?php

/**
 * Hello World
 *
 * @package     KelaketFilm OTP
 * @author      Mahmood Zamani
 * @copyright   2021 Mahmood Zamani (imahmoodzz)
 * @license     GPL-2.0-or-later
 *
 * @wordpress-plugin
 * Plugin Name: KelaketFilm OTP
 * Plugin URI:  https://imahmoodzz.ir
 * Description: پلاگین پوسته کلاکت فیلم برای پیاده سازی لاگین با شماره موبایل
 * Version:     1.2
 * Author:      Mahmood Zamani
 * Author URI:  https://imahmoodzz.ir
 * Text Domain: kelaketfilm-otp
 * License:     GPL v2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.txt
 */
register_activation_hook(__FILE__, 'my_plugin_create_db');
function my_plugin_create_db()
{
  //create db
  global $wpdb;
  $version = get_option('my_plugin_version', '1.0');
  $charset_collate = $wpdb->get_charset_collate();
  $table_name = $wpdb->prefix . 'otptokens';

  $sql = "CREATE TABLE $table_name (
		id bigint(20) NOT NULL AUTO_INCREMENT,
        mobile varchar(255) NOT NULL,
		token int(6) NOT NULL,
		created_at datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
		is_expire boolean NOT NULL,
		UNIQUE KEY id (id)
	) $charset_collate;";

  require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
  dbDelta($sql);
}

function new_modify_user_table($column)
{
  $column['phone'] = 'شماره موبایل';
  return $column;
}
add_filter('manage_users_columns', 'new_modify_user_table');

function new_modify_user_table_row($val, $column_name, $user_id)
{
  switch ($column_name) {
    case 'phone':
      return get_the_author_meta('phone', $user_id);
    default:
  }
  return $val;
}
add_filter('manage_users_custom_column', 'new_modify_user_table_row', 10, 3);
add_action('show_user_profile', 'my_show_extra_profile_fields');
add_action('edit_user_profile', 'my_show_extra_profile_fields');
function my_show_extra_profile_fields($user)
{ ?>
  <h3>اطلاعات تماس</h3>
  <table class="form-table">
    <tr>
      <th><label for="phone">شماره موبایل</label></th>
      <td>
        <input type="text" name="phone" id="phone" value="<?php echo esc_attr(get_the_author_meta('phone', $user->ID)); ?>" class="regular-text" /><br />
        <span class="description">شماره موبایل را وارد کنید.</span>
      </td>
    </tr>
  </table>
<?php }
add_action('personal_options_update', 'my_save_extra_profile_fields');
add_action('edit_user_profile_update', 'my_save_extra_profile_fields');

function my_save_extra_profile_fields($user_id)
{
  if (!current_user_can('edit_user', $user_id))
    return false;
  update_user_meta($user_id, 'phone', $_POST['phone']);
}

//auth with phone number
function authWithPhoneNumber($request)
{
  global $wpdb;
  $tablename = $wpdb->prefix . 'otptokens';
  $params = $request->get_params();
  $phone = $params['phone'];
  $is_web = $params['web'] || false;

  if (isset($phone) && !empty($phone) && (strlen(trim($phone)) == 11)) {
    if (isset($params['user_otp']) && !empty($params['user_otp'])) {
      //check userotp with generated otp in db
      $query = $wpdb->get_results("SELECT * FROM $tablename WHERE mobile = $phone AND is_expire = 0 ORDER BY ID DESC LIMIT 1");

      if ($query) {
        $savedToken = $query[0]->token;
        $id = $query[0]->id;
        if ($savedToken == $params['user_otp']) {
          //expire token
          $wpdb->query($wpdb->prepare("UPDATE $tablename SET is_expire= 1 WHERE id=$id"));
          //find user by phone number
          $user = get_users(array(
            'meta_key'     => 'phone',
            'meta_value'   => $phone,
            'meta_compare' => '=',
          ));
          //check user have account
          if ($user) {
            $vip = '';
            if (class_exists('Restrict_Content_Pro')) {
              $vip = rcp_user_has_active_membership($user[0]->data->ID);
            }
            if ($is_web) {
              // return $user;
              $password =  $user[0]->data->user_pass;
              // return 'az to filter';
              if ($user instanceof WP_User) {
                return $user;
              }

              if ( empty($phone) || empty($password) ) {
                if (is_wp_error($user)) {
                  return $user;
                }

                $error = new WP_Error();

                if (empty($phone)) {
                  // Uses 'empty_username' for back-compat with wp_signon().
                  $error->add('empty_username', __('<strong>Error</strong>: The phone field is empty.', 'actions-pack'));
                }

                if (empty($password)) {
                  $error->add('empty_password', __('<strong>Error</strong>: The password field is empty.', 'actions-pack'));
                }

                return $error;
              }

              $user2 = get_users(['meta_key' => 'phone', 'meta_value' => $phone, 'number' => 1, 'count_total' => false])[0];

              if (!$user2) {
                return new WP_Error(
                  'invalid_phone',
                  __('Unknown phone number. Check again or try your username.', 'actions-pack')
                );
              }

              /** This filter is documented in wp-includes/user.php */
              $user2 = apply_filters('wp_authenticate_user', $user, $password);

              if ($user2) {

                wp_set_current_user($user2[0]->data->ID, $user2[0]->data->user_login);
                wp_set_auth_cookie($user2[0]->data->ID, true);
                do_action('wp_login', $user2[0]->data->user_login, $user2);

                wp_send_json(array(
                  'code' => 200,
                  'msg' => __('Login Successful, Redirecting..', 'digits'),
                  'redirect' => '/panel'
                ));
              }

              if (is_wp_error($user2)) {
                return $user2;
              }
              return $user2;
            } else {
              // mobile 
              // generate jwt token 
              $jwt_instance = new Jwt_Auth_Public('jwt-auth', '1');
              $generated_token = $jwt_instance->kelaket_generate_token( $phone );
              
              $generated_token += ['code' => 200];
              return $generated_token;

              // return [
              //   'token' => $generated_token,
              //   'user_email' => $user[0]->data->user_email,
              //   'user_nicename' => $user[0]->data->user_nicename,
              //   'user_display_name' => $user[0]->data->display_name,
              //   'id' => $user[0]->data->ID,
              //   'activeSubscribe' => $vip,
              //   'code' => 200
              // ];
            }
          } else {
            //register user with that phone number
            $vip = '';
            $username = $phone;
            $password = $phone;
            $email = $phone . '@gmail.com';
            $create_user = wp_create_user($username, $password, $email);
            if (!is_wp_error($create_user)) {
              $RegistredUser = get_user_by('id', $create_user);
              $RegistredUser->set_role('subscriber');
              update_user_meta($RegistredUser->id, 'phone', $phone);
              if (class_exists('Restrict_Content_Pro')) {
                $vip = rcp_user_has_active_membership($RegistredUser->data->ID);
              }
              if ($is_web) {
                //req from web
                $user2 = get_users(['meta_key' => 'phone', 'meta_value' => $phone, 'number' => 1, 'count_total' => false])[0];

                if ($user2) {
                  wp_set_current_user($user2->data->ID, $user2->data->user_login);
                  wp_set_auth_cookie($user2->data->ID, true);
                  do_action('wp_login', $user2->data->user_login, $user2);

                  wp_send_json(array(
                    'code' => 200,
                    'msg' => __('Login Successful, Redirecting..', 'digits'),
                    'redirect' => '/panel'
                  ));
                }
              } else {
                $jwt_instance = new Jwt_Auth_Public('jwt-auth', '1');
                $generated_token = $jwt_instance->kelaket_generate_token( $phone );
                
                $generated_token += ['code' => 200];
                return $generated_token;
                // return [
                //   'token' => '123',
                //   'user_email' => $RegistredUser->data->user_email,
                //   'user_nicename' => $RegistredUser->data->user_nicename,
                //   'user_display_name' => $RegistredUser->data->display_name,
                //   'id' => $RegistredUser->data->ID,
                //   'activeSubscribe' => $vip
                // ];
              }
            }
          }

          //if dont have account create account 
          return [
            'code' => 200,
            'message' => 'ورود موفقیت آمیز'
          ];
        }
      } else {
        return [
          'code' => 302,
          'message' => 'توکن منقضی شده'
        ];
      }
      return [
        'code' => 301,
        'message' => 'توکن باطل شده'
      ];
    } else {
      $otpToken = rand(100000, 999999);
      $data = array(
        'token' => $otpToken,
        'mobile' => $phone,
        'is_expire' => 0,
        'created_at' => wp_date('Y-m-d h:i:s', time()),
      );
      $wpdb->insert($tablename, $data);
      //send sms to phone number
      $config = get_option('my_framework');
      $api_key = $config['api_key_sms'];
      $pattern_code = $config['pattern_sms'];
      $fnum = $config['number_sms'];
      $username = htmlspecialchars_decode($config['sms_user']);
      $password = htmlspecialchars_decode($config['sms_pass']);

      if($config['sms_provider'] == 'faraz_sms'){
        /**
         * Faraz SMS Normal SMS Send method With api key
         */
        $api_url = "http://ippanel.com:8080/?apikey=$api_key&pid=$pattern_code&fnum=$fnum&tnum=$phone&p1=code&v1=$otpToken";
      }elseif ($config['sms_provider'] == 'kaveh_negar') {
        /**
         * KaveNegar sms Lookup Method
         * docs: https://www.melipayamak.com/api/sendbybasenumber2/
         */
        $api_url = "https://api.kavenegar.com/v1/$api_key/verify/lookup.json?receptor=$phone&token=$otpToken&template=$pattern_code";
      }elseif($config['sms_provider'] == 'meli_payamak'){
        /**
         * Meli Payamak sendbybasenumber2 Method
         * Todo: issue with &amp; in urls
         * docs: https://www.melipayamak.com/api/sendbybasenumber2/
         */
        $api_url = "http://api.payamak-panel.com/post/Send.asmx/SendByBaseNumber2?username=$username&password=$password&text=$otpToken&to=$phone&bodyId=$pattern_code";
      }

      $request = wp_remote_get($api_url);
      // if (is_wp_error($request)) {
      //     return false;
      // }

      return [
        'code' => 201,
        'message' => 'توکن با موفقیت ارسال شد.',
        'req' => $request,
      ];
    }
  }
  return [
    'code' => 300,
    'message' => 'یافت نشد!'
  ];
}

add_action('rest_api_init', function () {
  register_rest_route('mobile/v1', '/auth', array(
    'methods' => 'POST',
    'callback' => 'authWithPhoneNumber',
  ));
});
