<?php
$config = get_option('my_framework');
$genre = isset($_GET['_genre']) ? $_GET['_genre'] : '';
$post_type = isset($_GET['post-type']) ? $_GET['post-type'] : '';
$sort = isset($_GET['sort']) ? $_GET['sort'] : 'newest';
$from_year = isset($_GET['fromYear']) ? $_GET['fromYear'] : '';
$to_year = isset($_GET['toYear']) ? $_GET['toYear'] : '';
$country = isset($_GET['_country']) ? $_GET['_country'] : '';
$rate = isset($_GET['_rates']) ? $_GET['_rates'] : '';
$score = isset($_GET['_score']) ? $_GET['_score'] : '';
$subtitle = isset($_GET['subtitle']) ? $_GET['subtitle'] : false;
$doble = isset($_GET['doble']) ? $_GET['doble'] : false;
$playonline = isset($_GET['playonline']) ? $_GET['playonline'] : false;
$final_post_type = [];
if ($post_type == 'all') {
  $temp = get_terms(['taxonomy' => 'type_of_post', 'hide_empty' => false]);
  foreach ($temp as $t) {
    array_push($final_post_type, $t->slug);
  }
} else {
  array_push($final_post_type, $post_type);
}
if ($sort == 'oldest') {
  $sort = 'ASC';
} else {
  $sort = 'DESC';
}
$year_range = [];
if ($from_year && $to_year) {
  for ($x = $from_year; $x <= $to_year; $x++) {
    array_push($year_range, $x);
  }
}
?>
<?php get_header(); ?>

<div class="container after_fe2">
  <div class="category_title text-center">
    <h3 class=""><?php _e('نتایج جستجوی پیشرفته', 'kelaketfilm'); ?></h3>
  </div>
  <?php 
    get_template_part('new', 'searchform', array('archive' => true));
  ?>
  <div class="row pt-4">
    <div class="<?php echo $config['post_show_type'] == "default" || $config['post_show_type'] == "secondary" ? 'col-xl-9 col-lg-8 col-md-12 col-sm-12 col-xs-12 col-xxl-9 my-3' : ''?>">
      <?php include('inc/template_parts/filter_query.php'); ?>
      <?php
      //check if not posts show notfound
      if(!$the_query->have_posts()) {
        get_template_part('inc/template_parts/posts/template/not_found');
      }
      if ($the_query->have_posts() && $config['post_show_type'] == "default") :
        if($config['post_style'] == 'minimal'){
          echo '<div class="row">';
        }
        while ($the_query->have_posts()) : $the_query->the_post();
          get_template_part('inc/template_parts/posts/template/default');
        endwhile;
        if($config['post_style'] == 'minimal'){
          echo '</div>';
        }
      endif;
      wp_reset_postdata(); 

      if ($the_query->have_posts() && $config['post_show_type'] == "category") :?>
        <div class="row">
         <?php while ($the_query->have_posts()) : $the_query->the_post();
          get_template_part('inc/template_parts/posts/template/namava_archive');
        endwhile;?>
        </div>
      <?php endif;
      wp_reset_postdata(); 
      
      ?>

      <div class="row">
        <?php if ($the_query->have_posts() && $config['post_show_type'] == "secondary") : while ($the_query->have_posts()) : $the_query->the_post();
            get_template_part('inc/template_parts/posts/template/secondary');
          endwhile;
        endif;
        wp_reset_postdata();
        ?>
      </div>
      <div class="pagination">
        <?php
        echo paginate_links(array(
          'base' => str_replace(999999999, '%#%', esc_url(get_pagenum_link(999999999))),
          'total' => $the_query->max_num_pages,
          'current' => max(1, get_query_var('paged')),
          'format' => '?paged=%#%',
          'show_all' => false,
          'type' => 'plain',
          'end_size' => 2,
          'mid_size' => 1,
          'prev_next' => true,
          'prev_text' => sprintf('<i></i> %1$s', __('قبلی', 'kelaketfilm')),
          'next_text' => sprintf('%1$s <i></i>', __('بعدی', 'kelaketfilm')),
          'add_args' => false,
          'add_fragment' => '',
        ));
        ?>
      </div>
    </div>


    <?php
    if($config['post_show_type'] == "default" || $config['post_show_type'] == "secondary"){
      get_sidebar();
    }
    ?>
  </div>
</div>


<?php get_footer(); ?>


</div>

<?php get_footer(); ?>