<form method="get" id="advanced-searchform" role="search" action="<?php echo esc_url(home_url('/')); ?>">

  <h3><?php _e('فیلترهای جستجو', 'kelaketfilm'); ?></h3>

  <input type="hidden" name="search" value="advanced">
  <input type="hidden" name="s" value="">

  <?php
  $post_type = get_terms(
    array(
      'taxonomy'   => 'type_of_post',
      'hide_empty' => false
    )
  );
  $genres = get_terms(
    array(
      'taxonomy'   => 'genre',
      'hide_empty' => false
    )
  );
  $years = get_terms(
    array(
      'taxonomy'   => 'yearr',
      'hide_empty' => false
    )
  );
  $country = get_terms(
    array(
      'taxonomy'   => 'country',
      'hide_empty' => false
    )
  );
  $rates = get_terms(
    array(
      'taxonomy'   => 'rate',
      'hide_empty' => false
    )
  );
  $scores = get_terms(
    array(
      'taxonomy'   => 'score',
      'hide_empty' => false
    )
  );
  ?>
  <div class="search_filter">
    <a href="#search_filter_1">
      <?php
      if (isset($_REQUEST['post-type'])) :
        $post_type_s = esc_sql($_REQUEST['post-type']);
        if ($post_type_s && $post_type_s !== 'all') {
          echo get_term_by('slug', $post_type_s, 'type_of_post')->name;
        } else {
          echo __('همه', 'kelaketfilm');
        }
      else : echo __('همه', 'kelaketfilm');
      endif;
      ?>
    </a>
    <div class="search_filer_box filer_box_1">
      <label class="custom-checkbox"><?php _e('همه', 'kelaketfilm') ?>
        <input type="radio" name="post-type" value="all" checked="checked">
        <span class="checkmark"></span>
      </label>
      <?php
      foreach ($post_type as $type) { ?>
        <label class="custom-checkbox"><?php _e($type->name, 'textdomain'); ?>
          <input type="radio" value="<?php echo $type->slug ?>" <?php if (!empty($post_type_s) && $post_type_s == $type->slug) {
                                                                  echo 'checked';
                                                                } ?> name="post-type">
          <span class="checkmark"></span>
        </label>
      <?php } ?>
    </div>
  </div>

  <div class="search_filter">
    <a href="#search_filter_2"><?php _e('ژانر', 'kelaketfilm') ?></a>
    <div class="search_filer_box filer_box_2">
      <?php
      if (isset($_REQUEST['_genre'])) :
        $genre_s = esc_sql($_REQUEST['_genre']);
      endif;
      // var_dump($genre_s);
      foreach ($genres as $genre) { ?>
        <label class="custom-checkbox"><?php _e($genre->name, 'textdomain'); ?>
          <input type="checkbox" value="<?php echo $genre->slug ?>" <?php if (!empty($genre_s) && in_array($genre->slug, $genre_s)) {
                                                                      echo 'checked';
                                                                    } ?> name="_genre[]">
          <span class="checkmark"></span>
        </label>
      <?php } ?>
    </div>
  </div>


  <div class="search_filter">
    <a href="#search_filter_3"><?php _e('نمایش بر اساس', 'kelaketfilm'); ?></a>
    <div class="search_filer_box filer_box_3">
      <label class="custom-radio"><?php _e('جدیدترین', 'kelaketfilm'); ?>
        <input type="radio" value="newest" name="sort">
        <span class="checkmark"></span>
      </label>

      <label class="custom-radio"><?php _e('قدیمی ترین', 'kelaketfilm'); ?>
        <input type="radio" value="oldest" name="sort">
        <span class="checkmark"></span>
      </label>
    </div>
  </div>

  <div class="search_filter year_filter">
    <?php
    if (isset($_REQUEST['fromYear']) && isset($_REQUEST['toYear'])) :
      $fromYear_s = esc_sql($_REQUEST['fromYear']);
      $toYear_s = esc_sql($_REQUEST['toYear']);
    else :
      $fromYear_s = null;
      $toYear_s = null;
    endif;
    ?>
    <a href="#search_filter_4" style="">
      <?php
      if ($fromYear_s) {
        echo $fromYear_s;
      } else {
        echo __('از سال', 'kelaketfilm');
      }
      ?>
    </a>
    <div class="search_filer_box filer_box_4 year_box">

      <?php
      foreach ($years as $year) { ?>
        <label class="custom-radio"><?php _e($year->name, 'textdomain'); ?>
          <input type="radio" value="<?php _e($year->slug, 'textdomain'); ?>" <?php if (!empty($fromYear_s) && $fromYear_s == $year->slug) {
                                                                                echo 'checked';
                                                                              } ?> name="fromYear">
          <span class="checkmark"></span>
        </label>
      <?php } ?>
    </div>
  </div>

  <div class="search_filter year_filter">
    <a href="#search_filter_5" style="">
      <?php
      if ($toYear_s) {
        echo $toYear_s;
      } else {
        echo __('تا سال', 'kelaketfilm');
      }
      ?>
    </a>
    <div class="search_filer_box filer_box_5 year_box">
      <?php
      foreach ($years as $year) { ?>
        <label class="custom-radio"><?php _e($year->name, 'textdomain'); ?>
          <input type="radio" value="<?php _e($year->slug, 'textdomain'); ?>" <?php if (!empty($toYear_s) && $toYear_s == $year->slug) {
                                                                                echo 'checked';
                                                                              } ?> name="toYear">
          <span class="checkmark"></span>
        </label>
      <?php } ?>
    </div>
  </div>
  <div class="search_filter">
    <a href="#search_filter_6">
      <?php
      if (isset($_REQUEST['_country'])) :
        $country_s = esc_sql($_REQUEST['_country']);
      else :
        $country_s = null;
      endif;
      if ($country_s) {
        echo get_term_by('slug', $country_s, 'country')->name;
      } else {
        echo __('کشور سازنده', 'kelaketfilm');
      }
      ?>
    </a>
    <div class="search_filer_box filer_box_6">
      <?php
      foreach ($country as $ctry) { ?>
        <label class="custom-radio"><?php _e($ctry->name, 'textdomain'); ?>
          <input type="radio" value="<?php _e($ctry->slug, 'textdomain'); ?>" <?php if (!empty($country_s) && $country_s == $ctry->slug) {
                                                                                echo 'checked';
                                                                              } ?> name="_country">
          <span class="checkmark"></span>
        </label>
      <?php } ?>
    </div>
  </div>

  <div class="search_filter">
    <a href="#search_filter_7">
      <?php
      if (isset($_REQUEST['_rates'])) :
        $rate_s = esc_sql($_REQUEST['_rates']);
      else :
        $rate_s = null;
      endif;
      if ($rate_s) {
        echo $rate_s;
      } else {
        echo __('رده سنی', 'kelaketfilm');
      }
      ?>
    </a>
    <div class="search_filer_box filer_box_7">
      <?php
      foreach ($rates as $rate) { ?>
        <label class="custom-radio"><?php _e($rate->name, 'textdomain'); ?>
          <input type="radio" value="<?php _e($rate->slug, 'textdomain'); ?>" <?php if (!empty($rate_s) && $rate_s == $rate->slug) {
                                                                                echo 'checked';
                                                                              } ?> name="_rates">
          <span class="checkmark"></span>
        </label>
      <?php } ?>
    </div>
  </div>

  <div class="search_filter">
    <a href="#search_filter_8">
      <?php
      if (isset($_REQUEST['_score'])) :
        $score_s = esc_sql($_REQUEST['_score']);
      else :
        $score_s = null;
      endif;

      if ($country_s) {
        echo get_term_by('slug', $score_s, 'score')->name;
      } else {
        echo __('امتیاز', 'kelaketfilm');
      }
      ?>
    </a>
    <div class="search_filer_box filer_box_8">
      <?php
      foreach ($scores as $score) { ?>
        <label class="custom-radio"><?php _e($score->name, 'textdomain'); ?>
          <input type="radio" value="<?php _e($score->slug, 'textdomain'); ?>" <?php if (!empty($score_s) && $score_s == $score->slug) {
                                                                                  echo 'checked';
                                                                                } ?> name="_score">
          <span class="checkmark"></span>
        </label>
      <?php } ?>
    </div>
  </div>
  <div class="search_filter do">
    <?php
    if (isset($_REQUEST['doble'])) :
      $doble_s = esc_sql($_REQUEST['doble']);
    else :
      $doble_s = null;
    endif;
    if (isset($_REQUEST['subtitle'])) :
      $subtitle_s = esc_sql($_REQUEST['subtitle']);
    else :
      $subtitle_s = null;
    endif;
    ?>
    <label class="custom-checkbox d-inline-block m-2"><?php _e('دوبله فارسی', 'kelaketfilm') ?>
      <input type="checkbox" value="true" <?php if (!empty($doble_s)) {
                                            echo 'checked';
                                          } ?> name="doble">
      <span class="checkmark"></span>
    </label>
    <label class="custom-checkbox d-inline-block m-2"><?php _e('زیرنویس فارسی', 'kelaketfilm') ?>
      <input type="checkbox" value="true" <?php if (!empty($subtitle_s)) {
                                            echo 'checked';
                                          } ?> name="subtitle">
      <span class="checkmark"></span>
    </label>
  </div>

  <input type="submit" id="searchsubmit" value="<?php _e('جستجو', 'kelaketfilm') ?>" />

</form>