<?php
if ( post_password_required() ) {
   return;
}
?>

<div id="comments" class="comments-area">

    <?php

    // You can start editing here -- including this comment!
    if ( have_comments() ) :  ?>

        <?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : // Are there comments to navigate through? ?>
        <?php endif; // Check for comment navigation. ?>

        <ol class="comment-list">
            <?php
                wp_list_comments('type=comment&callback=mycomments');
            ?>
        </ol><!-- .comment-list -->

        <?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : // Are there comments to navigate through? ?>
        <nav id="comment-nav-below" class="navigation comment-navigation" role="navigation">
          <div class="nav-links">
            <div class="nav-previous"><?php previous_comments_link( esc_html__( 'نمایش دیدگاه های قدیمی تر', 'kelaketfilm' ) ); ?></div>
            <div class="nav-next"><?php next_comments_link( esc_html__( 'نمایش دیدگاه های جدید تر', 'kelaketfilm' ) ); ?></div>
          </div><!-- .nav-links -->
        </nav><!-- #comment-nav-below -->
        <?php
        endif; // Check for comment navigation.

    endif; // Check for have_comments().


    // If comments are closed and there are comments, let's leave a little note
    if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) : ?>

        <p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'wphierarchy' ); ?></p>
    <?php
    endif;

    ?>
<?php
comment_form(
  array(
      'title_reply'  => __('دیدگاهتان را بنویسید!', 'kelaketfilm'),
      'cancel_reply_link'     => '<i class="fa-solid fa-xmark"></i>'.__('لغو پاسخ', 'kelaketfilm'),
      'comment_field' => '<div class="comment-form comment-text"><textarea id="comment" placeholder="'.__('نظرتان را بنویسید', 'kelaketfilm').'" name="comment" cols="45" rows="2" maxlength="65525" required="required" class="form-control"></textarea></div>',
      'fields' =>  array(
        'author' => '<div class="d-flex mb-3 gap-3"><div class="comment-form comment-name "><input class="form-control" id="author" placeholder="'.__('نام شما', 'kelaketfilm').'" name="author" type="text" value="" size="30" maxlength="245" required="required"></div>',
        'email' => '<div class="comment-form comment-email"><input class="form-control" id="email" placeholder="'.__('ایمیل شما', 'kelaketfilm').'" name="email" type="text" value="" size="30" maxlength="100" aria-describedby="email-notes" required="required"></div></div>',
      )
  )
);
?>
</div><!-- #comments -->