<?php
$config = get_option('my_framework');
$style = '';

if (!function_exists('elementor_theme_do_location') || !elementor_theme_do_location('footer')) : ?>
  <?php if (theme_options('footer_style') == 'default') : ?>
    <footer style="<?php echo $style ?>" class="footer">
      <div class="container">
        <div class="row">
          <div class="about col-xxl-3 col-xl-3 col-lg-3 col-md-4 col-sm-12 col-xs-6">
            <div class="logo">
              <a href="<?php bloginfo('url') ?>">
                <?php if ($config['logo_image']['url']) : ?>
                  <img src="<?php echo $config['logo_image']['url']; ?>" alt="logo" class="logo_img" />
                <?php else : ?>
                  <img src="<?php echo get_template_directory_uri(); ?>/images/logo.png" alt="logo" class="logo_img" />
                <?php endif; ?>
                <span><?php echo $config['logo_text']; ?></span>
              </a>
            </div>
            <p><?php echo $config['about']; ?></p>
            <div class="social">
              <ul>
                <?php if ($config['instagram']) { ?><li class="instagram"><a href="<?php echo $config['instagram'] ?>"><i class="fa-brands fa-instagram"></i></a></li><?php } ?>
                <?php if ($config['twitter']) { ?><li class="twitter"><a href="<?php echo $config['twitter'] ?>"><i class="fa-brands fa-twitter"></i></a></li><?php } ?>
                <?php if ($config['facebook']) { ?><li class="facebook"><a href="<?php echo $config['facebook'] ?>"><i class="fa-brands fa-facebook-f"></i></a></li><?php } ?>
                <?php if ($config['youtube']) { ?><li class="youtube"><a href="<?php echo $config['youtube'] ?>"><i class="fa-brands fa-youtube"></i></a></li><?php } ?>
                <?php if ($config['telegram']) { ?><li class="telegram"><a href="<?php echo $config['telegram'] ?>"><i class="fa-brands fa-telegram"></i></a></li><?php } ?>
                <?php if ($config['skype']) { ?><li class="skype"><a href="<?php echo $config['skype'] ?>"><i class="fa-brands fa-skype"></i></a></li><?php } ?>
                <?php if ($config['discord']) { ?><li class="discord"><a href="<?php echo $config['discord'] ?>"><i class="fa-brands fa-discord"></i></a></li><?php } ?>
              </ul>
            </div>
          </div>
          <div class="links col-xxl-2 offset-xxl-1 col-xl-2 offset-xl-1 col-lg-3 col-md-4 col-sm-6 col-xs-6">
            <h3><i class="fa fa-link"></i><?php echo wp_get_nav_menu_name('foot-menu-1') ?></h3>
            <?php wp_nav_menu(array('theme_location' => 'foot-menu-1', 'container' => '', 'menu_class' => 'menunav')); ?>
          </div>
          <div class="links col-xxl-2 offset-xxl-1 col-xl-2 offset-xl-1 col-lg-3 col-md-4 col-sm-6 col-xs-6">
            <h3><i class="fa fa-link"></i><?php echo wp_get_nav_menu_name('foot-menu-2') ?></h3>
            <?php wp_nav_menu(array('theme_location' => 'foot-menu-2', 'container' => '', 'menu_class' => 'menunav')); ?>
          </div>
          <div class="extra col-xxl-3 col-xl-3 col-lg-3 col-md-12 col-sm-12 col-xs-6">
            <div class="btn-large request">
              <a href="<?php bloginfo('url'); ?>/panel/?action=req">
                <i class="fa fa-folders"></i>
                <span><?php _e('درخواست فیلم', 'kelaketfilm'); ?></span>
                <i class="fa fa-chevron-left"></i>
              </a>
            </div>
            <div class="btn-large blog">
              <a href="<?php bloginfo('url'); ?>/blog">
                <i class="fa fa-newspaper"></i>
                <span><?php _e('اخبار دنیای فیلم و سریال', 'kelaketfilm'); ?></span>
                <i class="fa fa-chevron-left"></i>
              </a>
            </div>
          </div>
        </div>
      </div>
      <div class="copyright">
        <div class="container">
          <div><?php echo $config['copyright']; ?></div>
        </div>
      </div>
    </footer>
  <?php elseif (theme_options('footer_style') == 'modern') : ?>
    <footer style="<?php echo $style ?>" class="footer footer_modern">
      <div class="logo">
        <a href="<?php bloginfo('url') ?>">
          <?php if ($config['logo_image']['url']) : ?>
            <img src="<?php echo $config['logo_image']['url']; ?>" alt="logo" class="logo_img" />
          <?php else : ?>
            <img src="<?php echo get_template_directory_uri(); ?>/images/logo.png" alt="logo" class="logo_img" />
          <?php endif; ?>
          <span><?php echo $config['logo_text']; ?></span>
        </a>
      </div>
      <div class="container">
        <div class="row g-5">
          <div class="col-lg-4">
            <div class="row">
              <div class="col-lg-6 links">
                <h3><span><?php echo wp_get_nav_menu_name('foot-menu-1') ?></span></h3>
                <?php wp_nav_menu(array('theme_location' => 'foot-menu-1', 'container' => '', 'menu_class' => 'menunav')); ?>
              </div>
              <div class="col-lg-6 links">
                <h3><span><?php echo wp_get_nav_menu_name('foot-menu-2') ?></span></h3>
                <?php wp_nav_menu(array('theme_location' => 'foot-menu-2', 'container' => '', 'menu_class' => 'menunav')); ?>
              </div>
            </div>
          </div>
          <div class="col-lg-4 about">
            <p class="mt-3"><?php echo $config['about']; ?></p>


            <div class="social">
              <ul>
                <?php if ($config['instagram']) { ?><li class="instagram"><a href="<?php echo $config['instagram'] ?>"><i class="fa-brands fa-instagram"></i></a></li><?php } ?>
                <?php if ($config['twitter']) { ?><li class="twitter"><a href="<?php echo $config['twitter'] ?>"><i class="fa-brands fa-twitter"></i></a></li><?php } ?>
                <?php if ($config['facebook']) { ?><li class="facebook"><a href="<?php echo $config['facebook'] ?>"><i class="fa-brands fa-facebook-f"></i></a></li><?php } ?>
                <?php if ($config['youtube']) { ?><li class="youtube"><a href="<?php echo $config['youtube'] ?>"><i class="fa-brands fa-youtube"></i></a></li><?php } ?>
                <?php if ($config['telegram']) { ?><li class="telegram"><a href="<?php echo $config['telegram'] ?>"><i class="fa-brands fa-telegram"></i></a></li><?php } ?>
                <?php if ($config['skype']) { ?><li class="skype"><a href="<?php echo $config['skype'] ?>"><i class="fa-brands fa-skype"></i></a></li><?php } ?>
                <?php if ($config['discord']) { ?><li class="discord"><a href="<?php echo $config['discord'] ?>"><i class="fa-brands fa-discord"></i></a></li><?php } ?>
              </ul>
            </div>

          </div>
          <div class="col-lg-4 extra">
            <div class="btn-large request">
              <a href="<?php bloginfo('url'); ?>/panel/?action=req">
                <i class="fa fa-folders"></i>
                <span><?php _e('درخواست فیلم', 'kelaketfilm'); ?></span>
                <i class="fa fa-chevron-left"></i>
              </a>
            </div>
            <div class="btn-large blog">
              <a href="<?php bloginfo('url'); ?>/blog">
                <i class="fa fa-newspaper"></i>
                <span><?php _e('اخبار دنیای فیلم و سریال', 'kelaketfilm'); ?></span>
                <i class="fa fa-chevron-left"></i>
              </a>
            </div>
            <?php if (theme_options('appBanner')) : ?>
              <div class="btn-large blog">
                <a href="<?php echo theme_options('app_link'); ?>">
                  <i class="fa-brands fa-android"></i>
                  <span><?php echo theme_options('app_text'); ?></span>
                  <i class="fa fa-chevron-left"></i>
                </a>
              </div>
            <?php endif; ?>
          </div>
        </div>
      </div>
      <div class="copyright">
        <div class="container">
          <div><?php echo $config['copyright']; ?></div>
        </div>
      </div>
    </footer>
  <?php elseif (theme_options('footer_style') == 'minimal') : ?>
    <div class="container">
      <footer class="footer footer_minimal">
        <div class="row">
          <div class="about col-lg-4 offset-lg-1">
            <div class="logo">
              <a href="<?php bloginfo('url') ?>">
                <?php if ($config['logo_image']['url']) : ?>
                  <img src="<?php echo $config['logo_image']['url']; ?>" alt="logo" class="logo_img" />
                <?php else : ?>
                  <img src="<?php echo get_template_directory_uri(); ?>/images/logo.png" alt="logo" class="logo_img" />
                <?php endif; ?>
                <span><?php echo $config['logo_text']; ?></span>

                <span class="desc"><?php bloginfo('description') ?></span>
              </a>
            </div>
            <p><?php echo $config['about']; ?></p>
          </div><!-- /.col-lg-4 -->
          <div class="links col-lg-3 offset-lg-1">
            <h3><span><?php echo wp_get_nav_menu_name('foot-menu-1') ?></span></h3>
            <?php wp_nav_menu(array('theme_location' => 'foot-menu-1', 'container' => '', 'menu_class' => 'menunav')); ?>
          </div><!-- /.col-lg-3 -->
          <div class="social col-lg-3">
            <h3>
              <span>
                <?php _e(' ارتباط با') ?> <?php echo $config['logo_text']; ?>
              </span>
            </h3>

            <p><?php echo $config['contact_us_text']; ?></p>


            <a class="mini_button" href="<?php bloginfo('url') ?>/panel?action=add_ticket"><?php _e('ارسال تیکت پشتیبانی', 'kelaketfilm') ?></a>

            <div class="d-flex footer_insta">
              <?php if ($config['instagram']) { ?>
                <div class="instagram_b">
                  <a href="<?php echo $config['instagram']; ?>">
                    <svg width="30px" height="30px" fill="#fff" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve">
                      <g>
                        <path d="M352,0H160C71.648,0,0,71.648,0,160v192c0,88.352,71.648,160,160,160h192c88.352,0,160-71.648,160-160V160 C512,71.648,440.352,0,352,0z M464,352c0,61.76-50.24,112-112,112H160c-61.76,0-112-50.24-112-112V160C48,98.24,98.24,48,160,48 h192c61.76,0,112,50.24,112,112V352z"></path>
                      </g>
                      <g>
                        <path d="M256,128c-70.688,0-128,57.312-128,128s57.312,128,128,128s128-57.312,128-128S326.688,128,256,128z M256,336 c-44.096,0-80-35.904-80-80c0-44.128,35.904-80,80-80s80,35.872,80,80C336,300.096,300.096,336,256,336z"></path>
                      </g>
                      <g>
                        <circle cx="393.6" cy="118.4" r="17.056"></circle>
                      </g>
                    </svg>
                    <div>
                      <span><?php _e('پیچ اینستاگرام', 'kelaketfilm') ?></span>
                      <small>@KelaketFilm</small>
                    </div>
                  </a>
                </div>
              <?php } ?>

              <?php if ($config['telegram']) { ?>
                <div class="telegram_b">
                  <a href="<?php echo $config['telegram']; ?>">
                    <svg height="30px" width="30px" fill="#fff" viewBox="0 -39 512.00189 512" xmlns="http://www.w3.org/2000/svg">
                      <path d="m504.097656 11.863281c-6.257812-7.648437-15.625-11.863281-26.378906-11.863281-5.851562 0-12.042969 1.234375-18.410156 3.664062l-433.402344 165.441407c-23 8.777343-26.097656 21.949219-25.8984375 29.023437.1992185 7.070313 4.0390625 20.046875 27.4999995 27.507813.140626.046875.28125.085937.421876.128906l60.78125 17.390625 296.015624-151.230469c7.375-3.773437 16.414063-.84375 20.183594 6.535157 2.960938 5.796874 1.773438 12.609374-2.445312 17.09375l.011718.011718-164.585937 174.878906-4.695313 19.027344 58.773438 47.328125 81.445312 65.582031c.070313.054688.140626.113282.214844.167969 8.960938 6.953125 18.75 10.625 28.308594 10.628907 18.679688 0 33.550781-13.824219 37.882812-35.214844l71.011719-350.640625c2.847657-14.070313.457031-26.667969-6.734375-35.460938zm0 0"></path>
                      <path d="m209.714844 279.4375c.597656-2.425781 1.800781-4.738281 3.632812-6.6875l107.996094-114.753906-200.402344 102.382812 45.503906 130.136719c2.59375 7.414063 6.453126 13.726563 11.226563 18.667969l32.035156-129.75zm0 0"></path>
                      <path d="m205.601562 421.230469c10.816407-.089844 21.445313-4.652344 30.757813-13.226563l33.292969-30.65625-44.390625-35.742187zm0 0"></path>
                    </svg>
                    <div>
                      <span><?php _e('کانال تلگرام', 'kelaketfilm') ?></span>
                      <small>@KelaketTel</small>
                    </div>
                  </a>
                </div>
              <?php } ?>
            </div>
          </div><!-- /.col-lg-5 -->
        </div><!-- /.row -->

        <div class="copyright d-flex justify-content-between align-items-center">
          <?php echo $config['copyright']; ?>

          <div class="social">
            <ul>
              <?php if ($config['instagram']) { ?><li class="instagram"><a href="<?php echo $config['instagram'] ?>"><i class="fa-brands fa-instagram"></i></a></li><?php } ?>
              <?php if ($config['twitter']) { ?><li class="twitter"><a href="<?php echo $config['twitter'] ?>"><i class="fa-brands fa-twitter"></i></a></li><?php } ?>
              <?php if ($config['facebook']) { ?><li class="facebook"><a href="<?php echo $config['facebook'] ?>"><i class="fa-brands fa-facebook-f"></i></a></li><?php } ?>
              <?php if ($config['youtube']) { ?><li class="youtube"><a href="<?php echo $config['youtube'] ?>"><i class="fa-brands fa-youtube"></i></a></li><?php } ?>
              <?php if ($config['telegram']) { ?><li class="telegram"><a href="<?php echo $config['telegram'] ?>"><i class="fa-brands fa-telegram"></i></a></li><?php } ?>
              <?php if ($config['skype']) { ?><li class="skype"><a href="<?php echo $config['skype'] ?>"><i class="fa-brands fa-skype"></i></a></li><?php } ?>
              <?php if ($config['discord']) { ?><li class="discord"><a href="<?php echo $config['discord'] ?>"><i class="fa-brands fa-discord"></i></a></li><?php } ?>
            </ul>
          </div>
        </div><!-- /.copyright -->

      </footer><!-- /.footer_minimal -->
    </div>
  <?php endif; //for style 
  ?>
<?php endif; //for elementor condition 
?>



<?php
get_template_part('inc/template_parts/modal/search_modal');
?>

<button class="go_top">
  <i class="fa fa-chevron-up"></i>
</button>
<?php wp_footer(); ?>

<?php if (is_single()) : ?>
  <script>
    document.addEventListener("DOMContentLoaded", function(event) {
      Chocolat(document.querySelectorAll(".gallery .gallery_image"), {
        loop: true,
      });
    });
  </script>
<?php endif; ?>

<?php if ($config['pwa_active']) : ?>
  <script>
    if ("serviceWorker" in navigator) {
      window.addEventListener("load", function() {
        navigator.serviceWorker
          .register("<?php echo site_url() ?>/serviceWorker.js")
      })
    }
  </script>
<?php endif; ?>
<?php if ($config['footer_script']) : ?>
  <script>
    <?php echo $config['footer_script']; ?>
  </script>
<?php endif; ?>

</body>

</html>