<!doctype html>
<?php
$config = get_option('my_framework');
$default_light_theme = $config['lightMode'];
$output = $default_light_theme ? 'class="dark"' : '';
?>
<html <?php language_attributes(); ?> <?= $output; ?>>

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <?php if ($config['favicon']['url']) : ?>
    <link rel="icon" type="image/png" href="<?php echo $config['favicon']['url']; ?> ">
  <?php else : ?>
    <link rel="icon" type="image/png" href="<?php echo get_template_directory_uri(); ?>/images/favicon.png">
  <?php endif; ?>
  <?php if($config['pwa_active']): ?>
    <!-- PWA -->
    <link rel="manifest" href="<?php bloginfo('url'); ?>/manifest.json">
    <?php if($config['pwa_icon_1']['url']): ?>
    <link rel="apple-touch-icon" href="<?= $config['pwa_icon_1']['url']; ?>">
    <?php endif; ?> 
    <?php if($config['pwa_icon_2']['url']): ?>
    <link rel="apple-touch-icon" href="<?= $config['pwa_icon_2']['url']; ?>">
    <?php endif; ?> 
    <?php if($config['status_color']): ?>
    <meta name="apple-mobile-web-app-status-bar" content="<?= $config['status_color'] ?>">
    <?php endif; ?> 
    <?php if($config['theme_pwa_color']): ?>
    <meta name="theme-color" content="<?= $config['theme_pwa_color'] ?>">
    <?php endif; ?> 
  <?php endif;?>
  <script>
    var body = document.querySelector('html');
    if (localStorage.getItem("theme")) {
      var theme = localStorage.getItem("theme");
    }
    if (theme == "light") {
      body.classList.remove("dark");
    } else if (theme == "dark") {
      body.classList.add("dark");
    }
  </script>
  <?php
  wp_head();
  if (is_single()) {
    wp_enqueue_script('comment-reply');
  }
  ?>
</head>

<body <?php echo body_class() ?>>
  <?php 
  // load app install banner
  if ($config['appInstallBanner']){
    get_template_part('inc/template_parts/global/app_install_banner');
  }
  // load admin Notice
  if ($config['adminNotice'] && !is_single()){
    get_template_part('inc/template_parts/global/admin_notice');
  }
  // load float_menu
  get_template_part('inc/template_parts/global/float_menu');
  ?>
  
  <?php
  $is_single = '';
  $slider_active = '';
  $header_fluid = 'container';
  if (is_single() && 'post' == get_post_type() && ($config['single_style'] == 'default' || $config['single_style'] == 'casual') ) {
    $is_single = 'header-single';
  }
  if(isset($_GET['demo'])){
    $demo = $_GET['demo'];
    if($demo == 1){
      $is_single = 'header-single';
    }
  }
  if ($config['slider_type'] == 'slider' && !is_single() &&!is_page()) {
    $slider_active = 'header-single';
  }
  if ($config['header-fluid'] == true && $config['slider_type'] == 'slider' && is_home()) {
    $header_fluid = 'content-fluid px-2';
  }
  if($config['slider_type'] == 'mixed' && !is_single() &&!is_page() && !is_archive()){
    $slider_active = 'header-single';
  }
  if($config['slider_type'] == 'mixed' && is_front_page()){
    $slider_active = 'header-single';
  }
  if($config['slider_type'] == 'comfort' && !is_single() &&!is_page() && !is_archive()){
    $slider_active = 'header-single';
  }
  if($config['slider_type'] == 'comfort' && is_front_page()){
    $slider_active = 'header-single';
  }
  ?>

  <?php if (!function_exists('elementor_theme_do_location') || !elementor_theme_do_location('header')) : ?>
    <header id="navbar" class="header <?php echo $slider_active ?> <?php echo $is_single ?> clearfix">
      <div class="<?php echo $header_fluid ?> d-flex space-bet">
        <div class="mobile_menu_icon">
        <i class="fa-regular fa-bars"></i>
        </div>
        <div class="mobile_search_icon">
          <i class="fa-regular fa-search"></i>
        </div>
        <div class="logo">
          <a href="<?php bloginfo('url') ?>">
            <?php if ($config['logo_image']['url']) : ?>
              <img src="<?php echo $config['logo_image']['url']; ?>" alt="logo" class="logo_img" />
            <?php else : ?>
              <img src="<?php echo get_template_directory_uri(); ?>/images/logo.png" alt="logo" class="logo_img" />
            <?php endif; ?>
            <span><?php echo $config['logo_text']; ?></span>
          </a>
        </div>
        <nav class="top_nav">
          <?php wp_nav_menu(array('theme_location' => 'category', 'container' => '', 'menu_class' => 'menunav')); ?>
        </nav>


        <div class="go-left">
          <div class="search_form">
            <?php
            get_search_form();
            ?>
          </div>
          <div class="login_register">
            <button data-bs-custom-class="panel-tooltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="<?php _e('تغییر تم', 'kelaketfilm') ?>" class="night_mode panel_button">
              <i class="fa dark_toggle fa-moon"></i>
            </button>
          </div>
          <?php if (!is_user_logged_in()) { ?>
            <div class="login_register">
              <?php if ($config['mobile-auth']) : ?>
                <a data-bs-custom-class="panel-tooltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="<?php _e('ورود/عضویت', 'kelaketfilm') ?>" class="panel_button" href="<?php bloginfo('url') ?>/auth"><i class="fa fa-arrow-right-to-arc"></i></a>
              <?php else : ?>
                <a data-bs-custom-class="panel-tooltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="<?php _e('ورود به حساب کاربری', 'kelaketfilm') ?>" class="panel_button" href="<?php bloginfo('url') ?>/login"><i class="fa fa-arrow-right-to-arc"></i></a>
              <?php endif; ?>
            </div>
          <?php } else {
            $current_user = wp_get_current_user();
          ?>

            <div class="login_register">
              <a id="panel_user" data-bs-custom-class="panel-tooltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="<?php _e('پنل کاربری', 'kelaketfilm') ?>" class="panel_button" href="<?php bloginfo('url') ?>/panel/?action=dashboard"><i class="fa fa-objects-column"></i></a>
              <div class="panel_items">
                <ul>
                  <li>
                    <a href="<?php bloginfo('url') ?>/panel?action=dashboard">
                      <?php echo get_avatar($current_user->ID); ?>

                      <?php echo $current_user->display_name; ?>
                      <span><?php _e('مشاهده پنل کاربری', 'kelaketfilm') ?><i class="fa-light <?php echo is_rtl() ? 'fa-chevron-left' : 'fa-chevron-right' ?>"></i></span>

                      <?php
                      if($config['vip']):
                      if (function_exists('rcp_user_has_active_membership') && rcp_user_has_active_membership($current_user->ID)) { ?>
                        <span class="text-success bold mt-1"><?php _e('اشتراک دارید', 'kelaketfilm') ?></span>
                      <?php } else { ?>
                        <span class="text-danger bold mt-1"><?php _e('اشتراک ندارید', 'kelaketfilm') ?></span>
                      <?php }endif; ?>
                    </a>
                  </li>
                  <?php
                  if($config['vip']):
                  if (function_exists('rcp_user_has_active_membership') && rcp_user_has_active_membership($current_user->ID)) { ?>
                    <li>
                      <a href="<?php bloginfo('url') ?>/panel?action=vip"><i class="fa fa-gem"></i> <small><?php _e('وضعیت اشتراک', 'kelaketfilm') ?></small></a>
                    </li>
                  <?php } else { ?>
                    <li>
                      <a href="<?php bloginfo('url') ?>/panel?action=vip"><i class="fa fa-gem"></i> <small><?php _e('خرید اشتراک', 'kelaketfilm') ?></small></a>
                    </li>
                  <?php }endif; ?>
                  <li>
                    <a href="<?php bloginfo('url') ?>/panel?action=lists"><i class="fa fa-list"></i> <small><?php _e('لیست های سفارشی', 'kelaketfilm') ?></small></a>
                  </li>
                  <li>
                    <a href="<?php bloginfo('url') ?>/panel?action=tickets"><i class="fa fa-ticket"></i> <small><?php _e('تیکت ها', 'kelaketfilm') ?></small></a>
                  </li>
                  <li>
                    <a href="<?php bloginfo('url') ?>/panel?action=req"><i class="fa fa-film"></i> <small><?php _e('درخواست فیلم و سریال', 'kelaketfilm') ?></small></a>
                  </li>
                  <li>
                    <a href="<?php bloginfo('url') ?>/panel?action=watchlist"><i class="fa fa-bookmark"></i> <small><?php _e('لیست تماشا', 'kelaketfilm') ?></small></a>
                  </li>
                  <li>
                    <a href="<?php echo wp_logout_url(site_url()) ?>"><i class="fa fa-arrow-right-from-bracket"></i> <small><?php _e('خروج از حساب کاربری', 'kelaketfilm') ?></small></a>
                  </li>
                </ul>
              </div>
            </div>
          <?php } ?>
        </div>
      </div>
    </header>
  <?php endif; ?>
  