<?php
if( ! class_exists( 'WP_List_Table' ) ) {
  require_once( ABSPATH . 'wp-admin/includes/class-wp-list-table.php' );
}

class Lists_Table extends WP_List_Table {

  function get_columns(){
    $columns = array(
      'title' => 'نام لیست',
      'desc'    => 'توضیحات',
      'author'    => 'سازنده',
      'created_at'      => 'تاریخ ایجاد',
      'updated_at'      => 'تاریخ بروزرسانی'
    );
    return $columns;
  }


  function table_data(){
    global $wpdb;
    $table_name = $wpdb->prefix.'kelaket_lists';
    $data = [];
    $query = " 
      SELECT * 
      FROM $table_name
      ORDER BY created_at DESC
    ";
      
    $res = $wpdb->get_results($query);

    foreach($res as $list){
      $data[] = [
        'ID' => $list->id,
        'title' => $list->name,
        'desc' => $list->list_desc,
        'created_at' => $list->created_at,
        'updated_at' => $list->updated_at,
        'author' => get_user_by('id', $list->user_id)->display_name
      ];
    }

    return $data;
  }
  
  function prepare_items() {
    $columns = $this->get_columns();
    $hidden = array();
    $sortable = array();
    $this->_column_headers = array($columns, $hidden, $sortable);

    $data = $this->table_data();

    $per_page = 20;
    $current_page = $this->get_pagenum();
    $total_items = count($data);


    $this->set_pagination_args( array(
      'total_items' => $total_items,  //WE have to calculate the total number of items
      'per_page'    => $per_page  //WE have to determine how many items to show on a page
     ));

     $data = array_slice($data, (($current_page - 1) * $per_page), $per_page);

    $this->items = $data;
  }

  function column_default( $item, $column_name ) {
    switch( $column_name ) { 
      case 'title':
      case 'desc':
      case 'author':
      case 'created_at':
      case 'updated_at':
        return $item[ $column_name ];
      default:
        return print_r( $item, true ) ; //Show the whole array for troubleshooting purposes
    }
  }

  function column_title($item) {
    $actions = array(
        'show'      => sprintf('<a href="%s/lists/%d">نمایش</a>',site_url(),$item['ID']),
        'delete'    => sprintf('<a href="?page=%s&action=%s&list_id=%s">حذف</a>',$_REQUEST['page'],'delete',$item['ID']),
    );
  
    return sprintf('%1$s %2$s', $item['title'], $this->row_actions($actions) );
  }
}