<?php
if(isset($_GET['ticket_id']) && !empty($_GET['ticket_id'])){
  $ticket_id = $_GET['ticket_id'];

  global $wpdb;
  $table_name = $wpdb->prefix.'kelaket_tickets';
  $table_name_messsge = $wpdb->prefix.'kelaket_tickets_msg';

  $query = "SELECT * FROM $table_name WHERE id = $ticket_id LIMIT 1";
  $query_messages = "SELECT * FROM $table_name_messsge WHERE ticket_id = $ticket_id";
  $res = $wpdb->get_results($query);
  $messages = $wpdb->get_results($query_messages);

  if(!$res){
    die('یافت نشد!');
  }

  // remove messages on ticket
  if( isset( $_GET['delete_msg'] ) ){
    // delete msg with given id
    $msg_id = $_GET['delete_msg'];
    $wpdb->delete($table_name_messsge, array( 'id' => $msg_id ));

    wp_redirect( strip_param_from_url( $_SERVER['REQUEST_URI'], 'delete_msg' ) );
  }

  $name = $res[0]->subject;
  if($res[0]->status == '1'){
    $status = 'درانتظار پاسخ';
  }elseif($res[0]->status == '2'){
    $status = 'پاسخ داده شده';
  }elseif($res[0]->status == '3'){
    $status = 'بسته شده';
  }elseif($res[0]->status == '4'){
    $status = 'درحال بررسی';
  }
  $status_code = $res[0]->status;

  $id = $res[0]->id;
  $dep = get_dep_name($res[0]->department);
  $user = get_user_by('id', $res[0]->user_id)->display_name;
  $user_id = get_user_by('id', $res[0]->user_id)->user_login;
  $date = $res[0]->created_at;
}



// handle send Message 
if(isset($_POST['send_msg'])){
  var_dump('send mg');
  if(isset($_POST['status']) && !empty($_POST['status'])){
    $status = sanitize_text_field($_POST['status']);
  }
  if(isset($_POST['msg']) && !empty($_POST['msg'])){
    $msg = sanitize_textarea_field($_POST['msg']);
  }
  if(isset($msg)){
    // send Message
    $msg_query = $wpdb->insert($table_name_messsge, array(
      'ticket_id' => $ticket_id,
      'msg' => $msg,
      'user_id' => get_current_user_id(),
      'created_at' => current_time('Y-m-d H:i:s'),
      'reply_id' => get_current_user_id()
    ));
    // update status
    $update = $wpdb->update($tablename, array(
      'status' => $status, 
    ),
      array('id'=>$ticket_id)
    );
    set_transient( get_current_user_id().'reply_success', "پاسخ به تیکت با موفقیت ارسال شد." );
    wp_redirect(home_url($_SERVER['REQUEST_URI']));
  }else{
    // just update status
    $update = $wpdb->update($tablename, array(
      'status' => $status, 
    ),
      array('id'=>$ticket_id)
    );
    if($update){
      set_transient( get_current_user_id().'status_success', "وضعیت تیکت با موفقیت ویرایش شد." );
      wp_redirect(home_url($_SERVER['REQUEST_URI']));
    }else{
      var_dump('error');
    }
    
  }
}
?>

<style>
.tickets_admin{
  display: flex;
  margin-top: 25px;
}
.right_side{
  flex: 2;
  margin-left: 50px;
  position: relative;
  box-sizing: border-box;
  padding: 0 10px;
  box-shadow: 0 1px 1px rgb(0 0 0 / 4%);
  border: 1px solid #c3c4c7;
  background: #fff;
  color: #50575e;
  font-size: 13px;
  border-radius: 5px;
  max-height: 300px;
}
.right_side h3{
  text-align: center;
  border-bottom: solid 1px #e3e3e3;
  display: block;
  padding: 0 0 10px;
}
.right_side h2{
  font-size: 16px;
  font-weight: 300;
  padding: 0 5px;
}

.right_side h2 span{
  background: #eff1f3;
  padding: 1px 8px;
  border-radius: 5px;
  font-size: 13px;
  color: #acb3bf;
}

.right_side li{
  padding: 5px;
}

.left_side{
  flex: 6;
  box-sizing: border-box;
  padding: 0 10px;
  box-shadow: 0 1px 1px rgb(0 0 0 / 4%);
  border: 1px solid #c3c4c7;
  background: #fff;
  color: #50575e;
  font-size: 13px;
  border-radius: 5px;
}

.ticket_messsge {
  display: flex;
  align-items: center;
  margin:15px 0;
}

.ticket_messsge img {
  border-radius: 50%;
  margin-left: 15px;
}

.ticket_messsge .ticket_messsge_box {
  background: #e6e6e6;
  padding: 10px;
  border-radius: 5px;
  font-size: 14px;
  min-width: 50%;
  position: relative;
}
.ticket_messsge .ticket_messsge_box::before {
  content: '';
  display: block;
  width: 0;
  height: 0;
  border-color: transparent transparent transparent #e6e6e6;
  border-style: solid;
  border-width: 6px 0 6px 10.4px;
  position: absolute;
  top: 18px;
  z-index: 1;
  left: auto;
  right: -8px;
}


.ticket_messsge .ticket_messsge_info{
  border-top: solid 1px rgb(87 87 105 / 28%);
  margin-top: 10px;
  padding-top: 5px;
  font-size: 13px;
  display: flex;
  justify-content: space-between;
}


.ticket_messsge.reply_support{
  flex-direction: row-reverse;
}
.ticket_messsge.reply_support .ticket_messsge_box::before{
  left: -16px;
  right: auto;
  border-color: transparent #4857b8 transparent transparent;
  border-width: 6px 6px 6px 10px;
}

.ticket_messsge.reply_support img{
 margin-left: 0;
 margin-right: 15px;
}

.ticket_messsge.reply_support .ticket_messsge_info{
  border-top: solid 1px rgb(247 247 247 / 28%);
}

.ticket_messsge.reply_support .ticket_messsge_box{
  background: linear-gradient(179deg, #4050b5, #5c69bc);
    color: #fff;
}

.ticket_send_form{
  margin-top: 30px;
  position: relative;
  padding: 0 7px;
  display: flex;
  margin-bottom: 15px;
}

.ticket_send_form textarea{
  min-height: 100px;
  width: auto!important;
  flex:1;
}

.ticket_send_form button{
  line-height: 0;
  height: 38px;
  background: #4050b5;
  color: #fff;
  border: none;
  border-radius: 5px;
  font-size: 15px;
  display: flex;
  align-items: center;
  justify-content: center;
  margin-top: 5px;
  margin-right: 7px;
  font-size: 13px;
  width: 100%;
}
.ticket_send_form select{
  width: 100%!important;
  margin-top: 5px;
  height: 38px;
  margin-right: 7px;
  color: #595959;
  box-shadow: 0px 0px 13px #ece8e8;
  border: solid 1px #ddd;
  outline: none;
}

.ticket_send_form button i{
  margin-left: 5px;
}

.ticket_send_form .rcp-input {
  display: inline-block;
    font-size: 13px;
    outline: none;
    font-weight: 300;
    color: #595959;
    box-shadow: 0px 0px 13px #ece8e8;
    border: solid 1px #ddd;
    background: #ffffff;
    height: 45px;
    line-height: 1.5rem;
    padding: 5px;
    border-radius: 4px;
    text-indent: 0px;
    margin: 5px 0px;
    text-align: right;
}
</style>

<div class="tickets_admin">
  <div class="right_side">
    <h3>وضعیت: 

    <?php
    if((int) $status_code == 1){
      $staus_msg = '<span class="table_badge">درانتظار پاسخ</span>';
    }elseif((int) $status_code == 2){
      $staus_msg = '<span class="table_badge green">پاسخ داده شده</span>';
    }elseif((int) $status_code == 3){
      $staus_msg = '<span class="table_badge red">بسته شده</span>';
    }elseif((int) $status_code == 4){
      $staus_msg = '<span class="table_badge blue">درحال بررسی</span>';
    }
    echo $staus_msg;
    ?>
    </h3>

    <h2><?php echo $name ?> <span>#<?php echo $ticket_id?></span></h2>
    <ul>
      <li>
        <strong>تاریخ ارسال:</strong>
        <?php echo wp_date('Y/m/d - H:i', strtotime($date)); ?>
      </li>
      <li>
        <strong>ارسال کننده:</strong>
        <?php echo $user;?>
      </li>
      <li>
        <strong>شناسه کاربری:</strong>
        <?php echo $user_id;?>
      </li>
      <li>
        <strong>دپارتمان‌:</strong>
        <?php echo $dep;?>
      </li>

    </ul>
  </div>
  <div class="left_side">
    <?php
    if($messages) : foreach($messages as $messsge):
      $admin = $messsge->reply_id ? true : false;
    ?>
  <div class="ticket_messsge mb-2 d-flex <?php echo $admin ? 'reply_support' : '' ?>">
    <?php echo get_avatar($messsge->user_id, 50); ?>
    
    <div class="ticket_messsge_box">
      <?php echo nl2br( htmlspecialchars( $messsge->msg ) ); ?>

      <div class="ticket_messsge_info d-flex align-items-center justify-content-between">
      <span><?php 
      $time = strtotime($messsge->created_at);
      $current_time = current_time('U');
      echo human_time_diff($time, $current_time) . " پیش";
      ?></span>
      <span>
        <?php 
          $user = get_userdata($messsge->user_id);
          echo htmlspecialchars( $user->display_name );
        ?>
      </span>
      </div>
    </div>
    <a href="<?php echo $_SERVER['REQUEST_URI'] ?>&delete_msg=<?php echo $messsge->id ?>" style="margin: 0 5px" class="kelaket_guide"><?php _e('حذف پیام', 'kelaketfilm') ?></a>

  </div>
    <?php endforeach;endif;?>

    <form method="post" action="<?php echo home_url($_SERVER['REQUEST_URI']); ?>" class="ticket_send_form">
      <textarea name="msg" class="rcp-input" id="msg" placeholder="پیام شما..."></textarea>
      <div>
        <select name="status" id="status">
          <option  selected="selected" value="2">پاسخ داده شده</option>
          <option value="1">در انتظار پاسخ</option>
          <option value="3">بسته شده</option>
          <option value="4">درحال بررسی</option>
        </select>
        <button style="cursor: pointer" type="submit" name="send_msg">تغییر وضعیت تیکت</button>
      </div>
    </form>
  </div>
</div>
<script>
  jQuery('#msg').on('input', function(e){
    if(e.target.value.length >=1){
      jQuery('button[name="send_msg"]').text('ارسال پاسخ');
    }else{
      jQuery('button[name="send_msg"]').text('تغییر وضعیت تیکت');
    }
  });
</script>