<?php
if( ! class_exists( 'WP_List_Table' ) ) {
  require_once( ABSPATH . 'wp-admin/includes/class-wp-list-table.php' );
}

class Reqs_Table extends WP_List_Table {

  function get_columns(){
    $columns = array(
      'title' => 'عنوان',
      'type'    => 'نوع',
      'author'    => 'درخواست دهنده',
      'status'    => 'وضعیت',
      'msg'    => 'پیام',
      'created_at'      => 'تاریخ',
    );
    return $columns;
  }


  function table_data(){
    global $wpdb;
    $table_name = $wpdb->prefix.'kelaket_reqs';
    $data = [];
    $query = " 
      SELECT * 
      FROM $table_name
      ORDER BY created_at DESC
    ";  
      
    $res = $wpdb->get_results($query);

    foreach($res as $list){

      if($list->status == 1){
        $staus_msg = '<span class="table_badge">درحال بررسی</span>';
      }elseif($list->status == 2){
        $staus_msg = '<span class="table_badge green">تایید شده</span>';
      }elseif($list->status == 3){
        $staus_msg = '<span class="table_badge red">رد شده</span>';
      }

      $data[] = [
        'ID' => $list->id,
        'title' => $list->name,
        'type' => $list->type == 1 ? 'فیلم' : 'سریال',
        'status' => $staus_msg,
        'created_at' => wp_date('d M Y', strtotime($list->created_at)),
        'msg' => $list->msg,
        'author' => get_user_by('id', $list->user_id)->display_name
      ];
    }

    return $data;
  }
  
  function prepare_items() {
    $columns = $this->get_columns();
    $hidden = array();
    $sortable = array();
    $this->_column_headers = array($columns, $hidden, $sortable);

    $data = $this->table_data();

    $per_page = 20;
    $current_page = $this->get_pagenum();
    $total_items = count($data);


    $this->set_pagination_args( array(
      'total_items' => $total_items,  //WE have to calculate the total number of items
      'per_page'    => $per_page  //WE have to determine how many items to show on a page
     ));

     $data = array_slice($data, (($current_page - 1) * $per_page), $per_page);

    $this->items = $data;
  }

  function column_default( $item, $column_name ) {
    switch( $column_name ) { 
      case 'title':
      case 'type':
      case 'author':
      case 'created_at':
      case 'status':
      case 'msg':
        return $item[ $column_name ];
      default:
        return print_r( $item, true ) ; //Show the whole array for troubleshooting purposes
    }
  }

  function column_title($item) {
    $actions = array(
        'reply'      => sprintf('<a href="?page=%s&action=%s&req_id=%s">ارسال پاسخ</a>', $_REQUEST['page'], 'reply', $item['ID']),
        'delete'    => sprintf('<a href="?page=%s&action=%s&req_id=%s">حذف</a>', $_REQUEST['page'], 'delete', $item['ID']),
    );
  
    return sprintf('%1$s %2$s', $item['title'], $this->row_actions($actions) );
  }
}