<?php
if( ! class_exists( 'WP_List_Table' ) ) {
  require_once( ABSPATH . 'wp-admin/includes/class-wp-list-table.php' );
}

class Tickets_Table extends WP_List_Table {

  function get_columns(){
    $columns = array(
      'title' => __('موضوع', 'kelaketfilm'),
      'status'    => __('وضعیت', 'kelaketfilm'),
      'dep'    => __('دپارتمان', 'kelaketfilm'),
      'author'    => __('ارسال کننده', 'kelaketfilm'),
      'created_at'      => __('تاریخ', 'kelaketfilm'),
      'actions'      => __('عملیات', 'kelaketfilm'),
    );
    return $columns;
  }


  function table_data(){
    global $wpdb;
    $table_name = $wpdb->prefix.'kelaket_tickets';
    $data = [];

    if(isset($_REQUEST['action'])){
      $filter = $_REQUEST['action'];
      $whereQuery = "WHERE status = $filter";
    }else{
      $whereQuery = '';
    }

    $query = " 
      SELECT * 
      FROM $table_name
      $whereQuery
      ORDER BY created_at DESC
    ";  
      
    $res = $wpdb->get_results($query);

    foreach($res as $list){

      if($list->status == 1){
        $staus_msg = '<span class="table_badge">'.__('در انتظار پاسخ', 'kelaketfilm').'</span>';
      }elseif($list->status == 2){
        $staus_msg = '<span class="table_badge green">'.__('پاسخ داده شده', 'kelaketfilm').'</span>';
      }elseif($list->status == 3){
        $staus_msg = '<span class="table_badge red">'.__('بسته شده', 'kelaketfilm').'</span>';
      }elseif($list->status == 4){
        $staus_msg = '<span class="table_badge blue">'.__('درحال بررسی', 'kelaketfilm').'</span>';
      }

      $string = sprintf('<a class="table_badge green" href="?page=%s&action=%s&ticket_id=%s">'.__('ارسال پاسخ', 'kelaketfilm').'</a>', $_REQUEST['page'], 'reply', $list->id).''.sprintf('<a class="table_badge red" href="?page=%s&action=%s&ticket_id=%s">'.__('حذف', 'kelaketfilm').'</a>', $_REQUEST['page'], 'delete', $list->id);

      $data[] = [
        'ID' => $list->id,
        'title' => $list->subject,
        'dep' => get_dep_name($list->department),
        'status' => $staus_msg,
        'created_at' => wp_date('d M Y - H:i:s', strtotime($list->created_at)),
        'author' => get_user_by('id', $list->user_id)->display_name,
        // 'actions' => '<a class="table_badge green" href="#">پاسخ</a>'
        'actions'=> $string
        
      ];
    }

    return $data;
  }
  
  function prepare_items() {
    $columns = $this->get_columns();
    $hidden = array();
    $sortable = array();
    $this->_column_headers = array($columns, $hidden, $sortable);

    $data = $this->table_data();

    $per_page = 20;
    $current_page = $this->get_pagenum();
    $total_items = count($data);


    $this->set_pagination_args( array(
      'total_items' => $total_items,  //WE have to calculate the total number of items
      'per_page'    => $per_page  //WE have to determine how many items to show on a page
     ));

     $data = array_slice($data, (($current_page - 1) * $per_page), $per_page);

    $this->items = $data;
  }

  function column_default( $item, $column_name ) {
    switch( $column_name ) { 
      case 'title':
      case 'dep':
      case 'author':
      case 'created_at':
      case 'status':
      case 'actions':
        return $item[ $column_name ];
      default:
        return print_r( $item, true ) ; //Show the whole array for troubleshooting purposes
    }
  }

}