<?php
// header("Access-Control-Allow-Origin: *");
//Rest Api for KelaketFilm Mobile App
/**
 * Grab featured films
 *
 * @param array $data Options for the function.
 * @return array list of featured films
 */
function featuredFilms($data)
{
  $posts = get_posts(array(
    'meta_key' => 'slider',
    'meta_value' => true,
    'numberposts' => 5
  ));

  if (empty($posts)) {
    return null;
  }

  $return = [];

  foreach ($posts as $post) {
    $object = new stdClass();
    $object->name = $post->post_title;
    $object->date = $post->post_date;
    $object->id = $post->ID;
    $object->poster = get_the_post_thumbnail_url($post->ID,'post_retina');
    $object->poster2 = get_field('slider_image', $post->ID)['url'];
    $object->imdbRating = get_field('imdbRating', $post->ID);
    $object->rotten = get_field('rotten', $post->ID);
    $object->sliderBadge = get_field('slider-badge', $post->ID);
    $object->lastEpisode = get_field('last-episode', $post->ID);
    $object->story = get_field('story', $post->ID);
    $object->released = get_field('released', $post->ID);
    $object->def = get_field('def-version', $post->ID);
    $object->doble = get_field('persian-doble', $post->ID);
    $object->user_vote = get_post_votes($post->ID)['percent'] . '%';
    $return[] = $object;
  }
  return $return;
  //  return get_the_post_thumbnail_url($posts[0]->ID);

}

add_action('rest_api_init', function () {
  register_rest_route('mobile/v1', '/featured', array(
    'methods' => 'GET',
    'callback' => 'featuredFilms',
  ));
});


function getPostByCat($data)
{
  $page = $data['page'];
  $posts = get_posts(array(
    'numberposts' => 7,
    'paged' => $page,
    'category' => $data['id']
  ));

  if (empty($posts)) {
    return null;
  }

  $return = [];

  foreach ($posts as $post) {
    $object = new stdClass();
    $object->name = $post->post_title;
    $object->date = $post->post_date;
    $object->id = $post->ID;
    $object->poster = get_the_post_thumbnail_url($post->ID,'post_retina');
    $object->imdbRating = get_field('imdbRating', $post->ID);
    $object->rotten = get_field('rotten', $post->ID);
    $object->sliderBadge = get_field('slider-badge', $post->ID);
    $object->lastEpisode = get_field('last-episode', $post->ID);
    $object->story = get_field('story', $post->ID);
    $object->released = get_field('released', $post->ID);
    $object->def = get_field('def-version', $post->ID);
    $object->doble = get_field('persian-doble', $post->ID);
    $object->user_vote = get_post_votes($post->ID)['percent'] . '%';
    $return[] = $object;
  }
  return $return;
  //  return get_the_post_thumbnail_url($posts[0]->ID);

}

add_action('rest_api_init', function () {
  register_rest_route('mobile/v1', '/postByCat/(?P<id>\d+)', array(
    'methods' => 'GET',
    'callback' => 'getPostByCat',
  ));
});

function getSelectedCats($data)
{
  $cats = get_option('my_framework')['app_home'];

  foreach ($cats as $cat) {
    $object = new stdClass();
    $object->cat_id = $cat['app_home_item'];
    $object->cat_name = get_cat_name($cat['app_home_item']);
    $filtred = [];
    $posts = get_posts(array(
      'numberposts' => 10,
      'category' => $cat['app_home_item'],
    ));
    if ($posts) {
      foreach ($posts as $post) {
        $object2 = new stdClass();
        $object2->name = $post->post_title;
        $object2->date = $post->post_date;
        $object2->id = $post->ID;
        $object2->poster = get_the_post_thumbnail_url($post->ID,'post_retina');
        $object2->imdbRating = get_field('imdbRating', $post->ID);
        $object2->rotten = get_field('rotten', $post->ID);
        $object2->sliderBadge = get_field('slider-badge', $post->ID);
        $object2->lastEpisode = get_field('last-episode', $post->ID);
        $object2->story = get_field('story', $post->ID);
        $object2->released = get_field('released', $post->ID);
        $object2->def = get_field('def-version', $post->ID);
        $object2->doble = get_field('persian-doble', $post->ID);
        $object2->user_vote = get_post_votes($post->ID)['percent'] . '%';

        $filtred[] = $object2;
      }
    }
    $object->data = $filtred;
    $return[] = $object;
  }
  return $return;
  //  return get_the_post_thumbnail_url($posts[0]->ID);

}

add_action('rest_api_init', function () {
  register_rest_route('mobile/v1', '/selectedCats', array(
    'methods' => 'GET',
    'callback' => 'getSelectedCats',
  ));
});


function getSearchTerms($data)
{
  $return = [];
  $post_type = get_terms(
    array(
      'taxonomy'   => 'type_of_post',
      'hide_empty' => false
    )
  );
  $genres = get_terms(
    array(
      'taxonomy'   => 'genre',
      'hide_empty' => false
    )
  );
  $years = get_terms(
    array(
      'taxonomy'   => 'yearr',
      'hide_empty' => false
    )
  );
  $country = get_terms(
    array(
      'taxonomy'   => 'country',
      'hide_empty' => false
    )
  );
  $rates = get_terms(
    array(
      'taxonomy'   => 'rate',
      'hide_empty' => false
    )
  );
  $scores = get_terms(
    array(
      'taxonomy'   => 'score',
      'hide_empty' => false
    )
  );
  $temp = [];
  foreach ($post_type as $item) {
    $obj = new stdClass();
    $obj->term_name = $item->name;
    $obj->term_slug = $item->slug;
    $obj->term_id = $item->term_id;
    $temp[] = $obj;
  }
  $obj2 = new stdClass();
  $obj2->post_type = $temp;
  //empty temp array to fill next data
  $temp = [];

  foreach ($genres as $item) {
    $obj = new stdClass();
    $obj->term_name = $item->name;
    $obj->term_slug = $item->slug;
    $obj->term_id = $item->term_id;
    $temp[] = $obj;
  }
  $obj2->genres = $temp;
  //empty temp array to fill next data
  $temp = [];

  foreach ($years as $item) {
    $obj = new stdClass();
    $obj->term_name = $item->name;
    $obj->term_slug = $item->slug;
    $obj->term_id = $item->term_id;
    $temp[] = $obj;
  }
  $obj2->year = $temp;
  //empty temp array to fill next data
  $temp = [];

  foreach ($country as $item) {
    $obj = new stdClass();
    $obj->term_name = $item->name;
    $obj->term_slug = $item->slug;
    $obj->term_id = $item->term_id;
    $temp[] = $obj;
  }
  $obj2->country = $temp;
  //empty temp array to fill next data
  $temp = [];

  foreach ($rates as $item) {
    $obj = new stdClass();
    $obj->term_name = $item->name;
    $obj->term_slug = $item->slug;
    $obj->term_id = $item->term_id;
    $temp[] = $obj;
  }
  $obj2->rates = $temp;
  //empty temp array to fill next data
  $temp = [];

  foreach ($scores as $item) {
    $obj = new stdClass();
    $obj->term_name = $item->name;
    $obj->term_slug = $item->slug;
    $obj->term_id = $item->term_id;
    $temp[] = $obj;
  }
  $obj2->score = $temp;

  //return queried data's
  return $obj2;
}

add_action('rest_api_init', function () {
  register_rest_route('mobile/v1', '/searchTerms', array(
    'methods' => 'GET',
    'callback' => 'getSearchTerms',
  ));
});

function mod_jwt_token($data, $user)
{
  $id = $user->data->ID;
  $data['id'] = $id;
  if (class_exists('Restrict_Content_Pro')) {
    $data['activeSubscribe'] = rcp_user_has_active_membership($id);
  }
  return $data;
}
add_filter('jwt_auth_token_before_dispatch', 'mod_jwt_token', 10, 2);

add_action('rest_api_init', 'wp_rest_user_endpoints');
/**
 * Register a new user
 *
 * @param  WP_REST_Request $request Full details about the request.
 * @return array $args.
 **/
function wp_rest_user_endpoints($request)
{
  /**
   * Handle Register User request.
   */
  register_rest_route('mobile/v1', 'users/register', array(
    'methods' => 'POST',
    'callback' => 'wc_rest_user_endpoint_handler',
  ));
}
function wc_rest_user_endpoint_handler($request = null)
{
  $response = array();
  $parameters = $request->get_params();
  $username = sanitize_text_field($parameters['username']);
  $email = sanitize_text_field($parameters['email']);
  $password = sanitize_text_field($parameters['password']);
  // $role = sanitize_text_field($parameters['role']);
  $error = new WP_Error();
  if (empty($username)) {
    $error->add(400, __("فیلد نام کاربری الزامی است", 'wp-rest-user'), array('status' => 400));
    return $error;
  }
  if (empty($email)) {
    $error->add(401, __("فیلد ایمیل الزامی است.", 'wp-rest-user'), array('status' => 400));
    return $error;
  }
  if (empty($password)) {
    $error->add(404, __("فیلد رمز عبور الزامی است.", 'wp-rest-user'), array('status' => 400));
    return $error;
  }
  // if (empty($role)) {
  //  $role = 'subscriber';
  // } else {
  //     if ($GLOBALS['wp_roles']->is_role($role)) {
  //      // Silence is gold
  //     } else {
  //    $error->add(405, __("Role field 'role' is not a valid. Check your User Roles from Dashboard.", 'wp_rest_user'), array('status' => 400));
  //    return $error;
  //     }
  // }
  $user_id = username_exists($username);
  if (!$user_id && email_exists($email) == false) {
    $user_id = wp_create_user($username, $password, $email);
    if (!is_wp_error($user_id)) {
      // Ger User Meta Data (Sensitive, Password included. DO NOT pass to front end.)
      $user = get_user_by('id', $user_id);
      // $user->set_role($role);
      $user->set_role('subscriber');
      // WooCommerce specific code
      // if (class_exists('WooCommerce')) {
      //   $user->set_role('customer');
      // }
      // Ger User Data (Non-Sensitive, Pass to front end.)
      $response['code'] = 200;
      $response['message'] = __("'" . $username . "' با موفقیت ثبت نام کردید!", "wp-rest-user");
    } else {
      return $user_id;
    }
  } else {
    $error->add(406, __("ایمیل شما در سیستم موجود است اگر رمز را فراموش کرده اید فراموشی رمز استفاده کنید.", 'wp-rest-user'), array('status' => 400));
    return $error;
  }
  return new WP_REST_Response($response, 123);
}


function getMembershipLevel()
{
  if (class_exists('Restrict_Content_Pro')) {
    global $wpdb;
    $query = "SELECT * FROM wp_restrict_content_pro WHERE status = 'active' ";
    return $wpdb->get_results($query);
  }
}

add_action('rest_api_init', function () {
  register_rest_route('mobile/v1', '/membership', array(
    'methods' => 'GET',
    'callback' => 'getMembershipLevel',
  ));
});

function search($request)
{
  $params = $request->get_params();
  $page = $params['page'];
  $posts = [];
  $results = [];
  if (isset($params['s'])) {
    $args = [
      'numberposts' => 7,
      'paged' => $page,
      'post_type' => 'post',
      's' => $params['s'],
      'tax_query' => [],
    ];
    $final_post_type = [];
    if ($params['type_of_post'] == 'all') {
      $temp = get_terms(['taxonomy' => 'type_of_post', 'hide_empty' => false]);
      foreach ($temp as $t) {
        array_push($final_post_type, $t->slug);
      }
    } else {
      array_push($final_post_type, $params['type_of_post']);
    }
    if ($params['type_of_post'] && $final_post_type) {
      array_push($args['tax_query'], array(
        'taxonomy' => 'type_of_post',
        'field' => 'slug',
        'terms' => $final_post_type,
      ));
    }
    if ($params['genre']) {
      array_push($args['tax_query'], array(
        'taxonomy' => 'genre',
        'field' => 'slug',
        'terms' => $params['genre'],
      ));
    }
    if ($params['from_year'] && $params['to_year']) {
      $year_range = [];
      for ($x = $params['from_year']; $x <= $params['to_year']; $x++) {
        array_push($year_range, $x);
      }
      array_push($args['tax_query'], array(
        'taxonomy' => 'yearr',
        'field' => 'slug',
        'terms' => $year_range,
      ));
    }
    if ($params['country']) {
      array_push($args['tax_query'], array(
        'taxonomy' => 'country',
        'field' => 'slug',
        'terms' => $params['country'],
      ));
    }
    if ($params['rate']) {
      array_push($args['tax_query'], array(
        'taxonomy' => 'rate',
        'field' => 'slug',
        'terms' => $params['rate'],
      ));
    }
    if ($params['score']) {
      array_push($args['tax_query'], array(
        'taxonomy' => 'score',
        'field' => 'slug',
        'terms' => $params['score'],
      ));
    }
    $posts = get_posts($args);
    foreach ($posts as $post) {
      $object2 = new stdClass();
      $object2->name = $post->post_title;
      $object2->date = $post->post_date;
      $object2->id = $post->ID;
      $object2->poster = get_the_post_thumbnail_url($post->ID,'post_retina');
      $object2->imdbRating = get_field('imdbRating', $post->ID);
      $object2->rotten = get_field('rotten', $post->ID);
      $object2->sliderBadge = get_field('slider-badge', $post->ID);
      $object2->lastEpisode = get_field('last-episode', $post->ID);
      $object2->story = get_field('story', $post->ID);
      $object2->released = get_field('released', $post->ID);
      $object2->def = get_field('def-version', $post->ID);
      $object2->doble = get_field('persian-doble', $post->ID);
      $object2->user_vote = get_post_votes($post->ID)['percent'] . '%';
      $results[] = $object2;
    }
  }
  return $results;
}

add_action('rest_api_init', function () {
  register_rest_route('mobile/v1', '/search', array(
    'methods' => 'GET',
    'callback' => 'search',
  ));
});

function formatVotes($num)
{
  if (preg_match("/^[0-9,]+$/", $num)) {
    $num = str_replace(',', '', $num);
  }
  if ($num > 1000) {

    $x = round($num);
    $x_number_format = number_format($x);
    $x_array = explode(',', $x_number_format);
    $x_parts = array('k', 'm', 'b', 't');
    $x_count_parts = count($x_array) - 1;
    $x_display = $x;
    $x_display = $x_array[0] . ((int) $x_array[1][0] !== 0 ? '.' . $x_array[1][0] : '');
    $x_display .= $x_parts[$x_count_parts - 1];

    return $x_display;
  }

  return $num;
}

function getFilmDetails2($request)
{
  $params = $request->get_params();
  $id = $params['id'];
  $posts = get_posts(array('include' => $id));
  $results = '';
  foreach ($posts as $post) {
    $object2 = new stdClass();
    $actors = get_the_terms($post->ID, 'actor', '', '، ', '');
    $actors_arr = [];
    if($actors){
      foreach($actors as $actor){
        $image = get_template_directory_uri()."/images/no_img.png";
        if(get_field('actor_image_link', $actor)){
          $image = get_field('actor_image_link', $actor);
        }
        $actors_arr[] = ['name' => $actor->name, 'id' => $actor->term_id, 'image' => $image, 'bio' => $actor->description];
      }
    }
    // full actors 
    $object2->full_actors = $actors_arr;

    $object2->sub = get_field('mobile_sub', $post->ID);
    $object2->name = $post->post_title;
    $object2->date = $post->post_date;
    $object2->id = $post->ID;
    $object2->poster = get_the_post_thumbnail_url($post->ID,'post_retina');
    $object2->imdbRating = get_field('imdbRating', $post->ID);
    $object2->rotten = get_field('rotten', $post->ID);
    $object2->sliderBadge = get_field('slider-badge', $post->ID);
    $object2->lastEpisode = get_field('last-episode', $post->ID);
    $object2->story = get_field('story', $post->ID);
    $object2->about = get_field('about', $post->ID);
    $object2->released = get_field('released', $post->ID);
    $object2->def = get_field('def-version', $post->ID);
    $object2->user_vote = get_post_votes($post->ID)['percent'] . '%';
    $object2->doble = get_field('persian-doble', $post->ID);
    $object2->trailer = get_field('trailer', $post->ID);
    $object2->online_single = get_field('mobile_online', $post->ID);
    $object2->online_quality = [
      '1080' => get_field('mobile_1080', $post->ID),
      '720' => get_field('mobile_720', $post->ID),
      '480' => get_field('mobile_480', $post->ID),
    ];
    $object2->genre = strip_tags(get_the_term_list($post->ID, 'genre', '', '، ', ''));
    $object2->actors = strip_tags(get_the_term_list($post->ID, 'actor', '', '، ', ''));
    $object2->rate = strip_tags(get_the_term_list($post->ID, 'rate', '', '، ', ''));
    if (class_exists('Restrict_Content_Pro')) {
      $object2->isPaid = rcp_is_restricted_content($post->ID);
    }
    $object2->director = strip_tags(get_the_term_list($post->ID, 'director', '', '، ', ''));
    $object2->film_dl = [];
    $object2->serial_dl = [];
    //get films download links...
    if (have_rows('film-dl', $post->ID)) {
      $temp2 = [];
      while (have_rows('film-dl', $post->ID)) : the_row();
        $object2->subtitle = get_sub_field('subtitle-film', $post->ID);
        // $temp2[] = ['row_info' => get_sub_field('film_info')];

        if (have_rows('film-dl-link', $post->ID)) {
          $temp = [];
          while (have_rows('film-dl-link', $post->ID)) : the_row();
            $temp[] = [
              'link' => get_sub_field('dl-film-link'),
              'quality' => get_sub_field('quality-film'),
              'online' => get_sub_field('online_link'),
              'version' => get_sub_field('version'),
              'price' => get_sub_field('film-price'),
              'size' => get_sub_field('size-film')
            ];
          // $object2->film_dl = $temp;
          endwhile;
        }
        if (get_sub_field('subtitle-film', $post->ID)) {
          $temp[] = [
            'link' => get_sub_field('subtitle-film', $post->ID),
            'quality' => 'زیرنویس فارسی',
          ];
        }
        if (get_sub_field('farsi-doble-link', $post->ID)) {
          $temp[] = [
            'link' => get_sub_field('farsi-doble-link', $post->ID),
            'quality' => 'صوت دوبله',
          ];
        }
        $temp2[] = ['row_info' => get_sub_field('film_info'), 'data' => $temp];
      endwhile;
      $object2->film_dl = $temp2;
    }
    //get serials download links...
    if (have_rows('serial-dl', $post->ID)) {
      while (have_rows('serial-dl', $post->ID)) : the_row();
        $obj4 = new stdClass();
        $obj4->seasonName = get_sub_field('season-name');
        $obj4->seasonID = get_sub_field('identifer');
        $obj4->episodeCount = get_sub_field('episode-count');
        if (have_rows('dl-links', $post->ID)) {
          while (have_rows('dl-links', $post->ID)) : the_row();
            $temp = [];
            if (have_rows('quality', $post->ID)) {
              while (have_rows('quality', $post->ID)) : the_row();
                $temp[] = [
                  'link' => get_sub_field('quality-dl-link'),
                  'quality' => get_sub_field('quality-name'),
                  'sale' => get_sub_field('sale'),
                ];
              endwhile;
            }
            if (get_sub_field('subtitle')) {
              $temp[] = [
                'link' => get_sub_field('subtitle'),
                'quality' => 'زیرنویس فارسی',
              ];
            }
            if (get_sub_field('farsi-sound')) {
              $temp[] = [
                'link' => get_sub_field('farsi-sound'),
                'quality' => 'صوت دوبله فارسی',
              ];
            }
            $obj4->episode[] = [
              'price' => get_sub_field('serial-price'),
              'online_link' => get_sub_field('online_link_serial'),
              'subtitle' => get_sub_field('subtitle_online_serial'),
              'quality' => [
                '1080' => get_sub_field('serial_1080', $post->ID),
                '720' => get_sub_field('serial_720', $post->ID),
                '480' => get_sub_field('serial_480', $post->ID),
              ],
              'title' => get_sub_field('episode'),
              'link' => $temp
            ];


          endwhile;
        }
        $object2->serial_dl[] = $obj4;
      endwhile;
    }
    //get comments of film
    $comments = get_comments(array('post_id' => $post->ID));

    $object2->comments = $comments;

    $results = $object2;
  }
  return $results;
}

add_action('rest_api_init', function () {
  register_rest_route('mobile/v2', '/film/(?P<id>\d+)', array(
    'methods' => 'GET',
    'callback' => 'getFilmDetails2',
  ));
});




function getFilmDetails($request)
{
  $params = $request->get_params();
  $id = $params['id'];
  $posts = get_posts(array('include' => $id));
  $results = '';
  foreach ($posts as $post) {
    $object2 = new stdClass();
    $actors = get_the_terms($post->ID, 'actor', '', '، ', '');
    $actors_arr = [];
    if($actors){
      foreach($actors as $actor){
        $image = get_template_directory_uri()."/images/no_img.png";
        if(get_field('actor_image_link', $actor)){
          $image = get_field('actor_image_link', $actor);
        }
        $actors_arr[] = ['name' => $actor->name, 'id' => $actor->term_id, 'image' => $image];
      }
    }
    // full actors 
    $object2->full_actors = $actors_arr;

    $object2->name = $post->post_title;
    $object2->date = $post->post_date;
    $object2->id = $post->ID;
    $object2->subtitle = get_field('mobile_sub', $post->ID);
    $object2->poster = get_the_post_thumbnail_url($post->ID,'post_retina');
    $object2->imdbRating = get_field('imdbRating', $post->ID);
    $object2->rotten = get_field('rotten', $post->ID);
    $object2->sliderBadge = get_field('slider-badge', $post->ID);
    $object2->lastEpisode = get_field('last-episode', $post->ID);
    $object2->story = get_field('story', $post->ID);
    $object2->about = get_field('about', $post->ID);
    $object2->released = get_field('released', $post->ID);
    $object2->def = get_field('def-version', $post->ID);
    $object2->doble = get_field('persian-doble', $post->ID);
    $object2->trailer = get_field('trailer', $post->ID);
    $object2->online_single = get_field('mobile_online', $post->ID);
    $object2->online_quality = [
      '1080' => get_field('mobile_1080', $post->ID),
      '720' => get_field('mobile_720', $post->ID),
      '480' => get_field('mobile_480', $post->ID),
    ];
    $object2->genre = strip_tags(get_the_term_list($post->ID, 'genre', '', '، ', ''));
    $object2->actors = strip_tags(get_the_term_list($post->ID, 'actor', '', '، ', ''));
    $object2->rate = strip_tags(get_the_term_list($post->ID, 'rate', '', '، ', ''));
    if (class_exists('Restrict_Content_Pro')) {
      $object2->isPaid = rcp_is_restricted_content($post->ID);
    }
    $object2->director = strip_tags(get_the_term_list($post->ID, 'director', '', '، ', ''));
    $object2->film_dl = [];
    $object2->serial_dl = [];
    //get films download links...
    if (have_rows('film-dl', $post->ID)) {
      while (have_rows('film-dl', $post->ID)) : the_row();
        $object2->subtitle = get_sub_field('subtitle-film', $post->ID);

        if (have_rows('film-dl-link', $post->ID)) {
          $temp = [];
          while (have_rows('film-dl-link', $post->ID)) : the_row();
            $temp[] = [
              'link' => get_sub_field('dl-film-link'),
              'quality' => get_sub_field('quality-film'),
              'online' => get_sub_field('online_link'),
              'version' => get_sub_field('version'),
              'price' => get_sub_field('film-price'),
              'size' => get_sub_field('size-film')
            ];
            $object2->film_dl = $temp;
          endwhile;
        }
      endwhile;
    }
    //get serials download links...
    if (have_rows('serial-dl', $post->ID)) {
      while (have_rows('serial-dl', $post->ID)) : the_row();
        $obj4 = new stdClass();
        $obj4->seasonName = get_sub_field('season-name');
        $obj4->seasonID = get_sub_field('identifer');
        $obj4->episodeCount = get_sub_field('episode-count');
        if (have_rows('dl-links', $post->ID)) {
          while (have_rows('dl-links', $post->ID)) : the_row();
            $temp = [];
            if (have_rows('quality', $post->ID)) {
              while (have_rows('quality', $post->ID)) : the_row();
                $temp[] = [
                  'link' => get_sub_field('quality-dl-link'),
                  'quality' => get_sub_field('quality-name'),
                  'sale' => get_sub_field('sale'),
                ];
              endwhile;
            }
            $obj4->episode[] = [
              'price' => get_sub_field('serial-price'),
              'online_link' => get_sub_field('online_link_serial'),
              'quality' => [
                '1080' => get_sub_field('serial_1080', $post->ID),
                '720' => get_sub_field('serial_720', $post->ID),
                '480' => get_sub_field('serial_480', $post->ID),
              ],
              'title' => get_sub_field('episode'),
              'link' => $temp
            ];


          endwhile;
        }
        $object2->serial_dl[] = $obj4;
      endwhile;
    }
    //get comments of film
    $comments = get_comments(array('post_id' => $post->ID));

    $object2->comments = $comments;

    $results = $object2;
  }
  return $results;
}

add_action('rest_api_init', function () {
  register_rest_route('mobile/v1', '/film/(?P<id>\d+)', array(
    'methods' => 'GET',
    'callback' => 'getFilmDetails',
  ));
});




add_filter('rest_allow_anonymous_comments', '__return_true');

function editUserByID($request)
{
  $params = $request->get_params();
  $id = $params['id'];
  $token = $params['token'];
  $email = $params['email'];
  $new_email = $params['newEmail'];
  $name = $params['name'];
  if (!$token) {
    return [
      'code' => 330,
      'message' => 'دسترسی غیرمجاز'
    ];
  }
  if ($id) {
    $user = get_user_by('id', $id);
    if ($email == $user->data->user_email) {
      //check user is admin
      if (in_array('administrator', $user->roles)) {
        return [
          'code' => 330,
          'message' => 'امکان ویرایش اطلاعات وجود ندارد!'
        ];
        // return $user->caps;
      } else {
        //edit user
        $user_data = wp_update_user(array('ID' => $id, 'user_email' => $new_email, 'display_name' => $name));

        if (is_wp_error($user_data)) {
          // There was an error; possibly this user doesn't exist.
          return [
            'code' => 331,
            'message' => 'مشکلی پیش آمد دوباره تلاش کنید.'
          ];
        } else {
          return [
            'code' => 200,
            'message' => 'اطلاعات با موفقیت ویرایش شد.'
          ];
        }
      }
      return $user;
    } else {
      return [
        'code' => 330,
        'message' => 'دسترسی غیرمجاز'
      ];
    }
  }
  return [];
}

add_action('rest_api_init', function () {
  register_rest_route('mobile/v1', '/editUser', array(
    'methods' => 'POST',
    'callback' => 'editUserByID',
  ));
});

function fetchFilmsByID($request)
{
  $params = $request->get_params();
  $id = $params['id'];
  if (empty($id)) {
    return [];
  }
  $posts = get_posts(array('include' => $id));
  $return = [];
  foreach ($posts as $post) {
    $object = new stdClass();
    $object->id = $post->ID;
    $object->name = $post->post_title;
    $object->date = $post->post_date;
    $object->poster = get_the_post_thumbnail_url($post->ID,'post_retina');
    $object->imdbRating = get_field('imdbRating', $post->ID);
    $object->rotten = get_field('rotten', $post->ID);
    $object->sliderBadge = get_field('slider-badge', $post->ID);
    $object->lastEpisode = get_field('last-episode', $post->ID);
    $object->story = get_field('story', $post->ID);
    $object->released = get_field('released', $post->ID);
    $object->def = get_field('def-version', $post->ID);
    $object->doble = get_field('persian-doble', $post->ID);
    $object->user_vote = get_post_votes($post->ID)['percent'] . '%';
    $return[] = $object;
  }
  return $return;
}

add_action('rest_api_init', function () {
  register_rest_route('mobile/v1', '/fetchFilmsByID', array(
    'methods' => 'GET',
    'callback' => 'fetchFilmsByID',
  ));
});

function fetchGenres($request)
{
  $genres = get_terms(
    array(
      'taxonomy'   => 'genre',
      'hide_empty' => false
    )
  );
  $return = [];
  foreach ($genres as $genre) {
    $object = new StdClass();
    $object->id = $genre->term_id;
    $object->title = $genre->name;
    $object->slug = $genre->slug;
    $object->parent = $genre->parent;
    $object->count = $genre->count;
    $object->image = get_field('genre_image', $genre);
    $return[] = $object;
  }
  return $return;
}

add_action('rest_api_init', function () {
  register_rest_route('mobile/v1', '/fetchGenres', array(
    'methods' => 'GET',
    'callback' => 'fetchGenres',
  ));
});

function getPostByGenre($data)
{
  // $params = $data->get_params();
  $page = $data['page'];
  $posts = get_posts(array(
    'numberposts' => 7,
    'paged' => $page,
    'tax_query' => [
      [
        'taxonomy' => 'genre',
        'field' => 'term_id',
        'terms' => $data['id'],
      ]
    ]
  ));

  if (empty($posts)) {
    return [];
  }

  $return = [];

  foreach ($posts as $post) {
    $object = new stdClass();
    $object->name = $post->post_title;
    $object->date = $post->post_date;
    $object->id = $post->ID;
    $object->poster = get_the_post_thumbnail_url($post->ID,'post_retina');
    $object->imdbRating = get_field('imdbRating', $post->ID);
    $object->rotten = get_field('rotten', $post->ID);
    $object->sliderBadge = get_field('slider-badge', $post->ID);
    $object->lastEpisode = get_field('last-episode', $post->ID);
    $object->story = get_field('story', $post->ID);
    $object->released = get_field('released', $post->ID);
    $object->def = get_field('def-version', $post->ID);
    $object->doble = get_field('persian-doble', $post->ID);
    $object->user_vote = get_post_votes($post->ID)['percent'] . '%';
    $return[] = $object;
  }
  return $return;
}

add_action('rest_api_init', function () {
  register_rest_route('mobile/v1', '/postByGenre/(?P<id>\d+)', array(
    'methods' => 'GET',
    'callback' => 'getPostByGenre',
  ));
});

function getWeeklySeries($data)
{
  // $params = $data->get_params();
  $day = $data['day'];
  $return = [];
  if ($day) {
    $data = get_option('my_framework')['series_tabbed'][$day];
    if (is_array($data)) {
      foreach ($data as $item) {
        $object = new stdClass();
        $object->id = $item;
        $object->name = get_the_title($item);
        $object->update = get_field('update_info', $item);
        $object->image = get_the_post_thumbnail_url($item, 'thumbnail');
        $object->poster = get_the_post_thumbnail_url($item);
        $object->imdbRating = get_field('imdbRating', $item);
        $object->rotten = get_field('rotten', $item);
        $object->released = get_field('released', $item);
        $object->def = get_field('def-version', $item);
        $object->doble = get_field('persian-doble', $item);
        if(get_field('story', $item)){
          $object->story = get_field('story', $item);
        }else{
          $object->story = get_field('about', $item);
        }
        $return[] = $object;
      }
    } else {
      wp_send_json(['error' => true, 'message' => 'در این روز سریالی پخش نمی‌شود.']);
    }
    return $return;
  }
}

add_action('rest_api_init', function () {
  register_rest_route('mobile/v1', '/getWeeklySeries/(?P<day>[\w].+)', array(
    'methods' => 'GET',
    'callback' => 'getWeeklySeries',
  ));
});



// actor works
function getActorWorks($data)
{
  // $params = $data->get_params();
  $posts = get_posts(array(
    'numberposts' => -1,
    'tax_query' => [
      [
        'taxonomy' => 'actor',
        'field' => 'term_id',
        'terms' => $data['id'],
      ]
    ]
  ));

  if (empty($posts)) {
    return [];
  }

  $return = [];

  foreach ($posts as $post) {
    $object = new stdClass();
    $object->name = $post->post_title;
    $object->date = $post->post_date;
    $object->id = $post->ID;
    $object->poster = get_the_post_thumbnail_url($post->ID,'post_retina');
    $object->imdbRating = get_field('imdbRating', $post->ID);
    $object->rotten = get_field('rotten', $post->ID);
    $object->sliderBadge = get_field('slider-badge', $post->ID);
    $object->lastEpisode = get_field('last-episode', $post->ID);
    $object->story = get_field('story', $post->ID);
    $object->released = get_field('released', $post->ID);
    $object->def = get_field('def-version', $post->ID);
    $object->doble = get_field('persian-doble', $post->ID);
    $object->user_vote = get_post_votes($post->ID)['percent'] . '%';
    $return[] = $object;
  }
  return $return;
}

add_action('rest_api_init', function () {
  register_rest_route('mobile/v2', '/actorWorks/(?P<id>\d+)', array(
    'methods' => 'GET',
    'callback' => 'getActorWorks',
  ));
});



function getAppConfig(){
  $config = new stdClass();

  if(get_option('my_framework')['showWeeklySeries']){
    $config->show_weekly = true;
  }
  // app auth method => sms, email
  if(get_option('my_framework')['mobileAuth_Method']){
    $config->auth_method = get_option('my_framework')['mobileAuth_Method'];
  }
  if(get_option('my_framework')['active_vip_app'] == true){
    $config->active_vip = true;
  }else{
    $config->active_vip = false;
  }

  return $config;
}

add_action('rest_api_init', function () {
  register_rest_route('mobile/v2', '/config', array(
    'methods' => 'GET',
    'callback' => 'getAppConfig',
  ));
});


// check user state on app startup
function getUserInfoOnStartup($request){
  $params = $request->get_params();
  $user_id = $params['user_id'];

  if(!function_exists('rcp_get_customer')){
    return 'rcp is not active';
  }

  if(empty($user_id)){
    return 'user_id not defined';
  }

  $user = get_user_by('id', $user_id);

  $status = rcp_get_status( $user->data->ID );
  switch ( $status ) {
    case 'expired':
      $status_fa = 'به اتمام رسیده';
      break;
    case 'active':
      $status_fa = 'فعال';
      break;
    case 'cancelled':
      $status_fa = 'لغو شده';
      break;
    case 'pending':
      $status_fa = 'در انتظار تایید';
      break;
    default:
      $status_fa = 'بدون اشتراک'; 
      break;
  }

  $state = new stdClass();
  $expire_time = kelaket_get_user_expiration( $user->data->ID );
  $state->id = $user->data->ID;
  $state->is_expired = ( (int) $expire_time < current_time('U') ) ? true : false;
  $state->sub_state = $status;
  $state->sub_state_fa = $status_fa;
  $state->has_active_sub = rcp_user_has_active_membership( $user->data->ID );
  $state->expiration_timestamp = $expire_time;
  $state->expiration_date = wp_date( 'Y-m-d H:i:s', $expire_time );
  
  return $state;
}

add_action('rest_api_init', function () {
  register_rest_route('mobile/v2', '/userInfo', array(
    'methods' => 'GET',
    'callback' => 'getUserInfoOnStartup',
  ));
});



function setVoteMobile($request){

  $params = $request->get_params();

  if(isset($params['user_id']) && isset($params['post_id']) && isset($params['user_action'])){
    $user_id = (int) $params['user_id'];
    $post_id = (int) $params['post_id'];
    $user_action = sanitize_key($params['user_action']);

    if($user_id == 0 || empty($user_id)){
      wp_send_json_error(['msg' => 'برای ثبت رای وارد حساب کاربری خود شوید']);
    }
    $dislikes = get_post_meta($post_id, 'kelaket_dislikes', true);
    $likes = get_post_meta($post_id, 'kelaket_likes', true);

     // check user voted before
     $vote_history = get_user_meta($user_id, 'voted_posts', true);
     if (!is_array($vote_history) || empty($vote_history)) {
       $vote_history = [];
     }
     $vote_key = array_search($post_id, $vote_history);

     if ($vote_key !== false) {
       // user voted before
       wp_send_json_error(['msg' => 'شما قبلا به این فیلم رای دادید!']);
     }else{
       $vote_history[] = $post_id;
     }
     update_user_meta($user_id, 'voted_posts', $vote_history);

    if($user_action == 'like'){
      // like vote
      $likes = empty($likes) ? 0 : $likes;
      $new_likes = $likes + 1;

      update_post_meta($post_id, 'kelaket_likes', $new_likes);

      // send succes response
      wp_send_json_error(['msg' => 'رای مثبت شما برای این فیلم ثبت شد!']);
    }elseif($user_action == 'dislike'){
      // dislike vote
      $dislikes = empty($dislikes) ? 0 : $dislikes;
      $new_dislikes = $dislikes + 1;
      update_post_meta($post_id, 'kelaket_dislikes', $new_dislikes);

      // send succes response
      wp_send_json_error(['msg' => 'رای منفی شما برای این فیلم ثبت شد!']);
    }else{
      wp_send_json_error(['msg' => 'رای ثبت نشد!']);
    }
  }

}

add_action('rest_api_init', function () {
  register_rest_route('mobile/v2', '/setVote', array(
    'methods' => 'POST',
    'callback' => 'setVoteMobile',
  ));
});


// get list of requests
function getRequestsList($request){
  $params = $request->get_params();

  // return $params;
  global $wpdb;
  $tablename = $wpdb->prefix . 'kelaket_reqs';

  if($params){
    // return request for give user
    $user_id = (int) $params;
    $query = " 
      SELECT * 
      FROM $tablename
      WHERE user_id = $user_id
      ORDER BY created_at DESC
    ";  
      
    $res = $wpdb->get_results($query);
    return $res;
  }
}

add_action('rest_api_init', function () {
  register_rest_route('mobile/v2', '/requests', array(
    'methods' => 'GET',
    'callback' => 'getRequestsList',
  ));
});



function sendRequest_mobile($request)
{
  global $wpdb;
  $tablename = $wpdb->prefix . 'kelaket_reqs';

  $params = $request->get_params();
  $name = $params['name'];
  $category = $params['category'];
  $user_id = $params['user_id'];

  if(!empty($name) && !empty($category) && !empty($user_id)){
    $res = $wpdb->insert($tablename, array(
      'name' => $name,
      'type' => $category,
      'user_id' => $user_id,
      'created_at' => current_time('Y-m-d H:i:s'),
    ));
    if($res){
      return [
        'code' => 200,
        'msg' => 'درخواست با موفقیت ثبت شد.'
      ];
    }
  }

  return [$name, $category];
}

add_action('rest_api_init', function () {
  register_rest_route('mobile/v1', '/sendRequest', array(
    'methods' => 'POST',
    'callback' => 'sendRequest_mobile',
  ));
});



// Desktop App API
function featuredFilms_os($data)
{
  $posts = get_posts(array(
    'meta_key' => 'slider',
    'meta_value' => true,
    'numberposts' => 10
  ));

  if (empty($posts)) {
    return null;
  }

  $return = [];

  foreach ($posts as $post) {
    $object = new stdClass();
    $object->name = $post->post_title;
    $object->date = $post->post_date;
    $object->id = $post->ID;
    $object->poster = get_the_post_thumbnail_url($post->ID,'post_retina');
    $object->poster2 = get_field('slider_image', $post->ID)['url'];
    $object->imdbRating = get_field('imdbRating', $post->ID);
    $object->rotten = get_field('rotten', $post->ID);
    $object->sliderBadge = get_field('slider-badge', $post->ID);
    $object->lastEpisode = get_field('last-episode', $post->ID);
    $object->story = get_field('story', $post->ID);
    $object->released = get_field('released', $post->ID);
    $object->def = get_field('def-version', $post->ID);
    $object->doble = get_field('persian-doble', $post->ID);
    if (get_field('censored', $post->ID)) :
      $object->active_badge =  'سانسور شده';
    elseif (get_field('persian-doble', $post->ID)) :
      $object->active_badge =  'دوبله فارسی';
    elseif (get_field('def-version', $post->ID)) :
      $object->active_badge =  'دوبله فارسی';
    endif;
    $object->user_vote = get_post_votes($post->ID)['percent'] . '%';
    $return[] = $object;
  }
  return $return;
  //  return get_the_post_thumbnail_url($posts[0]->ID);

}

add_action('rest_api_init', function () {
  register_rest_route('desktop/v1', '/featured', array(
    'methods' => 'GET',
    'callback' => 'featuredFilms_os',
  ));
});

function singleFilm_os($request)
{

  $params = $request->get_params();
  $id = $params['id'];
  
  $posts = get_posts(array('include' => $id));
  $results = '';

  foreach ($posts as $post) {
    $object2 = new stdClass();
    $actors = get_the_terms($post->ID, 'actor', '', '، ', '');
    $actors_arr = [];
    if($actors){
      foreach($actors as $actor){
        $image = get_template_directory_uri()."/images/no_img.png";
        if(get_field('actor_image_link', $actor)){
          $image = get_field('actor_image_link', $actor);
        }
        $actors_arr[] = ['name' => $actor->name, 'id' => $actor->term_id, 'image' => $image, 'bio' => $actor->description];
      }
    }
    // full actors 
    $object2->full_actors = $actors_arr;
    // related news assigned to film
    $related_blog_posts = get_field('related_blog_post', $post->ID);
    $object2->rel_news = [];
    if($related_blog_posts){
      foreach($related_blog_posts as $blog_post){
        $object2->rel_news[] = [
          'title' => $blog_post->post_title,
          'post_id' => $blog_post->ID,
          'comment_status' => $blog_post->comment_status,
          'excerpt' => substr_replace($blog_post->post_excerpt, "...", 353),
        ];
      }
    }

    $object2->sub = get_field('mobile_sub', $post->ID);
    $object2->cover_bg = get_field('slider_image2', $post->ID)['url'];
    $object2->name = $post->post_title;
    $object2->date = $post->post_date;
    $object2->id = $post->ID;
    $object2->poster = get_the_post_thumbnail_url($post->ID,'post_retina');
    $object2->imdbRating = get_field('imdbRating', $post->ID);
    $object2->rotten = get_field('rotten', $post->ID);
    $object2->sliderBadge = get_field('slider-badge', $post->ID);
    $object2->enName = get_field('en_title', $post->ID);
    $object2->rotten = get_field('rotten', $post->ID);
    $object2->metacritic = get_field('metacritic', $post->ID);
    $object2->story = get_field('story', $post->ID);
    $object2->about = get_field('about', $post->ID);
    $object2->released = get_field('released', $post->ID);
    $object2->def = get_field('def-version', $post->ID);
    $object2->user_vote = get_post_votes($post->ID)['percent'] . '%';
    $object2->doble = get_field('persian-doble', $post->ID);
    $object2->trailer = get_field('trailer', $post->ID);
    $object2->online_single = get_field('mobile_online', $post->ID);
    $object2->online_quality = [
      '1080' => get_field('mobile_1080', $post->ID),
      '720' => get_field('mobile_720', $post->ID),
      '480' => get_field('mobile_480', $post->ID),
    ];
    $object2->genre = strip_tags(get_the_term_list($post->ID, 'genre', '', '، ', ''));
    $object2->actors = strip_tags(get_the_term_list($post->ID, 'actor', '', '، ', ''));
    $object2->rate = strip_tags(get_the_term_list($post->ID, 'rate', '', '، ', ''));
    if (class_exists('Restrict_Content_Pro')) {
      $object2->isPaid = rcp_is_restricted_content($post->ID);
    }
    $object2->director = strip_tags(get_the_term_list($post->ID, 'director', '', '، ', ''));
    $object2->film_dl = [];
    $object2->serial_dl = [];
    //get films download links...
    if (have_rows('film-dl', $post->ID)) {
      $temp2 = [];
      while (have_rows('film-dl', $post->ID)) : the_row();
        $object2->subtitle = get_sub_field('subtitle-film', $post->ID);
        // $temp2[] = ['row_info' => get_sub_field('film_info')];

        if (have_rows('film-dl-link', $post->ID)) {
          $temp = [];
          while (have_rows('film-dl-link', $post->ID)) : the_row();
            $temp[] = [
              'link' => get_sub_field('dl-film-link'),
              'quality' => get_sub_field('quality-film'),
              'online' => get_sub_field('online_link'),
              'version' => get_sub_field('version'),
              'price' => get_sub_field('film-price'),
              'size' => get_sub_field('size-film')
            ];
          // $object2->film_dl = $temp;
          endwhile;
        }
        if (get_sub_field('subtitle-film', $post->ID)) {
          $temp[] = [
            'link' => get_sub_field('subtitle-film', $post->ID),
            'quality' => 'زیرنویس فارسی',
          ];
        }
        if (get_sub_field('farsi-doble-link', $post->ID)) {
          $temp[] = [
            'link' => get_sub_field('farsi-doble-link', $post->ID),
            'quality' => 'صوت دوبله',
          ];
        }
        if (get_sub_field('online_link', $post->ID)) {
          $temp[] = [
            'link' => get_sub_field('online_link', $post->ID),
            'quality' => 'پخش آنلاین',
            'online' => true
          ];
        }
        $temp2[] = ['row_info' => get_sub_field('film_info'), 'data' => $temp];
      endwhile;
      $object2->film_dl = $temp2;
    }
    //get serials download links...
    if (have_rows('serial-dl', $post->ID)) {
      while (have_rows('serial-dl', $post->ID)) : the_row();
        $obj4 = new stdClass();
        $obj4->seasonName = get_sub_field('season-name');
        $obj4->seasonID = get_sub_field('identifer');
        $obj4->episodeCount = get_sub_field('episode-count');
        if (have_rows('dl-links', $post->ID)) {
          while (have_rows('dl-links', $post->ID)) : the_row();
            $temp = [];
            if (have_rows('quality', $post->ID)) {
              while (have_rows('quality', $post->ID)) : the_row();
                $temp[] = [
                  'link' => get_sub_field('quality-dl-link'),
                  'quality' => get_sub_field('quality-name'),
                  'sale' => get_sub_field('sale'),
                ];
              endwhile;
            }
            if (get_sub_field('subtitle')) {
              $temp[] = [
                'link' => get_sub_field('subtitle'),
                'quality' => 'زیرنویس فارسی',
              ];
            }
            if (get_sub_field('farsi-sound')) {
              $temp[] = [
                'link' => get_sub_field('farsi-sound'),
                'quality' => 'صوت دوبله فارسی',
              ];
            }
            $obj4->episode[] = [
              'price' => get_sub_field('serial-price'),
              'online_link' => get_sub_field('online_link_serial'),
              'subtitle' => get_sub_field('subtitle_online_serial'),
              'quality' => [
                '1080' => get_sub_field('serial_1080', $post->ID),
                '720' => get_sub_field('serial_720', $post->ID),
                '480' => get_sub_field('serial_480', $post->ID),
              ],
              'title' => get_sub_field('episode'),
              'link' => $temp
            ];


          endwhile;
        }
        $object2->serial_dl[] = $obj4;
      endwhile;
    }
    //get comments of film
    $comments = get_comments(array('post_id' => $post->ID));

    $object2->comments = $comments;

    $results = $object2;
  }

  return $results;
}

add_action('rest_api_init', function () {
  register_rest_route('desktop/v1', '/film/(?P<id>\d+)', array(
    'methods' => 'GET',
    'callback' => 'singleFilm_os',
  ));
});