<?php /* Custom Styles */

function css_styles(){
$config = get_option('my_framework');
  ?>
<style>

  <?php 
  if(theme_options('custom_palette_active') == false):
  if(theme_options('color_palette') == 'set1'): ?>
    body {
    --bg: #0D1726;
    --bg2: #0f1c2e;
    --bg_darker: #09111c;
    --bg_darker2: #070e17;
    --bg_lighter: #14253e;
    --bg_lighter2: #13243d;
    --primaryColor: <?php echo $config['theme_color']; ?>;
    /* text colors */
    --text: #cce1ff;
    
    }
  <?php elseif(theme_options('color_palette') == 'set2'): ?>
    body{
    --bg: #1c1c22;
    --bg2: #23232b;
    --bg_darker: #101014;
    --bg_darker2: #0b0b0e;
    --bg_lighter: #32323e;
    --bg_lighter2: #2f2f38;
    --primaryColor: <?php echo $config['theme_color']; ?>;
    /* text colors */
    --text: #fff;
    
    }
  <?php elseif(theme_options('color_palette') == 'set3'): ?>
    body{
    --bg: #082032;
    --bg2: #142736;
    --bg_darker: #061724;
    --bg_darker2: #061420;
    --bg_lighter: #1e384b;
    --bg_lighter2: #244459;
    --primaryColor: <?php echo $config['theme_color']; ?>;
    /* text colors */
    --text: #e4f1fa;
    }

    <?php elseif(theme_options('color_palette') == 'set4'): ?>
    body{
    --bg: #3a4550;
    --bg2:#424c57;
    --bg_darker: #2d3640;
    --bg_darker2: #2a323b;
    --bg_lighter: #505c68;
    --bg_lighter2: #3a424c;
    --primaryColor: <?php echo $config['theme_color']; ?>;
    /* text colors */
    --text: #e1e7ee;
    }
    /* .comfortSlider_wrap .dark_bg {
      background: linear-gradient(0deg,#576471 30%,rgba(10,13,16,0));
    } */
    <?php elseif(theme_options('color_palette') == 'set5'): ?>
    body{
    --bg: #21113c;
    --bg2:#2f1953;
    --bg_darker: #150b29;
    --bg_darker2: #0f081d;
    --bg_lighter: #391d69;
    --bg_lighter2: #402076;
    --primaryColor: <?php echo $config['theme_color']; ?>;
    /* text colors */
    --text: #efe6ff;
    }

  <?php endif; ?>
  
  <?php else: ?>
    body{
    --bg: <?php echo theme_options('custom_color_pallete')['bg'] ?>;
    --bg2: <?php echo theme_options('custom_color_pallete')['bg2'] ?>;
    --bg_darker: <?php echo theme_options('custom_color_pallete')['bg_darker'] ?>;
    --bg_darker2: <?php echo theme_options('custom_color_pallete')['bg_darker2'] ?>;
    --bg_lighter: <?php echo theme_options('custom_color_pallete')['bg_lighter'] ?>;
    --bg_lighter2: <?php echo theme_options('custom_color_pallete')['bg_lighter2'] ?>;
    --primaryColor: <?php echo $config['theme_color']; ?>;

    /* text colors */
    --text: <?php echo theme_options('custom_color_pallete')['text'] ?>;
    }
    .comfortSlider_wrap .dark_bg {
      background: linear-gradient(0deg,<?php echo theme_options('custom_color_pallete')['bg'] ?> 30%,rgba(10,13,16,0));
    }  
  <?php endif;?>
  <?php
  // set light mode custom color's
  if( theme_options('light_custom_palette_active')): 
  $pallete = theme_options('light_custom_color_pallete'); 

  list($r, $g, $b) = sscanf($pallete['shadow_color'], "#%02x%02x%02x");
  ?>
    html.dark body {
      --bg: <?php echo $pallete['bg'] ?>;
      --bg2: <?php echo $pallete['bg2'] ?>;
      --text: <?php echo $pallete['text'] ?>;
      --bg_lighter2: <?php echo $pallete['bg_lighter2'] ?>;
      --bg_darker2: <?php echo $pallete['bg_darker2'] ?>;
      --bg_darker: <?php echo $pallete['bg_darker'] ?>;
      --bg_lighter: <?php echo $pallete['bg_lighter'] ?>;
      --shadow_color: <?php echo 'rgb('. $r .' '. $g. ' ' . $b .' / 50% )' ?>;
    }
  <?php else:  // default styles ?>
    html.dark body {
      --bg: #f9fbff;
      --bg2: #fff;
      --text: #6881a9;
      --bg_darker: #6881bc;
      --bg_darker2: #d2def1;
      --bg_lighter: #e0ebfc;
      --bg_lighter2: #0052cc;
    }
  <?php endif;?>

  

  <?php if($config['font'] == 'dana'): ?>
    @font-face {
  font-family: dana;
  font-style: normal;
  font-weight: normal;
  src: url("<?= get_template_directory_uri() ?>/fonts/woff/dana-fanum-regular.woff") format("woff"),
    url("<?= get_template_directory_uri() ?>/fonts/woff2/dana-fanum-regular.woff2") format("woff2");
}

@font-face {
  font-family: dana;
  font-style: normal;
  font-weight: bold;
  src: url("<?= get_template_directory_uri() ?>/fonts/woff/dana-fanum-bold.woff") format("woff"),
    url("<?= get_template_directory_uri() ?>/fonts/woff2/dana-fanum-bold.woff2") format("woff2");
}

@font-face {
  font-family: dana;
  font-style: normal;
  font-weight: 100;
  src: url("<?= get_template_directory_uri() ?>/fonts/woff/dana-fanum-thin.woff") format("woff"),
    url("<?= get_template_directory_uri() ?>/fonts/woff2/dana-fanum-thin.woff2") format("woff2");
}

@font-face {
  font-family: dana;
  font-style: normal;
  font-weight: 200;
  src: url("<?= get_template_directory_uri() ?>/fonts/woff/dana-fanum-light.woff") format("woff"),
    url("<?= get_template_directory_uri() ?>/fonts/woff2/dana-fanum-light.woff2") format("woff2");
}

@font-face {
  font-family: dana;
  font-style: normal;
  font-weight: 300;
  src: url("<?= get_template_directory_uri() ?>/fonts/woff/dana-fanum-medium.woff") format("woff"),
    url("<?= get_template_directory_uri() ?>/fonts/woff2/dana-fanum-medium.woff2") format("woff2");
}

@font-face {
  font-family: dana;
  font-style: normal;
  font-weight: 500;
  src: url("<?= get_template_directory_uri() ?>/fonts/woff/dana-fanum-demibold.woff") format("woff"),
    url("<?= get_template_directory_uri() ?>/fonts/woff2/dana-fanum-demibold.woff2") format("woff2");
}
<?php elseif($config['font'] == 'IRANSans'): ?>
  @font-face {
  font-family: IRANSans;
  font-style: normal;
  font-weight: 900;
  src: url('<?= get_template_directory_uri() ?>/fonts/woff2/IRANSansX-Black.woff2') format('woff2'),
    url('<?= get_template_directory_uri() ?>/fonts/woff/IRANSansX-Black.woff') format('woff');
}

@font-face {
  font-family: IRANSans;
  font-style: normal;
  font-weight: bold;
  src: url('<?= get_template_directory_uri() ?>/fonts/woff2/IRANSansX-Bold.woff2') format('woff2'),
    url('<?= get_template_directory_uri() ?>/fonts/woff/IRANSansX-Bold.woff') format('woff');
}

@font-face {
  font-family: IRANSans;
  font-style: normal;
  font-weight: 300;
  src: url('<?= get_template_directory_uri() ?>/fonts/woff2/IRANSansX-Medium.woff2') format('woff2'),
    url('<?= get_template_directory_uri() ?>/fonts/woff/IRANSansX-Medium.woff') format('woff');
}

@font-face {
  font-family: IRANSans;
  font-style: normal;
  font-weight: 200;
  src: url('<?= get_template_directory_uri() ?>/fonts/woff2/IRANSansX-Light.woff2') format('woff2'),
    url('<?= get_template_directory_uri() ?>/fonts/woff/IRANSansX-Light.woff') format('woff');
}

@font-face {
  font-family: IRANSans;
  font-style: normal;
  font-weight: 100;
  src: url('<?= get_template_directory_uri() ?>/fonts/woff2/IRANSansX-UltraLight.woff2') format('woff2'),
    url('<?= get_template_directory_uri() ?>/fonts/woff/IRANSansX-UltraLight.woff') format('woff');
}

@font-face {
  font-family: IRANSans;
  font-style: normal;
  font-weight: normal;
  src: url('<?= get_template_directory_uri() ?>/fonts/woff2/IRANSansX-Regular.woff2') format('woff2'),
    url('<?= get_template_directory_uri() ?>/fonts/woff/IRANSansX-Regular.woff') format('woff');
}
<?php elseif($config['font'] == 'IRANYekan'): ?>

  @font-face {
	font-family: IRANYekan;
	font-style: normal;
	font-weight: 100;
	src: url('<?= get_template_directory_uri() ?>/fonts/woff/IRANYekanX-Thin.woff') format('woff'),   
	url('<?= get_template_directory_uri() ?>/fonts/woff2/IRANYekanX-Thin.woff2') format('woff2');		
}

@font-face {
	font-family: IRANYekan;
	font-style: normal;
	font-weight: 200;
	src: url('<?= get_template_directory_uri() ?>/fonts/woff/IRANYekanX-UltraLight.woff') format('woff'),   
	url('<?= get_template_directory_uri() ?>/fonts/woff2/IRANYekanX-UltraLight.woff2') format('woff2');	
}

@font-face {
	font-family: IRANYekan;
	font-style: normal;
	font-weight: 300;
	src: url('<?= get_template_directory_uri() ?>/fonts/woff/IRANYekanX-Light.woff') format('woff'),   
	url('<?= get_template_directory_uri() ?>/fonts/woff2/IRANYekanX-Light.woff2') format('woff2');		 
}

@font-face {
	font-family: IRANYekan;
	font-style: normal;
	font-weight: 500;
	src: url('<?= get_template_directory_uri() ?>/fonts/woff/IRANYekanX-Medium.woff') format('woff'),   
	url('<?= get_template_directory_uri() ?>/fonts/woff2/IRANYekanX-Medium.woff2') format('woff2');		 
}

@font-face {
	font-family: IRANYekan;
	font-style: normal;
	font-weight: 600;
	src: url('<?= get_template_directory_uri() ?>/fonts/woff/IRANYekanX-DemiBold.woff') format('woff'),   
	url('<?= get_template_directory_uri() ?>/fonts/woff2/IRANYekanX-DemiBold.woff2') format('woff2');	 
}


@font-face {
	font-family: IRANYekan;
	font-style: normal;
	font-weight: bold;
	src: url('<?= get_template_directory_uri() ?>/fonts/woff/IRANYekanX-Bold.woff') format('woff'),   
	url('<?= get_template_directory_uri() ?>/fonts/woff2/IRANYekanX-Bold.woff2') format('woff2');	 
}

@font-face {
	font-family: IRANYekan;
	font-style: normal;
	font-weight: normal;
	src: url('<?= get_template_directory_uri() ?>/fonts/woff/IRANYekanX-Regular.woff') format('woff'),   
	url('<?= get_template_directory_uri() ?>/fonts/woff2/IRANYekanX-Regular.woff2') format('woff2');	
}
<?php endif;?>

  body{
    font-family: <?= $config['font'] ?>;
    -webkit-font-smoothing: antialiased;
    <?php if( is_rtl() ): ?>
    -moz-font-feature-settings: "ss02";
    -webkit-font-feature-settings: "ss02";
    font-feature-settings: "ss02";
    <?php endif; ?>
  }
  .tooltip {
    font-family: <?= $config['font'] ?>;
  }
    .slider .slider_link:hover {
      background-color: <?php echo $config['theme_color']; ?>
    }

    .post .post_download {
      border-color: <?php echo $config['theme_color']; ?>;
      color: <?php echo $config['theme_color']; ?>;
    }

    .post .post_download:hover {
      background-color: <?php echo $config['theme_color']; ?>;
    }

    .nav-link.active {
      background-color: <?php echo $config['theme_color']; ?> !important;
    }

    .search_wrap #searchsubmit {
      background-color: <?php echo $config['theme_color']; ?>;
    }

    .search_wrap #searchsubmit:hover {
      background-color: <?php echo $config['theme_color']; ?>;
    }

    .pagination span {
      background-color: <?php echo $config['theme_color']; ?>;
    }

    .pagination a:hover {
      background-color: <?php echo $config['theme_color']; ?>;
    }

    .footer .links li:before {
      color: <?php echo $config['theme_color']; ?>;
    }

    .footer .btn-large i:first-of-type {
      color: <?php echo $config['theme_color']; ?>;

    }

    .user_btn a, .user_btn button {
      background-color: <?php echo $config['theme_color']; ?>
    }

    html.dark .sidebar_active {
      background-color: <?php echo $config['theme_color']; ?>
    }

    .owl-dot {
      background-color: <?php echo $config['theme_color']; ?> !important;
    }

    .boxOffice .boxOffice__name span {
      background-color: <?php echo $config['theme_color']; ?>
    }

    .boxOfficeMore {
      color: <?php echo $config['theme_color']; ?>;
    }

    .boxOfficeMore:hover {
      background: <?php echo $config['theme_color']; ?>24;
      color: <?php echo $config['theme_color']; ?>;
    }

    .related_post_blog_item .icon span {
      background: <?php echo $config['theme_color']; ?>;
    }


    .single__content .owl-next,
    .single__content .owl-prev {
      background: <?php echo $config['theme_color']; ?> !important;
      color: #fff !important;
    }

    
    .post2 .single_cast .owl-next, .post2 .single_cast .owl-prev{
      background: <?php echo $config['theme_color']; ?> !important;
      color: #fff !important;
    }

    .post2 .about_box .post_download {
      background: <?php echo $config['theme_color']; ?> !important;

    }

    .post2 .about_box .post_download:hover {
      /* box-shadow: inset 0px 40px 0 <?php echo $config['theme_color']; ?> !important; */
      box-shadow: 0 0 0 4px <?php echo $config['theme_color']; ?>7a !important;
    }
    .series_week .series_week__header li:hover{
      background: <?php echo $config['theme_color']; ?>;
    }
    .download_notice i{
      color: <?php echo $config['theme_color']; ?>;

    }
    ._textAds li a:hover{
      background: <?php echo $config['theme_color']; ?>;
      box-shadow: 0 0 0 2px <?php echo $config['theme_color']; ?>7a !important;
    }
    .show_toggle{
      background: <?php echo $config['theme_color']; ?>;
    }
    .cat_title a{
      border-color: <?php echo $config['theme_color']; ?>;
      color: <?php echo $config['theme_color']; ?>;
    }
    .cat_title a:hover{
      border-color: <?php echo $config['theme_color']; ?>;
      color: #fff;
      background: <?php echo $config['theme_color']; ?>;

    }
    .search_wrap_index #searchsubmit{
      background: <?php echo $config['theme_color']; ?>;
    }
    .search_wrap_index #searchsubmit:hover{
      background: <?php echo $config['theme_color']; ?>;
    }

    .related_post_blog_item a {
      color: <?php echo $config['theme_color']; ?>;
      padding: 5px 10px;
      border-radius: 3px;
      transition: all 0.3s;
    }

    .reply {
      background: <?php echo $config['theme_color']; ?>;
    }

    .reply:hover {
      background: <?php echo $config['theme_color']; ?>;
    }

    .related_post_blog_item a:hover {
      background: <?php echo $config['theme_color']; ?>24;
      color: <?php echo $config['theme_color']; ?>;
    }

    html.dark ._textAds li a:hover {
      background-color: <?php echo $config['theme_color']; ?>
    }

    .owl-dot.active {
      background-color: <?php echo $config['theme_color']; ?> !important;
    }

    html.dark .collection_content {
      background: #fff!important;
      border: 1px solid #e0ebfc;
      box-shadow: 0 10px 15px 0 rgb(220 227 247 / 50);
    }

    html.dark .collection_title .name{
      color: #6881a9
    }

    html.dark .collection_mask{
      opacity: 0.1;
    }
    .boxOffice_item .boxOffice_image .rank{
      background: <?php echo $config['theme_color']; ?>;
    }

    .series_week .series_week__header li.active{
      background: <?php echo $config['theme_color']; ?>;
      color: #fff;
    }

    .show_more{
      background: <?php echo $config['theme_color']; ?>;
    }

    .film_search button{
      background: <?php echo $config['theme_color']; ?>;
    }
    .acc_info_ .buy_vip{
      background: <?php echo $config['theme_color']; ?>;
      border-color: <?php echo $config['theme_color']; ?>;
      
    }
    input:checked + .slider {
      background-color: <?php echo $config['theme_color']; ?>;
    }

    input:focus + .slider {
      box-shadow: 0 0 1px <?php echo $config['theme_color']; ?>;
    }
    .custom_list a.author{
      background-color: <?php echo $config['theme_color']; ?>;
    }
    .custom_list a.list{
      color: <?php echo $config['theme_color']; ?>;
    }
    html.dark .series_week .series_week__header li.active{
      background-color: <?php echo $config['theme_color']; ?>;
      color: #fff;
    }

    .post2 .post_details .post_meta li strong .icon{
      background-color: <?php echo $config['theme_color']; ?>;
    }
    .new_advanced_search .search_type span.active{
      background-color: <?php echo $config['theme_color']; ?>;
      color: #fff;
    }
    .adv_search_submit{
      background-color: <?php echo $config['theme_color']; ?>;
    }
    .mobile_adv_submit{
      background-color: <?php echo $config['theme_color']; ?>;
    }
    .mobile_adv_trigger .filter_icon{
      background-color: <?php echo $config['theme_color']; ?>;
    }

    .switch-toggle label input:checked + span{
      background-color: <?php echo $config['theme_color']; ?>;
    }

    html.dark .body_l .acc_info_ table a{
      background-color: <?php echo $config['theme_color']; ?>;
    }
    html.dark .body_panel .acc_info_ table a:hover{
      background-color: <?php echo $config['theme_color']; ?>;
    }

    .vip_modal_center .cta a{
      background-color: <?php echo $config['theme_color']; ?>;
    }

    .go_top{
      background-color: <?php echo $config['theme_color']; ?>;
    }

    .comment_spoiler .show_comment{
      background-color: <?php echo $config['theme_color']; ?>;
    }

    .post_minimal_download{
      background-color: <?php echo $config['theme_color']; ?>;
    }
    .backButton, .ep_select, .close_btn_ep, .save_settings, .close_btn{
      background-color: <?php echo $config['theme_color']; ?>!important;
    }

    .big_cat_title .star_title_c::before{
      background-color: <?php echo $config['theme_color']; ?>!important;
    }
    .post_content_single .awards li i {
      color: <?php echo $config['theme_color']; ?>;
    }

    .form-submit .submit{
      background-color: <?php echo $config['theme_color']; ?>!important;
    }
    .form-submit .submit:hover{
     opacity: .8;
    }

    .sidebar .nav_panel ul li span:before{
      background-color: <?php echo $config['theme_color']; ?>!important;
    }
    .submit_auth_2,.submit-reg{
      background: <?php echo $config['theme_color']; ?>!important;
      border-color: <?php echo $config['theme_color']; ?>!important;
    }

    .film_cat2 .film_overlay2 i{
      background: <?php echo $config['theme_color']; ?>!important;
    }

    body{
      --plyr-color-main: <?php echo $config['theme_color']; ?>!important;
    }

    .search_modal_input:focus{
      box-shadow: 0px 0px 0px 4px <?php echo $config['theme_color']; ?>;
    }

    .single_cover_wrap .simplefavorite-button{
      background: <?php echo $config['theme_color']; ?>;
    }

    .timeline__date{
      color: <?php echo $config['theme_color']; ?>!important;
      background: <?php echo $config['theme_color']; ?>3d!important;
      padding: 5px;
      border-radius: 5px;
    }

    .footer_modern .links h3::before{
      background: <?php echo $config['theme_color']; ?>;
    }
    
    .footer .links li:before{
      background: <?php echo $config['theme_color']; ?>;
    }

    .post_blog p a{
      color: <?php echo $config['theme_color']; ?>;
      font-weight: 700;
    }
    .post_blog p a:hover{
      color: <?php echo $config['theme_color']; ?>;
      font-weight: 700;
    }

    .widget_title .nav-link.active::after{
      border-color: transparent transparent <?php echo $config['theme_color']; ?> transparent;
    }
    .post2 .post_details .post_meta li strong .icon::after{
      border-color: transparent <?php echo $config['theme_color']; ?> transparent transparent;
    }


    <?php if(theme_options('adminNotice_bg')):  ?>
    .adminNotice{
      background-color: <?php echo theme_options('adminNotice_bg')['background-color'] ?>;
      background-image: linear-gradient(<?php echo theme_options('adminNotice_bg')['background-gradient-direction'] ?>, <?php echo theme_options('adminNotice_bg')['background-color'] ?>, <?php echo theme_options('adminNotice_bg')['background-gradient-color'] ?>);
      <?php if(theme_options('adminNotice_bg')['background-image']['url']):?>
        background-image: url(<?php echo theme_options('adminNotice_bg')['background-image']['url']; ?>);
        background-position: <?php echo theme_options('adminNotice_bg')['background-position']; ?>;
        background-repeat: <?php echo theme_options('adminNotice_bg')['background-repeat']; ?>;
        background-attachment: <?php echo theme_options('adminNotice_bg')['background-attachment']; ?>;
        background-size: <?php echo theme_options('adminNotice_bg')['background-size']; ?>;
      <?php endif;?>
    }

  <?php endif; ?>

    <?php if ($config['header_style']) : ?><?= $config['header_style']; ?><?php endif; ?>
  </style>
  <?php
}

add_action('wp_head', 'css_styles', 100);




function admin_css(){?>

<style>
@font-face {
    font-family: IRANYekan;
    font-style: normal;
    font-weight: normal;
    src: url('<?= get_template_directory_uri() ?>/fonts/woff2/IRANYekanX-Regular.woff2') format('woff2'),
      url('<?= get_template_directory_uri() ?>/fonts/woff/IRANYekanX-Regular.woff') format('woff');
  }
    @font-face {
    font-family: IRANYekan;
    font-style: normal;
    font-weight: bold;
    src: url('<?= get_template_directory_uri() ?>/fonts/woff2/IRANYekanX-Bold.woff2') format('woff2'),
      url('<?= get_template_directory_uri() ?>/fonts/woff/IRANYekanX-Bold.woff') format('woff');
  }


body,
.rtl h1, .rtl h2, .rtl h3, .rtl h4, .rtl h5, .rtl h6, #wpwrap, #wpbody, #wpadminbar
{
  font-family: IRANYekan !important;
  -webkit-font-smoothing: antialiased;
}
</style>

<?php }

add_action('admin_head', 'admin_css', 100);