<?php
function create_kelaket_taxonomy(){
  $labels = array(
    'name' => _x('بازیگران', 'taxonomy general name', 'kelaketfilm'),
    'singular_name' => _x('بازیگران', 'taxonomy singular name', 'kelaketfilm'),
    'search_items' => __('جستجو بازیگر', 'kelaketfilm'),
    'all_items' => __('تمام بازیگران', 'kelaketfilm'),
    'parent_item' => __('استفاده نکنید', 'kelaketfilm'),
    'parent_item_colon' => __('Parent Subject:', 'kelaketfilm'),
    'edit_item' => __('ویرایش بازیگر', 'kelaketfilm'),
    'update_item' => __('بروزرسانی بازیگر', 'kelaketfilm'),
    'add_new_item' => __('افزودن بازیگر', 'kelaketfilm'),
    'new_item_name' => __('New Subject Name', 'kelaketfilm'),
    'menu_name' => __('بازیگران', 'kelaketfilm'),
  );

  // Now register the taxonomy
  register_taxonomy('actor', array('post'), array(
    'hierarchical' => true,
    'labels' => $labels,
    'show_ui' => true,
    'show_in_rest' => true,
    'show_admin_column' => false,
    'query_var' => true,
    'rewrite' => array('slug' => 'actor'),
  ));

  $labels2 = array(
    'name' => _x('کارگردان', 'taxonomy general name', 'kelaketfilm'),
    'singular_name' => _x('کارگردان', 'taxonomy singular name', 'kelaketfilm'),
    'search_items' => __('جستجو کارگردان', 'kelaketfilm'),
    'all_items' => __('تمام کارگردانان', 'kelaketfilm'),
    'parent_item' => __('استفاده نکنید', 'kelaketfilm'),
    'parent_item_colon' => __('Parent Subject:', 'kelaketfilm'),
    'edit_item' => __('ویرایش کارگردان', 'kelaketfilm'),
    'update_item' => __('بروزرسانی کارگردان', 'kelaketfilm'),
    'add_new_item' => __('افزودن کارگردان', 'kelaketfilm'),
    'new_item_name' => __('New Subject Name', 'kelaketfilm'),
    'menu_name' => __('کارگردان', 'kelaketfilm'),
  );

  // Now register the taxonomy
  register_taxonomy('director', array('post'), array(
    'hierarchical' => true,
    'labels' => $labels2,
    'show_ui' => true,
    'show_in_rest' => true,
    'show_admin_column' => false,
    'query_var' => true,
    'rewrite' => array('slug' => 'director'),
  ));


  $labels_genre = array(
    'name' => _x('ژانر', 'taxonomy general name'),
    'singular_name' => _x('ژانر', 'taxonomy singular name', 'kelaketfilm'),
    'search_items' => __('جستجو ژانر', 'kelaketfilm'),
    'all_items' => __('تمام ژانرها', 'kelaketfilm'),
    'parent_item' => __('استفاده نکنید', 'kelaketfilm'),
    'parent_item_colon' => __('Parent Subject:', 'kelaketfilm'),
    'edit_item' => __('ویرایش ژانر', 'kelaketfilm'),
    'update_item' => __('بروزرسانی ژانر', 'kelaketfilm'),
    'add_new_item' => __('افزودن ژانر', 'kelaketfilm'),
    'new_item_name' => __('New Subject Name', 'kelaketfilm'),
    'menu_name' => __('ژانر', 'kelaketfilm'),
  );


  register_taxonomy('genre', array('post'), array(
    'hierarchical' => true,
    'labels' => $labels_genre,
    'show_ui' => true,
    'show_in_rest' => true,
    'show_admin_column' => true,
    'query_var' => true,
    'rewrite' => array('slug' => 'genre'),
  ));

  $labels_type = array(
    'name' => _x('نوع پست', 'taxonomy general name', 'kelaketfilm'),
    'singular_name' => _x('نوع پست', 'taxonomy singular name', 'kelaketfilm'),
    'search_items' => __('جستجو نوع پست'),
    'all_items' => __('تمام نوع پست'),
    'parent_item' => __('استفاده نکنید'),
    'parent_item_colon' => __('Parent Subject:'),
    'edit_item' => __('ویرایش نوع پست'),
    'update_item' => __('بروزرسانی نوع پست'),
    'add_new_item' => __('افزودن نوع پست'),
    'new_item_name' => __('New Subject Name'),
    'menu_name' => __('نوع پست', 'kelaketfilm'),
  );


  register_taxonomy('type_of_post', array('post'), array(
    'hierarchical' => true,
    'labels' => $labels_type,
    'show_ui' => true,
    'show_in_rest' => true,
    'show_admin_column' => true,
    'query_var' => true,
    'rewrite' => array('slug' => 'type_of_post'),
  ));

  $labels_year = array(
    'name' => _x('سال تولید', 'taxonomy general name', 'kelaketfilm'),
    'singular_name' => _x('سال تولید', 'taxonomy singular name', 'kelaketfilm'),
    'search_items' => __('جستجو سال تولید', 'kelaketfilm'),
    'all_items' => __(' تمام سال تولید', 'kelaketfilm'),
    'parent_item' => __('استفاده نکنید', 'kelaketfilm'),
    'parent_item_colon' => __('Parent Subject:', 'kelaketfilm'),
    'edit_item' => __('ویرایش  سال تولید', 'kelaketfilm'),
    'update_item' => __('بروزرسانی  سال تولید', 'kelaketfilm'),
    'add_new_item' => __('افزودن سال تولید', 'kelaketfilm'),
    'new_item_name' => __('New Subject Name', 'kelaketfilm'),
    'menu_name' => __('سال تولید', 'kelaketfilm'),
  );


  register_taxonomy('yearr', array('post'), array(
    'hierarchical' => true,
    'labels' => $labels_year,
    'show_ui' => true,
    'show_in_rest' => true,
    'show_admin_column' => false,
    'query_var' => true,
    'rewrite' => array('slug' => 'year'),
  ));

  $labels_country = array(
    'name' => _x('کشور سازنده', 'taxonomy general name', 'kelaketfilm'),
    'singular_name' => _x('کشور سازنده', 'taxonomy singular name', 'kelaketfilm'),
    'search_items' => __('جستجو کشور سازنده', 'kelaketfilm'),
    'all_items' => __(' تمام کشور سازنده', 'kelaketfilm'),
    'parent_item' => __('استفاده نکنید', 'kelaketfilm'),
    'parent_item_colon' => __('Parent Subject:', 'kelaketfilm'),
    'edit_item' => __('ویرایش  کشور سازنده', 'kelaketfilm'),
    'update_item' => __('بروزرسانی کشور سازنده', 'kelaketfilm'),
    'add_new_item' => __('افزودن کشور سازنده', 'kelaketfilm'),
    'new_item_name' => __('New Subject Name', 'kelaketfilm'),
    'menu_name' => __('کشور سازنده', 'kelaketfilm'),
  );


  register_taxonomy('country', array('post'), array(
    'hierarchical' => true,
    'labels' => $labels_country,
    'show_ui' => true,
    'show_in_rest' => true,
    'show_admin_column' => false,
    'query_var' => true,
    'rewrite' => array('slug' => 'country'),
  ));

  $labels_rate = array(
    'name' => _x('رده سنی', 'taxonomy general name', 'kelaketfilm'),
    'singular_name' => _x('رده سنی', 'taxonomy singular name', 'kelaketfilm'),
    'search_items' => __('جستجو رده سنی', 'kelaketfilm'),
    'all_items' => __(' تمام رده سنی', 'kelaketfilm'),
    'parent_item' => __('استفاده نکنید', 'kelaketfilm'),
    'parent_item_colon' => __('Parent Subject:'),
    'edit_item' => __('ویرایش  رده سنی', 'kelaketfilm'),
    'update_item' => __('بروزرسانی رده سنی', 'kelaketfilm'),
    'add_new_item' => __('افزودن رده سنی', 'kelaketfilm'),
    'new_item_name' => __('New Subject Name', 'kelaketfilm'),
    'menu_name' => __('رده سنی', 'kelaketfilm'),
  );


  register_taxonomy('rate', array('post'), array(
    'hierarchical' => true,
    'labels' => $labels_rate,
    'show_ui' => true,
    'show_in_rest' => true,
    'show_admin_column' => false,
    'query_var' => true,
    'rewrite' => array('slug' => 'rate'),
  ));

  $labels_score = array(
    'name' => _x('امتیاز', 'taxonomy general name', 'kelaketfilm'),
    'singular_name' => _x('امتیاز', 'taxonomy singular name', 'kelaketfilm'),
    'search_items' => __('جستجو امتیاز', 'kelaketfilm'),
    'all_items' => __(' تمام امتیاز', 'kelaketfilm'),
    'parent_item' => __('استفاده نکنید', 'kelaketfilm'),
    'parent_item_colon' => __('Parent Subject:', 'kelaketfilm'),
    'edit_item' => __('ویرایش  امتیاز', 'kelaketfilm'),
    'update_item' => __('بروزرسانی امتیاز', 'kelaketfilm'),
    'add_new_item' => __('افزودن امتیاز', 'kelaketfilm'),
    'new_item_name' => __('New Subject Name', 'kelaketfilm'),
    'menu_name' => __('امتیاز', 'kelaketfilm'),
  );


  register_taxonomy('score', array('post'), array(
    'hierarchical' => true,
    'labels' => $labels_score,
    'show_ui' => true,
    'show_in_rest' => true,
    'show_admin_column' => false,
    'query_var' => true,
    'rewrite' => array('slug' => 'score'),
  ));

  $labels_score = array(
    'name' => _x('دسته بندی', 'taxonomy general name', 'kelaketfilm'),
    'singular_name' => _x('دسته بندی', 'taxonomy singular name', 'kelaketfilm'),
    'search_items' => __('جستجو دسته بندی', 'kelaketfilm'),
    'all_items' => __(' تمام دسته بندی', 'kelaketfilm'),
    'parent_item' => __('پرنت', 'kelaketfilm'),
    'parent_item_colon' => __('Parent Subject:', 'kelaketfilm'),
    'edit_item' => __('ویرایش  دسته بندی ', 'kelaketfilm'),
    'update_item' => __('بروزرسانی دسته بندی ', 'kelaketfilm'),
    'add_new_item' => __('افزودن دسته بندی ', 'kelaketfilm'),
    'new_item_name' => __('New Subject Name', 'kelaketfilm'),
    'menu_name' => __('دسته بندی ', 'kelaketfilm'),
  );


  register_taxonomy('blog_category', array('blog'), array(
    'hierarchical' => true,
    'labels' => $labels_score,
    'show_ui' => true,
    'show_in_rest' => true,
    'show_admin_column' => true,
    'query_var' => true,
    'rewrite' => array('slug' => 'blog_category'),
  ));
}
add_action('init', 'create_kelaket_taxonomy', 0);
