<section class="custom_carousel">
  <?php 
  if(theme_options('blog_custom_cats')){
    foreach(theme_options('blog_custom_cats') as $item): ?>
      <section class="blog_carousel mt-5">
        <h3><?php echo $item['blog_custom_cats__title'] ?></h3>
        <div class="owl-carousel blog_carousel_instance">
          <?php
          $args = array(
            'post_type' => 'blog',
            'showposts' => (int) $item['blog_custom_cats__count'],
            'tax_query' => array(
              array(
                'taxonomy'  => 'blog_category',
                'field'     => 'term_id',
                'terms'     => $item['blog_custom_cats__cat'],
                'operator'  => 'IN',
              )
            ),
          );
          $the_query = new WP_Query($args);
          while ($the_query->have_posts()) : $the_query->the_post(); ?>
            <div>
              <a href="<?php the_permalink(); ?>">
                <?php the_post_thumbnail('blog-img'); ?>
              </a>
              <div class="blog_carousel__title">
                <a href="<?php the_permalink(); ?>">
                  <h2><?php the_title(); ?></h2>
                </a>
              </div>
            </div>
          <?php endwhile; ?>
          <?php wp_reset_query(); ?>
        </div>
      </section>
    <?php endforeach;
  }
  ?>
</section>