<?php
$boxOfficeDate = $args['type'];
$api_token = get_option('my_framework')['imdb-api-token'];

  if($boxOfficeDate == 'new'){
    //get weekend boxOffice
    $transient = get_transient('weekend_boxOffice');
    if(!empty($transient)){
      //do stuff with cache
      $data = $transient;
    }else{
      $api_url = "https://imdb-api.com/en/API/BoxOffice/$api_token";
      $request = wp_remote_get($api_url);
      if (is_wp_error($request)) {
        kelaket_log('box_office_page', $request->get_error_message());
        echo '<div class="rcp_error">مشکلی در دریافت اطلاعات پیش آمد - کلید api imdb-api.com را از پنل تنظیمات چک کنید در صورتی که مشکل پایدار بود با پشتیبانی در تماس باشید.</div>';
      }
      $data = json_decode(wp_remote_retrieve_body($request));
      set_transient( 'weekend_boxOffice', $data, DAY_IN_SECONDS );
    }

  }elseif($boxOfficeDate == 'old'){
    //all time box-office
    $transient = get_transient('all_boxOffice');
    if(!empty($transient)){
      //do stuff with cache
      $data = $transient;
    }else{
      $api_url = "https://imdb-api.com/en/API/BoxOfficeAllTime/$api_token";
      $request = wp_remote_get($api_url);
      if (is_wp_error($request)) {
        kelaket_log('box_office_page', $request->get_error_message());
        echo '<div class="rcp_error">مشکلی در دریافت اطلاعات پیش آمد - کلید api imdb-api.com را از پنل تنظیمات چک کنید در صورتی که مشکل پایدار بود با پشتیبانی در تماس باشید.</div>';
      }
      $data = json_decode(wp_remote_retrieve_body($request));
      set_transient( 'all_boxOffice', $data, DAY_IN_SECONDS );
    }
  }

  if($data) : foreach($data->items as $item):
    $poster_image = str_replace('Ratio0.6716_AL_', 'UX500', $item->image);

  if($boxOfficeDate == 'new'):
?>

<div class="col-lg-12">
  <div class="boxOffice_item">
    <div class="row">
      <div class="col-md-8 col-12 d-flex align-items-center flex-md-row flex-column">
        <div class="boxOffice_image">
          <div class="position-relative">
            <a href="<?php bloginfo('url') ?>?imdb_id=<?php echo $item->id ?>">
            <img src="<?php echo $poster_image ?>" alt="<?php echo $item->title; ?>">
            </a>
            <span class="rank"><?php echo $item->rank ?></span>
          </div>
        </div>
        <div class="pe-3 boxOffice_title">
          <a href="<?php bloginfo('url') ?>?imdb_id=<?php echo $item->id ?>">
            <h3><?php echo $item->title; ?></h3>
          </a>
        </div>
      </div>
      <div class="col-md-4 col-12">
        <div class="boxOffice__meta px-2">
          <ul class="d-flex flex-column mt-3">
            <li class="d-flex justify-content-between">هفته اکران <span><?= $item->weeks ?></span></li>
            <li class="d-flex justify-content-between bg">فروش اخرهفته <span><?= $item->weekend ?></span></li>
            <li class="d-flex justify-content-between">فروش کل <span style="font-size: 17px; font-weight: 700; color: #ffad49"><?= $item->gross ?></span></li>
          </ul>
        </div>
      </div>
    </div>
  </div>
</div>


<?php elseif($boxOfficeDate == 'old'): ?>
  <div class="col-lg-12">
  <div class="boxOffice_item position-relative">
    <div class="row">
      <div class="col-md-8 col-12 d-flex align-items-center flex-md-row flex-column">
        <span class="rank_all"><?php echo $item->rank ?></span>
        <div class="ps-3 boxOffice_title">
          <a href="<?php bloginfo('url') ?>?imdb_id=<?php echo $item->id ?>">
            <h3><?php echo $item->title; ?></h3>
          </a>
        </div>
      </div>
      <div class="col-md-4 col-12">
        <div class="boxOffice__meta px-2">
          <ul class="d-flex flex-column mt-3">
            <li class="d-flex justify-content-between">درصد فروش داخلی:‌ <span><?= $item->domestic ?></span></li>
            <li class="d-flex justify-content-between bg">فروش داخلی:‌ <span><?= $item->domesticLifetimeGross ?></span></li>
            <li class="d-flex justify-content-between">درصد فروش خارجی:‌ <span><?= $item->foreign ?></span></li>
            <li class="d-flex justify-content-between bg">فروش خارجی:‌ <span><?= $item->foreignLifetimeGross ?></span></li>
            <li class="d-flex justify-content-between">فروش جهانی:‌ <span><?= $item->worldwideLifetimeGross ?></span></li>
            <li class="d-flex justify-content-between bg">سال تولید:‌ <span><?= $item->year ?></span></li>
          </ul>
        </div>
      </div>
    </div>
  </div>
</div>
<?php endif; ?>
<?php endforeach;endif; ?>