<div class="row">
        <?php
        global $wpdb;
        $tablename = $wpdb->prefix . 'kelaket_lists';
        $pagenum = (get_query_var('paged')) ? get_query_var('paged') : 1;
        $limit = 12;
        $offset = ($pagenum - 1) * $limit;
        $total = $wpdb->get_var("SELECT COUNT(*) FROM $tablename");
        $num_of_pages = ceil($total / $limit);

        $qry = "select * from $tablename WHERE is_private = false ORDER BY id DESC LIMIT $offset, $limit";
        $result = $wpdb->get_results($qry);
        foreach($result as $item):
          $user = get_user_by('id', $item->user_id);
          $films = explode(',', $item->films);
          if(empty($films[0])){
            $count = 0;
          }else{
            $count = count($films);
          }
          // fix first image issue due the first index of array alwasy empty 
          if(!get_the_post_thumbnail_url($films[0],'post_retina')){
            $firstImage = get_template_directory_uri().'/images/nocover.jpeg';
          }else{
            $firstImage = get_the_post_thumbnail_url($films[0],'post_retina');
          }
        ?>
        <div class="col-xl-3 col-lg-6 col-md-6">
          <div class="custom_list">
            <a href="<?php echo site_url(). "/lists/$item->id" ?>">
            <div class="custom_list_images">
              <div>
                <img src="<?php echo $firstImage ?>">
                <img src="<?php echo checkIndexExists($films, 1) ?  get_the_post_thumbnail_url($films[1],'post_retina') : get_template_directory_uri().'/images/nocover.jpeg' ?>">
              </div>
              <div>
                <img src="<?php echo checkIndexExists($films, 2) ? get_the_post_thumbnail_url($films[2],'post_retina') : get_template_directory_uri().'/images/nocover.jpeg' ?>">
                <img src="<?php echo checkIndexExists($films, 3) ?get_the_post_thumbnail_url($films[3],'post_retina') : get_template_directory_uri().'/images/nocover.jpeg' ?>">
              </div>
            </div>
            </a>
            <h3>
              <a data-bs-toggle='tooltip' data-bs-placement='top' title="<?php echo $item->name; ?>" class="list" href="<?php echo site_url() . "/lists/$item->id" ?>"><?php echo limited_excerpt($item->name, 20) ?></a>
              <?php _e('توسط', 'kelaketfilm') ?>
              <a class="author" href="<?php echo bloginfo('url').'/profile/'. $user->user_login;  ?>"><?php echo $user->display_name; ?></a>
            </h3>
            <div class="custom_list_meta">
              <span><?php _e('تعداد :', 'kelaketfilm') ?> <?php echo $count;?></span>
              <?php
              //check if post updated show date as tooltip
              if($item->updated_at == '0000-00-00 00:00:00'){
                $update = "";
              }else{
                $update = __('آخرین بروزرسانی', 'kelaketfilm'); mysql2date( ' F j, Y', $item->updated_at  );
              }
              ?>
              <span data-bs-toggle='tooltip' data-bs-placement='top' title="<?php echo $update; ?>"><?php echo  mysql2date( ' F j, Y', $item->created_at  )?></span>
            </div>
          </div>
        </div>
        <?php endforeach; ?>
      </div>

      <div class="pagination">
        <?php
        echo paginate_links(array(
          'base' => str_replace(999999999, '%#%', esc_url(get_pagenum_link(999999999))),
          'total' => $num_of_pages,
          'current' => max(1, get_query_var('paged')),
          'format' => '?paged=%#%',
          'show_all' => false,
          'type' => 'plain',
          'end_size' => 2,
          'mid_size' => 1,
          'prev_next' => true,
          'prev_text' => sprintf('<i></i> %1$s', __('قبلی', 'kelaketfilm')),
          'next_text' => sprintf('%1$s <i></i>', __('بعدی', 'kelaketfilm')),
          'add_args' => false,
          'add_fragment' => '',
        ));
        ?>
      </div>