<div class="row">
  <?php
  global $wpdb;
  $list_id = get_query_var('id') ? get_query_var('id') : '';
  $tablename = $wpdb->prefix . 'kelaket_lists';
  $qry = "select * from $tablename WHERE id = $list_id LIMIT 1";
  $result = $wpdb->get_results($qry);
  $user = get_user_by('id', $args['user_id']);
  $list_name = $result[0]->name;
  $list_desc = $result[0]->list_desc;
  $list_user = $result[0]->user_id;
  $update_date = $result[0]->updated_at;
  $is_private = $result[0]->is_private;
  $films_array = explode(',', $result[0]->films);


  if (empty($films[0])) {
    $count = 0;
  } else {
    $count = count($films);
  }
  // custom regex to get current page
  preg_match_all('!\d+!', $_SERVER['REQUEST_URI'], $matches);
  if (isset($matches[0][1])) {
    $current_page = $matches[0][1];
  } else {
    $current_page = 1;
  }

  $args = array(
    'post__in' => $films_array,
    'posts_per_page' => 36,
    'orderby' => 'post__in',
    'paged' => $current_page,
    'post_status' => 'publish',
    'post_type' => 'post',
  );

  $posts = new WP_Query($args);
  $paged_no = ($posts->query_vars['paged'] < 2) ? 0 : $posts->query_vars['paged'] - 1;
  $current_offset = $paged_no * $posts->query_vars['posts_per_page'];
  if ($posts->have_posts()) :
    $i = 1;
    while ($posts->have_posts()) {
      $posts->the_post();
      echo '<div class="col-lg-2 col-md-3 col-sm-6 col-6">';
      if(theme_options('film_card_style') == 'style1'):
        get_template_part('/inc/template_parts/cards/film_card');
      elseif(theme_options('film_card_style') == 'style2'):
        get_template_part('/inc/template_parts/cards/film_card2');
      elseif(theme_options('film_card_style') == 'style3'):
          get_template_part('/inc/template_parts/cards/film_card3');
      endif;
      echo '</div>';
     }
    wp_reset_postdata();
  else : ?>
    <div class="text-center p-5 list_text">
      <h6><?php _e('لیست خالی می‌باشد.', 'kelaketfilm'); ?></h6>
    </div>
  <?php endif; ?>

</div>

<div class="pagination">
  <?php
  echo paginate_links(array(
    'base' => str_replace(999999999, '%#%', esc_url(get_pagenum_link(999999999))),
    'total' => $posts->max_num_pages,
    'current' => max(1, $current_page),
    'format' => '?paged=%#%',
    'show_all' => false,
    'type' => 'plain',
    'end_size' => 2,
    'mid_size' => 1,
    'prev_next' => true,
    'prev_text' => sprintf('<i></i> %1$s', __('قبلی', 'kelaketfilm')),
    'next_text' => sprintf('%1$s <i></i>', __('بعدی', 'kelaketfilm')),
    'add_args' => false,
    'add_fragment' => '',
  ));
  ?>
</div>