<div class="search_modal">
  <div class="search_modal_gradient"></div>
  <div class="container modal_center">
    <div class="col-xxl-8 col-xl-8 col-sm-12">
      <div class="search_modal__inner">
        <form action="<?php echo esc_url(home_url('/')); ?>" class="search_modal__form">
          <div class="position-relative search_modal__i">
            <input type="text" class="search_modal_input" name="s" value="<?php echo get_search_query(); ?>" placeholder="<?php _e('دنبال چیز خاصی می‌گردید؟', 'kelaketfilm'); ?>">
            <button aria-label="<?php _e('جستجو', 'kelaketfilm'); ?>" class="search_modal_submit"><i class="fa fa-search"></i></button>
          </div>
          <span id="close_search_modal"><?php _e('بستن', 'kelaketfilm') ?></span>
        </form>
      </div>
      <div class="search_modal_result">
        <div id="datafetch2"></div>
        <section class="s_trends">
          <h3><?php _e('ترندها', 'kelaketfilm'); ?></h3>
          <ul>
            <?php 
            $trends = get_trends(10);
            foreach($trends as $trend):?>
              <li data-value="<?= $trend['title']; ?>">
                <i class="fa-light fa-search"></i>
                <?php echo htmlspecialchars( $trend['title'] ); ?>
                <?php 
                if ( current_user_can( 'manage_options' ) ) {?>
                  <button data-text="<?php echo htmlspecialchars( $trend['title'] ); ?>" class="remove_trend_btn"><i class="fa fa-x"></i></button>
                <?php } ?>
              </li>
            <?php endforeach;?>
          </ul>
        </section>
      </div>
    </div>
  </div>
</div>