  <main class="body_panel">
    <h2><?php _e('ارسال تیکت', 'kelaketfilm') ?></h2>
    <div class="row">
      <div class="col-xx-12">
      
        <div class="acc_info_  mt-0 mb-3">
          <div class="acc_info_body">
          <?php
            global $wpdb;
            $tablename = $wpdb->prefix . 'kelaket_tickets';
            $message_table = $wpdb->prefix . 'kelaket_tickets_msg';
            $user_id = get_current_user_id();

            if(isset($_POST['send_ticket'])){
              $val = new Validation();

              $val->name('عنوان تیکت')->value($_POST['subject'])->min(3)->required();
              $val->name('توضیحات')->value($_POST['msg'])->min(5)->required();
              $val->name('دپارتمان')->value($_POST['dep'])->required();
              
              if($val->isSuccess()){
                //validation passed save record in db
                $subject = sanitize_text_field($_POST['subject']);
                $msg = sanitize_textarea_field($_POST['msg']);
                $dep = sanitize_text_field($_POST['dep']);

                $res = $wpdb->insert($tablename, array(
                  'subject' => $subject,
                  'status' => 1,
                  'department' => $dep,
                  'user_id' => $user_id,
                  'created_at' => current_time('Y-m-d H:i:s'),
                ));
                $lastid = $wpdb->insert_id;

                $msg_query = $wpdb->insert($message_table, array(
                  'ticket_id' => $lastid,
                  'msg' => $msg,
                  'user_id' => $user_id,
                  'created_at' => current_time('Y-m-d H:i:s'),
                ));
  
                if($res && $msg_query){
                  wp_redirect(get_site_url()."/panel?action=tickets&msg=1");
                }

              }else{
                echo $val->displayErrors();
              }
            }
            $is_active_subscribe = rcp_user_has_active_membership(get_current_user_id());
            $ticket_for_vip = get_option('my_framework')['tickets_vip'];
            if(!($ticket_for_vip) || $is_active_subscribe):
            ?>
            <form action="<?php bloginfo('url') ?>/panel?action=add_ticket" method="post" class="send_ticket_form">
              <div class="d-flex gap-3">
                <p class="flex-1">
                  <label for="subject"><?php _e('عنوان تیکت', 'kelaketfilm') ?></label>
                  <input name="subject" class="text rcp-input" type="text" value="<?php echo isset( $_POST['subject'] ) ? $_POST['subject'] : '' ?>">
                </p>
                <p class="flex-1">
                  <label for="dep"><?php _e('دپارتمان', 'kelaketfilm') ?></label>
                  <select style="height: 45px; margin: 5px 0px;" name="dep" id="dep">
                    <option value="" disabled selected><?php _e('انتخاب کنید', 'kelaketfilm') ?></option>
                    <?php
                    $deps = get_option('my_framework')['ticket_dep'];

                    if($deps): foreach($deps as $dep): ?>
                    <option value="<?php echo $dep['ticket_dep_id']; ?>"><?php echo $dep['ticket_dep_name']; ?></option>
                    <?php endforeach;endif; ?>
                  </select>
                </p>
              </div>
              <p>
                <label for="msg"><?php _e('توضیحات', 'kelaketfilm') ?></label>
                <textarea style="height: 200px;line-height: 1.7;padding: 10px;text-indent: 0;" name="msg" class="text rcp-input" type="text"><?php echo isset( $_POST['msg'] ) ? $_POST['msg'] : '' ?></textarea>
              </p>
              <p>
              <input name="send_ticket" type="submit" class="rcp_submit rcp-button_list" value="<?php _e('ارسال تیکت', 'kelaketfilm') ?>">
              </p>
            </form>
            <?php else: ?>
              <div class="rcp_error text-center"><?php _e('فقط کاربران دارای اشتراک فعال می‌توانند تیکت ارسال کنند.', 'kelaketfilm') ?></div>
            <?php endif; ?>
          </div>
        </div>
      </div>

  </main>