  <main class="body_panel">
    <h2><?php _e('ساخت لیست جدید', 'kelaketfilm') ?></h2>
    <p class="mb-0">در این قسمت می‌توانید اطلاعات موردنیاز برای سات لیست جدید را واردکنید.</p>

    <div class="row">
      <div class="col-xx-12">
        <div class="acc_info_">
          <header>
            <h3><?php _e('ساخت لیست جدید', 'kelaketfilm') ?></h3>
          </header>
          <div class="container acc_info_body">
            <div class="row">
              <?php
              $error = null;
              global $wpdb;
              $tablename = $wpdb->prefix . 'kelaket_lists';
              if($_POST){
                // var_dump($_POST);
                // check nonce
                if(!wp_verify_nonce($_POST['create_list_nonce'], 'create_list')){
                  die('به دلیل مسائل امنیتی امکان ساخت لیست وجود ندارد.');
                }else{
                  // create list
                  if(!empty($_POST['list_name']) && isset($_POST['list_desc'])){
                    
                    $list_name = sanitize_text_field($_POST['list_name']);
                    $list_desc = sanitize_text_field($_POST['list_desc']);
                    $user_id = get_current_user_id();

                    if(strlen($list_name) <= 5){
                      $error = "<div class='px-3 pb-3'><div class='rcp_error'>".__('نام لیست باید بالای ۵ کاراکتر باشد', 'kelaketfilm')."</div></div>";
                    }else{
                      //insert
                      
                      $res = $wpdb->insert($tablename, array(
                        'name' => $list_name,
                        'list_desc' => $list_desc,
                        'user_id' => $user_id,
                        'films' => '',
                        'created_at' => current_time('Y-m-d H:i:s'),
                    ));

                    $last_id = $wpdb->insert_id;

                    if($res){
                      // reditect to next step
                      wp_redirect(get_site_url()."/panel?action=edit_list_item&id=$last_id");
                    }
                    
                    }
                  }else{
                    $error = "<div class='px-3 pb-3'><div class='rcp_error'>".__('وارد کردن نام لیست الزامی میباشد.', 'kelaketfilm')."</div></div>";
                  }
                }
              }

              if($error){
                echo $error;
              }
              ?>
              <form class="rcp_form" action="<?php bloginfo('url') ?>/panel?action=create_list" method="post">
                <fieldset>
                  <legend><?php _e('نام لیست', 'kelaketfilm') ?></legend>
                  <p>
                    <label for="list_name"><?php _e('نام لیست', 'kelaketfilm') ?></label>
                    <input name="list_name" class="text rcp-input" type="text" value="<?php echo isset($_POST['list_name']) ? $_POST['list_name'] : ''  ?>">
                  </p>
                  <p>
                    <label for="list_desc"><?php _e('توضیحات لیست', 'kelaketfilm') ?></label>
                    <input name="list_desc" class="text rcp-input" type="text" value="<?php echo isset($_POST['list_desc']) ? $_POST['list_desc'] : '' ?>">
                  </p>
                </fieldset>
                <fieldset>
                  <p id="rcp_profile_submit_wrap">
                    <input type="hidden" name="create_list_nonce" value="<?php echo wp_create_nonce('create_list') ?>">
                    <input name="rcp_profile_editor_submit" type="submit" class="rcp_submit rcp-button_list" value="<?php _e('مرحله بعد', 'kelaketfilm') ?>">
                  </p>
                </fieldset>
              </form>
            </div>
          </div>
        </div>
      </div>

  </main>