  <main class="body_panel">
    <div class="row">
      <?php if (theme_options('vip')) : ?>
        <div class="col-xxl-3 col-xl-3 col-lg-6 col-md-6">
          <div class="info">
            <div class="icon_wrap blue_gradient icon_wrap">
              <i class="fa fa-gem"></i>
            </div>
            <div class="info_detail">
              <div class="title"><?php _e('وضعیت اشتراک', 'kelaketfilm') ?></div>
              <?php
              if (function_exists('rcp_get_status')) {
                $status = rcp_get_status(get_current_user_id());
                switch ($status) {
                  case 'expired':
                    echo '<span>' . __('به اتمام رسیده', 'kelaketfilm') . '</span>';
                    break;
                  case 'active':
                    echo '<span>' . __('فعال', 'kelaketfilm') . '</span>';
                    break;
                  case 'cancelled':
                    echo '<span>' . __('لغو شده', 'kelaketfilm') . '</span>';
                    break;
                  case 'pending':
                    echo '<span>' . __('در انتظار تایید', 'kelaketfilm') . '</span>';
                    break;
                  default:
                    echo '<span>' . __('بدون اشتراک', 'kelaketfilm') . '</span>';
                    break;
                }
              }
              ?>
            </div>
          </div>
        </div>
      <?php endif; ?>
      <?php if (theme_options('vip')) : ?>
        <div class="col-xxl-3 col-xl-3 col-lg-6 col-md-6">
          <div class="info">
            <div class="icon_wrap pink_gradient icon_wrap">
              <i class="fa fa-calendar-circle-exclamation"></i>
            </div>
            <div class="info_detail">
              <div class="title"><?php _e('تاریخ انقضا اشتراک', 'kelaketfilm') ?></div>
              <?php if (function_exists('rcp_get_expiration_date')) : ?>
                <span><?php echo kelaket_get_user_expiration() ? wp_date('d M Y',kelaket_get_user_expiration()) : '-';?>
                </span>
              <?php endif; ?>
            </div>
          </div>
        </div>
      <?php endif; ?>


      <?php if( theme_options('vip') == false ): ?>
        <div class="col-xxl-3 col-xl-3 col-lg-6 col-md-6">
        <div class="info">
          <div class="icon_wrap yellow_gradient icon_wrap">
            <i class="fa fa-ticket-simple"></i>
          </div>
          <div class="info_detail">
            <div class="title"><?php _e('تیکت های منتظر پاسخ', 'kelaketfilm') ?></div>
            <span><?php echo tickets_count(1, get_current_user_id()); ?></span>
          </div>
        </div>
      </div>
      <?php endif; ?>

      <?php if( theme_options('vip') == false ): ?>
        <div class="col-xxl-3 col-xl-3 col-lg-6 col-md-6">
        <div class="info">
          <div class="icon_wrap green_gradient icon_wrap">
            <i class="fa fa-ticket-simple"></i>
          </div>
          <div class="info_detail">
            <div class="title"><?php _e('تیکت های پاسخ داده شده', 'kelaketfilm') ?></div>
            <span><?php echo tickets_count(2, get_current_user_id()); ?></span>
          </div>
        </div>
      </div>
      <?php endif; ?>

      <div class="col-xxl-3 col-xl-3 col-lg-6 col-md-6">
        <div class="info">
          <div class="icon_wrap db_gradinet icon_wrap">
            <i class="fa fa-list"></i>
          </div>
          <div class="info_detail">
            <div class="title"><?php _e('لیست تماشا', 'kelaketfilm') ?></div>
            <?php
            $list = get_user_meta(get_current_user_id(), 'favorites_list', true);
            if (!is_array($list) || empty($list)) {
              $list = [];
            }
            ?>
            <span><?php echo count($list); ?></span>
          </div>
        </div>
      </div>

      <div class="col-xxl-3 col-xl-3 col-lg-6 col-md-6">
        <div class="info">
          <div class="icon_wrap yellow_gradient icon_wrap">
            <i class="fa fa-comments"></i>
          </div>
          <div class="info_detail">
            <div class="title"><?php _e('دیدگاه های شما', 'kelaketfilm') ?></div>
            <span>
              <?php
              echo get_comments(array('user_id' => get_current_user_id(), 'count' => true));
              ?>
            </span>
          </div>
        </div>
      </div>

      <div class="col-lg-6">
        <div class="acc_info">
          <header>
            <h3><?php _e('اطلاعات کلی', 'kelaketfilm') ?></h3>
          </header>
          <ul>
            <li>
              <span class="detail_1"><?php _e('نام و نام خانوادگی', 'kelaketfilm') ?></span>
              <span class="detail_2">

                <?php
                $current_user = wp_get_current_user();
                echo get_user_meta(get_current_user_id(), 'first_name', true); ?>
                <?php echo get_user_meta(get_current_user_id(), 'last_name', true); ?>
              </span>
            </li>
            <li>
              <span class="detail_1"><?php _e('نام کاربری', 'kelaketfilm') ?></span>
              <span class="detail_2"><?php echo $current_user->nickname; ?></span>
            </li>
            <li>
              <span class="detail_1"><?php _e('ایمیل', 'kelaketfilm') ?></span>
              <span class="detail_2"><?php echo $current_user->user_email; ?></span>
            </li>
            <li>
              <span class="detail_1"><?php _e('تاریخ عضویت', 'kelaketfilm') ?></span>
              <span class="detail_2"><?php echo wp_date('d M Y',strtotime($current_user->user_registered)); ?></span>
            </li>
            <li>
              <span class="detail_1"><?php _e('آدرس IP شما', 'kelaketfilm') ?></span>
              <span class="detail_2"><?php echo $_SERVER['REMOTE_ADDR']; ?></span>
            </li>
          </ul>
        </div>
      </div>

      <div class="col-lg-6">
        <div class="acc_info dashboard_ticket">
          <header>
            <h3><?php _e('وضعیت تیکت ها', 'kelaketfilm') ?></h3>
          </header>
          <div class="dashboard_ticket__body">
            <?php
            global $wpdb;
            $tablename = $wpdb->prefix . 'kelaket_tickets';
            $user_id = get_current_user_id();
            $query = "
              SELECT * 
              FROM $tablename
              WHERE user_id = $user_id
              ORDER BY created_at DESC
              LIMIT 10
            ";

            $res = $wpdb->get_results($query);
            
            if($res):
            foreach ($res as $key => $value):?>
              <div class="dashboard_ticket__item">
                <div class="dashboard_ticket__item--hover">
                  <a href="<?php bloginfo('url') ?>/panel?action=show_ticket&id=<?php echo $value->id ?>"><?php _e('نمایش تیکت', 'kelaketfilm') ?></a>
                </div><!-- /.dashboard_ticket__item--hover -->
                <strong style="width: 50%;">
                  <?php echo $value->subject; ?>
                </strong>
                <span>
                <?php echo wp_date('d M Y', strtotime($value->created_at)); ?>
                </span>
                <span>
                <?php if ($value->status == 1) : ?>
                  <span class="table_badge"><?php _e('در انتظار پاسخ', 'kelaketfilm') ?></span>
                <?php elseif ($value->status == 2) : ?>
                  <span class="table_badge green"><?php _e('پاسخ داده شده', 'kelaketfilm') ?></span>
                <?php elseif ($value->status == 3) : ?>
                  <span class="table_badge red"><?php _e('بسته شده', 'kelaketfilm') ?></span>
                <?php elseif ($value->status == 4) : ?>
                <span class="table_badge blue"><?php _e('درحال بررسی', 'kelaketfilm') ?></span>
                <?php endif; ?>
                </span>
              </div><!-- /.dashboard_ticket__item -->
            <?php
            endforeach;
          else:?>
            <div class="panel_notfound text-center p-3">
              <img src="<?php echo get_template_directory_uri() ?>/images/ticket_notfound.png">
              <h3><?php _e('شما تیکتی ندارید.', 'kelaketfilm') ?></h3>
              <p><?php _e('درصورتی که نیاز به پشتیبانی دارید تیکت ارسال کنید.', 'kelaketfilm') ?></p>
            </div>
          <?php endif; ?>
          </div><!-- /.dashboard_ticket_body -->
        </div><!-- /.dashboard_ticket -->
      </div>


      <div class="col-lg-12">
        <div class="acc_info dashboard_watchlist mt-1">
          <header class="d-flex justify-content-between">
            <h3><?php _e('لیست تماشای شما', 'kelaketfilm') ?></h3>

            <a class="show_more_panel" href="<?php bloginfo('url') ?>/panel?action=watchlist">
              <?php _e('مشاهده کامل', 'kelaketfilm'); ?>
              <i class="fa fa-chevron-left"></i>
            </a>
          </header>
          <div class="dashboard_watchlist__body">
            <div class="owl-carousel film_cat_carousel_panel">
              <?php
              $favorites_list = get_user_meta(get_current_user_id(), 'favorites_list', true);
              $not_found = false;
              if( is_array( $favorites_list ) && !empty( $favorites_list )){
                $favorites_list = array_reverse( $favorites_list );
              }

              $args = array(
                'post__in' => $favorites_list,
                'orderby' => 'post__in',
                'post_status' => 'publish',
                'post_type' => 'post',
                'showposts' => 20,
                'order' => 'ASC',
                // 'orderby' => 'date',
              );

              $query = new WP_Query($args);
              if ($query->found_posts) {
                while ($query->have_posts()) {
                  $query->the_post();
                  if(theme_options('film_card_style') == 'style1'):
                    get_template_part('/inc/template_parts/cards/film_card');
                  elseif(theme_options('film_card_style') == 'style2'):
                    get_template_part('/inc/template_parts/cards/film_card2');
                    elseif(theme_options('film_card_style') == 'style3'):
                      get_template_part('/inc/template_parts/cards/film_card3');
                  endif;
                }
              }else{
                $not_found = true;
              }
              wp_reset_postdata();?>
              
            </div><!-- /.film_cat_carousel_big -->
            <?php
            if( $not_found == true ):?>
              <div class="panel_notfound text-center p-3 w-100">
                <img class="mb-3" src="<?php echo get_template_directory_uri() ?>/images/req_notfound.png">
                <h3><?php _e('لیست تماشا خالی میباشد.', 'kelaketfilm') ?></h3>
                <p><?php _e('فیلم هایی که بعدا میخواهید تماشا کنید به این لیست اضافه کنید.', 'kelaketfilm') ?></p>
              </div>
            <?php endif; ?>
          </div><!-- /.dashboard_watchlist__body -->
        </div><!-- /.dashboard_ticket -->
      </div>

  </main>