<div class="col-xxl-8 col-xl-8 col-lg-8 col-md-8 col-sm-8 col-xs-12">
  <main class="body_panel">
    <h2><?php _e('ویرایش لیست', 'kelaketfilm') ?></h2>
    <p class="mb-0"><?php _e('لیست ساخته شده را ویرایش کنید.', 'kelaketfilm') ?></p>

    <div class="row">
      <div class="col-xx-12">
        <div class="acc_info_">
          <header>
            <h3><?php _e('ویرایش لیست', 'kelaketfilm') ?></h3>
          </header>
          <div class="container acc_info_body">
            <div class="row">
              <?php
              global $wpdb;
              $tablename = $wpdb->prefix . 'kelaket_lists';
              $user_id = get_current_user_id();
              $error = null;

              // check list_id
              if(isset($_GET['id']) && !empty($_GET['id'])){
                $list_id = (int) $_GET['id'];
                // check list belogns to current user
                if(!checkListBelongToUser($user_id, $list_id)){
                  wp_redirect(get_site_url()."/404");
                }
                
                $query = " 
                  SELECT * 
                  FROM $tablename
                  WHERE user_id = $user_id AND id = $list_id LIMIT 1
                ";  
                  
                $res = $wpdb->get_results($query);

                if($res){
                  $list_name = $res[0]->name;
                  $list_desc = $res[0]->list_desc;
                }
                
              }
              if($_POST){
                // var_dump($_POST);
                // check nonce
                if(!wp_verify_nonce($_POST['edit_list_nonce'], 'edit_list')){
                  die('به دلیل مسائل امنیتی امکان ویرایش لیست وجود ندارد.');
                }else{
                  // edit list
                  if(!empty($_POST['list_name']) && isset($_POST['list_desc'])){
                    
                    $list_name_new = sanitize_text_field($_POST['list_name']);
                    $list_desc_new = sanitize_text_field($_POST['list_desc']);

                    if(strlen($list_name_new) <= 5){
                      $error = "<div class='px-3 pb-3'><div class='rcp_error'>".__('نام لیست باید بالای ۵ کاراکتر باشد', 'kelaketfilm')."</div></div>";
                    }else{
                      //edit list
                      $update = $wpdb->update($tablename, array(
                        'name' => $list_name_new,
                        'list_desc' => $list_desc_new,
                        'updated_at' => current_time('Y-m-d H:i:s')
                      ),
                        array('id'=>$list_id)
                      );

                      if($update){
                         wp_redirect(get_site_url()."/panel?action=lists");
                      }
                    }
                  }else{
                    $error = "<div class='px-3 pb-3'><div class='rcp_error'>".__('وارد کردن نام الزامی است', 'kelaketfilm')."</div></div>";
                  }
                }
              }

              if($error){
                echo $error;
              }
              ?>
              <form class="rcp_form" action="<?php bloginfo('url') ?>/panel?action=edit_list&id=<?php echo $list_id ?>" method="post">
                <fieldset>
                  <legend><?php _e('نام لیست', 'kelaketfilm') ?></legend>
                  <p>
                    <label for="list_name"><?php _e('نام لیست', 'kelaketfilm') ?></label>
                    <input name="list_name" class="text rcp-input" type="text" value="<?php echo isset($_POST['list_name']) ? $_POST['list_name'] : $list_name  ?>">
                  </p>
                  <p>
                    <label for="list_desc"><?php _e('توضیحات لیست', 'kelaketfilm') ?></label>
                    <textarea style="height: auto" name="list_desc" class="text rcp-input" type="text" cols="5" rows="3"><?php echo isset($_POST['list_desc']) ? $_POST['list_desc'] : $list_desc ?></textarea>
                  </p>
                </fieldset>
                <fieldset>
                  <p id="rcp_profile_submit_wrap">
                    <input type="hidden" name="edit_list_nonce" value="<?php echo wp_create_nonce('edit_list') ?>">
                    <input name="rcp_profile_editor_submit" type="submit" class="rcp_submit rcp-button_list" value="<?php _e('ویرایش لیست', 'kelaketfilm') ?>">
                  </p>
                </fieldset>
              </form>
            </div>
          </div>
        </div>
      </div>

  </main>
</div>