  <main class="body_panel">
    <h2><?php _e('ویرایش فیلم های لیست', 'kelaketfilm') ?></h2>

    <div class="row">
      <div class="col-xx-12">
        <div class="acc_info_">
          <header>
            <h3><?php _e('ویرایش فیلم های لیست', 'kelaketfilm') ?></h3>
          </header>
          <div class="container acc_info_body">
            <div class="row">
              <?php
              global $wpdb;
              $tablename = $wpdb->prefix . 'kelaket_lists';
              $user_id = get_current_user_id();
              $error = null;

              // check list_id
              if(isset($_GET['id']) && !empty($_GET['id'])){
                $list_id = (int) $_GET['id'];
                // check list belogns to current user
                if(!checkListBelongToUser($user_id, $list_id)){
                  wp_redirect(get_site_url()."/404");
                }
                
                $query = " 
                  SELECT * 
                  FROM $tablename
                  WHERE user_id = $user_id AND id = $list_id LIMIT 1
                ";  
                  
                $res = $wpdb->get_results($query);

                if($res){
                  $list_name = $res[0]->name;
                  $list_desc = $res[0]->list_desc;
                  $list_films = explode(',', $res[0]->films);
                  if($res[0]->is_private){
                    $private = true;
                  }else{
                    $private = false;
                  }
                }

              }
              if($_POST){
                // check nonce
                if(!wp_verify_nonce($_POST['edit_list_nonce'], 'edit_list')){
                  die('به دلیل مسائل امنیتی امکان ویرایش لیست وجود ندارد.');
                }else{
                  // edit list
                  if(!empty($_POST['list_name']) && isset($_POST['list_desc'])){
                    
                    $list_name_new = sanitize_text_field($_POST['list_name']);
                    $list_desc_new = sanitize_text_field($_POST['list_desc']);
                    if(isset($_POST['ids'])){
                      $list_films_new = $_POST['ids'];
                    }else{
                      $list_films_new = [];
                    }
                    $private = false;
                    if(isset($_POST['private']) && $_POST['private'] == 'on'){
                      $private = true;
                    }

                    if(is_array($list_films_new)){
                      $list_films_string = implode(',', $list_films_new);
                    }

                    if(strlen($list_name_new) <= 5){
                      $error = "<div class='px-3 pb-3'><div class='rcp_error'>".__('نام لیست باید بالای ۵ کاراکتر باشد', 'kelaketfilm')."</div></div>";
                    }else{
                      //edit list
                      $update = $wpdb->update($tablename, array(
                        'name' => $list_name_new,
                        'list_desc' => $list_desc_new,
                        'films' => $list_films_string, 
                        'is_private' => $private,
                        'updated_at' => current_time('Y-m-d H:i:s')
                      ),
                        array('id'=>$list_id)
                      );

                      if($update){
                         wp_redirect(get_site_url()."/panel?action=edit_list_item&id=$list_id");
                      }
                    }
                  }else{
                    $error = "<div class='px-3 pb-3'><div class='rcp_error'>".__('وارد کردن نام الزامی است', 'kelaketfilm')."</div></div>";
                  }
                }
              }

              if($error){
                echo $error;
              }
              ?>
              <form class="rcp_form" action="<?php bloginfo('url') ?>/panel?action=edit_list_item&id=<?php echo $list_id ?>" method="post">
                <fieldset>
                  <legend><?php _e('نام لیست', 'kelaketfilm') ?></legend>
                  <p>
                    <label for="list_name"><?php _e('نام لیست', 'kelaketfilm') ?></label>
                    <input name="list_name" class="text rcp-input" type="text" value="<?php echo isset($_POST['list_name']) ? $_POST['list_name'] : $list_name  ?>">
                  </p>
                  <p>
                    <label for="list_desc"><?php _e('توضیحات لیست', 'kelaketfilm') ?></label>
                    <textarea style="height: auto" name="list_desc" class="text rcp-input" type="text" cols="5" rows="3"><?php echo isset($_POST['list_desc']) ? $_POST['list_desc'] : $list_desc ?></textarea>
                  </p>
                  <p class="mb-0">
                    <label for="list_desc"><?php _e(' لیست خصوصی', 'kelaketfilm') ?><small class="small_custom"> <?php _e(' درصورت فعال سازی لیست برای کاربران نمایش داده نمی‌شود. ', 'kelaketfilm') ?></small></label>
                    <div style="width: 60px">
                      <label class="switch">
                        <input type="checkbox" <?php echo $private ? 'checked' : '' ?> name="private">
                        <span class="slider_ round"></span>
                      </label>
                    </div>
                  </p>
                </fieldset>
                <fieldset>
                  <p class="mb-0">
                  <label><?php _e('فیلم های این لیست', 'kelaketfilm') ?></label>
                  </p>
                  
                <ul class="panel_film_sort" id="sortable">
                  <?php
                  if(is_array($list_films) && !empty($list_films[0])): foreach($list_films as $index => $item): ?>
                  <li id="p_<?php echo $item ?>" class="listItem ui-state-default d-flex">
                    <figure>
                      <img width="100" height="100" src="<?php echo get_the_post_thumbnail_url($item,'post_retina') ?>">
                    </figure>
                    <div class="ps-2 d-flex align-items-start flex-grow-1">
                      <div class="d-flex align-items-center">
                        <div class="sort_id"><?php echo $index+1; ?></div>
                        <a href="<?php echo get_the_permalink($item) ?>"><h2><?php echo get_the_title($item) ?></h2></a>
                      </div>
                      <input class="ids" type="hidden" value="<?php echo $item ?>" name="ids[]">
                    </div>
                    <button type="button" class="remove_film_item">
                      <i class="fa fa-x"></i>
                    </button>
                  </li>
                  <?php endforeach; else: echo "<span class='no_data'>".__('هیچ فیلمی در لیست وجود ندارد اولین فیلم خود را اضافه کنید.', 'kelaketfilm')."</span>";endif; ?>
                </ul>
                </fieldset>
                <fieldset>
                <p>
                  <?php _e('ابتدا نام فیلم مورد نطر را در فیلد وارد کنید سپس دکمه جستجو را انتخاب نمایید تا عملیات جستجو انجام شود.', 'kelaketfilm'); ?>
                </p>
                  <div class="film_search">
                    <div class="flex-grow-1 me-2 position-relative">
                      <input type="text" class="w-100" id="panel_search_keyword" name="ajax_films" placeholder="<?php _e('عنوان فیلم', 'kelaketfilm') ?>">
                      <div class="search_fetch_data position-absolute"><?php _e('صبرکنید', 'kelaketfilm') ?></div>
                    </div>
                    <button id="search_film_panel" type="button"><?php _e('جستجو', 'kelaketfilm') ?></button>
                  </div>
                </fieldset>
                <fieldset>
                  <p id="rcp_profile_submit_wrap">
                    <input type="hidden" name="edit_list_nonce" value="<?php echo wp_create_nonce('edit_list') ?>">
                    <input name="edit_film_list_item" type="submit" class="rcp_submit rcp-button_list" value="<?php _e('ذخیره', 'kelaketfilm') ?>">
                  </p>
                </fieldset>
              </form>

              
            </div>
          </div>
        </div>
      </div>

      <div class="films_template" style="display:none!important">
        <li class="listItem ui-state-default d-flex">
          <figure>
            <img width="100" height="100" src="<?php echo get_the_post_thumbnail_url($item,'post_retina') ?>">
          </figure>
          <div class="ps-2 d-flex align-items-start flex-grow-1">
            <div class="d-flex align-items-center">
              <div class="sort_id"><?php echo $index+1; ?></div>
              <a href="<?php echo get_the_permalink($item) ?>"><h2><?php echo get_the_title($item) ?></h2></a>
            </div>
            <input class="ids" type="hidden" value="<?php echo $item ?>" name="ids[]">
          </div>
          <button type="button" class="remove_film_item">
            <i class="bi bi-x-lg"></i>
          </button>
        </li>
      </div>

  </main>
