  <main class="body_panel">
    <h2><?php _e('ویرایش اطلاعات', 'kelaketfilm'); ?></h2>
    <div class="row">
      <div class="col-xx-12">
        <div class="acc_info_">
          <header>
            <h3><?php _e('ویرایش اطلاعات کاربری', 'kelaketfilm'); ?></h3>
          </header>
          <div class="acc_info_body">
            <?php if (isset($_GET['msg']) && $_GET['msg'] == 'wrong_number') : ?>
              <div class="rcp_error mb-3">
                <?php _e('شماره موبایل وارد شده صحیح نمی باشد.', 'kelaketfilm'); ?>
              </div>
            <?php endif; ?>
            <?php if (isset($_GET['msg']) && $_GET['msg'] == 'phone_exists') : ?>
              <div class="rcp_error mb-3">
                <?php _e('شماره موبایل وارد شده از قبل در سیستم موجود می‌باشد.', 'kelaketfilm'); ?>
              </div>
            <?php endif; ?>

            <?php if (isset($_GET['msg']) && $_GET['msg'] == 'user_updated') : ?>
              <div class="rcp_success mb-3">
                <?php _e('اطلاعات کاربری بروزرسانی شد.', 'kelaketfilm'); ?>
              </div>
            <?php endif; ?>

            <?php 
            $user_id      = get_current_user_id();
            $current_user = wp_get_current_user();
            $first_name   = get_user_meta($user_id, 'first_name', true);
            $last_name    = get_user_meta($user_id, 'last_name', true);
            $display_name = $current_user->display_name;

            if(isset($_POST['edit_profile'])){
              $update_password = false;
              if( !empty($_POST['kelaket_edit_nonce']) && isset($_POST['kelaket_edit_nonce']) ){
                $nonce = sanitize_text_field( $_POST['kelaket_edit_nonce'] );
              }
              if( !empty($_POST['rcp_email']) && isset($_POST['rcp_email']) ){
                $email = sanitize_email( $_POST['rcp_email'] );
              }
              // if( !empty($_POST['rcp_phone']) && isset($_POST['rcp_phone']) ){
              //   $phone = sanitize_text_field( $_POST['rcp_phone'] );
              // }

              if( ! empty( $_POST['rcp_mobile'] )) {
                if(preg_match("/^09[0-9]{9}$/", $_POST['rcp_mobile'])){
                  // check phone number not exists then save it
                  $users = get_users(['meta_key' => 'phone', 'meta_value' => $_POST['rcp_mobile'], 'number' => 1, 'count_total' => false])[0];
                  if($users && $users->id !== $user_id){
                    $redirect = add_query_arg( 'msg', 'phone_exists', $_SERVER['HTTP_REFERER'] );
                    wp_redirect($redirect);
                    exit();
                  }else{
                    update_user_meta( $user_id, 'phone', sanitize_text_field( $_POST['rcp_mobile'] ) );
                  }
                }else{
                  $redirect = add_query_arg( 'msg', 'wrong_number', $_SERVER['HTTP_REFERER'] );
                  wp_redirect($redirect);
                  exit();
                }
              }


              if( !empty($_POST['rcp_new_user_pass1']) && isset($_POST['rcp_new_user_pass1']) ){
                $pass1 = sanitize_text_field( $_POST['rcp_new_user_pass1'] );
              }
              if( !empty($_POST['rcp_new_user_pass2']) && isset($_POST['rcp_new_user_pass2']) ){
                $pass2 = sanitize_text_field( $_POST['rcp_new_user_pass2'] );
              }
              if( !empty($_POST['rcp_first_name']) && isset($_POST['rcp_first_name']) ){
                $fname = sanitize_text_field( $_POST['rcp_first_name'] );
              }
              if( !empty($_POST['rcp_last_name']) && isset($_POST['rcp_last_name']) ){
                $lname = sanitize_text_field( $_POST['rcp_last_name'] );
              }
              // check password field filled 
              if($pass1 && $pass2){
                if($pass1 <> $pass2){?>
                  <div class="rcp_error mb-3">
                    <?php _e('رمز عبور و تایید آن یکسان نیستند!', 'kelaketfilm'); ?>
                  </div>
                <?php }elseif(strlen($pass1) < 6){?>
                  <div class="rcp_error mb-3">
                  <?php _e('رمز عبور قوی تری انتخاب کنید.', 'kelaketfilm'); ?>
                  </div>
                <?php }else{
                  // set update password to true
                  $update_password = true;
                }
              }

              // update user data
              $user_data = wp_update_user(array(
                  'ID' => $user_id,
                  'user_email' => $email,
                  'user_pass' => $pass1
                )
              );

              update_user_meta( $user_id, 'first_name', sanitize_text_field( $fname ) );
              update_user_meta( $user_id, 'last_name', sanitize_text_field( $lname ) );


              if ( is_wp_error( $user_data ) ) {
                // There was an error; possibly this user doesn't exist.
                echo 'مشکلی پیش آمد.';
              } else {
                $redirect = add_query_arg( 'msg', 'user_updated', $_SERVER['HTTP_REFERER'] );
                wp_redirect($redirect);
              }

            }
            ?>
            <form action="<?php echo $_SERVER['REQUEST_URI']; ?>" method="post">
              
              <div class="col-lg-7 mx-auto py-4">
                <fieldset class="row">
                  <div class="col-sm-6">
                    <?php do_action('rcp_profile_editor_before', $current_user->ID); ?>
                    <p>
                      <label for="rcp_email"><?php _e('ایمیل', 'kelaketfilm'); ?></label>
                      <input name="rcp_email" id="rcp_email" class="text rcp-input required" type="email" value="<?php echo esc_attr($current_user->user_email); ?>" />
                    </p>
                  </div>
                  <div class="col-sm-6">
                    <?php do_action('rcp_profile_editor_after', $current_user->ID); ?>
                  </div>
                </fieldset>

                <fieldset class="row">
                  <div class="col-sm-6">
                    <p id="rcp_profile_password_wrap">
                      <label for="rcp_user_pass"><?php _e('رمز عبور جدید', 'kelaketfilm'); ?></label>
                      <input name="rcp_new_user_pass1" id="rcp_new_user_pass1" class="password rcp-input" type="password" />
                    </p>
                  </div>
                  <div class="col-sm-6">
                    <p id="rcp_profile_password_confirm_wrap">
                      <label for="rcp_user_pass"><?php _e('تکرار رمز عبور', 'kelaketfilm'); ?></label>
                      <input name="rcp_new_user_pass2" id="rcp_new_user_pass2" class="password rcp-input" type="password" />
                    </p>
                  </div>
                  <div class="col-auto">
                    <p class="profiel_edit_info"><?php _e('اگر می‌خواهید رمز عبور خود را تغییر دهید رمز عبور جدید را در فیلد بالا وارد کنید.', 'kelaketfilm'); ?></p>
                  </div>
                </fieldset>

                <fieldset class="row">
                  <div class="col-sm-6">
                    <p id="rcp_profile_first_name_wrap">
                      <label for="rcp_first_name"><?php _e('نام', 'kelaketfilm'); ?></label>
                      <input name="rcp_first_name" id="rcp_first_name" class="text rcp-input" type="text" value="<?php echo esc_attr($first_name); ?>" />
                    </p>
                  </div>
                  <div class="col-sm-6">
                    <p id="rcp_profile_last_name_wrap">
                      <label for="rcp_last_name"><?php _e('نام خانوادگی', 'kelaketfilm'); ?></label>
                      <input name="rcp_last_name" id="rcp_last_name" class="text rcp-input" type="text" value="<?php echo esc_attr($last_name); ?>" />
                    </p>
                  </div>
                </fieldset>

                <fieldset class="row">
                  <div class="col-auto">
                    <input type="hidden" name="kelaket_edit_nonce" value="<?php echo wp_create_nonce('edit_profile') ?>">
                    <input name="edit_profile" id="rcp_profile_editor_submit" type="submit" class="rcp_submit rcp-button m-0 w-auto" value="<?php esc_attr_e('ذخیره تغییرات', 'kelaketfilm'); ?>" />
                  </div>
                </fieldset>

              </div>
            </form>
            <?php //echo do_shortcode('[rcp_profile_editor]'); 
            ?>
          </div>
        </div>
      </div>

  </main>