  <main class="body_panel">
    <h2><?php _e('درخواست فیلم و سریال', 'kelaketfilm') ?></h2>
    <div class="row">
      <div class="col-xx-12">
      <?php
      global $wpdb;
      $tablename = $wpdb->prefix . 'kelaket_reqs';
      $user_id = get_current_user_id();
      if(isset($_POST['req_submit'])){
        if(isset($_POST['film_name'])){
          $film_name = sanitize_text_field($_POST['film_name']);
          if(isset($_POST['type'])){
            $req_type = sanitize_text_field($_POST['type']);
            if(!empty($film_name) && !empty($req_type)){
              //save request in db
              if($req_type == 'movie'){
                $req_type = 1;
              }elseif($req_type == 'series'){
                $req_type = 2;
              }
              
              $res = $wpdb->insert($tablename, array(
                'name' => $film_name,
                'type' => $req_type,
                'user_id' => $user_id,
                'created_at' => current_time('Y-m-d H:i:s'),
              ));

              if($res){
                wp_redirect(get_site_url()."/panel?action=req&msg=1");
              }
            }
          }
        }
      }
      ?>
        <div class="acc_info_  mt-0 mb-3">
          <div class="acc_info_body">
            <?php if(isset($_GET['msg'])){
              $msg = $_GET['msg'];
              if($msg == 1){
                echo "<div class='rcp_success mb-4'>".__('درخواست با موفقیت ثبت شد! وضعیت درخواست خود را از همین صفحه می‌توانید پیگیری کنید.', 'kelaketfilm')."</div>";
              }elseif($msg == 2){
                echo "<div class='rcp_error mb-4'>".__('مشکلی پیش آمد دوباره تلاش کنید.', 'kelaketfilm')."</div>";
              }
            } ?>
            <form action="<?php bloginfo('url') ?>/panel?action=req" method="post" class="request_film_form">
              <p>
                <label for="film_name"><?php _e('نام فیلم و سریال', 'kelaketfilm') ?></label>
                <input required name="film_name" class="text rcp-input" type="text" value="">
              </p>
              <div class="mb-0 req_heading">
                <label for="type"><?php _e('انتخاب دسته بندی', 'kelaketfilm') ?></label>
                <div class="req_type_wrap">
                  <span class="active" data-value="movie"><?php _e('فیلم', 'kelaketfilm') ?></span>
                  <span class="" data-value="series"><?php _e('سریال', 'kelaketfilm') ?></span>
                  <input id="req_type" type="hidden" name="type" value="movie">
                </div>
              </div>
              <p>
              <input name="req_submit" type="submit" class="rcp_submit rcp-button_list" value="<?php _e('ارسال درخواست', 'kelaketfilm') ?>">
              </p>
            </form>
          </div>
        </div>

        <h2 class="mt-4 d-block"><?php _e('درخواست های شما', 'kelaketfilm') ?></h2>
        <div class="acc_info_ mt-0 mb-3">
          <div class="acc_info_body">
          <?php
                $tablename = $wpdb->prefix . 'kelaket_reqs';
                $user_id = get_current_user_id();

                $query = " 
                  SELECT * 
                  FROM $tablename
                  WHERE user_id = $user_id
                  ORDER BY created_at DESC
                ";  
                  
                $res = $wpdb->get_results($query);
                if($res):
               ?>
              <table class="rcp-table" id="rcp-payment-history">
                <thead>
                  <tr>
                    <th><?php _e('عنوان', 'kelaketfilm') ?></th>
                    <th><?php _e('نوع', 'kelaketfilm') ?></th>
                    <th><?php _e('تاریخ', 'kelaketfilm') ?></th>
                    <th><?php _e('وضعیت', 'kelaketfilm') ?></th>
                    <th><?php _e('پیام', 'kelaketfilm') ?></th>
                  </tr>
                </thead>
                <tbody>
                  <?php
                  foreach($res as $index => $list):
                  ?>
                  <tr>
                    <td>
                      <?php echo $list->name; ?>
                    </td>
                    <td><?php echo $list->type == 1 ? __('فیلم', 'kelaketfilm') : __('سریال', 'kelaketfilm') ?></td>
                    <td><?php echo wp_date('d M Y', strtotime($list->created_at)); ?></td>
                    <td>
                      <?php if($list->status == 1): ?>
                      <span class="table_badge"><?php _e('درحال بررسی', 'kelaketfilm') ?></span>
                      <?php elseif($list->status == 2): ?>
                      <span class="table_badge green"><?php _e('تایید شد', 'kelaketfilm') ?></span>
                      <?php elseif($list->status == 3): ?>
                      <span class="table_badge red"><?php _e('رد شد', 'kelaketfilm') ?></span>
                      <?php endif; ?>
                    </td>
                    <td>
                      <?php
                      if($list->msg){
                        echo $list->msg;
                      }else{
                         _e('پیغامی نیست!', 'kelaketfilm');
                      }
                      ?>
                    </td>
                  </tr>
                  <?php endforeach; ?>
                </tbody>
              </table>
              <?php else: ?>
                <div class="panel_notfound text-center p-3">
                <img class="mb-3" src="<?php echo get_template_directory_uri() ?>/images/req_notfound.png">
                <h3><?php _e('شما درخواستی ندارید!', 'kelaketfilm') ?></h3>
                <p><?php _e('اگر فیلم یا سریالی در سایت موجود نبود درخواست دهید تا در سایت قرار گیرد.', 'kelaketfilm') ?></p>
              </div>
              <?php endif; ?>
          </div>
        </div>
      </div>

  </main>