  <main class="body_panel">
    <div class="row">
      <div class="col-xx-12">
        <?php
        if (isset($_GET['id']) && !empty($_GET['id'])) {
          $ticket_id = (int) $_GET['id'];
          $user_id = get_current_user_id();
        } else {
          die('دسترسی غیرمجاز');
        }
        
        global $wpdb;
        $table_name = $wpdb->prefix . 'kelaket_tickets';
        $msg_table = $wpdb->prefix . 'kelaket_tickets_msg';

        // save message when sent by use
        if(isset($_POST['send_msg']) && !empty($_POST['msg'])){
          $msg = $_POST['msg'];
          $insert_query = $wpdb->insert($msg_table, array(
            'msg' => $msg,
            'ticket_id' => $ticket_id,
            'user_id' => $user_id,
            'created_at' => current_time('Y-m-d H:i:s'),
          ));
          $update = $wpdb->update($table_name, array(
            'status' => 1, 
          ),
            array('id'=>$ticket_id)
          );
          if($insert_query && $update){
            wp_redirect(get_site_url()."/panel?action=show_ticket&id=$ticket_id");
          }
        }

        $query = " 
          SELECT * 
          FROM $table_name
          WHERE user_id = $user_id AND id = $ticket_id LIMIT 1
        ";

        $msg_query = "
          SELECT * 
          FROM $msg_table
          WHERE ticket_id = $ticket_id
        ";


        $res = $wpdb->get_results($query);
        $msgs = $wpdb->get_results($msg_query);
        ?>
        <h2 class="mt-2 mb-3 d-block"><?php _e('تیکت', 'kelaketfilm') ?> <i class="fa-solid fa-chevron-left"></i> <?php echo $res[0]->subject ?></h2>
        <div class="acc_info_ mt-0 mb-3">
          <div class="acc_info_body">
            <?php
            if ($res[0]) :
            ?>
              <div class="ticket_info mb-3">
                <div>
                  <i class="fa fa-calendar-check"></i>
                  <?php _e('تاریخ: ', 'kelaketfilm') ?> 
                  <?php echo wp_date('d M Y - H:i', strtotime($res[0]->created_at)) ?>
                </div>
                <div>
                  <i class="fa fa-grid"></i>
                  <?php _e('دپارتمان: ', 'kelaketfilm') ?>
                  <?php
                  echo get_dep_name($res[0]->department);
                  ?>
                </div>
              </div>
              <?php foreach($msgs as $msg): 
                  $admin = $msg->reply_id ? true : false;
                ?>
              <div class="ticket_msg mb-2 d-flex <?php echo $admin ? 'reply_support' : '' ?>">
                <?php echo get_avatar($msg->user_id, 50); ?>
                
                <div class="ticket_msg_box">
                  <?php echo nl2br( htmlspecialchars( $msg->msg ) ); ?>
                  <div class="ticket_msg_info d-flex align-items-center justify-content-between">
                  <span><?php 
                  $time = strtotime($msg->created_at);
                  $current_time = current_time('U');
                  echo human_time_diff($time, $current_time) .' '. __('پیش', 'kelaketfilm');
                  ?></span>
                  <span>
                    <?php 
                      $user = get_userdata($msg->user_id);
                      echo htmlspecialchars( $user->display_name ); 
                    ?>
                  </span>
                  </div>
                </div>
              </div>
              <?php endforeach; ?>

              <?php if($res[0]->status != 3): ?>
              <form method="post" action="<?php bloginfo('url') ?>/panel?action=show_ticket&id=<?php echo $ticket_id; ?> " class="ticket_send_form">
                <textarea name="msg" class="rcp-input" id="msg" placeholder="<?php _e('پیام شما', 'kelaketfilm') ?>"></textarea>
                <button type="submit" name="send_msg"><i class="fa fa-paper-plane-top"></i> <?php _e('ارسال پیام', 'kelaketfilm') ?></button>
              </form>
              <?php else: ?>
              <div class="rcp_error mt-4 text-center"><?php _e('تیکت بسته شده است! امکان ارسال پاسخ وجود ندارد.', 'kelaketfilm') ?></div>
              <?php endif; ?>
            <?php else : wp_redirect(site_url().'/404') ?>
            <?php endif; ?>
          </div>
        </div>
      </div>

  </main>