  <main class="body_panel">
    <div class="row">
      <div class="col-xxl-3 col-xl-3 col-lg-6 col-md-6">
        <div class="info">
          <div class="icon_wrap yellow_gradient icon_wrap">
            <i class="fa fa-ticket-simple"></i>
          </div>
          <div class="info_detail">
            <div class="title"><?php _e('تیکت های منتظر پاسخ', 'kelaketfilm') ?></div>
            <span><?php echo tickets_count(1, get_current_user_id()); ?></span>
          </div>
        </div>
      </div>

    <div class="col-xxl-3 col-xl-3 col-lg-6 col-md-6">
      <div class="info">
        <div class="icon_wrap green_gradient icon_wrap">
          <i class="fa fa-ticket-simple"></i>
        </div>
        <div class="info_detail">
          <div class="title"><?php _e('تیکت های پاسخ داده شده', 'kelaketfilm') ?></div>
          <span><?php echo tickets_count(2, get_current_user_id()); ?></span>
        </div>
      </div>
    </div>

    <div class="col-xxl-3 col-xl-3 col-lg-6 col-md-6">
      <div class="info">
        <div class="icon_wrap blue_gradient icon_wrap">
          <i class="fa fa-ticket-simple"></i>
        </div>
        <div class="info_detail">
          <div class="title"><?php _e('تیکت های درحال بررسی', 'kelaketfilm') ?></div>
          <span><?php echo tickets_count(4, get_current_user_id()); ?></span>
        </div>
      </div>
    </div>

    <div class="col-xxl-3 col-xl-3 col-lg-6 col-md-6">
      <div class="info">
        <div class="icon_wrap pink_gradient icon_wrap">
          <i class="fa fa-ticket-simple"></i>
        </div>
        <div class="info_detail">
          <div class="title"><?php _e('تیکت های بسته شده', 'kelaketfilm') ?></div>
          <span><?php echo tickets_count(3, get_current_user_id()); ?></span>
        </div>
      </div>
    </div>

    </div> <!-- ./row -->

    <div class="row">
      <div class="col-xx-12">
        <?php
        global $wpdb;
        $tablename = $wpdb->prefix . 'kelaket_tickets';
        $user_id = get_current_user_id();
        if (isset($_POST['req_submit'])) {
          if (isset($_POST['film_name'])) {
            $film_name = sanitize_text_field($_POST['film_name']);
            if (isset($_POST['type'])) {
              $req_type = sanitize_text_field($_POST['type']);
              if (!empty($film_name) && !empty($req_type)) {
                //save request in db
                if ($req_type == 'movie') {
                  $req_type = 1;
                } elseif ($req_type == 'series') {
                  $req_type = 2;
                }

                $res = $wpdb->insert($tablename, array(
                  'name' => $film_name,
                  'type' => $req_type,
                  'user_id' => $user_id,
                  'created_at' => current_time('Y-m-d H:i:s'),
                ));

                if ($res) {
                  wp_redirect(get_site_url() . "/panel?action=req&msg=1");
                }
              }
            }
          }
        }
        ?>
        <h2 class="mt-2 mb-3 d-block"><?php _e('تیکت های شما', 'kelaketfilm') ?></h2>
        <div class="acc_info_ mt-0 mb-3">
          <div class="acc_info_body">
            <?php
            $query = " 
                  SELECT * 
                  FROM $tablename
                  WHERE user_id = $user_id
                  ORDER BY created_at DESC
                ";

            $res = $wpdb->get_results($query);
            if ($res) :
            ?>
              <table class="rcp-table" id="rcp-payment-history">
                <thead>
                  <tr>
                    <th><?php _e('عنوان', 'kelaketfilm') ?></th>
                    <th><?php _e('وضعیت', 'kelaketfilm') ?></th>
                    <th><?php _e('دپارتمان', 'kelaketfilm') ?></th>
                    <th><?php _e('تاریخ', 'kelaketfilm') ?></th>
                    <th><?php _e('عملیات', 'kelaketfilm') ?></th>
                  </tr>
                </thead>
                <tbody>
                  <?php
                  foreach ($res as $index => $list) :
                  ?>
                    <tr>
                      <td>
                        <?php echo $list->subject; ?>
                      </td>
                      <td>
                        <?php if ($list->status == 1) : ?>
                          <span class="table_badge"><?php _e('در انتظار پاسخ', 'kelaketfilm') ?></span>
                        <?php elseif ($list->status == 2) : ?>
                          <span class="table_badge green"><?php _e('پاسخ داده شده', 'kelaketfilm') ?></span>
                        <?php elseif ($list->status == 3) : ?>
                          <span class="table_badge red"><?php _e('بسته شده', 'kelaketfilm') ?></span>
                        <?php elseif ($list->status == 4) : ?>
                        <span class="table_badge blue"><?php _e('درحال بررسی', 'kelaketfilm') ?></span>
                        <?php endif; ?>
                      </td>
                      <td><?php echo get_dep_name($list->department); ?> </td>
                      <td><?php echo wp_date('d M Y - H:i:s', strtotime($list->created_at)); ?></td>
                      <td>
                        <a href="<?php bloginfo('url') ?>/panel?action=show_ticket&id=<?php echo $list->id ?>"><?php _e('نمایش', 'kelaketfilm') ?></a>
                      </td>
                    </tr>
                  <?php endforeach; ?>
                </tbody>
              </table>
            <?php else : ?>
              <div class="panel_notfound text-center p-3">
                <img src="<?php echo get_template_directory_uri() ?>/images/ticket_notfound.png">
                <h3><?php _e('شما تیکتی ندارید.', 'kelaketfilm') ?></h3>
                <p><?php _e('درصورتی که نیاز به پشتیبانی دارید تیکت ارسال کنید.', 'kelaketfilm') ?></p>
              </div>
            <?php endif; ?>
          </div>
        </div>
      </div>

  </main>