<?php
$config = get_option('my_framework');
?>
<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-xs-12 col-xxl-12">

  <?php if( theme_options('show_updated_serial') ): ?>
  <div class="cat_title mb-3">
    <h3 class="star_title_c title1">
      <?php _e('سریال های بروز شده', 'kelaketfilm') ?>
      <span><?php _e('جدید ترین سریال های بروز شده سایت', 'kelaketfilm') ?></span>
    </h3>
  </div>
  <div class="row">
    <?php 
    $query = new WP_Query(array(
      'post_type' => 'post',
      'meta_key' => 'post-type',
      'meta_value' => 'series',
      'posts_per_page' => 8,
      'orderby' => 'modified',
      'no_found_rows' => true, // speed up query when we don't need pagination
    ));
    if ($query->have_posts()) :
      while ($query->have_posts()) : $query->the_post();
      get_template_part('inc/template_parts/cards/serial_card');
    ?>
    <?php endwhile; endif; ?>
  </div>
  <?php endif; ?>

  <?php
  foreach ($config['film_cat_home'] as $item) { 
    if($item['film_cat_item__style']): //bigger header style?>
    <div class="row">
      <div class="col-lg-2 col-md-3 col-sm-3 big_cat_title">
        <div class="cat_title mb-1">
          <h3 class="star_title_c title1"><?php echo $item['film_cat_item_title'] ? $item['film_cat_item_title'] : get_cat_name($item['film_cat_item']); ?></h3>
          <div class="cat_title_badge"><?php echo $item['film_cat_item_sub_title'] ?></div>
          <a class="cat_title_more" href="<?php echo get_category_link($item['film_cat_item']); ?>">
          <?php _e('مشاهده بیشتر', 'kelaketfilm'); ?> <i class="fa-regular fa-chevron-left"></i>
          </a>
          <div class="icon"><i class="fa fa-film-alt"></i></div>
        </div>
      </div>
      <div class="col-lg-10 col-md-9 col-sm-9">
        <div class="owl-carousel film_cat_carousel_big">
          <?php
          $args = array(
            'post_type' => 'post',
            'posts_per_page' => $item['film_cat_item_count'],
            'offset' => '0',
            'cat' => $item['film_cat_item'],
            'order' => 'DESC',
            'orderby' => theme_options('updated_first') ? 'modified' : 'date',
          );

          $query = new WP_Query($args);
          if ($query->found_posts) {
            while ($query->have_posts()) {
              $query->the_post();
              if(theme_options('film_card_style') == 'style1'):
                get_template_part('/inc/template_parts/cards/film_card');
              elseif(theme_options('film_card_style') == 'style2'):
                get_template_part('/inc/template_parts/cards/film_card2');
              elseif(theme_options('film_card_style') == 'style3'):
                  get_template_part('/inc/template_parts/cards/film_card3');
              endif;
            }
          }
          wp_reset_postdata();
          ?>
        </div>
      </div>
    </div>
    <?php else: ?>
    <div class="row">
      <div class="cat_title mb-1">
        <h3 class="star_title_c title1">
        <?php echo $item['film_cat_item_title'] ? $item['film_cat_item_title'] : get_cat_name($item['film_cat_item']); ?>
        </h3>
        <a class="cat_title_more" href="<?php echo get_category_link($item['film_cat_item']); ?>">
        <?php _e('مشاهده بیشتر', 'kelaketfilm'); ?> <i class="fa-regular fa-chevron-left"></i>
        </a>
      </div>
      <div class="owl-carousel film_cat_carousel">
        <?php
        $args = array(
          'post_type' => 'post',
          'posts_per_page' => $item['film_cat_item_count'],
          'offset' => '0',
          'cat' => $item['film_cat_item'],
          'order' => 'DESC',
          'orderby' => theme_options('updated_first') ? 'modified' : 'date',
        );

        $query = new WP_Query($args);
        if ($query->found_posts) {
          while ($query->have_posts()) {
            $query->the_post();
            if(theme_options('film_card_style') == 'style1'):
              get_template_part('/inc/template_parts/cards/film_card');
            elseif(theme_options('film_card_style') == 'style2'):
              get_template_part('/inc/template_parts/cards/film_card2');
            elseif(theme_options('film_card_style') == 'style3'):
                get_template_part('/inc/template_parts/cards/film_card3');
            endif;
          }
        }
        wp_reset_postdata();
        ?>
      </div>
    </div>
  <?php endif;  }   ?>


  <div class="home_blog mb-3">
    <?php 
    if(theme_options('blog_lastposts_index')){
      get_template_part('inc/template_parts/blog/latest_posts2', null, array( 'show_all_btn' => true ));
    }
    ?>
  </div>


  <?php if ($config['ads_beforePost']) : ?>
    <div class="_banner">
      <?= $config['ads_beforePost']; ?>
    </div>
  <?php endif; ?>
</div>