<?php //posts markup without loop 
$config = get_option('my_framework');

if(isset($_GET['style'])){
  $demo = $_GET['style'];

  if($demo == 1){
    $config['post_style'] = 'default';
  }elseif($demo == 2){
    $config['post_style'] = 'modern';
  }elseif($demo == 3){
    $config['post_style'] = 'minimal';
  }
}

if ($config['post_style'] == 'default') :
?>
  <article class="post">
    <div class="row">
      <div class="post_image col-xl-3 col-lg-4 col-md-4">
        <a href="<?php the_permalink() ?>">
          <div class="post_image--inner">
            <?php the_post_thumbnail('post_retina'); ?>
          </div>
        </a>
      </div>
      <div class="post_details col-xl-9 col-lg-8 col-md-8">
        <?php
        if (get_field('imdbRating')) { ?>
        <a target="_blank" href="https://www.imdb.com/title/<?php the_field('imdb') ?>">
          <div class="imdbRating_holder">
            <div class="imdb_num">
              <strong><?php the_field('imdbRating'); ?></strong>
              <small>/10</small>
              <span><?php echo formatVotes(get_field('imdbVotes')); ?> Votes</span>
            </div>
            <div class="imdbLogo">
              <img src="<?php echo get_template_directory_uri(); ?>/images/imdbt.svg" alt="">
            </div>
          </div>
        </a>
        <?php } ?>
        <div data-bs-toggle="tooltip" data-bs-placement="top" title="افزودن به لیست تماشا" class="simplefavorite-button stats -favorites">
          <span class="icon postFav-<?php echo $post->ID; ?> -click <?php echo is_favorite(get_current_user_id(), $post->ID) ? 'fa' : 'far' ?> fa-bookmark" data-js="favorite" data-favorite="<?php echo $post->ID; ?>" data-user="<?php echo get_current_user_id(); ?>"></span>
        </div>
        <h2>
          <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
          <?php if (get_field('legal')) : ?>
            <span class="legal"><i class="fa fa-check"></i> <?php _e("قانونی", "kelaketfilm") ?></span>
          <?php endif; ?>
          <?php if (get_field('censored')) : ?>
            <span class="censored"><i class="fa fa-check"></i> <?php _e("سانسور شده", "kelaketfilm") ?></span>
          <?php endif; ?>
        </h2>

        <ul class="post_meta">
          <li><strong><i class="fa-light fa-tv"></i><?php _e('کیفیت', 'kelaketfilm'); ?></strong> <?php the_field('quality-meta') ?></li>
          <li><strong><i class="fa-light fa-theater-masks"></i><?php _e('ژانر', 'kelaketfilm'); ?></strong> <?php echo get_the_term_list($post->ID, 'genre', '', '، ', '') ?></li>
          <li><strong><i class="fa-light fa-calendar-days"></i><?php _e('سال تولید', 'kelaketfilm'); ?></strong> <?php echo get_the_term_list($post->ID, 'yearr', '', '، ', '') ?></li>
          <li><strong><i class="fa-light fa-globe"></i><?php _e('محصول', 'kelaketfilm'); ?></strong> <?php echo get_the_term_list($post->ID, 'country', '', '، ', '') ?></li>
          <li><strong><i class="fa-light fa-stopwatch"></i><?php _e('مدت زمان', 'kelaketfilm'); ?></strong> <?php the_field('time') ?></li>
          <li><strong><i class="fa-light fa-language"></i><?php _e('زبان', 'kelaketfilm'); ?></strong> <?php the_field('Language') ?></li>
          <li><strong><i class="fa-light fa-users"></i><?php _e('بازیگران', 'kelaketfilm'); ?></strong> <?php echo get_the_term_list($post->ID, 'actor', '', '، ', '') ?></li>
          <li><strong><i class="fa-light fa-user-crown"></i><?php _e('کارگردان', 'kelaketfilm'); ?></strong> <?php echo get_the_term_list($post->ID, 'director', '', '، ', '') ?></li>
          
        </ul>
        <div class="about_box">
        <div class="badges_new">
        <?php if (get_field('legal')) : ?>
          <span class="badge_movie badge_blue">
            <i class="fa fa-hexagon-check"></i>
            <?php _e('دانلود قانونی', 'kelaketfilm'); ?>
          </span>
        <?php endif; ?>
        <?php if (get_field('censored')) : ?>
          <span class="badge_movie badge_cyan">
            <i class="fa fa-eye-slash"></i>
            <?php _e('سانسور شده', 'kelaketfilm'); ?>
          </span>
        <?php endif; ?>
        <?php if (get_field('persian-doble')) : ?>
          <span class="badge_movie badge_red">
            <i class="fa fa-microphone-lines"></i>
            <?php _e('دوبله فارسی', 'kelaketfilm'); ?>
          </span>
        <?php endif; ?>
        <?php if (get_field('def-version')) : ?>
          <span class="badge_movie badge_orange">
            <i class="fa fa-closed-captioning"></i>
            <?php _e('زیرنویس فارسی', 'kelaketfilm'); ?>
          </span>
        <?php endif; ?>
        <?php if (get_field('top-250-imdb')) : ?>
          <span class="badge_movie badge_yellow">
            <i class="fa fa-stars"></i>
            <?php _e('جزو ۲۵۰ فیلم برتر با رتبه', 'kelaketfilm'); ?>  <?php the_field('imdb_rank'); ?>
          </span>
        <?php endif; ?>
        <?php if (get_field('top-250-series')) : ?>
          <span class="badge_movie badge_yellow">
            <i class="fa fa-stars"></i>
            <?php _e('جزو ۲۵۰ سریال برتر با رتبه', 'kelaketfilm'); ?>  <?php the_field('series_imdb_rank'); ?>
          </span>
        <?php endif; ?>
        <?php if (get_field('custom-badge')) : ?>
          <span class="badge_movie badge_dark_blue">
            <i class="fa fa-grid-2"></i>
            <?php the_field('custom-badge'); ?>
          </span>
        <?php endif; ?>
      </div>

      </div>
      <div class="about_box">
      


        <?php if (get_field('story')) : ?> <p><?php the_field('story'); ?></p><?php endif; ?>
        
        <a href="<?php the_permalink(); ?>" class="post_download btn btn-outline-primary">
        <i class="fa fa-download"></i>
        <?php _e('دانلود', 'kelaketfilm') ?> 
        <?php 
        $type = get_the_terms( get_the_ID() , 'type_of_post');
        if( isset( $type[0] ) ){
          echo $type[0]->name;
        }
        ?>
        </a>
      </div>

    </div>
  </article>
<?php elseif ($config['post_style'] == 'modern') : ?>
  <article class="post2">
    <div class="post2_bg" style="background-image: url(<?php echo get_the_post_thumbnail_url(); ?>)"></div>
    <div class="row relz2">
      <div class="title">
        <h2>
          <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
        </h2>
      </div>

      <div class="post_details col-xl-9 col-lg-8 col-md-8 order-md-1 order-2">
      <ul class="post_meta">
        <?php if (get_field('update_info')) : ?>
          <li>
            <strong>
              <span class="icon"><i class="fa-light fa-rotate"></i></span>
              <?php _e('بروزرسانی', 'kelaketfilm'); ?></strong><i class="seprator"></i>
            <div class="post_meta--left"><?php the_field('update_info') ?></div>
          </li>
        <?php endif; ?>
        <?php if (get_the_term_list(get_the_ID(), 'genre', '', '، ', '')) : ?>
          <li><strong>
              <span class="icon"><i class="fa-light fa-theater-masks"></i></span>
              <?php _e('ژانر', 'kelaketfilm'); ?>
            </strong><i class="seprator"></i>
            <div class="post_meta--left"><?php echo get_the_term_list(get_the_ID(), 'genre', '', '، ', '') ?></div>
          </li>
        <?php endif; ?>
        <?php if (get_the_term_list(get_the_ID(), 'yearr', '', '، ', '')) : ?>
          <li><strong>
              <span class="icon"><i class="fa-light fa-calendar-days"></i> </span>
              <?php _e('سال تولید', 'kelaketfilm'); ?></strong><i class="seprator"></i>
            <div class="post_meta--left"><?php echo get_the_term_list(get_the_ID(), 'yearr', '', '، ', '') ?></div>
          </li>
        <?php endif; ?>
        <?php if (get_the_term_list(get_the_ID(), 'country', '', '، ', '')) : ?>
          <li><strong>
              <span class="icon"><i class="fa-light fa-globe"></i> </span>
              <?php _e('محصول', 'kelaketfilm'); ?></strong><i class="seprator"></i>
            <div class="post_meta--left"><?php echo get_the_term_list(get_the_ID(), 'country', '', '، ', '') ?></div>
          </li>
        <?php endif; ?>
        <?php if (get_field('time')) : ?>
          <li><strong>
              <span class="icon"><i class="fa-light fa-stopwatch"></i> </span>
              <?php _e('مدت زمان', 'kelaketfilm'); ?></strong><i class="seprator"></i>
            <div class="post_meta--left"><?php the_field('time') ?></div>
          </li>
        <?php endif; ?>
        <?php if (get_field('air_status')) : ?>
          <li><strong>
              <span class="icon"><i class="fa-light fa-screencast"></i> </span>
              <?php _e('وضعیت پخش', 'kelaketfilm'); ?></strong><i class="seprator"></i>
            <div class="post_meta--left"><?php the_field('air_status') ?></div>
          </li>
        <?php endif; ?>
        <?php if (get_field('Language')) : ?>
          <li><strong>
              <span class="icon"><i class="fa-light fa-language"></i> </span>
              <?php _e('زبان', 'kelaketfilm'); ?></strong><i class="seprator"></i>
            <div class="post_meta--left"><?php the_field('Language') ?></div>
          </li>
        <?php endif; ?>
        <?php if (get_field('quality-meta')) : ?>
          <li><strong>
              <span class="icon"><i class="fa-light fa-tv"></i> </span>
              <?php _e('کیفیت', 'kelaketfilm'); ?></strong><i class="seprator"></i>
            <div class="post_meta--left">
              <?php
              $quality = get_field('quality-meta');
              $quality = explode(',', $quality);
              foreach ($quality as $item) {
                echo '<span> ' . $item . ' </span>';
              }
              ?>
            </div>
          </li>
        <?php endif; ?>

        <?php if (get_the_term_list(get_the_ID(), 'actor', '', '، ', '')) : ?>
          <li><strong>
              <span class="icon"><i class="fa-light fa-users"></i> </span>
              <?php _e('بازیگران', 'kelaketfilm'); ?></strong><i class="seprator"></i>
            <div class="post_meta--left"><?php echo get_the_term_list(get_the_ID(), 'actor', '', '، ', '') ?></div>
          </li>
        <?php endif; ?>
        <?php if (get_the_term_list(get_the_ID(), 'director', '', '، ', '')) : ?>
          <li><strong>
              <span class="icon"><i class="fa-light fa-user-crown"></i></span>
              <?php _e('کارگردان', 'kelaketfilm'); ?></strong><i class="seprator"></i>
            <div class="post_meta--left"><?php echo get_the_term_list(get_the_ID(), 'director', '', '، ', '') ?></div>
          </li>
        <?php endif; ?>
        <li class="badges_new">
          <?php if (get_field('legal')) : ?>
            <span class="badge_movie badge_blue">
              <i class="fa fa-hexagon-check"></i>
              <?php _e('دانلود قانونی', 'kelaketfilm'); ?>
            </span>
          <?php endif; ?>
          <?php if (get_field('censored')) : ?>
            <span class="badge_movie badge_cyan">
              <i class="fa fa-eye-slash"></i>
              <?php _e('سانسور شده', 'kelaketfilm'); ?>
            </span>
          <?php endif; ?>
          <?php if (get_field('persian-doble')) : ?>
            <span class="badge_movie badge_red">
              <i class="fa fa-microphone-lines"></i>
              <?php _e('دوبله فارسی', 'kelaketfilm'); ?>
            </span>
          <?php endif; ?>
          <?php if (get_field('def-version')) : ?>
            <span class="badge_movie badge_orange">
              <i class="fa fa-closed-captioning"></i>
              <?php _e('زیرنویس فارسی', 'kelaketfilm'); ?>
            </span>
          <?php endif; ?>
          <?php if (get_field('top-250-imdb')) : ?>
            <span class="badge_movie badge_yellow">
              <i class="fa fa-stars"></i>
              <?php _e('جزو ۲۵۰ فیلم برتر با رتبه', 'kelaketfilm'); ?>  <?php the_field('imdb_rank'); ?>
            </span>
          <?php endif; ?>
          <?php if (get_field('top-250-series')) : ?>
            <span class="badge_movie badge_yellow">
              <i class="fa fa-stars"></i>
              <?php _e('جزو ۲۵۰ سریال برتر با رتبه', 'kelaketfilm'); ?>  <?php the_field('series_imdb_rank'); ?>
            </span>
          <?php endif; ?>
          <?php if (get_field('custom-badge')) : ?>
            <span class="badge_movie badge_dark_blue">
              <i class="fa fa-grid-2"></i>
              <?php the_field('custom-badge'); ?>
            </span>
          <?php endif; ?>
        </li>
        <li>
          <?php if (get_field('story')) : ?> <p><i class="fa-light fa-comment-dots"></i> <span class="story"><?php _e('خلاصه داستان:', 'kelaketfilm'); ?></span> <?php the_field('story'); ?></p><?php endif; ?>
        </li>
      </ul>
      </div>
      <div class="post_image col-xl-3 col-lg-4 col-md-4 order-1">
        <?php
        if (get_field('imdbRating')) { ?>
        <a target="_blank" href="https://www.imdb.com/title/<?php the_field('imdb') ?>">
          <div class="imdbRating_holder mb-4">
            <div class="imdbLogo">
              <img width="29" height="12" src="<?php echo get_template_directory_uri(); ?>/images/imdbt.svg" alt="">
            </div>
            <div class="imdbRate_nums">
              <strong><?php the_field('imdbRating'); ?></strong>
              <small>/10</small>
            </div>
          </div>
        </a>
        <?php } ?>
        <?php
        if (get_field('malRating')) { ?>
          <div class="imdbRating_holder mal_holder mb-4">
            <div class="imdbLogo">
              MAL
            </div>
            <div class="imdbRate_nums">
              <strong><?php the_field('malRating'); ?></strong>
              <small>/10</small>
            </div>
          </div>
        <?php } ?>
          <div class="post_image--inner text-center">
            <a href="<?php the_permalink() ?>">
              <?php if (get_field('playonline')) : ?>
                <span class="playonline_badge">
                  <i class="fa-solid fa-play-circle"></i>
                </span>
              <?php endif; ?>
              <?php the_post_thumbnail('post_retina'); ?>
            </a>

            <div data-bs-custom-class="panel-tooltip" data-bs-toggle="tooltip" data-bs-placement="top" title="<?php echo is_favorite(get_current_user_id(), get_the_ID()) ? __('حذف از لیست تماشا', 'kelaketfilm') : _e('افزودن به لیست تماشا', 'kelaketfilm') ?>" class="simplefavorite-button stats -favorites">
              <span class="icon postFav-<?php echo get_the_ID(); ?> -click <?php echo is_favorite(get_current_user_id(), get_the_ID()) ? 'fa' : 'far' ?> fa-bookmark" data-js="favorite" data-favorite="<?php echo get_the_ID(); ?>" data-user="<?php echo get_current_user_id(); ?>"></span>
            </div>
          </div>
      </div>
      <div class="about_box order-3">
        <div class="about_box--right">
          <a href="<?php the_permalink(); ?>" class="post_download">
          <?php _e('دانلود', 'kelaketfilm'); ?>
          <?php 
          $type = get_the_terms( get_the_ID() , 'type_of_post');
          if( isset( $type[0] ) ){
            echo $type[0]->name;
          }
          ?>
          <i class="fa fa-arrow-left"></i>
          </a>
        </div>
      </div>
    </div>
  </article>

<?php elseif ($config['post_style'] == 'minimal') : ?>
<div class="col-xxl-6 col-lg-6 col-md-12">
  <article class="post_minimal post2">
    <a href="<?php the_permalink(); ?>">
    <div style="background-image: url(<?php echo get_field('slider_image2') ? get_field('slider_image2')['url'] : get_the_post_thumbnail_url(); ?>)"  class="post_minimal_image">
      <?php the_post_thumbnail('post_retina'); ?>
      <div class="post_minimal__rs"></div>
      <div class="post_minimal__bs"></div>
    </div>
    </a>
    <div class="post_minimal_details">
      <a href="<?php the_permalink(); ?>">
        <h2><?php the_title(); ?></h2>
      </a>
      <?php if(get_field('story')): ?>
        <p><?php echo limited_excerpt(get_field('story'), 200) ?></p>
      <?php endif; ?>
      <ul class="post_minimal__badges">
        <?php if(get_field('imdbRating')): ?>
          <a target="_blank" href="https://www.imdb.com/title/<?php the_field('imdb') ?>">
          <li class="yellow">
            <i class="fa fa-star"></i>
            <span><?php the_field('imdbRating') ?></span>
          </li>
        </a>
        <?php endif; ?>
        <?php if(get_field('malRating')): ?>
        <li class="blue_mal">
          <i class="fa fa-star"></i>
          <span><?php the_field('malRating') ?></span>
        </li>
        <?php endif; ?>
        <?php if(get_field('persian-doble')): ?>
        <li class="orange">
          <i class="fa fa-microphone"></i>
          <span><?php _e('دوبله', 'kelaketfilm') ?></span>
        </li>
        <?php endif; ?>
        <?php if(get_field('def-version')): ?>
        <li class="cyan">
          <i class="fa fa-closed-captioning"></i>
          <span><?php _e('زیرنویس', 'kelaketfilm') ?></span>
        </li>
        <?php endif; ?>
        <?php if(get_field('legal')): ?>
        <li class="blue">
          <i class="fa fa-check-circle"></i>
          <span><?php _e('قانونی', 'kelaketfilm') ?></span>
        </li>
        <?php endif; ?>
        <?php if(get_field('censored')): ?>
        <li class="blue">
          <i class="fa fa-check-circle"></i>
          <span><?php _e('سانسور', 'kelaketfilm') ?></span>
        </li>
        <?php endif; ?>
        <?php if(get_field('playonline')): ?>
        <li class="red">
          <i class="fa fa-play-circle"></i>
          <span><?php _e('پخش آنلاین', 'kelaketfilm') ?></span>
        </li>
        <?php endif; ?>
      </ul>
      <a class="post_minimal_download" href="<?php the_permalink(); ?>">
      <?php _e('دانلود و تماشا', 'kelaketfilm') ?>
      <?php 
        $type = get_the_terms( get_the_ID() , 'type_of_post');
        if( isset( $type[0] ) ){
          echo $type[0]->name;
        }
        ?>
    </a>
    </div>
  </article>
</div>
<?php endif; ?>