<section class="series_week">
  <header class="series_week__header">
    <h3><i class="fa fa-calendar-days"></i> <?php _e('جدول پخش هفتگی', 'kelaketfilm'); ?></h3>
    <?php $todayEn = date('D'); ?>
    <ul>
      <li data-day="Sat" class="<?= $todayEn == 'Sat' ? 'active' : ''; ?>"><span><?php _e('شنبه', 'kelaketfilm'); ?></span></li>
      <li data-day="Sun" class="<?= $todayEn == 'Sun' ? 'active' : ''; ?>"><span><?php _e('یک‌شنبه', 'kelaketfilm'); ?></span></li>
      <li data-day="Mon" class="<?= $todayEn == 'Mon' ? 'active' : ''; ?>"><span><?php _e('دوشنبه', 'kelaketfilm'); ?></span></li>
      <li data-day="Tue" class="<?= $todayEn == 'Tue' ? 'active' : ''; ?>"><span><?php _e('سه‌شنبه', 'kelaketfilm'); ?></span></li>
      <li data-day="Wed" class="<?= $todayEn == 'Wed' ? 'active' : ''; ?>"><span><?php _e('چهارشنبه', 'kelaketfilm'); ?></span></li>
      <li data-day="Thu" class="<?= $todayEn == 'Thu' ? 'active' : ''; ?>"><span><?php _e('پنج‌شنبه', 'kelaketfilm'); ?></span></li>
      <li data-day="Fri" class="<?= $todayEn == 'Fri' ? 'active' : ''; ?>"><span><?php _e('جمعه', 'kelaketfilm'); ?></span></li>
    </ul>
  </header>
  <div class="series_inner">
    <div class="row">
      <?php
      $data = @theme_options('series_tabbed')[$todayEn];
      if ($data) :
        foreach ($data as $item) :
      ?>
          <div class="col-lg-4 col-md-6 col-sm-6">
            <div class="series_item">
              <a class="d-flex" href="<?php the_permalink($item); ?>">
                <img src="<?php echo get_the_post_thumbnail_url($item, 'thumbnail'); ?>" alt="<?php echo get_the_title($item); ?>">
                <div class="d-flex flex-column justify-content-between">
                  <div class="name"><?= get_the_title($item); ?></div>
                  <div class="update"><?php the_field('update_info', $item); ?></div>
                </div>
              </a>
            </div>
          </div>
        <?php endforeach;
      else : ?><span class="not_found"><i class="fa fa-info-circle"></i> <?php _e('در این روز سریالی پخش نمی‌شود.', 'kelaketfilm'); ?></span><?php endif; ?>
    </div>
  </div>
</section>