<section class="casual_single">
<div class="casual_single__bg" style="background-image: url(<?php echo get_field('slider_image2') ? get_field('slider_image2')['url'] : get_the_post_thumbnail_url(); ?>)"></div>
  <div class="single_hero">
    <div class="container">
      <div class="row g-0">
        <div class="col-lg-3 col-md-5 col-sm-7 col-9 center_image_mobile">
          <div class="single_cover">
            <div class="single_cover_wrap">
              <div class="single_cover_wrap_overlay">
                <?php if (get_field('def-version')) : ?>
                  <i title="<?php _e('دارای زیرنویس فارسی', 'kelaketfilm'); ?>" data-bs-custom-class="panel-tooltip" data-bs-custom-class="panel-tooltip" data-bs-toggle="tooltip" data-bs-placement="top" class="fa fa-closed-captioning meta_def"></i>
                <?php endif; ?>
                <?php if (get_field('persian-doble')) : ?>
                  <i title="<?php _e('دارای دوبله فارسی', 'kelaketfilm'); ?>" data-bs-custom-class="panel-tooltip" data-bs-custom-class="panel-tooltip" data-bs-toggle="tooltip" data-bs-placement="top"  class="fa-solid fa-microphone-lines meta_double"></i>
                <?php endif; ?>
                <?php if (get_field('censored')) : ?>
                  <i title="<?php _e('سانسور شده', 'kelaketfilm'); ?>" data-bs-custom-class="panel-tooltip" data-bs-custom-class="panel-tooltip" data-bs-toggle="tooltip" data-bs-placement="top"  class="fa-solid fa-eye-slash meta_custom"></i>
                <?php endif; ?>
              </div>
              <?php the_post_thumbnail('post-retina'); ?>
              <div data-bs-custom-class="panel-tooltip" data-bs-custom-class="panel-tooltip" data-bs-toggle="tooltip" data-bs-placement="top" title="<?php echo is_favorite(get_current_user_id(), get_the_ID()) ? __('حذف از لیست تماشا', 'kelaketfilm') : _e('افزودن به لیست تماشا', 'kelaketfilm') ?>" class="simplefavorite-button stats -favorites <?php echo is_favorite(get_current_user_id(), get_the_ID()) ? 'bg-danger' : '' ?>">
                <span class="icon postFav-<?php echo get_the_ID(); ?> -click <?php echo is_favorite(get_current_user_id(), get_the_ID()) ? 'fa' : 'far' ?> fa-bookmark" data-js="favorite" data-favorite="<?php echo get_the_ID(); ?>" data-user="<?php echo get_current_user_id(); ?>"></span>
              </div>
            </div>
          </div>
        </div>
        <div class="col-lg-6 col-md-7 col-sm-12">
          <h1>
            <?php the_title(); ?> 
            <?php if( get_field('released') ): ?>
              <small>(<?php the_field('released') ?>)</small>
            <?php endif; ?>
          </h1>

          <?php if( get_field('update_info') ): ?>
          <span class="post_update"><i class="fa fa-info-circle"></i><?php the_field('update_info'); ?></span>
          <?php endif; ?>

          <div class="post_genre">
            <?php if (get_the_term_list($post->ID, 'genre', '', '، ', '')) : ?>
              <?php echo get_the_term_list($post->ID, 'genre', '', ' ', '') ?>
            <?php endif; ?>
          </div>

          <div class="post_runtime">
            <i class="fa fa-clock"></i>
            <?php _e('مدت زمان', 'kelaketfilm') ?>:  <?php the_field('time') ?>

            <span style="margin-right: 10px;">
              <?php if (get_the_term_list($post->ID, 'country', '', '، ', '')) : ?>
                <?php _e('کشور', 'kelaketfilm') ?>:  
                <?php echo get_the_term_list($post->ID, 'country', '', '، ', '') ?>
              <?php endif; ?>
            </span>
          </div>

          <div class="post_story">
            <p><?php the_field('story') ?></p>
          </div>

          <div class="post_download_cta">
            <?php if (get_field('trailer')):?>
              <button data-bs-toggle="modal" data-bs-target="#trailerModal" class="play_trailer"><i class="fa fa-play"></i> <span> <?php _e('پخش تریلر', 'kelaketfilm') ?></span></button>
            <?php endif; ?>
            <button data-bs-toggle="modal" data-bs-target="#downloadModal" class="download"><i class="fa fa-download"></i> <span><?php _e('دانلود', 'kelaketfilm') ?></span></button>
          </div>

          <div class="post_vote">
            <button data-vote_system="<?php echo theme_options('post_like_system') ?>" data-postid="<?php echo get_the_ID() ?>" data-userid="<?php echo get_current_user_id() ?>" data-action="like" data-nonce="<?php echo wp_create_nonce('post_vote') ?>" class="post_vote_up">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                <path d="M88 192h-48C17.94 192 0 209.9 0 232v208C0 462.1 17.94 480 40 480h48C110.1 480 128 462.1 128 440v-208C128 209.9 110.1 192 88 192zM96 440C96 444.4 92.41 448 88 448h-48C35.59 448 32 444.4 32 440v-208C32 227.6 35.59 224 40 224h48C92.41 224 96 227.6 96 232V440zM512 221.5C512 187.6 484.4 160 450.5 160h-102.5c11.98-27.06 18.83-53.48 18.83-67.33C366.9 62.84 343.6 32 304.9 32c-41.22 0-50.7 29.11-59.12 54.81C218.1 171.1 160 184.8 160 208C160 217.1 167.5 224 176 224C180.1 224 184.2 222.4 187.3 219.3c52.68-53.04 67.02-56.11 88.81-122.5C285.3 68.95 288.2 64 304.9 64c20.66 0 29.94 16.77 29.94 28.67c0 10.09-8.891 43.95-26.62 75.48c-1.366 2.432-2.046 5.131-2.046 7.83C306.2 185.5 314 192 322.2 192h128.3C466.8 192 480 205.2 480 221.5c0 15.33-12.08 28.16-27.48 29.2c-8.462 .5813-14.91 7.649-14.91 15.96c0 12.19 12.06 12.86 12.06 30.63c0 14.14-10.11 26.3-24.03 28.89c-5.778 1.082-13.06 6.417-13.06 15.75c0 8.886 6.765 10.72 6.765 23.56c0 31.02-31.51 22.12-31.51 43.05c0 3.526 1.185 5.13 1.185 10.01C389 434.8 375.8 448 359.5 448H303.9c-82.01 0-108.3-64.02-127.9-64.02c-8.873 0-16 7.193-16 15.96C159.1 416.3 224.6 480 303.9 480h55.63c33.91 0 61.5-27.58 61.5-61.47c18.55-10.86 30.33-31 30.33-53.06c0-4.797-.5938-9.594-1.734-14.27c19.31-10.52 32.06-30.97 32.06-53.94c0-7.219-1.281-14.31-3.75-20.98C498.2 266.2 512 245.3 512 221.5z" />
              </svg>
              <?php if(theme_options('post_like_count')):
                $likes = get_post_meta(get_the_ID(), 'kelaket_likes', true);
                $dis_likes = get_post_meta(get_the_ID(), 'kelaket_dislikes', true);
              endif; ?>
            </button>
            
            <button data-vote_system="<?php echo theme_options('post_like_system') ?>" data-postid="<?php echo get_the_ID() ?>" data-userid="<?php echo get_current_user_id() ?>" data-action="dislike" data-nonce="<?php echo wp_create_nonce('post_vote') ?>" class="post_vote_down">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                <path d="M128 280v-208C128 49.94 110.1 32 88 32h-48C17.94 32 0 49.94 0 72v208C0 302.1 17.94 320 40 320h48C110.1 320 128 302.1 128 280zM96 280C96 284.4 92.41 288 88 288h-48C35.59 288 32 284.4 32 280v-208C32 67.59 35.59 64 40 64h48C92.41 64 96 67.59 96 72V280zM477.9 235.7c2.469-6.672 3.75-13.77 3.75-20.98c0-22.97-12.75-43.42-32.06-53.94c1.141-4.672 1.734-9.469 1.734-14.27c0-22.06-11.78-41.94-30.33-52.8C421 59.84 393.4 32 359.5 32H303.9c-77.41 0-143.9 63.11-143.9 80.07c0 8.767 7.133 15.96 16 15.96C195.8 128 222.2 64 303.9 64h55.63c16.27 0 29.5 13.22 29.5 29.47c0 4.826-1.185 6.491-1.185 10.01c0 20.94 31.51 12.09 31.51 43.05c0 12.84-6.765 14.68-6.765 23.56c0 9.347 7.255 14.66 13.06 15.75c13.92 2.594 24.03 14.75 24.03 28.89c0 17.77-12.06 18.45-12.06 30.63c0 8.314 6.443 15.38 14.91 15.96C467.9 262.4 480 275.2 480 290.5C480 306.8 466.8 320 450.5 320h-128.3c-8.273 0-15.1 6.658-15.1 16.01c0 2.699 .68 5.398 2.046 7.83c17.73 31.53 26.62 65.39 26.62 75.48C334.9 431.2 325.6 448 304.9 448c-16.7 0-19.66-4.953-28.78-32.78c-21.79-66.41-36.14-69.47-88.81-122.5C184.2 289.6 180.1 288 176 288C167.4 288 160 294.9 160 303.1c0 23.25 57.94 36.53 85.73 121.2C254.2 450.9 263.6 480 304.9 480c38.77 0 62.01-30.84 62.01-60.67c0-13.84-6.844-40.27-18.83-67.33h102.5C484.4 352 512 324.4 512 290.5C512 266.8 498.2 245.8 477.9 235.7z" />
              </svg>
            </button>


            <div class="vote_stats">
              <?php $post_votes = get_post_votes(get_the_ID()); ?>
              <div class="vote_stats_text">
                <?php _e('رضایت کاربران', 'kelaketfilm'); ?>
              </div>
              <span><?php echo $post_votes['percent']; ?>%</span>
              <small>(<?php echo $post_votes['totalVotes'] ?> <?php _e('رای', 'kelaketfilm') ?>)</small>
            </div>


            <div class="movie_meta">
              <?php
              if (get_field('imdbRating')): ?>
              <a target="_blank" href="https://www.imdb.com/title/<?php the_field('imdb') ?>">
                <div class="mixed_imdb d-flex flex-row">
                  <div class="imdbLogo">
                    <img width="29" height="12" src="<?php echo get_template_directory_uri(); ?>/images/imdbt.svg" alt="imdb">
                  </div>
                  <div class="imdbRate_nums_casual">
                    <strong><?php the_field('imdbRating'); ?></strong>
                    <small>/10</small>
                  </div>
                </div>
              </a>
              <?php endif; ?>

              <?php
              if (get_field('malRating')): ?>
                <div class="mixed_imdb mal_holder d-flex flex-row">
                  <div class="imdbLogo">
                    MAL
                  </div>
                  <div class="malRate_nums_casual">
                    <strong><?php the_field('malRating'); ?></strong>
                    <small>/10</small>
                  </div>
                </div>
              <?php endif; ?>

              <?php if (get_field('metacritic')) : ?>
                <div class="movie_score">
                  <?php the_field('metacritic') ?>
                  <img width="25" height="25" src="<?php echo get_template_directory_uri(); ?>/images/metacritic-icon.svg">
                </div>
              <?php endif; ?>

              <?php if (get_field('rotten')) : ?>
                <div class="movie_score">
                  <?php the_field('rotten') ?>%
                  <img width="25" height="25" src="<?php echo get_template_directory_uri(); ?>/images/rotten.svg">
                </div>
              <?php endif; ?>

            </div>
          </div>


          <div class="post_actor">
            <?php if( get_the_term_list($post->ID, 'actor', '', ' - ', '') ): ?>
            <div class="actor"><Span><?php _e('بازیگران', 'kelaketfilm') ?>: </Span>
              <?php echo get_the_term_list($post->ID, 'actor', '', ' - ', '') ?>
            </div>
            <?php endif; ?>
            <?php if( get_the_term_list($post->ID, 'director', '', ' - ', '') ): ?>
            <div class="actor"><Span><?php _e('کارگردان', 'kelaketfilm') ?>: </Span>
              <?php echo get_the_term_list($post->ID, 'director', '', ' - ', '') ?>
            </div>
            <?php endif; ?>
          </div>
          
        </div>
      </div>
    </div>
  </div>
</section>


<div class="container">
  <div class="row">
    <div class="related_films_title">
      <h4><?php _e('جزئیات و توضیحات', 'kelaketfilm') ?></h4>
    </div>

    <div class="col-xxl-12">
      <div class="post_content_single">
        <?php if (!empty(get_the_content())) : ?>
          <?php the_content(); ?>
        <?php endif; ?>
        <div class="awards">
          <ul>
            <?php if (get_field('Awards') && get_field('Awards') !== 'N/A') : ?><li><i class="fa fa-award"></i><strong><?php _e('جوایز', 'kelaketfilm') ?>: </strong><?php the_field('Awards') ?></li><?php endif; ?>
            <?php if (get_field('Language')) : ?><li><i class="fa fa-language"></i><strong><?php _e('زبان', 'kelaketfilm') ?>: </strong><?php the_field('Language') ?></li><?php endif; ?>
            <?php if (get_field('Writer') && get_field('Writer') !== 'N/A') : ?><li><i class="fa fa-pen"></i><strong><?php _e('نویسنده', 'kelaketfilm') ?>: </strong><?php the_field('Writer') ?></li><?php endif; ?>
          </ul>
        </div>
      </div>
    </div>

    <?php if($config['show_actors']): 
      $actors = get_field('actors');
      $director = get_field('director');
    ?>
    <div class="default_stars mb-3">
      
      <?php if($actors || $director): ?>
      <div class="stars_header mb-4">
        <h4>
          <i class="fa fa-star"></i>
          <?php _e('ستارگان', 'kelaketfilm'); ?>
        </h4>
      </div>
      <?php endif; ?>
      
      
      <div class="owl-carousel single_cast_default">
      <?php
      if ($actors) :
        foreach ($actors as $actor) :
      ?>
        <a href="<?php echo esc_url(get_term_link($actor)) ?>">
          <?php if (get_field('actor_image_link', $actor)) { ?>
            <img width="150" height="150" src="<?php echo get_field('actor_image_link', $actor) ?>" onerror="this.onerror=null; this.src='<?php echo get_template_directory_uri(); ?>/images/no_img.png';" alt="<?php echo $actor->name; ?>" title="<?php echo $actor->name; ?>" />
          <?php } else { ?>
            <img src="<?php echo get_template_directory_uri(); ?>/images/no_img.png" alt="no-image" />
          <?php } ?>
          <div class="stars_title">
            <?php echo $actor->name; ?>
            <div><small><?php _e("بازیگر", 'kelaketfilm') ?></small></div>
          </div>
        </a>
        <?php endforeach;
      endif;
      if ($director) :
        foreach ($director as $direct) :
        ?>
          <a href="<?php echo esc_url(get_term_link($direct)) ?>">
            <?php if (get_field('actor_image_link', $direct)) { ?>
              <img src="<?php echo get_field('actor_image_link', $direct) ?>" onerror="this.onerror=null; this.src='<?php echo get_template_directory_uri(); ?>/images/no_img.png';" alt="<?php echo $direct->name; ?>" title="<?php echo $direct->name; ?>" />
            <?php } else { ?>
              <img src="<?php echo get_template_directory_uri(); ?>/images/no_img.png" alt="no-image" />
            <?php } ?>
            <div class="stars_title">
              <?php echo $direct->name; ?>
              <div><small><?php _e("کارگردان", 'kelaketfilm') ?></small></div>
            </div>
          </a>
      <?php endforeach;
      endif; ?>
      </div>
    </div> <!-- # default stars -->
    <?php endif; ?>

    <?php if (get_field('gallery')) : ?>
      <div class="related_films_title">
        <i class="fa fa-images"></i>
        <h4><?php _e('گالری تصاویر', 'kelaketfilm'); ?></h4>
      </div>
      <section class="film_info">
        <div class="gallery row g-2">
          <?php foreach (get_field('gallery') as $item) : ?>
            <div class="col-xxl-2 col-xl-3 col-lg-3 col-md-3 col-sm-4 col-4">
              <a class="gallery_image" href="<?php echo $item; ?>">
                <img src="<?php echo $item; ?>" alt="<?php the_title(); ?>" />
                <div class="gallery_mask">
                  <i class="fa fa-arrow-down-left-and-arrow-up-right-to-center"></i>
                </div>
              </a>
            </div>
          <?php endforeach; ?>
        </div>
      </section>
    <?php endif; ?>

  </div>
</div>



<?php if (get_field('collection_id')) : ?>
  <div class="container">
    <section class="collection_content overflow-hidden position-relative single__content my-3 mb-4">
      <img class="position-absolute collection_mask" src="<?php echo get_the_post_thumbnail_url(); ?>)" />
      <div class="row align-items-center position-relative">
        <div class="col-xxl-3 col-xl-3 col-lg-4 col-sm-4">
          <div class="collection_title">
            <div class="from"><?php _e("از کالکشن", 'kelaketfilm') ?></div>
            <div class="name"><?= get_cat_name(get_field('collection_id')) ?></div>
            <a href="<?= get_category_link(get_field('collection_id')); ?>" class="btn btn-orange"><?php _e("مشاهده همه", 'kelaketfilm') ?></a>
          </div>
        </div>
        <div class="col-xxl-9 col-xl-9 col-lg-8 col-sm-8">
          <div class="row flex-row-reverse g-2">
            <!-- collction posts -->
            <?php
            $related = get_posts(array('numberposts' => 4, 'category__in' => get_field('collection_id')));
            if ($related) foreach ($related as $post) {
              setup_postdata($post); ?>
              <div class="col-xxl-3 col-xl-3 col-lg-3 col-md-3 col-sm-6 col-6">
                <div class="related_film_item">
                  <a href="<?php the_permalink() ?>">
                    <?php the_post_thumbnail('rel_item'); ?>
                    <h5><?php the_title(); ?></h5>
                    <div class="related_rotten">
                      <i class="bi bi-hand-thumbs-up"></i>
                      <?php
                      if (get_field('rotten')) {
                        the_field('rotten');
                      } else {
                        echo '۰';
                      }
                      ?>% <?php _e('رضایت', 'kelaketfilm'); ?>
                    </div>
                  </a>
                </div>
              </div>
            <?php }
            wp_reset_postdata(); ?>
            <!-- /END Collection posts -->
          </div>
        </div>
      </div>
    </section>
  </div>
<?php endif; ?>

<!-- lists -->
<?php
global $wpdb;
$tablename = $wpdb->prefix . 'kelaket_lists';
$post_id = get_the_ID();

$qry = "select * from $tablename WHERE is_private = false AND FIND_IN_SET($post_id, films) ORDER BY id DESC LIMIT 6";
$result = $wpdb->get_results($qry);
if ($result) :
?>
  <section class="related_films">
    <div class="container">
      <div class="row">
        <div class="related_films_title">
          <i class="fa fa-list"></i>
          <h4><?php _e("لیست های مرتبط با ", 'kelaketfilm') ?> <?php the_title(); ?></h4>
        </div>
        <div class="owl-carousel lists_carousel2">

          <?php
          foreach ($result as $item) :
            $user = get_user_by('id', $item->user_id);
            $films = explode(',', $item->films);
            if (empty($films[0])) {
              $count = 0;
            } else {
              $count = count($films);
            }
            // fix first image issue due the first index of array alwasy empty 
            if (!get_the_post_thumbnail_url($films[0], 'post_retina')) {
              $firstImage = get_template_directory_uri() . '/images/nocover.jpeg';
            } else {
              $firstImage = get_the_post_thumbnail_url($films[0], 'post_retina');
            }
          ?>
            <div class="">
              <div class="custom_list single_list">
                <a href="<?php echo site_url() . "/lists/$item->id" ?>">
                  <div class="custom_list_images">
                    <div>
                      <img src="<?php echo $firstImage ?>" alt="">
                      <img src="<?php echo checkIndexExists($films, 1) ?  get_the_post_thumbnail_url($films[1], 'post_retina') : get_template_directory_uri() . '/images/nocover.jpeg' ?>" alt="">
                    </div>
                    <div>
                      <img src="<?php echo checkIndexExists($films, 2) ? get_the_post_thumbnail_url($films[2], 'post_retina') : get_template_directory_uri() . '/images/nocover.jpeg' ?>" alt="">
                      <img src="<?php echo checkIndexExists($films, 3) ? get_the_post_thumbnail_url($films[3], 'post_retina') : get_template_directory_uri() . '/images/nocover.jpeg' ?>" alt="">
                    </div>
                  </div>
                </a>
                <h3>
                  <a data-bs-custom-class="panel-tooltip" data-bs-toggle='tooltip' data-bs-placement='top' title="<?php echo $item->name; ?>" class="list" href="<?php echo site_url() . "/lists/$item->id" ?>"><?php echo limited_excerpt($item->name, 20) ?></a>
                  توسط
                  <a class="author" href="<?php echo bloginfo('url') . '/profile/' . $user->user_login;  ?>"><?php echo $user->display_name; ?></a>
                </h3>
                <div class="custom_list_meta">
                  <span><?php _e("تعداد:", 'kelaketfilm') ?> <?php echo $count; ?></span>
                  <?php
                  //check if post updated show date as tooltip
                  if ($item->updated_at == '0000-00-00 00:00:00') {
                    $update = "";
                  } else {
                    $update = __("آخرین بروزرسانی:", 'kelaketfilm') . mysql2date(' F j, Y', $item->updated_at);
                  }
                  ?>
                  <span data-bs-toggle='tooltip' data-bs-placement='top' title="<?php echo $update; ?>"><?php echo  mysql2date(' F j, Y', $item->created_at) ?></span>
                </div>
              </div>
            </div>
          <?php endforeach; ?>
          <!-- lists -->
        </div>
      </div>
    </div>
  </section>
  <!-- lists -->
<?php endif; ?>

<section class="related_films">
  <div class="container">
    <div class="row">
      <?php
      $terms = get_the_terms($post->ID, 'genre', 'string');
      //Pluck out the IDs to get an array of IDS
      $term_ids = wp_list_pluck($terms, 'term_id');

      $genre_query = new WP_Query(array(
        'post_type' => 'post',
        'tax_query' => array(
          array(
            'taxonomy' => 'genre',
            'field' => 'id',
            'terms' => $term_ids,
            'operator' => 'IN' //Or 'AND' or 'NOT IN'
          )
        ),
        'posts_per_page' => $config['count_relpots'],
        'ignore_sticky_posts' => 1,
        'orderby' => 'rand',
        'post__not_in' => array($post->ID)
      ));

      ?>
      <div class="related_films_title">
        <i class="fa fa-film"></i>
        <?php
        $post_type = get_field('post-type');
        if ($post_type == 'film') {
          $post_type = __('فیلم', 'kelaketfilm');
        } elseif ($post_type == 'series') {
          $post_type = __('سریال', 'kelaketfilm');
        } else {
          $post_type = __('فیلم', 'kelaketfilm');
        }
        ?>
        <h4><?php _e('موارد مشابه', 'kelaketfilm') ?></h4>
      </div>

      <?php
      if ($genre_query->have_posts()) {
        while ($genre_query->have_posts()) : $genre_query->the_post();
      ?>
          <div class="col-xl-2 col-xxl-2 col-lg-3 col-md-4 col-sm-6 col-6">
            <?php 
            if(theme_options('film_card_style') == 'style1'):
              get_template_part('/inc/template_parts/cards/film_card');
            elseif(theme_options('film_card_style') == 'style2'):
              get_template_part('/inc/template_parts/cards/film_card2');
            elseif(theme_options('film_card_style') == 'style3'):
                get_template_part('/inc/template_parts/cards/film_card3');
            endif;
            ?>
          </div>
      <?php endwhile;
      }
      wp_reset_query(); ?>
    </div>
  </div>
</section>


<?php if (get_the_tags()) : ?>
<div class="container">
  <div class="post__tags">
    <div class="post__tags__header d-flex justify-content-between align-items-baseline">
      <div>
        <i class="fa fa-tags"></i><strong><?php _e('برچسب ها', 'kelaketfilm') ?></strong>
      </div>
      <i class="fa fa-chevron-left post__tags__icon"></i>
    </div>
    <div class="post__tags__body">
      <?php the_tags(' ', ' '); ?>
    </div>
  </div>
</div>
<?php endif; ?>


<section class="comments">
  <div class="container">
    <?php
    $comments_count = wp_count_comments(get_the_ID());
    if ($comments_count->approved > 0) {
    ?>
      <div class="comments_title">
        <i class="fa fa-comments-question"></i>
        <h4><?php echo $comments_count->approved . ""; ?> <?php _e('دیدگاه', 'kelaketfilm'); ?></h4>
      </div>
    <?php } ?>
    <div class="comments_inner">
      <?php
      if (comments_open()) {
        comments_template();
      }
      ?>
    </div>
  </div>
</section>