<section class="post_header">
  <div class="post_header_cover" style="background-image: url(<?php echo get_field('slider_image2') ? get_field('slider_image2')['url'] : get_the_post_thumbnail_url(); ?>)"></div>
  <div class="post_header_dark"></div>
  <div class="container">
    <div class="row post_header_content">
      <div class="z-index-2 col-xl-2 offset-xxl-1 col-md-3 col-sm-5 col-xs-10">
        <div class="post_cover">
          <?php the_post_thumbnail('post-retina'); ?>
          <div class="like_single" data-bs-toggle="tooltip" data-bs-placement="top" title="<?php echo is_favorite(get_current_user_id(), get_the_ID()) ? __('حذف از لیست تماشا', 'kelaketfilm') : _e('افزودن به لیست تماشا', 'kelaketfilm') ?>">
            <span class="icon postFav-<?php echo $post->ID; ?> -click <?php echo is_favorite(get_current_user_id(), $post->ID) ? 'fa' : 'far' ?> fa-bookmark" data-js="favorite" data-favorite="<?php echo $post->ID; ?>" data-user="<?php echo get_current_user_id(); ?>"></span>
          </div>
        </div>
      </div>
      <div class="z-index-2 post_header_info col-xxl-8 col-md-9 col-sm-7 col-xs-10">
        <div class="post_header_meta clearfix">
          <h1><?php the_title(); ?>
            <?php if (get_field('legal')) : ?>
              <span class="legal"><i class="fa fa-check"></i> <?php _e('قانونی', 'kelaketfilm') ?></span>
            <?php endif; ?>
            <?php if (get_field('censored')) : ?>
              <span class="censored"><i class="fa fa-check"></i> <?php _e('سانسور شده', 'kelaketfilm') ?></span>
            <?php endif; ?>
          </h1>
          <?php if (get_the_term_list($post->ID, 'genre', '', '، ', '')) : ?>
            <?php echo get_the_term_list($post->ID, 'genre', '', '، ', '') ?>
            <div class="vr"></div>
          <?php endif; ?>
          <?php if (get_the_term_list($post->ID, 'yearr', '', '، ', '')) : ?>
            <?php echo get_the_term_list($post->ID, 'yearr', '', '، ', '') ?>
            <div class="vr"></div>
          <?php endif; ?>
          <?php if (get_field('Rated')) : ?>
            <span class="age_y"><?php the_field('Rated') ?></span>
            <div class="vr"></div>
          <?php endif; ?>
          <?php if (get_field('time')) : ?>
            <?php the_field('time') ?>
            <div class="vr"></div>
          <?php endif; ?>
          <?php if (get_the_term_list($post->ID, 'country', '', '، ', '')) : ?>
            <?php echo get_the_term_list($post->ID, 'country', '', '، ', '') ?>
          <?php endif; ?>
          <span class="float_left">
            <?php
            if (get_field('persian-doble') == 1) { ?>
              <div class="video_tag farsi"><?php _e('دوبله فارسی', 'kelaketfilm') ?></div>
            <?php } elseif (get_field('def-version') == 1) { ?>
              <div class="video_tag"><?php _e('دارای زیرنویس فارسی', 'kelaketfilm') ?></div>
            <?php } elseif (get_field('top-250-imdb') == 1) { ?>
              <div class="video_tag imdb"><?php _e('جزو ۲۵۰ فیلم برتر imdb', 'kelaketfilm') ?></div>
            <?php } ?>
          </span>
        </div>
        <div class="metas_wrap">
          <div class="post_mobile_meta post_header_meta p-t-20">

            <div class="post_meta_i">

              <?php if (get_field('imdbRating') && get_field('imdbVotes')) : ?>
                <a target="_blank" href="https://www.imdb.com/title/<?php the_field('imdb') ?>">
                <div class="d-inline-block">
                  <img class="imdb-svg" alt="imdb" src="<?php echo get_template_directory_uri(); ?>/images/imdb.svg">
                </div>
                </a>
                <div class="d-inline-block imdbb"> <b class="fw-bold"><?php the_field('imdbRating') ?></b> <small><span class="hidden_xs"><?php _e('از', 'kelaketfilm') ?> <?php the_field('imdbVotes') ?> <?php _e('رای', 'kelaketfilm') ?></span></small></div>
              <?php endif; ?>
              <div class="icon d-inline-block">
                <i class="fa-solid fa-heart"></i>
              </div>
              <div class="d-inline-block"> <b class="fw-bold">
              <?php $post_votes = get_post_votes(get_the_ID()); ?>
                <span><?php echo $post_votes['percent']; ?>%</span>
                <?php _e('رضایت', 'kelaketfilm'); ?>
                </b> <small>(<?php echo $post_votes['totalVotes'] ?> <?php _e('رای', 'kelaketfilm') ?>)</small></div>
            </div>
            <div class="m-b-30"></div>


            <?php if( get_the_term_list($post->ID, 'actor', '', ' - ', '') ): ?>
            <div class="actor"><Span><?php _e('بازیگران', 'kelaketfilm') ?>: </Span>
              <?php echo get_the_term_list($post->ID, 'actor', '', ' - ', '') ?>
            </div>
            <?php endif; ?>
            <?php if( get_the_term_list($post->ID, 'director', '', ' - ', '') ): ?>
            <div class="actor"><Span><?php _e('کارگردان', 'kelaketfilm') ?>: </Span>
              <?php echo get_the_term_list($post->ID, 'director', '', ' - ', '') ?>
            </div>
            <?php endif; ?>

          </div>
          <div class="post_like">
            <div class="post_vote">
              <?php
                if(theme_options('post_like_count')):
                  $likes = get_post_meta(get_the_ID(), 'kelaket_likes', true);
                  $dis_likes = get_post_meta(get_the_ID(), 'kelaket_dislikes', true);
                endif;
              ?>
              <button data-vote_system="<?php echo theme_options('post_like_system') ?>" data-postid="<?php echo get_the_ID() ?>" data-userid="<?php echo get_current_user_id() ?>" data-action="like" data-nonce="<?php echo wp_create_nonce('post_vote') ?>" class="post_vote_up">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M88 192h-48C17.94 192 0 209.9 0 232v208C0 462.1 17.94 480 40 480h48C110.1 480 128 462.1 128 440v-208C128 209.9 110.1 192 88 192zM96 440C96 444.4 92.41 448 88 448h-48C35.59 448 32 444.4 32 440v-208C32 227.6 35.59 224 40 224h48C92.41 224 96 227.6 96 232V440zM512 221.5C512 187.6 484.4 160 450.5 160h-102.5c11.98-27.06 18.83-53.48 18.83-67.33C366.9 62.84 343.6 32 304.9 32c-41.22 0-50.7 29.11-59.12 54.81C218.1 171.1 160 184.8 160 208C160 217.1 167.5 224 176 224C180.1 224 184.2 222.4 187.3 219.3c52.68-53.04 67.02-56.11 88.81-122.5C285.3 68.95 288.2 64 304.9 64c20.66 0 29.94 16.77 29.94 28.67c0 10.09-8.891 43.95-26.62 75.48c-1.366 2.432-2.046 5.131-2.046 7.83C306.2 185.5 314 192 322.2 192h128.3C466.8 192 480 205.2 480 221.5c0 15.33-12.08 28.16-27.48 29.2c-8.462 .5813-14.91 7.649-14.91 15.96c0 12.19 12.06 12.86 12.06 30.63c0 14.14-10.11 26.3-24.03 28.89c-5.778 1.082-13.06 6.417-13.06 15.75c0 8.886 6.765 10.72 6.765 23.56c0 31.02-31.51 22.12-31.51 43.05c0 3.526 1.185 5.13 1.185 10.01C389 434.8 375.8 448 359.5 448H303.9c-82.01 0-108.3-64.02-127.9-64.02c-8.873 0-16 7.193-16 15.96C159.1 416.3 224.6 480 303.9 480h55.63c33.91 0 61.5-27.58 61.5-61.47c18.55-10.86 30.33-31 30.33-53.06c0-4.797-.5938-9.594-1.734-14.27c19.31-10.52 32.06-30.97 32.06-53.94c0-7.219-1.281-14.31-3.75-20.98C498.2 266.2 512 245.3 512 221.5z"/></svg>
              <?php _e('دوست داشتم', 'kelaketfilm'); ?>
              <?php if(theme_options('post_like_count')): ?>
                <span class="count_like">(<?php echo $likes ? $likes : 0 ?>)</span>
              <?php endif;?>
              </button>
              <button data-vote_system="<?php echo theme_options('post_like_system') ?>" data-postid="<?php echo get_the_ID() ?>" data-userid="<?php echo get_current_user_id() ?>" data-action="dislike" data-nonce="<?php echo wp_create_nonce('post_vote') ?>" class="post_vote_down">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M128 280v-208C128 49.94 110.1 32 88 32h-48C17.94 32 0 49.94 0 72v208C0 302.1 17.94 320 40 320h48C110.1 320 128 302.1 128 280zM96 280C96 284.4 92.41 288 88 288h-48C35.59 288 32 284.4 32 280v-208C32 67.59 35.59 64 40 64h48C92.41 64 96 67.59 96 72V280zM477.9 235.7c2.469-6.672 3.75-13.77 3.75-20.98c0-22.97-12.75-43.42-32.06-53.94c1.141-4.672 1.734-9.469 1.734-14.27c0-22.06-11.78-41.94-30.33-52.8C421 59.84 393.4 32 359.5 32H303.9c-77.41 0-143.9 63.11-143.9 80.07c0 8.767 7.133 15.96 16 15.96C195.8 128 222.2 64 303.9 64h55.63c16.27 0 29.5 13.22 29.5 29.47c0 4.826-1.185 6.491-1.185 10.01c0 20.94 31.51 12.09 31.51 43.05c0 12.84-6.765 14.68-6.765 23.56c0 9.347 7.255 14.66 13.06 15.75c13.92 2.594 24.03 14.75 24.03 28.89c0 17.77-12.06 18.45-12.06 30.63c0 8.314 6.443 15.38 14.91 15.96C467.9 262.4 480 275.2 480 290.5C480 306.8 466.8 320 450.5 320h-128.3c-8.273 0-15.1 6.658-15.1 16.01c0 2.699 .68 5.398 2.046 7.83c17.73 31.53 26.62 65.39 26.62 75.48C334.9 431.2 325.6 448 304.9 448c-16.7 0-19.66-4.953-28.78-32.78c-21.79-66.41-36.14-69.47-88.81-122.5C184.2 289.6 180.1 288 176 288C167.4 288 160 294.9 160 303.1c0 23.25 57.94 36.53 85.73 121.2C254.2 450.9 263.6 480 304.9 480c38.77 0 62.01-30.84 62.01-60.67c0-13.84-6.844-40.27-18.83-67.33h102.5C484.4 352 512 324.4 512 290.5C512 266.8 498.2 245.8 477.9 235.7z"/></svg>
              <?php _e('دوست نداشتم', 'kelaketfilm'); ?>
              <?php if(theme_options('post_like_count')): ?>
                <span class="count_dislike">(<?php echo $dis_likes ? $dis_likes : 0 ?>)</span>
              <?php endif; ?>
              </button>
            </div>
          </div>
        </div>
      </div>
    </div>
</section>
<section class="post_content">
  <div class="container">
    <div class="row">
      <?php if (get_field('trailer')) { ?>
        <div class="col-xl-6 col-md-6">
          <video class="m-b-10" width="100%" height="auto" controls="" poster="<?php the_field('cover-trailer') ?>" preload="none">
            <source src="<?php the_field('trailer') ?>" type="video/mp4">
            Your browser does not support the video tag.
          </video>
        </div>
      <?php } ?>
      <?php if (get_field('story') || get_field('about') || get_field('rel_date')) { ?>
        <div class="col-xl-6 col-md-6">
          <?php if (get_field('rel_date')) : ?>
            <div class="mb-4">
              <h2 class="post-content-title"><?php _e('لحظه شمار انتشار', 'kelaketfilm') ?></h2>
              <div class="countdown show" data-Date='<?= get_field('rel_date'); ?>'>
                <div class="running">
                  <div class="timer">
                    <div>
                      <span class="days"></span>
                      <div class="counter_label"><?php _e('روز', 'kelaketfilm') ?></div>
                    </div>
                    <div>
                      <span class="hours"></span>
                      <div class="counter_label"><?php _e('ساعت', 'kelaketfilm') ?></div>
                    </div>
                    <div>
                      <span class="minutes"></span>
                      <div class="counter_label"><?php _e('دقیقه', 'kelaketfilm') ?></div>
                    </div>
                    <div>
                      <span class="seconds"></span>
                      <div class="counter_label"><?php _e('ثانیه', 'kelaketfilm') ?></div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          <?php endif; ?>
          <?php
          $post_type = get_field('post-type');
          if ($post_type == 'film') {
            $post_type = __('فیلم', 'kelaketfilm');
          } elseif ($post_type == 'series') {
            $post_type = __('سریال', 'kelaketfilm');
          } else {
            $post_type = __('فیلم', 'kelaketfilm');
          }
          ?>
          <?php if (get_field('story')) { ?>
            <h4 class="post-content-title">
              <i class="fa fa-film"></i>

              <?php _e('داستان', 'kelaketfilm') ?> <?php echo $post_type; ?>
            </h4>
            <p class="post-content-more">
              <?php the_field('story') ?>
            </p>
          <?php } ?>
          <?php if (get_field('about')) { ?>
            <h4 class="post-content-title">
              <i class="fa fa-film"></i>

              درباره <?php echo $post_type; ?>
            </h4>
            <p class="post-content-more">
              <?php the_field('about') ?>
            </p>
          <?php } ?>
        </div>
      <?php } ?>
    </div>
    <?php if (get_field('story') || get_field('about')) : ?>
      <div class="divider m-t-20"></div>
    <?php endif; ?>
  </div>
</section>
<?php //endwhile;


if ($justIranOption == false || $userFromIran) : ?>
  <section class="download_section">
    <div class="container">
      <div class="d-flex justify-content-between dl_info">
        <div class="internet">
          <i class="fa-solid fa-star"></i>
          <span>
            <?php
            if (get_field('internet') == 'half') {
              _e('حجم مصرفی شما نیم بها محاسبه می‌شود.', 'kelaketfilm');
            } else {
              _e('حجم مصرفی شما عادی محاسبه می‌شود.', 'kelaketfilm');
            }
            ?>
          </span>
        </div>
        <div class="report">
          <button data-bs-toggle="modal" data-bs-target="#exampleModal"><i class="fa fa-flag"></i><?php _e('گزارش خرابی لینک', 'kelaketfilm') ?></button>
          <button class="share" data-bs-toggle="modal" data-bs-target="#shareModal"><i class="fa fa-share-nodes"></i><?php _e('اشتراک گذاری', 'kelaketfilm') ?></button>
        </div>
      </div>
      <?php
      // if (function_exists('rcp_user_can_access') && rcp_user_can_access(get_current_user_id(), get_the_ID())) {
      ?>
        <div class="download_inner">
          <?php
          // film downloadbox
          if (have_rows('film-dl')) :
            while (have_rows('film-dl')) : the_row();
              $sub_value = get_sub_field('farsi-doble');
              $is_free = get_sub_field('is_free');
          ?>
              <div class="download_item clearfix">
                <div class="download_info">
                  <?php if (have_rows('film-dl-link')) {
                    while (have_rows('film-dl-link')) : the_row(); ?>
                      <span><?php the_sub_field('dl_row_info'); ?></span>
                      <?php if (get_sub_field('film-price')) : ?>
                        قیمت:‌ <span class="text-green"><?php the_sub_field('film-price'); ?></span>
                      <?php endif; ?>
                      <?php if (get_sub_field('version')) { ?><span class="badge-v"> <?php the_sub_field('version'); ?> </span> <?php } ?>
                    <?php endwhile; ?>
                    <?php
                      if($is_free){
                        echo '<small class="free_badge">'.__('رایگان', 'kelaketfilm').'</small>';
                      }
                    ?>
                </div>

                <?php
                    $quality = [];
                    while (have_rows('film-dl-link')) : the_row();
                      $temp = @parse_url(get_sub_field('dl-film-link'))['query'];
                      if ($temp) {
                        $quality[] = get_sub_field('dl-film-link') . "&size=" . get_sub_field('quality-film') . "";
                      } else {
                        $quality[] = get_sub_field('dl-film-link') . "?size=" . get_sub_field('quality-film') . "";
                      }
                ?>

                  <div class="align-left">
                    <?php if (get_sub_field('film-price')) : ?>
                      <a data-bs-toggle="tooltip" data-bs-placement="top" title="<?= get_sub_field('size-film') ? __(' دانلود با حجم ') : '' ?><?= the_sub_field('size-film'); ?>" href="<?php the_sub_field('dl-film-link') ?>" class="button  align-left button-green"><?php _e('خرید و دانلود', 'kelaketfilm') ?> <?php the_sub_field('quality-film') ?></a>
                    <?php else : 
                      if(kelaket_user_access(get_current_user_id(), get_the_ID(), $is_free)): 
                        if(get_sub_field('dl-film-link')):
                      ?>
                      <a data-bs-toggle="tooltip" data-bs-placement="top" title="<?= get_sub_field('size-film') ? __(' دانلود با حجم ') : '' ?><?= the_sub_field('size-film'); ?>" href="<?php the_sub_field('dl-film-link') ?>" class="button  align-left button-green"><?php _e('دانلود', 'kelaketfilm') ?> <?php the_sub_field('quality-film') ?></a>
                    <?php endif; else:?>
                      <a data-bs-toggle="modal" href="#vipModal" class="button  align-left button-green">
                        <?php _e('دانلود', 'kelaketfilm'); ?> <?php the_sub_field('quality-film') ?>
                      </a>
                    <?php endif; endif; ?>
                  </div>


              <?php endwhile;
                  } ?>
              <?php
              if (get_sub_field('farsi-doble') == 'yes' && get_sub_field('farsi-doble-link')) { ?>
                <div class="align-left">
                  <a href="<?php the_sub_field('farsi-doble-link') ?>" class="button align-left button-orange"><?php _e('دانلود صوت دوبله فارسی', 'kelaketfilm') ?></a>
                </div>
              <?php } ?>
              <?php
              if (get_sub_field('subtitle-film')) { ?>
                <div class="align-left">
                  <a href="<?php the_sub_field('subtitle-film') ?>" class="button align-left button-blue"><?php _e('دانلود زیرنویس', 'kelaketfilm') ?></a>
                </div>
              <?php } ?>
              <?php if (get_sub_field('online_link')) {
                $link = encrypt_decrypt(get_sub_field('online_link'), 'encrypt');
                $subtitle = encrypt_decrypt(get_sub_field('subtitle_online_film'), 'encrypt');
              ?>
                <div class="align-left">
                  <a href="<?php bloginfo('url') ?>/playonline?id=<?php echo get_the_ID() ?>&media=<?php echo $link ?>&subtitle=<?php echo $subtitle ?>&quality1=<?php echo encrypt_decrypt($quality[0], 'encrypt'); ?>&quality2=<?php echo encrypt_decrypt($quality[1], 'encrypt'); ?>&quality3=<?php echo encrypt_decrypt($quality[2], 'encrypt'); ?>" class="button_online align-left btn-outline-warning">
                    <svg xmlns="http://www.w3.org/2000/svg" width="31" height="31" fill="currentColor" class="bi bi-play-fill" viewBox="0 0 16 16">
                      <path d="m11.596 8.697-6.363 3.692c-.54.313-1.233-.066-1.233-.697V4.308c0-.63.692-1.01 1.233-.696l6.363 3.692a.802.802 0 0 1 0 1.393z" />
                    </svg>
                    <span class="online_text"><?php _e("پخش آنلاین", 'kelaketfilm') ?></span>
                  </a>
                </div>
              <?php } ?>
              </div>
              <?php
              if (get_sub_field('film_info')) { ?>
                <div class="download_notice">
                  <i class="fa-dutone fa-info-circle"></i>
                  <?php the_sub_field('film_info'); ?>
                </div>
              <?php } ?>

          <?php
            endwhile;

          else :

          endif;
          ?>

          <?php
          // series downloadbox
          if (have_rows('serial-dl')) : ?>
            <nav>
              <div class="nav nav-tabs" id="nav-tab" role="tablist">
                <?php
                while (have_rows('serial-dl')) : the_row();
                  //$sub_value = get_sub_field('farsi-doble');
                ?>
                  <button class="nav-link" id="serial-tab" data-bs-toggle="tab" data-bs-target="#<?php the_sub_field('identifer') ?>" type="button" role="tab" aria-controls="<?php the_sub_field('identifer') ?>" aria-selected="true">
                  <?php the_sub_field('season-name') ?>
                  <?php if(get_sub_field('episode-count')): ?>
                   <small><?php the_sub_field('episode-count') ?></small> 
                  <?php endif; ?>
                </button>

                <?php
                endwhile; ?>
              </div>
            </nav>
            <div class="tab-content" id="nav-tabContent">

              <?php while (have_rows('serial-dl')) : the_row();
              $season = get_row_index();
              ?>
                <div class="tab-pane fade" id="<?php the_sub_field('identifer') ?>" role="tabpanel" aria-labelledby="serial-tab">
                  <?php
                  if (have_rows('dl-links')) {
                    while (have_rows('dl-links')) : the_row(); ?>
                      <div class="download_item serial-item clearfix">
                        <div class="download_info serial-dl-info">
                          <?php the_sub_field('episode');
                          $is_free = get_sub_field('is_free');

                          if($is_free){
                            echo '<small class="free_badge">'.__('رایگان', 'kelaketfilm').'</small>';
                          }
                          ?>

                          <?php if (get_sub_field('serial-price')) : ?>
                            قیمت:‌ <span class="text-green"><?php the_sub_field('serial-price'); ?></span>
                          <?php endif; ?>
                        </div>
                        <div class="align-left">

                          <?php
                          while (have_rows('quality')) : the_row();
                          ?>
                            <?php if (get_sub_field('sale')) : ?>
                              <a data-bs-toggle="tooltip" data-bs-placement="top" title="<?= get_sub_field('serial_size') ? __(' دانلود با حجم ') : '' ?><?= the_sub_field('serial_size'); ?>" href="<?php the_sub_field('quality-dl-link') ?>" class="button align-left button-green"><?php _e('خرید و دانلود', 'kelaketfilm') ?> <?php the_sub_field('quality-name') ?></a>
                            <?php else :
                            if(kelaket_user_access(get_current_user_id(), get_the_ID(), $is_free)):
                            ?>
                              <a data-bs-toggle="tooltip" data-bs-placement="top" title="<?= get_sub_field('serial_size') ? __(' دانلود با حجم ') : '' ?><?= the_sub_field('serial_size'); ?>" href="<?php the_sub_field('quality-dl-link') ?>" class="button align-left button-green"><?php _e('دانلود', 'kelaketfilm') ?> <?php the_sub_field('quality-name') ?></a>
                            <?php else:?>
                              <a data-bs-toggle="modal" href="#vipModal" class="button align-left button-green">
                                دانلود <?php the_sub_field('quality-name') ?>
                              </a>
                            <?php endif; endif; ?>
                          <?php endwhile; ?>

                          <?php if (get_sub_field('online_link_serial')) {
                            $link = encrypt_decrypt(get_sub_field('online_link_serial'), 'encrypt');

                            $subtitle = encrypt_decrypt(get_sub_field('subtitle_online_serial'), 'encrypt');
                          ?>
                            <a target="_blank" href="<?php bloginfo('url') ?>/playonline?id=<?php echo get_the_ID() ?>&season=<?php echo $season; ?>&ep=<?php echo get_row_index() ?>" class="button_online align-left btn-outline-warning">
                              <svg xmlns="http://www.w3.org/2000/svg" width="31" height="31" fill="currentColor" class="bi bi-play-fill" viewBox="0 0 16 16">
                                <path d="m11.596 8.697-6.363 3.692c-.54.313-1.233-.066-1.233-.697V4.308c0-.63.692-1.01 1.233-.696l6.363 3.692a.802.802 0 0 1 0 1.393z" />
                              </svg>
                              <span class="online_text"><?php _e('پخش آنلاین', 'kelaketfilm') ?></span>
                            </a>
                          <?php } ?>

                          <?php
                          if (get_sub_field('subtitle')) { ?>

                            <a href="<?php the_sub_field('subtitle') ?>" class="button align-right button-blue"><?php _e('دانلود زیرنویس', 'kelaketfilm') ?></a>

                          <?php } ?>
                          <?php
                          if (get_sub_field('farsi') == 'yes' && get_sub_field('farsi-sound')) { ?>

                            <a href="<?php the_sub_field('farsi-sound') ?>" class="button align-right button-orange"><?php _e('دانلود صوت دوبله فارسی', 'kelaketfilm') ?></a>

                          <?php } ?>
                          
                        </div>
                      </div>
                      <?php
                      if (get_sub_field('serial_info')) { ?>
                        <div class="download_notice">
                          <i class="fa fa-info-circle"></i>
                          <?php the_sub_field('serial_info'); ?>
                        </div>
                      <?php } ?>
                  <?php endwhile;
                  }
                  ?>

                </div>
            <?php endwhile;

            else :

            endif;
            ?>
            </div>

        </div>
    </div>
  </section>
<?php else : ?>
  <div class="container">
    <div class="alert alert-danger"><strong>نکته:‌ </strong>دانلود فیلم و سریال از <strong><?php bloginfo('name'); ?></strong> فقط با IP ایران امکان پذیر می‌باشد. درصورت استفاده از <strong>VPN</strong> آنرا قطع کرده و صفحه را رفرش کنید.</div>
  </div>
<?php endif; ?>


<?php if (get_field('collection_id')) : ?>
  <div class="container">
    <section class="collection_content overflow-hidden position-relative single__content my-3 mb-4">
      <img class="position-absolute collection_mask" src="<?php echo get_the_post_thumbnail_url(); ?>)" />
      <div class="row align-items-center position-relative">
        <div class="col-xxl-3 col-xl-3 col-lg-4 col-sm-4">
          <div class="collection_title">
            <div class="from"><?php _e("از کالکشن", 'kelaketfilm') ?></div>
            <div class="name"><?= get_cat_name(get_field('collection_id')) ?></div>
            <a href="<?= get_category_link(get_field('collection_id')); ?>" class="btn btn-orange"><?php _e("مشاهده همه", 'kelaketfilm') ?></a>
          </div>
        </div>
        <div class="col-xxl-9 col-xl-9 col-lg-8 col-sm-8">
          <div class="row flex-row-reverse g-2">
            <!-- collction posts -->
            <?php
            $related = get_posts(array('numberposts' => 4, 'category__in' => get_field('collection_id')));
            if ($related) foreach ($related as $post) {
              setup_postdata($post); ?>
              <div class="col-xxl-3 col-xl-3 col-lg-3 col-md-3 col-sm-6 col-6">
                <div class="related_film_item">
                  <a href="<?php the_permalink() ?>">
                    <?php the_post_thumbnail('rel_item'); ?>
                    <h5><?php the_title(); ?></h5>
                    <div class="related_rotten">
                      <i class="bi bi-hand-thumbs-up"></i>
                      <?php
                      if (get_field('rotten')) {
                        the_field('rotten');
                      } else {
                        echo '۰';
                      }
                      ?>% <?php _e('رضایت', 'kelaketfilm'); ?>
                    </div>
                  </a>
                </div>
              </div>
            <?php }
            wp_reset_postdata(); ?>
            <!-- /END Collection posts -->
          </div>
        </div>
      </div>
    </section>
  </div>

<?php endif; ?>


<div class="container d-flex justify-content-center text-cetner">
  <button class="toggle_more_default">
    <?php _e('اطلاعات بیشتر', 'kelaketfilm'); ?>
    <i class="fa fa-chevron-left"></i>
  </button>
</div>

<div class="container default_style_more">
  <div class="row">
    <?php if (get_field('gallery')) : ?>
      <div class="related_films_title">
        <i class="fa fa-images"></i>
        <h4><?php _e('گالری تصاویر', 'kelaketfilm'); ?></h4>
      </div>
      <section class="film_info">
        <div class="gallery row g-2">
          <?php foreach (get_field('gallery') as $item) : ?>
            <div class="col-xxl-2 col-xl-3 col-lg-3 col-md-3 col-sm-4 col-4">
              <a class="gallery_image" href="<?php echo $item; ?>">
                <img src="<?php echo $item; ?>" alt="<?php the_title(); ?>" />
                <div class="gallery_mask">
                  <i class="fa fa-arrow-down-left-and-arrow-up-right-to-center"></i>
                </div>
              </a>
            </div>
          <?php endforeach; ?>
        </div>
      </section>
    <?php endif; ?>

    <div class="related_films_title">
      <i class="fa fa-message-text"></i>
      <h4><?php _e("اطلاعات بیشتر", 'kelaketfilm') ?></h4>
    </div>

    <div class="related_post_blog">
      <div class="row">
        <?php
        $related_blog_posts = get_field('related_blog_post');
        if ($related_blog_posts) :
          foreach ($related_blog_posts as $blog_post) : ?>
            <div class="col-xxl-4 col-xl-4 col-lg-6 col-md-6 col-sm-6">
              <article class="related_post_blog_item">
                <div class="icon">
                  <?php bloginfo('name'); ?> <span><?php _e("مگ", 'kelaketfilm') ?></span>
                </div>
                <header>
                  <?php echo $blog_post->post_title; ?>
                </header>
                <p>
                  <?php echo substr_replace($blog_post->post_excerpt, "...", 353) ?>
                </p>
                <div>
                  <a href="<?php echo $blog_post->guid ?>"><?php _e("ادامه مطلب", 'kelaketfilm') ?></a>
                </div>
              </article>
            </div>
        <?php endforeach;
        endif; ?>
      </div>
    </div>

    <div class="col-xxl-12">
      <div class="post_content_single">
        <?php if (!empty(get_the_content())) : ?>
          <?php the_content(); ?>
        <?php endif; ?>
        <div class="awards">
          <ul>
            <?php if (get_field('Awards') && get_field('Awards') !== 'N/A') : ?><li><i class="fa fa-award"></i><strong><?php _e('جوایز', 'kelaketfilm') ?>: </strong><?php the_field('Awards') ?></li><?php endif; ?>
            <?php if (get_field('Language')) : ?><li><i class="fa fa-language"></i><strong><?php _e('زبان', 'kelaketfilm') ?>: </strong><?php the_field('Language') ?></li><?php endif; ?>
            <?php if (get_field('Writer') && get_field('Writer') !== 'N/A') : ?><li><i class="fa fa-pen"></i><strong><?php _e('نویسنده', 'kelaketfilm') ?>: </strong><?php the_field('Writer') ?></li><?php endif; ?>
          </ul>
        </div>
      </div>
    </div>

    <?php if($config['show_actors']): 
      $actors = get_field('actors');
      $director = get_field('director');
    ?>
    <div class="default_stars mb-3">
      
      <?php if($actors || $director): ?>
      <div class="stars_header mb-4">
        <h4>
          <i class="fa fa-star"></i>
          <?php _e('ستارگان', 'kelaketfilm'); ?>
        </h4>
      </div>
      <?php endif; ?>
      
      
      <div class="owl-carousel single_cast_default">
      <?php
      if ($actors) :
        foreach ($actors as $actor) :
      ?>
        <a href="<?php echo esc_url(get_term_link($actor)) ?>">
          <?php if (get_field('actor_image_link', $actor)) { ?>
            <img width="150" height="150" src="<?php echo get_field('actor_image_link', $actor) ?>" onerror="this.onerror=null; this.src='<?php echo get_template_directory_uri(); ?>/images/no_img.png';" alt="<?php echo $actor->name; ?>" title="<?php echo $actor->name; ?>" />
          <?php } else { ?>
            <img src="<?php echo get_template_directory_uri(); ?>/images/no_img.png" alt="no-image" />
          <?php } ?>
          <div class="stars_title">
            <?php echo $actor->name; ?>
            <div><small><?php _e("بازیگر", 'kelaketfilm') ?></small></div>
          </div>
        </a>
        <?php endforeach;
      endif;
      if ($director) :
        foreach ($director as $direct) :
        ?>
          <a href="<?php echo esc_url(get_term_link($direct)) ?>">
            <?php if (get_field('actor_image_link', $direct)) { ?>
              <img src="<?php echo get_field('actor_image_link', $direct) ?>" onerror="this.onerror=null; this.src='<?php echo get_template_directory_uri(); ?>/images/no_img.png';" alt="<?php echo $direct->name; ?>" title="<?php echo $direct->name; ?>" />
            <?php } else { ?>
              <img src="<?php echo get_template_directory_uri(); ?>/images/no_img.png" alt="no-image"/>
            <?php } ?>
            <div class="stars_title">
              <?php echo $direct->name; ?>
              <div><small><?php _e("کارگردان", 'kelaketfilm') ?></small></div>
            </div>
          </a>
      <?php endforeach;
      endif; ?>
      </div>
    </div> <!-- # default stars -->
    <?php endif; ?>
  </div>


<!-- lists -->
<?php
global $wpdb;
$tablename = $wpdb->prefix . 'kelaket_lists';
$post_id = get_the_ID();

$qry = "select * from $tablename WHERE is_private = false AND FIND_IN_SET($post_id, films) ORDER BY id DESC LIMIT 6";
$result = $wpdb->get_results($qry);
if ($result) :
?>
  <section class="related_films">
    <div class="container">
      <div class="row">
        <div class="related_films_title">
          <i class="fa fa-list"></i>
          <h4><?php _e("لیست های مرتبط با ", 'kelaketfilm') ?> <?php the_title(); ?></h4>
        </div>
        <div class="owl-carousel lists_carousel2">

          <?php
          foreach ($result as $item) :
            $user = get_user_by('id', $item->user_id);
            $films = explode(',', $item->films);
            if (empty($films[0])) {
              $count = 0;
            } else {
              $count = count($films);
            }
            // fix first image issue due the first index of array alwasy empty 
            if (!get_the_post_thumbnail_url($films[0], 'post_retina')) {
              $firstImage = get_template_directory_uri() . '/images/nocover.jpeg';
            } else {
              $firstImage = get_the_post_thumbnail_url($films[0], 'post_retina');
            }
          ?>
            <div class="">
              <div class="custom_list single_list">
                <a href="<?php echo site_url() . "/lists/$item->id" ?>">
                  <div class="custom_list_images">
                    <div>
                      <img src="<?php echo $firstImage ?>" alt="">
                      <img src="<?php echo checkIndexExists($films, 1) ?  get_the_post_thumbnail_url($films[1], 'post_retina') : get_template_directory_uri() . '/images/nocover.jpeg' ?>" alt="">
                    </div>
                    <div>
                      <img src="<?php echo checkIndexExists($films, 2) ? get_the_post_thumbnail_url($films[2], 'post_retina') : get_template_directory_uri() . '/images/nocover.jpeg' ?>" alt="">
                      <img src="<?php echo checkIndexExists($films, 3) ? get_the_post_thumbnail_url($films[3], 'post_retina') : get_template_directory_uri() . '/images/nocover.jpeg' ?>" alt="">
                    </div>
                  </div>
                </a>
                <h3>
                  <a data-bs-toggle='tooltip' data-bs-placement='top' title="<?php echo $item->name; ?>" class="list" href="<?php echo site_url() . "/lists/$item->id" ?>"><?php echo limited_excerpt($item->name, 20) ?></a>
                  توسط
                  <a class="author" href="<?php echo bloginfo('url') . '/profile/' . $user->user_login;  ?>"><?php echo $user->display_name; ?></a>
                </h3>
                <div class="custom_list_meta">
                  <span><?php _e("تعداد:", 'kelaketfilm') ?> <?php echo $count; ?></span>
                  <?php
                  //check if post updated show date as tooltip
                  if ($item->updated_at == '0000-00-00 00:00:00') {
                    $update = "";
                  } else {
                    $update = __("آخرین بروزرسانی:", 'kelaketfilm') . mysql2date(' F j, Y', $item->updated_at);
                  }
                  ?>
                  <span data-bs-toggle='tooltip' data-bs-placement='top' title="<?php echo $update; ?>"><?php echo  mysql2date(' F j, Y', $item->created_at) ?></span>
                </div>
              </div>
            </div>
          <?php endforeach; ?>
          <!-- lists -->
        </div>
      </div>
    </div>
  </section>
  <!-- lists -->
<?php endif; ?>

</div>



<section class="related_films">
  <div class="container">
    <div class="row">
      <?php
      $terms = get_the_terms($post->ID, 'genre', 'string');
      //Pluck out the IDs to get an array of IDS
      $term_ids = wp_list_pluck($terms, 'term_id');

      $genre_query = new WP_Query(array(
        'post_type' => 'post',
        'tax_query' => array(
          array(
            'taxonomy' => 'genre',
            'field' => 'id',
            'terms' => $term_ids,
            'operator' => 'IN' //Or 'AND' or 'NOT IN'
          )
        ),
        'posts_per_page' => $config['count_relpots'],
        'ignore_sticky_posts' => 1,
        'orderby' => 'rand',
        'post__not_in' => array($post->ID)
      ));

      ?>
      <div class="related_films_title">
        <i class="fa fa-film"></i>
        <?php
        $post_type = get_field('post-type');
        if ($post_type == 'film') {
          $post_type = __('فیلم', 'kelaketfilm');
        } elseif ($post_type == 'series') {
          $post_type = __('سریال', 'kelaketfilm');
        } else {
          $post_type = __('فیلم', 'kelaketfilm');
        }
        ?>
        <h4><?php _e('موارد مشابه', 'kelaketfilm') ?></h4>
      </div>

      <?php
      if ($genre_query->have_posts()) {
        while ($genre_query->have_posts()) : $genre_query->the_post();
      ?>
          <div class="col-xl-2 col-xxl-2 col-lg-3 col-md-4 col-sm-6 col-6">
          <?php 
            if(theme_options('film_card_style') == 'style1'):
              get_template_part('/inc/template_parts/cards/film_card');
            elseif(theme_options('film_card_style') == 'style2'):
              get_template_part('/inc/template_parts/cards/film_card2');
            elseif(theme_options('film_card_style') == 'style3'):
                get_template_part('/inc/template_parts/cards/film_card3');
            endif;
            ?>
          </div>
      <?php endwhile;
      }
      wp_reset_query(); ?>
    </div>
  </div>
</section>

<?php if (get_the_tags()) : ?>
<div class="container">
  <div class="post__tags">
    <div class="post__tags__header d-flex justify-content-between align-items-baseline">
      <div>
        <i class="fa fa-tags"></i><strong><?php _e('برچسب ها', 'kelaketfilm') ?></strong>
      </div>
      <i class="fa fa-chevron-left post__tags__icon"></i>
    </div>
    <div class="post__tags__body">
      <?php the_tags(' ', ' '); ?>
    </div>
  </div>
</div>
<?php endif; ?>

<section class="comments">
  <div class="container">
    <?php
    $comments_count = wp_count_comments(get_the_ID());
    if ($comments_count->approved > 0) {
    ?>
      <div class="comments_title">
        <i class="fa fa-comments-question"></i>
        <h4><?php echo $comments_count->approved . ""; ?> <?php _e('دیدگاه', 'kelaketfilm'); ?></h4>
      </div>
    <?php } ?>
    <div class="comments_inner">
      <?php
      if (comments_open()) {
        comments_template();
      }
      ?>
    </div>
  </div>
</section>