<div class="container after_fe2">
  <?php echo kelaket_breadcrumbs(); ?>
  <div class="row">
    <div class="col-xl-9 col-lg-8 col-md-12 col-sm-12 col-xs-12 col-xxl-9">
      <article class="post2">
        <div class="post2_bg" style="background-image: url(<?php echo get_the_post_thumbnail_url(); ?>)"></div>
        <div class="row relz2">
          <div class="title">
            <h1>
              <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
            </h1>
          </div>

          <div class="post_details col-xl-9 col-lg-8 col-md-8 order-md-1 order-2">
            <ul class="post_meta">
              <?php if (get_field('update_info')) : ?>
                <li>
                  <strong>
                    <span class="icon"><i class="fa-light fa-rotate"></i></span>
                    <?php _e('بروزرسانی', 'kelaketfilm'); ?></strong><i class="seprator"></i>
                  <div class="post_meta--left"><?php the_field('update_info') ?></div>
                </li>
              <?php endif; ?>
              <?php if (get_the_term_list(get_the_ID(), 'genre', '', '، ', '')) : ?>
                <li><strong>
                    <span class="icon"><i class="fa-light fa-theater-masks"></i></span>
                    <?php _e('ژانر', 'kelaketfilm'); ?>
                  </strong><i class="seprator"></i>
                  <div class="post_meta--left"><?php echo get_the_term_list(get_the_ID(), 'genre', '', '، ', '') ?></div>
                </li>
              <?php endif; ?>
              <?php if (get_the_term_list(get_the_ID(), 'yearr', '', '، ', '')) : ?>
                <li><strong>
                    <span class="icon"><i class="fa-light fa-calendar-days"></i> </span>
                    <?php _e('سال تولید', 'kelaketfilm'); ?></strong><i class="seprator"></i>
                  <div class="post_meta--left"><?php echo get_the_term_list(get_the_ID(), 'yearr', '', '، ', '') ?></div>
                </li>
              <?php endif; ?>
              <?php if (get_the_term_list(get_the_ID(), 'country', '', '، ', '')) : ?>
                <li><strong>
                    <span class="icon"><i class="fa-light fa-globe"></i> </span>
                    <?php _e('محصول', 'kelaketfilm'); ?></strong><i class="seprator"></i>
                  <div class="post_meta--left"><?php echo get_the_term_list(get_the_ID(), 'country', '', '، ', '') ?></div>
                </li>
              <?php endif; ?>
              <?php if (get_field('time')) : ?>
                <li><strong>
                    <span class="icon"><i class="fa-light fa-stopwatch"></i> </span>
                    <?php _e('مدت زمان', 'kelaketfilm'); ?></strong><i class="seprator"></i>
                  <div class="post_meta--left"><?php the_field('time') ?></div>
                </li>
              <?php endif; ?>
              <?php if (get_field('air_status')) : ?>
                <li><strong>
                    <span class="icon"><i class="fa-light fa-screencast"></i> </span>
                    <?php _e('وضعیت پخش', 'kelaketfilm'); ?></strong><i class="seprator"></i>
                  <div class="post_meta--left"><?php the_field('air_status') ?></div>
                </li>
              <?php endif; ?>
              <?php if (get_field('Language')) : ?>
                <li><strong>
                    <span class="icon"><i class="fa-light fa-language"></i> </span>
                    <?php _e('زبان', 'kelaketfilm'); ?></strong><i class="seprator"></i>
                  <div class="post_meta--left"><?php the_field('Language') ?></div>
                </li>
              <?php endif; ?>
              <?php if (get_field('quality-meta')) : ?>
                <li><strong>
                    <span class="icon"><i class="fa-light fa-tv"></i> </span>
                    <?php _e('کیفیت', 'kelaketfilm'); ?></strong><i class="seprator"></i>
                  <div class="post_meta--left">
                    <?php
                    $quality = get_field('quality-meta');
                    $quality = explode(',', $quality);
                    foreach ($quality as $item) {
                      echo '<span> ' . $item . ' </span>';
                    }
                    ?>
                  </div>
                </li>
              <?php endif; ?>

              <?php if (get_the_term_list(get_the_ID(), 'actor', '', '، ', '')) : ?>
                <li><strong>
                    <span class="icon"><i class="fa-light fa-users"></i> </span>
                    <?php _e('بازیگران', 'kelaketfilm'); ?></strong><i class="seprator"></i>
                  <div class="post_meta--left"><?php echo get_the_term_list(get_the_ID(), 'actor', '', '، ', '') ?></div>
                </li>
              <?php endif; ?>
              <?php if (get_the_term_list(get_the_ID(), 'director', '', '، ', '')) : ?>
                <li><strong>
                    <span class="icon"><i class="fa-light fa-user-crown"></i></span>
                    <?php _e('کارگردان', 'kelaketfilm'); ?></strong><i class="seprator"></i>
                  <div class="post_meta--left"><?php echo get_the_term_list(get_the_ID(), 'director', '', '، ', '') ?></div>
                </li>
              <?php endif; ?>
              <li class="badges_new">
                <?php if (get_field('legal')) : ?>
                  <span class="badge_movie badge_blue">
                    <i class="fa fa-hexagon-check"></i>
                    <?php _e('دانلود قانونی', 'kelaketfilm'); ?>
                  </span>
                <?php endif; ?>
                <?php if (get_field('censored')) : ?>
                  <span class="badge_movie badge_cyan">
                    <i class="fa fa-eye-slash"></i>
                    <?php _e('سانسور شده', 'kelaketfilm'); ?>
                  </span>
                <?php endif; ?>
                <?php if (get_field('persian-doble')) : ?>
                  <span class="badge_movie badge_red">
                    <i class="fa fa-microphone-lines"></i>
                    <?php _e('دوبله فارسی', 'kelaketfilm'); ?>
                  </span>
                <?php endif; ?>
                <?php if (get_field('def-version')) : ?>
                  <span class="badge_movie badge_orange">
                    <i class="fa fa-closed-captioning"></i>
                    <?php _e('زیرنویس فارسی', 'kelaketfilm'); ?>
                  </span>
                <?php endif; ?>
                <?php if (get_field('top-250-imdb')) : ?>
                  <span class="badge_movie badge_yellow">
                    <i class="fa fa-stars"></i>
                    <?php _e('جزو ۲۵۰ فیلم برتر با رتبه', 'kelaketfilm'); ?>  <?php the_field('imdb_rank'); ?>
                  </span>
                <?php endif; ?>
                <?php if (get_field('top-250-series')) : ?>
                  <span class="badge_movie badge_yellow">
                    <i class="fa fa-stars"></i>
                    <?php _e('جزو ۲۵۰ سریال برتر با رتبه', 'kelaketfilm'); ?>  <?php the_field('series_imdb_rank'); ?>
                  </span>
                <?php endif; ?>
                <?php if (get_field('custom-badge')) : ?>
                  <span class="badge_movie badge_dark_blue">
                    <i class="fa fa-grid-2"></i>
                    <?php the_field('custom-badge'); ?>
                  </span>
                <?php endif; ?>
              </li>
              <li>
                <?php if (get_field('story')) : ?> <p><i class="fa-light fa-comment-dots"></i> <span class="story"><?php _e('خلاصه داستان:', 'kelaketfilm'); ?></span> <?php the_field('story'); ?></p><?php endif; ?>
              </li>
            </ul>

            <?php
            $post_type = get_field('post-type');
            if ($post_type == 'film') {
              $post_type = __('فیلم', 'kelaketfilm');
            } elseif ($post_type == 'series') {
              $post_type = __('سریال', 'kelaketfilm');
            } else {
              $post_type = '';
            }
            ?>
          </div>
          <div class="post_image col-xl-3 col-lg-4 col-md-4 order-1">
            <?php
            if (get_field('imdbRating')) { ?>
              <a target="_blank" href="https://www.imdb.com/title/<?php the_field('imdb') ?>">
                <div class="imdbRating_holder mb-4">
                  <div class="imdbLogo">
                    <img width="29" height="12" src="<?php echo get_template_directory_uri(); ?>/images/imdbt.svg" alt="imdb">
                  </div>
                  <div class="imdbRate_nums">
                    <strong><?php the_field('imdbRating'); ?></strong>
                    <small>/10</small>
                  </div>
                </div>
              </a>
            <?php } ?>
            <?php
            if (get_field('malRating')) { ?>
              <div class="imdbRating_holder mal_holder mb-4">
                <div class="imdbLogo">
                  MAL
                </div>
                <div class="imdbRate_nums">
                  <strong><?php the_field('malRating'); ?></strong>
                  <small>/10</small>
                </div>
              </div>
            <?php } ?>
            <a href="<?php the_permalink() ?>">
              <div class="post_image--inner text-center">
                <?php if (get_field('playonline')) : ?>
                  <span class="playonline_badge">
                    <i class="fa-solid fa-play-circle"></i>
                  </span>
                <?php endif; ?>
                <?php the_post_thumbnail('post_retina'); ?>
                <div data-bs-toggle="tooltip" data-bs-placement="top" title="<?php echo is_favorite(get_current_user_id(), get_the_ID()) ? __('حذف از لیست تماشا', 'kelaketfilm') : _e('افزودن به لیست تماشا', 'kelaketfilm') ?>" class="simplefavorite-button stats -favorites">
                  <span class="icon postFav-<?php echo get_the_ID(); ?> -click <?php echo is_favorite(get_current_user_id(), get_the_ID()) ? 'fa' : 'far' ?> fa-bookmark" data-js="favorite" data-favorite="<?php echo get_the_ID(); ?>" data-user="<?php echo get_current_user_id(); ?>"></span>
                </div>
              </div>
            </a>
          </div>
          <div class="about_box push_right mt-1 order-3">
            <div class="about_box--right d-flex">
              <div class="post_vote">
                <button data-vote_system="<?php echo theme_options('post_like_system') ?>" data-postid="<?php echo get_the_ID() ?>" data-userid="<?php echo get_current_user_id() ?>" data-action="like" data-nonce="<?php echo wp_create_nonce('post_vote') ?>" class="post_vote_up">
                  <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                    <path d="M88 192h-48C17.94 192 0 209.9 0 232v208C0 462.1 17.94 480 40 480h48C110.1 480 128 462.1 128 440v-208C128 209.9 110.1 192 88 192zM96 440C96 444.4 92.41 448 88 448h-48C35.59 448 32 444.4 32 440v-208C32 227.6 35.59 224 40 224h48C92.41 224 96 227.6 96 232V440zM512 221.5C512 187.6 484.4 160 450.5 160h-102.5c11.98-27.06 18.83-53.48 18.83-67.33C366.9 62.84 343.6 32 304.9 32c-41.22 0-50.7 29.11-59.12 54.81C218.1 171.1 160 184.8 160 208C160 217.1 167.5 224 176 224C180.1 224 184.2 222.4 187.3 219.3c52.68-53.04 67.02-56.11 88.81-122.5C285.3 68.95 288.2 64 304.9 64c20.66 0 29.94 16.77 29.94 28.67c0 10.09-8.891 43.95-26.62 75.48c-1.366 2.432-2.046 5.131-2.046 7.83C306.2 185.5 314 192 322.2 192h128.3C466.8 192 480 205.2 480 221.5c0 15.33-12.08 28.16-27.48 29.2c-8.462 .5813-14.91 7.649-14.91 15.96c0 12.19 12.06 12.86 12.06 30.63c0 14.14-10.11 26.3-24.03 28.89c-5.778 1.082-13.06 6.417-13.06 15.75c0 8.886 6.765 10.72 6.765 23.56c0 31.02-31.51 22.12-31.51 43.05c0 3.526 1.185 5.13 1.185 10.01C389 434.8 375.8 448 359.5 448H303.9c-82.01 0-108.3-64.02-127.9-64.02c-8.873 0-16 7.193-16 15.96C159.1 416.3 224.6 480 303.9 480h55.63c33.91 0 61.5-27.58 61.5-61.47c18.55-10.86 30.33-31 30.33-53.06c0-4.797-.5938-9.594-1.734-14.27c19.31-10.52 32.06-30.97 32.06-53.94c0-7.219-1.281-14.31-3.75-20.98C498.2 266.2 512 245.3 512 221.5z" />
                  </svg>
                  <?php _e('دوست داشتم', 'kelaketfilm'); ?>
                  <?php
                  if(theme_options('post_like_count')):
                    $likes = get_post_meta(get_the_ID(), 'kelaket_likes', true);
                    $dis_likes = get_post_meta(get_the_ID(), 'kelaket_dislikes', true);
                  endif;
                  ?>
                  <?php if(theme_options('post_like_count')): ?>
                  <span class="count_like">(<?php echo $likes ? $likes : 0 ?>)</span>
                  <?php endif;?>
                </button>
                <button data-vote_system="<?php echo theme_options('post_like_system') ?>" data-postid="<?php echo get_the_ID() ?>" data-userid="<?php echo get_current_user_id() ?>" data-action="dislike" data-nonce="<?php echo wp_create_nonce('post_vote') ?>" class="post_vote_down">
                  <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                    <path d="M128 280v-208C128 49.94 110.1 32 88 32h-48C17.94 32 0 49.94 0 72v208C0 302.1 17.94 320 40 320h48C110.1 320 128 302.1 128 280zM96 280C96 284.4 92.41 288 88 288h-48C35.59 288 32 284.4 32 280v-208C32 67.59 35.59 64 40 64h48C92.41 64 96 67.59 96 72V280zM477.9 235.7c2.469-6.672 3.75-13.77 3.75-20.98c0-22.97-12.75-43.42-32.06-53.94c1.141-4.672 1.734-9.469 1.734-14.27c0-22.06-11.78-41.94-30.33-52.8C421 59.84 393.4 32 359.5 32H303.9c-77.41 0-143.9 63.11-143.9 80.07c0 8.767 7.133 15.96 16 15.96C195.8 128 222.2 64 303.9 64h55.63c16.27 0 29.5 13.22 29.5 29.47c0 4.826-1.185 6.491-1.185 10.01c0 20.94 31.51 12.09 31.51 43.05c0 12.84-6.765 14.68-6.765 23.56c0 9.347 7.255 14.66 13.06 15.75c13.92 2.594 24.03 14.75 24.03 28.89c0 17.77-12.06 18.45-12.06 30.63c0 8.314 6.443 15.38 14.91 15.96C467.9 262.4 480 275.2 480 290.5C480 306.8 466.8 320 450.5 320h-128.3c-8.273 0-15.1 6.658-15.1 16.01c0 2.699 .68 5.398 2.046 7.83c17.73 31.53 26.62 65.39 26.62 75.48C334.9 431.2 325.6 448 304.9 448c-16.7 0-19.66-4.953-28.78-32.78c-21.79-66.41-36.14-69.47-88.81-122.5C184.2 289.6 180.1 288 176 288C167.4 288 160 294.9 160 303.1c0 23.25 57.94 36.53 85.73 121.2C254.2 450.9 263.6 480 304.9 480c38.77 0 62.01-30.84 62.01-60.67c0-13.84-6.844-40.27-18.83-67.33h102.5C484.4 352 512 324.4 512 290.5C512 266.8 498.2 245.8 477.9 235.7z" />
                  </svg>
                  <?php _e('دوست نداشتم', 'kelaketfilm'); ?>
                  <?php if(theme_options('post_like_count')): ?>
                    <span class="count_dislike">(<?php echo $dis_likes ? $dis_likes : 0 ?>)</span>
                  <?php endif; ?>
                </button>


                <div class="vote_stats">
                  <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                    <path d="M88 192h-48C17.94 192 0 209.9 0 232v208C0 462.1 17.94 480 40 480h48C110.1 480 128 462.1 128 440v-208C128 209.9 110.1 192 88 192zM96 440C96 444.4 92.41 448 88 448h-48C35.59 448 32 444.4 32 440v-208C32 227.6 35.59 224 40 224h48C92.41 224 96 227.6 96 232V440zM512 221.5C512 187.6 484.4 160 450.5 160h-102.5c11.98-27.06 18.83-53.48 18.83-67.33C366.9 62.84 343.6 32 304.9 32c-41.22 0-50.7 29.11-59.12 54.81C218.1 171.1 160 184.8 160 208C160 217.1 167.5 224 176 224C180.1 224 184.2 222.4 187.3 219.3c52.68-53.04 67.02-56.11 88.81-122.5C285.3 68.95 288.2 64 304.9 64c20.66 0 29.94 16.77 29.94 28.67c0 10.09-8.891 43.95-26.62 75.48c-1.366 2.432-2.046 5.131-2.046 7.83C306.2 185.5 314 192 322.2 192h128.3C466.8 192 480 205.2 480 221.5c0 15.33-12.08 28.16-27.48 29.2c-8.462 .5813-14.91 7.649-14.91 15.96c0 12.19 12.06 12.86 12.06 30.63c0 14.14-10.11 26.3-24.03 28.89c-5.778 1.082-13.06 6.417-13.06 15.75c0 8.886 6.765 10.72 6.765 23.56c0 31.02-31.51 22.12-31.51 43.05c0 3.526 1.185 5.13 1.185 10.01C389 434.8 375.8 448 359.5 448H303.9c-82.01 0-108.3-64.02-127.9-64.02c-8.873 0-16 7.193-16 15.96C159.1 416.3 224.6 480 303.9 480h55.63c33.91 0 61.5-27.58 61.5-61.47c18.55-10.86 30.33-31 30.33-53.06c0-4.797-.5938-9.594-1.734-14.27c19.31-10.52 32.06-30.97 32.06-53.94c0-7.219-1.281-14.31-3.75-20.98C498.2 266.2 512 245.3 512 221.5z" />
                  </svg>
                  <?php $post_votes = get_post_votes(get_the_ID()); ?>
                  <span><?php echo $post_votes['percent']; ?>%</span>
                  <small>(<?php echo $post_votes['totalVotes'] ?> <?php _e('رای', 'kelaketfilm') ?>)</small>
                </div>
              </div>

              <?php if (get_field('metacritic')) : ?>
                <div class="movie_score">
                  <?php the_field('metacritic') ?>
                  <img width="25" height="25" src="<?php echo get_template_directory_uri(); ?>/images/metacritic-icon.svg">
                </div>
              <?php endif; ?>
              <?php if (get_field('rotten')) : ?>
                <div class="movie_score">
                  <?php the_field('rotten') ?>%
                  <img width="25" height="25" src="<?php echo get_template_directory_uri(); ?>/images/rotten.svg">
                </div>
              <?php endif; ?>
            </div>
        
          </div>

        </div>
        <?php if (get_field('rel_date')) : ?>
          <div class="py-3">
            <h2><?php _e('لحظه شمار انتشار', 'kelaketfilm') ?></h2>
            <div class="countdown show" data-Date='<?= get_field('rel_date'); ?>'>
              <div class="running">
                <div class="timer">
                  <div>
                    <span class="days"></span>
                    <div class="counter_label"><?php _e('روز', 'kelaketfilm') ?></div>
                  </div>
                  <div>
                    <span class="hours"></span>
                    <div class="counter_label"><?php _e('ساعت', 'kelaketfilm') ?></div>
                  </div>
                  <div>
                    <span class="minutes"></span>
                    <div class="counter_label"><?php _e('دقیقه', 'kelaketfilm') ?></div>
                  </div>
                  <div>
                    <span class="seconds"></span>
                    <div class="counter_label"><?php _e('ثانیه', 'kelaketfilm') ?></div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        <?php endif; ?>

        <?php if (!empty(get_the_content())) : ?>
          <section class="content my-3 mb-4">
            <header class="section__title mb-2">
              <h3><i class="fa fa-pencil"></i> <?php _e('توضیحات', 'kelaketfilm') ?> <?= $post_type; ?></h3>
            </header>
            <div class="content_inner post_inner">
              <?php the_content(); ?>
            </div>
          </section>
        <?php endif; ?>


        <?php
        $related_blog_posts = get_field('related_blog_post');
        if ($related_blog_posts) : ?>
          <div class="related_post_blog mt-3">
            <div class="row">
              <?php foreach ($related_blog_posts as $blog_post) : ?>
                <div class="col-xxl-4 col-xl-4 col-lg-6 col-md-6 col-sm-6">
                  <article class="related_post_blog_item">
                    <div class="icon">
                      <?php bloginfo('name'); ?> <span>مگ</span>
                    </div>
                    <header>
                      <?php echo $blog_post->post_title; ?>
                    </header>
                    <p>
                      <?php echo substr_replace($blog_post->post_excerpt, "...", 353) ?>
                    </p>
                    <div>
                      <a href="<?php echo $blog_post->guid ?>"> <?php _e('ادامه مطلب', 'kelaketfilm') ?></a>
                    </div>
                  </article>
                </div>
              <?php endforeach; ?>
            </div>
          </div>
        <?php endif; ?>



        <?php
        if ($config['show_actors']) :

          $actors = get_field('actors');
          $director = get_field('director');
          if ($actors || $director) :
        ?>
            <section class="content cast my-4">
              <header class="section__title mb-2">
                <h3><i class="fa fa-user-crown"></i> <?php _e('عوامل', 'kelaketfilm') ?> <?= $post_type; ?></h3>
              </header>
              <div class="owl-carousel single_cast">
                <?php

                if ($actors) :
                  foreach ($actors as $actor) :
                ?>
                    <section class="stars">
                      <a href="<?php echo esc_url(get_term_link($actor)) ?>">
                        <?php if (get_field('actor_image_link', $actor)) { ?>
                          <img width="150" height="150" src="<?php echo get_field('actor_image_link', $actor) ?>" onerror="this.onerror=null; this.src='<?php echo get_template_directory_uri(); ?>/images/no_img.png';" alt="<?php echo $actor->name; ?>" title="<?php echo $actor->name; ?>" />
                        <?php } else { ?>
                          <img width="150" height="150" src="<?php echo get_template_directory_uri(); ?>/images/no_img.png" alt="no-image" />
                        <?php } ?>
                        <div class="stars_title">
                          <?php echo $actor->name; ?>
                          <div><small><?php _e('بازیگر', 'kelaketfilm') ?></small></div>
                        </div>
                      </a>
                    </section>
                  <?php endforeach;
                endif;
                if ($director) :
                  foreach ($director as $direct) :
                  ?>
                    <section class="stars">
                      <a href="<?php echo esc_url(get_term_link($direct)) ?>">
                        <?php if (get_field('actor_image_link', $direct)) { ?>
                          <img width="130" height="130" src="<?php echo get_field('actor_image_link', $direct) ?>" onerror="this.onerror=null; this.src='<?php echo get_template_directory_uri(); ?>/images/no_img.png';" alt="<?php echo $direct->name; ?>" title="<?php echo $direct->name; ?>" />
                        <?php } else { ?>
                          <img width="130" height="130" src="<?php echo get_template_directory_uri(); ?>/images/no_img.png" alt="no-image" />
                        <?php } ?>
                        <div class="stars_title">
                          <?php echo $direct->name; ?>
                          <div><small><?php _e('کارگردان', 'kelaketfilm') ?></small></div>
                        </div>
                      </a>
                    </section>
                <?php endforeach;
                endif; ?>
              </div>
            </section>
        <?php endif;
        endif; ?>
        <section class="content cast my-4">
          <header class="section__title dl__title mb-2">
            <ul class="nav nav-pills" id="pills-tab" role="tablist">
              <li class="nav-item" role="presentation">
                <button class="nav-link active" id="pills-dl-tab" data-bs-toggle="pill" data-bs-target="#pills-dl" type="button" role="tab" aria-controls="pills-home" aria-selected="true"><?php _e('لینک های دانلود', 'kelaketfilm') ?></button>
              </li>
              <?php if (get_field('trailer')) : ?>
                <li class="nav-item" role="presentation">
                  <button class="nav-link" id="pills-trailer-tab" data-bs-toggle="pill" data-bs-target="#pills-trailer" type="button" role="tab" aria-controls="pills-profile" aria-selected="false"><?php _e('تریلر', 'kelaketfilm') ?></button>
                </li>
              <?php endif; ?>
              <?php if (get_field('gallery')) : ?>
                <li class="nav-item" role="presentation">
                  <button class="nav-link" id="pills-gallery-tab" data-bs-toggle="pill" data-bs-target="#pills-gallery" type="button" role="tab" aria-controls="pills-contact" aria-selected="false"><?php _e('گالری تصاویر', 'kelaketfilm') ?></button>
                </li>
              <?php endif; ?>
              <?php if (get_the_tags()) : ?>
                <li class="nav-item" role="presentation">
                  <button class="nav-link" id="pills-tags-tab" data-bs-toggle="pill" data-bs-target="#pills-tags" type="button" role="tab" aria-controls="pills-tags" aria-selected="false"><?php _e('برچسب ها', 'kelaketfilm') ?></button>
                </li>
              <?php endif; ?>
            </ul>
            <span><i class="fa-regular fa-star"></i>
              <?php
              if (get_field('internet') == 'half') {
                _e('حجم مصرفی شما نیم بها محاسبه می‌شود.', 'kelaketfilm');
              } else {
                _e('حجم مصرفی شما عادی محاسبه می‌شود.', 'kelaketfilm');
              }
              ?>

            </span>
          </header>

          <!-- tab_content -->
          <div class="tab-content" id="pills-tabContent">
            <div class="tab-pane fade show active" id="pills-dl" role="tabpanel" aria-labelledby="pills-dl-tab" tabindex="0">
              <?php get_template_part('inc/template_parts/single/tabs/download', null, array(
                'justIranOption' => $justIranOption,
                'userFromIran'  => $userFromIran
              )) ?>
            </div>
            <div class="tab-pane fade" id="pills-trailer" role="tabpanel" aria-labelledby="pills-trailer-tab" tabindex="0">
              <?php get_template_part('inc/template_parts/single/tabs/trailer') ?>
            </div>
            <div class="tab-pane fade" id="pills-gallery" role="tabpanel" aria-labelledby="pills-gallery-tab" tabindex="0">
              <?php get_template_part('inc/template_parts/single/tabs/gallery') ?>
            </div>
            <div class="tab-pane fade" id="pills-tags" role="tabpanel" aria-labelledby="pills-tags-tab" tabindex="0">
              <?php get_template_part('inc/template_parts/single/tabs/tags') ?>
            </div>
          </div>
          <!-- tab_content -->
  
        </section><!-- /.content -->
        <!-- report buttons -->
        <div class="report text-end">
          <button data-bs-toggle="modal" data-bs-target="#exampleModal"><i class="fa fa-flag"></i><?php _e('گزارش خرابی لینک', 'kelaketfilm') ?></button>
          <button class="share" data-bs-toggle="modal" data-bs-target="#shareModal"><i class="fa fa-share-nodes"></i><?php _e('اشتراک گذاری', 'kelaketfilm') ?></button>
        </div>
        <!-- report buttons -->
      </article>

      <?php if (get_field('collection_id')) : ?>
        <section class="collection_content overflow-hidden position-relative single__content my-3 mb-4">
          <img class="position-absolute collection_mask" src="<?php echo get_the_post_thumbnail_url(); ?>)" />
          <div class="row align-items-center position-relative">
            <div class="col-xxl-3 col-xl-3 col-lg-4 col-sm-4">
              <div class="collection_title">
                <div class="from"><?php _e('از کالکشن', 'kelaketfilm') ?></div>
                <div class="name"><?= get_cat_name(get_field('collection_id')) ?></div>
                <a href="<?= get_category_link(get_field('collection_id')); ?>" class="btn btn-orange"><?php _e('مشاهده همه', 'kelaketfilm') ?></a>
              </div>
            </div>
            <div class="col-xxl-9 col-xl-9 col-lg-8 col-sm-8">
              <div class="row flex-row-reverse g-2">
                <!-- collction posts -->
                <?php
                $related = get_posts(array('numberposts' => 4, 'category__in' => get_field('collection_id')));

                if ($related) foreach ($related as $post) {
                  setup_postdata($post); ?>
                  <div class="col-xxl-3 col-xl-3 col-lg-3 col-md-3 col-sm-6 col-6">
                    <div class="related_film_item">
                      <a href="<?php the_permalink() ?>">
                        <?php the_post_thumbnail('rel_item'); ?>
                        <h5><?php the_title(); ?></h5>
                        <div class="related_rotten">
                          <i class="fa-regular fa-thumbs-up"></i>
                          <?php echo get_post_votes(get_the_ID())['percent'] . '% رضایت'; ?>
                        </div>
                      </a>
                    </div>
                  </div>
                <?php }
                wp_reset_postdata(); ?>
                <!-- /END Collection posts -->
              </div>
            </div>
          </div>
        </section>
      <?php endif; ?>
      <section class="content single__content my-3 mb-4">
        <header class="section__title mb-2">
          <h3><i style="margin-left: 5px; vertical-align:middle;" class="fa fa-clapperboard"></i><?php _e('پیشنهادات بر اساس', 'kelaketfilm'); ?>  <?php the_title(); ?></h3>
        </header>
        <div class="content_inner py-3 px-3">
          <div class="owl-carousel rel_posts">

            <?php
            $terms = get_the_terms($post->ID, 'genre', 'string');
            //Pluck out the IDs to get an array of IDS
            $term_ids = wp_list_pluck($terms, 'term_id');

            $genre_query = new WP_Query(array(
              'post_type' => 'post',
              'tax_query' => array(
                array(
                  'taxonomy' => 'genre',
                  'field' => 'id',
                  'terms' => $term_ids,
                  'operator' => 'IN' //Or 'AND' or 'NOT IN'
                )
              ),
              'posts_per_page' => $config['count_relpots'],
              'ignore_sticky_posts' => 1,
              'orderby' => 'rand',
              'post__not_in' => array($post->ID)
            ));

            if ($genre_query->have_posts()) {
              while ($genre_query->have_posts()) : $genre_query->the_post();
            ?>
            <?php 
            if(theme_options('film_card_style') == 'style1'):
              get_template_part('/inc/template_parts/cards/film_card');
            elseif(theme_options('film_card_style') == 'style2'):
              get_template_part('/inc/template_parts/cards/film_card2');
            elseif(theme_options('film_card_style') == 'style3'):
                get_template_part('/inc/template_parts/cards/film_card3');
            endif;
            ?>
            <?php endwhile;
            }
            wp_reset_query(); ?>
          </div>
        </div>
      </section>

      <!-- lists -->
      <?php
      global $wpdb;
      $tablename = $wpdb->prefix . 'kelaket_lists';
      $post_id = get_the_ID();

      $qry = "select * from $tablename WHERE is_private = false AND FIND_IN_SET($post_id, films) ORDER BY id DESC LIMIT 6";
      $result = $wpdb->get_results($qry);
      if ($result) :
      ?>
        <section class="content single__content my-3 mb-4">
          <header class="section__title mb-2">
            <h3><i style="vertical-align:middle; margin-left:5px" class="fa fa-list"></i> <?php _e('لیست های مرتبط با', 'kelaketfilm') ?> <?php the_title(); ?></h3>
          </header>
          <div class="content_inner py-3 px-3">
            <div class="owl-carousel lists_carousel">
              <?php
              foreach ($result as $item) :
                $user = get_user_by('id', $item->user_id);
                $films = explode(',', $item->films);
                if (empty($films[0])) {
                  $count = 0;
                } else {
                  $count = count($films);
                }
                // fix first image issue due the first index of array alwasy empty 
                if (!get_the_post_thumbnail_url($films[0], 'post_retina')) {
                  $firstImage = get_template_directory_uri() . '/images/nocover.jpeg';
                } else {
                  $firstImage = get_the_post_thumbnail_url($films[0], 'post_retina');
                }
              ?>
                <div class="">
                  <div class="custom_list single_list modern_list">
                    <a href="<?php echo site_url() . "/lists/$item->id" ?>">
                      <div class="custom_list_images">
                        <div>
                          <img width="120" height="120" src="<?php echo $firstImage ?>" alt="">
                          <img width="120" height="120" src="<?php echo checkIndexExists($films, 1) ?  get_the_post_thumbnail_url($films[1], 'post_retina') : get_template_directory_uri() . '/images/nocover.jpeg' ?>" alt="">
                        </div>
                        <div>
                          <img width="120" height="120" src="<?php echo checkIndexExists($films, 2) ? get_the_post_thumbnail_url($films[2], 'post_retina') : get_template_directory_uri() . '/images/nocover.jpeg' ?>" alt="">
                          <img width="120" height="120" src="<?php echo checkIndexExists($films, 3) ? get_the_post_thumbnail_url($films[3], 'post_retina') : get_template_directory_uri() . '/images/nocover.jpeg' ?>" alt="">
                        </div>
                      </div>
                    </a>
                    <h3>
                      <a data-bs-toggle='tooltip' data-bs-placement='top' title="<?php echo $item->name; ?>" class="list" href="<?php echo site_url() . "/lists/$item->id" ?>"><?php echo limited_excerpt($item->name, 20) ?></a>
                      <?php _e('توسط', 'kelaketfilm') ?>
                      <a class="author" href="<?php echo bloginfo('url') . '/profile/' . $user->user_login;  ?>"><?php echo $user->display_name; ?></a>
                    </h3>
                    <div class="custom_list_meta">
                      <span><?php _e('تعداد:', 'kelaketfilm') ?> <?php echo $count; ?></span>
                      <?php
                      //check if post updated show date as tooltip
                      if ($item->updated_at == '0000-00-00 00:00:00') {
                        $update = "";
                      } else {
                        $update = __('آخرین بروزرسانی: ', 'kelaketfilm') . mysql2date(' F j, Y', $item->updated_at);
                      }
                      ?>
                      <span data-bs-toggle='tooltip' data-bs-placement='top' title="<?php echo $update; ?>"><?php echo  mysql2date(' F j, Y', $item->created_at) ?></span>
                    </div>
                  </div>
                </div>
              <?php endforeach; ?>
            </div>
          </div>
        </section>
      <?php endif; ?>
      <!-- lists -->

      <section class="content single__content my-3 mb-4">
        <header class="section__title mb-2">
          <h3><i style="vertical-align:middle; margin-left: 5px" class="fa fa-comment-dots"></i> <?php _e('نظرات', 'kelaketfilm') ?></h3>
        </header>
        <div class="content_inner py-2 px-2">
          <section class="comments modern">
            <div class="comments_inner">
              <?php
              if (comments_open()) {
                comments_template();
              }
              ?>
            </div>
          </section>
        </div>
      </section>

    </div>

    <div class="col-xl-3 col-lg-4 col-md-12 col-sm-12 col-xs-12 col-xxl-3">



      <?php if (function_exists('dynamic_sidebar') && dynamic_sidebar('single')) : else : ?>
      <?php endif; ?>

      <?php if ($config['instagram']) { ?>
        <div class="instagram_b">
          <a href="<?php echo $config['instagram']; ?>">
            <i class="fa-brands fa-instagram"></i>
            <span><?php _e('صفحه اینستاگرام', 'kelaketfilm') ?></span>
            <i class="fa fa-angles-left left"></i>
          </a>
        </div>
      <?php } ?>

      <?php if ($config['telegram']) { ?>
        <div class="telegram_b">
          <a href="<?php echo $config['telegram']; ?>">
            <i class="fa-brands fa-telegram"></i>
            <span><?php _e('کانال تلگرام', 'kelaketfilm') ?></span>
            <i class="fa fa-angles-left left"></i>
          </a>
        </div>
      <?php } ?>

      <?php if ($config['appBanner']) : ?>
        <div class="mobile_b">
          <a href="<?php echo $config['app_link'] ?>">
            <i class="fa fa-mobile-button"></i>
            <span><?php echo $config['app_text'] ?></span>
            <i class="fa fa-angles-left left"></i>
          </a>
        </div>
      <?php endif; ?>

    </div>


  </div>
</div>
</div>