<section class="featured">
    <div class="container">
      <div id="owl-carousel" class="owl-carousel">
        <?php
        if(isset(get_queried_object()->term_id)){
          $cat_id = get_queried_object()->term_id;
        }else{
          $cat_id = '';
        }

        $args = array(
          'showposts' => theme_options('count_slider'),
          'meta_key'    => 'slider',
          'meta_value'  => true,
          'cat' => $cat_id
        );
        $the_query = new WP_Query($args);
        while ($the_query->have_posts()) : $the_query->the_post(); ?>
          <a href="<?php the_permalink() ?>">
            <div class="featured_item">
              <?php the_post_thumbnail('sliderr-thumb'); ?>
              <div class="featured_item_hover">
                <div class="featured_item_likes">
                  <i class="fa fa-thumbs-up"></i>
                  <?php echo get_post_votes(get_the_ID())['percent'] . '%'; ?>
                  <?php if (get_field('imdbRating')) : ?>
                    <span class="featured_item_imdb">
                      IMDb
                      <?php the_field('imdbRating') ?>
                    </span>
                  <?php endif; ?>
                </div>
                <h2><?php the_title(); ?></h2>
                <div class="description"><?php the_field('last-episode'); ?></div>
                <?php
                $badge_color = 'bg-success';
                if (get_field('slider-badge-color')) {
                  if (get_field('slider-badge-color') == 'red') {
                    $badge_color = 'bg-danger';
                  } elseif (get_field('slider-badge-color') == 'green') {
                    $badge_color = 'bg-success';
                  } elseif (get_field('slider-badge-color') == 'yellow') {
                    $badge_color = 'bg-warning text-dark';
                  } elseif (get_field('slider-badge-color') == 'blue') {
                    $badge_color = 'bg-info text-dark';
                  }
                }
                ?>
                <div class="badge <?php echo $badge_color; ?>"><?php the_field('slider-badge'); ?></div>
                <p><?php echo limited_excerpt(get_field('story') ? get_field('story') : get_field('about') , 270) ?></p>
              </div>
            </div>
          </a>
        <?php endwhile; ?>
        <?php wp_reset_query(); ?>
      </div>
    </div>
  </section>