<?php
if (theme_options('slider_type') == 'carousel') :
?>
  <section class="featured">
    <div class="container">
      <div id="owl-carousel" class="owl-carousel">
        <?php
        $args = array(
          'showposts' => 8,
          'meta_key'    => 'slider',
          'meta_value'  => true
        );
        $the_query = new WP_Query($args);
        while ($the_query->have_posts()) : $the_query->the_post(); ?>
          <a href="<?php the_permalink() ?>">
            <div class="featured_item">
              <?php the_post_thumbnail('sliderr-thumb'); ?>
              <div class="featured_item_hover">
                <div class="featured_item_likes">
                  <i class="bi bi-heart-fill"></i>
                  <?php
                  if (get_field('rotten')) {
                    the_field('rotten');
                  } else {
                    echo '۰';
                  }
                  ?>%
                  <?php if (get_field('imdbRating')) : ?>
                    <span class="featured_item_imdb">
                      IMDb
                      <?php the_field('imdbRating') ?>
                    </span>
                  <?php endif; ?>
                </div>
                <h2><?php the_title(); ?></h2>
                <div class="description"><?php the_field('last-episode'); ?></div>
                <?php
                $badge_color = 'bg-success';
                if (get_field('slider-badge-color')) {
                  if (get_field('slider-badge-color') == 'red') {
                    $badge_color = 'bg-danger';
                  } elseif (get_field('slider-badge-color') == 'green') {
                    $badge_color = 'bg-success';
                  } elseif (get_field('slider-badge-color') == 'yellow') {
                    $badge_color = 'bg-warning text-dark';
                  } elseif (get_field('slider-badge-color') == 'blue') {
                    $badge_color = 'bg-info text-dark';
                  }
                }
                ?>
                <div class="badge <?php echo $badge_color; ?>"><?php the_field('slider-badge'); ?></div>
                <p><?php the_field('about'); ?></p>
              </div>
            </div>
          </a>
        <?php endwhile; ?>
        <?php wp_reset_query(); ?>
      </div>
    </div>
  </section>
<?php elseif (theme_options('slider_type') == 'slider') : ?>
  <section class="slider">
    <div id="owl-slider" class="owl-carousel">
      <?php
      $args = array(
        'showposts' => 5,
        'meta_key'    => 'slider',
        'meta_value'  => true
      );
      $the_query = new WP_Query($args);
      while ($the_query->have_posts()) : $the_query->the_post(); ?>
        <?php
        $video = get_field('slider_video');
        $has_video = $video ? 'video' : '';
        ?>
        <div class="slider_item <?php echo $has_video ?>">
          <?php
          if (get_field('slider_video')) : ?>
            <video>
              <source type="video/mp4" src="<?php the_field('slider_video') ?>">
            </video>
          <?php else : ?>
            <img class="" src="<?php the_field('slider_image') ?>" alt="<?php the_title(); ?>">
          <?php endif; ?>
          <div class="slider_info">
            <?php if (get_field('film_logo')) : ?>
              <img class="film_logo" src="<?php the_field('film_logo') ?>" alt="<?php the_title(); ?>">
            <?php else : ?>
              <h2><?php the_title(); ?></h2>
            <?php endif; ?>
            <div class="description"><?php the_field('last-episode'); ?></div>
            <p><?php the_field('story'); ?></p>

            <?php if (get_field('slider_button')) : ?>
              <a class="slider_link" href="<?php the_permalink(); ?>"><?php the_field('slider_button'); ?></a>
            <?php else : ?>
              <a class="slider_link" href="<?php the_permalink(); ?>">تماشای فیلم</a>
            <?php endif; ?>
          </div>
          <div class="mask_gradient"></div>
        </div>
      <?php endwhile; ?>
      <?php wp_reset_query(); ?>
    </div>
  </section>
<?php elseif (theme_options('slider_type') == 'carousel2') : ?>
  <section class="featured2">
    <div class="container">
      <div class="row g-3">
        <?php
        $args = array(
          'showposts' => 8,
          'meta_key'    => 'slider',
          'meta_value'  => true
        );
        $the_query = new WP_Query($args);
        while ($the_query->have_posts()) : $the_query->the_post(); ?>
          <div class="col-xxl-3 col-xl-3 col-lg-4 col-md-6 col-sm-6 col-4">
            <a href="<?php the_permalink() ?>">
              <div class="featured_item2">
                <?php 
                if(get_field('slider_image')){?>
                  <img width="312" height="200" alt="<?php the_title(); ?>" src="<?php the_field('slider_image') ?>" alt="<?php the_title(); ?>">
                <?php }else{
                  the_post_thumbnail();
                }?>
                <div class="featured_item2_hover">
                  <div class="featured_item_likes">
                    <i class="bi bi-heart-fill"></i>
                    <?php
                    if (get_field('rotten')) {
                      the_field('rotten');
                    } else {
                      echo '۰';
                    }
                    ?>%
                    <?php if (get_field('imdbRating')) : ?>
                      <span class="featured_item_imdb">
                        IMDb
                        <?php the_field('imdbRating') ?>
                      </span>
                    <?php endif; ?>
                  </div>
                  <h2><?php the_title(); ?></h2>
                  <div class="description"><?php the_field('last-episode'); ?></div>
                  <?php
                  $badge_color = 'bg-success';
                  if (get_field('slider-badge-color')) {
                    if (get_field('slider-badge-color') == 'red') {
                      $badge_color = 'bg-danger';
                    } elseif (get_field('slider-badge-color') == 'green') {
                      $badge_color = 'bg-success';
                    } elseif (get_field('slider-badge-color') == 'yellow') {
                      $badge_color = 'bg-warning text-dark';
                    } elseif (get_field('slider-badge-color') == 'blue') {
                      $badge_color = 'bg-info text-dark';
                    }
                  }
                  ?>
                  <div class="badge <?php echo $badge_color; ?>"><?php the_field('slider-badge'); ?></div>
                </div>
              </div>
            </a>
          </div>
        <?php endwhile; ?>
        <?php wp_reset_query(); ?>
      </div>
    </div>
  </section>
<?php endif; ?>