<?php
if (!defined('ABSPATH')) {
  exit; // Exit if accessed directly.
}

/**
 * Elementor oEmbed Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class AboutUs_Element extends \Elementor\Widget_Base
{

  /**
   * Get widget name.
   *
   * Retrieve oEmbed widget name.
   *
   * @since 1.0.0
   * @access public
   * @return string Widget name.
   */
  public function get_name()
  {
    return 'about_us';
  }

  /**
   * Get widget title.
   *
   * Retrieve oEmbed widget title.
   *
   * @since 1.0.0
   * @access public
   * @return string Widget title.
   */
  public function get_title()
  {
    return esc_html__('المان درباره ما', 'elementor-ads-widget');
  }

  /**
   * Get widget icon.
   *
   * Retrieve oEmbed widget icon.
   *
   * @since 1.0.0
   * @access public
   * @return string Widget icon.
   */
  public function get_icon()
  {
    return 'eicon-info-circle-o';
  }

  /**
   * Get custom help URL.
   *
   * Retrieve a URL where the user can get more information about the widget.
   *
   * @since 1.0.0
   * @access public
   * @return string Widget help URL.
   */
  public function get_custom_help_url()
  {
    return 'https://developers.elementor.com/docs/widgets/';
  }

  /**
   * Get widget categories.
   *
   * Retrieve the list of categories the oEmbed widget belongs to.
   *
   * @since 1.0.0
   * @access public
   * @return array Widget categories.
   */
  public function get_categories()
  {
    return ['header'];
  }

  /**
   * Get widget keywords.
   *
   * Retrieve the list of keywords the oEmbed widget belongs to.
   *
   * @since 1.0.0
   * @access public
   * @return array Widget keywords.
   */
  public function get_keywords()
  {
    return ['header', 'logo'];
  }

  /**
   * Register oEmbed widget controls.
   *
   * Add input fields to allow the user to customize the widget settings.
   *
   * @since 1.0.0
   * @access protected
   */
  protected function register_controls()
  {

    $this->start_controls_section(
      'content_section',
      [
        'label' => esc_html__('تنظیمات', 'elementor-ads-widget'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'logo',
      [
        'label' => esc_html__('نمایش لوگو', 'plugin-name'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => esc_html__('بله', 'your-plugin'),
        'label_off' => esc_html__('خیر', 'your-plugin'),
        'return_value' => true,
        'default' => true,
      ]
    );

    $this->add_control(
      'social',
      [
        'label' => esc_html__('نمایش شبکه های اجتماعی', 'plugin-name'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => esc_html__('بله', 'your-plugin'),
        'label_off' => esc_html__('خیر', 'your-plugin'),
        'return_value' => true,
        'default' => true,
      ]
    );


    $this->end_controls_section();
  }

  /**
   * Render oEmbed widget output on the frontend.
   *
   * Written in PHP and used to generate the final HTML.
   *
   * @since 1.0.0
   * @access protected
   */
  protected function render()
  {
    $settings = $this->get_settings_for_display();
    $config = get_option('my_framework');
    $logo = $settings['logo'];
    $social = $settings['social'];
?>
    <div class="about">
      <?php if($logo): ?>
      <div class="logo">
        <a href="<?php bloginfo('url') ?>">
          <?php if ($config['logo_image']['url']) : ?>
            <img src="<?php echo $config['logo_image']['url']; ?>" alt="logo" class="logo_img" />
          <?php else : ?>
            <img src="<?php echo get_template_directory_uri(); ?>/images/logo.png" alt="logo" class="logo_img" />
          <?php endif; ?>
          <span><?php echo $config['logo_text']; ?></span>
        </a>
      </div>
      <?php endif; ?>
      <p><?php echo $config['about']; ?></p>
      <?php if($social): ?>
      <div class="social">
        <ul>
          <?php if ($config['instagram']) { ?><li class="instagram"><a href="<?php echo $config['instagram'] ?>"><i class="bi bi-instagram"></i></a></li><?php } ?>
          <?php if ($config['twitter']) { ?><li class="twitter"><a href="<?php echo $config['twitter'] ?>"><i class="bi bi-twitter"></i></a></li><?php } ?>
          <?php if ($config['facebook']) { ?><li class="facebook"><a href="<?php echo $config['facebook'] ?>"><i class="bi bi-facebook"></i></a></li><?php } ?>
          <?php if ($config['youtube']) { ?><li class="youtube"><a href="<?php echo $config['youtube'] ?>"><i class="bi bi-youtube"></i></a></li><?php } ?>
          <?php if ($config['telegram']) { ?><li class="telegram"><a href="<?php echo $config['telegram'] ?>"><i class="bi bi-telegram"></i></a></li><?php } ?>
          <?php if ($config['skype']) { ?><li class="skype"><a href="<?php echo $config['skype'] ?>"><i class="bi bi-skype"></i></a></li><?php } ?>
          <?php if ($config['discord']) { ?><li class="discord"><a href="<?php echo $config['discord'] ?>"><i class="bi bi-discord"></i></a></li><?php } ?>
        </ul>
      </div>
      <?php endif; ?>
    </div>
<?php
  }
}
