<?php
if (!defined('ABSPATH')) {
  exit; // Exit if accessed directly.
}

/**
 * Elementor oEmbed Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class CategoryCarousel_widget extends \Elementor\Widget_Base
{

  public function __construct($data = [], $args = null) {
    parent::__construct($data, $args);

    wp_register_script( 'categoryCarousel', get_template_directory_uri() . '/js/carousel.elementor.js', [ 'elementor-frontend', 'jquery', 'owl' ], '1.0.0', true );
  }

  public function get_script_depends() {
    return [ 'categoryCarousel' ];
  }

  /**
   * Get widget name.
   *
   * Retrieve oEmbed widget name.
   *
   * @since 1.0.0
   * @access public
   * @return string Widget name.
   */
  public function get_name()
  {
    return 'categoryCarousel';
  }

  /**
   * Get widget title.
   *
   * Retrieve oEmbed widget title.
   *
   * @since 1.0.0
   * @access public
   * @return string Widget title.
   */
  public function get_title()
  {
    return esc_html__('ویجت کروسل مطالب دسته', 'elementor-ads-widget');
  }

  /**
   * Get widget icon.
   *
   * Retrieve oEmbed widget icon.
   *
   * @since 1.0.0
   * @access public
   * @return string Widget icon.
   */
  public function get_icon()
  {
    return 'eicon-carousel';
  }

  /**
   * Get custom help URL.
   *
   * Retrieve a URL where the user can get more information about the widget.
   *
   * @since 1.0.0
   * @access public
   * @return string Widget help URL.
   */
  public function get_custom_help_url()
  {
    return 'https://developers.elementor.com/docs/widgets/';
  }

  /**
   * Get widget categories.
   *
   * Retrieve the list of categories the oEmbed widget belongs to.
   *
   * @since 1.0.0
   * @access public
   * @return array Widget categories.
   */
  public function get_categories()
  {
    return ['basic'];
  }

  /**
   * Get widget keywords.
   *
   * Retrieve the list of keywords the oEmbed widget belongs to.
   *
   * @since 1.0.0
   * @access public
   * @return array Widget keywords.
   */
  public function get_keywords()
  {
    return ['post', 'latestpost', 'index'];
  }

  /**
   * Register oEmbed widget controls.
   *
   * Add input fields to allow the user to customize the widget settings.
   *
   * @since 1.0.0
   * @access protected
   */
  protected function register_controls()
  {

    $this->start_controls_section(
      'content_section',
      [
        'label' => esc_html__('تنظیمات ویجت کروسل مطالب دسته', 'elementor-ads-widget'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );

    $options = array();

    $args = array(
      'hide_empty' => false,
      'post_type'     => 'post',
      'taxonomy'  => 'category',

    );

    $categories = get_categories($args);

    foreach ($categories as $key => $category) {
      $options[$category->term_id] = $category->name;
    }


    $this->add_control(
      'title',
      [
        'label' => esc_html__('عنوان ویجت', 'elementor-oembed-widget'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => esc_html__('مثلا آخرین مطالب', 'elementor-oembed-widget'),
        'default' => 'آخرین مطالب'
      ]
    );

    $this->add_control(
      'category',
      [
        'label' => esc_html__('انتخاب دسته بندی', 'plugin-name'),
        'type' => \Elementor\Controls_Manager::SELECT2,
        'multiple' => false,
        'description' => 'در صورت انتخاب دسته مطالب دسته و درصورت انتخاب نکردن آخرین مطالب نشان داده می‌شوند.',
        'options' => $options,
        'default' => [],
      ]
    );

    $this->add_control(
      'number_posts',
      [
        'label' => esc_html__('تعداد مطالب برای نمایش', 'elementor-oembed-widget'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => esc_html__('مثلا ۱۰', 'elementor-oembed-widget'),
      ]
    );

    $this->add_control(
      'desktop_item',
      [
        'label' => esc_html__('تعداد آیتم در دسکتاپ', 'elementor-oembed-widget'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => esc_html__('مثلا 6', 'elementor-oembed-widget'),
        'default' => 6
      ]
    );

    $this->add_control(
      'mobile_item',
      [
        'label' => esc_html__('تعداد آیتم در موبایل', 'elementor-oembed-widget'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => esc_html__('مثلا 6', 'elementor-oembed-widget'),
        'default' => 2
      ]
    );

    $this->add_control(
      'tablet_item',
      [
        'label' => esc_html__('تعداد آیتم در تبلت', 'elementor-oembed-widget'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => esc_html__('مثلا 6', 'elementor-oembed-widget'),
        'default' => 3
      ]
    );

    $this->end_controls_section();
  }

  /**
   * Render oEmbed widget output on the frontend.
   *
   * Written in PHP and used to generate the final HTML.
   *
   * @since 1.0.0
   * @access protected
   */
  protected function render()
  {
    $settings = $this->get_settings_for_display();
    $number_posts = $settings['number_posts'];
    $title = $settings['title'];
    $cat_id = $settings['category'];
    // $widget_id = $this->get_id();
    $widget_class = $this->get_unique_selector();
    if (!empty($cat_id)) {
      // $paged = (get_query_var('page')) ? get_query_var('page') : 1;
      $cat_name = get_cat_name($settings['category']);
      $args = array(
        'post_type' => 'post',
        'posts_per_page' => $number_posts,
        'cat' => $cat_id,
        'order' => 'DESC',
        // 'paged' => $paged,
      );
    } else {
      // $paged = (get_query_var('page')) ? get_query_var('page') : 1;
      $args = array(
        'post_type' => 'post',
        'posts_per_page' => $number_posts,
        'order' => 'DESC',
        // 'paged' => $paged,
      );
    }
?>

    <div class="row">
      <div class="cat_title">
        <?php if ($title) : ?>
          <h3 class="star_title_c title1"><?= $title; ?></h3>
        <?php else : ?>
          <h3 class="star_title_c title1"><?php echo get_cat_name($cat_id); ?></h3>

        <?php endif; ?>
        <a class="btn btn-outline-primary btn-sm link1" href="<?php echo get_category_link($cat_id); ?>"><?php _e('مشاهده همه', 'kelaketfilm'); ?></a>
      </div>
      <div
      data-id="<?php echo $widget_class ?>"
      data-desktop="<?php echo $settings['desktop_item'] ?>"
      data-mobile="<?php echo $settings['mobile_item'] ?>"
      data-tablet="<?php echo $settings['tablet_item'] ?>"
      class="owl-carousel elementor_carousel">
        <?php
        $query = new WP_Query($args);
        if ($query->have_posts()) : while ($query->have_posts()) : $query->the_post(); ?>
            <div class="film_cat">
              <a href="<?php the_permalink(); ?>">
                <div class="position-relative image-round">
                  <?php the_post_thumbnail('post-cat-thumb'); ?>
                  <div class="film_overlay">
                    <?php if (get_field('persian-doble')) : ?>
                    <span class="dobed"><?php _e('دوبله فارسی', 'kelaketfilm') ?></span>
                    <?php elseif(get_field('def-version')): ?>
                    <span class="sub"><?php _e('زیرنویس فارسی', 'kelaketfilm') ?></span>
                    <?php elseif(get_field('censored')): ?>
                    <span class="censored"><?php _e('سانسور شده', 'kelaketfilm') ?></span>
                    <?php endif;?>
                  </div>
                  <div class="position-absolute film_overlay2">
                    
                    <?php if(get_field('imdbRating')): ?>
                    <div class="film_overlay2_meta">
                      <img width="29" height="12" src="<?php echo get_template_directory_uri(); ?>/images/imdbt_w.svg" alt="">
                      <?php echo get_field('imdbRating'); ?>
                    </div>
                    <?php endif; ?>
                    <?php if(get_field('rotten')): ?>
                    <div class="film_overlay2_meta">
                      <i class="bi bi-heart-fill"></i>
                      <?php echo '%'.get_field('rotten'); ?>
                    </div>
                    <?php endif; ?>
                    <div class="film_overlay2_meta">
                      <?php 
                      if(get_the_term_list(get_the_ID(), 'genre', '', '، ', '')){
                        echo strip_tags(get_the_term_list(get_the_ID(), 'genre', '', '، ', ''));
                      }
                      ?>
                    </div>
                    <div class="film_overlay2_meta">
                      <?php 
                      if(get_the_term_list(get_the_ID(), 'country', '', '، ', '')){
                        echo strip_tags(get_the_term_list(get_the_ID(), 'country', '', '، ', '')).' - ';
                      }
                      echo strip_tags(get_the_term_list(get_the_ID(), 'yearr', '', '، ', ''));
                      ?>
                    </div>
                    
                  </div>
                </div>

                <div class="film_cat_title"><?php echo get_the_title(); ?></div>
              </a>
            </div>
        <?php endwhile;
        endif;
        wp_reset_postdata();
        ?>
      </div>
    </div>
<?php
  }
}
