<?php
if (!defined('ABSPATH')) {
  exit; // Exit if accessed directly.
}

/**
 * Elementor oEmbed Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class CategoryPosts_widget extends \Elementor\Widget_Base
{

  /**
   * Get widget name.
   *
   * Retrieve oEmbed widget name.
   *
   * @since 1.0.0
   * @access public
   * @return string Widget name.
   */
  public function get_name()
  {
    return 'categoryPosts';
  }

  /**
   * Get widget title.
   *
   * Retrieve oEmbed widget title.
   *
   * @since 1.0.0
   * @access public
   * @return string Widget title.
   */
  public function get_title()
  {
    return esc_html__('ویجت مطالب دسته', 'elementor-ads-widget');
  }

  /**
   * Get widget icon.
   *
   * Retrieve oEmbed widget icon.
   *
   * @since 1.0.0
   * @access public
   * @return string Widget icon.
   */
  public function get_icon()
  {
    return 'eicon-gallery-grid';
  }

  /**
   * Get custom help URL.
   *
   * Retrieve a URL where the user can get more information about the widget.
   *
   * @since 1.0.0
   * @access public
   * @return string Widget help URL.
   */
  public function get_custom_help_url()
  {
    return 'https://developers.elementor.com/docs/widgets/';
  }

  /**
   * Get widget categories.
   *
   * Retrieve the list of categories the oEmbed widget belongs to.
   *
   * @since 1.0.0
   * @access public
   * @return array Widget categories.
   */
  public function get_categories()
  {
    return ['basic'];
  }

  /**
   * Get widget keywords.
   *
   * Retrieve the list of keywords the oEmbed widget belongs to.
   *
   * @since 1.0.0
   * @access public
   * @return array Widget keywords.
   */
  public function get_keywords()
  {
    return ['post', 'latestpost', 'index'];
  }

  /**
   * Register oEmbed widget controls.
   *
   * Add input fields to allow the user to customize the widget settings.
   *
   * @since 1.0.0
   * @access protected
   */
  protected function register_controls()
  {

    $this->start_controls_section(
      'content_section',
      [
        'label' => esc_html__('تنظیمات ویجت مطالب دسته', 'elementor-ads-widget'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );

    $options = array();

    $args = array(
      'hide_empty' => false,
      'post_type'     => 'post',
      'taxonomy'  => 'category',

    );

    $categories = get_categories($args);

    foreach ($categories as $key => $category) {
      $options[$category->term_id] = $category->name;
    }


    $this->add_control(
      'title',
      [
        'label' => esc_html__('عنوان ویجت', 'elementor-oembed-widget'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => esc_html__('مثلا آخرین مطالب', 'elementor-oembed-widget'),
        'default' => 'آخرین مطالب'
      ]
    );

    $this->add_control(
      'category',
      [
        'label' => esc_html__('انتخاب دسته بندی', 'plugin-name'),
        'type' => \Elementor\Controls_Manager::SELECT2,
        'multiple' => false,
        'description' => 'در صورت انتخاب دسته مطالب دسته و درصورت انتخاب نکردن آخرین مطالب نشان داده می‌شوند.',
        'options' => $options,
        'default' => [],
      ]
    );

    $this->add_control(
      'number_posts',
      [
        'label' => esc_html__('تعداد مطالب برای نمایش', 'elementor-oembed-widget'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => esc_html__('مثلا ۱۰', 'elementor-oembed-widget'),
      ]
    );

    $this->add_control(
      'pagination',
      [
        'label' => esc_html__('فعال بودن صفحه بندی', 'plugin-name'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => esc_html__('بله', 'your-plugin'),
        'label_off' => esc_html__('خیر', 'your-plugin'),
        'return_value' => true,
        'default' => true,
      ]
    );


    $this->end_controls_section();
  }

  /**
   * Render oEmbed widget output on the frontend.
   *
   * Written in PHP and used to generate the final HTML.
   *
   * @since 1.0.0
   * @access protected
   */
  protected function render()
  {
    $settings = $this->get_settings_for_display();
    $pagination = $settings['pagination'];
    $number_posts = $settings['number_posts'];
    $title = $settings['title'];
    $cat_id = $settings['category'];
    if (!empty($cat_id)) {
      $paged = (get_query_var('page')) ? get_query_var('page') : 1;
      $cat_name = get_cat_name($settings['category']);
      $args = array(
        'post_type' => 'post',
        'posts_per_page' => $number_posts,
        'cat' => $cat_id,
        'order' => 'DESC',
        'paged' => $paged,
      );
    } else {
      $paged = (get_query_var('page')) ? get_query_var('page') : 1;
      $args = array(
        'post_type' => 'post',
        'posts_per_page' => $number_posts,
        'order' => 'DESC',
        'paged' => $paged,
      );
    }
?>

    <div class="row">
      <div class="cat_title">
        <?php if ($cat_id) : ?>
          <h3 class="star_title_c title1"><?php echo get_cat_name($cat_id); ?></h3>
        <?php else : ?>
          <h3 class="star_title_c title1"><?= $title; ?></h3>

        <?php endif; ?>
        <a class="btn btn-outline-primary btn-sm link1" href="<?php echo get_category_link($cat_id); ?>"><?php _e('مشاهده همه', 'kelaketfilm'); ?></a>
      </div>
      <?php
      $query = new WP_Query($args);
      if ($query->have_posts()) : while ($query->have_posts()) : $query->the_post(); ?>

          <section class=" col-xl-2 col-lg-3 col-md-4 col-sm-6 col-6 col-xxl-2">
            <div class="film_cat">
              <a href="<?php the_permalink(); ?>">
                <div class="position-relative">
                  <?php the_post_thumbnail('post-cat-thumb'); ?>
                  <div class="overlay">
                    <?php if (get_field('imdbRating')) : ?><span><i class="fab fa-imdb imdb-c"></i>امتیاز: <?php the_field('imdbRating') ?></span><?php endif; ?>
                  </div>
                  <div class="overlay2">
                    <?php if (get_field('rotten')) : ?><span class="rotten"><i class="bi bi-heart-fill text-danger"></i><?php the_field('rotten'); ?>٪ رضایت</span><?php endif; ?>
                  </div>
                </div>

                <div class="film_cat_title"><?php echo get_the_title(); ?></div>
              </a>
            </div>
          </section>

      <?php endwhile;
      endif;
      wp_reset_postdata();
      ?>
    </div>
<?php
  }
}
