<?php
if (!defined('ABSPATH')) {
  exit; // Exit if accessed directly.
}

/**
 * Elementor oEmbed Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class GenresCarousel_widget extends \Elementor\Widget_Base
{

  public function __construct($data = [], $args = null) {
    parent::__construct($data, $args);

    wp_register_script( 'categoryCarousel', get_template_directory_uri() . '/js/carousel.elementor.js', [ 'elementor-frontend', 'jquery', 'owl' ], '1.0.0', true );
  }

  public function get_script_depends() {
    return [ 'categoryCarousel' ];
  }

  /**
   * Get widget name.
   *
   * Retrieve oEmbed widget name.
   *
   * @since 1.0.0
   * @access public
   * @return string Widget name.
   */
  public function get_name()
  {
    return 'genresCarousel';
  }

  /**
   * Get widget title.
   *
   * Retrieve oEmbed widget title.
   *
   * @since 1.0.0
   * @access public
   * @return string Widget title.
   */
  public function get_title()
  {
    return esc_html__('ویجت کروسل ژانر ها', 'elementor-ads-widget');
  }

  /**
   * Get widget icon.
   *
   * Retrieve oEmbed widget icon.
   *
   * @since 1.0.0
   * @access public
   * @return string Widget icon.
   */
  public function get_icon()
  {
    return 'eicon-posts-carousel';
  }

  /**
   * Get custom help URL.
   *
   * Retrieve a URL where the user can get more information about the widget.
   *
   * @since 1.0.0
   * @access public
   * @return string Widget help URL.
   */
  public function get_custom_help_url()
  {
    return 'https://developers.elementor.com/docs/widgets/';
  }

  /**
   * Get widget categories.
   *
   * Retrieve the list of categories the oEmbed widget belongs to.
   *
   * @since 1.0.0
   * @access public
   * @return array Widget categories.
   */
  public function get_categories()
  {
    return ['basic'];
  }

  /**
   * Get widget keywords.
   *
   * Retrieve the list of keywords the oEmbed widget belongs to.
   *
   * @since 1.0.0
   * @access public
   * @return array Widget keywords.
   */
  public function get_keywords()
  {
    return ['post', 'latestpost', 'index'];
  }

  /**
   * Register oEmbed widget controls.
   *
   * Add input fields to allow the user to customize the widget settings.
   *
   * @since 1.0.0
   * @access protected
   */
  protected function register_controls()
  {

    $this->start_controls_section(
      'content_section',
      [
        'label' => esc_html__('تنظیمات', 'elementor-ads-widget'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );

    $options = array();

    $args = array(
      'hide_empty' => false,
      'post_type'     => 'post',
      'taxonomy'  => 'category',

    );

    $categories = get_categories($args);

    foreach ($categories as $key => $category) {
      $options[$category->term_id] = $category->name;
    }


    $this->add_control(
      'title',
      [
        'label' => esc_html__('عنوان ویجت', 'elementor-oembed-widget'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => esc_html__('مثلا:‌ژانرهای محبوب', 'elementor-oembed-widget'),
        'default' => 'ژانرهای محبوب'
      ]
    );

    $this->add_control(
      'number_posts',
      [
        'label' => esc_html__('تعداد ژانر برای نمایش', 'elementor-oembed-widget'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => esc_html__('مثلا ۱۰', 'elementor-oembed-widget'),
      ]
    );

    $this->add_control(
      'desktop_item',
      [
        'label' => esc_html__('تعداد آیتم در دسکتاپ', 'elementor-oembed-widget'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => esc_html__('مثلا 6', 'elementor-oembed-widget'),
        'default' => 6
      ]
    );

    $this->add_control(
      'mobile_item',
      [
        'label' => esc_html__('تعداد آیتم در موبایل', 'elementor-oembed-widget'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => esc_html__('مثلا 6', 'elementor-oembed-widget'),
        'default' => 2
      ]
    );

    $this->add_control(
      'tablet_item',
      [
        'label' => esc_html__('تعداد آیتم در تبلت', 'elementor-oembed-widget'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => esc_html__('مثلا 6', 'elementor-oembed-widget'),
        'default' => 3
      ]
    );

    $this->end_controls_section();
  }


  /**
   * Render oEmbed widget output on the frontend.
   *
   * Written in PHP and used to generate the final HTML.
   *
   * @since 1.0.0
   * @access protected
   */
  protected function render()
  {
    $settings = $this->get_settings_for_display();
    $number_posts = $settings['number_posts'];
    $title = $settings['title'];
    $widget_class = $this->get_unique_selector();
?>
    <div class="container">
      <?php if ($title) : ?>
        <div class="category_title">
          <h3><?= $title; ?></h3>
        </div>
      <?php endif; ?>
      <div class="row">
        <div
          data-id="<?php echo $widget_class ?>"
          data-desktop="<?php echo $settings['desktop_item'] ?>"
          data-mobile="<?php echo $settings['mobile_item'] ?>"
          data-tablet="<?php echo $settings['tablet_item'] ?>"
         class="owl-carousel genres_carousel">
          <?php
          // Get the taxonomy's terms
          $terms = get_terms(
            array(
              'taxonomy'   => 'genre',
              'hide_empty' => false,
              'number'     => $number_posts
            )
          );

          // Check if any term exists
          if (!empty($terms) && is_array($terms)) {
            // Run a loop and print them all
            foreach ($terms as $term) { ?>
              <div class="genre_card">
                <a href="<?php echo esc_url(get_term_link($term)) ?>">
                  <?php if (get_field('genre_image', $term)) { ?>
                    <img src="<?php echo get_field('genre_image', $term) ?>" alt="brat" />
                  <?php } else { ?>
                    <img src="<?php echo get_template_directory_uri(); ?>/images/default_genre.jpg" alt="no-image" />
                  <?php } ?>
                  <div class="genre_card__inner">
                    <?php echo $term->name; ?>
                  </div>
                </a>
              </div>
          <?php }
          }
          ?>
        </div>
      </div>
    </div>
   
<?php
  }
}
