<?php
if (!defined('ABSPATH')) {
  exit; // Exit if accessed directly.
}

/**
 * Elementor oEmbed Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class LatestPosts_widget extends \Elementor\Widget_Base
{

  /**
   * Get widget name.
   *
   * Retrieve oEmbed widget name.
   *
   * @since 1.0.0
   * @access public
   * @return string Widget name.
   */
  public function get_name()
  {
    return 'latestPosts';
  }

  /**
   * Get widget title.
   *
   * Retrieve oEmbed widget title.
   *
   * @since 1.0.0
   * @access public
   * @return string Widget title.
   */
  public function get_title()
  {
    return esc_html__('ویجت آخرین مطالب دسته', 'elementor-ads-widget');
  }

  /**
   * Get widget icon.
   *
   * Retrieve oEmbed widget icon.
   *
   * @since 1.0.0
   * @access public
   * @return string Widget icon.
   */
  public function get_icon()
  {
    return 'eicon-post-content';
  }

  /**
   * Get custom help URL.
   *
   * Retrieve a URL where the user can get more information about the widget.
   *
   * @since 1.0.0
   * @access public
   * @return string Widget help URL.
   */
  public function get_custom_help_url()
  {
    return 'https://developers.elementor.com/docs/widgets/';
  }

  /**
   * Get widget categories.
   *
   * Retrieve the list of categories the oEmbed widget belongs to.
   *
   * @since 1.0.0
   * @access public
   * @return array Widget categories.
   */
  public function get_categories()
  {
    return ['basic'];
  }

  /**
   * Get widget keywords.
   *
   * Retrieve the list of keywords the oEmbed widget belongs to.
   *
   * @since 1.0.0
   * @access public
   * @return array Widget keywords.
   */
  public function get_keywords()
  {
    return ['post', 'latestpost', 'index'];
  }

  /**
   * Register oEmbed widget controls.
   *
   * Add input fields to allow the user to customize the widget settings.
   *
   * @since 1.0.0
   * @access protected
   */
  protected function register_controls()
  {

    $this->start_controls_section(
      'content_section',
      [
        'label' => esc_html__('تنظیمات ویجت آخرین مطالب دسته', 'elementor-ads-widget'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );

    $options = array();

    $args = array(
      'hide_empty' => false,
      'post_type'     => 'post',
      'taxonomy'  => 'category',

    );

    $categories = get_categories($args);

    foreach ($categories as $key => $category) {
      $options[$category->term_id] = $category->name;
    }


    $this->add_control(
      'title',
      [
        'label' => esc_html__('عنوان ویجت', 'elementor-oembed-widget'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => esc_html__('مثلا آخرین مطالب', 'elementor-oembed-widget'),
        'default' => 'آخرین مطالب'
      ]
    );

    $this->add_control(
      'style',
      [
        'label' => esc_html__('استایل نمایش', 'plugin-name'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'multiple' => false,
        'options' => ['first' => 'استایل اول', 'second' => 'استایل دوم'],
        'default' => 'first',
      ]
    );

    $this->add_control(
      'category',
      [
        'label' => esc_html__('انتخاب دسته بندی', 'plugin-name'),
        'type' => \Elementor\Controls_Manager::SELECT2,
        'multiple' => false,
        'description' => 'در صورت انتخاب دسته مطالب دسته و درصورت انتخاب نکردن آخرین مطالب نشان داده می‌شوند.',
        'options' => $options,
        'default' => [],
      ]
    );

    $this->add_control(
      'number_posts',
      [
        'label' => esc_html__('تعداد مطالب برای نمایش', 'elementor-oembed-widget'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => esc_html__('مثلا ۱۰', 'elementor-oembed-widget'),
      ]
    );

    $this->add_control(
      'pagination',
      [
        'label' => esc_html__('فعال بودن صفحه بندی', 'plugin-name'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => esc_html__('بله', 'your-plugin'),
        'label_off' => esc_html__('خیر', 'your-plugin'),
        'return_value' => true,
        'default' => true,
      ]
    );


    $this->end_controls_section();
  }

  /**
   * Render oEmbed widget output on the frontend.
   *
   * Written in PHP and used to generate the final HTML.
   *
   * @since 1.0.0
   * @access protected
   */
  protected function render()
  {
    $settings = $this->get_settings_for_display();
    $pagination = $settings['pagination'];
    $number_posts = $settings['number_posts'];
    $title = $settings['title'];
    $cat_id = $settings['category'];
    $style = $settings['style'];
    if (!empty($cat_id)) {
      $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
      $cat_name = get_cat_name($settings['category']);
      $args = array(
        'post_type' => 'post',
        'posts_per_page' => $number_posts,
        'cat' => $cat_id,
        'order' => 'DESC',
        'paged' => $paged,
      );
    } else {
      $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
      $args = array(
        'post_type' => 'post',
        'posts_per_page' => $number_posts,
        'order' => 'DESC',
        'paged' => $paged,
      );
    }
?>
    <div class="category_title">
      <h3>
        <?php echo $title; ?>
      </h3>
    </div>
    <?php
    $query = new WP_Query($args);
    if ($query->have_posts()) : while ($query->have_posts()) : $query->the_post(); ?>
        <?php if ($style == 'first') : ?>
          <article class="post">
    <div class="row">
      <div class="post_image col-xl-3 col-lg-4 col-md-4">
        <a href="<?php the_permalink() ?>">
          <div class="post_image--inner">
            <?php the_post_thumbnail('post_retina'); ?>
            <div class="post_meta--inner">
              <?php if (get_field('def-version')) { ?>
                <div class="sub_meta meta_def">
                  <i class="fa fa-closed-captioning"></i>
                  <?php _e('دارای زیرنویس فارسی', 'kelaketfilm'); ?>
                </div>
              <?php } ?>
              <?php if (get_field('top-250-imdb')) { ?>
                <div class="sub_meta meta_imdbtop">
                  <i class="fa fa-stars"></i>
                  <?php _e('جزو ۲۵۰ فیلم برتر با رتبه', 'kelaketfilm'); ?> <?php the_field('imdb_rank'); ?>
                </div>
              <?php } ?>
              <?php if (get_field('top-250-series')) { ?>
                <div class="sub_meta meta_imdbtop">
                  <i class="fa fa-stars"></i>
                  <?php _e('جزو ۲۵۰ سریال برتر با رتبه', 'kelaketfilm'); ?> <?php the_field('series_imdb_rank'); ?>
                </div>
              <?php } ?>
              <?php if (get_field('persian-doble')) { ?>
                <div class="sub_meta meta_double">
                  <i class="fa fa-microphone"></i>
                  <?php _e('دارای دوبله فارسی', 'kelaketfilm'); ?>
                </div>
              <?php } ?>
              <?php if (get_field('custom-badge')) { ?>
                <div class="sub_meta meta_custom">
                  <i class="fa fa-info"></i>
                  <?php the_field('custom-badge') ?>
                </div>
              <?php } ?>
            </div>
          </div>
        </a>
      </div>
      <div class="post_details col-xl-9 col-lg-8 col-md-8">
        <?php
        if (get_field('imdbRating')) { ?>
        <a target="_blank" href="https://www.imdb.com/title/<?php the_field('imdb') ?>">
          <div class="imdbRating_holder">
            <div class="imdb_num">
              <strong><?php the_field('imdbRating'); ?></strong>
              <small>/10</small>
              <span><?php echo formatVotes(get_field('imdbVotes')); ?> Votes</span>
            </div>
            <div class="imdbLogo">
              <img src="<?php echo get_template_directory_uri(); ?>/images/imdbt.svg" alt="">
            </div>
          </div>
        </a>
        <?php } ?>
        <div data-bs-toggle="tooltip" data-bs-placement="top" title="افزودن به لیست تماشا" class="simplefavorite-button stats -favorites">
          <span class="icon postFav-<?php echo $post->ID; ?> -click <?php echo is_favorite(get_current_user_id(), $post->ID) ? 'fa' : 'far' ?> fa-bookmark" data-js="favorite" data-favorite="<?php echo $post->ID; ?>" data-user="<?php echo get_current_user_id(); ?>"></span>
        </div>
        <h2>
          <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
          <?php if (get_field('legal')) : ?>
            <span class="legal"><i class="fa fa-check"></i> <?php _e("قانونی", "kelaketfilm") ?></span>
          <?php endif; ?>
          <?php if (get_field('censored')) : ?>
            <span class="censored"><i class="fa fa-check"></i> <?php _e("سانسور شده", "kelaketfilm") ?></span>
          <?php endif; ?>
        </h2>

        <ul class="post_meta">
          <li><strong><i class="fa-light fa-tv"></i><?php _e('کیفیت', 'kelaketfilm'); ?></strong> <?php the_field('quality-meta') ?></li>
          <li><strong><i class="fa-light fa-theater-masks"></i><?php _e('ژانر', 'kelaketfilm'); ?></strong> <?php echo get_the_term_list($post->ID, 'genre', '', '، ', '') ?></li>
          <li><strong><i class="fa-light fa-calendar-days"></i><?php _e('سال تولید', 'kelaketfilm'); ?></strong> <?php echo get_the_term_list($post->ID, 'yearr', '', '، ', '') ?></li>
          <li><strong><i class="fa-light fa-globe"></i><?php _e('محصول', 'kelaketfilm'); ?></strong> <?php echo get_the_term_list($post->ID, 'country', '', '، ', '') ?></li>
          <li><strong><i class="fa-light fa-stopwatch"></i><?php _e('مدت زمان', 'kelaketfilm'); ?></strong> <?php the_field('time') ?></li>
          <li><strong><i class="fa-light fa-language"></i><?php _e('زبان', 'kelaketfilm'); ?></strong> <?php the_field('Language') ?></li>
          <li><strong><i class="fa-light fa-users"></i><?php _e('بازیگران', 'kelaketfilm'); ?></strong> <?php echo get_the_term_list($post->ID, 'actor', '', '، ', '') ?></li>
          <li><strong><i class="fa-light fa-user-crown"></i><?php _e('کارگردان', 'kelaketfilm'); ?></strong> <?php echo get_the_term_list($post->ID, 'director', '', '، ', '') ?></li>
        </ul>

        <?php
        $post_type = get_field('post-type');
        if ($post_type == 'film') {
          $post_type = __('فیلم', 'kelaketfilm');
        } elseif ($post_type == 'series') {
          $post_type = __('سریال', 'kelaketfilm');
        } else {
          $post_type = '';
        }
        ?>
      </div>
      <div class="about_box">
        <?php if (get_field('story')) : ?> <p><?php the_field('story'); ?></p><?php endif; ?>
        <a href="<?php the_permalink(); ?>" type="button" class="post_download btn btn-outline-primary"><i class="fa fa-download"></i><?php _e('دانلود', 'kelaketfilm') ?> <?php echo $post_type ?></a>
      </div>

    </div>
  </article>
        <?php elseif ($style == 'second') : ?>
          <article class="post2">
    <div class="post2_bg" style="background-image: url(<?php echo get_the_post_thumbnail_url(); ?>)"></div>
    <div class="row relz2">
      <div class="title">
        <h2>
          <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
        </h2>
        <?php if (get_field('legal')) : ?>
          <span class="legal"><?php _e('دانلود قانونی', 'kelaketfilm'); ?></span>
        <?php elseif (get_field('censored')) : ?>
          <span class="censored"><?php _e('سانسور شده', 'kelaketfilm'); ?></span>
        <?php elseif (get_field('persian-doble')) : ?>
          <span class="censored dub"><?php _e('دوبله فارسی', 'kelaketfilm'); ?></span>
        <?php elseif (get_field('def-version')) : ?>
          <span class="censored sub"><?php _e('زیرنویس فارسی', 'kelaketfilm'); ?></span>
        <?php endif; ?>
      </div>

      <div class="post_details col-xl-9 col-lg-8 col-md-8 order-md-1 order-2">

        <ul class="post_meta">
          <?php if (get_field('update_info')) : ?>
            <li>
              <strong>
                <span class="icon"><i class="fa-light fa-rotate"></i></span>
                <?php _e('بروزرسانی', 'kelaketfilm'); ?></strong><i class="seprator"></i>
              <div class="post_meta--left"><?php the_field('update_info') ?></div>
            </li>
          <?php endif; ?>
          <?php if (get_the_term_list(get_the_ID(), 'genre', '', '، ', '')) : ?>
            <li><strong>
                <span class="icon"><i class="fa-light fa-theater-masks"></i></span>
                <?php _e('ژانر', 'kelaketfilm'); ?>
              </strong><i class="seprator"></i>
              <div class="post_meta--left"><?php echo get_the_term_list(get_the_ID(), 'genre', '', '، ', '') ?></div>
            </li>
          <?php endif; ?>
          <?php if (get_the_term_list(get_the_ID(), 'yearr', '', '، ', '')) : ?>
            <li><strong>
                <span class="icon"><i class="fa-light fa-calendar-days"></i> </span>
                <?php _e('سال تولید', 'kelaketfilm'); ?></strong><i class="seprator"></i>
              <div class="post_meta--left"><?php echo get_the_term_list(get_the_ID(), 'yearr', '', '، ', '') ?></div>
            </li>
          <?php endif; ?>
          <?php if (get_the_term_list(get_the_ID(), 'country', '', '، ', '')) : ?>
            <li><strong>
                <span class="icon"><i class="fa-light fa-globe"></i> </span>
                <?php _e('محصول', 'kelaketfilm'); ?></strong><i class="seprator"></i>
              <div class="post_meta--left"><?php echo get_the_term_list(get_the_ID(), 'country', '', '، ', '') ?></div>
            </li>
          <?php endif; ?>
          <?php if (get_field('time')) : ?>
            <li><strong>
                <span class="icon"><i class="fa-light fa-stopwatch"></i> </span>
                <?php _e('مدت زمان', 'kelaketfilm'); ?></strong><i class="seprator"></i>
              <div class="post_meta--left"><?php the_field('time') ?></div>
            </li>
          <?php endif; ?>
          <?php if (get_field('air_status')) : ?>
            <li><strong>
                <span class="icon"><i class="fa-light fa-screencast"></i> </span>
                <?php _e('وضعیت پخش', 'kelaketfilm'); ?></strong><i class="seprator"></i>
              <div class="post_meta--left"><?php the_field('air_status') ?></div>
            </li>
          <?php endif; ?>
          <?php if (get_field('Language')) : ?>
            <li><strong>
                <span class="icon"><i class="fa-light fa-language"></i> </span>
                <?php _e('زبان', 'kelaketfilm'); ?></strong><i class="seprator"></i>
              <div class="post_meta--left"><?php the_field('Language') ?></div>
            </li>
          <?php endif; ?>
          <?php if (get_field('quality-meta')) : ?>
            <li><strong>
                <span class="icon"><i class="fa-light fa-tv"></i> </span>
                <?php _e('کیفیت', 'kelaketfilm'); ?></strong><i class="seprator"></i>
              <div class="post_meta--left">
                <?php
                $quality = get_field('quality-meta');
                $quality = explode(',', $quality);
                foreach ($quality as $item) {
                  echo '<span> ' . $item . ' </span>';
                }
                ?>
              </div>
            </li>
          <?php endif; ?>

          <?php if (get_the_term_list(get_the_ID(), 'actor', '', '، ', '')) : ?>
            <li><strong>
                <span class="icon"><i class="fa-light fa-users"></i> </span>
                <?php _e('بازیگران', 'kelaketfilm'); ?></strong><i class="seprator"></i>
              <div class="post_meta--left"><?php echo get_the_term_list(get_the_ID(), 'actor', '', '، ', '') ?></div>
            </li>
          <?php endif; ?>
          <?php if (get_the_term_list(get_the_ID(), 'director', '', '، ', '')) : ?>
            <li><strong>
                <span class="icon"><i class="fa-light fa-user-crown"></i></span>
                <?php _e('کارگردان', 'kelaketfilm'); ?></strong><i class="seprator"></i>
              <div class="post_meta--left"><?php echo get_the_term_list(get_the_ID(), 'director', '', '، ', '') ?></div>
            </li>
          <?php endif; ?>
          <li>
            <?php if (get_field('story')) : ?> <p><i class="fa-light fa-comment-dots"></i> <span class="story"><?php _e('خلاصه داستان:', 'kelaketfilm'); ?></span> <?php the_field('story'); ?></p><?php endif; ?>
          </li>
        </ul>

        <?php
        $post_type = get_field('post-type');
        if ($post_type == 'film') {
          $post_type = __('فیلم', 'kelaketfilm');
        } elseif ($post_type == 'series') {
          $post_type = __('سریال', 'kelaketfilm');
        } else {
          $post_type = '';
        }
        ?>
      </div>
      <div class="post_image col-xl-3 col-lg-4 col-md-4 order-1">
        <?php
        if (get_field('imdbRating')) { ?>
        <a target="_blank" href="https://www.imdb.com/title/<?php the_field('imdb') ?>">
          <div class="imdbRating_holder mb-4">
            <div class="imdbLogo">
              <img width="29" height="12" src="<?php echo get_template_directory_uri(); ?>/images/imdbt.svg" alt="">
            </div>
            <div class="imdbRate_nums">
              <strong><?php the_field('imdbRating'); ?></strong>
              <small>/10</small>
            </div>
          </div>
        </a>
        <?php } ?>
        <?php
        if (get_field('malRating')) { ?>
          <div class="imdbRating_holder mal_holder mb-4">
            <div class="imdbLogo">
              MAL
            </div>
            <div class="imdbRate_nums">
              <strong><?php the_field('malRating'); ?></strong>
              <small>/10</small>
            </div>
          </div>
        <?php } ?>
        <a href="<?php the_permalink() ?>">
          <div class="post_image--inner text-center">
            <?php if (get_field('playonline')) : ?>
              <span class="playonline_badge">
                <i class="fa-solid fa-play-circle"></i>
              </span>
            <?php endif; ?>
            <?php the_post_thumbnail('post_retina'); ?>
          </div>
        </a>
      </div>
      <div class="about_box order-3">
        <div class="about_box--right">
          <a href="<?php the_permalink(); ?>" type="button" class="post_download"><i class="fa fa-download"></i><?php _e('دانلود', 'kelaketfilm'); ?> <?php echo $post_type ?></a>
        </div>
        <div class="about_box--left d-flex align-items-center">
          <div class="badges">
            <ul>
              <?php if (get_field('def-version')) : ?>
                <li data-bs-toggle="tooltip" data-bs-placement="top" title="<?php _e('دارای زیرنویس فارسی', 'kelaketfilm'); ?>" class="meta_def"><i class="fa-solid fa-closed-captioning"></i></li>
              <?php endif; ?>
              <?php if (get_field('top-250-imdb')) : ?>
                <li data-bs-toggle="tooltip" data-bs-placement="top" title="<?php _e('جزو ۲۵۰ فیلم برتر با رتبه', 'kelaketfilm'); ?> <?php the_field('imdb_rank'); ?>" class="meta_imdbtop"><i class="fa fa-stars"></i></li>
              <?php endif; ?>
              <?php if (get_field('top-250-series')) : ?>
                <li data-bs-toggle="tooltip" data-bs-placement="top" title="<?php _e('جزو ۲۵۰ سریال برتر با رتبه', 'kelaketfilm'); ?> <?php the_field('series_imdb_rank'); ?>" class="meta_imdbtop"><i class="fa fa-stars"></i></li>
              <?php endif; ?>
              <?php if (get_field('persian-doble')) : ?>
                <li data-bs-toggle="tooltip" data-bs-placement="top" title="<?php _e('دارای دوبله فارسی', 'kelaketfilm'); ?>" class="meta_double"><i class="fa-solid fa-microphone-lines"></i></li>
              <?php endif; ?>
              <?php if (get_field('custom-badge')) : ?>
                <li data-bs-toggle="tooltip" data-bs-placement="top" title="<?php the_field('custom-badge'); ?>" class="meta_custom"><i class="fa-solid fa-ribbon"></i></li>
              <?php endif; ?>
            </ul>
          </div>

          <div data-bs-toggle="tooltip" data-bs-placement="top" title="<?php _e('افزودن به لیست تماشا', 'kelaketfilm'); ?>" class="simplefavorite-button stats -favorites">
            <span class="icon postFav-<?php echo get_the_ID(); ?> -click <?php echo is_favorite(get_current_user_id(), get_the_ID()) ? 'fa' : 'far' ?> fa-bookmark" data-js="favorite" data-favorite="<?php echo get_the_ID(); ?>" data-user="<?php echo get_current_user_id(); ?>"></span>
          </div>

        </div>
      </div>
    </div>
  </article>
        <?php endif; ?>
      <?php endwhile;
    endif;
    wp_reset_postdata();
    if ($pagination) :
      ?>
      <div class="pagination">
        <?php
        echo paginate_links(array(
          'base' => str_replace(999999999, '%#%', esc_url(get_pagenum_link(999999999))),
          'total' => $query->max_num_pages,
          'current' => max(1, get_query_var('page')),
          'format' => '?paged=%#%',
          'show_all' => false,
          'type' => 'plain',
          'end_size' => 2,
          'mid_size' => 1,
          'prev_next' => true,
          'prev_text' => sprintf('<i></i> %1$s', __('قبلی', 'kelaketfilm')),
          'next_text' => sprintf('%1$s <i></i>', __('بعدی', 'kelaketfilm')),
          'add_args' => false,
          'add_fragment' => '',
        )); ?>
      </div>
<?php endif;
  }
}
