<?php
if (!defined('ABSPATH')) {
  exit; // Exit if accessed directly.
}

/**
 * Elementor oEmbed Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class List_Element extends \Elementor\Widget_Base
{

  /**
   * Get widget name.
   *
   * Retrieve oEmbed widget name.
   *
   * @since 1.0.0
   * @access public
   * @return string Widget name.
   */
  public function get_name()
  {
    return 'list';
  }

  /**
   * Get widget title.
   *
   * Retrieve oEmbed widget title.
   *
   * @since 1.0.0
   * @access public
   * @return string Widget title.
   */
  public function get_title()
  {
    return esc_html__('المان لیست فهرست', 'elementor-ads-widget');
  }

  /**
   * Get widget icon.
   *
   * Retrieve oEmbed widget icon.
   *
   * @since 1.0.0
   * @access public
   * @return string Widget icon.
   */
  public function get_icon()
  {
    return 'eicon-menu-bar';
  }

  /**
   * Get custom help URL.
   *
   * Retrieve a URL where the user can get more information about the widget.
   *
   * @since 1.0.0
   * @access public
   * @return string Widget help URL.
   */
  public function get_custom_help_url()
  {
    return 'https://developers.elementor.com/docs/widgets/';
  }

  /**
   * Get widget categories.
   *
   * Retrieve the list of categories the oEmbed widget belongs to.
   *
   * @since 1.0.0
   * @access public
   * @return array Widget categories.
   */
  public function get_categories()
  {
    return ['header'];
  }

  /**
   * Get widget keywords.
   *
   * Retrieve the list of keywords the oEmbed widget belongs to.
   *
   * @since 1.0.0
   * @access public
   * @return array Widget keywords.
   */
  public function get_keywords()
  {
    return ['footer', 'list'];
  }

  /**
   * Register oEmbed widget controls.
   *
   * Add input fields to allow the user to customize the widget settings.
   *
   * @since 1.0.0
   * @access protected
   */
  protected function register_controls()
  {

    $this->start_controls_section(
      'content_section',
      [
        'label' => esc_html__('تنظیمات', 'elementor-ads-widget'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'title',
      [
        'label' => esc_html__('عنوان ویجت', 'elementor-oembed-widget'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => esc_html__('مثلا: دسترسی سریع', 'elementor-oembed-widget'),
      ]
    );

    $this->add_control(
      'menu',
      [
        'label' => esc_html__('انتخاب منو', 'plugin-name'),
        'type' => \Elementor\Controls_Manager::SELECT2,
        'multiple' => false,
        'options' => ['foot-menu-2' => 'فهرست فوتر ۲', 'foot-menu-1' => 'فهرست فوتر ۱', 'header' => 'منوی هدر'],
        'default' => [],
      ]
    );


    $this->end_controls_section();
  }

  /**
   * Render oEmbed widget output on the frontend.
   *
   * Written in PHP and used to generate the final HTML.
   *
   * @since 1.0.0
   * @access protected
   */
  protected function render()
  {
    $settings = $this->get_settings_for_display();
    $config = get_option('my_framework');
    $title = $settings['title'];
    $menu = $settings['menu'];
    // $social = $settings['social'];
?>
    <div class="links">
      <h3><i class="bi bi-gear"></i><?= $title; ?></h3>
      <?php wp_nav_menu(array('theme_location' => $menu, 'container' => '', 'menu_class' => 'menunav')); ?>
    </div>
<?php
  }
}
