<?php
if (!defined('ABSPATH')) {
  exit; // Exit if accessed directly.
}

/**
 * Elementor oEmbed Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class Slider_widget extends \Elementor\Widget_Base
{

  /**
   * Get widget name.
   *
   * Retrieve oEmbed widget name.
   *
   * @since 1.0.0
   * @access public
   * @return string Widget name.
   */
  public function get_name()
  {
    return 'slider';
  }

  /**
   * Get widget title.
   *
   * Retrieve oEmbed widget title.
   *
   * @since 1.0.0
   * @access public
   * @return string Widget title.
   */
  public function get_title()
  {
    return esc_html__('ویجت اسلایدر', 'elementor-ads-widget');
  }

  /**
   * Get widget icon.
   *
   * Retrieve oEmbed widget icon.
   *
   * @since 1.0.0
   * @access public
   * @return string Widget icon.
   */
  public function get_icon()
  {
    return 'eicon-slider-3d';
  }

  /**
   * Get custom help URL.
   *
   * Retrieve a URL where the user can get more information about the widget.
   *
   * @since 1.0.0
   * @access public
   * @return string Widget help URL.
   */
  public function get_custom_help_url()
  {
    return 'https://developers.elementor.com/docs/widgets/';
  }

  /**
   * Get widget categories.
   *
   * Retrieve the list of categories the oEmbed widget belongs to.
   *
   * @since 1.0.0
   * @access public
   * @return array Widget categories.
   */
  public function get_categories()
  {
    return ['basic'];
  }

  /**
   * Get widget keywords.
   *
   * Retrieve the list of keywords the oEmbed widget belongs to.
   *
   * @since 1.0.0
   * @access public
   * @return array Widget keywords.
   */
  public function get_keywords()
  {
    return ['post', 'slider', 'index'];
  }

  /**
   * Register oEmbed widget controls.
   *
   * Add input fields to allow the user to customize the widget settings.
   *
   * @since 1.0.0
   * @access protected
   */
  protected function register_controls()
  {

    $this->start_controls_section(
      'content_section',
      [
        'label' => esc_html__('تنظیمات', 'elementor-ads-widget'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );


    // $this->add_control(
    //   'title',
    //   [
    //     'label' => esc_html__('عنوان ویجت', 'elementor-oembed-widget'),
    //     'type' => \Elementor\Controls_Manager::TEXT,
    //     'placeholder' => esc_html__('مثلا آخرین مطالب', 'elementor-oembed-widget'),
    //     'default' => 'آخرین مطالب'
    //   ]
    // );

    $this->add_control(
      'style',
      [
        'label' => esc_html__('استایل نمایش', 'plugin-name'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'multiple' => false,
        'options' => ['grid' => 'گرید', 'carousel' => 'کروسل', 'full' => 'تمام صفحه'],
        'default' => 'grid',
      ]
    );

    // $this->add_control(
    //   'category',
    //   [
    //     'label' => esc_html__('انتخاب دسته بندی', 'plugin-name'),
    //     'type' => \Elementor\Controls_Manager::SELECT2,
    //     'multiple' => false,
    //     'description' => 'در صورت انتخاب دسته مطالب دسته و درصورت انتخاب نکردن آخرین مطالب نشان داده می‌شوند.',
    //     'options' => $options,
    //     'default' => [],
    //   ]
    // );

    $this->add_control(
      'number_posts',
      [
        'label' => esc_html__('تعداد مطالب برای نمایش', 'elementor-oembed-widget'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => esc_html__('مثلا ۱۰', 'elementor-oembed-widget'),
      ]
    );

    // $this->add_control(
    //   'pagination',
    //   [
    //     'label' => esc_html__('فعال بودن صفحه بندی', 'plugin-name'),
    //     'type' => \Elementor\Controls_Manager::SWITCHER,
    //     'label_on' => esc_html__('بله', 'your-plugin'),
    //     'label_off' => esc_html__('خیر', 'your-plugin'),
    //     'return_value' => true,
    //     'default' => true,
    //   ]
    // );


    $this->end_controls_section();
  }

  /**
   * Render oEmbed widget output on the frontend.
   *
   * Written in PHP and used to generate the final HTML.
   *
   * @since 1.0.0
   * @access protected
   */
  protected function render()
  {
    $settings = $this->get_settings_for_display();
    $number_posts = $settings['number_posts'];
    $style = $settings['style'];
?>
    <?php if ($style == 'grid') : ?>
      <!-- grid slider -->
      <section class="featured2">
        <div class="container">
          <div class="row g-3">
            <?php
            $args = array(
              'showposts' => 8,
              'meta_key'    => 'slider',
              'meta_value'  => true
            );
            $the_query = new WP_Query($args);
            while ($the_query->have_posts()) : $the_query->the_post(); ?>
              <div class="col-xxl-3 col-xl-3 col-lg-4 col-md-6 col-sm-6 col-4">
                <a href="<?php the_permalink() ?>">
                  <div class="featured_item2">
                    <?php
                    if (get_field('slider_image')) { ?>
                      <img width="312" height="200" alt="<?php the_title(); ?>" src="<?php the_field('slider_image') ?>" alt="<?php the_title(); ?>">
                    <?php } else {
                      the_post_thumbnail();
                    } ?>
                    <div class="featured_item2_hover">
                      <div class="featured_item_likes">
                        <i class="bi bi-heart-fill"></i>
                        <?php
                        if (get_field('rotten')) {
                          the_field('rotten');
                        } else {
                          echo '۰';
                        }
                        ?>%
                        <?php if (get_field('imdbRating')) : ?>
                          <span class="featured_item_imdb">
                            IMDb
                            <?php the_field('imdbRating') ?>
                          </span>
                        <?php endif; ?>
                      </div>
                      <h2><?php the_title(); ?></h2>
                      <div class="description"><?php the_field('last-episode'); ?></div>
                      <?php
                      $badge_color = 'bg-success';
                      if (get_field('slider-badge-color')) {
                        if (get_field('slider-badge-color') == 'red') {
                          $badge_color = 'bg-danger';
                        } elseif (get_field('slider-badge-color') == 'green') {
                          $badge_color = 'bg-success';
                        } elseif (get_field('slider-badge-color') == 'yellow') {
                          $badge_color = 'bg-warning text-dark';
                        } elseif (get_field('slider-badge-color') == 'blue') {
                          $badge_color = 'bg-info text-dark';
                        }
                      }
                      ?>
                      <div class="badge <?php echo $badge_color; ?>"><?php the_field('slider-badge'); ?></div>
                    </div>
                  </div>
                </a>
              </div>
            <?php endwhile; ?>
            <?php wp_reset_query(); ?>
          </div>
        </div>
      </section>
    <?php elseif ($style == 'carousel') : ?>
      <!-- carousel slider -->
      <section class="featured">
        <div class="container">
          <div id="owl-carousel" class="owl-carousel">
            <?php
            $args = array(
              'showposts' => 8,
              'meta_key'    => 'slider',
              'meta_value'  => true
            );
            $the_query = new WP_Query($args);
            while ($the_query->have_posts()) : $the_query->the_post(); ?>
              <a href="<?php the_permalink() ?>">
                <div class="featured_item">
                  <?php the_post_thumbnail('sliderr-thumb'); ?>
                  <div class="featured_item_hover">
                    <div class="featured_item_likes">
                      <i class="bi bi-heart-fill"></i>
                      <?php
                      if (get_field('rotten')) {
                        the_field('rotten');
                      } else {
                        echo '۰';
                      }
                      ?>%
                      <?php if (get_field('imdbRating')) : ?>
                        <span class="featured_item_imdb">
                          IMDb
                          <?php the_field('imdbRating') ?>
                        </span>
                      <?php endif; ?>
                    </div>
                    <h2><?php the_title(); ?></h2>
                    <div class="description"><?php the_field('last-episode'); ?></div>
                    <?php
                    $badge_color = 'bg-success';
                    if (get_field('slider-badge-color')) {
                      if (get_field('slider-badge-color') == 'red') {
                        $badge_color = 'bg-danger';
                      } elseif (get_field('slider-badge-color') == 'green') {
                        $badge_color = 'bg-success';
                      } elseif (get_field('slider-badge-color') == 'yellow') {
                        $badge_color = 'bg-warning text-dark';
                      } elseif (get_field('slider-badge-color') == 'blue') {
                        $badge_color = 'bg-info text-dark';
                      }
                    }
                    ?>
                    <div class="badge <?php echo $badge_color; ?>"><?php the_field('slider-badge'); ?></div>
                    <p><?php the_field('about'); ?></p>
                  </div>
                </div>
              </a>
            <?php endwhile; ?>
            <?php wp_reset_query(); ?>
          </div>
        </div>
      </section>
    <?php elseif ($style == 'full') : ?>
      <!-- full slider -->
      <section class="slider">
        <div id="owl-slider" class="owl-carousel">
          <?php
          $args = array(
            'showposts' => 5,
            'meta_key'    => 'slider',
            'meta_value'  => true
          );
          $the_query = new WP_Query($args);
          while ($the_query->have_posts()) : $the_query->the_post(); ?>
            <?php
            $video = get_field('slider_video');
            $has_video = $video ? 'video' : '';
            ?>
            <div class="slider_item <?php echo $has_video ?>">
              <?php
              if (get_field('slider_video')) : ?>
                <video>
                  <source type="video/mp4" src="<?php the_field('slider_video') ?>">
                </video>
              <?php else : ?>
                <img class="" src="<?php the_field('slider_image') ?>" alt="<?php the_title(); ?>">
              <?php endif; ?>
              <div class="slider_info">
                <?php if (get_field('film_logo')) : ?>
                  <img class="film_logo" src="<?php the_field('film_logo') ?>" alt="<?php the_title(); ?>">
                <?php else : ?>
                  <h2><?php the_title(); ?></h2>
                <?php endif; ?>
                <div class="description"><?php the_field('last-episode'); ?></div>
                <p><?php the_field('story'); ?></p>

                <?php if (get_field('slider_button')) : ?>
                  <a class="slider_link" href="<?php the_permalink(); ?>"><?php the_field('slider_button'); ?></a>
                <?php else : ?>
                  <a class="slider_link" href="<?php the_permalink(); ?>"> <?php _e('مشاهده فیلم', 'kelaketfilm') ?></a>
                <?php endif; ?>
              </div>
            </div>
          <?php endwhile; ?>
          <?php wp_reset_query(); ?>
        </div>
      </section>
    <?php endif; ?>
<?php
  }
}
