<?php
if (!defined('ABSPATH')) {
  exit; // Exit if accessed directly.
}

/**
 * Elementor oEmbed Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class WeeklySeries_widget extends \Elementor\Widget_Base
{

  /**
   * Get widget name.
   *
   * Retrieve oEmbed widget name.
   *
   * @since 1.0.0
   * @access public
   * @return string Widget name.
   */
  public function get_name()
  {
    return 'weeklySeries';
  }

  /**
   * Get widget title.
   *
   * Retrieve oEmbed widget title.
   *
   * @since 1.0.0
   * @access public
   * @return string Widget title.
   */
  public function get_title()
  {
    return esc_html__('ویجت جدول پخش', 'elementor-ads-widget');
  }

  /**
   * Get widget icon.
   *
   * Retrieve oEmbed widget icon.
   *
   * @since 1.0.0
   * @access public
   * @return string Widget icon.
   */
  public function get_icon()
  {
    return 'eicon-barcode';
  }

  /**
   * Get custom help URL.
   *
   * Retrieve a URL where the user can get more information about the widget.
   *
   * @since 1.0.0
   * @access public
   * @return string Widget help URL.
   */
  public function get_custom_help_url()
  {
    return 'https://developers.elementor.com/docs/widgets/';
  }

  /**
   * Get widget categories.
   *
   * Retrieve the list of categories the oEmbed widget belongs to.
   *
   * @since 1.0.0
   * @access public
   * @return array Widget categories.
   */
  public function get_categories()
  {
    return ['basic'];
  }

  /**
   * Get widget keywords.
   *
   * Retrieve the list of keywords the oEmbed widget belongs to.
   *
   * @since 1.0.0
   * @access public
   * @return array Widget keywords.
   */
  public function get_keywords()
  {
    return ['boxoffice', 'latestpost', 'index'];
  }

  /**
   * Register oEmbed widget controls.
   *
   * Add input fields to allow the user to customize the widget settings.
   *
   * @since 1.0.0
   * @access protected
   */
  protected function register_controls()
  {

    $this->start_controls_section(
      'content_section',
      [
        'label' => esc_html__('تنظیمات جدول پخش', 'elementor-ads-widget'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->end_controls_section();
  }

  /**
   * Render oEmbed widget output on the frontend.
   *
   * Written in PHP and used to generate the final HTML.
   *
   * @since 1.0.0
   * @access protected
   */
  protected function render()
  {
    $settings = $this->get_settings_for_display();
?>
<section class="series_week">
  <header class="series_week__header">
    <h3><i class="bi bi-film"></i> جدول پخش هفتگی</h3>
    <?php $todayEn = date('D'); ?>
    <ul>
      <li data-day="Sat" class="<?= $todayEn == 'Sat' ? 'active' : ''; ?>"><span>شنبه</span></li>
      <li data-day="Sun" class="<?= $todayEn == 'Sun' ? 'active' : ''; ?>"><span>یک‌شنبه</span></li>
      <li data-day="Mon" class="<?= $todayEn == 'Mon' ? 'active' : ''; ?>"><span>دوشنبه</span></li>
      <li data-day="Tue" class="<?= $todayEn == 'Tue' ? 'active' : ''; ?>"><span>سه‌‌شنبه</span></li>
      <li data-day="Wed" class="<?= $todayEn == 'Wed' ? 'active' : ''; ?>"><span>چهارشنبه</span></li>
      <li data-day="Thu" class="<?= $todayEn == 'Thu' ? 'active' : ''; ?>"><span>پنج‌شنبه</span></li>
      <li data-day="Fri" class="<?= $todayEn == 'Fri' ? 'active' : ''; ?>"><span>جمعه</span></li>
    </ul>
  </header>
  <div class="series_inner">
    <div class="row g-2">
      <?php
      $data = @theme_options('series_tabbed')[$todayEn];
      if ($data) :
        foreach ($data as $item) :
      ?>
          <div class="col-lg-4 col-md-6 col-sm-6">
            <div class="series_item">
              <a class="d-flex" href="<?php the_permalink($item); ?>">
                <img src="<?php echo get_the_post_thumbnail_url($item, 'thumbnail'); ?>" alt="">
                <div class="d-flex flex-column justify-content-between">
                  <div class="name"><?= get_the_title($item); ?></div>
                  <div class="update"><?php the_field('update_info', $item); ?></div>
                </div>
              </a>
            </div>
          </div>
        <?php endforeach;
      else : ?><span class="not_found">در این روز سریالی پخش نمی‌شود.</span><?php endif; ?>
    </div>
  </div>
</section>
<?php
  }
}
