<?php

// box office auto widget
CSF::createWidget('csf_widget_box_office_auto', array(
  'title'       => ' ویجت  باکس آفیس ',
  'classname'   => 'csf-widget-classname',
  'description' => 'ویجت اختصاصی کلاکت فیلم برای نمایش باکس آفیس اتوماتیک',
  'fields'      => array(

    array(
      'id'      => 'title',
      'type'    => 'text',
      'title'   => 'عنوان ویجت',
    ),
    array(
      'id'      => 'icon',
      'type'    => 'text',
      'subtitle' => 'از FontAwesome استفاده شود',
      'placeholder' => 'مثلا: film',
      'title'   => 'آیکون ویجت',
    ),
    array(
      'id'          => 'film_cat_',
      'type'        => 'select',
      'title'       => 'انتخاب برگه باکس آفیس',
      'placeholder' => 'برگه باکس آفیس را انتخاب کنید',
      'chosen'      => true,
      'ajax'        => true,
      'multiple'    => false,
      // 'sortable'    => true,
      'options'     => 'pages',
    ),
  )
));

// box office auto widget
if (!function_exists('csf_widget_box_office_auto')) {
  function csf_widget_box_office_auto($args, $instance)
  { 
    $api_token = get_option('my_framework')['imdb-api-token'];
    ?>
    <aside class="widget widget-bg col-lg-12">
      <div class="widget_title">
        <h3><i class="<?= $instance['icon'] ?>"></i> <?= $instance['title'] ?></h3>
      </div>
      <div class="widget_inner">
      <?php 
        $transient = get_transient('weekend_boxOffice');
        if(!empty($transient)){
          $data = $transient;
        }else{
          $api_url = "https://imdb-api.com/en/API/BoxOffice/$api_token";
          $request = wp_remote_get($api_url);
          if (is_wp_error($request)) {
            kelaket_log('box_office_widget', $request->get_error_message());
            echo '<div class="rcp_error">مشکلی در دریافت اطلاعات پیش آمد - کلید api imdb-api.com را از پنل تنظیمات چک کنید در صورتی که مشکل پایدار بود با پشتیبانی در تماس باشید.</div>';
          }
          $data = json_decode(wp_remote_retrieve_body($request));
          set_transient( 'weekend_boxOffice', $data, DAY_IN_SECONDS );
        }
        if($data) : foreach($data->items as $item):
          $poster_image = preg_replace('/_V1[\s\S]+?_AL_/', 'UX500', $item->image);
          if( $item->rank == 6 ) {
            break;
          }
        ?>
        <div class="sidebarBoxOffice <?php echo $item->rank == 5 ? 'no-border' : '' ?>">
        <div class="sidebarBoxOffice__right">
          <div class="boxOffice__film">
            <a href="<?php bloginfo('url') ?>?imdb_id=<?php echo $item->id ?>">
            <div class="position-relative">
              <img src="<?php echo $poster_image ?>" alt="">
              <span class="boxOffice__film__rank"><?php echo $item->rank ?></span>
            </div>
            </a>
            <div class="boxOffice__meta">
              <a class="film_name" href="<?php bloginfo('url') ?>?imdb_id=<?php echo $item->id ?>">
                <h3><?php echo $item->title ?></h3>
              </a>
              <div>
              <?php echo $item->weeks . __(' هفته اکران ', 'kelaketfilm') ?> 
              </div>
              <div>
              <?php echo __(' فروش آخر هفته :', 'kelaketfilm') . $item->weekend  ?> 
              </div>
              <div>
              <?php echo __(' فروش کل :', 'kelaketfilm') . $item->gross  ?> 
              </div>
            </div>
          </div>
        </div>
      </div>
        <?php endforeach; endif;
      ?>
        <div class="text-center">
          <a href="<?php bloginfo('url') ?>/<?= $instance['film_cat_'] ?>" class="boxOfficeMore"> <?php _e('مشاهده کامل باکس آفیس', 'kelaketfilm'); ?> <i class="fa-solid fa-chevron-down"></i></a>
        </div>
      </div>
    </aside>
  <?php
  }
}