<?php 
// category post carousel widget
CSF::createWidget('csf_widget_carousel', array(
  'title'       => ' ویجت کروسل مطالب دسته',
  'classname'   => 'csf-widget-classname',
  'description' => 'ویجت اختصاصی کلاکت فیلم برای نمایش کروسل مطالب دسته',
  'fields'      => array(

    array(
      'id'      => 'title',
      'type'    => 'text',
      'title'   => 'عنوان ویجت',
    ),
    array(
      'id'      => 'icon',
      'type'    => 'text',
      'subtitle' => 'از FontAwesome استفاده شود',
      'placeholder' => 'مثلا: film',
      'title'   => 'آیکون ویجت',
    ),
    array(
      'id'      => 'count',
      'type'    => 'text',
      'title'   => 'تعداد مطالب',
    ),
    array(
      'id'      => 'archive',
      'type'    => 'switcher',
      'title' => 'نمایش دکمه آرشیو',
      'text_on'  => 'فعال',
      'text_off' => 'غیرفعال',
      'text_width' => 75,
      'default' => false
    ),
    array(
      'id'          => 'film_cat',
      'type'        => 'select',
      'title'       => 'انتخاب دسته بندی',
      'placeholder' => 'دسته بندی را انتخاب کنید',
      'chosen'      => true,
      'ajax'        => false,
      'multiple'    => false,
      'sortable'    => true,
      'options'     => 'categories',
    ),
  )
));

// category carousel widget
if (!function_exists('csf_widget_carousel')) {
  function csf_widget_carousel($args, $instance)
  { ?>
    <aside class="widget widget-bg col-lg-12">
      <div class="widget_title">
        <h3><i class="<?= $instance['icon'] ?>"></i> <?= $instance['title'] ?></h3>
        <?php if ($instance['archive']) : ?>
          <a href="<?php echo get_category_link($instance['film_cat']); ?>" class="nav-link active carousel_archive"><?php _e('آرشیو', 'kelaketfilm'); ?></a>
        <?php endif; ?>
      </div>
      <div class="widget_inner">
        <div class="owl-carousel sidebar_carousel">
          <?php
          $query = new WP_Query(array(
            'post_type' => 'post',
            'posts_per_page' => $instance['count'],
            'cat' => $instance['film_cat'],
          ));
          if ($query->have_posts()) :
            while ($query->have_posts()) : $query->the_post(); ?>
              <a href="<?php the_permalink(); ?>">
                <div class="item2">
                  <?php the_post_thumbnail('sidebar-thumb'); ?>
                  <div class="item2__mask">
                    <?php the_title(); ?>
                  </div>
                </div>
              </a>
            <?php endwhile; ?>
            <?php wp_reset_postdata(); ?>
          <?php endif; ?>


        </div>
      </div>
    </aside>
  <?php
  }
}