<?php
// top 250 imdb films widget
CSF::createWidget('csf_widget_250top_films_imdb', array(
  'title'       => ' ۲۵۰ فیلم برتر IMDB',
  'classname'   => 'csf-widget-classname',
  'description' => 'ویجت اختصاصی کلاکت فیلم برای ۲۵۰ فیلم برتر IMDB',
  'fields'      => array(

    array(
      'id'      => 'title',
      'type'    => 'text',
      'title'   => 'عنوان ویجت',
    ),
    array(
      'id'      => 'count',
      'type'    => 'text',
      'title'   => 'تعداد مطالب',
    ),
  )
));

// top 250 films imdb widget
if (!function_exists('csf_widget_250top_films_imdb')) {
  function csf_widget_250top_films_imdb($args, $instance)
  { ?>
    <aside class="widget col-lg-12">
      <div class="widget_title">
        <h3><i class="fa fa-clapperboard-play"></i> <?= $instance['title'] ?></h3>
          <a href="<?php bloginfo('url') ?>/imdb-top-250"><span> <?php _e('مشاهده همه', 'kelaketfilm'); ?></span></a>
      </div>
      <div class="clearfix"></div>
      <div class="widget_inner">
        <?php
        $query = new WP_Query(array(
          'post_type' => 'post',
          'meta_query' => array(
            array(
              'key'     => 'top-250-imdb',
              'value'   => true,
              'compare' => '=',
            ),
          ),
          'meta_key' => 'imdb_rank',
          'posts_per_page' => $instance['count'],
          'orderby' => 'meta_value_num',
          'order'   => 'ASC',

        ));
        if ($query->have_posts()) :
          while ($query->have_posts()) : $query->the_post(); ?>
            <div class="update">
              <a href="<?php the_permalink(); ?>">
                <?php if (get_field('serial-jadval')) : ?>
                  <img src="<?php the_field('serial-jadval') ?>" alt="<?php the_title(); ?>" />
                <?php else : ?>
                  <?php the_post_thumbnail('post-thumb'); ?>
                <?php endif; ?>
                <div class="update_info">
                  <div class="txt_flow"><?php the_title(); ?></div>
                  <?php if (get_field('imdb_rank')) : ?><span class="info_rank"><?php _e('رتبه', 'kelaketfilm'); ?> <?php the_field('imdb_rank'); ?></span><?php endif; ?>
                </div>
              </a>
            </div>
          <?php endwhile; ?>
          <?php wp_reset_postdata(); ?>
        <?php endif; ?>
      </div>
    </aside>
  <?php
  }
}