<?php
// post's slider widget
CSF::createWidget('csf_widget_post_slider', array(
  'title'       => ' ویجت اسلایدر مطالب',
  'classname'   => 'csf-widget-classname',
  'description' => 'ویجت اختصاصی کلاکت فیلم برای نمایش اسلایدر مطالب',
  'fields'      => array(

    array(
      'id'      => 'title',
      'type'    => 'text',
      'title'   => 'عنوان ویجت',
    ),
    array(
      'id'      => 'icon',
      'type'    => 'text',
      'subtitle' => 'از FontAwesome استفاده شود',
      'placeholder' => 'مثلا: film',
      'title'   => 'آیکون ویجت',
    ),
    array(
      'id'      => 'count',
      'type'    => 'text',
      'title'   => 'تعداد مطالب',
    ),
    array(
      'id'      => 'archive',
      'type'    => 'switcher',
      'title' => 'نمایش دکمه آرشیو',
      'text_on'  => 'فعال',
      'text_off' => 'غیرفعال',
      'text_width' => 75,
      'default' => false
    ),
    array(
      'id'          => 'film_cat',
      'type'        => 'select',
      'title'       => 'انتخاب دسته بندی',
      'placeholder' => 'دسته بندی را انتخاب کنید',
      'chosen'      => true,
      'ajax'        => false,
      'multiple'    => false,
      'sortable'    => true,
      'options'     => 'categories',
    ),
  )
));

// post's slider widget
if (!function_exists('csf_widget_post_slider')) {
  function csf_widget_post_slider($args, $instance)
  { ?>
    <aside class="widget widget-bg col-lg-12">
      <div class="widget_title">
        <h3><i class="<?= $instance['icon'] ?>"></i> <?= $instance['title'] ?></h3>
        <?php if ($instance['archive']) : ?>
          <a href="<?php echo get_category_link($instance['film_cat']); ?>" class="nav-link active carousel_archive"><?php _e('آرشیو', 'kelaketfilm'); ?></a>
        <?php endif; ?>
      </div>
      <div class="widget_inner">
        <div class="owl-carousel sidebar_carousel2">
          <?php
          $query = new WP_Query(array(
            'post_type' => 'post',
            'posts_per_page' => $instance['count'],
            'cat' => $instance['film_cat'],
          ));
          if ($query->have_posts()) :
            while ($query->have_posts()) : $query->the_post(); ?>
              <a href="<?php the_permalink(); ?>">
                <div class="item2">
                  <?php the_post_thumbnail('sidebar-thumb'); ?>
                  <div class="item2__mask">
                    <?php the_title(); ?>
                  </div>
                </div>
              </a>
            <?php endwhile; ?>
            <?php wp_reset_postdata(); ?>
          <?php endif; ?>


        </div>
      </div>
    </aside>
  <?php
  }
}