<?php
// countdown widget
CSF::createWidget('csf_widget_countdown', array(
  'title'       => ' ویجت لحظه شمار انتشار فیلم و سریال',
  'classname'   => 'csf-widget-classname',
  'description' => 'ویجت اختصاصی کلاکت فیلم برای نمایش لحظه شمار انتشار فیلم و سریال',
  'fields'      => array(

    array(
      'id'      => 'title',
      'type'    => 'text',
      'title'   => 'عنوان ویجت',
    ),
    array(
      'id'      => 'icon',
      'type'    => 'text',
      'subtitle' => 'از FontAwesome استفاده شود',
      'placeholder' => 'مثلا: film',
      'title'   => 'آیکون ویجت',
    ),
    array(
      'id'          => 'count_cat',
      'type'        => 'select',
      'title'       => 'انتخاب دسته بندی',
      'placeholder' => 'دسته بندی مطالب بزودی را انتخاب کنید.',
      'chosen'      => true,
      'ajax'        => false,
      'multiple'    => false,
      'sortable'    => true,
      'options'     => 'categories',
    ),
  )
));

// countdown widget
if (!function_exists('csf_widget_countdown')) {
  function csf_widget_countdown($args, $instance)
  { ?>
    <aside class="widget col-lg-12">
      <div class="widget_title">
        <h3><i class="<?= $instance['icon'] ?>"></i> <?= $instance['title'] ?></h3>
      </div>
      <div class="clearfix"></div>

      <div style="padding: 10px" class="widget_inner widget-bg">
        <!-- start countdown -->
        <div class="owl-carousel count_carousel">

          <?php
          $query = new WP_Query(array(
            'post_type' => 'post',
            'cat' => $instance['count_cat'],
          ));
          if ($query->have_posts()) :
            while ($query->have_posts()) : $query->the_post(); ?>
              <div class="count_row" style="color: #fff">
                <div class="update">
                  <a href="<?php the_permalink(); ?>">
                    <h4><?php the_title(); ?></h4>
                    <?php if (get_field('serial-jadval')) : ?>
                      <img src="<?php the_field('serial-jadval') ?>" alt="<?php the_title(); ?>" />
                    <?php else : ?>
                      <?php the_post_thumbnail('post-thumb'); ?>
                    <?php endif; ?>
                  </a>
                </div>
                <?php if (get_field('rel_date')) : ?>
                  <div class="countdown show" data-Date='<?= get_field('rel_date'); ?>'>
                    <div class="running">
                      <div class="timer">
                        <div>
                          <span class="days"></span>
                          <div class="counter_label"><?php _e('روز', 'kelaketfilm'); ?></div>
                        </div>
                        <div>
                          <span class="hours"></span>
                          <div class="counter_label"><?php _e('ساعت', 'kelaketfilm'); ?></div>
                        </div>
                        <div>
                          <span class="minutes"></span>
                          <div class="counter_label"><?php _e('دقیقه', 'kelaketfilm'); ?></div>
                        </div>
                        <div>
                          <span class="seconds"></span>
                          <div class="counter_label"><?php _e('ثانیه', 'kelaketfilm'); ?></div>
                        </div>
                      </div>
                    </div>
                  </div>
                <?php endif; ?>
              </div>
            <?php endwhile; ?>
            <?php wp_reset_postdata(); ?>
          <?php endif; ?>
        </div>
        <!-- end countdown -->
      </div>
    </aside>
  <?php
  }
}