<?php
// tabed genre widget
CSF::createWidget('csf_widget_tabbed_genre', array(
  'title'       => ' تب دسته بندی ژانر',
  'classname'   => 'csf-widget-classname',
  'description' => 'ویجت اختصاصی کلاکت فیلم برای نمایش تب دسته بندی ژانر',
  'fields'      => array(

    array(
      'id'      => 'title',
      'type'    => 'text',
      'title'   => 'عنوان ویجت',
    ),
    array(
      'id'          => 'serial_cat',
      'type'        => 'select',
      'title'       => 'انتخاب دسته بندی سریال',
      'placeholder' => 'دسته بندی سریال را انتخاب کنید',
      'desc'        => 'دسته بندی مادر سریال ها را انتخاب کنید.',
      'chosen'      => true,
      'ajax'        => false,
      'multiple'    => false,
      'sortable'    => true,
      'options'     => 'categories',
    ),
    array(
      'id'          => 'film_cat',
      'type'        => 'select',
      'title'       => 'انتخاب دسته بندی فیلم',
      'placeholder' => 'دسته بندی فیلم را انتخاب کنید',
      'desc'        => 'دسته بندی مادر فیلم ها را انتخاب کنید.',
      'chosen'      => true,
      'ajax'        => false,
      'multiple'    => false,
      'sortable'    => true,
      'options'     => 'categories',
    ),

  )
));

// tabbed genre widget 
  if (!function_exists('csf_widget_tabbed_genre')) {
    function csf_widget_tabbed_genre($args, $instance)
    { ?>
      <aside class="widget widget-bg col-lg-12">
        <div class="widget_title">
          <h3><i class="fa fa-masks-theater"></i> <?= $instance['title'] ?></h3>
          <ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">
            <li class="nav-item" role="presentation">
              <button class="nav-link active" id="pills-film-tab" data-bs-toggle="pill" data-bs-target="#pills-film" type="button" role="tab" aria-selected="true"><?php _e('فیلم', 'kelaketfilm'); ?>
              </button>
            </li>
            <li class="nav-item" role="presentation">
              <button class="nav-link" id="pills-series-tab" data-bs-toggle="pill" data-bs-target="#pills-series" type="button" role="tab" aria-selected="false"><?php _e('سریال', 'kelaketfilm'); ?>
              </button>
            </li>
          </ul>
        </div>
        <div class="clearfix"></div>
        <div class="widget_inner">
          <div class="tab-content" id="pills-tabContent">
            <div class="tab-pane fade show active" id="pills-film" role="tabpanel" aria-labelledby="pills-film-tab">
              <ul class="genre">
                <?php
                $film_cat = $instance['film_cat'];

                $categories = wp_list_categories("title_li=&show_count=1&echo=0&hide_empty=0&depth=0&parent=$film_cat");
                $temp = $categories;
                $temp = str_replace("(", "<span class='count'>", $temp);
                $temp = str_replace(")", "</span>", $temp);
                echo $temp; ?>
              </ul>
            </div>
            <div class="tab-pane fade" id="pills-series" role="tabpanel" aria-labelledby="pills-series-tab">
              <ul class="genre">
                <?php
                $serial_cat = $instance['serial_cat'];
                $categories = wp_list_categories("title_li=&show_count=1&echo=0&hide_empty=0&depth=0&parent=$serial_cat");
                $temp = $categories;
                $temp = str_replace("(", "<span class='count'>", $temp);
                $temp = str_replace(")", "</span>", $temp);
                echo $temp; ?>
              </ul>
            </div>
          </div>
        </div>
      </aside>
    <?php
    }
  }